/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "mer" locale.
 */
public class LocalizedNamesImpl_mer extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "IE",
        "ZA",
        "AF",
        "CK",
        "FK",
        "KY",
        "MP",
        "MH",
        "NF",
        "SB",
        "TC",
        "VI",
        "VG",
        "IS",
        "AR",
        "AL",
        "US",
        "AD",
        "DZ",
        "AO",
        "AI",
        "AG",
        "AQ",
        "AM",
        "AW",
        "AT",
        "AU",
        "AX",
        "AZ",
        "BB",
        "BS",
        "BH",
        "BM",
        "BD",
        "BY",
        "BZ",
        "BJ",
        "BE",
        "BL",
        "BO",
        "BA",
        "BW",
        "BQ",
        "BR",
        "BN",
        "BF",
        "BG",
        "BI",
        "BT",
        "BV",
        "CY",
        "CC",
        "TD",
        "CL",
        "CN",
        "CP",
        "CW",
        "CX",
        "DK",
        "DG",
        "DM",
        "EA",
        "EH",
        "EC",
        "SV",
        "ER",
        "EE",
        "EU",
        "EZ",
        "AE",
        "FJ",
        "PH",
        "FI",
        "FO",
        "FR",
        "GA",
        "GM",
        "GG",
        "GH",
        "GN",
        "GW",
        "GQ",
        "GD",
        "GS",
        "GY",
        "GP",
        "GU",
        "GT",
        "GF",
        "HT",
        "HU",
        "HK",
        "HM",
        "NL",
        "HN",
        "IC",
        "IM",
        "IN",
        "ID",
        "IQ",
        "IR",
        "IL",
        "IT",
        "ET",
        "JM",
        "JP",
        "JE",
        "DJ",
        "GE",
        "JO",
        "NC",
        "KH",
        "CM",
        "CA",
        "QA",
        "KZ",
        "KE",
        "CV",
        "KI",
        "KG",
        "CU",
        "CI",
        "CO",
        "KM",
        "CG",
        "KP",
        "KR",
        "HR",
        "CR",
        "KW",
        "LA",
        "LV",
        "LB",
        "LS",
        "LR",
        "LY",
        "LI",
        "LT",
        "LU",
        "MK",
        "MG",
        "MW",
        "ML",
        "MY",
        "MT",
        "MQ",
        "MR",
        "MU",
        "YT",
        "ME",
        "MX",
        "MF",
        "FM",
        "EG",
        "MO",
        "MV",
        "MD",
        "MC",
        "MN",
        "MS",
        "MA",
        "MZ",
        "MM",
        "NA",
        "NR",
        "NP",
        "GB",
        "GI",
        "GR",
        "GL",
        "NE",
        "NG",
        "NI",
        "NU",
        "NZ",
        "DE",
        "NO",
        "IO",
        "CF",
        "CZ",
        "DO",
        "CD",
        "OM",
        "PK",
        "PW",
        "PA",
        "PG",
        "PY",
        "PE",
        "PN",
        "PL",
        "PF",
        "PT",
        "PR",
        "QO",
        "RU",
        "RE",
        "RO",
        "RS",
        "PS",
        "RW",
        "SM",
        "WS",
        "AS",
        "SH",
        "KN",
        "LC",
        "PM",
        "VC",
        "ST",
        "SA",
        "SN",
        "SC",
        "SL",
        "SG",
        "SY",
        "LK",
        "SJ",
        "SK",
        "SI",
        "SO",
        "ES",
        "SS",
        "SD",
        "SR",
        "SZ",
        "SE",
        "CH",
        "SX",
        "TA",
        "TW",
        "TJ",
        "TR",
        "TZ",
        "TF",
        "TH",
        "TL",
        "TG",
        "TK",
        "TO",
        "TT",
        "TM",
        "TN",
        "TV",
        "UG",
        "UA",
        "UM",
        "UN",
        "UY",
        "UZ",
        "VU",
        "VA",
        "VE",
        "VN",
        "WF",
        "XA",
        "XB",
        "XK",
        "YE",
        "ZM",
        "ZW",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("AD", "Andora");
    namesMap.put("AE", "Falme cia Kiarabu");
    namesMap.put("AF", "Afuganistani");
    namesMap.put("AG", "Antigua na Barbuda");
    namesMap.put("AL", "Alubania");
    namesMap.put("AR", "Ajentina");
    namesMap.put("AS", "Samoa ya Amerika");
    namesMap.put("AT", "Austiria");
    namesMap.put("AU", "Austrĩlia");
    namesMap.put("AZ", "Azebaijani");
    namesMap.put("BA", "Bosnia na Hezegovina");
    namesMap.put("BB", "Babadosi");
    namesMap.put("BD", "Bangiradeshi");
    namesMap.put("BE", "Beronjiamu");
    namesMap.put("BF", "Bukinafaso");
    namesMap.put("BH", "Baharini");
    namesMap.put("BJ", "Benini");
    namesMap.put("BM", "Bamuda");
    namesMap.put("BR", "Brazilu");
    namesMap.put("BS", "Bahamasi");
    namesMap.put("BT", "Butani");
    namesMap.put("BY", "Belarusi");
    namesMap.put("CA", "Kanada");
    namesMap.put("CD", "Nthĩ ya Kidemokrasĩ ya Kongo");
    namesMap.put("CF", "Nthĩ ya Afrika gatĩgatĩ");
    namesMap.put("CG", "Kongo");
    namesMap.put("CH", "Swizilandi");
    namesMap.put("CI", "Kodivaa");
    namesMap.put("CK", "Aĩrandi cia Cook");
    namesMap.put("CM", "Kameruni");
    namesMap.put("CO", "Kolombia");
    namesMap.put("CR", "Kostarika");
    namesMap.put("CU", "Kiuba");
    namesMap.put("CV", "Kepuvede");
    namesMap.put("CY", "Caipurasi");
    namesMap.put("CZ", "Nthĩ ya Cheki");
    namesMap.put("DE", "Njamanĩ");
    namesMap.put("DJ", "Jibuti");
    namesMap.put("DK", "Denimaki");
    namesMap.put("DM", "Dominika");
    namesMap.put("DO", "Nthĩ ya Dominika");
    namesMap.put("DZ", "Angiria");
    namesMap.put("EC", "Ekwado");
    namesMap.put("EG", "Misiri");
    namesMap.put("ES", "Spĩni");
    namesMap.put("ET", "Ithiopia");
    namesMap.put("FI", "Finilandi");
    namesMap.put("FK", "Aĩrandi cia Falklandi");
    namesMap.put("FM", "Mikronesia");
    namesMap.put("FR", "Fransi");
    namesMap.put("GA", "Gaboni");
    namesMap.put("GB", "Ngeretha");
    namesMap.put("GE", "Jojia");
    namesMap.put("GF", "Gwiyana ya Fransi");
    namesMap.put("GI", "Ngĩbrata");
    namesMap.put("GL", "Ngirinilandi");
    namesMap.put("GN", "Gine");
    namesMap.put("GP", "Gwadelupe");
    namesMap.put("GQ", "Gine ya Iquita");
    namesMap.put("GR", "Ngiriki");
    namesMap.put("GT", "Gwatemala");
    namesMap.put("GU", "Gwam");
    namesMap.put("GW", "Ginebisau");
    namesMap.put("HN", "Hondurasi");
    namesMap.put("HR", "Koroashia");
    namesMap.put("HU", "Hangarĩ");
    namesMap.put("IE", "Aelandi");
    namesMap.put("IL", "Isiraeli");
    namesMap.put("IO", "Nthĩ cia Ngeretha gatagatĩ ka ĩria ria Hindi");
    namesMap.put("IQ", "Iraki");
    namesMap.put("IR", "Irani");
    namesMap.put("IS", "Aisilandi");
    namesMap.put("IT", "Italĩ");
    namesMap.put("JM", "Jamaika");
    namesMap.put("JO", "Jorondani");
    namesMap.put("JP", "Japani");
    namesMap.put("KG", "Kirigizistani");
    namesMap.put("KH", "Kambodia");
    namesMap.put("KM", "Komoro");
    namesMap.put("KN", "Santakitzi na Nevis");
    namesMap.put("KP", "Korea Nothi");
    namesMap.put("KR", "Korea Saũthi");
    namesMap.put("KW", "Kuwĩ ti");
    namesMap.put("KY", "Aĩrandi cia Kayman");
    namesMap.put("KZ", "Kazakistani");
    namesMap.put("LA", "Laosi");
    namesMap.put("LB", "Lebanoni");
    namesMap.put("LC", "Santalusia");
    namesMap.put("LI", "Lishenteni");
    namesMap.put("LK", "Sirilanka");
    namesMap.put("LU", "Luxembogu");
    namesMap.put("LV", "Lativia");
    namesMap.put("LY", "Lĩbia");
    namesMap.put("MA", "Moroko");
    namesMap.put("MC", "Monako");
    namesMap.put("MG", "Madagasika");
    namesMap.put("MH", "Aĩrandi cia Marshal");
    namesMap.put("MM", "Myanima");
    namesMap.put("MP", "Aĩrandi cia Mariana ya nothi");
    namesMap.put("MQ", "Martiniki");
    namesMap.put("MS", "Montserrati");
    namesMap.put("MU", "Maurĩtiasi");
    namesMap.put("MV", "Modivu");
    namesMap.put("MX", "Mexiko");
    namesMap.put("MY", "Malĩsia");
    namesMap.put("MZ", "Mozambiki");
    namesMap.put("NC", "Kalendoia Ĩnjeru");
    namesMap.put("NE", "Nija");
    namesMap.put("NF", "Aĩrandi cia Norfok");
    namesMap.put("NG", "Nijeria");
    namesMap.put("NI", "Nikaragwa");
    namesMap.put("NL", "Holandi");
    namesMap.put("NO", "Norwi");
    namesMap.put("NP", "Nepali");
    namesMap.put("NZ", "Niuzilandi");
    namesMap.put("OM", "Omani");
    namesMap.put("PF", "Polinesia ya Fransi");
    namesMap.put("PG", "Papua");
    namesMap.put("PH", "Filipino");
    namesMap.put("PK", "Pakistani");
    namesMap.put("PL", "Polandi");
    namesMap.put("PM", "Santapieri na Mikeloni");
    namesMap.put("PN", "Pitkairni");
    namesMap.put("PR", "Pwetoriko");
    namesMap.put("PS", "Rũtere rwa Westi banki na Gaza cia Palestina");
    namesMap.put("PT", "Potogo");
    namesMap.put("PY", "Paragwai");
    namesMap.put("QA", "Kata");
    namesMap.put("RE", "Riyunioni");
    namesMap.put("RU", "Rashia");
    namesMap.put("SA", "Saudi");
    namesMap.put("SB", "Airandi Cia Solomon");
    namesMap.put("SC", "Shelisheli");
    namesMap.put("SD", "Sudani");
    namesMap.put("SE", "Swideni");
    namesMap.put("SG", "Singapoo");
    namesMap.put("SH", "Santahelena");
    namesMap.put("SL", "Siera Leoni");
    namesMap.put("SM", "Samarino");
    namesMap.put("SN", "Senego");
    namesMap.put("SR", "Surinamu");
    namesMap.put("ST", "Sao Tome na Principe");
    namesMap.put("SV", "Elsavado");
    namesMap.put("SY", "Siria");
    namesMap.put("SZ", "Swazilandi");
    namesMap.put("TC", "Aĩrandi cia Takĩ na Kaiko");
    namesMap.put("TD", "Chadi");
    namesMap.put("TH", "Thaĩlandi");
    namesMap.put("TJ", "Tajikistani");
    namesMap.put("TL", "Timori ya Isti");
    namesMap.put("TM", "Tukumenistani");
    namesMap.put("TR", "Takĩ");
    namesMap.put("TT", "Trinidad na Tobago");
    namesMap.put("TW", "Taiwani");
    namesMap.put("UA", "Ukirĩni");
    namesMap.put("US", "Amerika");
    namesMap.put("UY", "Urugwĩ");
    namesMap.put("UZ", "Uzibekistani");
    namesMap.put("VA", "Vatikani");
    namesMap.put("VC", "Santavisenti na Grenadini");
    namesMap.put("VG", "Aĩrandi cia Virgin cia Ngeretha");
    namesMap.put("VI", "Aĩrandi cia Virgin cia Amerika");
    namesMap.put("VN", "Vietinamu");
    namesMap.put("WF", "Walis na Futuna");
    namesMap.put("YE", "Yemeni");
    namesMap.put("ZA", "Afrika ya Southi");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "AD": "Andora",
        "AE": "Falme cia Kiarabu",
        "AF": "Afuganistani",
        "AG": "Antigua na Barbuda",
        "AL": "Alubania",
        "AR": "Ajentina",
        "AS": "Samoa ya Amerika",
        "AT": "Austiria",
        "AU": "Austrĩlia",
        "AZ": "Azebaijani",
        "BA": "Bosnia na Hezegovina",
        "BB": "Babadosi",
        "BD": "Bangiradeshi",
        "BE": "Beronjiamu",
        "BF": "Bukinafaso",
        "BH": "Baharini",
        "BJ": "Benini",
        "BM": "Bamuda",
        "BR": "Brazilu",
        "BS": "Bahamasi",
        "BT": "Butani",
        "BY": "Belarusi",
        "CA": "Kanada",
        "CD": "Nthĩ ya Kidemokrasĩ ya Kongo",
        "CF": "Nthĩ ya Afrika gatĩgatĩ",
        "CG": "Kongo",
        "CH": "Swizilandi",
        "CI": "Kodivaa",
        "CK": "Aĩrandi cia Cook",
        "CM": "Kameruni",
        "CO": "Kolombia",
        "CR": "Kostarika",
        "CU": "Kiuba",
        "CV": "Kepuvede",
        "CY": "Caipurasi",
        "CZ": "Nthĩ ya Cheki",
        "DE": "Njamanĩ",
        "DJ": "Jibuti",
        "DK": "Denimaki",
        "DM": "Dominika",
        "DO": "Nthĩ ya Dominika",
        "DZ": "Angiria",
        "EC": "Ekwado",
        "EG": "Misiri",
        "ES": "Spĩni",
        "ET": "Ithiopia",
        "FI": "Finilandi",
        "FK": "Aĩrandi cia Falklandi",
        "FM": "Mikronesia",
        "FR": "Fransi",
        "GA": "Gaboni",
        "GB": "Ngeretha",
        "GE": "Jojia",
        "GF": "Gwiyana ya Fransi",
        "GI": "Ngĩbrata",
        "GL": "Ngirinilandi",
        "GN": "Gine",
        "GP": "Gwadelupe",
        "GQ": "Gine ya Iquita",
        "GR": "Ngiriki",
        "GT": "Gwatemala",
        "GU": "Gwam",
        "GW": "Ginebisau",
        "HN": "Hondurasi",
        "HR": "Koroashia",
        "HU": "Hangarĩ",
        "IE": "Aelandi",
        "IL": "Isiraeli",
        "IO": "Nthĩ cia Ngeretha gatagatĩ ka ĩria ria Hindi",
        "IQ": "Iraki",
        "IR": "Irani",
        "IS": "Aisilandi",
        "IT": "Italĩ",
        "JM": "Jamaika",
        "JO": "Jorondani",
        "JP": "Japani",
        "KG": "Kirigizistani",
        "KH": "Kambodia",
        "KM": "Komoro",
        "KN": "Santakitzi na Nevis",
        "KP": "Korea Nothi",
        "KR": "Korea Saũthi",
        "KW": "Kuwĩ ti",
        "KY": "Aĩrandi cia Kayman",
        "KZ": "Kazakistani",
        "LA": "Laosi",
        "LB": "Lebanoni",
        "LC": "Santalusia",
        "LI": "Lishenteni",
        "LK": "Sirilanka",
        "LU": "Luxembogu",
        "LV": "Lativia",
        "LY": "Lĩbia",
        "MA": "Moroko",
        "MC": "Monako",
        "MG": "Madagasika",
        "MH": "Aĩrandi cia Marshal",
        "MM": "Myanima",
        "MP": "Aĩrandi cia Mariana ya nothi",
        "MQ": "Martiniki",
        "MS": "Montserrati",
        "MU": "Maurĩtiasi",
        "MV": "Modivu",
        "MX": "Mexiko",
        "MY": "Malĩsia",
        "MZ": "Mozambiki",
        "NC": "Kalendoia Ĩnjeru",
        "NE": "Nija",
        "NF": "Aĩrandi cia Norfok",
        "NG": "Nijeria",
        "NI": "Nikaragwa",
        "NL": "Holandi",
        "NO": "Norwi",
        "NP": "Nepali",
        "NZ": "Niuzilandi",
        "OM": "Omani",
        "PF": "Polinesia ya Fransi",
        "PG": "Papua",
        "PH": "Filipino",
        "PK": "Pakistani",
        "PL": "Polandi",
        "PM": "Santapieri na Mikeloni",
        "PN": "Pitkairni",
        "PR": "Pwetoriko",
        "PS": "Rũtere rwa Westi banki na Gaza cia Palestina",
        "PT": "Potogo",
        "PY": "Paragwai",
        "QA": "Kata",
        "RE": "Riyunioni",
        "RU": "Rashia",
        "SA": "Saudi",
        "SB": "Airandi Cia Solomon",
        "SC": "Shelisheli",
        "SD": "Sudani",
        "SE": "Swideni",
        "SG": "Singapoo",
        "SH": "Santahelena",
        "SL": "Siera Leoni",
        "SM": "Samarino",
        "SN": "Senego",
        "SR": "Surinamu",
        "ST": "Sao Tome na Principe",
        "SV": "Elsavado",
        "SY": "Siria",
        "SZ": "Swazilandi",
        "TC": "Aĩrandi cia Takĩ na Kaiko",
        "TD": "Chadi",
        "TH": "Thaĩlandi",
        "TJ": "Tajikistani",
        "TL": "Timori ya Isti",
        "TM": "Tukumenistani",
        "TR": "Takĩ",
        "TT": "Trinidad na Tobago",
        "TW": "Taiwani",
        "UA": "Ukirĩni",
        "US": "Amerika",
        "UY": "Urugwĩ",
        "UZ": "Uzibekistani",
        "VA": "Vatikani",
        "VC": "Santavisenti na Grenadini",
        "VG": "Aĩrandi cia Virgin cia Ngeretha",
        "VI": "Aĩrandi cia Virgin cia Amerika",
        "VN": "Vietinamu",
        "WF": "Walis na Futuna",
        "YE": "Yemeni",
        "ZA": "Afrika ya Southi"
    };
  }-*/;
}
