/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.vicluster.telecontrol.ssh;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.gridkit.internal.com.jcraft.jsch.JSch;
import org.gridkit.internal.com.jcraft.jsch.JSchException;
import org.gridkit.internal.com.jcraft.jsch.Session;
import org.gridkit.internal.com.jcraft.jsch.UIKeyboardInteractive;
import org.gridkit.internal.com.jcraft.jsch.UserInfo;
import org.gridkit.vicluster.telecontrol.ssh.SshSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleSshSessionProvider
implements SshSessionFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleSshSessionProvider.class);
    private JSch jsch;
    private String user;
    private String password;
    private String passphrase;
    private Map<String, String> config = new HashMap<String, String>();

    public SimpleSshSessionProvider() {
        this(new JSch());
    }

    public SimpleSshSessionProvider(JSch jsch) {
        this.jsch = jsch;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setKeyFile(String fileName) {
        String[] paths;
        boolean added = false;
        for (String path : paths = fileName.split("[|]")) {
            try {
                File f;
                if (path.startsWith("~/")) {
                    try {
                        path = new File(System.getProperty("user.home"), path.substring(2)).getCanonicalPath();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                if (!(f = new File(path)).exists()) continue;
                this.jsch.addIdentity(path);
                added = true;
            }
            catch (JSchException e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (!added) {
            throw new IllegalArgumentException("No keys found at [" + fileName + "]");
        }
    }

    public void setConfig(String key, String value) {
        this.config.put(key, value);
    }

    @Override
    public Session getSession(String host, String account) throws JSchException {
        if (account != null && !this.user.equals(account)) {
            throw new IllegalArgumentException("User '" + account + "' is not configured");
        }
        UserAuthnticator ui = new UserAuthnticator(host);
        int port = 22;
        if (host.indexOf(58) > 0) {
            String p = host.substring(host.lastIndexOf(58) + 1);
            host = host.substring(0, host.lastIndexOf(58));
            port = Integer.parseInt(p);
        }
        Session session = this.jsch.getSession(this.user, host, port);
        session.setConfig("StrictHostKeyChecking", "no");
        for (String key : this.config.keySet()) {
            session.setConfig(key, this.config.get(key));
        }
        session.setDaemonThread(true);
        session.setUserInfo(ui);
        session.connect();
        return session;
    }

    static {
        JSch.setLogger(new JSchLogger());
    }

    private static final class JSchLogger
    implements org.gridkit.internal.com.jcraft.jsch.Logger {
        private Logger logger = LoggerFactory.getLogger((String)"remoting.ssh.jsch");

        @Override
        public void log(int level, String message) {
            switch (level) {
                case 0: {
                    this.logger.trace(message);
                    break;
                }
                case 2: {
                    if (message.endsWith("(RSA) to the list of known hosts.")) {
                        this.logger.info(message);
                        break;
                    }
                    this.logger.warn(message);
                    break;
                }
                case 1: {
                    this.logger.debug(message);
                    break;
                }
                case 3: {
                    this.logger.error(message);
                    break;
                }
                case 4: {
                    this.logger.error(message);
                    break;
                }
                default: {
                    this.logger.warn(message);
                }
            }
        }

        @Override
        public boolean isEnabled(int level) {
            switch (level) {
                case 0: {
                    return this.logger.isDebugEnabled();
                }
                case 2: {
                    return this.logger.isWarnEnabled();
                }
                case 1: {
                    return this.logger.isInfoEnabled();
                }
                case 3: {
                    return this.logger.isErrorEnabled();
                }
                case 4: {
                    return this.logger.isErrorEnabled();
                }
            }
            return this.logger.isWarnEnabled();
        }
    }

    private final class UserAuthnticator
    implements UserInfo,
    UIKeyboardInteractive {
        private final String host;

        private UserAuthnticator(String host) {
            this.host = host;
        }

        @Override
        public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
            LOGGER.debug("[" + this.host + "] SSH: keyboard-interactive Prompt=" + Arrays.toString(prompt));
            return new String[]{SimpleSshSessionProvider.this.password != null ? SimpleSshSessionProvider.this.password : ""};
        }

        @Override
        public void showMessage(String message) {
            LOGGER.debug("[" + this.host + "] SSH: " + message);
        }

        @Override
        public boolean promptYesNo(String message) {
            LOGGER.debug("[" + this.host + "] SSH: " + message + " <- yes");
            return true;
        }

        @Override
        public boolean promptPassword(String message) {
            LOGGER.debug("[" + this.host + "] SSH: " + message + " <- yes");
            return true;
        }

        @Override
        public boolean promptPassphrase(String message) {
            LOGGER.debug("[" + this.host + "] SSH: " + message + " <- yes");
            return true;
        }

        @Override
        public String getPassword() {
            LOGGER.debug("[" + this.host + "] SSH: password = " + SimpleSshSessionProvider.this.password);
            return SimpleSshSessionProvider.this.password;
        }

        @Override
        public String getPassphrase() {
            LOGGER.debug("[" + this.host + "] SSH: passphrase = " + SimpleSshSessionProvider.this.password);
            return SimpleSshSessionProvider.this.passphrase;
        }
    }
}

