/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.nanocloud;

import org.gridkit.vicluster.ViConfExtender;
import org.gridkit.vicluster.ViConfigurable;
import org.gridkit.vicluster.ViEngine;

public class RemoteNode
extends ViConfigurable.Delegate {
    public static ViConfExtender<RemoteNode> REMOTE = new ViConfExtender<RemoteNode>(){

        public RemoteNode wrap(ViConfigurable node) {
            return RemoteNode.at(node);
        }
    };
    public static String HOST = "remote:host";
    public static String ACCOUNT = "remote:account";
    public static String PASSWORD = "remote:password";
    public static String SSH_AUTH_METHODS = "remote:ssh-auth-methods";
    public static String SSH_KEY_FILE = "remote:ssh-key-file";
    public static String JAR_CACHE_PATH = "remote:jar-cache-path";
    private ViConfigurable config;

    public static RemoteNode at(ViConfigurable target) {
        return new RemoteNode(target);
    }

    protected RemoteNode(ViConfigurable target) {
        this.config = target;
    }

    protected ViConfigurable getConfigurable() {
        return this.config;
    }

    public RemoteNode setRemoteNodeType() {
        this.config.setProp("node:type", "remote");
        this.setRemoteJarCachePath("/tmp/.nanocloud");
        this.config.setProp("remote-runtime:fallback-jvm-exec", "java");
        this.config.setConfigElement("pragma-handler:ssh", (Object)new ViEngine.InitTimePragmaHandler());
        return this;
    }

    public RemoteNode useSimpleRemoting() {
        this.setRemoteNodeType();
        this.setHostsConfigFile("?~/ssh-credentials.prop");
        this.setRemoteHost("~%s!(.*)");
        return this;
    }

    public RemoteNode setRemoteHost(String host) {
        this.config.setProp(HOST, host);
        return this;
    }

    public RemoteNode setRemoteAccount(String account) {
        this.config.setProp(ACCOUNT, account);
        return this;
    }

    public RemoteNode setHostsConfigFile(String path) {
        this.config.setProp("remote:host-config", path);
        return this;
    }

    public RemoteNode setSshPrivateKey(String path) {
        this.config.setProp(SSH_KEY_FILE, path);
        this.config.setProp("ssh:private-key-file", path);
        return this;
    }

    public RemoteNode setPassword(String password) {
        this.config.setProp("ssh:password", password);
        return this;
    }

    public RemoteNode setRemoteJavaExec(String javaExec) {
        this.config.setProp("jvm:exec-command", javaExec);
        return this;
    }

    public RemoteNode setRemoteBootstrapJavaExec(String jarCachePath) {
        this.config.setProp("remote-runtime:bootstrap-jvm-exec", jarCachePath);
        return this;
    }

    public RemoteNode setRemoteJarCachePath(String jarCachePath) {
        this.config.setProp("remote-runtime:jar-cache", jarCachePath);
        return this;
    }
}

