/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.syslog4j.impl;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.graylog2.syslog4j.SyslogRuntimeException;
import org.graylog2.syslog4j.impl.AbstractSyslog;
import org.graylog2.syslog4j.impl.AbstractSyslogConfigIF;
import org.graylog2.syslog4j.util.SyslogUtility;

public abstract class AbstractSyslogWriter
implements Runnable,
Serializable {
    private static final long serialVersionUID = 836468466009035847L;
    protected AbstractSyslog syslog = null;
    protected List queuedMessages = null;
    protected Thread thread = null;
    protected AbstractSyslogConfigIF syslogConfig = null;
    protected boolean shutdown = false;

    public void initialize(AbstractSyslog abstractSyslog) {
        this.syslog = abstractSyslog;
        try {
            this.syslogConfig = (AbstractSyslogConfigIF)this.syslog.getConfig();
        }
        catch (ClassCastException cce) {
            throw new SyslogRuntimeException("config must implement interface AbstractSyslogConfigIF");
        }
        if (this.syslogConfig.isThreaded()) {
            this.queuedMessages = new LinkedList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queue(int level, byte[] message) {
        List list = this.queuedMessages;
        synchronized (list) {
            if (this.syslogConfig.getMaxQueueSize() == -1 || this.queuedMessages.size() < this.syslogConfig.getMaxQueueSize()) {
                this.queuedMessages.add(message);
            } else {
                this.syslog.backLog(level, SyslogUtility.newString(this.syslogConfig, message), "MaxQueueSize (" + this.syslogConfig.getMaxQueueSize() + ") reached");
            }
        }
    }

    public void setThread(Thread thread) {
        this.thread = thread;
    }

    public boolean hasThread() {
        return this.thread != null && this.thread.isAlive();
    }

    public abstract void write(byte[] var1);

    public abstract void flush();

    public abstract void shutdown();

    protected abstract void runCompleted();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.shutdown || !this.queuedMessages.isEmpty()) {
            LinkedList queuedMessagesCopy = null;
            List list = this.queuedMessages;
            synchronized (list) {
                queuedMessagesCopy = new LinkedList(this.queuedMessages);
                this.queuedMessages.clear();
            }
            if (queuedMessagesCopy != null) {
                while (!queuedMessagesCopy.isEmpty()) {
                    byte[] message = (byte[])queuedMessagesCopy.remove(0);
                    try {
                        this.write(message);
                        this.syslog.setBackLogStatus(false);
                    }
                    catch (SyslogRuntimeException sre) {
                        this.syslog.backLog(6, SyslogUtility.newString(this.syslog.getConfig(), message), sre);
                    }
                }
            }
            SyslogUtility.sleep(this.syslogConfig.getThreadLoopInterval());
        }
        this.runCompleted();
    }
}

