/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.profiler;

import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.tools.profiler.StackTraceEntry;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;

public final class ProfilerNode<T> {
    private final T payload;
    private final ProfilerNode<T> parent;
    private final StackTraceEntry sourceLocation;
    Map<StackTraceEntry, ProfilerNode<T>> children;

    ProfilerNode(ProfilerNode<T> parent, StackTraceEntry sourceLocation, T payload) {
        this.parent = parent;
        this.sourceLocation = sourceLocation;
        this.payload = payload;
    }

    ProfilerNode() {
        this.parent = null;
        this.sourceLocation = null;
        this.payload = null;
    }

    public Collection<ProfilerNode<T>> getChildren() {
        if (this.children == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.children.values());
    }

    public ProfilerNode<T> getParent() {
        return this.parent;
    }

    public boolean isRecursive() {
        return this.isRecursiveImpl(this);
    }

    private boolean isRecursiveImpl(ProfilerNode<T> source) {
        if (this.parent.sourceLocation == null) {
            return false;
        }
        if (this.parent.sourceLocation.equals(source.sourceLocation)) {
            return true;
        }
        return super.isRecursiveImpl(source);
    }

    public SourceSection getSourceSection() {
        return this.sourceLocation.getSourceSection();
    }

    public String getRootName() {
        return this.sourceLocation.getRootName();
    }

    public Set<Class<?>> getTags() {
        return this.sourceLocation.getTags();
    }

    public T getPayload() {
        return this.payload;
    }

    ProfilerNode<T> findChild(StackTraceEntry childLocation) {
        if (this.children != null) {
            return this.children.get(childLocation);
        }
        return null;
    }

    void addChild(StackTraceEntry childLocation, ProfilerNode<T> child) {
        if (this.children == null) {
            this.children = new HashMap<StackTraceEntry, ProfilerNode<T>>();
        }
        this.children.put(childLocation, child);
    }

    StackTraceEntry getSourceLocation() {
        return this.sourceLocation;
    }

    void deepCopyChildrenFrom(ProfilerNode<T> node, Function<T, T> copyPayload) {
        for (ProfilerNode<T> child : node.getChildren()) {
            StackTraceEntry childSourceLocation = child.getSourceLocation();
            T childPayload = child.getPayload();
            T destinationPayload = copyPayload.apply(childPayload);
            ProfilerNode<T> destinationChild = new ProfilerNode<T>(this, childSourceLocation, destinationPayload);
            if (this.children == null) {
                this.children = new HashMap<StackTraceEntry, ProfilerNode<T>>();
            }
            this.children.put(childSourceLocation, destinationChild);
            destinationChild.deepCopyChildrenFrom(child, copyPayload);
        }
    }

    void deepMergeChildrenFrom(ProfilerNode<T> node, BiConsumer<T, T> mergePayload, Supplier<T> payloadFactory) {
        for (ProfilerNode<T> child : node.getChildren()) {
            StackTraceEntry childSourceLocation = child.getSourceLocation();
            T childPayload = child.getPayload();
            ProfilerNode<T> destinationChild = this.findBySourceLocation(childSourceLocation);
            if (destinationChild == null) {
                T destinationPayload = payloadFactory.get();
                mergePayload.accept(childPayload, destinationPayload);
                destinationChild = new ProfilerNode<T>(this, childSourceLocation, destinationPayload);
                if (this.children == null) {
                    this.children = new HashMap<StackTraceEntry, ProfilerNode<T>>();
                }
                this.children.put(childSourceLocation, destinationChild);
            } else {
                mergePayload.accept(childPayload, destinationChild.getPayload());
            }
            destinationChild.deepMergeChildrenFrom(child, mergePayload, payloadFactory);
        }
    }

    void deepMergeNodeToChildren(ProfilerNode<T> node, BiConsumer<T, T> mergePayload, Supplier<T> payloadFactory) {
        StackTraceEntry childSourceLocation = node.getSourceLocation();
        T childPayload = node.getPayload();
        ProfilerNode<T> destinationChild = this.findBySourceLocation(childSourceLocation);
        if (destinationChild == null) {
            T destinationPayload = payloadFactory.get();
            mergePayload.accept(childPayload, destinationPayload);
            destinationChild = new ProfilerNode<T>(this, childSourceLocation, destinationPayload);
            if (this.children == null) {
                this.children = new HashMap<StackTraceEntry, ProfilerNode<T>>();
            }
            this.children.put(childSourceLocation, destinationChild);
        } else {
            mergePayload.accept(childPayload, destinationChild.getPayload());
        }
        destinationChild.deepMergeChildrenFrom(node, mergePayload, payloadFactory);
    }

    private ProfilerNode<T> findBySourceLocation(StackTraceEntry targetSourceLocation) {
        if (this.children != null) {
            for (ProfilerNode<T> child : this.children.values()) {
                if (!child.getSourceLocation().equals(targetSourceLocation)) continue;
                return child;
            }
        }
        return null;
    }
}

