/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.pecoff.cv;

import com.oracle.objectfile.pecoff.cv.CVDebugInfo;
import com.oracle.objectfile.pecoff.cv.CVSymbolRecord;
import com.oracle.objectfile.pecoff.cv.CVUtil;
import java.util.ArrayList;

final class CVLineRecord
extends CVSymbolRecord {
    private static final int LINE_RECORD_HEADER_SIZE = 12;
    private static final int DEFAULT_LINE_BLOCK_COUNT = 100;
    private static final int DEFAULT_LINE_ENTRY_COUNT = 100;
    private static final short CB_HAS_NO_COLUMNS_FLAG = 0;
    private final String symbolName;
    private final ArrayList<FileBlock> fileBlocks = new ArrayList(100);

    CVLineRecord(CVDebugInfo cvDebugInfo, String symbolName) {
        super(cvDebugInfo, 242);
        this.symbolName = symbolName;
    }

    void addNewFile(int fileId) {
        this.fileBlocks.add(new FileBlock(fileId));
    }

    void addNewLine(int addr, int line) {
        this.fileBlocks.get(this.fileBlocks.size() - 1).addEntry(new LineEntry(addr, line));
    }

    int getCurrentFileId() {
        assert (!this.fileBlocks.isEmpty());
        return this.fileBlocks.get((int)(this.fileBlocks.size() - 1)).fileId;
    }

    @Override
    protected int computeSize(int initialPos) {
        return this.computeContents(null, initialPos);
    }

    @Override
    protected int computeContents(byte[] buffer, int initialPos) {
        int pos = this.computeHeader(buffer, initialPos);
        for (FileBlock fileBlock : this.fileBlocks) {
            pos = fileBlock.computeContents(buffer, pos);
        }
        return pos;
    }

    private int computeHeader(byte[] buffer, int initialPos) {
        if (buffer == null) {
            return initialPos + 12;
        }
        assert (this.symbolName != null);
        int pos = initialPos;
        pos = this.cvDebugInfo.getCVSymbolSection().markRelocationSite(buffer, pos, this.symbolName);
        pos = CVUtil.putShort((short)0, buffer, pos);
        assert (!this.fileBlocks.isEmpty());
        int length = this.fileBlocks.get(this.fileBlocks.size() - 1).getHighAddr();
        pos = CVUtil.putInt(length, buffer, pos);
        return pos;
    }

    boolean isEmpty() {
        return this.fileBlocks.isEmpty();
    }

    @Override
    public String toString() {
        return String.format("CVLineRecord(type=0x%04x pos=0x%05x size=0x%d)", this.type, this.recordStartPosition, this.fileBlocks.size());
    }

    private static class FileBlock {
        static final int FILE_BLOCK_HEADER_SIZE = 12;
        static final int NO_PREVIOUS_LINE = -2;
        private final ArrayList<LineEntry> lineEntries = new ArrayList(100);
        private final int fileId;
        private int previousLine;

        FileBlock(int fileId) {
            this.fileId = fileId;
            this.previousLine = -2;
        }

        void addEntry(LineEntry le) {
            assert (le.lineAndFlags != -2);
            if (le.lineAndFlags != this.previousLine) {
                this.lineEntries.add(le);
                this.previousLine = le.lineAndFlags;
            }
        }

        int computeContents(byte[] buffer, int initialPos) {
            if (buffer == null) {
                return this.computeSize(initialPos);
            }
            int pos = initialPos;
            pos = CVUtil.putInt(this.fileId, buffer, pos);
            pos = CVUtil.putInt(this.lineEntries.size(), buffer, pos);
            pos = CVUtil.putInt(this.computeSize(0), buffer, pos);
            for (LineEntry lineEntry : this.lineEntries) {
                pos = lineEntry.computeContents(buffer, pos);
            }
            return pos;
        }

        int computeSize(int initialPos) {
            return initialPos + 12 + 8 * this.lineEntries.size();
        }

        int getHighAddr() {
            assert (!this.lineEntries.isEmpty());
            return this.lineEntries.get((int)(this.lineEntries.size() - 1)).addr;
        }
    }

    private static class LineEntry {
        static final int LINE_ENTRY_SIZE = 8;
        int addr;
        int lineAndFlags;

        LineEntry(int addr, int line, int deltaEnd, boolean isStatement) {
            this.addr = addr;
            assert (line <= 0xFFFFFF);
            assert (line >= 0);
            assert (deltaEnd <= 127);
            assert (deltaEnd >= 0);
            this.lineAndFlags = line | deltaEnd << 24 | (isStatement ? Integer.MIN_VALUE : 0);
        }

        LineEntry(int addr, int line) {
            this(addr, line, 0, false);
        }

        int computeContents(byte[] buffer, int initialPos) {
            int pos = initialPos;
            pos = CVUtil.putInt(this.addr, buffer, pos);
            pos = CVUtil.putInt(this.lineAndFlags, buffer, pos);
            return pos;
        }
    }
}

