/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.debugentry;

import com.oracle.objectfile.debugentry.ClassEntry;
import com.oracle.objectfile.debugentry.range.PrimaryRange;
import com.oracle.objectfile.debugentry.range.SubRange;
import com.oracle.objectfile.debuginfo.DebugInfoProvider;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.List;

public class CompiledMethodEntry {
    private final PrimaryRange primary;
    private final ClassEntry classEntry;
    private final List<DebugInfoProvider.DebugFrameSizeChange> frameSizeInfos;
    private final int frameSize;

    public CompiledMethodEntry(PrimaryRange primary, List<DebugInfoProvider.DebugFrameSizeChange> frameSizeInfos, int frameSize, ClassEntry classEntry) {
        this.primary = primary;
        this.classEntry = classEntry;
        this.frameSizeInfos = frameSizeInfos;
        this.frameSize = frameSize;
    }

    public PrimaryRange getPrimary() {
        return this.primary;
    }

    public ClassEntry getClassEntry() {
        return this.classEntry;
    }

    public Iterator<SubRange> topDownRangeIterator() {
        return new Iterator<SubRange>(){
            final ArrayDeque<SubRange> workStack = new ArrayDeque();
            SubRange current;
            {
                this.current = CompiledMethodEntry.this.primary.getFirstCallee();
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            @Override
            public SubRange next() {
                assert (this.hasNext());
                SubRange result = this.current;
                this.forward();
                return result;
            }

            private void forward() {
                SubRange sibling = this.current.getSiblingCallee();
                assert (sibling == null || this.current.getHi() <= sibling.getLo()) : this.current.getHi() + " > " + sibling.getLo();
                if (!this.current.isLeaf()) {
                    if (sibling != null) {
                        this.workStack.push(sibling);
                    }
                    this.current = this.current.getFirstCallee();
                } else {
                    this.current = sibling != null ? sibling : this.workStack.pollFirst();
                }
            }
        };
    }

    public Iterator<SubRange> leafRangeIterator() {
        final Iterator<SubRange> iter = this.topDownRangeIterator();
        return new Iterator<SubRange>(){
            SubRange current;
            {
                this.current = this.forwardLeaf(iter);
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            @Override
            public SubRange next() {
                assert (this.hasNext());
                SubRange result = this.current;
                this.current = this.forwardLeaf(iter);
                return result;
            }

            private SubRange forwardLeaf(Iterator<SubRange> t) {
                if (t.hasNext()) {
                    SubRange next = t.next();
                    while (next != null && !next.isLeaf()) {
                        next = t.next();
                    }
                    return next;
                }
                return null;
            }
        };
    }

    public List<DebugInfoProvider.DebugFrameSizeChange> getFrameSizeInfos() {
        return this.frameSizeInfos;
    }

    public int getFrameSize() {
        return this.frameSize;
    }
}

