/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.util;

import com.oracle.svm.util.ModuleSupport;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public final class ReflectionUtil {
    private ReflectionUtil() {
    }

    private static void openModule(Class<?> declaringClass) {
        ModuleSupport.openModuleByClass(declaringClass, ReflectionUtil.class);
    }

    public static Method lookupMethod(Class<?> declaringClass, String methodName, Class<?> ... parameterTypes) {
        return ReflectionUtil.lookupMethod(false, declaringClass, methodName, parameterTypes);
    }

    public static Method lookupMethod(boolean optional, Class<?> declaringClass, String methodName, Class<?> ... parameterTypes) {
        try {
            Method result = declaringClass.getDeclaredMethod(methodName, parameterTypes);
            ReflectionUtil.openModule(declaringClass);
            result.setAccessible(true);
            return result;
        }
        catch (ReflectiveOperationException ex) {
            if (optional) {
                return null;
            }
            throw new ReflectionUtilError(ex);
        }
    }

    public static <T> Constructor<T> lookupConstructor(Class<T> declaringClass, Class<?> ... parameterTypes) {
        return ReflectionUtil.lookupConstructor(false, declaringClass, parameterTypes);
    }

    public static <T> Constructor<T> lookupConstructor(boolean optional, Class<T> declaringClass, Class<?> ... parameterTypes) {
        try {
            Constructor<T> result = declaringClass.getDeclaredConstructor(parameterTypes);
            ReflectionUtil.openModule(declaringClass);
            result.setAccessible(true);
            return result;
        }
        catch (ReflectiveOperationException ex) {
            if (optional) {
                return null;
            }
            throw new ReflectionUtilError(ex);
        }
    }

    public static <T> T newInstance(Class<T> declaringClass) {
        try {
            return ReflectionUtil.lookupConstructor(declaringClass, new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException ex) {
            throw new ReflectionUtilError(ex);
        }
    }

    public static Field lookupField(Class<?> declaringClass, String fieldName) {
        return ReflectionUtil.lookupField(false, declaringClass, fieldName);
    }

    public static Field lookupField(boolean optional, Class<?> declaringClass, String fieldName) {
        try {
            Field result = declaringClass.getDeclaredField(fieldName);
            ReflectionUtil.openModule(declaringClass);
            result.setAccessible(true);
            return result;
        }
        catch (ReflectiveOperationException ex) {
            if (optional) {
                return null;
            }
            throw new ReflectionUtilError(ex);
        }
    }

    public static <T> T readField(Class<?> declaringClass, String fieldName, Object receiver) {
        try {
            return (T)ReflectionUtil.lookupField(declaringClass, fieldName).get(receiver);
        }
        catch (ReflectiveOperationException ex) {
            throw new ReflectionUtilError(ex);
        }
    }

    public static <T> T readStaticField(Class<?> declaringClass, String fieldName) {
        return ReflectionUtil.readField(declaringClass, fieldName, null);
    }

    public static final class ReflectionUtilError
    extends Error {
        private ReflectionUtilError(Throwable cause) {
            super(cause);
        }
    }
}

