/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.junit.platform;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;

public class UniqueIdTrackingTestExecutionListener
implements TestExecutionListener {
    static final String FILE_NAME = "test_ids.txt";
    private final List<String> uniqueIds = new ArrayList<String>();

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        if (testIdentifier.isTest()) {
            this.uniqueIds.add(testIdentifier.getUniqueId());
        }
    }

    public void testPlanExecutionFinished(TestPlan testPlan) {
        File file = UniqueIdTrackingTestExecutionListener.getFile();
        if (file == null) {
            return;
        }
        try (PrintWriter writer = new PrintWriter((Writer)new BufferedWriter(new FileWriter(file)), true);){
            this.uniqueIds.stream().sorted().forEach(writer::println);
        }
        catch (IOException ex) {
            System.err.println("Failed to write test class names to file " + file);
            ex.printStackTrace(System.err);
        }
    }

    private static File getFile() {
        File buildDir = new File("pom.xml").exists() ? new File("target") : new File("build");
        if (!buildDir.exists() && !buildDir.mkdirs()) {
            System.err.println("Failed to create directory " + buildDir);
            return null;
        }
        File file = new File(buildDir, FILE_NAME);
        if (file.exists() && !file.delete()) {
            System.err.println("Failed to delete file " + file);
            return null;
        }
        try {
            file.createNewFile();
        }
        catch (IOException ex) {
            System.err.println("Failed to create file " + file);
            ex.printStackTrace(System.err);
            return null;
        }
        return file;
    }
}

