/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.junit.platform;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.graalvm.junit.platform.NativeImageJUnitLauncher;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeClassInitialization;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import org.junit.platform.commons.annotation.Testable;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;

public final class JUnitPlatformFeature
implements Feature {
    final boolean debug = System.getProperty("debug") != null;

    public void duringSetup(Feature.DuringSetupAccess access) {
        try {
            RuntimeReflection.register((Executable[])Testable.class.getMethods());
            RuntimeReflection.register((Executable[])Class.forName("org.junit.jupiter.params.ParameterizedTestExtension").getDeclaredMethods());
            RuntimeReflection.registerForReflectiveInstantiation((Class[])new Class[]{Class.forName("org.junit.jupiter.params.ParameterizedTestExtension")});
            RuntimeReflection.register((Executable[])Class.forName("org.junit.jupiter.params.provider.CsvArgumentsProvider").getMethods());
            RuntimeReflection.register((Executable[])Class.forName("org.junit.jupiter.params.provider.CsvArgumentsProvider").getDeclaredMethods());
            RuntimeReflection.registerForReflectiveInstantiation((Class[])new Class[]{Class.forName("org.junit.jupiter.params.provider.CsvArgumentsProvider")});
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Missing some JUnit Platform classes for runtime reflection configuration. \nCheck if JUnit Platform is on your classpath or if that version is supported. \nOriginal error: " + e);
        }
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        RuntimeClassInitialization.initializeAtBuildTime((String[])new String[]{"org.junit.vintage.engine.support.UniqueIdReader"});
        RuntimeClassInitialization.initializeAtBuildTime((String[])new String[]{"org.junit.vintage.engine.support.UniqueIdStringifier"});
        RuntimeClassInitialization.initializeAtBuildTime((String[])new String[]{"org.junit.platform.launcher.core.InternalTestPlan"});
        RuntimeClassInitialization.initializeAtBuildTime((String[])new String[]{"org.junit.platform.commons.util.StringUtils"});
        RuntimeClassInitialization.initializeAtBuildTime((String[])new String[]{"org.junit.platform.launcher.core.TestExecutionListenerRegistry"});
        RuntimeClassInitialization.initializeAtBuildTime((String[])new String[]{"org.junit.platform.commons.logging.LoggerFactory$DelegatingLogger"});
        RuntimeClassInitialization.initializeAtBuildTime((String[])new String[]{"org.junit.platform.launcher.core.EngineDiscoveryOrchestrator"});
        RuntimeClassInitialization.initializeAtBuildTime((String[])new String[]{"org.junit.platform.launcher.core.LauncherConfigurationParameters"});
        RuntimeClassInitialization.initializeAtBuildTime((String[])new String[]{"org.junit.platform.commons.logging.LoggerFactory"});
        RuntimeClassInitialization.initializeAtBuildTime((String[])new String[]{"org.junit.jupiter.engine.config.EnumConfigurationParameterConverter"});
        RuntimeClassInitialization.initializeAtBuildTime((String[])new String[]{"org.junit.jupiter.engine.descriptor.ClassTestDescriptor"});
        RuntimeClassInitialization.initializeAtBuildTime((String[])new String[]{"org.junit.jupiter.engine.descriptor.ClassBasedTestDescriptor"});
        RuntimeClassInitialization.initializeAtBuildTime((String[])new String[]{"org.junit.jupiter.engine.descriptor.TestFactoryTestDescriptor"});
        RuntimeClassInitialization.initializeAtBuildTime((String[])new String[]{"org.junit.platform.engine.UniqueIdFormat"});
        RuntimeClassInitialization.initializeAtBuildTime((String[])new String[]{"org.junit.jupiter.engine.descriptor.JupiterTestDescriptor"});
        RuntimeClassInitialization.initializeAtBuildTime((String[])new String[]{"org.junit.jupiter.engine.descriptor.MethodBasedTestDescriptor"});
        RuntimeClassInitialization.initializeAtBuildTime((String[])new String[]{"org.junit.jupiter.engine.descriptor.TestMethodTestDescriptor"});
        RuntimeClassInitialization.initializeAtBuildTime((String[])new String[]{"org.junit.platform.commons.util.ReflectionUtils"});
        RuntimeClassInitialization.initializeAtBuildTime((String[])new String[]{"org.junit.jupiter.engine.descriptor.TestTemplateTestDescriptor"});
        RuntimeClassInitialization.initializeAtBuildTime((String[])new String[]{"org.junit.jupiter.engine.execution.ConditionEvaluator"});
        RuntimeClassInitialization.initializeAtBuildTime((String[])new String[]{"org.junit.jupiter.engine.execution.ExecutableInvoker"});
        RuntimeClassInitialization.initializeAtBuildTime((Class[])new Class[]{NativeImageJUnitLauncher.class});
        Launcher launcher = LauncherFactory.create();
        TestPlan testplan = this.registerTestPlan(launcher, access.getApplicationClassPath());
        ImageSingletons.add(NativeImageJUnitLauncher.class, (Object)new NativeImageJUnitLauncher(launcher, testplan));
    }

    private List<? extends DiscoverySelector> getSelectors(List<Path> classpath) {
        List list;
        InputStream listenerStream;
        try {
            listenerStream = new FileInputStream("test_ids.txt");
        }
        catch (FileNotFoundException e) {
            listenerStream = this.getClass().getClassLoader().getResourceAsStream("test_ids.txt");
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(listenerStream));
        try {
            List classes = br.lines().collect(Collectors.toList());
            System.out.println("[junit-platform-native] Running in 'test listener' mode.");
            list = classes.stream().map(DiscoverySelectors::selectUniqueId).collect(Collectors.toList());
        }
        catch (Throwable throwable) {
            try {
                try {
                    br.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | NullPointerException e) {
                System.out.println("[junit-platform-native] Running in 'test discovery' mode. Note that this is a fallback mode.");
                if (this.debug) {
                    classpath.forEach(path -> System.out.println("[Debug] Found classpath: " + path));
                }
                return DiscoverySelectors.selectClasspathRoots(new HashSet<Path>(classpath));
            }
        }
        br.close();
        return list;
    }

    private TestPlan registerTestPlan(Launcher launcher, List<Path> classpath) {
        LauncherDiscoveryRequest request = LauncherDiscoveryRequestBuilder.request().selectors(this.getSelectors(classpath)).build();
        TestPlan testPlan = launcher.discover(request);
        testPlan.getRoots().stream().flatMap(rootIdentifier -> testPlan.getDescendants(rootIdentifier).stream()).map(TestIdentifier::getSource).filter(Optional::isPresent).map(Optional::get).filter(ClassSource.class::isInstance).map(ClassSource.class::cast).forEach(classSource -> {
            Class clazz = classSource.getJavaClass();
            if (this.debug) {
                System.out.println("[Debug] Found test class: " + clazz);
            }
            RuntimeReflection.registerForReflectiveInstantiation((Class[])new Class[]{clazz});
            for (Field field : clazz.getDeclaredFields()) {
                RuntimeReflection.register((Field[])new Field[]{field});
            }
            for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
                RuntimeReflection.register((Executable[])new Executable[]{accessibleObject});
            }
        });
        return testPlan;
    }
}

