
package org.glassfish.jersey.gson;

import java.util.Locale;
import java.util.ResourceBundle;
import org.glassfish.jersey.internal.l10n.Localizable;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory.ResourceBundleSupplier;
import org.glassfish.jersey.internal.l10n.Localizer;


/**
 * Defines string formatting method for each constant in the resource file
 * 
 */
public final class LocalizationMessages {

    private static final String BUNDLE_NAME = "org.glassfish.jersey.gson.localization";
    private static final LocalizableMessageFactory MESSAGE_FACTORY = new LocalizableMessageFactory(BUNDLE_NAME, new LocalizationMessages.BundleSupplier());
    private static final Localizer LOCALIZER = new Localizer();

    private LocalizationMessages() {
    }

    public static Localizable localizableERROR_GSON_EMPTYSTREAM() {
        return MESSAGE_FACTORY.getMessage("error.gson.emptystream");
    }

    /**
     * GSON cannot parse empty input stream.
     * 
     */
    public static String ERROR_GSON_EMPTYSTREAM() {
        return LOCALIZER.localize(localizableERROR_GSON_EMPTYSTREAM());
    }

    public static Localizable localizableERROR_GSON_SERIALIZATION() {
        return MESSAGE_FACTORY.getMessage("error.gson.serialization");
    }

    /**
     * Error writing GSON serialized object.
     * 
     */
    public static String ERROR_GSON_SERIALIZATION() {
        return LOCALIZER.localize(localizableERROR_GSON_SERIALIZATION());
    }

    public static Localizable localizableERROR_GSON_DESERIALIZATION() {
        return MESSAGE_FACTORY.getMessage("error.gson.deserialization");
    }

    /**
     * Error deserializing object from entity stream.
     * 
     */
    public static String ERROR_GSON_DESERIALIZATION() {
        return LOCALIZER.localize(localizableERROR_GSON_DESERIALIZATION());
    }

    private static class BundleSupplier
        implements ResourceBundleSupplier
    {


        public ResourceBundle getResourceBundle(Locale locale) {
            return ResourceBundle.getBundle(BUNDLE_NAME, locale);
        }

    }

}
