/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.strategies;

import java.io.IOException;
import java.util.logging.Logger;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Context;
import org.glassfish.grizzly.EmptyIOEventProcessingHandler;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.Transport;
import org.glassfish.grizzly.strategies.AbstractIOStrategy;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;

public final class SameThreadIOStrategy
extends AbstractIOStrategy {
    private static final SameThreadIOStrategy INSTANCE = new SameThreadIOStrategy();
    private static final Logger logger = Grizzly.logger(SameThreadIOStrategy.class);
    private static final EnableInterestProcessingHandler PROCESSING_HANDLER = new EnableInterestProcessingHandler();

    private SameThreadIOStrategy() {
    }

    public static SameThreadIOStrategy getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean executeIoEvent(Connection connection, IOEvent ioEvent) throws IOException {
        EnableInterestProcessingHandler ph = null;
        if (SameThreadIOStrategy.isReadWrite(ioEvent)) {
            ph = PROCESSING_HANDLER;
        }
        SameThreadIOStrategy.fireIOEvent(connection, ioEvent, ph, logger);
        return true;
    }

    @Override
    public ThreadPoolConfig createDefaultWorkerPoolConfig(Transport transport) {
        return null;
    }

    private static final class EnableInterestProcessingHandler
    extends EmptyIOEventProcessingHandler {
        private EnableInterestProcessingHandler() {
        }

        @Override
        public void onReregister(Context context) throws IOException {
            this.onComplete(context, null);
        }

        @Override
        public void onComplete(Context context, Object data) throws IOException {
            if (context.wasSuspended() || context.isManualIOEventControl()) {
                IOEvent ioEvent = context.getIoEvent();
                Connection connection = context.getConnection();
                connection.enableIOEvent(ioEvent);
            }
        }

        @Override
        public void onContextSuspend(Context context) throws IOException {
            if (!context.isManualIOEventControl()) {
                EnableInterestProcessingHandler.disableIOEvent(context);
            }
        }

        @Override
        public void onContextManualIOEventControl(Context context) throws IOException {
            if (!context.wasSuspended()) {
                EnableInterestProcessingHandler.disableIOEvent(context);
            }
        }

        private static void disableIOEvent(Context context) throws IOException {
            Connection connection = context.getConnection();
            IOEvent ioEvent = context.getIoEvent();
            connection.disableIOEvent(ioEvent);
        }
    }
}

