/*
 * Decompiled with CFR 0.152.
 */
package org.gagravarr.tika;

import java.util.Arrays;
import java.util.List;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.metadata.XMPDM;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.sax.XHTMLContentHandler;
import org.gagravarr.vorbis.VorbisStyleComments;
import org.xml.sax.SAXException;

public abstract class OggAudioParser
extends AbstractParser {
    private static final long serialVersionUID = 5168743829615945633L;

    protected static void extractChannelInfo(Metadata metadata, int channelCount) {
        if (channelCount == 1) {
            metadata.set(XMPDM.AUDIO_CHANNEL_TYPE, "Mono");
        } else if (channelCount == 2) {
            metadata.set(XMPDM.AUDIO_CHANNEL_TYPE, "Stereo");
        } else if (channelCount == 5) {
            metadata.set(XMPDM.AUDIO_CHANNEL_TYPE, "5.1");
        } else if (channelCount == 7) {
            metadata.set(XMPDM.AUDIO_CHANNEL_TYPE, "7.1");
        }
    }

    protected static void extractComments(Metadata metadata, XHTMLContentHandler xhtml, VorbisStyleComments comments) throws TikaException, SAXException {
        metadata.set(TikaCoreProperties.TITLE, comments.getTitle());
        metadata.set(TikaCoreProperties.CREATOR, comments.getArtist());
        metadata.set(XMPDM.ARTIST, comments.getArtist());
        metadata.set(XMPDM.ALBUM, comments.getAlbum());
        metadata.set(XMPDM.GENRE, comments.getGenre());
        metadata.set(XMPDM.RELEASE_DATE, comments.getDate());
        metadata.add("vendor", comments.getVendor());
        for (String comment : comments.getComments("comment")) {
            metadata.add(XMPDM.LOG_COMMENT.getName(), comment);
        }
        List<String> done = Arrays.asList("title", "artist", "album", "genre", "date", "tracknumber", "vendor", "comment");
        for (String key : comments.getAllComments().keySet()) {
            if (done.contains(key)) continue;
            for (String value : (List)comments.getAllComments().get(key)) {
                metadata.add(key, value);
            }
        }
        xhtml.element("h1", comments.getTitle());
        xhtml.element("p", comments.getArtist());
        if (comments.getTrackNumber() != null) {
            xhtml.element("p", comments.getAlbum() + ", track " + comments.getTrackNumber());
            metadata.set(XMPDM.TRACK_NUMBER, comments.getTrackNumber());
        } else {
            xhtml.element("p", comments.getAlbum());
        }
        xhtml.element("p", comments.getDate());
        for (String comment : comments.getComments("comment")) {
            xhtml.element("p", comment);
        }
        xhtml.element("p", comments.getGenre());
    }
}

