/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.directory;

import com.apple.foundationdb.KeyValue;
import com.apple.foundationdb.MutationType;
import com.apple.foundationdb.Range;
import com.apple.foundationdb.ReadTransaction;
import com.apple.foundationdb.ReadTransactionContext;
import com.apple.foundationdb.Transaction;
import com.apple.foundationdb.TransactionContext;
import com.apple.foundationdb.async.AsyncIterable;
import com.apple.foundationdb.async.AsyncIterator;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.directory.Directory;
import com.apple.foundationdb.directory.DirectoryAlreadyExistsException;
import com.apple.foundationdb.directory.DirectoryException;
import com.apple.foundationdb.directory.DirectoryMoveException;
import com.apple.foundationdb.directory.DirectoryPartition;
import com.apple.foundationdb.directory.DirectorySubspace;
import com.apple.foundationdb.directory.DirectoryVersionException;
import com.apple.foundationdb.directory.MismatchedLayerException;
import com.apple.foundationdb.directory.NoSuchDirectoryException;
import com.apple.foundationdb.directory.PathUtil;
import com.apple.foundationdb.subspace.Subspace;
import com.apple.foundationdb.tuple.ByteArrayUtil;
import com.apple.foundationdb.tuple.Tuple;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public class DirectoryLayer
implements Directory {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final byte[] LITTLE_ENDIAN_LONG_ONE = new byte[]{1, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] HIGH_CONTENTION_KEY = "hca".getBytes(UTF_8);
    private static final byte[] LAYER_KEY = "layer".getBytes(UTF_8);
    private static final byte[] VERSION_KEY = "version".getBytes(UTF_8);
    private static final long SUB_DIR_KEY = 0L;
    private static final Integer[] VERSION = new Integer[]{1, 0, 0};
    static final byte[] EMPTY_BYTES = new byte[0];
    static final List<String> EMPTY_PATH = Collections.emptyList();
    static final byte[] DEFAULT_NODE_SUBSPACE_PREFIX = new byte[]{-2};
    public static final Subspace DEFAULT_NODE_SUBSPACE = new Subspace(DEFAULT_NODE_SUBSPACE_PREFIX);
    public static final Subspace DEFAULT_CONTENT_SUBSPACE = new Subspace();
    private final Subspace rootNode;
    private final Subspace nodeSubspace;
    private final Subspace contentSubspace;
    private final HighContentionAllocator allocator;
    private final boolean allowManualPrefixes;
    private List<String> path = EMPTY_PATH;
    public static final byte[] PARTITION_LAYER = "partition".getBytes(Charset.forName("UTF-8"));
    private static DirectoryLayer defaultDirectoryLayer = new DirectoryLayer();

    public DirectoryLayer() {
        this(DEFAULT_NODE_SUBSPACE, DEFAULT_CONTENT_SUBSPACE, false);
    }

    public DirectoryLayer(boolean bl) {
        this(DEFAULT_NODE_SUBSPACE, DEFAULT_CONTENT_SUBSPACE, bl);
    }

    public DirectoryLayer(Subspace subspace, Subspace subspace2) {
        this(subspace, subspace2, false);
    }

    public DirectoryLayer(Subspace subspace, Subspace subspace2, boolean bl) {
        this.nodeSubspace = subspace;
        this.contentSubspace = subspace2;
        this.rootNode = subspace.get(subspace.getKey());
        this.allocator = new HighContentionAllocator(this.rootNode.get(HIGH_CONTENTION_KEY));
        this.allowManualPrefixes = bl;
    }

    public static Directory createWithNodeSubspace(Subspace subspace) {
        return new DirectoryLayer(subspace, DEFAULT_CONTENT_SUBSPACE);
    }

    public static Directory createWithContentSubspace(Subspace subspace) {
        return new DirectoryLayer(DEFAULT_NODE_SUBSPACE, subspace);
    }

    public static DirectoryLayer getDefault() {
        return defaultDirectoryLayer;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DirectoryLayer directoryLayer = (DirectoryLayer)object;
        return (this.path == directoryLayer.path || this.path.equals(directoryLayer.path)) && this.nodeSubspace.equals(directoryLayer.nodeSubspace) && this.contentSubspace.equals(directoryLayer.contentSubspace);
    }

    public int hashCode() {
        return this.path.hashCode() ^ this.nodeSubspace.hashCode() * 179 ^ this.contentSubspace.hashCode() * 937;
    }

    void setPath(List<String> list) {
        this.path = list;
    }

    @Override
    public List<String> getPath() {
        return Collections.unmodifiableList(this.path);
    }

    @Override
    public byte[] getLayer() {
        return EMPTY_BYTES;
    }

    @Override
    public DirectoryLayer getDirectoryLayer() {
        return this;
    }

    @Override
    public CompletableFuture<DirectorySubspace> createOrOpen(TransactionContext transactionContext, List<String> list, byte[] byArray) {
        return transactionContext.runAsync(transaction -> this.createOrOpenInternal((ReadTransaction)transaction, (Transaction)transaction, list, byArray, null, true, true));
    }

    @Override
    public CompletableFuture<DirectorySubspace> open(ReadTransactionContext readTransactionContext, List<String> list, byte[] byArray) {
        return readTransactionContext.readAsync(readTransaction -> this.createOrOpenInternal((ReadTransaction)readTransaction, null, list, byArray, null, false, true));
    }

    @Override
    public CompletableFuture<DirectorySubspace> create(TransactionContext transactionContext, List<String> list, byte[] byArray, byte[] byArray2) {
        return transactionContext.runAsync(transaction -> this.createOrOpenInternal((ReadTransaction)transaction, (Transaction)transaction, list, byArray, byArray2, true, false));
    }

    @Override
    public CompletableFuture<DirectorySubspace> moveTo(TransactionContext transactionContext, List<String> list) {
        CompletableFuture<DirectorySubspace> completableFuture = new CompletableFuture<DirectorySubspace>();
        completableFuture.completeExceptionally(new DirectoryMoveException("The root directory cannot be moved.", this.path, list));
        return completableFuture;
    }

    @Override
    public CompletableFuture<DirectorySubspace> move(TransactionContext transactionContext, List<String> list, List<String> list2) {
        ArrayList<String> arrayList = new ArrayList<String>(list);
        ArrayList<String> arrayList2 = new ArrayList<String>(list2);
        return transactionContext.runAsync(transaction -> ((CompletableFuture)this.checkOrWriteVersion((Transaction)transaction).thenComposeAsync(void_ -> {
            if (arrayList.size() <= arrayList2.size() && arrayList.equals(arrayList2.subList(0, arrayList.size()))) {
                throw new DirectoryMoveException("The destination directory cannot be a subdirectory of the source directory.", this.toAbsolutePath(arrayList), this.toAbsolutePath(arrayList2));
            }
            ArrayList arrayList = new ArrayList();
            arrayList.add(new NodeFinder(arrayList).find((ReadTransaction)transaction).thenComposeAsync((Function)new NodeMetadataLoader((ReadTransaction)transaction), transaction.getExecutor()));
            arrayList.add(new NodeFinder(arrayList2).find((ReadTransaction)transaction).thenComposeAsync((Function)new NodeMetadataLoader((ReadTransaction)transaction), transaction.getExecutor()));
            return AsyncUtil.getAll(arrayList);
        }, transaction.getExecutor())).thenComposeAsync(list3 -> {
            Node node = (Node)list3.get(0);
            Node node3 = (Node)list3.get(1);
            if (!node.exists()) {
                throw new NoSuchDirectoryException(this.toAbsolutePath(arrayList));
            }
            if (node.isInPartition(false) || node3.isInPartition(false)) {
                if (!(node.isInPartition(false) && node3.isInPartition(false) && node.path.equals(node3.path))) {
                    throw new DirectoryMoveException("Cannot move between partitions.", this.toAbsolutePath(arrayList), this.toAbsolutePath(arrayList2));
                }
                return node3.getContents().move((TransactionContext)transaction, node.getPartitionSubpath(), node3.getPartitionSubpath());
            }
            if (node3.exists()) {
                throw new DirectoryAlreadyExistsException(this.toAbsolutePath(arrayList2));
            }
            List<String> list4 = PathUtil.popBack(arrayList2);
            return new NodeFinder(list4).find((ReadTransaction)transaction).thenComposeAsync(node2 -> {
                if (!node2.exists()) {
                    throw new NoSuchDirectoryException(this.toAbsolutePath(list4));
                }
                transaction.set(node2.subspace.get(0L).get(DirectoryLayer.getLast(arrayList2)).getKey(), this.contentsOfNode(node.subspace, EMPTY_PATH, EMPTY_BYTES).getKey());
                return this.removeFromParent((Transaction)transaction, (List<String>)arrayList).thenApply(void_ -> this.contentsOfNode(node.subspace, arrayList2, node.layer));
            }, transaction.getExecutor());
        }, transaction.getExecutor()));
    }

    @Override
    public CompletableFuture<Void> remove(TransactionContext transactionContext, List<String> list) {
        return AsyncUtil.success(this.removeInternal(transactionContext, list, true));
    }

    @Override
    public CompletableFuture<Boolean> removeIfExists(TransactionContext transactionContext, List<String> list) {
        return this.removeInternal(transactionContext, list, false);
    }

    @Override
    public CompletableFuture<List<String>> list(ReadTransactionContext readTransactionContext, List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>(list);
        return readTransactionContext.readAsync(readTransaction -> ((CompletableFuture)this.checkVersion((ReadTransaction)readTransaction).thenComposeAsync(void_ -> new NodeFinder(arrayList).find((ReadTransaction)readTransaction).thenComposeAsync((Function)new NodeMetadataLoader((ReadTransaction)readTransaction), readTransaction.getExecutor()), readTransaction.getExecutor())).thenComposeAsync(node -> {
            if (!node.exists()) {
                throw new NoSuchDirectoryException(this.toAbsolutePath(arrayList));
            }
            if (node.isInPartition(true)) {
                return node.getContents().list((ReadTransactionContext)readTransaction, node.getPartitionSubpath());
            }
            Subspace subspace = node.subspace.get(0L);
            return AsyncUtil.collect(AsyncUtil.mapIterable(readTransaction.getRange(subspace.range()), keyValue -> subspace.unpack(keyValue.getKey()).getString(0)), readTransaction.getExecutor());
        }, readTransaction.getExecutor()));
    }

    @Override
    public CompletableFuture<Boolean> exists(ReadTransactionContext readTransactionContext) {
        return AsyncUtil.READY_TRUE;
    }

    @Override
    public CompletableFuture<Boolean> exists(ReadTransactionContext readTransactionContext, List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>(list);
        return readTransactionContext.readAsync(readTransaction -> ((CompletableFuture)this.checkVersion((ReadTransaction)readTransaction).thenComposeAsync(void_ -> new NodeFinder(arrayList).find((ReadTransaction)readTransaction).thenComposeAsync((Function)new NodeMetadataLoader((ReadTransaction)readTransaction), readTransaction.getExecutor()), readTransaction.getExecutor())).thenComposeAsync(node -> {
            if (!node.exists()) {
                return AsyncUtil.READY_FALSE;
            }
            if (node.isInPartition(false)) {
                return node.getContents().exists((ReadTransactionContext)readTransaction, node.getPartitionSubpath());
            }
            return AsyncUtil.READY_TRUE;
        }, readTransaction.getExecutor()));
    }

    private Subspace nodeWithPrefix(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        return this.nodeSubspace.get(byArray);
    }

    private CompletableFuture<Subspace> nodeContainingKey(ReadTransaction readTransaction, byte[] byArray) {
        if (ByteArrayUtil.startsWith(byArray, this.nodeSubspace.getKey())) {
            return CompletableFuture.completedFuture(this.rootNode);
        }
        return readTransaction.getRange(this.nodeSubspace.range().begin, ByteArrayUtil.join(this.nodeSubspace.pack(byArray), {0}), 1, true).asList().thenApply(list -> {
            byte[] byArray2;
            byte[] byArray3;
            if (list.size() > 0 && ByteArrayUtil.startsWith(byArray, byArray3 = this.nodeSubspace.unpack(byArray2 = ((KeyValue)list.get(0)).getKey()).getBytes(0))) {
                return this.nodeWithPrefix(byArray3);
            }
            return null;
        });
    }

    private List<String> toAbsolutePath(List<String> list) {
        return PathUtil.join(this.path, list);
    }

    private DirectorySubspace contentsOfNode(Subspace subspace, List<String> list, byte[] byArray) {
        byte[] byArray2 = this.nodeSubspace.unpack(subspace.getKey()).getBytes(0);
        if (Arrays.equals(byArray, PARTITION_LAYER)) {
            return new DirectoryPartition(this.toAbsolutePath(list), byArray2, this);
        }
        return new DirectorySubspace(this.toAbsolutePath(list), byArray2, this, byArray);
    }

    private CompletableFuture<Boolean> removeInternal(TransactionContext transactionContext, List<String> list, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>(list);
        return transactionContext.runAsync(transaction -> ((CompletableFuture)this.checkOrWriteVersion((Transaction)transaction).thenComposeAsync(void_ -> {
            if (arrayList.size() == 0) {
                throw new DirectoryException("The root directory cannot be removed.", this.toAbsolutePath(arrayList));
            }
            return new NodeFinder(arrayList).find((ReadTransaction)transaction).thenComposeAsync((Function)new NodeMetadataLoader((ReadTransaction)transaction), transaction.getExecutor());
        }, transaction.getExecutor())).thenComposeAsync(node -> {
            if (!node.exists()) {
                if (bl) {
                    throw new NoSuchDirectoryException(this.toAbsolutePath(arrayList));
                }
                return AsyncUtil.READY_FALSE;
            }
            if (node.isInPartition(false)) {
                return node.getContents().getDirectoryLayer().removeInternal((TransactionContext)transaction, node.getPartitionSubpath(), bl);
            }
            ArrayList<CompletableFuture<Void>> arrayList = new ArrayList<CompletableFuture<Void>>();
            arrayList.add(this.removeRecursive((Transaction)transaction, node.subspace));
            arrayList.add(this.removeFromParent((Transaction)transaction, (List<String>)arrayList));
            return AsyncUtil.tag(AsyncUtil.whenAll(arrayList), true);
        }, transaction.getExecutor()));
    }

    private CompletableFuture<Void> removeFromParent(Transaction transaction, List<String> list) {
        return new NodeFinder(PathUtil.popBack(list)).find(transaction).thenAccept(node -> transaction.clear(node.subspace.get(0L).get(DirectoryLayer.getLast(list)).getKey()));
    }

    private CompletableFuture<Void> removeRecursive(Transaction transaction, Subspace subspace) {
        Subspace subspace2 = subspace.get(0L);
        Iterator iterator = transaction.getRange(subspace2.range()).iterator();
        transaction.clear(Range.startsWith(this.nodeSubspace.unpack(subspace.getKey()).getBytes(0)));
        transaction.clear(subspace.range());
        return AsyncUtil.whileTrue(() -> this.lambda$removeRecursive$50((AsyncIterator)iterator, transaction), transaction.getExecutor());
    }

    private CompletableFuture<Boolean> isPrefixFree(ReadTransaction readTransaction, byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return AsyncUtil.READY_FALSE;
        }
        return this.nodeContainingKey(readTransaction, byArray).thenComposeAsync(subspace -> {
            if (subspace != null) {
                return AsyncUtil.READY_FALSE;
            }
            Iterator iterator = readTransaction.getRange(this.nodeSubspace.pack(byArray), this.nodeSubspace.pack(ByteArrayUtil.strinc(byArray)), 1).iterator();
            return iterator.onHasNext().thenApply(bl -> bl == false);
        }, readTransaction.getExecutor());
    }

    private CompletableFuture<byte[]> getVersionValue(ReadTransaction readTransaction) {
        return readTransaction.get(this.rootNode.pack(VERSION_KEY));
    }

    private CompletableFuture<Void> checkOrWriteVersion(Transaction transaction) {
        return this.getVersionValue(transaction).thenApply((Function)new WritableVersionCheck(transaction));
    }

    private CompletableFuture<Void> checkVersion(ReadTransaction readTransaction) {
        return this.getVersionValue(readTransaction).thenApply((Function)new VersionCheck());
    }

    private CompletableFuture<DirectorySubspace> createOrOpenInternal(ReadTransaction readTransaction, Transaction transaction, List<String> list, byte[] byArray, byte[] byArray2, boolean bl, boolean bl2) {
        ArrayList<String> arrayList = new ArrayList<String>(list);
        if (byArray2 != null && !this.allowManualPrefixes) {
            String string = this.path.size() == 0 ? "Cannot specify a prefix unless manual prefixes are enabled." : "Cannot specify a prefix in a partition.";
            CompletableFuture<DirectorySubspace> completableFuture = new CompletableFuture<DirectorySubspace>();
            completableFuture.completeExceptionally(new IllegalArgumentException(string));
            return completableFuture;
        }
        return ((CompletableFuture)this.checkVersion(readTransaction).thenComposeAsync(void_ -> {
            if (arrayList.size() == 0) {
                throw new IllegalArgumentException("The root directory may not be opened.");
            }
            return new NodeFinder(arrayList).find(readTransaction).thenComposeAsync((Function)new NodeMetadataLoader(readTransaction), readTransaction.getExecutor());
        }, readTransaction.getExecutor())).thenComposeAsync(node -> {
            if (node.exists()) {
                if (node.isInPartition(false)) {
                    List<String> list2 = node.getPartitionSubpath();
                    DirectoryLayer directoryLayer = node.getContents().getDirectoryLayer();
                    return directoryLayer.createOrOpenInternal(readTransaction, transaction, list2, byArray, byArray2, bl, bl2);
                }
                DirectorySubspace directorySubspace = this.openInternal((List<String>)arrayList, byArray, (Node)node, bl2);
                return CompletableFuture.completedFuture(directorySubspace);
            }
            return this.createInternal(transaction, arrayList, byArray, byArray2, bl);
        }, readTransaction.getExecutor());
    }

    private DirectorySubspace openInternal(List<String> list, byte[] byArray, Node node, boolean bl) {
        if (!bl) {
            throw new DirectoryAlreadyExistsException(this.toAbsolutePath(list));
        }
        if (byArray.length > 0 && !Arrays.equals(byArray, node.layer)) {
            throw new MismatchedLayerException(this.toAbsolutePath(list), node.layer, byArray);
        }
        return node.getContents();
    }

    private CompletableFuture<DirectorySubspace> createInternal(Transaction transaction, List<String> list, byte[] byArray, byte[] byArray2, boolean bl) {
        if (!bl) {
            throw new NoSuchDirectoryException(this.toAbsolutePath(list));
        }
        return ((CompletableFuture)this.checkOrWriteVersion(transaction).thenComposeAsync(void_ -> {
            if (byArray2 == null) {
                return this.allocator.allocate(transaction).thenComposeAsync(byArray -> {
                    byte[] byArray2 = ByteArrayUtil.join(this.contentSubspace.getKey(), byArray);
                    return transaction.getRange(Range.startsWith(byArray2), 1).iterator().onHasNext().thenApply(bl -> {
                        if (bl.booleanValue()) {
                            throw new IllegalStateException("The database has keys stored at the prefix chosen by the automatic prefix allocator: " + ByteArrayUtil.printable(byArray2) + ".");
                        }
                        return byArray2;
                    });
                }, transaction.getExecutor());
            }
            return CompletableFuture.completedFuture(byArray2);
        }, transaction.getExecutor())).thenComposeAsync(byArray3 -> ((CompletableFuture)this.isPrefixFree(byArray2 == null ? transaction.snapshot() : transaction, (byte[])byArray3).thenComposeAsync(bl -> {
            if (!bl.booleanValue()) {
                if (byArray2 == null) {
                    throw new IllegalStateException("The directory layer has manually allocated prefixes that conflict with the automatic prefix allocator.");
                }
                throw new IllegalArgumentException("Prefix already in use: " + ByteArrayUtil.printable(byArray3) + ".");
            }
            if (list.size() > 1) {
                return this.createOrOpen(transaction, PathUtil.popBack(list)).thenApply(directorySubspace -> this.nodeWithPrefix(directorySubspace.getKey()));
            }
            return CompletableFuture.completedFuture(this.rootNode);
        }, transaction.getExecutor())).thenApplyAsync(subspace -> {
            if (subspace == null) {
                throw new IllegalStateException("The parent directory does not exist.");
            }
            Subspace subspace2 = this.nodeWithPrefix((byte[])byArray3);
            transaction.set(subspace.get(0L).get(DirectoryLayer.getLast(list)).getKey(), (byte[])byArray3);
            transaction.set(subspace2.get(LAYER_KEY).getKey(), byArray);
            return this.contentsOfNode(subspace2, list, byArray);
        }, transaction.getExecutor()), transaction.getExecutor());
    }

    private static long unpackLittleEndian(byte[] byArray) {
        assert (byArray.length == 8);
        int n = 0;
        for (int i = 0; i < 8; ++i) {
            n += byArray[i] << i * 8;
        }
        return n;
    }

    private static String getLast(List<String> list) {
        assert (list.size() > 0);
        return list.get(list.size() - 1);
    }

    private /* synthetic */ CompletableFuture lambda$removeRecursive$50(AsyncIterator asyncIterator, Transaction transaction) {
        CompletableFuture<Void> completableFuture = asyncIterator.onHasNext().isDone() && asyncIterator.hasNext() ? this.removeRecursive(transaction, this.nodeWithPrefix(((KeyValue)asyncIterator.next()).getValue())) : AsyncUtil.DONE;
        return completableFuture.thenCompose(void_ -> asyncIterator.onHasNext());
    }

    private static class HighContentionAllocator {
        public final Subspace counters;
        public final Subspace recent;

        HighContentionAllocator(Subspace subspace) {
            this.counters = subspace.get(0);
            this.recent = subspace.get(1);
        }

        public CompletableFuture<byte[]> allocate(Transaction transaction) {
            return new PrefixFinder().find(transaction, this);
        }
    }

    private static class PrefixFinder {
        private final Random random = new Random();
        private long windowStart = 0L;
        private int windowSize;
        private long candidate;
        private boolean restart;

        PrefixFinder() {
        }

        public CompletableFuture<byte[]> find(Transaction transaction, HighContentionAllocator highContentionAllocator) {
            return AsyncUtil.whileTrue(() -> {
                Iterator iterator = transaction.snapshot().getRange(highContentionAllocator.counters.range(), 1, true).iterator();
                return ((CompletableFuture)((CompletableFuture)iterator.onHasNext().thenApply(arg_0 -> this.lambda$null$67((AsyncIterator)iterator, highContentionAllocator, arg_0))).thenComposeAsync(object -> this.chooseWindow(transaction, highContentionAllocator), transaction.getExecutor())).thenComposeAsync(void_ -> this.choosePrefix(transaction, highContentionAllocator), transaction.getExecutor());
            }, transaction.getExecutor()).thenApply(void_ -> Tuple.from(this.candidate).pack());
        }

        public CompletableFuture<Void> chooseWindow(Transaction transaction, HighContentionAllocator highContentionAllocator) {
            long l = this.windowStart;
            return AsyncUtil.whileTrue(() -> {
                byte[] byArray2 = highContentionAllocator.counters.get(this.windowStart).getKey();
                Range range = new Range(highContentionAllocator.counters.getKey(), byArray2);
                Range range2 = new Range(highContentionAllocator.recent.getKey(), highContentionAllocator.recent.get(this.windowStart).getKey());
                Class<HighContentionAllocator> clazz = HighContentionAllocator.class;
                synchronized (HighContentionAllocator.class) {
                    if (this.windowStart > l) {
                        transaction.clear(range);
                        transaction.options().setNextWriteNoWriteConflictRange();
                        transaction.clear(range2);
                    }
                    transaction.mutate(MutationType.ADD, byArray2, LITTLE_ENDIAN_LONG_ONE);
                    CompletableFuture<byte[]> completableFuture = transaction.snapshot().get(byArray2);
                    // ** MonitorExit[var9_7] (shouldn't be in output)
                    return completableFuture.thenApply(byArray -> {
                        long l = byArray == null ? 0L : DirectoryLayer.unpackLittleEndian(byArray);
                        this.windowSize = PrefixFinder.getWindowSize(this.windowStart);
                        if (l * 2L >= (long)this.windowSize) {
                            this.windowStart += (long)this.windowSize;
                            return true;
                        }
                        return false;
                    });
                }
            }, transaction.getExecutor());
        }

        public CompletableFuture<Boolean> choosePrefix(Transaction transaction, HighContentionAllocator highContentionAllocator) {
            this.restart = false;
            return AsyncUtil.whileTrue(() -> {
                this.candidate = this.windowStart + (long)this.random.nextInt(this.windowSize);
                byte[] byArray = highContentionAllocator.recent.get(this.candidate).getKey();
                Range range = highContentionAllocator.counters.range();
                Object object = HighContentionAllocator.class;
                synchronized (HighContentionAllocator.class) {
                    AsyncIterable<KeyValue> asyncIterable = transaction.snapshot().getRange(range, 1, true);
                    CompletableFuture<byte[]> completableFuture = transaction.get(byArray);
                    transaction.options().setNextWriteNoWriteConflictRange();
                    transaction.set(byArray, EMPTY_BYTES);
                    // ** MonitorExit[var7_5] (shouldn't be in output)
                    object = asyncIterable.asList();
                    CompletableFuture<byte[]> completableFuture2 = completableFuture;
                    return ((CompletableFuture)object).thenCombineAsync(completableFuture2, (list, byArray2) -> {
                        long l = 0L;
                        if (!list.isEmpty()) {
                            l = highContentionAllocator.counters.unpack(((KeyValue)list.get(0)).getKey()).getLong(0);
                        }
                        if (l > this.windowStart) {
                            this.restart = true;
                            return false;
                        }
                        if (byArray2 == null) {
                            transaction.addWriteConflictKey(byArray);
                            return false;
                        }
                        return true;
                    }, transaction.getExecutor());
                }
            }, transaction.getExecutor()).thenApply(void_ -> this.restart);
        }

        private static int getWindowSize(long l) {
            if (l < 255L) {
                return 64;
            }
            if (l < 65535L) {
                return 1024;
            }
            return 8192;
        }

        private /* synthetic */ Object lambda$null$67(AsyncIterator asyncIterator, HighContentionAllocator highContentionAllocator, Boolean bl) {
            if (bl.booleanValue()) {
                KeyValue keyValue = (KeyValue)asyncIterator.next();
                this.windowStart = highContentionAllocator.counters.unpack(keyValue.getKey()).getLong(0);
            }
            return null;
        }
    }

    private class Node {
        public final Subspace subspace;
        public final List<String> path;
        public final List<String> targetPath;
        public byte[] layer;
        private boolean loadedMetadata;

        Node(Subspace subspace, List<String> list, List<String> list2) {
            this.subspace = subspace;
            this.path = list;
            this.targetPath = list2;
            this.layer = null;
            this.loadedMetadata = false;
        }

        public boolean exists() {
            return this.subspace != null;
        }

        public CompletableFuture<Node> loadMetadata(ReadTransaction readTransaction) {
            if (!this.exists()) {
                this.loadedMetadata = true;
                return CompletableFuture.completedFuture(this);
            }
            return readTransaction.get(this.subspace.pack(new Tuple().add(LAYER_KEY))).thenApply(byArray -> {
                this.layer = byArray;
                this.loadedMetadata = true;
                return this;
            });
        }

        public void ensureMetadataLoaded() {
            if (!this.loadedMetadata) {
                throw new IllegalStateException("Metadata for node has not been loaded");
            }
        }

        public boolean isInPartition(boolean bl) {
            this.ensureMetadataLoaded();
            return this.exists() && Arrays.equals(this.layer, PARTITION_LAYER) && (bl || this.targetPath.size() > this.path.size());
        }

        public List<String> getPartitionSubpath() {
            this.ensureMetadataLoaded();
            return this.targetPath.subList(this.path.size(), this.targetPath.size());
        }

        public DirectorySubspace getContents() {
            this.ensureMetadataLoaded();
            return DirectoryLayer.this.contentsOfNode(this.subspace, this.path, this.layer);
        }
    }

    private static class NodeMetadataLoader
    implements Function<Node, CompletableFuture<Node>> {
        private final ReadTransaction tr;

        NodeMetadataLoader(ReadTransaction readTransaction) {
            this.tr = readTransaction;
        }

        @Override
        public CompletableFuture<Node> apply(Node node) {
            return node.loadMetadata(this.tr);
        }
    }

    private class NodeFinder {
        private List<String> path;
        private int index;
        private Node node;
        private List<String> currentPath;

        NodeFinder(List<String> list) {
            this.path = list;
        }

        public CompletableFuture<Node> find(ReadTransaction readTransaction) {
            this.index = 0;
            this.node = new Node(DirectoryLayer.this.rootNode, this.currentPath, this.path);
            this.currentPath = new ArrayList<String>();
            return AsyncUtil.whileTrue(() -> {
                if (this.index == this.path.size()) {
                    return AsyncUtil.READY_FALSE;
                }
                return readTransaction.get(this.node.subspace.get(0L).get(this.path.get(this.index)).getKey()).thenComposeAsync(byArray -> {
                    this.currentPath.add(this.path.get(this.index));
                    this.node = new Node(DirectoryLayer.this.nodeWithPrefix(byArray), this.currentPath, this.path);
                    if (!this.node.exists()) {
                        return AsyncUtil.READY_FALSE;
                    }
                    return this.node.loadMetadata(readTransaction).thenApply(node -> {
                        ++this.index;
                        return !Arrays.equals(this.node.layer, PARTITION_LAYER);
                    });
                }, readTransaction.getExecutor());
            }, readTransaction.getExecutor()).thenApply(void_ -> this.node);
        }
    }

    private class WritableVersionCheck
    extends VersionCheck {
        private final Transaction tr;

        private WritableVersionCheck(Transaction transaction) {
            this.tr = transaction;
        }

        @Override
        public Void apply(byte[] byArray) {
            if (byArray == null) {
                ByteBuffer byteBuffer = ByteBuffer.allocate(VERSION.length * 4);
                byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                Integer[] integerArray = VERSION;
                int n = integerArray.length;
                for (int i = 0; i < n; ++i) {
                    int n2 = integerArray[i];
                    byteBuffer.putInt(n2);
                }
                this.tr.set(DirectoryLayer.this.rootNode.pack(VERSION_KEY), byteBuffer.array());
                return null;
            }
            return super.apply(byArray);
        }

        @Override
        protected void throwOnError(Integer[] integerArray, String string, String string2) {
            super.throwOnError(integerArray, string, string2);
            if (integerArray[1] > VERSION[1]) {
                throw new DirectoryVersionException("Directory with " + string + " is read-only when opened with " + string2 + ".");
            }
        }
    }

    private class VersionCheck
    implements Function<byte[], Void> {
        private VersionCheck() {
        }

        @Override
        public Void apply(byte[] byArray) {
            if (byArray == null) {
                return null;
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            Integer[] integerArray = new Integer[3];
            for (int i = 0; i < integerArray.length; ++i) {
                integerArray[i] = byteBuffer.getInt();
            }
            String string = String.format("version %d.%d.%d", integerArray);
            String string2 = String.format("directory layer %d.%d.%d", VERSION);
            this.throwOnError(integerArray, string, string2);
            return null;
        }

        protected void throwOnError(Integer[] integerArray, String string, String string2) {
            if (integerArray[0] > VERSION[0]) {
                throw new DirectoryVersionException("Cannot load directory with " + string + " using " + string2 + ".");
            }
        }
    }
}

