/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.sqlserver;

import java.sql.SQLException;
import java.util.concurrent.Callable;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.exception.FlywaySqlException;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.database.sqlserver.SQLServerConnection;

public class SQLServerApplicationLockTemplate {
    private static final Log LOG = LogFactory.getLog(SQLServerApplicationLockTemplate.class);
    private final SQLServerConnection connection;
    private final JdbcTemplate jdbcTemplate;
    private final String databaseName;
    private final String lockName;

    SQLServerApplicationLockTemplate(SQLServerConnection connection, JdbcTemplate jdbcTemplate, String databaseName, int discriminator) {
        this.connection = connection;
        this.jdbcTemplate = jdbcTemplate;
        this.databaseName = databaseName;
        this.lockName = "Flyway-" + discriminator;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T execute(Callable<T> callable) {
        T t;
        try {
            this.connection.setCurrentDatabase(this.databaseName);
            this.jdbcTemplate.execute("EXEC sp_getapplock @Resource = ?, @LockTimeout='3600000', @LockMode = 'Exclusive', @LockOwner = 'Session'", new Object[]{this.lockName});
            t = callable.call();
        }
        catch (SQLException e) {
            try {
                throw new FlywaySqlException("Unable to acquire SQL Server application lock", e);
                catch (Exception e2) {
                    RuntimeException rethrow;
                    if (e2 instanceof RuntimeException) {
                        rethrow = (RuntimeException)e2;
                        throw rethrow;
                    }
                    rethrow = new FlywayException((Throwable)e2);
                    throw rethrow;
                }
            }
            catch (Throwable throwable) {
                try {
                    this.connection.setCurrentDatabase(this.databaseName);
                    this.jdbcTemplate.execute("EXEC sp_releaseapplock @Resource = ?, @LockOwner = 'Session'", new Object[]{this.lockName});
                    throw throwable;
                }
                catch (SQLException e3) {
                    LOG.error("Unable to release SQL Server application lock", (Exception)e3);
                }
                throw throwable;
            }
        }
        try {
            this.connection.setCurrentDatabase(this.databaseName);
            this.jdbcTemplate.execute("EXEC sp_releaseapplock @Resource = ?, @LockOwner = 'Session'", new Object[]{this.lockName});
            return t;
        }
        catch (SQLException e) {
            LOG.error("Unable to release SQL Server application lock", (Exception)e);
        }
        return t;
    }
}

