/*
 * Decompiled with CFR 0.152.
 */
package activiti;

import activiti.mappers.CustomMybatisMapper;
import org.activiti.engine.ManagementService;
import org.activiti.engine.impl.cmd.AbstractCustomSqlExecution;
import org.activiti.engine.impl.cmd.CustomSqlExecution;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;

@SpringBootApplication
public class Application {
    private static final Logger logger = LoggerFactory.getLogger(Application.class);

    @Bean
    CommandLineRunner customMybatisMapper(final ManagementService managementService) {
        return new CommandLineRunner(){

            public void run(String ... args) throws Exception {
                String processDefinitionId = (String)managementService.executeCustomSql((CustomSqlExecution)new AbstractCustomSqlExecution<CustomMybatisMapper, String>(CustomMybatisMapper.class){

                    public String execute(CustomMybatisMapper customMybatisMapper) {
                        return customMybatisMapper.loadProcessDefinitionIdByKey("waiter");
                    }
                });
                logger.info("Process definition id = {}", (Object)processDefinitionId);
            }
        };
    }

    @Bean
    CommandLineRunner customMybatisXmlMapper(final ManagementService managementService) {
        return new CommandLineRunner(){

            public void run(String ... args) throws Exception {
                String processDefinitionDeploymentId = (String)managementService.executeCommand((Command)new Command<String>(){

                    public String execute(CommandContext commandContext) {
                        return (String)commandContext.getDbSqlSession().selectOne("selectProcessDefinitionDeploymentIdByKey", (Object)"waiter");
                    }
                });
                logger.info("Process definition deployment id = {}", (Object)processDefinitionDeploymentId);
            }
        };
    }

    public static void main(String[] args) {
        SpringApplication.run(Application.class, (String[])args);
    }
}

