/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.compatibility.spring;

import org.activiti.compatibility.spring.DefaultFlowable5SpringCompatibilityHandler;
import org.flowable.engine.compatibility.Flowable5CompatibilityHandler;
import org.flowable.engine.compatibility.Flowable5CompatibilityHandlerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringFlowable5CompatibilityHandlerFactory
implements Flowable5CompatibilityHandlerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringFlowable5CompatibilityHandlerFactory.class);
    protected String compatibilityHandlerClassName;

    public Flowable5CompatibilityHandler createFlowable5CompatibilityHandler() {
        if (this.compatibilityHandlerClassName != null) {
            try {
                Flowable5CompatibilityHandler handler = (Flowable5CompatibilityHandler)Class.forName(this.compatibilityHandlerClassName).newInstance();
                return handler;
            }
            catch (Exception e) {
                LOGGER.info("Flowable 5 compatibility handler implementation not found or error during instantiation : {}. Flowable 5 backwards compatibility disabled.", (Object)e.getMessage());
            }
        } else {
            return new DefaultFlowable5SpringCompatibilityHandler();
        }
        return null;
    }

    public String getCompatibilityHandlerClassName() {
        return this.compatibilityHandlerClassName;
    }

    public void setCompatibilityHandlerClassName(String compatibilityHandlerClassName) {
        this.compatibilityHandlerClassName = compatibilityHandlerClassName;
    }
}

