/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.util;

import org.flowable.common.engine.api.FlowableException;
import org.flowable.engine.impl.event.EventHandler;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.CountingEntityUtil;
import org.flowable.eventsubscription.api.EventSubscription;
import org.flowable.eventsubscription.service.impl.persistence.entity.CompensateEventSubscriptionEntity;
import org.flowable.eventsubscription.service.impl.persistence.entity.EventSubscriptionEntity;
import org.flowable.job.service.JobService;
import org.flowable.job.service.impl.persistence.entity.JobEntity;

public class EventSubscriptionUtil {
    public static void eventReceived(EventSubscriptionEntity eventSubscriptionEntity, Object payload, boolean processASync) {
        if (processASync) {
            EventSubscriptionUtil.scheduleEventAsync(eventSubscriptionEntity, payload);
        } else {
            EventSubscriptionUtil.processEventSync(eventSubscriptionEntity, payload);
        }
    }

    protected static void processEventSync(EventSubscriptionEntity eventSubscriptionEntity, Object payload) {
        EventHandler eventHandler;
        if (eventSubscriptionEntity instanceof CompensateEventSubscriptionEntity) {
            CommandContextUtil.getEventSubscriptionService().deleteEventSubscription(eventSubscriptionEntity);
            CountingEntityUtil.handleDeleteEventSubscriptionEntityCount((EventSubscription)eventSubscriptionEntity);
        }
        if ((eventHandler = CommandContextUtil.getProcessEngineConfiguration().getEventHandler(eventSubscriptionEntity.getEventType())) == null) {
            throw new FlowableException("Could not find eventhandler for event of type '" + eventSubscriptionEntity.getEventType() + "'.");
        }
        eventHandler.handleEvent(eventSubscriptionEntity, payload, CommandContextUtil.getCommandContext());
    }

    protected static void scheduleEventAsync(EventSubscriptionEntity eventSubscriptionEntity, Object payload) {
        JobService jobService = CommandContextUtil.getJobService();
        JobEntity message = jobService.createJob();
        message.setJobType("message");
        message.setJobHandlerType("event");
        message.setElementId(eventSubscriptionEntity.getActivityId());
        message.setJobHandlerConfiguration(eventSubscriptionEntity.getId());
        message.setTenantId(eventSubscriptionEntity.getTenantId());
        jobService.scheduleAsyncJob(message);
    }
}

