/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.scripting;

import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.scripting.ScriptingEngines;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.Condition;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.variable.api.delegate.VariableScope;

public class ScriptCondition
implements Condition {
    private final String expression;
    private final String language;

    public ScriptCondition(String expression, String language) {
        this.expression = expression;
        this.language = language;
    }

    @Override
    public boolean evaluate(String sequenceFlowId, DelegateExecution execution) {
        ScriptingEngines scriptingEngines = CommandContextUtil.getProcessEngineConfiguration().getScriptingEngines();
        Object result = scriptingEngines.evaluate(this.expression, this.language, (VariableScope)execution);
        if (result == null) {
            throw new FlowableException("condition script returns null: " + this.expression);
        }
        if (!(result instanceof Boolean)) {
            throw new FlowableException("condition script returns non-Boolean: " + result + " (" + result.getClass().getName() + ")");
        }
        return (Boolean)result;
    }
}

