/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.persistence.entity;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.history.HistoryLevel;
import org.flowable.common.engine.impl.persistence.entity.data.DataManager;
import org.flowable.engine.history.HistoricDetail;
import org.flowable.engine.impl.HistoricDetailQueryImpl;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.entity.AbstractEntityManager;
import org.flowable.engine.impl.persistence.entity.ActivityInstanceEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.HistoricDetailEntity;
import org.flowable.engine.impl.persistence.entity.HistoricDetailEntityManager;
import org.flowable.engine.impl.persistence.entity.HistoricDetailVariableInstanceUpdateEntity;
import org.flowable.engine.impl.persistence.entity.HistoricFormPropertyEntity;
import org.flowable.engine.impl.persistence.entity.data.HistoricDetailDataManager;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;

public class HistoricDetailEntityManagerImpl
extends AbstractEntityManager<HistoricDetailEntity>
implements HistoricDetailEntityManager {
    protected HistoricDetailDataManager historicDetailDataManager;

    public HistoricDetailEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration, HistoricDetailDataManager historicDetailDataManager) {
        super(processEngineConfiguration);
        this.historicDetailDataManager = historicDetailDataManager;
    }

    @Override
    protected DataManager<HistoricDetailEntity> getDataManager() {
        return this.historicDetailDataManager;
    }

    @Override
    public HistoricFormPropertyEntity insertHistoricFormPropertyEntity(ExecutionEntity execution, String propertyId, String propertyValue, String taskId, Date createTime) {
        HistoricFormPropertyEntity historicFormPropertyEntity = this.historicDetailDataManager.createHistoricFormProperty();
        historicFormPropertyEntity.setProcessInstanceId(execution.getProcessInstanceId());
        historicFormPropertyEntity.setExecutionId(execution.getId());
        historicFormPropertyEntity.setTaskId(taskId);
        historicFormPropertyEntity.setPropertyId(propertyId);
        historicFormPropertyEntity.setPropertyValue(propertyValue);
        historicFormPropertyEntity.setTime(createTime);
        ActivityInstanceEntity activityInstance = this.getActivityInstanceEntityManager().findUnfinishedActivityInstance(execution);
        if (activityInstance == null) {
            throw new FlowableException("ActivityInstance not found for execution " + execution.getId());
        }
        String activityInstanceId = activityInstance.getId();
        historicFormPropertyEntity.setActivityInstanceId(activityInstanceId);
        this.insert(historicFormPropertyEntity);
        return historicFormPropertyEntity;
    }

    @Override
    public HistoricDetailVariableInstanceUpdateEntity copyAndInsertHistoricDetailVariableInstanceUpdateEntity(VariableInstanceEntity variableInstance, Date createTime) {
        HistoricDetailVariableInstanceUpdateEntity historicVariableUpdate = this.historicDetailDataManager.createHistoricDetailVariableInstanceUpdate();
        historicVariableUpdate.setProcessInstanceId(variableInstance.getProcessInstanceId());
        historicVariableUpdate.setExecutionId(variableInstance.getExecutionId());
        historicVariableUpdate.setTaskId(variableInstance.getTaskId());
        historicVariableUpdate.setTime(createTime);
        historicVariableUpdate.setRevision(variableInstance.getRevision());
        historicVariableUpdate.setName(variableInstance.getName());
        historicVariableUpdate.setVariableType(variableInstance.getType());
        historicVariableUpdate.setTextValue(variableInstance.getTextValue());
        historicVariableUpdate.setTextValue2(variableInstance.getTextValue2());
        historicVariableUpdate.setDoubleValue(variableInstance.getDoubleValue());
        historicVariableUpdate.setLongValue(variableInstance.getLongValue());
        if (variableInstance.getBytes() != null) {
            historicVariableUpdate.setBytes(variableInstance.getBytes());
        }
        this.insert(historicVariableUpdate);
        return historicVariableUpdate;
    }

    @Override
    public void delete(HistoricDetailEntity entity, boolean fireDeleteEvent) {
        HistoricDetailVariableInstanceUpdateEntity historicDetailVariableInstanceUpdateEntity;
        super.delete(entity, fireDeleteEvent);
        if (entity instanceof HistoricDetailVariableInstanceUpdateEntity && (historicDetailVariableInstanceUpdateEntity = (HistoricDetailVariableInstanceUpdateEntity)entity).getByteArrayRef() != null) {
            historicDetailVariableInstanceUpdateEntity.getByteArrayRef().delete();
        }
    }

    @Override
    public void deleteHistoricDetailsByProcessInstanceId(String historicProcessInstanceId) {
        if (this.getHistoryManager().isHistoryLevelAtLeast(HistoryLevel.AUDIT)) {
            List<HistoricDetailEntity> historicDetails = this.historicDetailDataManager.findHistoricDetailsByProcessInstanceId(historicProcessInstanceId);
            for (HistoricDetailEntity historicDetail : historicDetails) {
                this.delete(historicDetail);
            }
        }
    }

    @Override
    public long findHistoricDetailCountByQueryCriteria(HistoricDetailQueryImpl historicVariableUpdateQuery) {
        return this.historicDetailDataManager.findHistoricDetailCountByQueryCriteria(historicVariableUpdateQuery);
    }

    @Override
    public List<HistoricDetail> findHistoricDetailsByQueryCriteria(HistoricDetailQueryImpl historicVariableUpdateQuery) {
        return this.historicDetailDataManager.findHistoricDetailsByQueryCriteria(historicVariableUpdateQuery);
    }

    @Override
    public void deleteHistoricDetailsByTaskId(String taskId) {
        if (this.getHistoryManager().isHistoryLevelAtLeast(HistoryLevel.FULL)) {
            List<HistoricDetailEntity> details = this.historicDetailDataManager.findHistoricDetailsByTaskId(taskId);
            for (HistoricDetail historicDetail : details) {
                this.delete((HistoricDetailEntity)historicDetail);
            }
        }
    }

    @Override
    public List<HistoricDetail> findHistoricDetailsByNativeQuery(Map<String, Object> parameterMap) {
        return this.historicDetailDataManager.findHistoricDetailsByNativeQuery(parameterMap);
    }

    @Override
    public long findHistoricDetailCountByNativeQuery(Map<String, Object> parameterMap) {
        return this.historicDetailDataManager.findHistoricDetailCountByNativeQuery(parameterMap);
    }

    public HistoricDetailDataManager getHistoricDetailDataManager() {
        return this.historicDetailDataManager;
    }

    public void setHistoricDetailDataManager(HistoricDetailDataManager historicDetailDataManager) {
        this.historicDetailDataManager = historicDetailDataManager;
    }
}

