/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.flowable.common.engine.impl.util.CollectionUtil;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.CountingEntityUtil;
import org.flowable.engine.impl.util.EventSubscriptionUtil;
import org.flowable.eventsubscription.api.EventSubscription;
import org.flowable.eventsubscription.service.EventSubscriptionService;
import org.flowable.eventsubscription.service.impl.persistence.entity.CompensateEventSubscriptionEntity;
import org.flowable.eventsubscription.service.impl.persistence.entity.EventSubscriptionEntity;

public class ScopeUtil {
    public static void throwCompensationEvent(List<CompensateEventSubscriptionEntity> eventSubscriptions, DelegateExecution execution, boolean async) {
        ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager();
        for (EventSubscriptionEntity eventSubscriptionEntity : eventSubscriptions) {
            ExecutionEntity compensatingExecution = null;
            if (eventSubscriptionEntity.getConfiguration() != null) {
                compensatingExecution = (ExecutionEntity)executionEntityManager.findById(eventSubscriptionEntity.getConfiguration());
                compensatingExecution.setParent(compensatingExecution.getProcessInstance());
                compensatingExecution.setEventScope(false);
                continue;
            }
            compensatingExecution = executionEntityManager.createChildExecution((ExecutionEntity)execution);
            eventSubscriptionEntity.setConfiguration(compensatingExecution.getId());
        }
        Collections.sort(eventSubscriptions, new Comparator<EventSubscriptionEntity>(){

            @Override
            public int compare(EventSubscriptionEntity o1, EventSubscriptionEntity o2) {
                return o2.getCreated().compareTo(o1.getCreated());
            }
        });
        for (CompensateEventSubscriptionEntity compensateEventSubscriptionEntity : eventSubscriptions) {
            EventSubscriptionUtil.eventReceived((EventSubscriptionEntity)compensateEventSubscriptionEntity, null, async);
        }
    }

    public static void createCopyOfSubProcessExecutionForCompensation(ExecutionEntity subProcessExecution) {
        EventSubscriptionService eventSubscriptionService = CommandContextUtil.getEventSubscriptionService();
        List eventSubscriptions = eventSubscriptionService.findEventSubscriptionsByExecutionAndType(subProcessExecution.getId(), "compensate");
        ArrayList<CompensateEventSubscriptionEntity> compensateEventSubscriptions = new ArrayList<CompensateEventSubscriptionEntity>();
        for (EventSubscriptionEntity event : eventSubscriptions) {
            if (!(event instanceof CompensateEventSubscriptionEntity)) continue;
            compensateEventSubscriptions.add((CompensateEventSubscriptionEntity)event);
        }
        if (CollectionUtil.isNotEmpty(compensateEventSubscriptions)) {
            ExecutionEntity processInstanceExecutionEntity = subProcessExecution.getProcessInstance();
            ExecutionEntity eventScopeExecution = CommandContextUtil.getExecutionEntityManager().createChildExecution(processInstanceExecutionEntity);
            eventScopeExecution.setActive(false);
            eventScopeExecution.setEventScope(true);
            eventScopeExecution.setCurrentFlowElement(subProcessExecution.getCurrentFlowElement());
            Map variables = subProcessExecution.getVariablesLocal();
            for (Map.Entry variable : variables.entrySet()) {
                eventScopeExecution.setVariableLocal((String)variable.getKey(), variable.getValue(), subProcessExecution, true);
            }
            for (CompensateEventSubscriptionEntity eventSubscriptionEntity : compensateEventSubscriptions) {
                eventSubscriptionService.deleteEventSubscription((EventSubscriptionEntity)eventSubscriptionEntity);
                CountingEntityUtil.handleDeleteEventSubscriptionEntityCount((EventSubscription)eventSubscriptionEntity);
                EventSubscriptionEntity newSubscription = (EventSubscriptionEntity)eventSubscriptionService.createEventSubscriptionBuilder().eventType("compensate").executionId(eventScopeExecution.getId()).processInstanceId(eventScopeExecution.getProcessInstanceId()).activityId(eventSubscriptionEntity.getActivityId()).tenantId(eventScopeExecution.getTenantId()).create();
                CountingEntityUtil.handleInsertEventSubscriptionEntityCount((EventSubscription)newSubscription);
                newSubscription.setConfiguration(eventSubscriptionEntity.getConfiguration());
                newSubscription.setCreated(eventSubscriptionEntity.getCreated());
            }
            EventSubscriptionEntity eventSubscription = (EventSubscriptionEntity)eventSubscriptionService.createEventSubscriptionBuilder().eventType("compensate").executionId(processInstanceExecutionEntity.getId()).processInstanceId(processInstanceExecutionEntity.getProcessInstanceId()).activityId(eventScopeExecution.getCurrentFlowElement().getId()).tenantId(processInstanceExecutionEntity.getTenantId()).create();
            CountingEntityUtil.handleInsertEventSubscriptionEntityCount((EventSubscription)eventSubscription);
            eventSubscription.setConfiguration(eventScopeExecution.getId());
        }
    }
}

