# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
from typing import List, Optional
from datetime import date
from datetime import time
from datetime import datetime
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import *

__all__ = ['InterestAmountApplication']


class InterestAmountApplication(BaseDataClass):
  """
  A class to specify the application of Interest Amount with respect to the Delivery Amount and the Return Amount.
  """
  deliveryAmount: DeliveryAmount = Field(..., description="The application of Interest Amount with respect the Delivery Amount.")
  """
  The application of Interest Amount with respect the Delivery Amount.
  """
  returnAmount: ReturnAmount = Field(..., description="The application of Interest Amount with respect the Return Amount.")
  """
  The application of Interest Amount with respect the Return Amount.
  """

from cdm.product.collateral.DeliveryAmount import DeliveryAmount
from cdm.product.collateral.ReturnAmount import ReturnAmount

InterestAmountApplication.update_forward_refs()
