# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
from typing import List, Optional
from datetime import date
from datetime import time
from datetime import datetime
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import *

__all__ = ['CollateralInterestParameters']


class CollateralInterestParameters(BaseDataClass):
  """
  Represents the floating interest calculation and distribution parameters for a single currency.
  """
  currency: Optional[str] = Field(None, description="Specifies the currency for which the parameters are captured.")
  """
  Specifies the currency for which the parameters are captured.
  """
  interestCalculationFrequency: Optional[CalculationFrequency] = Field(None, description="Represents how often and when interest is calculated.")
  """
  Represents how often and when interest is calculated.
  """
  interestCalculationParameters: Optional[CollateralInterestCalculationParameters] = Field(None, description="Represents the basic interest calculation parameters.")
  """
  Represents the basic interest calculation parameters.
  """
  interestHandlingParameters: Optional[CollateralInterestHandlingParameters] = Field(None, description="Represents the parameters describing how and when interest transfer occurs.")
  """
  Represents the parameters describing how and when interest transfer occurs.
  """
  marginType: Optional[CollateralMarginTypeEnum] = Field(None, description="Specifies the type of margin for which interest is being calculated, if the parameters are different depending on type of margin (initial or variation).")
  """
  Specifies the type of margin for which interest is being calculated, if the parameters are different depending on type of margin (initial or variation).
  """
  postingParty: Optional[CounterpartyRoleEnum] = Field(None, description="Represents the party to which these parameters apply (the applicable party). In other words, if the parameters are different depending on which party is posting/holding the collateral, for which party to the Collateral Agreement (Party 1 or Party 2) that is posting the collateral do these parameters apply?")
  """
  Represents the party to which these parameters apply (the applicable party).  In other words, if the parameters are different depending on which party is posting/holding the collateral, for which party to the Collateral Agreement (Party 1 or Party 2) that is posting the collateral do these parameters apply?
  """

from cdm.base.datetime.CalculationFrequency import CalculationFrequency
from cdm.product.collateral.CollateralInterestCalculationParameters import CollateralInterestCalculationParameters
from cdm.product.collateral.CollateralInterestHandlingParameters import CollateralInterestHandlingParameters
from cdm.product.collateral.CollateralMarginTypeEnum import CollateralMarginTypeEnum
from cdm.base.staticdata.party.CounterpartyRoleEnum import CounterpartyRoleEnum

CollateralInterestParameters.update_forward_refs()
