# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
from typing import List, Optional
from datetime import date
from datetime import time
from datetime import datetime
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import *

__all__ = ['CollateralInterestNotification']


class CollateralInterestNotification(BaseDataClass):
  """
  Represents the parameters describing when notifications should be made for required collateral interest transfers.
  """
  notificationDayType: DayTypeEnum = Field(..., description="The type of days on which notification should occur.")
  """
  The type of days on which notification should occur.
  """
  notificationTime: time = Field(..., description="Specifies the time of day that the notification should occur.")
  """
  Specifies the time of day that the notification should occur.
  """
  offset: Decimal = Field(..., description="Specifies the number of days before (negative) or after (positive) the trigger event.")
  """
  Specifies the number of days before (negative) or after (positive) the trigger event.
  """
  trigger: str = Field(..., description="Specifies what triggers notification (should be enum) Interest Statement Frequency, Period End Date.")
  """
  Specifies what triggers notification (should be enum) Interest Statement Frequency, Period End Date.
  """

from cdm.base.datetime.DayTypeEnum import DayTypeEnum

CollateralInterestNotification.update_forward_refs()
