from enum import Enum

all = ['CollateralInterestHandlingEnum']
  
class CollateralInterestHandlingEnum(Enum):
  """
  How is collateral interest to be handled?
  """
  ADJUST = "ADJUST"
  """
   Adjust the collateral balance to include the interest amount 
  """
  TRANSFER = "TRANSFER"
  """
   Transfer the interest each period 
  """
  TRANSFER_OR_ADJUST = "TRANSFER_OR_ADJUST"
  """
   Transfer the interest if it meets certain criteria, or otherwise adjust the collateral balance to reflect the interest amount  
  """
