from enum import Enum

all = ['AlternativeToInterestAmountEnum']
  
class AlternativeToInterestAmountEnum(Enum):
  """
  If there is an alternative to interest amounts, how is it specified?
  """
  ACTUAL_AMOUNT_RECEIVED = "ACTUAL_AMOUNT_RECEIVED"
  """
  The standard calculation of the Interest Amount is replaced with the amount of interest the secured party actually receives in relation to the Cash collateral.
  """
  OTHER = "OTHER"
  """
  An other alternative option outside these choices that can be described as an alternative provision.
  """
  STANDARD = "STANDARD"
  """
  Interest amount is not transferred if transfer would create or increase a delivery amount.
  """
  TRANSFER_IF_DELIVERY_AMOUNT_BELOW_MTA = "TRANSFER_IF_DELIVERY_AMOUNT_BELOW_MTA"
  """
  Interest amount is not transferred if transfer would create or increase a delivery amount. (This is the 'Standard' provision). However, interest Amount will be transferred if Delivery Amount is below Minimum Transfer Amount.
  """
