from enum import Enum

all = ['InformationProviderEnum']
  
class InformationProviderEnum(Enum):
  """
  The enumerated values to specify the list of information providers.
  """
  ASSOC_BANKS_SINGAPORE = "ASSOC_BANKS_SINGAPORE"
  """
  The Association of Banks in Singapore.
  """
  BANCO_CENTRAL_CHILE = "BANCO_CENTRAL_CHILE"
  """
  The central bank of Chile.
  """
  BANK_OF_CANADA = "BANK_OF_CANADA"
  """
  The central bank of Canada.
  """
  BANK_OF_ENGLAND = "BANK_OF_ENGLAND"
  """
  The Bank Of England.
  """
  BANK_OF_JAPAN = "BANK_OF_JAPAN"
  """
  The central bank of Japan.
  """
  BLOOMBERG = "BLOOMBERG"
  """
  Bloomberg LP.
  """
  EURO_CENTRAL_BANK = "EURO_CENTRAL_BANK"
  """
  The European Central Bank.
  """
  FHLBSF = "FHLBSF"
  """
  The Federal Home Loan Bank of San Francisco, or its successor.
  """
  FEDERAL_RESERVE = "FEDERAL_RESERVE"
  """
  The Federal Reserve, the central bank of the United States.
  """
  ICESWAP = "ICESWAP"
  """
  ICESWAP Rate Administrator which means ICE Benchmark Administration, or any successor thereto, as administrator of the ICE Swap Rate.
  """
  ISDA = "ISDA"
  """
  International Swaps and Derivatives Association, Inc.
  """
  REFINITIV = "REFINITIV"
  """
  Refinitiv, formerly Thomson Reuters Financial & Risk.
  """
  RESERVE_BANK_AUSTRALIA = "RESERVE_BANK_AUSTRALIA"
  """
  The Reserve Bank of Australia.
  """
  RESERVE_BANK_NEW_ZEALAND = "RESERVE_BANK_NEW_ZEALAND"
  """
  The Reserve Bank of New Zealand.
  """
  REUTERS = "REUTERS"
  """
  Reuters Group Plc.
  """
  SAFEX = "SAFEX"
  """
  South African Futures Exchange, or its successor.
  """
  TOKYOSWAP = "TOKYOSWAP"
  """
  The Tokyo Swap Reference Rate (or TSR) Administrator, which means Refinitiv Asia Pacific Limited, or any successor thereto, as administrator of the TSR.
  """
  TELERATE = "TELERATE"
  """
  Telerate, Inc.
  """
