from enum import Enum

all = ['MasterConfirmationAnnexTypeEnum']
  
class MasterConfirmationAnnexTypeEnum(Enum):
  """
  The enumerated values to specify the type of annex to be used with master confirmation agreement governing the transaction.
  """
  ISDA_2004_INDEX_VARIANCE_SWAP_AMERICAS_INTERDEALER = "ISDA_2004_INDEX_VARIANCE_SWAP_AMERICAS_INTERDEALER"
  """
  The Index Variance Swap 2004 Annex to the ISDA 2004 Americas Interdealer Master Equity Derivatives Confirmation Agreement and to the Revised ISDA 2004 Americas Interdealer Master Equity Derivatives Confirmation Agreement applies.
  """
  ISDA_2004_SHARE_VARIANCE_SWAP_AMERICAS_INTERDEALER = "ISDA_2004_SHARE_VARIANCE_SWAP_AMERICAS_INTERDEALER"
  """
  The Share Variance Swap 2004 Annex to the ISDA 2004 Americas Interdealer Master Equity Derivatives Confirmation Agreement and to the Revised ISDA 2004 Americas Interdealer Master Equity Derivatives Confirmation Agreement applies.
  """
  ISDA_2007_DISPERSION_VARIANCE_SWAP_EUROPEAN = "ISDA_2007_DISPERSION_VARIANCE_SWAP_EUROPEAN"
  """
  The Dispersion Variance Swap Annex to the Revised 2007 ISDA European Variance Swap Master Confirmation Agreement applies.
  """
  ISDA_2007_EQUITY_FINANCE_SWAP_EUROPEAN = "ISDA_2007_EQUITY_FINANCE_SWAP_EUROPEAN"
  """
  The EFS (Equity Share Finance Swap) 2007 Annex to the ISDA 2007 European Master Equity Derivatives Confirmation Agreement applies.
  """
  ISDA_2007_INDEX_VARIANCE_SWAP_AMERICAS_INTERDEALER = "ISDA_2007_INDEX_VARIANCE_SWAP_AMERICAS_INTERDEALER"
  """
  The Index Variance Swap 2007 Annex to the Revised ISDA 2004 Americas Interdealer Master Equity Derivatives Confirmation Agreement applies.
  """
  ISDA_2007_SHARE_VARIANCE_SWAP_AMERICAS_INTERDEALER = "ISDA_2007_SHARE_VARIANCE_SWAP_AMERICAS_INTERDEALER"
  """
  The Share Variance Swap 2007 Annex to the Revised ISDA 2004 Americas Interdealer Master Equity Derivatives Confirmation Agreement applies.
  """
  ISDA_2007_VARIANCE_OPTION_EUROPEAN = "ISDA_2007_VARIANCE_OPTION_EUROPEAN"
  """
  The Variance Option Standard Terms Appendix to the Revised ISDA 2007 European Variance Swap Master Confirmation Agreement applies.
  """
  ISDA_2008_EQUITY_FINANCE_SWAP_ASIA_EXCLUDING_JAPAN = "ISDA_2008_EQUITY_FINANCE_SWAP_ASIA_EXCLUDING_JAPAN"
  """
  The Cash-settled Open Market EFS (Equity Finance Share Swap) 2008 Annex to the ISDA 2008 AEJ (Asia Excluding Japan) Master Equity Derivatives Confirmation Agreement applies.
  """
  ISDA_2008_EQUITY_FINANCE_SWAP_ASIA_EXCLUDING_JAPAN_REV_1 = "ISDA_2008_EQUITY_FINANCE_SWAP_ASIA_EXCLUDING_JAPAN_REV_1"
  """
  The Cash-settled Open Market EFS (Equity Finance Share Swap) Annex to the Revised ISDA 2008 AEJ (Asia Excluding Japan) Master Equity Derivatives Confirmation Agreement applies.
  """
  ISDA_2008_EQUITY_OPTION_ASIA_EXCLUDING_JAPAN = "ISDA_2008_EQUITY_OPTION_ASIA_EXCLUDING_JAPAN"
  """
  The Open Market Equity Option 2008 Annex to the ISDA 2008 AEJ (Asia Excluding Japan) Master Equity Derivatives Confirmation Agreement applies.
  """
  ISDA_2008_EQUITY_OPTION_ASIA_EXCLUDING_JAPAN_REV_1 = "ISDA_2008_EQUITY_OPTION_ASIA_EXCLUDING_JAPAN_REV_1"
  """
  The Open Market Equity Option Annex to the Revised ISDA 2008 AEJ (Asia Excluding Japan) Master Equity Derivatives Confirmation Agreement applies.
  """
  ISDA_2008_EQUITY_OPTION_JAPAN = "ISDA_2008_EQUITY_OPTION_JAPAN"
  """
  The Equity Option 2008 Annex to the ISDA 2008 Japanese Master Equity Derivatives Confirmation Agreement applies.
  """
  ISDA_2009_CLOSED_MARKETS_OPTIONS_ASIA_EXCLUDING_JAPAN = "ISDA_2009_CLOSED_MARKETS_OPTIONS_ASIA_EXCLUDING_JAPAN"
  """
  The Cash-settled Closed Market Index and Share Options 2009 Annex to the Revised ISDA 2008 AEJ (Asia Excluding Japan) Master Equity Derivatives Confirmation Agreement applies.
  """
  ISDA_2009_EQUITY_EUROPEAN_IS = "ISDA_2009_EQUITY_EUROPEAN_IS"
  """
  The Index Swap 2009 Annex to the ISDA 2007 European Master Equity Derivatives Confirmation Agreement applies.
  """
  ISDA_2009_EQUITY_EUROPEAN_INTERDEALER_SS = "ISDA_2009_EQUITY_EUROPEAN_INTERDEALER_SS"
  """
  The Interdealer Share Swap 2009 Annex to the ISDA 2009 European Interdealer Master Equity Derivatives Confirmation Agreement applies.
  """
  ISDA_2009_INDEX_SHARE_OPTION_AMERICAS = "ISDA_2009_INDEX_SHARE_OPTION_AMERICAS"
  """
  The Index and Share Options 2009 Annex to the ISDA 2009 Americas Master Equity Derivatives Confirmation Agreement applies.
  """
  ISDA_2009_INDEX_SWAP_EUROPEAN_INTERDEALER = "ISDA_2009_INDEX_SWAP_EUROPEAN_INTERDEALER"
  """
  The Interdealer Index Swap 2009 Annex to the ISDA 2009 European Interdealer Master Equity Derivatives Confirmation Agreement applies.
  """
  ISDA_2009_INDEX_SWAP_PAN_ASIA_INTERDEALER = "ISDA_2009_INDEX_SWAP_PAN_ASIA_INTERDEALER"
  """
  The Index Swap 2009 Annex to the ISDA 2009 Pan-Asia Interdealer Master Equity Derivatives Confirmation Agreement applies.
  """
  ISDA_2009_SHARE_SWAP_PAN_ASIA = "ISDA_2009_SHARE_SWAP_PAN_ASIA"
  """
  The Share Swap 2009 Annex to the ISDA 2009 Pan-Asia Interdealer Master Equity Derivatives Confirmation Agreement applies.
  """
  ISDA_2010_FAIR_VALUE_SHARE_SWAP_EUROPEAN_INTERDEALER = "ISDA_2010_FAIR_VALUE_SHARE_SWAP_EUROPEAN_INTERDEALER"
  """
  The Fair Value Interdealer Share Swap 2010 Annex to the ISDA 2009 European Interdealer Master Equity Derivatives Confirmation Agreement applies.
  """
  ISDA_2010_INDEX_SHARE_OPTION_EMEA_INTERDEALER = "ISDA_2010_INDEX_SHARE_OPTION_EMEA_INTERDEALER"
  """
  The Cash-settled Index Option/Cash/Physically-settled Share Option 2010 Annex to the ISDA 2010 EMEA EM Interdealer Master Equity Derivatives Confirmation Agreement applies.
  """
