from enum import Enum

all = ['MatrixTermEnum']
  
class MatrixTermEnum(Enum):
  """
  The enumerated values to specify a scheme of transaction types specified in the Equity Derivatives Settlement Matrix.
  """
  ASIA_CORPORATE = "ASIA_CORPORATE"
  """
  Matrix Transaction Type of ASIA CORPORATE.
  """
  ASIA_FINANCIAL_CORPORATE = "ASIA_FINANCIAL_CORPORATE"
  """
  Matrix Transaction Type of ASIA FINANCIAL CORPORATE.
  """
  ASIA_SOVEREIGN = "ASIA_SOVEREIGN"
  """
  Matrix Transaction Type of ASIA SOVEREIGN.
  """
  AUSTRALIA_CORPORATE = "AUSTRALIA_CORPORATE"
  """
  Matrix Transaction Type of AUSTRALIA CORPORATE.
  """
  AUSTRALIA_FINANCIAL_CORPORATE = "AUSTRALIA_FINANCIAL_CORPORATE"
  """
  Matrix Transaction Type of AUSTRALIA FINANCIAL CORPORATE.
  """
  AUSTRALIA_SOVEREIGN = "AUSTRALIA_SOVEREIGN"
  """
  Matrix Transaction Type of AUSTRALIA SOVEREIGN.
  """
  EMERGING_EUROPEAN_AND_MIDDLE_EASTERN_SOVEREIGN = "EMERGING_EUROPEAN_AND_MIDDLE_EASTERN_SOVEREIGN"
  """
  Matrix Transaction Type of EMERGING EUROPEAN AND MIDDLE EASTERN SOVEREIGN.
  """
  EMERGING_EUROPEAN_CORPORATE = "EMERGING_EUROPEAN_CORPORATE"
  """
  Matrix Transaction Type of EMERGING EUROPEAN CORPORATE.
  """
  EMERGING_EUROPEAN_CORPORATE_LPN = "EMERGING_EUROPEAN_CORPORATE_LPN"
  """
  Matrix Transaction Type of EMERGING EUROPEAN CORPORATE LPN.
  """
  EMERGING_EUROPEAN_FINANCIAL_CORPORATE = "EMERGING_EUROPEAN_FINANCIAL_CORPORATE"
  """
  Matrix Transaction Type of EMERGING EUROPEAN FINANCIAL CORPORATE.
  """
  EMERGING_EUROPEAN_FINANCIAL_CORPORATE_LPN = "EMERGING_EUROPEAN_FINANCIAL_CORPORATE_LPN"
  """
  Matrix Transaction Type of EMERGING EUROPEAN FINANCIAL CORPORATE LPN.
  """
  EUROPEAN_CO_CO_FINANCIAL_CORPORATE = "EUROPEAN_CO_CO_FINANCIAL_CORPORATE"
  """
  Matrix Transaction Type of EUROPEAN COCO FINANCIAL CORPORATE.
  """
  EUROPEAN_CORPORATE = "EUROPEAN_CORPORATE"
  """
  Matrix Transaction Type of EUROPEAN CORPORATE.
  """
  EUROPEAN_FINANCIAL_CORPORATE = "EUROPEAN_FINANCIAL_CORPORATE"
  """
  Matrix Transaction Type of EUROPEAN FINANCIAL CORPORATE.
  """
  EUROPEAN_SENIOR_NON_PREFERRED_FINANCIAL_CORPORATE = "EUROPEAN_SENIOR_NON_PREFERRED_FINANCIAL_CORPORATE"
  """
  Matrix Transaction Type of EUROPEAN SENIOR NON PREFERRED FINANCIAL CORPORATE.
  """
  IVS_1_OPEN_MARKETS = "IVS_1_OPEN_MARKETS"
  """
  The ISDA-published 2011 Index Volatility Swap Agreement for Open Markets.
  """
  JAPAN_CORPORATE = "JAPAN_CORPORATE"
  """
  Matrix Transaction Type of JAPAN CORPORATE.
  """
  JAPAN_FINANCIAL_CORPORATE = "JAPAN_FINANCIAL_CORPORATE"
  """
  Matrix Transaction Type of JAPAN FINANCIAL CORPORATE.
  """
  JAPAN_SOVEREIGN = "JAPAN_SOVEREIGN"
  """
  Matrix Transaction Type of JAPAN SOVEREIGN.
  """
  LATIN_AMERICA_CORPORATE = "LATIN_AMERICA_CORPORATE"
  """
  Matrix Transaction Type of LATIN AMERICA CORPORATE.
  """
  LATIN_AMERICA_CORPORATE_BOND = "LATIN_AMERICA_CORPORATE_BOND"
  """
  Matrix Transaction Type of LATIN AMERICA CORPORATE B.
  """
  LATIN_AMERICA_CORPORATE_BOND_OR_LOAN = "LATIN_AMERICA_CORPORATE_BOND_OR_LOAN"
  """
  Matrix Transaction Type of LATIN AMERICA CORPORATE BL.
  """
  LATIN_AMERICA_FINANCIAL_CORPORATE_BOND = "LATIN_AMERICA_FINANCIAL_CORPORATE_BOND"
  """
  Matrix Transaction Type of LATIN AMERICA FINANCIAL CORPORATE B.
  """
  LATIN_AMERICA_FINANCIAL_CORPORATE_BOND_OR_LOAN = "LATIN_AMERICA_FINANCIAL_CORPORATE_BOND_OR_LOAN"
  """
  Matrix Transaction Type of LATIN AMERICA FINANCIAL CORPORATE BL.
  """
  LATIN_AMERICA_SOVEREIGN = "LATIN_AMERICA_SOVEREIGN"
  """
  Matrix Transaction Type of LATIN AMERICA SOVEREIGN.
  """
  NEW_ZEALAND_CORPORATE = "NEW_ZEALAND_CORPORATE"
  """
  Matrix Transaction Type of NEW ZEALAND CORPORATE.
  """
  NEW_ZEALAND_FINANCIAL_CORPORATE = "NEW_ZEALAND_FINANCIAL_CORPORATE"
  """
  Matrix Transaction Type of NEW ZEALAND FINANCIAL CORPORATE.
  """
  NEW_ZEALAND_SOVEREIGN = "NEW_ZEALAND_SOVEREIGN"
  """
  Matrix Transaction Type of NEW ZEALAND SOVEREIGN.
  """
  NORTH_AMERICAN_CORPORATE = "NORTH_AMERICAN_CORPORATE"
  """
  Matrix Transaction Type of NORTH AMERICAN CORPORATE.
  """
  NORTH_AMERICAN_FINANCIAL_CORPORATE = "NORTH_AMERICAN_FINANCIAL_CORPORATE"
  """
  Matrix Transaction Type of NORTH AMERICAN FINANCIAL CORPORATE.
  """
  SINGAPORE_CORPORATE = "SINGAPORE_CORPORATE"
  """
  Matrix Transaction Type of SINGAPORE CORPORATE.
  """
  SINGAPORE_FINANCIAL_CORPORATE = "SINGAPORE_FINANCIAL_CORPORATE"
  """
  Matrix Transaction Type of SINGAPORE FINANCIAL CORPORATE.
  """
  SINGAPORE_SOVEREIGN = "SINGAPORE_SOVEREIGN"
  """
  Matrix Transaction Type of SINGAPORE SOVEREIGN.
  """
  STANDARD_ASIA_CORPORATE = "STANDARD_ASIA_CORPORATE"
  """
  Matrix Transaction Type of STANDARD ASIA CORPORATE.
  """
  STANDARD_ASIA_FINANCIAL_CORPORATE = "STANDARD_ASIA_FINANCIAL_CORPORATE"
  """
  Matrix Transaction Type of STANDARD ASIA FINANCIAL CORPORATE.
  """
  STANDARD_ASIA_SOVEREIGN = "STANDARD_ASIA_SOVEREIGN"
  """
  Matrix Transaction Type of STANDARD ASIA SOVEREIGN.
  """
  STANDARD_AUSTRALIA_CORPORATE = "STANDARD_AUSTRALIA_CORPORATE"
  """
  Matrix Transaction Type of STANDARD AUSTRALIA CORPORATE.
  """
  STANDARD_AUSTRALIA_FINANCIAL_CORPORATE = "STANDARD_AUSTRALIA_FINANCIAL_CORPORATE"
  """
  Matrix Transaction Type of STANDARD AUSTRALIA FINANCIAL CORPORATE.
  """
  STANDARD_AUSTRALIA_SOVEREIGN = "STANDARD_AUSTRALIA_SOVEREIGN"
  """
  Matrix Transaction Type of STANDARD AUSTRALIA SOVEREIGN.
  """
  STANDARD_EMERGING_EUROPEAN_AND_MIDDLE_EASTERN_SOVEREIGN = "STANDARD_EMERGING_EUROPEAN_AND_MIDDLE_EASTERN_SOVEREIGN"
  """
  Matrix Transaction Type of STANDARD EMERGING EUROPEAN AND MIDDLE EASTERN SOVEREIGN.
  """
  STANDARD_EMERGING_EUROPEAN_CORPORATE = "STANDARD_EMERGING_EUROPEAN_CORPORATE"
  """
  Matrix Transaction Type of STANDARD EMERGING EUROPEAN CORPORATE.
  """
  STANDARD_EMERGING_EUROPEAN_CORPORATE_LPN = "STANDARD_EMERGING_EUROPEAN_CORPORATE_LPN"
  """
  Matrix Transaction Type of STANDARD EMERGING EUROPEAN CORPORATE LPN.
  """
  STANDARD_EMERGING_EUROPEAN_FINANCIAL_CORPORATE = "STANDARD_EMERGING_EUROPEAN_FINANCIAL_CORPORATE"
  """
  Matrix Transaction Type of STANDARD EMERGING EUROPEAN FINANCIAL CORPORATE.
  """
  STANDARD_EMERGING_EUROPEAN_FINANCIAL_CORPORATE_LPN = "STANDARD_EMERGING_EUROPEAN_FINANCIAL_CORPORATE_LPN"
  """
  Matrix Transaction Type of STANDARD EMERGING EUROPEAN FINANCIAL CORPORATE LPN.
  """
  STANDARD_EUROPEAN_CO_CO_FINANCIAL_CORPORATE = "STANDARD_EUROPEAN_CO_CO_FINANCIAL_CORPORATE"
  """
  Matrix Transaction Type of STANDARD EUROPEAN COCO FINANCIAL CORPORATE.
  """
  STANDARD_EUROPEAN_CORPORATE = "STANDARD_EUROPEAN_CORPORATE"
  """
  Matrix Transaction Type of STANDARD EUROPEAN CORPORATE.
  """
  STANDARD_EUROPEAN_FINANCIAL_CORPORATE = "STANDARD_EUROPEAN_FINANCIAL_CORPORATE"
  """
  Matrix Transaction Type of STANDARD EUROPEAN FINANCIAL CORPORATE.
  """
  STANDARD_EUROPEAN_SENIOR_NON_PREFERRED_FINANCIAL_CORPORATE = "STANDARD_EUROPEAN_SENIOR_NON_PREFERRED_FINANCIAL_CORPORATE"
  """
  Matrix Transaction Type of STANDARD EUROPEAN SENIOR NON PREFERRED FINANCIAL CORPORATE.
  """
  STANDARD_JAPAN_CORPORATE = "STANDARD_JAPAN_CORPORATE"
  """
  Matrix Transaction Type of STANDARD JAPAN CORPORATE.
  """
  STANDARD_JAPAN_FINANCIAL_CORPORATE = "STANDARD_JAPAN_FINANCIAL_CORPORATE"
  """
  Matrix Transaction Type of STANDARD JAPAN FINANCIAL CORPORATE.
  """
  STANDARD_JAPAN_SOVEREIGN = "STANDARD_JAPAN_SOVEREIGN"
  """
  Matrix Transaction Type of STANDARD JAPAN SOVEREIGN.
  """
  STANDARD_LATIN_AMERICA_CORPORATE_BOND = "STANDARD_LATIN_AMERICA_CORPORATE_BOND"
  """
  Matrix Transaction Type of STANDARD LATIN AMERICA CORPORATE B.
  """
  STANDARD_LATIN_AMERICA_CORPORATE_BOND_OR_LOAN = "STANDARD_LATIN_AMERICA_CORPORATE_BOND_OR_LOAN"
  """
  Matrix Transaction Type of STANDARD LATIN AMERICA CORPORATE BL.
  """
  STANDARD_LATIN_AMERICA_FINANCIAL_CORPORATE_BOND = "STANDARD_LATIN_AMERICA_FINANCIAL_CORPORATE_BOND"
  """
  Matrix Transaction Type of STANDARD LATIN AMERICA FINANCIAL CORPORATE B.
  """
  STANDARD_LATIN_AMERICA_FINANCIAL_CORPORATE_BOND_OR_LOAN = "STANDARD_LATIN_AMERICA_FINANCIAL_CORPORATE_BOND_OR_LOAN"
  """
  Matrix Transaction Type of STANDARD LATIN AMERICA FINANCIAL CORPORATE BL.
  """
  STANDARD_LATIN_AMERICA_SOVEREIGN = "STANDARD_LATIN_AMERICA_SOVEREIGN"
  """
  Matrix Transaction Type of STANDARD LATIN AMERICA SOVEREIGN.
  """
  STANDARD_NEW_ZEALAND_CORPORATE = "STANDARD_NEW_ZEALAND_CORPORATE"
  """
  Matrix Transaction Type of STANDARD NEW ZEALAND CORPORATE.
  """
  STANDARD_NEW_ZEALAND_FINANCIAL_CORPORATE = "STANDARD_NEW_ZEALAND_FINANCIAL_CORPORATE"
  """
  Matrix Transaction Type of STANDARD NEW ZEALAND FINANCIAL CORPORATE.
  """
  STANDARD_NEW_ZEALAND_SOVEREIGN = "STANDARD_NEW_ZEALAND_SOVEREIGN"
  """
  Matrix Transaction Type of STANDARD NEW ZEALAND SOVEREIGN.
  """
  STANDARD_NORTH_AMERICAN_CORPORATE = "STANDARD_NORTH_AMERICAN_CORPORATE"
  """
  Matrix Transaction Type of STANDARD NORTH AMERICAN CORPORATE.
  """
  STANDARD_NORTH_AMERICAN_FINANCIAL_CORPORATE = "STANDARD_NORTH_AMERICAN_FINANCIAL_CORPORATE"
  """
  Matrix Transaction Type of STANDARD NORTH AMERICAN FINANCIAL CORPORATE.
  """
  STANDARD_SINGAPORE_CORPORATE = "STANDARD_SINGAPORE_CORPORATE"
  """
  Matrix Transaction Type of STANDARD SINGAPORE CORPORATE.
  """
  STANDARD_SINGAPORE_FINANCIAL_CORPORATE = "STANDARD_SINGAPORE_FINANCIAL_CORPORATE"
  """
  Matrix Transaction Type of STANDARD SINGAPORE FINANCIAL CORPORATE.
  """
  STANDARD_SINGAPORE_SOVEREIGN = "STANDARD_SINGAPORE_SOVEREIGN"
  """
  Matrix Transaction Type of STANDARD SINGAPORE SOVEREIGN.
  """
  STANDARD_SUBORDINATED_EUROPEAN_INSURANCE_CORPORATE = "STANDARD_SUBORDINATED_EUROPEAN_INSURANCE_CORPORATE"
  """
  Transaction Type of STANDARD SUBORDINATED EUROPEAN INSURANCE CORPORATE.
  """
  STANDARD_SUKUK_FINANCIAL_CORPORATE = "STANDARD_SUKUK_FINANCIAL_CORPORATE"
  """
  Matrix Transaction Type of STANDARD SUKUK FINANCIAL CORPORATE.
  """
  STANDARD_US_MUNICIPAL_FULL_FAITH_AND_CREDIT = "STANDARD_US_MUNICIPAL_FULL_FAITH_AND_CREDIT"
  """
  Matrix Transaction Type of STANDARD U.S. MUNICIPAL FULL FAITH AND CREDIT.
  """
  STANDARD_US_MUNICIPAL_GENERAL_FUND = "STANDARD_US_MUNICIPAL_GENERAL_FUND"
  """
  Matrix Transaction Type of STANDARD U.S. MUNICIPAL GENERAL FUND.
  """
  STANDARD_US_MUNICIPAL_REVENUE = "STANDARD_US_MUNICIPAL_REVENUE"
  """
  Matrix Transaction Type of STANDARD U.S. MUNICIPAL REVENUE.
  """
  STANDARD_WESTERN_EUROPEAN_SOVEREIGN = "STANDARD_WESTERN_EUROPEAN_SOVEREIGN"
  """
  Matrix Transaction Type of STANDARD WESTERN EUROPEAN SOVEREIGN.
  """
  SUBORDINATED_EUROPEAN_INSURANCE_CORPORATE = "SUBORDINATED_EUROPEAN_INSURANCE_CORPORATE"
  """
  Matrix Transaction Type of SUBORDINATED EUROPEAN INSURANCE CORPORATE.
  """
  SUKUK_CORPORATE = "SUKUK_CORPORATE"
  """
  Matrix Transaction Type of SUKUK CORPORATE.
  """
  SUKUK_FINANCIAL_CORPORATE = "SUKUK_FINANCIAL_CORPORATE"
  """
  Matrix Transaction Type of SUKUK FINANCIAL CORPORATE.
  """
  SUKUK_SOVEREIGN = "SUKUK_SOVEREIGN"
  """
  Matrix Transaction Type of SUKUK SOVEREIGN.
  """
  US_MUNICIPAL_FULL_FAITH_AND_CREDIT = "US_MUNICIPAL_FULL_FAITH_AND_CREDIT"
  """
  Matrix Transaction Type of U.S. MUNICIPAL FULL FAITH AND CREDIT.
  """
  US_MUNICIPAL_GENERAL_FUND = "US_MUNICIPAL_GENERAL_FUND"
  """
  Matrix Transaction Type of U.S. MUNICIPAL GENERAL FUND.
  """
  US_MUNICIPAL_REVENUE = "US_MUNICIPAL_REVENUE"
  """
  Matrix Transaction Type of U.S. MUNICIPAL REVENUE.
  """
  WESTERN_EUROPEAN_SOVEREIGN = "WESTERN_EUROPEAN_SOVEREIGN"
  """
  Matrix Transaction Type of WESTERN EUROPEAN SOVEREIGN.
  """
