from enum import Enum

all = ['ContractualDefinitionsEnum']
  
class ContractualDefinitionsEnum(Enum):
  """
  The enumerated values to specify a set of standard contract definitions relevant to the transaction.
  """
  ISDA1991 = "ISDA1991"
  """
  ISDA 1991 Interest Rate Definitions
  """
  ISDA_1993_COMMODITY = "ISDA_1993_COMMODITY"
  """
  ISDA 1993 Commodity Derivatives Definitions
  """
  ISDA_1996_EQUITY = "ISDA_1996_EQUITY"
  """
  ISDA 1996 Equity Derivatives Definitions
  """
  ISDA_1997_BULLION = "ISDA_1997_BULLION"
  """
  ISDA 1997 Bullion Definitions
  """
  ISDA_1997_GOVERNMENT_BOND = "ISDA_1997_GOVERNMENT_BOND"
  """
  ISDA 1997 Government Bond Option Definitions
  """
  ISDA1998FX = "ISDA1998FX"
  """
  ISDA 1998 FX and Currency Option Definitions
  """
  ISDA_1999_CREDIT = "ISDA_1999_CREDIT"
  """
  ISDA 1999 Credit Derivatives Definitions
  """
  ISDA2000 = "ISDA2000"
  """
  ISDA 2000 Definitions
  """
  ISDA_2002_EQUITY = "ISDA_2002_EQUITY"
  """
  ISDA 2002 Equity Derivatives Definitions
  """
  ISDA_2003_CREDIT = "ISDA_2003_CREDIT"
  """
  ISDA 2003 Credit Derivatives Definitions
  """
  ISDA_2004_NOVATION = "ISDA_2004_NOVATION"
  """
  ISDA 2004 Novation Definitions
  """
  ISDA_2005_COMMODITY = "ISDA_2005_COMMODITY"
  """
  ISDA 2005 Commodity Derivatives Definitions
  """
  ISDA2006 = "ISDA2006"
  """
  ISDA 2006 Interest Rate Definitions
  """
  ISDA_2006_INFLATION = "ISDA_2006_INFLATION"
  """
  ISDA 2006 Inflation Derivatives Definitions
  """
  ISDA_2008_INFLATION = "ISDA_2008_INFLATION"
  """
  ISDA 2008 Inflation Derivatives Definitions
  """
  ISDA_2011_EQUITY = "ISDA_2011_EQUITY"
  """
  ISDA 2011 Equity Derivatives Definitions
  """
  ISDA_2014_CREDIT = "ISDA_2014_CREDIT"
  """
  ISDA 2014 Credit Derivatives Definitions
  """
  ISDA2021 = "ISDA2021"
  """
  ISDA 2021 Interest Rate Derivatives Definitions
  """
