# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
from typing import List, Optional
from datetime import date
from datetime import time
from datetime import datetime
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import *

__all__ = ['Valuation']


class Valuation(BaseDataClass):
  """
  Defines the value of an investment, asset, or security
  """
  amount: Money = Field(..., description="Current value of the outstanding contract")
  """
  Current value of the outstanding contract
  """
  delta: Optional[Decimal] = Field(None, description="The ratio of the change in the price of a derivative transaction to the change in the price of the underlying. This field is applicable only to options and swaptions.")
  """
  The ratio of the change in the price of a derivative transaction to the change in the price of the underlying. This field is applicable only to options and swaptions.
  """
  method: Optional[ValuationTypeEnum] = Field(None, description="Method used for the valuation of the transaction by the valuation party.")
  """
  Method used for the valuation of the transaction by the valuation party.
  """
  source: Optional[ValuationSourceEnum] = Field(None, description="Source of the valuation of the transaction by the valuation party.")
  """
  Source of the valuation of the transaction by the valuation party.
  """
  timestamp: datetime = Field(..., description="Date and time of the last valuation marked to market, provided by the central counterparty (CCP) or calculated using the current or last available market price of the inputs.")
  """
  Date and time of the last valuation marked to market, provided by the central counterparty (CCP) or calculated using the current or last available market price of the inputs.
  """
  
  @rosetta_condition
  def condition_0_ValuationType(self):
    """
    The below condition ensures one and only one of the two attributes: 'Valuation Method' or 'Valuation Source' is allowed. Valuation of a trade or a portfolio is either internally calculated (via M2Market or M2Model methods) or supplied from an external source (e.g Central Counterparty's Valuation). Valuation cannot be based upon internal calculations and external source at the same time.
    """
    return self.check_one_of_constraint('method', 'source', necessity=True)

from cdm.observable.asset.Money import Money
from cdm.event.common.ValuationTypeEnum import ValuationTypeEnum
from cdm.event.common.ValuationSourceEnum import ValuationSourceEnum

Valuation.update_forward_refs()
