from enum import Enum

all = ['CompoundingTypeEnum']
  
class CompoundingTypeEnum(Enum):
  """
  The enumerated values to specify how the compounding calculation is done
  """
  BUSINESS = "BUSINESS"
  """
  Compounding is done only on business days, i.e. not compounded each day on weekends or holidays.
  """
  CALENDAR = "CALENDAR"
  """
  Compounding is done on each calendar day.
  """
  NONE = "NONE"
  """
  Compounding is not applicable
  """
