# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
from typing import List, Optional
from datetime import date
from datetime import time
from datetime import datetime
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import *

__all__ = ['CalculationFrequency']


class CalculationFrequency(BaseDataClass):
  """
  Represents the parameters for describing how often something (such as collateral interest) is to be calculated.
  """
  businessCenter: List[BusinessCenterEnum] = Field([], description="Specifies the business center for adjustment of calculation period.")
  """
  Specifies the business center for adjustment of calculation period.
  """
  dateLocation: BusinessCenterTime = Field(..., description="Specifies where is the time measured.")
  """
  Specifies where is the time measured.
  """
  dayOfMonth: Optional[Decimal] = Field(None, description="Specifies the day of the month if used.")
  """
  Specifies the day of the month if used.
  """
  dayOfWeek: Optional[DayOfWeekEnum] = Field(None, description="Specifies the day of the week if used.")
  """
  Specifies the day of the week if used.
  """
  monthOfYear: Optional[Decimal] = Field(None, description="Specifies the month of the year if used.")
  """
  Specifies the month of the year if used.
  """
  offsetDays: Decimal = Field(..., description="Specifies how many days from the trigger event should the payment occur.")
  """
  Specifies how many days from the trigger event should the payment occur.
  """
  period: Period = Field(..., description="Specifies the time period at which calculation is performed, e.g. 1 month.")
  """
  Specifies the time period at which calculation is performed, e.g. 1 month.
  """
  weekOfMonth: Optional[Decimal] = Field(None, description="Specifies the week of the month if used.")
  """
  Specifies the week of the month if used.
  """
  
  @rosetta_condition
  def condition_0_Moy(self):
    def _then_fn0():
      return all_elements(_resolve_rosetta_attr(self, "monthOfYear"), "<=", 12)
    
    def _else_fn0():
      return True
    
    return if_cond_fn(((_resolve_rosetta_attr(self, "monthOfYear")) is not None), _then_fn0, _else_fn0)
  
  @rosetta_condition
  def condition_1_Dom(self):
    def _then_fn0():
      return all_elements(_resolve_rosetta_attr(self, "dayOfMonth"), "<=", 31)
    
    def _else_fn0():
      return True
    
    return if_cond_fn(((_resolve_rosetta_attr(self, "dayOfMonth")) is not None), _then_fn0, _else_fn0)
  
  @rosetta_condition
  def condition_2_Wom(self):
    def _then_fn0():
      return all_elements(_resolve_rosetta_attr(self, "weekOfMonth"), "<=", 5)
    
    def _else_fn0():
      return True
    
    return if_cond_fn(((_resolve_rosetta_attr(self, "weekOfMonth")) is not None), _then_fn0, _else_fn0)
  
  @rosetta_condition
  def condition_3_MoyTerm(self):
    def _then_fn0():
      return all_elements(_resolve_rosetta_attr(_resolve_rosetta_attr(self, "period"), "period"), "=", _resolve_rosetta_attr(PeriodEnum, "Y"))
    
    def _else_fn0():
      return True
    
    return if_cond_fn(((_resolve_rosetta_attr(self, "monthOfYear")) is not None), _then_fn0, _else_fn0)
  
  @rosetta_condition
  def condition_4_DomTerm(self):
    def _then_fn0():
      return all_elements(_resolve_rosetta_attr(_resolve_rosetta_attr(self, "period"), "period"), "=", _resolve_rosetta_attr(PeriodEnum, "M"))
    
    def _else_fn0():
      return True
    
    return if_cond_fn(((_resolve_rosetta_attr(self, "dayOfMonth")) is not None), _then_fn0, _else_fn0)
  
  @rosetta_condition
  def condition_5_DowTerm(self):
    def _then_fn0():
      return all_elements(_resolve_rosetta_attr(_resolve_rosetta_attr(self, "period"), "period"), "=", _resolve_rosetta_attr(PeriodEnum, "W"))
    
    def _else_fn0():
      return True
    
    return if_cond_fn(((_resolve_rosetta_attr(self, "dayOfWeek")) is not None), _then_fn0, _else_fn0)
  
  @rosetta_condition
  def condition_6_WomTerm(self):
    def _then_fn0():
      return all_elements(_resolve_rosetta_attr(_resolve_rosetta_attr(self, "period"), "period"), "=", _resolve_rosetta_attr(PeriodEnum, "M"))
    
    def _else_fn0():
      return True
    
    return if_cond_fn(((_resolve_rosetta_attr(self, "weekOfMonth")) is not None), _then_fn0, _else_fn0)

from cdm.base.datetime.BusinessCenterEnum import BusinessCenterEnum
from cdm.base.datetime.BusinessCenterTime import BusinessCenterTime
from cdm.base.datetime.DayOfWeekEnum import DayOfWeekEnum
from cdm.base.datetime.Period import Period
from cdm.base.datetime.PeriodEnum import PeriodEnum

CalculationFrequency.update_forward_refs()
