// This file is auto-generated from the ISDA Common Domain Model, do not edit.
//
// Version: 5.0.0-dev.12
//
[assembly: Rosetta.Lib.Attributes.CdmVersion("5.0.0-dev.12")]

#nullable enable // Allow nullable reference types

namespace Org.Isda.Cdm
{
    using System.Collections.Generic;

    using Newtonsoft.Json;
    using Newtonsoft.Json.Converters;

    using NodaTime;

    using Rosetta.Lib;
    using Rosetta.Lib.Attributes;
    using Rosetta.Lib.Meta;
    using Rosetta.Lib.Validation;

    using Org.Isda.Cdm.Meta;
    using Org.Isda.Cdm.MetaFields;
    using _MetaFields = Org.Isda.Cdm.MetaFields.MetaFields;
    
    /// <summary>
    /// A class to specify an account as an account number alongside, optionally. an account name, an account type, an account beneficiary and a servicing party.
    /// </summary>
    public class Account : AbstractRosettaModelObject<Account>
    {
        private static readonly IRosettaMetaData<Account> metaData = new AccountMeta();
        
        [JsonConstructor]
        public Account(ReferenceWithMetaParty? accountBeneficiary, FieldWithMetaString? accountName, FieldWithMetaString accountNumber, FieldWithMetaAccountTypeEnum? accountType, _MetaFields? meta, ReferenceWithMetaParty? partyReference, ReferenceWithMetaParty? servicingParty)
        {
            AccountBeneficiary = accountBeneficiary;
            AccountName = accountName;
            AccountNumber = accountNumber;
            AccountType = accountType;
            Meta = meta;
            PartyReference = partyReference;
            ServicingParty = servicingParty;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Account> MetaData => metaData;
        
        /// <summary>
        /// A reference to the party beneficiary of the account.
        /// </summary>
        public ReferenceWithMetaParty? AccountBeneficiary { get; }
        
        /// <summary>
        /// The name by which the account is known.
        /// </summary>
        public FieldWithMetaString? AccountName { get; }
        
        /// <summary>
        /// The account number.
        /// </summary>
        public FieldWithMetaString AccountNumber { get; }
        
        /// <summary>
        /// The type of account, e.g. client, house.
        /// </summary>
        public FieldWithMetaAccountTypeEnum? AccountType { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <summary>
        /// A reference to the party to which the account refers to.
        /// </summary>
        public ReferenceWithMetaParty? PartyReference { get; }
        
        /// <summary>
        /// The reference to the legal entity that services the account, i.e. in the books of which the account is held.
        /// </summary>
        public ReferenceWithMetaParty? ServicingParty { get; }
    }
    
    public class AcctOwnr : AbstractRosettaModelObject<AcctOwnr>
    {
        private static readonly IRosettaMetaData<AcctOwnr> metaData = new AcctOwnrMeta();
        
        [JsonConstructor]
        public AcctOwnr(Id id)
        {
            Id = id;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AcctOwnr> MetaData => metaData;
        
        public Id Id { get; }
    }
    
    /// <summary>
    /// A type for defining the Additional Disruption Events.
    /// </summary>
    public class AdditionalDisruptionEvents : AbstractRosettaModelObject<AdditionalDisruptionEvents>
    {
        private static readonly IRosettaMetaData<AdditionalDisruptionEvents> metaData = new AdditionalDisruptionEventsMeta();
        
        [JsonConstructor]
        public AdditionalDisruptionEvents(bool? changeInLaw, Enums.AncillaryRole? determiningParty, bool? failureToDeliver, bool? foreignOwnershipEvent, bool? hedgingDisruption, bool? increasedCostOfHedging, bool? increasedCostOfStockBorrow, decimal? initialStockLoanRate, bool? insolvencyFiling, bool? lossOfStockBorrow, decimal? maximumStockLoanRate)
        {
            ChangeInLaw = changeInLaw;
            DeterminingParty = determiningParty;
            FailureToDeliver = failureToDeliver;
            ForeignOwnershipEvent = foreignOwnershipEvent;
            HedgingDisruption = hedgingDisruption;
            IncreasedCostOfHedging = increasedCostOfHedging;
            IncreasedCostOfStockBorrow = increasedCostOfStockBorrow;
            InitialStockLoanRate = initialStockLoanRate;
            InsolvencyFiling = insolvencyFiling;
            LossOfStockBorrow = lossOfStockBorrow;
            MaximumStockLoanRate = maximumStockLoanRate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AdditionalDisruptionEvents> MetaData => metaData;
        
        /// <summary>
        /// 2002 ISDA Equity Derivatives Definitions: Change in Law | 2018 ISDA CDM Equity Confirmation for Security Equity Swap: Change In Law | If true, then change in law is applicable.
        /// </summary>
        public bool? ChangeInLaw { get; }
        
        /// <summary>
        /// Specifies the party which determines additional disruption events.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.AncillaryRole? DeterminingParty { get; }
        
        /// <summary>
        /// 2002 ISDA Equity Derivatives Definitions: Failure to Deliver | Where the underlying is shares and the transaction is physically settled, then, if true, a failure to deliver the shares on the settlement date will not be an event of default for the purposes of the master agreement.
        /// </summary>
        public bool? FailureToDeliver { get; }
        
        /// <summary>
        /// If true, then foreign ownership event is applicable.
        /// </summary>
        public bool? ForeignOwnershipEvent { get; }
        
        /// <summary>
        /// 2002 ISDA Equity Derivatives Definitions: Hedging Disruption | If true, then hedging disruption is applicable.
        /// </summary>
        public bool? HedgingDisruption { get; }
        
        /// <summary>
        /// 2002 ISDA Equity Derivatives Definitions: Increased Cost of Hedging | If true, then increased cost of hedging is applicable.
        /// </summary>
        public bool? IncreasedCostOfHedging { get; }
        
        /// <summary>
        /// 2002 ISDA Equity Derivatives Definitions: Increased Cost of Stock Borrow | If true, then increased cost of stock borrow is applicable.
        /// </summary>
        public bool? IncreasedCostOfStockBorrow { get; }
        
        /// <summary>
        /// Specifies the initial stock loan rate for Increased Cost of Stock Borrow. A percentage of 5% is represented as 0.05.
        /// </summary>
        public decimal? InitialStockLoanRate { get; }
        
        /// <summary>
        /// 2002 ISDA Equity Derivatives Definitions: Insolvency Filing | If true, then insolvency filing is applicable.
        /// </summary>
        public bool? InsolvencyFiling { get; }
        
        /// <summary>
        /// 2002 ISDA Equity Derivatives Definitions: Loss of Stock Borrow | If true, then loss of stock borrow is applicable.
        /// </summary>
        public bool? LossOfStockBorrow { get; }
        
        /// <summary>
        /// Specifies the maximum stock loan rate for Loss of Stock Borrow. A percentage of 5% is represented as 0.05.
        /// </summary>
        public decimal? MaximumStockLoanRate { get; }
    }
    
    /// <summary>
    /// A class to specify the events that will give rise to the payment additional fixed payments.
    /// </summary>
    public class AdditionalFixedPayments : AbstractRosettaModelObject<AdditionalFixedPayments>
    {
        private static readonly IRosettaMetaData<AdditionalFixedPayments> metaData = new AdditionalFixedPaymentsMeta();
        
        [JsonConstructor]
        public AdditionalFixedPayments(bool? interestShortfallReimbursement, bool? principalShortfallReimbursement, bool? writedownReimbursement)
        {
            InterestShortfallReimbursement = interestShortfallReimbursement;
            PrincipalShortfallReimbursement = principalShortfallReimbursement;
            WritedownReimbursement = writedownReimbursement;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AdditionalFixedPayments> MetaData => metaData;
        
        /// <summary>
        /// An additional Fixed Payment Event. Corresponds to the payment by or on behalf of the Issuer of an actual interest amount in respect to the reference obligation that is greater than the expected interest amount. ISDA 2003 Term: Interest Shortfall Reimbursement.
        /// </summary>
        public bool? InterestShortfallReimbursement { get; }
        
        /// <summary>
        /// An additional Fixed Payment Event. Corresponds to the payment by or on behalf of the Issuer of an actual principal amount in respect to the reference obligation that is greater than the expected principal amount. ISDA 2003 Term: Principal Shortfall Reimbursement.
        /// </summary>
        public bool? PrincipalShortfallReimbursement { get; }
        
        /// <summary>
        /// An Additional Fixed Payment. Corresponds to the payment by or on behalf of the issuer of an amount in respect to the reference obligation in reduction of the prior writedowns. ISDA 2003 Term: Writedown Reimbursement.
        /// </summary>
        public bool? WritedownReimbursement { get; }
    }
    
    /// <summary>
    /// A class to specify a post or street address.
    /// </summary>
    public class Address : AbstractRosettaModelObject<Address>
    {
        private static readonly IRosettaMetaData<Address> metaData = new AddressMeta();
        
        [JsonConstructor]
        public Address(string? city, FieldWithMetaString? country, string? postalCode, string? state, IEnumerable<string> street)
        {
            City = city;
            Country = country;
            PostalCode = postalCode;
            State = state;
            Street = street;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Address> MetaData => metaData;
        
        /// <summary>
        /// The city component of the postal address.
        /// </summary>
        public string? City { get; }
        
        /// <summary>
        /// The ISO 3166 standard code for the country within which the postal address is located.
        /// </summary>
        public FieldWithMetaString? Country { get; }
        
        /// <summary>
        /// The code, required for computerized mail sorting systems, that is allocated to a physical address by a national postal authority.
        /// </summary>
        public string? PostalCode { get; }
        
        /// <summary>
        /// A country subdivision used in postal addresses in some countries. For example, US states, Canadian provinces, Swiss cantons, ...
        /// </summary>
        public string? State { get; }
        
        /// <summary>
        /// The set of street and building number information that identifies a postal address within a city.
        /// </summary>
        public IEnumerable<string> Street { get; }
    }
    
    /// <summary>
    /// Specification of the address and other details for notices.
    /// </summary>
    public class AddressForNotices : AbstractRosettaModelObject<AddressForNotices>
    {
        private static readonly IRosettaMetaData<AddressForNotices> metaData = new AddressForNoticesMeta();
        
        [JsonConstructor]
        public AddressForNotices(IEnumerable<PartyContactInformation> additionalNotices, ContactElection primaryNotices)
        {
            AdditionalNotices = additionalNotices;
            PrimaryNotices = primaryNotices;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AddressForNotices> MetaData => metaData;
        
        /// <summary>
        /// The optional specification of additional information when a party requires notices to be delivered to more than one address.
        /// </summary>
        public IEnumerable<PartyContactInformation> AdditionalNotices { get; }
        
        /// <summary>
        /// Specification of primary notice details
        /// </summary>
        public ContactElection PrimaryNotices { get; }
    }
    
    public class AddtlAttrbts : AbstractRosettaModelObject<AddtlAttrbts>
    {
        private static readonly IRosettaMetaData<AddtlAttrbts> metaData = new AddtlAttrbtsMeta();
        
        [JsonConstructor]
        public AddtlAttrbts(string rskRdcgTx, string sctiesFincgTxInd)
        {
            RskRdcgTx = rskRdcgTx;
            SctiesFincgTxInd = sctiesFincgTxInd;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AddtlAttrbts> MetaData => metaData;
        
        public string RskRdcgTx { get; }
        
        public string SctiesFincgTxInd { get; }
    }
    
    /// <summary>
    /// A class for defining a date that shall be subject to adjustment if it would otherwise fall on a day that is not a business day in the specified business centers, together with the convention for adjusting the date.
    /// </summary>
    public class AdjustableDate : AbstractRosettaModelObject<AdjustableDate>
    {
        private static readonly IRosettaMetaData<AdjustableDate> metaData = new AdjustableDateMeta();
        
        [JsonConstructor]
        public AdjustableDate(FieldWithMetaLocalDate? adjustedDate, BusinessDayAdjustments? dateAdjustments, ReferenceWithMetaBusinessDayAdjustments? dateAdjustmentsReference, _MetaFields? meta, LocalDate? unadjustedDate)
        {
            AdjustedDate = adjustedDate;
            DateAdjustments = dateAdjustments;
            DateAdjustmentsReference = dateAdjustmentsReference;
            Meta = meta;
            UnadjustedDate = unadjustedDate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AdjustableDate> MetaData => metaData;
        
        /// <summary>
        /// The date once the adjustment has been performed. (Note that this date may change if the business center holidays change).
        /// </summary>
        public FieldWithMetaLocalDate? AdjustedDate { get; }
        
        /// <summary>
        /// The business day convention and financial business centers used for adjusting the date if it would otherwise fall on a day that is not a business date in the specified business centers.
        /// </summary>
        public BusinessDayAdjustments? DateAdjustments { get; }
        
        /// <summary>
        /// A pointer style reference to date adjustments defined elsewhere in the document.
        /// </summary>
        public ReferenceWithMetaBusinessDayAdjustments? DateAdjustmentsReference { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <summary>
        /// A date subject to adjustment. While in FpML this date is required, this cardinality constraint has been relaxed as part of the CDM in order to support the FRA representation, which effective and termination dates are specified in FpML as adjusted dates.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? UnadjustedDate { get; }
    }
    
    /// <summary>
    /// A class for defining a series of dates that shall be subject to adjustment if they would otherwise fall on a day that is not a business day in the specified business centers, together with the convention for adjusting the dates.
    /// </summary>
    public class AdjustableDates : AbstractRosettaModelObject<AdjustableDates>
    {
        private static readonly IRosettaMetaData<AdjustableDates> metaData = new AdjustableDatesMeta();
        
        [JsonConstructor]
        public AdjustableDates(IEnumerable<FieldWithMetaLocalDate> adjustedDate, BusinessDayAdjustments? dateAdjustments, _MetaFields? meta, IEnumerable<LocalDate> unadjustedDate)
        {
            AdjustedDate = adjustedDate;
            DateAdjustments = dateAdjustments;
            Meta = meta;
            UnadjustedDate = unadjustedDate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AdjustableDates> MetaData => metaData;
        
        /// <summary>
        /// The date(s) once the adjustment has been performed. (Note that this date may change if the business center holidays change).
        /// </summary>
        public IEnumerable<FieldWithMetaLocalDate> AdjustedDate { get; }
        
        /// <summary>
        /// The business day convention and financial business centers used for adjusting the date if it would otherwise fall on a day that is not a business date in the specified business centers.
        /// </summary>
        public BusinessDayAdjustments? DateAdjustments { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <summary>
        /// A date subject to adjustment.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public IEnumerable<LocalDate> UnadjustedDate { get; }
    }
    
    /// <summary>
    /// A class for defining a date that shall be subject to adjustment if it would otherwise fall on a day that is not a business day in the specified business centers, together with the convention for adjusting the date.
    /// </summary>
    public class AdjustableOrAdjustedDate : AbstractRosettaModelObject<AdjustableOrAdjustedDate>
    {
        private static readonly IRosettaMetaData<AdjustableOrAdjustedDate> metaData = new AdjustableOrAdjustedDateMeta();
        
        [JsonConstructor]
        public AdjustableOrAdjustedDate(FieldWithMetaLocalDate? adjustedDate, BusinessDayAdjustments? dateAdjustments, _MetaFields? meta, LocalDate? unadjustedDate)
        {
            AdjustedDate = adjustedDate;
            DateAdjustments = dateAdjustments;
            Meta = meta;
            UnadjustedDate = unadjustedDate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AdjustableOrAdjustedDate> MetaData => metaData;
        
        /// <summary>
        /// The date once the adjustment has been performed. (Note that this date may change if the business center holidays change).
        /// </summary>
        public FieldWithMetaLocalDate? AdjustedDate { get; }
        
        /// <summary>
        /// The business day convention and financial business centers used for adjusting the date if it would otherwise fall on a day that is not a business date in the specified business centers.
        /// </summary>
        public BusinessDayAdjustments? DateAdjustments { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <summary>
        /// A date subject to adjustment.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? UnadjustedDate { get; }
    }
    
    /// <summary>
    /// This Rosetta class specifies the date as either an unadjusted, adjusted or relative date. It supplements the features of the AdjustableOrAdjustedDate to support the credit default swap option premium, which uses the relative date construct.
    /// </summary>
    public class AdjustableOrAdjustedOrRelativeDate : AbstractRosettaModelObject<AdjustableOrAdjustedOrRelativeDate>
    {
        private static readonly IRosettaMetaData<AdjustableOrAdjustedOrRelativeDate> metaData = new AdjustableOrAdjustedOrRelativeDateMeta();
        
        [JsonConstructor]
        public AdjustableOrAdjustedOrRelativeDate(FieldWithMetaLocalDate? adjustedDate, BusinessDayAdjustments? dateAdjustments, RelativeDateOffset? relativeDate, LocalDate? unadjustedDate)
        {
            AdjustedDate = adjustedDate;
            DateAdjustments = dateAdjustments;
            RelativeDate = relativeDate;
            UnadjustedDate = unadjustedDate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AdjustableOrAdjustedOrRelativeDate> MetaData => metaData;
        
        /// <summary>
        /// The date once the adjustment has been performed. (Note that this date may change if the business center holidays change).
        /// </summary>
        public FieldWithMetaLocalDate? AdjustedDate { get; }
        
        /// <summary>
        /// The business day convention and financial business centers used for adjusting the date if it would otherwise fall on a day that is not a business date in the specified business centers.
        /// </summary>
        public BusinessDayAdjustments? DateAdjustments { get; }
        
        /// <summary>
        /// A date specified as some offset to another date (the anchor date).
        /// </summary>
        public RelativeDateOffset? RelativeDate { get; }
        
        /// <summary>
        /// A date subject to adjustment.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? UnadjustedDate { get; }
    }
    
    /// <summary>
    /// A class giving the choice between defining a date as an explicit date together with applicable adjustments or as relative to some other (anchor) date.
    /// </summary>
    public class AdjustableOrRelativeDate : AbstractRosettaModelObject<AdjustableOrRelativeDate>
    {
        private static readonly IRosettaMetaData<AdjustableOrRelativeDate> metaData = new AdjustableOrRelativeDateMeta();
        
        [JsonConstructor]
        public AdjustableOrRelativeDate(AdjustableDate? adjustableDate, _MetaFields? meta, AdjustedRelativeDateOffset? relativeDate)
        {
            AdjustableDate = adjustableDate;
            Meta = meta;
            RelativeDate = relativeDate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AdjustableOrRelativeDate> MetaData => metaData;
        
        /// <summary>
        /// A date that shall be subject to adjustment if it would otherwise fall on a day that is not a business day in the specified business centers, together with the convention for adjusting the date.
        /// </summary>
        public AdjustableDate? AdjustableDate { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <summary>
        /// A date specified as some offset to another date (the anchor date).
        /// </summary>
        public AdjustedRelativeDateOffset? RelativeDate { get; }
    }
    
    /// <summary>
    /// A class giving the choice between defining a series of dates as an explicit list of dates together with applicable adjustments or as relative to some other series of (anchor) dates.
    /// </summary>
    public class AdjustableOrRelativeDates : AbstractRosettaModelObject<AdjustableOrRelativeDates>
    {
        private static readonly IRosettaMetaData<AdjustableOrRelativeDates> metaData = new AdjustableOrRelativeDatesMeta();
        
        [JsonConstructor]
        public AdjustableOrRelativeDates(AdjustableDates? adjustableDates, _MetaFields? meta, RelativeDates? relativeDates)
        {
            AdjustableDates = adjustableDates;
            Meta = meta;
            RelativeDates = relativeDates;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AdjustableOrRelativeDates> MetaData => metaData;
        
        /// <summary>
        /// A series of dates that shall be subject to adjustment if they would otherwise fall on a day that is not a business day in the specified business centers, together with the convention for adjusting the date.
        /// </summary>
        public AdjustableDates? AdjustableDates { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <summary>
        /// A series of dates specified as some offset to another series of dates (the anchor dates).
        /// </summary>
        public RelativeDates? RelativeDates { get; }
    }
    
    /// <summary>
    /// A class giving the choice between defining a series of dates as an explicit list of dates together with applicable adjustments or as relative to some other series of (anchor) dates, or as a calculation period schedule.
    /// </summary>
    public class AdjustableRelativeOrPeriodicDates : AbstractRosettaModelObject<AdjustableRelativeOrPeriodicDates>
    {
        private static readonly IRosettaMetaData<AdjustableRelativeOrPeriodicDates> metaData = new AdjustableRelativeOrPeriodicDatesMeta();
        
        [JsonConstructor]
        public AdjustableRelativeOrPeriodicDates(AdjustableDates? adjustableDates, _MetaFields? meta, PeriodicDates? periodicDates, RelativeDates? relativeDates)
        {
            AdjustableDates = adjustableDates;
            Meta = meta;
            PeriodicDates = periodicDates;
            RelativeDates = relativeDates;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AdjustableRelativeOrPeriodicDates> MetaData => metaData;
        
        /// <summary>
        /// A series of dates that shall be subject to adjustment if they would otherwise fall on a day that is not a business day in the specified business centers, together with the convention for adjusting the date.
        /// </summary>
        public AdjustableDates? AdjustableDates { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <summary>
        /// A calculation period schedule.
        /// </summary>
        public PeriodicDates? PeriodicDates { get; }
        
        /// <summary>
        /// A series of dates specified as some offset to another series of dates (the anchor dates).
        /// </summary>
        public RelativeDates? RelativeDates { get; }
    }
    
    /// <summary>
    /// A type defining a date (referred to as the derived date) as a relative offset from another date (referred to as the anchor date) plus optional date adjustments.
    /// </summary>
    public class AdjustedRelativeDateOffset : AbstractRosettaModelObject<AdjustedRelativeDateOffset>, IRelativeDateOffset
    {
        private static readonly IRosettaMetaData<AdjustedRelativeDateOffset> metaData = new AdjustedRelativeDateOffsetMeta();
        
        [JsonConstructor]
        public AdjustedRelativeDateOffset(BusinessDayAdjustments? relativeDateAdjustments, LocalDate? adjustedDate, BusinessCenters? businessCenters, ReferenceWithMetaBusinessCenters? businessCentersReference, Enums.BusinessDayConvention businessDayConvention, BasicReferenceWithMetaLocalDate? dateRelativeTo, Enums.DayType? dayType, _MetaFields? meta, Enums.Period period, int periodMultiplier)
        {
            RelativeDateAdjustments = relativeDateAdjustments;
            AdjustedDate = adjustedDate;
            BusinessCenters = businessCenters;
            BusinessCentersReference = businessCentersReference;
            BusinessDayConvention = businessDayConvention;
            DateRelativeTo = dateRelativeTo;
            DayType = dayType;
            Meta = meta;
            PeriodValue = period;
            PeriodMultiplier = periodMultiplier;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AdjustedRelativeDateOffset> MetaData => metaData;
        
        /// <summary>
        /// The business day convention and financial business centers used for adjusting the relative date if it would otherwise fall on a day that is not a business date in the specified business centers.
        /// </summary>
        public BusinessDayAdjustments? RelativeDateAdjustments { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? AdjustedDate { get; }
        
        public BusinessCenters? BusinessCenters { get; }
        
        /// <inheritdoc/>
        public ReferenceWithMetaBusinessCenters? BusinessCentersReference { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.BusinessDayConvention BusinessDayConvention { get; }
        
        /// <inheritdoc/>
        public BasicReferenceWithMetaLocalDate? DateRelativeTo { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.DayType? DayType { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        [JsonProperty(PropertyName = "period")]
        public Enums.Period PeriodValue { get; }
        
        /// <inheritdoc/>
        public int PeriodMultiplier { get; }
    }
    
    /// <summary>
    /// A class to specify a trade affirmation.
    /// </summary>
    public class Affirmation : AbstractRosettaModelObject<Affirmation>
    {
        private static readonly IRosettaMetaData<Affirmation> metaData = new AffirmationMeta();
        
        [JsonConstructor]
        public Affirmation(IEnumerable<Identifier> identifier, Lineage? lineage, IEnumerable<Party> party, IEnumerable<PartyRole> partyRole, Enums.AffirmationStatus status)
        {
            Identifier = identifier;
            Lineage = lineage;
            Party = party;
            PartyRole = partyRole;
            Status = status;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Affirmation> MetaData => metaData;
        
        /// <summary>
        /// The identifier(s) associated with the trade and resulting confirmation.
        /// </summary>
        public IEnumerable<Identifier> Identifier { get; }
        
        /// <summary>
        /// The lineage attribute provides a linkage to previous lifecycle events and associated data.
        /// </summary>
        public Lineage? Lineage { get; }
        
        /// <summary>
        /// The parties associated with the trade.
        /// </summary>
        public IEnumerable<Party> Party { get; }
        
        /// <summary>
        /// The role(s) that party(ies) may have in relation to the trade
        /// </summary>
        public IEnumerable<PartyRole> PartyRole { get; }
        
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.AffirmationStatus Status { get; }
    }
    
    /// <summary>
    /// Represents a class to specify multiple credit notations alongside a conditional &apos;any&apos; or &apos;all&apos; qualifier.
    /// </summary>
    public class AgencyRatingCriteria : AbstractRosettaModelObject<AgencyRatingCriteria>
    {
        private static readonly IRosettaMetaData<AgencyRatingCriteria> metaData = new AgencyRatingCriteriaMeta();
        
        [JsonConstructor]
        public AgencyRatingCriteria(Enums.CreditNotationBoundary? boundary, IEnumerable<CreditNotation> creditNotation, Enums.CreditNotationMismatchResolution? mismatchResolution, Enums.Quantifier qualifier, Enums.CreditRatingAgency? referenceAgency)
        {
            Boundary = boundary;
            CreditNotation = creditNotation;
            MismatchResolution = mismatchResolution;
            Qualifier = qualifier;
            ReferenceAgency = referenceAgency;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AgencyRatingCriteria> MetaData => metaData;
        
        /// <summary>
        /// Indicates the boundary of a credit agency rating i.e minimum or maximum.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CreditNotationBoundary? Boundary { get; }
        
        /// <summary>
        /// Indicates the agency rating criteria specified for the asset or issuer.
        /// </summary>
        public IEnumerable<CreditNotation> CreditNotation { get; }
        
        /// <summary>
        /// Indicator for options to be used if several agency ratings (&gt;1) are specified and its necessary to identify specific charateristics. i.e (lowest or highest).
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CreditNotationMismatchResolution? MismatchResolution { get; }
        
        /// <summary>
        /// Indicates whether all or any agency ratings apply.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.Quantifier Qualifier { get; }
        
        /// <summary>
        /// identifies the dominant reference agency if there is a missmatch and several reference agencies exsist.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CreditRatingAgency? ReferenceAgency { get; }
    }
    
    /// <summary>
    ///  Parameters to be used to filter events that are relevant to a given portfolio in order to calculate the state of this portfolio. The attributes correspond to all the possible aggregation criteria that can be used and these criteria can be combined. All the attributes are optional.
    /// </summary>
    public class AggregationParameters : AbstractRosettaModelObject<AggregationParameters>
    {
        private static readonly IRosettaMetaData<AggregationParameters> metaData = new AggregationParametersMeta();
        
        [JsonConstructor]
        public AggregationParameters(ZonedDateTime dateTime, IEnumerable<ReferenceWithMetaParty> party, Enums.PositionStatus? positionStatus, IEnumerable<Product> product, IEnumerable<string> productQualifier, bool? totalPosition, IEnumerable<ReferenceWithMetaTrade> tradeReference)
        {
            DateTime = dateTime;
            Party = party;
            PositionStatus = positionStatus;
            Product = product;
            ProductQualifier = productQualifier;
            TotalPosition = totalPosition;
            TradeReference = tradeReference;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AggregationParameters> MetaData => metaData;
        
        /// <summary>
        /// To aggregate as of a particular date
        /// </summary>
        public ZonedDateTime DateTime { get; }
        
        /// <summary>
        /// To aggregate based on a selection of party(ies) / legal entity(ies).
        /// </summary>
        public IEnumerable<ReferenceWithMetaParty> Party { get; }
        
        /// <summary>
        /// To aggregate based on position status (EXECUTED, SETTLED etc)
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.PositionStatus? PositionStatus { get; }
        
        /// <summary>
        /// To aggregate based on a selection of products.
        /// </summary>
        public IEnumerable<Product> Product { get; }
        
        /// <summary>
        /// To aggregate based on a selection of product type(s).
        /// </summary>
        public IEnumerable<string> ProductQualifier { get; }
        
        /// <summary>
        /// Specifies whether to calculate total position to given date, or only daily position for the given date.
        /// </summary>
        public bool? TotalPosition { get; }
        
        public IEnumerable<ReferenceWithMetaTrade> TradeReference { get; }
    }
    
    /// <summary>
    /// Specification of the standard set of terms that define a legal agreement.
    /// </summary>
    public class Agreement : AbstractRosettaModelObject<Agreement>
    {
        private static readonly IRosettaMetaData<Agreement> metaData = new AgreementMeta();
        
        [JsonConstructor]
        public Agreement(CollateralTransferAgreementElections? collateralTransferAgreementElections, CreditSupportAgreementElections? creditSupportAgreementElections, MasterAgreementSchedule? masterAgreementSchedule, SecurityAgreementElections? securityAgreementElections)
        {
            CollateralTransferAgreementElections = collateralTransferAgreementElections;
            CreditSupportAgreementElections = creditSupportAgreementElections;
            MasterAgreementSchedule = masterAgreementSchedule;
            SecurityAgreementElections = securityAgreementElections;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Agreement> MetaData => metaData;
        
        /// <summary>
        /// Elections to specify a Collateral Transfer Agreement.
        /// </summary>
        public CollateralTransferAgreementElections? CollateralTransferAgreementElections { get; }
        
        /// <summary>
        /// Elections to specify a Credit Support Annex or Credit Support Deed for Intial or Variation Margin.
        /// </summary>
        public CreditSupportAgreementElections? CreditSupportAgreementElections { get; }
        
        /// <summary>
        /// Elections to specify a Master Agreement Schedule.
        /// </summary>
        public MasterAgreementSchedule? MasterAgreementSchedule { get; }
        
        /// <summary>
        /// Elections to specify a Security agreement.
        /// </summary>
        public SecurityAgreementElections? SecurityAgreementElections { get; }
    }
    
    /// <summary>
    /// Specifies the agreement name through an agreement type and optional detailed sub agreement type.
    /// </summary>
    public class AgreementName : AbstractRosettaModelObject<AgreementName>
    {
        private static readonly IRosettaMetaData<AgreementName> metaData = new AgreementNameMeta();
        
        [JsonConstructor]
        public AgreementName(Enums.LegalAgreementType agreementType, IEnumerable<FieldWithMetaContractualDefinitionsEnum> contractualDefinitionsType, IEnumerable<ContractualMatrix> contractualMatrix, IEnumerable<ContractualTermsSupplement> contractualTermsSupplement, Enums.CollateralMarginType? creditSupportAgreementMarginType, FieldWithMetaCreditSupportAgreementTypeEnum? creditSupportAgreementType, FieldWithMetaMasterAgreementTypeEnum? masterAgreementType, FieldWithMetaMasterConfirmationAnnexTypeEnum? masterConfirmationAnnexType, FieldWithMetaMasterConfirmationTypeEnum? masterConfirmationType, string? otherAgreement)
        {
            AgreementType = agreementType;
            ContractualDefinitionsType = contractualDefinitionsType;
            ContractualMatrix = contractualMatrix;
            ContractualTermsSupplement = contractualTermsSupplement;
            CreditSupportAgreementMarginType = creditSupportAgreementMarginType;
            CreditSupportAgreementType = creditSupportAgreementType;
            MasterAgreementType = masterAgreementType;
            MasterConfirmationAnnexType = masterConfirmationAnnexType;
            MasterConfirmationType = masterConfirmationType;
            OtherAgreement = otherAgreement;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AgreementName> MetaData => metaData;
        
        /// <summary>
        /// Specification of the legal agreement type.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.LegalAgreementType AgreementType { get; }
        
        /// <summary>
        /// The definitions such as those published by ISDA that will define the terms of the trade.
        /// </summary>
        public IEnumerable<FieldWithMetaContractualDefinitionsEnum> ContractualDefinitionsType { get; }
        
        /// <summary>
        /// A reference to a contractual matrix of elected terms/values (such as those published by ISDA) that shall be deemed to apply to the trade. The applicable matrix is identified by reference to a name and optionally a publication date. Depending on the structure of the matrix, an additional term (specified in the matrixTerm element) may be required to further identify a subset of applicable terms/values within the matrix.
        /// </summary>
        public IEnumerable<ContractualMatrix> ContractualMatrix { get; }
        
        /// <summary>
        /// A contractual supplement (such as those published by ISDA) that will apply to the trade.
        /// </summary>
        public IEnumerable<ContractualTermsSupplement> ContractualTermsSupplement { get; }
        
        /// <summary>
        /// specifies the type of margin for which a legal agreement is named.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CollateralMarginType? CreditSupportAgreementMarginType { get; }
        
        /// <summary>
        /// Specification of the credit support agreement type.
        /// </summary>
        public FieldWithMetaCreditSupportAgreementTypeEnum? CreditSupportAgreementType { get; }
        
        /// <summary>
        /// Specification of the master agreement type.
        /// </summary>
        public FieldWithMetaMasterAgreementTypeEnum? MasterAgreementType { get; }
        
        /// <summary>
        /// The type of master confirmation annex executed between the parties.
        /// </summary>
        public FieldWithMetaMasterConfirmationAnnexTypeEnum? MasterConfirmationAnnexType { get; }
        
        /// <summary>
        /// The type of master confirmation executed between the parties.
        /// </summary>
        public FieldWithMetaMasterConfirmationTypeEnum? MasterConfirmationType { get; }
        
        /// <summary>
        /// Definition of an agreement that is not enumerated in the CDM.
        /// </summary>
        public string? OtherAgreement { get; }
    }
    
    /// <summary>
    /// Specification of the content of a legal agreement.
    /// </summary>
    public class AgreementTerms : AbstractRosettaModelObject<AgreementTerms>
    {
        private static readonly IRosettaMetaData<AgreementTerms> metaData = new AgreementTermsMeta();
        
        [JsonConstructor]
        public AgreementTerms(Agreement agreement, bool? clauseLibrary, IEnumerable<Counterparty> counterparty)
        {
            Agreement = agreement;
            ClauseLibrary = clauseLibrary;
            Counterparty = counterparty;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AgreementTerms> MetaData => metaData;
        
        /// <summary>
        /// Specification of the standard set of terms that define a legal agreement.
        /// </summary>
        public Agreement Agreement { get; }
        
        /// <summary>
        /// Specification of whether the agreement terms have been negotiated using the clause library methodology.
        /// </summary>
        public bool? ClauseLibrary { get; }
        
        /// <summary>
        /// Specification of the roles of the counterparties to the agreement.
        /// </summary>
        public IEnumerable<Counterparty> Counterparty { get; }
    }
    
    /// <summary>
    /// A class defining the exercise period for an American style option together with any rules governing the notional amount of the underlying which can be exercised on any given exercise date and any associated exercise fees.
    /// </summary>
    public class AmericanExercise : AbstractRosettaModelObject<AmericanExercise>
    {
        private static readonly IRosettaMetaData<AmericanExercise> metaData = new AmericanExerciseMeta();
        
        [JsonConstructor]
        public AmericanExercise(AdjustableOrRelativeDate commencementDate, BusinessCenterTime? earliestExerciseTime, ExerciseFeeSchedule? exerciseFeeSchedule, AdjustableOrRelativeDate expirationDate, BusinessCenterTime expirationTime, Enums.ExpirationTimeType? expirationTimeType, BusinessCenterTime? latestExerciseTime, _MetaFields? meta, MultipleExercise? multipleExercise, AdjustableOrRelativeDates? relevantUnderlyingDate)
        {
            CommencementDate = commencementDate;
            EarliestExerciseTime = earliestExerciseTime;
            ExerciseFeeSchedule = exerciseFeeSchedule;
            ExpirationDate = expirationDate;
            ExpirationTime = expirationTime;
            ExpirationTimeType = expirationTimeType;
            LatestExerciseTime = latestExerciseTime;
            Meta = meta;
            MultipleExercise = multipleExercise;
            RelevantUnderlyingDate = relevantUnderlyingDate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AmericanExercise> MetaData => metaData;
        
        /// <summary>
        /// The first day of the exercise period for an American style option.
        /// </summary>
        public AdjustableOrRelativeDate CommencementDate { get; }
        
        /// <summary>
        /// The earliest time at which notice of exercise can be given by the buyer to the seller (or seller&apos;s agent) to, and including, the expiration date.
        /// </summary>
        public BusinessCenterTime? EarliestExerciseTime { get; }
        
        /// <summary>
        /// The fees associated with an exercise date. The fees are conditional on the exercise occurring. The fees can be specified as actual currency amounts or as percentages of the notional amount being exercised.
        /// </summary>
        public ExerciseFeeSchedule? ExerciseFeeSchedule { get; }
        
        /// <summary>
        /// The last day within an exercise period for an American style option. For a European style option it is the only day within the exercise period.
        /// </summary>
        public AdjustableOrRelativeDate ExpirationDate { get; }
        
        /// <summary>
        /// The latest time for exercise on expirationDate.
        /// </summary>
        public BusinessCenterTime ExpirationTime { get; }
        
        /// <summary>
        /// The time of day at which the equity option expires, for example the official closing time of the exchange.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.ExpirationTimeType? ExpirationTimeType { get; }
        
        /// <summary>
        /// For a Bermuda or American style option, the latest time on an exercise business day (excluding the expiration date) within the exercise period that notice can be given by the buyer to the seller or seller&apos;s agent. Notice of exercise given after this time will be deemed to have been given on the next exercise business day.
        /// </summary>
        public BusinessCenterTime? LatestExerciseTime { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <summary>
        /// As defined in the 2000 ISDA Definitions, Section 12.4. Multiple Exercise, the buyer of the option has the right to exercise all or less than all the unexercised notional amount of the underlying swap on one or more days in the exercise period, but on any such day may not exercise less than the minimum notional amount or more that the maximum notional amount, and if an integral multiple amount is specified, the notional amount exercised must be equal to, or be an integral multiple of, the integral multiple amount.
        /// </summary>
        public MultipleExercise? MultipleExercise { get; }
        
        /// <summary>
        /// The effective date on the underlying product if the option is exercised.  For example, for a swaption it is the swap effective date, for an option on an FX spot or forward it is the value date for settlement, and in an extendible/cancelable provision it is the swap termination date, which is the date on which the termination is effective.&apos;
        /// </summary>
        public AdjustableOrRelativeDates? RelevantUnderlyingDate { get; }
    }
    
    /// <summary>
    /// A class to specify a currency amount or a currency amount schedule.
    /// </summary>
    public class AmountSchedule : AbstractRosettaModelObject<AmountSchedule>, ISchedule
    {
        private static readonly IRosettaMetaData<AmountSchedule> metaData = new AmountScheduleMeta();
        
        [JsonConstructor]
        public AmountSchedule(IEnumerable<FieldWithMetaString> currency, IEnumerable<DatedValue> datedValue, decimal value)
        {
            Currency = currency;
            DatedValue = datedValue;
            Value = value;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AmountSchedule> MetaData => metaData;
        
        /// <summary>
        /// The currency in which the amount schedule is denominated. The currency is specified outside of the actual schedule in order to be applied uniformly to it. The list of valid currencies is not presently positioned as an enumeration as part of the CDM because that scope is limited to the values specified by ISDA and FpML. As a result, implementers have to make reference to the relevant standard, such as the ISO 4217 standard for currency codes.
        /// </summary>
        public IEnumerable<FieldWithMetaString> Currency { get; }
        
        /// <inheritdoc/>
        public IEnumerable<DatedValue> DatedValue { get; }
        
        /// <inheritdoc/>
        public decimal Value { get; }
    }
    
    /// <summary>
    /// Holds an identifier for an ancillary entity, either identified directly via its ancillary role or directly as a legal entity.
    /// </summary>
    public class AncillaryEntity : AbstractRosettaModelObject<AncillaryEntity>
    {
        private static readonly IRosettaMetaData<AncillaryEntity> metaData = new AncillaryEntityMeta();
        
        [JsonConstructor]
        public AncillaryEntity(Enums.AncillaryRole? ancillaryParty, LegalEntity? legalEntity)
        {
            AncillaryParty = ancillaryParty;
            LegalEntity = legalEntity;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AncillaryEntity> MetaData => metaData;
        
        /// <summary>
        /// Identifies a party via its ancillary role on a transaction (e.g. CCP or DCO through which the trade should be cleared.)
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.AncillaryRole? AncillaryParty { get; }
        
        public LegalEntity? LegalEntity { get; }
    }
    
    /// <summary>
    /// Defines an ancillary role enumerated value with an associated party reference. The product is agnostic to the actual parties involved in the transaction, with the party references abstracted away from the product definition and replaced by the AncillaryRoleEnum. The AncillaryRoleEnum can then be positioned in the product and this AncillaryParty type, which is positioned outside of the product definition, allows the AncillaryRoleEnum to be associated with an actual party reference.
    /// </summary>
    public class AncillaryParty : AbstractRosettaModelObject<AncillaryParty>
    {
        private static readonly IRosettaMetaData<AncillaryParty> metaData = new AncillaryPartyMeta();
        
        [JsonConstructor]
        public AncillaryParty(Enums.CounterpartyRole? onBehalfOf, IEnumerable<ReferenceWithMetaParty> partyReference, Enums.AncillaryRole role)
        {
            OnBehalfOf = onBehalfOf;
            PartyReference = partyReference;
            Role = role;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AncillaryParty> MetaData => metaData;
        
        /// <summary>
        /// Optionally specifies the counterparty that the ancillary party is acting on behalf of.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CounterpartyRole? OnBehalfOf { get; }
        
        /// <summary>
        /// Specifies the party, or parties, associated to the ancillary role.
        /// </summary>
        public IEnumerable<ReferenceWithMetaParty> PartyReference { get; }
        
        /// <summary>
        /// Specifies the AncillaryRoleEnum that is associated to the party reference. An ancillary party is any involved party that is not one of the two principal parties to the transaction.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.AncillaryRole Role { get; }
    }
    
    /// <summary>
    /// As per ISDA 2002 Definitions.
    /// </summary>
    public class Asian : AbstractRosettaModelObject<Asian>
    {
        private static readonly IRosettaMetaData<Asian> metaData = new AsianMeta();
        
        [JsonConstructor]
        public Asian(Enums.AveragingInOut averagingInOut, AveragingPeriod? averagingPeriodIn, AveragingPeriod? averagingPeriodOut, decimal? strikeFactor)
        {
            AveragingInOut = averagingInOut;
            AveragingPeriodIn = averagingPeriodIn;
            AveragingPeriodOut = averagingPeriodOut;
            StrikeFactor = strikeFactor;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Asian> MetaData => metaData;
        
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.AveragingInOut AveragingInOut { get; }
        
        /// <summary>
        /// The averaging in period.
        /// </summary>
        public AveragingPeriod? AveragingPeriodIn { get; }
        
        /// <summary>
        /// The averaging out period.
        /// </summary>
        public AveragingPeriod? AveragingPeriodOut { get; }
        
        /// <summary>
        /// The factor of strike.
        /// </summary>
        public decimal? StrikeFactor { get; }
    }
    
    /// <summary>
    /// Represents a set of criteria used to specify eligible collateral assets.
    /// </summary>
    public class AssetCriteria : AbstractRosettaModelObject<AssetCriteria>
    {
        private static readonly IRosettaMetaData<AssetCriteria> metaData = new AssetCriteriaMeta();
        
        [JsonConstructor]
        public AssetCriteria(IEnumerable<AgencyRatingCriteria> agencyRating, IEnumerable<FieldWithMetaString> assetCountryOfOrigin, IEnumerable<AssetType> collateralAssetType, IEnumerable<CollateralTaxonomy> collateralTaxonomy, IEnumerable<FieldWithMetaString> denominatedCurrency, bool? domesticCurrencyIssued, ListingType? listing, PeriodRange? maturityRange, Enums.MaturityType? maturityType, IEnumerable<ProductIdentifier> productIdentifier)
        {
            AgencyRating = agencyRating;
            AssetCountryOfOrigin = assetCountryOfOrigin;
            CollateralAssetType = collateralAssetType;
            CollateralTaxonomy = collateralTaxonomy;
            DenominatedCurrency = denominatedCurrency;
            DomesticCurrencyIssued = domesticCurrencyIssued;
            Listing = listing;
            MaturityRange = maturityRange;
            MaturityType = maturityType;
            ProductIdentifier = productIdentifier;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AssetCriteria> MetaData => metaData;
        
        /// <summary>
        /// Represents an agency rating based on default risk and creditors claim in event of default associated with specific instrument.
        /// </summary>
        public IEnumerable<AgencyRatingCriteria> AgencyRating { get; }
        
        /// <summary>
        /// Represents a filter based on the asset country of origin.
        /// </summary>
        public IEnumerable<FieldWithMetaString> AssetCountryOfOrigin { get; }
        
        /// <summary>
        /// Represents a filter based on the asset product type.
        /// </summary>
        public IEnumerable<AssetType> CollateralAssetType { get; }
        
        /// <summary>
        /// Specifies the collateral taxonomy,which is composed of a taxonomy value and a taxonomy source.
        /// </summary>
        public IEnumerable<CollateralTaxonomy> CollateralTaxonomy { get; }
        
        /// <summary>
        /// Represents a filter based on the underlying asset denominated currency.
        /// </summary>
        public IEnumerable<FieldWithMetaString> DenominatedCurrency { get; }
        
        /// <summary>
        /// Identifies that the Security must be denominated in the domestic currency of the issuer.
        /// </summary>
        public bool? DomesticCurrencyIssued { get; }
        
        /// <summary>
        /// Specifies the exchange, index or sector specific to listing of a security.
        /// </summary>
        public ListingType? Listing { get; }
        
        /// <summary>
        /// Represents a filter based on the underlying asset maturity.
        /// </summary>
        public PeriodRange? MaturityRange { get; }
        
        /// <summary>
        /// Specifies whether the maturity range is the remaining or original maturity.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.MaturityType? MaturityType { get; }
        
        /// <summary>
        /// Represents a filter based on specific instrument identifiers (e.g. specific ISINs, CUSIPs etc).
        /// </summary>
        public IEnumerable<ProductIdentifier> ProductIdentifier { get; }
    }
    
    /// <summary>
    /// Defines each asset movement of an asset payout.
    /// </summary>
    public class AssetLeg : AbstractRosettaModelObject<AssetLeg>
    {
        private static readonly IRosettaMetaData<AssetLeg> metaData = new AssetLegMeta();
        
        [JsonConstructor]
        public AssetLeg(Enums.DeliveryMethod deliveryMethod, AdjustableOrRelativeDate settlementDate)
        {
            DeliveryMethod = deliveryMethod;
            SettlementDate = settlementDate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AssetLeg> MetaData => metaData;
        
        /// <summary>
        /// Specifies a delivery method for the security transaction.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.DeliveryMethod DeliveryMethod { get; }
        
        /// <summary>
        /// Specifies the settlement date of securities.  In a repo transaction the purchase date would always be the effective date as specified under Economic Terms, the repurchase date would always be the termination date as specified under Economic Terms.
        /// </summary>
        public AdjustableOrRelativeDate SettlementDate { get; }
    }
    
    /// <summary>
    /// Security finance payout specification in case the product payout involves some form of security collateral, as in a securities financing transaction. Plus additional description for ICMA.
    /// </summary>
    public class AssetPayout : AbstractRosettaModelObject<AssetPayout>, IPayoutBase
    {
        private static readonly IRosettaMetaData<AssetPayout> metaData = new AssetPayoutMeta();
        
        [JsonConstructor]
        public AssetPayout(IEnumerable<AssetLeg> assetLeg, DividendTerms? dividendTerms, Duration durationType, _MetaFields? meta, Money? minimumFee, Product securityInformation, PayerReceiver payerReceiver, ResolvablePriceQuantity? priceQuantity, PrincipalPayments? principalPayment, SettlementTerms? settlementTerms)
        {
            AssetLeg = assetLeg;
            DividendTerms = dividendTerms;
            DurationType = durationType;
            Meta = meta;
            MinimumFee = minimumFee;
            SecurityInformation = securityInformation;
            PayerReceiver = payerReceiver;
            PriceQuantity = priceQuantity;
            PrincipalPayment = principalPayment;
            SettlementTerms = settlementTerms;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AssetPayout> MetaData => metaData;
        
        /// <summary>
        /// Defines each asset movement as a buy/sell at different dates, typically 1 near leg and 1 far leg in a securities financing transaction.
        /// </summary>
        public IEnumerable<AssetLeg> AssetLeg { get; }
        
        /// <summary>
        /// Specifies the terms under which dividends received by the borrower are passed through to the lender.
        /// </summary>
        public DividendTerms? DividendTerms { get; }
        
        /// <summary>
        /// Specifies the Duration Terms of the Security Finance transaction. e.g. Open or Term.
        /// </summary>
        public Duration DurationType { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <summary>
        /// A contractual minimum amount which the borrower will pay, regardless of the duration of the loan. A mechanism for making sure that a trade generates enough income.
        /// </summary>
        public Money? MinimumFee { get; }
        
        /// <summary>
        /// Specifies the Purchased Security.  Within SecurityPayout we include a condition which validates that the product must be a Security (see below condition &apos;ProductMustBeSecurity&apos;).
        /// </summary>
        public Product SecurityInformation { get; }
        
        /// <inheritdoc/>
        public PayerReceiver PayerReceiver { get; }
        
        /// <inheritdoc/>
        public ResolvablePriceQuantity? PriceQuantity { get; }
        
        /// <inheritdoc/>
        public PrincipalPayments? PrincipalPayment { get; }
        
        /// <inheritdoc/>
        public SettlementTerms? SettlementTerms { get; }
    }
    
    /// <summary>
    /// Characterizes the asset pool behind an asset backed bond.
    /// </summary>
    public class AssetPool : AbstractRosettaModelObject<AssetPool>
    {
        private static readonly IRosettaMetaData<AssetPool> metaData = new AssetPoolMeta();
        
        [JsonConstructor]
        public AssetPool(decimal? currentFactor, LocalDate? effectiveDate, decimal initialFactor, string? version)
        {
            CurrentFactor = currentFactor;
            EffectiveDate = effectiveDate;
            InitialFactor = initialFactor;
            Version = version;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AssetPool> MetaData => metaData;
        
        /// <summary>
        /// The part of the mortgage that is currently outstanding. It is expressed similarly to the initial factor, as factor multiplier to the mortgage. This term is formally defined as part of the &apos;ISDA Standard Terms Supplement for use with credit derivatives transactions on mortgage-backed security with pas-as-you-go or physical settlement&apos;.
        /// </summary>
        public decimal? CurrentFactor { get; }
        
        /// <summary>
        /// Optionally it is possible to specify a version effective date when a version is supplied.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? EffectiveDate { get; }
        
        /// <summary>
        /// The part of the mortgage that is outstanding on trade inception, i.e. has not been repaid yet as principal. It is expressed as a multiplier factor to the mortgage: 1 means that the whole mortgage amount is outstanding, 0.8 means that 20% has been repaid.
        /// </summary>
        public decimal InitialFactor { get; }
        
        /// <summary>
        /// The asset pool version.
        /// </summary>
        public string? Version { get; }
    }
    
    /// <summary>
    /// Represents a class to allow specification of the asset product type.
    /// </summary>
    public class AssetType : AbstractRosettaModelObject<AssetType>
    {
        private static readonly IRosettaMetaData<AssetType> metaData = new AssetTypeMeta();
        
        [JsonConstructor]
        public AssetType(Enums.AssetType assetType, DebtType? debtType, Enums.EquityType? equityType, Enums.FundProductType? fundType, IEnumerable<string> otherAssetType, Enums.SecurityType? securityType)
        {
            AssetTypeValue = assetType;
            DebtType = debtType;
            EquityType = equityType;
            FundType = fundType;
            OtherAssetType = otherAssetType;
            SecurityType = securityType;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AssetType> MetaData => metaData;
        
        /// <summary>
        /// Represents a filter based on the type of collateral asset.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        [JsonProperty(PropertyName = "assetType")]
        public Enums.AssetType AssetTypeValue { get; }
        
        /// <summary>
        /// Represents a filter based on the type of bond.
        /// </summary>
        public DebtType? DebtType { get; }
        
        /// <summary>
        /// Represents a filter based on the type of equity.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.EquityType? EquityType { get; }
        
        /// <summary>
        /// Represents a filter based on the type of fund.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.FundProductType? FundType { get; }
        
        /// <summary>
        /// Specifies the eligible asset type when not enumerated.
        /// </summary>
        public IEnumerable<string> OtherAssetType { get; }
        
        /// <summary>
        /// Represents a filter based on the type of security.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.SecurityType? SecurityType { get; }
    }
    
    /// <summary>
    /// A class to specify the identifier value and its associated version.
    /// </summary>
    public class AssignedIdentifier : AbstractRosettaModelObject<AssignedIdentifier>
    {
        private static readonly IRosettaMetaData<AssignedIdentifier> metaData = new AssignedIdentifierMeta();
        
        [JsonConstructor]
        public AssignedIdentifier(FieldWithMetaString identifier, int? version)
        {
            Identifier = identifier;
            Version = version;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AssignedIdentifier> MetaData => metaData;
        
        /// <summary>
        /// The identifier value.
        /// </summary>
        public FieldWithMetaString Identifier { get; }
        
        /// <summary>
        /// The identifier version, which is specified as an integer and is meant to be incremented each time the transaction terms (whether contract or event) change. This version is made option to support the use case where the identifier is referenced without the version. The constraint that a contract and a lifecycle event need to have an associated version is enforced through data rules.
        /// </summary>
        public int? Version { get; }
    }
    
    /// <summary>
    /// A type to define automatic exercise of a swaption. With automatic exercise the option is deemed to have exercised if it is in the money by more than the threshold amount on the exercise date.
    /// </summary>
    public class AutomaticExercise : AbstractRosettaModelObject<AutomaticExercise>
    {
        private static readonly IRosettaMetaData<AutomaticExercise> metaData = new AutomaticExerciseMeta();
        
        [JsonConstructor]
        public AutomaticExercise(bool? isApplicable, decimal? thresholdRate)
        {
            IsApplicable = isApplicable;
            ThresholdRate = thresholdRate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AutomaticExercise> MetaData => metaData;
        
        /// <summary>
        /// Boolean that indicates if it has an automaticExercise
        /// </summary>
        public bool? IsApplicable { get; }
        
        /// <summary>
        /// A threshold rate. The threshold of 0.10% would be represented as 0.001
        /// </summary>
        public decimal? ThresholdRate { get; }
    }
    
    /// <summary>
    /// Represents the average trading volume of an Equity product upon an exchange or set of exchanges.
    /// </summary>
    public class AverageTradingVolume : AbstractRosettaModelObject<AverageTradingVolume>
    {
        private static readonly IRosettaMetaData<AverageTradingVolume> metaData = new AverageTradingVolumeMeta();
        
        [JsonConstructor]
        public AverageTradingVolume(Enums.AverageTradingVolumeMethodology methodology, Period period)
        {
            Methodology = methodology;
            Period = period;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AverageTradingVolume> MetaData => metaData;
        
        /// <summary>
        /// Indicates the type of equity average trading volume being stated (single) the highest amount on one exchange, or (consolidated) volumes across multiple exchanges.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.AverageTradingVolumeMethodology Methodology { get; }
        
        /// <summary>
        /// Represents the period of the equities average trading volume on the exchange/s.
        /// </summary>
        public Period Period { get; }
    }
    
    /// <summary>
    /// Defines parameters for use in cases when a valuation or other term is based on an average of market observations.
    /// </summary>
    public class AveragingCalculation : AbstractRosettaModelObject<AveragingCalculation>
    {
        private static readonly IRosettaMetaData<AveragingCalculation> metaData = new AveragingCalculationMeta();
        
        [JsonConstructor]
        public AveragingCalculation(AveragingCalculationMethod averagingMethod, Rounding precision)
        {
            AveragingMethod = averagingMethod;
            Precision = precision;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AveragingCalculation> MetaData => metaData;
        
        /// <summary>
        /// Specifies enumerations for the type of averaging calculation.
        /// </summary>
        public AveragingCalculationMethod AveragingMethod { get; }
        
        /// <summary>
        /// Rounding applied to the average calculation. 
        /// </summary>
        public Rounding Precision { get; }
    }
    
    /// <summary>
    /// Defines the ways in which multiple values can be aggregated into a single value.
    /// </summary>
    public class AveragingCalculationMethod : AbstractRosettaModelObject<AveragingCalculationMethod>
    {
        private static readonly IRosettaMetaData<AveragingCalculationMethod> metaData = new AveragingCalculationMethodMeta();
        
        [JsonConstructor]
        public AveragingCalculationMethod(Enums.AveragingCalculationMethod calculationMethod, bool isWeighted)
        {
            CalculationMethod = calculationMethod;
            IsWeighted = isWeighted;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AveragingCalculationMethod> MetaData => metaData;
        
        /// <summary>
        /// Identifies which of the Pythagorean means is being used to compute an average value.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.AveragingCalculationMethod CalculationMethod { get; }
        
        /// <summary>
        /// Identifies whether the average values will be weighted or unweighted.
        /// </summary>
        public bool IsWeighted { get; }
    }
    
    /// <summary>
    /// An unordered list of weighted averaging observations.
    /// </summary>
    public class AveragingObservationList : AbstractRosettaModelObject<AveragingObservationList>
    {
        private static readonly IRosettaMetaData<AveragingObservationList> metaData = new AveragingObservationListMeta();
        
        [JsonConstructor]
        public AveragingObservationList(IEnumerable<WeightedAveragingObservation> averagingObservation)
        {
            AveragingObservation = averagingObservation;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AveragingObservationList> MetaData => metaData;
        
        /// <summary>
        /// A single weighted averaging observation.
        /// </summary>
        public IEnumerable<WeightedAveragingObservation> AveragingObservation { get; }
    }
    
    /// <summary>
    /// Period over which an average value is taken.
    /// </summary>
    public class AveragingPeriod : AbstractRosettaModelObject<AveragingPeriod>
    {
        private static readonly IRosettaMetaData<AveragingPeriod> metaData = new AveragingPeriodMeta();
        
        [JsonConstructor]
        public AveragingPeriod(DateTimeList? averagingDateTimes, AveragingObservationList? averagingObservations, FieldWithMetaMarketDisruptionEnum? marketDisruption, IEnumerable<AveragingSchedule> schedule)
        {
            AveragingDateTimes = averagingDateTimes;
            AveragingObservations = averagingObservations;
            MarketDisruption = marketDisruption;
            Schedule = schedule;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AveragingPeriod> MetaData => metaData;
        
        /// <summary>
        /// An unweighted list of averaging observation date and times.
        /// </summary>
        public DateTimeList? AveragingDateTimes { get; }
        
        /// <summary>
        /// A weighted list of averaging observation date and times.
        /// </summary>
        public AveragingObservationList? AveragingObservations { get; }
        
        /// <summary>
        /// The market disruption event as defined by ISDA 2002 Definitions.
        /// </summary>
        public FieldWithMetaMarketDisruptionEnum? MarketDisruption { get; }
        
        /// <summary>
        /// A schedule for generating averaging observation dates.
        /// </summary>
        public IEnumerable<AveragingSchedule> Schedule { get; }
    }
    
    /// <summary>
    /// Class to representing a method for generating a series of dates.
    /// </summary>
    public class AveragingSchedule : AbstractRosettaModelObject<AveragingSchedule>
    {
        private static readonly IRosettaMetaData<AveragingSchedule> metaData = new AveragingScheduleMeta();
        
        [JsonConstructor]
        public AveragingSchedule(CalculationPeriodFrequency averagingPeriodFrequency, LocalDate endDate, LocalDate startDate)
        {
            AveragingPeriodFrequency = averagingPeriodFrequency;
            EndDate = endDate;
            StartDate = startDate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AveragingSchedule> MetaData => metaData;
        
        /// <summary>
        /// The frequency at which averaging period occurs with the regular part of the valuation schedule and their roll date convention.
        /// </summary>
        public CalculationPeriodFrequency AveragingPeriodFrequency { get; }
        
        /// <summary>
        /// Date on which this period ends.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate EndDate { get; }
        
        /// <summary>
        /// Date on which this period begins.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate StartDate { get; }
    }
    
    /// <summary>
    /// Defines the terms required to calculate the average observations associated with an averaging strike.
    /// </summary>
    public class AveragingStrikeFeature : AbstractRosettaModelObject<AveragingStrikeFeature>
    {
        private static readonly IRosettaMetaData<AveragingStrikeFeature> metaData = new AveragingStrikeFeatureMeta();
        
        [JsonConstructor]
        public AveragingStrikeFeature(AveragingCalculation averagingCalculation, ObservationTerms observationTerms)
        {
            AveragingCalculation = averagingCalculation;
            ObservationTerms = observationTerms;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AveragingStrikeFeature> MetaData => metaData;
        
        /// <summary>
        /// Defines parameters for use in cases when a valuation or other term is based on an average of market observations.
        /// </summary>
        public AveragingCalculation AveragingCalculation { get; }
        
        /// <summary>
        /// Class containing terms that are associated with observing a price/benchmark/index across either single or multple observations. 
        /// </summary>
        public ObservationTerms ObservationTerms { get; }
    }
    
    /// <summary>
    /// As per ISDA 2002 Definitions.
    /// </summary>
    public class Barrier : AbstractRosettaModelObject<Barrier>
    {
        private static readonly IRosettaMetaData<Barrier> metaData = new BarrierMeta();
        
        [JsonConstructor]
        public Barrier(TriggerEvent? barrierCap, TriggerEvent? barrierFloor)
        {
            BarrierCap = barrierCap;
            BarrierFloor = barrierFloor;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Barrier> MetaData => metaData;
        
        /// <summary>
        /// A trigger level approached from beneath.
        /// </summary>
        public TriggerEvent? BarrierCap { get; }
        
        /// <summary>
        /// A trigger level approached from above.
        /// </summary>
        public TriggerEvent? BarrierFloor { get; }
    }
    
    /// <summary>
    /// Defines a custom basket by referencing a product identifier and its consituents.
    /// </summary>
    public class Basket : AbstractRosettaModelObject<Basket>, IProductBase
    {
        private static readonly IRosettaMetaData<Basket> metaData = new BasketMeta();
        
        [JsonConstructor]
        public Basket(IEnumerable<Product> basketConstituent, IEnumerable<ReferenceWithMetaProductIdentifier> productIdentifier, IEnumerable<ProductTaxonomy> productTaxonomy)
        {
            BasketConstituent = basketConstituent;
            ProductIdentifier = productIdentifier;
            ProductTaxonomy = productTaxonomy;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Basket> MetaData => metaData;
        
        /// <summary>
        /// Identifies the constituents of the basket
        /// </summary>
        public IEnumerable<Product> BasketConstituent { get; }
        
        /// <inheritdoc/>
        public IEnumerable<ReferenceWithMetaProductIdentifier> ProductIdentifier { get; }
        
        /// <inheritdoc/>
        public IEnumerable<ProductTaxonomy> ProductTaxonomy { get; }
    }
    
    /// <summary>
    /// CDS Basket Reference Information.
    /// </summary>
    public class BasketReferenceInformation : AbstractRosettaModelObject<BasketReferenceInformation>
    {
        private static readonly IRosettaMetaData<BasketReferenceInformation> metaData = new BasketReferenceInformationMeta();
        
        [JsonConstructor]
        public BasketReferenceInformation(IEnumerable<FieldWithMetaString> basketId, FieldWithMetaString? basketName, int? mthToDefault, int? nthToDefault, ReferencePool referencePool, Tranche? tranche)
        {
            BasketId = basketId;
            BasketName = basketName;
            MthToDefault = mthToDefault;
            NthToDefault = nthToDefault;
            ReferencePool = referencePool;
            Tranche = tranche;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<BasketReferenceInformation> MetaData => metaData;
        
        /// <summary>
        /// A CDS basket identifier.
        /// </summary>
        public IEnumerable<FieldWithMetaString> BasketId { get; }
        
        /// <summary>
        /// The name of the basket expressed as a free format string. FpML does not define usage rules for this element.
        /// </summary>
        public FieldWithMetaString? BasketName { get; }
        
        /// <summary>
        /// M th reference obligation to default to allow representation of N th to M th defaults.
        /// </summary>
        public int? MthToDefault { get; }
        
        /// <summary>
        /// N th reference obligation to default triggers payout.
        /// </summary>
        public int? NthToDefault { get; }
        
        /// <summary>
        /// This element contains all the reference pool items to define the reference entity and reference obligation(s) in the basket.
        /// </summary>
        public ReferencePool ReferencePool { get; }
        
        /// <summary>
        /// This element contains CDS tranche terms.
        /// </summary>
        public Tranche? Tranche { get; }
    }
    
    /// <summary>
    /// A class defining the Bermuda option exercise dates and the expiration date together with any rules governing the notional amount of the underlying which can be exercised on any given exercise date and any associated exercise fee.
    /// </summary>
    public class BermudaExercise : AbstractRosettaModelObject<BermudaExercise>
    {
        private static readonly IRosettaMetaData<BermudaExercise> metaData = new BermudaExerciseMeta();
        
        [JsonConstructor]
        public BermudaExercise(AdjustableOrRelativeDates bermudaExerciseDates, BusinessCenterTime earliestExerciseTime, ExerciseFeeSchedule? exerciseFeeSchedule, BusinessCenterTime expirationTime, Enums.ExpirationTimeType? expirationTimeType, BusinessCenterTime? latestExerciseTime, _MetaFields? meta, MultipleExercise? multipleExercise, AdjustableOrRelativeDates? relevantUnderlyingDate)
        {
            BermudaExerciseDates = bermudaExerciseDates;
            EarliestExerciseTime = earliestExerciseTime;
            ExerciseFeeSchedule = exerciseFeeSchedule;
            ExpirationTime = expirationTime;
            ExpirationTimeType = expirationTimeType;
            LatestExerciseTime = latestExerciseTime;
            Meta = meta;
            MultipleExercise = multipleExercise;
            RelevantUnderlyingDate = relevantUnderlyingDate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<BermudaExercise> MetaData => metaData;
        
        /// <summary>
        /// The dates that define the Bermuda option exercise dates and the expiration date. The last specified date is assumed to be the expiration date. The dates can either be specified as a series of explicit dates and associated adjustments or as a series of dates defined relative to another schedule of dates, for example, the calculation period start dates. Where a relative series of dates are defined the first and last possible exercise dates can be separately specified.
        /// </summary>
        public AdjustableOrRelativeDates BermudaExerciseDates { get; }
        
        /// <summary>
        /// The earliest time at which notice of exercise can be given by the buyer to the seller (or seller&apos;s agent) on each Bermuda option exercise date and the expiration date.
        /// </summary>
        public BusinessCenterTime EarliestExerciseTime { get; }
        
        /// <summary>
        /// The fees associated with an exercise date. The fees are conditional on the exercise occurring. The fees can be specified as actual currency amounts or as percentages of the notional amount being exercised.
        /// </summary>
        public ExerciseFeeSchedule? ExerciseFeeSchedule { get; }
        
        /// <summary>
        /// The latest time for exercise on expirationDate.
        /// </summary>
        public BusinessCenterTime ExpirationTime { get; }
        
        /// <summary>
        /// The time of day at which the equity option expires, for example the official closing time of the exchange.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.ExpirationTimeType? ExpirationTimeType { get; }
        
        /// <summary>
        /// For a Bermuda or American style option, the latest time on an exercise business day (excluding the expiration date) within the exercise period that notice can be given by the buyer to the seller or seller&apos;s agent. Notice of exercise given after this time will be deemed to have been given on the next exercise business day.
        /// </summary>
        public BusinessCenterTime? LatestExerciseTime { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <summary>
        /// As defined in the 2000 ISDA Definitions, Section 12.4. Multiple Exercise, the buyer of the option has the right to exercise all or less than all the unexercised notional amount of the underlying swap on one or more days in the exercise period, but on any such day may not exercise less than the minimum notional amount or more that the maximum notional amount, and if an integral multiple amount is specified, the notional amount exercised must be equal to, or be an integral multiple of, the integral multiple amount.
        /// </summary>
        public MultipleExercise? MultipleExercise { get; }
        
        /// <summary>
        /// The effective date on the underlying product if the option is exercised.  For example, for a swaption it is the swap effective date, for an option on an FX spot or forward it is the value date for settlement, and in an extendible/cancelable provision it is the swap termination date, which is the date on which the termination is effective.
        /// </summary>
        public AdjustableOrRelativeDates? RelevantUnderlyingDate { get; }
    }
    
    /// <summary>
    /// Specifies the instructions for creation of a Security Lending billing invoice.
    /// </summary>
    public class BillingInstruction : AbstractRosettaModelObject<BillingInstruction>
    {
        private static readonly IRosettaMetaData<BillingInstruction> metaData = new BillingInstructionMeta();
        
        [JsonConstructor]
        public BillingInstruction(LocalDate billingEndDate, IEnumerable<BillingRecordInstruction> billingRecordInstruction, LocalDate billingStartDate, IEnumerable<BillingSummaryInstruction> billingSummary, Party receivingParty, Party sendingParty)
        {
            BillingEndDate = billingEndDate;
            BillingRecordInstruction = billingRecordInstruction;
            BillingStartDate = billingStartDate;
            BillingSummary = billingSummary;
            ReceivingParty = receivingParty;
            SendingParty = sendingParty;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<BillingInstruction> MetaData => metaData;
        
        /// <summary>
        /// The ending date of the period described by this invoice
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate BillingEndDate { get; }
        
        /// <summary>
        /// Instructions for creating the billing records contained within the invoice
        /// </summary>
        public IEnumerable<BillingRecordInstruction> BillingRecordInstruction { get; }
        
        /// <summary>
        /// The starting date of the period described by this invoice
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate BillingStartDate { get; }
        
        /// <summary>
        /// The billing summaries contained within the invoice
        /// </summary>
        public IEnumerable<BillingSummaryInstruction> BillingSummary { get; }
        
        /// <summary>
        /// The party receiving the invoice
        /// </summary>
        public Party ReceivingParty { get; }
        
        /// <summary>
        /// The party issuing the invoice
        /// </summary>
        public Party SendingParty { get; }
    }
    
    /// <summary>
    /// Specifies individual records within a billing invoice.
    /// </summary>
    public class BillingRecord : AbstractRosettaModelObject<BillingRecord>
    {
        private static readonly IRosettaMetaData<BillingRecord> metaData = new BillingRecordMeta();
        
        [JsonConstructor]
        public BillingRecord(Money? minimumFee, LocalDate recordEndDate, LocalDate recordStartDate, Transfer recordTransfer, ReferenceWithMetaTradeState tradeState)
        {
            MinimumFee = minimumFee;
            RecordEndDate = recordEndDate;
            RecordStartDate = recordStartDate;
            RecordTransfer = recordTransfer;
            TradeState = tradeState;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<BillingRecord> MetaData => metaData;
        
        /// <summary>
        /// Indicates the minimum fee amount applied to the billing record, if any.
        /// </summary>
        public Money? MinimumFee { get; }
        
        /// <summary>
        /// The ending date of the period described by this record
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate RecordEndDate { get; }
        
        /// <summary>
        /// The starting date of the period described by this record
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate RecordStartDate { get; }
        
        /// <summary>
        /// The settlement terms for the billing record
        /// </summary>
        public Transfer RecordTransfer { get; }
        
        /// <summary>
        /// The trade for the individual billing record.
        /// </summary>
        public ReferenceWithMetaTradeState TradeState { get; }
    }
    
    /// <summary>
    /// Specifies the instructions for creation of a billing record.
    /// </summary>
    public class BillingRecordInstruction : AbstractRosettaModelObject<BillingRecordInstruction>
    {
        private static readonly IRosettaMetaData<BillingRecordInstruction> metaData = new BillingRecordInstructionMeta();
        
        [JsonConstructor]
        public BillingRecordInstruction(IEnumerable<Observation> observation, LocalDate recordEndDate, LocalDate recordStartDate, LocalDate settlementDate, ReferenceWithMetaTradeState tradeState)
        {
            Observation = observation;
            RecordEndDate = recordEndDate;
            RecordStartDate = recordStartDate;
            SettlementDate = settlementDate;
            TradeState = tradeState;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<BillingRecordInstruction> MetaData => metaData;
        
        /// <summary>
        /// The observations used to calculate the billing amount.
        /// </summary>
        public IEnumerable<Observation> Observation { get; }
        
        /// <summary>
        /// The ending date of the period described by this record
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate RecordEndDate { get; }
        
        /// <summary>
        /// The starting date of the period described by this record
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate RecordStartDate { get; }
        
        /// <summary>
        /// The date for settlement of the transfer.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate SettlementDate { get; }
        
        /// <summary>
        /// The trade for the individual billing record.
        /// </summary>
        public ReferenceWithMetaTradeState TradeState { get; }
    }
    
    /// <summary>
    /// Specifies individual summaries within a billing invoice.
    /// </summary>
    public class BillingSummary : AbstractRosettaModelObject<BillingSummary>
    {
        private static readonly IRosettaMetaData<BillingSummary> metaData = new BillingSummaryMeta();
        
        [JsonConstructor]
        public BillingSummary(Enums.RecordAmountType summaryAmountType, Transfer? summaryTransfer)
        {
            SummaryAmountType = summaryAmountType;
            SummaryTransfer = summaryTransfer;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<BillingSummary> MetaData => metaData;
        
        /// <summary>
        /// The account level for the billing summary.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.RecordAmountType SummaryAmountType { get; }
        
        /// <summary>
        /// The settlement terms for the billing summary
        /// </summary>
        public Transfer? SummaryTransfer { get; }
    }
    
    /// <summary>
    /// Specifies the instructions for creation of a billing summary.
    /// </summary>
    public class BillingSummaryInstruction : AbstractRosettaModelObject<BillingSummaryInstruction>
    {
        private static readonly IRosettaMetaData<BillingSummaryInstruction> metaData = new BillingSummaryInstructionMeta();
        
        [JsonConstructor]
        public BillingSummaryInstruction(Enums.RecordAmountType summaryAmountType)
        {
            SummaryAmountType = summaryAmountType;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<BillingSummaryInstruction> MetaData => metaData;
        
        /// <summary>
        /// The account level for the billing summary.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.RecordAmountType SummaryAmountType { get; }
    }
    
    /// <summary>
    /// A class to specify a bond as having a product identifier. As a difference versus the FpML standard, the CDM structure of this class only includes the productIdentifier class, which consists of an identifier, productTaxonomy, and source of the identifier. The reason for this approach is to avoid the potential for conflicting information between the information associated with the contractual product and the reference information maintained by the relevant service provider.
    /// </summary>
    public class Bond : AbstractRosettaModelObject<Bond>, IIdentifiedProduct
    {
        private static readonly IRosettaMetaData<Bond> metaData = new BondMeta();
        
        [JsonConstructor]
        public Bond(ProductIdentifier productIdentifier)
        {
            ProductIdentifier = productIdentifier;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Bond> MetaData => metaData;
        
        public ProductIdentifier ProductIdentifier { get; }
    }
    
    /// <summary>
    ///  Either a bond or convertible bond.
    /// </summary>
    public class BondChoiceModel : AbstractRosettaModelObject<BondChoiceModel>
    {
        private static readonly IRosettaMetaData<BondChoiceModel> metaData = new BondChoiceModelMeta();
        
        [JsonConstructor]
        public BondChoiceModel(Bond? bond, ConvertibleBond? convertibleBond)
        {
            Bond = bond;
            ConvertibleBond = convertibleBond;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<BondChoiceModel> MetaData => metaData;
        
        public Bond? Bond { get; }
        
        public ConvertibleBond? ConvertibleBond { get; }
    }
    
    /// <summary>
    ///  Bond equity model to value convertible bonds and modelled onto BondEquity.model in FpML.
    /// </summary>
    public class BondEquityModel : AbstractRosettaModelObject<BondEquityModel>
    {
        private static readonly IRosettaMetaData<BondEquityModel> metaData = new BondEquityModelMeta();
        
        [JsonConstructor]
        public BondEquityModel(BondChoiceModel? bondchoiceModel, Equity? equity)
        {
            BondchoiceModel = bondchoiceModel;
            Equity = equity;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<BondEquityModel> MetaData => metaData;
        
        /// <summary>
        /// Either the bond or convertible bond.
        /// </summary>
        public BondChoiceModel? BondchoiceModel { get; }
        
        /// <summary>
        /// The equity.
        /// </summary>
        public Equity? Equity { get; }
    }
    
    /// <summary>
    ///  Bond price and yield valuation model for the security leg in a securities financing transaction, closely modelled onto the BondPriceAndYield.model in FpML.
    /// </summary>
    public class BondPriceAndYieldModel : AbstractRosettaModelObject<BondPriceAndYieldModel>
    {
        private static readonly IRosettaMetaData<BondPriceAndYieldModel> metaData = new BondPriceAndYieldModelMeta();
        
        [JsonConstructor]
        public BondPriceAndYieldModel(decimal? allInPrice, CleanOrDirtyPrice? cleanOrDirtyPrice, decimal? inflationFactor, RelativePrice? relativePrice, decimal? yieldToMaturity)
        {
            AllInPrice = allInPrice;
            CleanOrDirtyPrice = cleanOrDirtyPrice;
            InflationFactor = inflationFactor;
            RelativePrice = relativePrice;
            YieldToMaturity = yieldToMaturity;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<BondPriceAndYieldModel> MetaData => metaData;
        
        /// <summary>
        /// Bond all-in-price which is a price that includes all relevant price adjustments (i.e. accrued interest, haircut or margin ratio, inflation factor,etc.). It expresses a price in terms of percentage of nominal amount.
        /// </summary>
        public decimal? AllInPrice { get; }
        
        /// <summary>
        /// Either the clean or dirty price of the bond.
        /// </summary>
        public CleanOrDirtyPrice? CleanOrDirtyPrice { get; }
        
        /// <summary>
        /// The inflation factor is specified for inflation-linked products which require some additional elements to calculate prices correctly.
        /// </summary>
        public decimal? InflationFactor { get; }
        
        /// <summary>
        /// Bond price relative to a Benchmark.
        /// </summary>
        public RelativePrice? RelativePrice { get; }
        
        /// <summary>
        /// Price specified as a yield to maturity.
        /// </summary>
        public decimal? YieldToMaturity { get; }
    }
    
    /// <summary>
    /// Reference to a bond underlier to represent an asset swap or Condition Precedent Bond.
    /// </summary>
    public class BondReference : AbstractRosettaModelObject<BondReference>
    {
        private static readonly IRosettaMetaData<BondReference> metaData = new BondReferenceMeta();
        
        [JsonConstructor]
        public BondReference(ProductIdentifier bond, bool conditionPrecedentBond, FixedRateSpecification? couponRate, bool? discrepancyClause)
        {
            Bond = bond;
            ConditionPrecedentBond = conditionPrecedentBond;
            CouponRate = couponRate;
            DiscrepancyClause = discrepancyClause;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<BondReference> MetaData => metaData;
        
        /// <summary>
        /// Reference to a bond underlier.
        /// </summary>
        public ProductIdentifier Bond { get; }
        
        /// <summary>
        /// To indicate whether the Condition Precedent Bond is applicable. The swap contract is only valid if the bond is issued and if there is any dispute over the terms of fixed stream then the bond terms would be used.
        /// </summary>
        public bool ConditionPrecedentBond { get; }
        
        /// <summary>
        /// Specifies the coupon rate (expressed in percentage) of a fixed income security or convertible bond.
        /// </summary>
        public FixedRateSpecification? CouponRate { get; }
        
        /// <summary>
        /// To indicate whether the Discrepancy Clause is applicable.
        /// </summary>
        public bool? DiscrepancyClause { get; }
    }
    
    /// <summary>
    ///  Bond valuation model for the security leg in a securities financing transaction, closely modelled onto the BondCollateral.model in FpML.
    /// </summary>
    public class BondValuationModel : AbstractRosettaModelObject<BondValuationModel>
    {
        private static readonly IRosettaMetaData<BondValuationModel> metaData = new BondValuationModelMeta();
        
        [JsonConstructor]
        public BondValuationModel(Money? accrualsAmount, BondPriceAndYieldModel bondPriceAndYieldModel, Money nominalAmount)
        {
            AccrualsAmount = accrualsAmount;
            BondPriceAndYieldModel = bondPriceAndYieldModel;
            NominalAmount = nominalAmount;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<BondValuationModel> MetaData => metaData;
        
        /// <summary>
        /// Accruals amount for the bond in the security leg
        /// </summary>
        public Money? AccrualsAmount { get; }
        
        /// <summary>
        /// Price and yield model for valuing a bond security leg.
        /// </summary>
        public BondPriceAndYieldModel BondPriceAndYieldModel { get; }
        
        /// <summary>
        /// The quantity of the underlier expressed as a nominal amount.
        /// </summary>
        public Money NominalAmount { get; }
    }
    
    /// <summary>
    /// Describes correlation bounds, which form a cap and a floor on the realized correlation.
    /// </summary>
    public class BoundedCorrelation : AbstractRosettaModelObject<BoundedCorrelation>
    {
        private static readonly IRosettaMetaData<BoundedCorrelation> metaData = new BoundedCorrelationMeta();
        
        [JsonConstructor]
        public BoundedCorrelation(decimal? maximumBoundaryPercent, decimal? minimumBoundaryPercent)
        {
            MaximumBoundaryPercent = maximumBoundaryPercent;
            MinimumBoundaryPercent = minimumBoundaryPercent;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<BoundedCorrelation> MetaData => metaData;
        
        /// <summary>
        /// Maximum Boundary as a percentage of the Strike Price.
        /// </summary>
        public decimal? MaximumBoundaryPercent { get; }
        
        /// <summary>
        /// Minimum Boundary as a percentage of the Strike Price.
        /// </summary>
        public decimal? MinimumBoundaryPercent { get; }
    }
    
    public class BoundedVariance : AbstractRosettaModelObject<BoundedVariance>
    {
        private static readonly IRosettaMetaData<BoundedVariance> metaData = new BoundedVarianceMeta();
        
        [JsonConstructor]
        public BoundedVariance(bool daysInRangeAdjustment, decimal? lowerBarrier, Enums.RealisedVarianceMethod realisedVarianceMethod, decimal? upperBarrier)
        {
            DaysInRangeAdjustment = daysInRangeAdjustment;
            LowerBarrier = lowerBarrier;
            RealisedVarianceMethod = realisedVarianceMethod;
            UpperBarrier = upperBarrier;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<BoundedVariance> MetaData => metaData;
        
        /// <summary>
        /// The contract specifies whether the notional should be scaled by the Number of Days in Range divided by the Expected N. The number of Days in Ranges refers to the number of returns that contribute to the realized volatility.
        /// </summary>
        public bool DaysInRangeAdjustment { get; }
        
        /// <summary>
        /// All observations below this price level will be excluded from the variance calculation.
        /// </summary>
        public decimal? LowerBarrier { get; }
        
        /// <summary>
        /// The contract specifies which price must satisfy the boundary condition.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.RealisedVarianceMethod RealisedVarianceMethod { get; }
        
        /// <summary>
        /// All observations above this price level will be excluded from the variance calculation.
        /// </summary>
        public decimal? UpperBarrier { get; }
    }
    
    /// <summary>
    /// A class for defining a time with respect to a business day calendar location. For example, 11:00:00 GBLO.
    /// </summary>
    public class BusinessCenterTime : AbstractRosettaModelObject<BusinessCenterTime>
    {
        private static readonly IRosettaMetaData<BusinessCenterTime> metaData = new BusinessCenterTimeMeta();
        
        [JsonConstructor]
        public BusinessCenterTime(FieldWithMetaBusinessCenterEnum businessCenter, LocalTime hourMinuteTime)
        {
            BusinessCenter = businessCenter;
            HourMinuteTime = hourMinuteTime;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<BusinessCenterTime> MetaData => metaData;
        
        /// <summary>
        /// A code identifying a business day calendar location. A business day calendar location is drawn from the list identified by the business day calendar location enumeration.
        /// </summary>
        public FieldWithMetaBusinessCenterEnum BusinessCenter { get; }
        
        /// <summary>
        /// A time specified in hh:mm:ss format where the second component must be &apos;00&apos;, e.g. 11am would be represented as 11:00:00.
        /// </summary>
        public LocalTime HourMinuteTime { get; }
    }
    
    /// <summary>
    /// A class for specifying the business day calendar location used in determining whether a day is a business day or not, either by specifying this business center by reference to an enumerated list that is maintained by the FpML standard, or by reference to such specification when it exists elsewhere as part of the instance document. This class corresponds to the FpML BusinessCentersOrReference.model.
    /// </summary>
    public class BusinessCenters : AbstractRosettaModelObject<BusinessCenters>
    {
        private static readonly IRosettaMetaData<BusinessCenters> metaData = new BusinessCentersMeta();
        
        [JsonConstructor]
        public BusinessCenters(IEnumerable<FieldWithMetaBusinessCenterEnum> businessCenter, ReferenceWithMetaBusinessCenters? businessCentersReference, IEnumerable<FieldWithMetaCommodityBusinessCalendarEnum> commodityBusinessCalendar, _MetaFields? meta)
        {
            BusinessCenter = businessCenter;
            BusinessCentersReference = businessCentersReference;
            CommodityBusinessCalendar = commodityBusinessCalendar;
            Meta = meta;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<BusinessCenters> MetaData => metaData;
        
        /// <summary>
        /// A code identifying one or several business day calendar location(s). The set of business day calendar locations are specified by the business day calendar location enumeration which is maintained by the FpML standard.
        /// </summary>
        public IEnumerable<FieldWithMetaBusinessCenterEnum> BusinessCenter { get; }
        
        /// <summary>
        /// A reference to a financial business center location specified elsewhere in the instance document.
        /// </summary>
        public ReferenceWithMetaBusinessCenters? BusinessCentersReference { get; }
        
        public IEnumerable<FieldWithMetaCommodityBusinessCalendarEnum> CommodityBusinessCalendar { get; }
        
        public _MetaFields? Meta { get; }
    }
    
    /// <summary>
    /// A class defining a range of contiguous business days by defining an unadjusted first date, an unadjusted last date and a business day convention and business centers for adjusting the first and last dates if they would otherwise fall on a non business day in the specified business centers. The days between the first and last date must also be good business days in the specified centers to be counted in the range.
    /// </summary>
    public class BusinessDateRange : AbstractRosettaModelObject<BusinessDateRange>, IDateRange
    {
        private static readonly IRosettaMetaData<BusinessDateRange> metaData = new BusinessDateRangeMeta();
        
        [JsonConstructor]
        public BusinessDateRange(BusinessCenters? businessCenters, Enums.BusinessDayConvention businessDayConvention, LocalDate endDate, LocalDate startDate)
        {
            BusinessCenters = businessCenters;
            BusinessDayConvention = businessDayConvention;
            EndDate = endDate;
            StartDate = startDate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<BusinessDateRange> MetaData => metaData;
        
        /// <summary>
        /// The business center(s), specified either explicitly or by reference to those specified somewhere else in the instance document.
        /// </summary>
        public BusinessCenters? BusinessCenters { get; }
        
        /// <summary>
        /// The convention for adjusting a date if it would otherwise fall on a day that is not a business day, as specified by an ISDA convention (e.g. Following, Precedent).
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.BusinessDayConvention BusinessDayConvention { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate EndDate { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate StartDate { get; }
    }
    
    /// <summary>
    /// A class defining the business day convention and financial business centers used for adjusting any relevant date if it would otherwise fall on a day that is not a business day in the specified business center.
    /// </summary>
    public class BusinessDayAdjustments : AbstractRosettaModelObject<BusinessDayAdjustments>
    {
        private static readonly IRosettaMetaData<BusinessDayAdjustments> metaData = new BusinessDayAdjustmentsMeta();
        
        [JsonConstructor]
        public BusinessDayAdjustments(BusinessCenters? businessCenters, Enums.BusinessDayConvention businessDayConvention, _MetaFields? meta)
        {
            BusinessCenters = businessCenters;
            BusinessDayConvention = businessDayConvention;
            Meta = meta;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<BusinessDayAdjustments> MetaData => metaData;
        
        /// <summary>
        /// The business center(s), specified either explicitly or by reference to those specified somewhere else in the instance document.
        /// </summary>
        public BusinessCenters? BusinessCenters { get; }
        
        /// <summary>
        /// The convention for adjusting a date if it would otherwise fall on a day that is not a business day.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.BusinessDayConvention BusinessDayConvention { get; }
        
        public _MetaFields? Meta { get; }
    }
    
    /// <summary>
    /// A business event represents a life cycle event of a trade. The combination of the state changes results in a qualifiable life cycle event. An example of a Business Event is a PartialTermination which is a defined by a quantity change primitive event.
    /// </summary>
    public class BusinessEvent : AbstractRosettaModelObject<BusinessEvent>, IEventInstruction
    {
        private static readonly IRosettaMetaData<BusinessEvent> metaData = new BusinessEventMeta();
        
        [JsonConstructor]
        public BusinessEvent(IEnumerable<TradeState> after, string? eventQualifier, _MetaFields? meta, Enums.CorporateActionType? corporateActionIntent, LocalDate? effectiveDate, LocalDate? eventDate, IEnumerable<Instruction> instruction, Enums.EventIntent? intent, IdentifiedList? packageInformation)
        {
            After = after;
            EventQualifier = eventQualifier;
            Meta = meta;
            CorporateActionIntent = corporateActionIntent;
            EffectiveDate = effectiveDate;
            EventDate = eventDate;
            Instruction = instruction;
            Intent = intent;
            PackageInformation = packageInformation;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<BusinessEvent> MetaData => metaData;
        
        /// <summary>
        /// Specifies the after trade state(s) created.
        /// </summary>
        public IEnumerable<TradeState> After { get; }
        
        /// <summary>
        /// The CDM event qualifier, which corresponds to the outcome of the isEvent qualification logic which qualifies the lifecycle event as a function of its features (e.g. PartialTermination, ClearingSubmission, Novation, ...).
        /// </summary>
        public string? EventQualifier { get; }
        
        public _MetaFields? Meta { get; }
        
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CorporateActionType? CorporateActionIntent { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? EffectiveDate { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? EventDate { get; }
        
        /// <inheritdoc/>
        public IEnumerable<Instruction> Instruction { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.EventIntent? Intent { get; }
        
        /// <inheritdoc/>
        public IdentifiedList? PackageInformation { get; }
    }
    
    /// <summary>
    /// A class to specify an organizational unit.
    /// </summary>
    public class BusinessUnit : AbstractRosettaModelObject<BusinessUnit>
    {
        private static readonly IRosettaMetaData<BusinessUnit> metaData = new BusinessUnitMeta();
        
        [JsonConstructor]
        public BusinessUnit(ContactInformation? contactInformation, Identifier? identifier, _MetaFields? meta, string name)
        {
            ContactInformation = contactInformation;
            Identifier = identifier;
            Meta = meta;
            Name = name;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<BusinessUnit> MetaData => metaData;
        
        /// <summary>
        /// The contact information for such business unit, when different from the contact information associated with the party.
        /// </summary>
        public ContactInformation? ContactInformation { get; }
        
        /// <summary>
        /// An identifier used to uniquely identify the organizational unit
        /// </summary>
        public Identifier? Identifier { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <summary>
        /// A name used to describe the organizational unit
        /// </summary>
        public string Name { get; }
    }
    
    /// <summary>
    /// This class corresponds to the FpML BuyerSeller.model construct.
    /// </summary>
    public class BuyerSeller : AbstractRosettaModelObject<BuyerSeller>, IBuyerSeller
    {
        private static readonly IRosettaMetaData<BuyerSeller> metaData = new BuyerSellerMeta();
        
        [JsonConstructor]
        public BuyerSeller(Enums.CounterpartyRole buyer, Enums.CounterpartyRole seller)
        {
            Buyer = buyer;
            Seller = seller;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<BuyerSeller> MetaData => metaData;
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CounterpartyRole Buyer { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CounterpartyRole Seller { get; }
    }
    
    public class Buyr : AbstractRosettaModelObject<Buyr>
    {
        private static readonly IRosettaMetaData<Buyr> metaData = new BuyrMeta();
        
        [JsonConstructor]
        public Buyr(AcctOwnr acctOwnr)
        {
            AcctOwnr = acctOwnr;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Buyr> MetaData => metaData;
        
        public AcctOwnr AcctOwnr { get; }
    }
    
    /// <summary>
    /// Defines the tradeState or payout on which to create a Transfer along with all necessary resets.
    /// </summary>
    public class CalculateTransferInstruction : AbstractRosettaModelObject<CalculateTransferInstruction>
    {
        private static readonly IRosettaMetaData<CalculateTransferInstruction> metaData = new CalculateTransferInstructionMeta();
        
        [JsonConstructor]
        public CalculateTransferInstruction(LocalDate? date, PayerReceiver? payerReceiver, ReferenceWithMetaPayout payout, Quantity? quantity, IEnumerable<Reset> resets, TradeState tradeState)
        {
            Date = date;
            PayerReceiver = payerReceiver;
            Payout = payout;
            Quantity = quantity;
            Resets = resets;
            TradeState = tradeState;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CalculateTransferInstruction> MetaData => metaData;
        
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? Date { get; }
        
        public PayerReceiver? PayerReceiver { get; }
        
        public ReferenceWithMetaPayout Payout { get; }
        
        /// <summary>
        /// Specifies quantity amount returned if not the full amount from the TradeState, e.g. partial return
        /// </summary>
        public Quantity? Quantity { get; }
        
        public IEnumerable<Reset> Resets { get; }
        
        public TradeState TradeState { get; }
    }
    
    /// <summary>
    /// Type for reporting details of calculated rates, including the observations that went into the final reported rate.
    /// </summary>
    public class CalculatedRateDetails : AbstractRosettaModelObject<CalculatedRateDetails>
    {
        private static readonly IRosettaMetaData<CalculatedRateDetails> metaData = new CalculatedRateDetailsMeta();
        
        [JsonConstructor]
        public CalculatedRateDetails(decimal? aggregateValue, decimal? aggregateWeight, decimal? calculatedRate, IEnumerable<decimal> compoundedGrowth, IEnumerable<decimal> growthFactor, CalculatedRateObservations? observations, IEnumerable<decimal> weightedRates)
        {
            AggregateValue = aggregateValue;
            AggregateWeight = aggregateWeight;
            CalculatedRate = calculatedRate;
            CompoundedGrowth = compoundedGrowth;
            GrowthFactor = growthFactor;
            Observations = observations;
            WeightedRates = weightedRates;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CalculatedRateDetails> MetaData => metaData;
        
        /// <summary>
        /// The total sum or product of all the individual terms that went into the calculated rate.
        /// </summary>
        public decimal? AggregateValue { get; }
        
        /// <summary>
        /// The total weight of all the terms that went into the calculated rate.
        /// </summary>
        public decimal? AggregateWeight { get; }
        
        /// <summary>
        /// The resulting calculated weight.
        /// </summary>
        public decimal? CalculatedRate { get; }
        
        /// <summary>
        /// The compounding curve, showing how the initial value grew during the calculation period.
        /// </summary>
        public IEnumerable<decimal> CompoundedGrowth { get; }
        
        /// <summary>
        /// The daily growth factors, showing the weighted rates divided by the day count basis plus one, giving how much the value grows for each step in the calculation.
        /// </summary>
        public IEnumerable<decimal> GrowthFactor { get; }
        
        /// <summary>
        /// The observation dates and weights for each observation date.
        /// </summary>
        public CalculatedRateObservations? Observations { get; }
        
        /// <summary>
        /// The weighted value of each observation.
        /// </summary>
        public IEnumerable<decimal> WeightedRates { get; }
    }
    
    /// <summary>
    /// Type for reporting the observations dates and the corresponding weights going into a daily calculated rate
    /// </summary>
    public class CalculatedRateObservationDatesAndWeights : AbstractRosettaModelObject<CalculatedRateObservationDatesAndWeights>
    {
        private static readonly IRosettaMetaData<CalculatedRateObservationDatesAndWeights> metaData = new CalculatedRateObservationDatesAndWeightsMeta();
        
        [JsonConstructor]
        public CalculatedRateObservationDatesAndWeights(IEnumerable<LocalDate> observationDates, IEnumerable<decimal> weights)
        {
            ObservationDates = observationDates;
            Weights = weights;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CalculatedRateObservationDatesAndWeights> MetaData => metaData;
        
        /// <summary>
        /// The observation date upon which the rate is observed.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public IEnumerable<LocalDate> ObservationDates { get; }
        
        /// <summary>
        /// The corresponding weight for each date.
        /// </summary>
        public IEnumerable<decimal> Weights { get; }
    }
    
    /// <summary>
    /// Type for reporting observations that went into the final reported rate.
    /// </summary>
    public class CalculatedRateObservations : AbstractRosettaModelObject<CalculatedRateObservations>
    {
        private static readonly IRosettaMetaData<CalculatedRateObservations> metaData = new CalculatedRateObservationsMeta();
        
        [JsonConstructor]
        public CalculatedRateObservations(IEnumerable<LocalDate> observationDates, IEnumerable<decimal> observedRates, IEnumerable<decimal> processedRates, IEnumerable<decimal> weights)
        {
            ObservationDates = observationDates;
            ObservedRates = observedRates;
            ProcessedRates = processedRates;
            Weights = weights;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CalculatedRateObservations> MetaData => metaData;
        
        /// <summary>
        /// The observation date upon which the rate is observed.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public IEnumerable<LocalDate> ObservationDates { get; }
        
        /// <summary>
        /// The value observed for that date
        /// </summary>
        public IEnumerable<decimal> ObservedRates { get; }
        
        /// <summary>
        /// The value after any processing, such as application of caps or floors.
        /// </summary>
        public IEnumerable<decimal> ProcessedRates { get; }
        
        /// <summary>
        /// The corresponding weight for each date.
        /// </summary>
        public IEnumerable<decimal> Weights { get; }
    }
    
    /// <summary>
    /// A class defining the ISDA calculation agent responsible for performing duties as defined in the applicable product definitions.
    /// </summary>
    public class CalculationAgent : AbstractRosettaModelObject<CalculationAgent>
    {
        private static readonly IRosettaMetaData<CalculationAgent> metaData = new CalculationAgentMeta();
        
        [JsonConstructor]
        public CalculationAgent(FieldWithMetaBusinessCenterEnum? calculationAgentBusinessCenter, Enums.AncillaryRole? calculationAgentParty, Enums.PartyDetermination? calculationAgentPartyEnum)
        {
            CalculationAgentBusinessCenter = calculationAgentBusinessCenter;
            CalculationAgentParty = calculationAgentParty;
            CalculationAgentPartyEnum = calculationAgentPartyEnum;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CalculationAgent> MetaData => metaData;
        
        /// <summary>
        /// The city in which the office through which ISDA Calculation Agent is acting for purposes of the transaction is located The short-form confirm for a trade that is executed under a Sovereign or Asia Pacific Master Confirmation Agreement ( MCA ), does not need to specify the Calculation Agent. However, the confirm does need to specify the Calculation Agent City. This is due to the fact that the MCA sets the value for Calculation Agent but does not set the value for Calculation Agent City.
        /// </summary>
        public FieldWithMetaBusinessCenterEnum? CalculationAgentBusinessCenter { get; }
        
        /// <summary>
        /// Specifies the party which is the ISDA Calculation Agent for the trade. If more than one party is referenced then the parties are assumed to be co-calculation agents, i.e. they have joint responsibility.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.AncillaryRole? CalculationAgentParty { get; }
        
        /// <summary>
        /// Specifies the ISDA calculation agent responsible for performing duties as defined in the applicable product definitions. For example, the Calculation Agent may be defined as being the Non-exercising Party.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.PartyDetermination? CalculationAgentPartyEnum { get; }
    }
    
    /// <summary>
    /// This class corresponds to the FpML CalculationAgent.model.
    /// </summary>
    public class CalculationAgentModel : AbstractRosettaModelObject<CalculationAgentModel>
    {
        private static readonly IRosettaMetaData<CalculationAgentModel> metaData = new CalculationAgentModelMeta();
        
        [JsonConstructor]
        public CalculationAgentModel(CalculationAgent? calculationAgent, Enums.BusinessCenter? calculationAgentBusinessCenter)
        {
            CalculationAgent = calculationAgent;
            CalculationAgentBusinessCenter = calculationAgentBusinessCenter;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CalculationAgentModel> MetaData => metaData;
        
        /// <summary>
        /// The ISDA calculation agent responsible for performing duties as defined in the applicable product definitions.
        /// </summary>
        public CalculationAgent? CalculationAgent { get; }
        
        /// <summary>
        /// The city in which the office through which ISDA Calculation Agent is acting for purposes of the transaction is located. The short-form confirm for a trade that is executed under a Sovereign or Asia-Pacific Master Confirmation Agreement (MCA), does not need to specify the Calculation Agent. However, the confirm does need to specify the Calculation Agent city. This is due to the fact that the MCA sets the value for Calculation Agent but does not set the value for Calculation Agent city.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.BusinessCenter? CalculationAgentBusinessCenter { get; }
    }
    
    /// <summary>
    /// Represents the parameters for describing how often something (such as collateral interest) is to be calculated.
    /// </summary>
    public class CalculationFrequency : AbstractRosettaModelObject<CalculationFrequency>
    {
        private static readonly IRosettaMetaData<CalculationFrequency> metaData = new CalculationFrequencyMeta();
        
        [JsonConstructor]
        public CalculationFrequency(IEnumerable<Enums.BusinessCenter> businessCenter, BusinessCenterTime dateLocation, decimal? dayOfMonth, Enums.DayOfWeek? dayOfWeek, decimal? monthOfYear, decimal offsetDays, Period period, decimal? weekOfMonth)
        {
            BusinessCenter = businessCenter;
            DateLocation = dateLocation;
            DayOfMonth = dayOfMonth;
            DayOfWeek = dayOfWeek;
            MonthOfYear = monthOfYear;
            OffsetDays = offsetDays;
            Period = period;
            WeekOfMonth = weekOfMonth;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CalculationFrequency> MetaData => metaData;
        
        /// <summary>
        /// Specifies the business center for adjustment of calculation period.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public IEnumerable<Enums.BusinessCenter> BusinessCenter { get; }
        
        /// <summary>
        /// Specifies where is the time measured.
        /// </summary>
        public BusinessCenterTime DateLocation { get; }
        
        /// <summary>
        /// Specifies the day of the month if used.
        /// </summary>
        public decimal? DayOfMonth { get; }
        
        /// <summary>
        /// Specifies the day of the week if used.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.DayOfWeek? DayOfWeek { get; }
        
        /// <summary>
        /// Specifies the month of the year if used.
        /// </summary>
        public decimal? MonthOfYear { get; }
        
        /// <summary>
        /// Specifies how many days from the trigger event should the payment occur.
        /// </summary>
        public decimal OffsetDays { get; }
        
        /// <summary>
        /// Specifies the time period at which calculation is performed, e.g. 1 month.
        /// </summary>
        public Period Period { get; }
        
        /// <summary>
        /// Specifies the week of the month if used.
        /// </summary>
        public decimal? WeekOfMonth { get; }
    }
    
    /// <summary>
    /// A data defining:  the parameters used in the calculation of a fixed or floating rate calculation period amount. This data forms:  part of cashflows representation of a swap stream.
    /// </summary>
    public class CalculationPeriod : AbstractRosettaModelObject<CalculationPeriod>, ICalculationPeriodBase
    {
        private static readonly IRosettaMetaData<CalculationPeriod> metaData = new CalculationPeriodMeta();
        
        [JsonConstructor]
        public CalculationPeriod(int? calculationPeriodNumberOfDays, decimal? dayCountYearFraction, decimal? fixedRate, FloatingRateDefinition? floatingRateDefinition, Money? forecastAmount, decimal? forecastRate, FxLinkedNotionalAmount? fxLinkedNotionalAmount, decimal? notionalAmount, LocalDate? unadjustedEndDate, LocalDate? unadjustedStartDate, LocalDate? adjustedEndDate, LocalDate? adjustedStartDate, _MetaFields? meta)
        {
            CalculationPeriodNumberOfDays = calculationPeriodNumberOfDays;
            DayCountYearFraction = dayCountYearFraction;
            FixedRate = fixedRate;
            FloatingRateDefinition = floatingRateDefinition;
            ForecastAmount = forecastAmount;
            ForecastRate = forecastRate;
            FxLinkedNotionalAmount = fxLinkedNotionalAmount;
            NotionalAmount = notionalAmount;
            UnadjustedEndDate = unadjustedEndDate;
            UnadjustedStartDate = unadjustedStartDate;
            AdjustedEndDate = adjustedEndDate;
            AdjustedStartDate = adjustedStartDate;
            Meta = meta;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CalculationPeriod> MetaData => metaData;
        
        /// <summary>
        /// The number of days from the adjusted effective / start date to the adjusted termination / end date calculated in accordance with the applicable day count fraction.
        /// </summary>
        public int? CalculationPeriodNumberOfDays { get; }
        
        /// <summary>
        /// The year fraction value of the calculation period, result of applying the ISDA rules for day count fraction defined in the ISDA Annex.
        /// </summary>
        public decimal? DayCountYearFraction { get; }
        
        /// <summary>
        /// The calculation period fixed rate. A per annum rate, expressed as a decimal. A fixed rate of 5% would be represented as 0.05.
        /// </summary>
        public decimal? FixedRate { get; }
        
        /// <summary>
        /// The floating rate reset information for the calculation period.
        /// </summary>
        public FloatingRateDefinition? FloatingRateDefinition { get; }
        
        /// <summary>
        /// The amount representing the forecast of the accrued value of the calculation period. An intermediate value used to generate the forecastPaymentAmount in the PaymentCalculationPeriod.
        /// </summary>
        public Money? ForecastAmount { get; }
        
        /// <summary>
        /// A value representing the forecast rate used to calculate the forecast future value of the accrual period. This is a calculated rate determined based on averaging the rates in the rateObservation elements, and incorporates all of the rate treatment and averaging rules. A value of 1% should be represented as 0.01.
        /// </summary>
        public decimal? ForecastRate { get; }
        
        /// <summary>
        /// The amount that a cashflow will accrue interest on. This is the calculated amount of the FX linked - i.e. the other currency notional amount multiplied by the appropriate FX spot rate.
        /// </summary>
        public FxLinkedNotionalAmount? FxLinkedNotionalAmount { get; }
        
        /// <summary>
        /// The amount that a cashflow will accrue interest on.
        /// </summary>
        public decimal? NotionalAmount { get; }
        
        /// <summary>
        /// The calculation end date, unadjusted.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? UnadjustedEndDate { get; }
        
        /// <summary>
        /// The calculation start date, unadjusted.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? UnadjustedStartDate { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? AdjustedEndDate { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? AdjustedStartDate { get; }
        
        public _MetaFields? Meta { get; }
    }
    
    /// <summary>
    /// The calculation period adjusted start and end dates, which are the baseline arguments needed to compute an interest accrual calculation.
    /// </summary>
    public class CalculationPeriodBase : AbstractRosettaModelObject<CalculationPeriodBase>, ICalculationPeriodBase
    {
        private static readonly IRosettaMetaData<CalculationPeriodBase> metaData = new CalculationPeriodBaseMeta();
        
        [JsonConstructor]
        public CalculationPeriodBase(LocalDate? adjustedEndDate, LocalDate? adjustedStartDate, _MetaFields? meta)
        {
            AdjustedEndDate = adjustedEndDate;
            AdjustedStartDate = adjustedStartDate;
            Meta = meta;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CalculationPeriodBase> MetaData => metaData;
        
        /// <inheritdoc/>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? AdjustedEndDate { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? AdjustedStartDate { get; }
        
        public _MetaFields? Meta { get; }
    }
    
    public class CalculationPeriodData : AbstractRosettaModelObject<CalculationPeriodData>
    {
        private static readonly IRosettaMetaData<CalculationPeriodData> metaData = new CalculationPeriodDataMeta();
        
        [JsonConstructor]
        public CalculationPeriodData(int daysInLeapYearPeriod, int daysInPeriod, LocalDate endDate, bool isFirstPeriod, bool isLastPeriod, LocalDate startDate)
        {
            DaysInLeapYearPeriod = daysInLeapYearPeriod;
            DaysInPeriod = daysInPeriod;
            EndDate = endDate;
            IsFirstPeriod = isFirstPeriod;
            IsLastPeriod = isLastPeriod;
            StartDate = startDate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CalculationPeriodData> MetaData => metaData;
        
        public int DaysInLeapYearPeriod { get; }
        
        public int DaysInPeriod { get; }
        
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate EndDate { get; }
        
        public bool IsFirstPeriod { get; }
        
        public bool IsLastPeriod { get; }
        
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate StartDate { get; }
    }
    
    /// <summary>
    /// A data for:  defining the parameters used to generate the calculation period dates schedule, including the specification of any initial or final stub calculation periods. A calculation period schedule consists of an optional initial stub calculation period, one or more regular calculation periods and an optional final stub calculation period. In the absence of any initial or final stub calculation periods, the regular part of the calculation period schedule is assumed to be between the effective date and the termination date. No implicit stubs are allowed, i.e. stubs must be explicitly specified using an appropriate combination of firstPeriodStartDate, firstRegularPeriodStartDate and lastRegularPeriodEndDate.
    /// </summary>
    public class CalculationPeriodDates : AbstractRosettaModelObject<CalculationPeriodDates>
    {
        private static readonly IRosettaMetaData<CalculationPeriodDates> metaData = new CalculationPeriodDatesMeta();
        
        [JsonConstructor]
        public CalculationPeriodDates(BusinessDayAdjustments? calculationPeriodDatesAdjustments, CalculationPeriodFrequency? calculationPeriodFrequency, AdjustableOrRelativeDate? effectiveDate, LocalDate? firstCompoundingPeriodEndDate, AdjustableOrRelativeDate? firstPeriodStartDate, LocalDate? firstRegularPeriodStartDate, LocalDate? lastRegularPeriodEndDate, _MetaFields? meta, Enums.StubPeriodType? stubPeriodType, AdjustableOrRelativeDate? terminationDate)
        {
            CalculationPeriodDatesAdjustments = calculationPeriodDatesAdjustments;
            CalculationPeriodFrequency = calculationPeriodFrequency;
            EffectiveDate = effectiveDate;
            FirstCompoundingPeriodEndDate = firstCompoundingPeriodEndDate;
            FirstPeriodStartDate = firstPeriodStartDate;
            FirstRegularPeriodStartDate = firstRegularPeriodStartDate;
            LastRegularPeriodEndDate = lastRegularPeriodEndDate;
            Meta = meta;
            StubPeriodType = stubPeriodType;
            TerminationDate = terminationDate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CalculationPeriodDates> MetaData => metaData;
        
        /// <summary>
        /// The specification of the business day convention and financial business centers used for adjusting any calculation period date if it would otherwise fall on a day that is not a business day in the specified business center.
        /// </summary>
        public BusinessDayAdjustments? CalculationPeriodDatesAdjustments { get; }
        
        /// <summary>
        /// The frequency at which calculation period end dates occur with the regular part of the calculation period schedule and their roll date convention.
        /// </summary>
        public CalculationPeriodFrequency? CalculationPeriodFrequency { get; }
        
        /// <summary>
        /// The first day of the terms of the trade. This day may be subject to adjustment in accordance with a business day convention.
        /// </summary>
        public AdjustableOrRelativeDate? EffectiveDate { get; }
        
        /// <summary>
        /// The end date of the initial compounding period when compounding is applicable. It must only be specified when the compoundingMethod element is present and not equal to a value of None. This date may be subject to adjustment in accordance with any adjustments specified in calculationPeriodDatesAdjustments.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? FirstCompoundingPeriodEndDate { get; }
        
        /// <summary>
        /// The start date of the calculation period. FpML specifies that for interest rate swaps this date must only be specified if it is not equal to the effective date. It is always specified in the case of equity swaps and credit default swaps with periodic payments. This date may be subject to adjustment in accordance with a business day convention.
        /// </summary>
        public AdjustableOrRelativeDate? FirstPeriodStartDate { get; }
        
        /// <summary>
        /// The start date of the regular part of the calculation period schedule. It must only be specified if there is an initial stub calculation period. This day may be subject to adjustment in accordance with any adjustments specified in calculationPeriodDatesAdjustments.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? FirstRegularPeriodStartDate { get; }
        
        /// <summary>
        /// The end date of the regular part of the calculation period schedule. It must only be specified if there is a final stub calculation period. This day may be subject to adjustment in accordance with any adjustments specified in calculationPeriodDatesAdjustments.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? LastRegularPeriodEndDate { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <summary>
        /// Method to allocate any irregular period remaining after regular periods have been allocated between the effective and termination date.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.StubPeriodType? StubPeriodType { get; }
        
        /// <summary>
        /// The last day of the terms of the trade. This date may be subject to adjustments in accordance with the business day convention. It can also be specified in relation to another scheduled date (e.g. the last payment date).
        /// </summary>
        public AdjustableOrRelativeDate? TerminationDate { get; }
    }
    
    /// <summary>
    /// A class to specify the frequency at which calculation period end dates occur within the regular part of the calculation period schedule and their roll date convention.
    /// </summary>
    public class CalculationPeriodFrequency : AbstractRosettaModelObject<CalculationPeriodFrequency>, IFrequency
    {
        private static readonly IRosettaMetaData<CalculationPeriodFrequency> metaData = new CalculationPeriodFrequencyMeta();
        
        [JsonConstructor]
        public CalculationPeriodFrequency(bool? balanceOfFirstPeriod, Enums.RollConvention rollConvention, _MetaFields? meta, Enums.PeriodExtended period, int periodMultiplier)
        {
            BalanceOfFirstPeriod = balanceOfFirstPeriod;
            RollConvention = rollConvention;
            Meta = meta;
            Period = period;
            PeriodMultiplier = periodMultiplier;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CalculationPeriodFrequency> MetaData => metaData;
        
        /// <summary>
        /// Indicates, when true, that that the first Calculation Period should run from the Effective Date to the end of the calendar period in which the Effective Date falls, e.g. Jan 15 - Jan 31 if the calculation periods are one month long and Effective Date is Jan 15. If false, the first Calculation Period should run from the Effective Date for one whole period, e.g. Jan 15 to Feb 14 if the calculation periods are one month long and Effective Date is Jan 15. Mostly used in Commmodity Swaps.
        /// </summary>
        public bool? BalanceOfFirstPeriod { get; }
        
        /// <summary>
        /// The roll convention specifies the period term as part of a periodic schedule, i.e. the calculation period end date within the regular part of the calculation period. The value could be a rule, e.g. IMM Settlement Dates, which is the 3rd Wednesday of the month, or it could be a specific day of the month, such as the first day of the applicable month. It is used in conjunction with a frequency and the regular period start date of a calculation period.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.RollConvention RollConvention { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.PeriodExtended Period { get; }
        
        /// <inheritdoc/>
        public int PeriodMultiplier { get; }
    }
    
    /// <summary>
    /// A type for defining a calendar spread feature.
    /// </summary>
    public class CalendarSpread : AbstractRosettaModelObject<CalendarSpread>
    {
        private static readonly IRosettaMetaData<CalendarSpread> metaData = new CalendarSpreadMeta();
        
        [JsonConstructor]
        public CalendarSpread(AdjustableOrRelativeDate expirationDateTwo)
        {
            ExpirationDateTwo = expirationDateTwo;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CalendarSpread> MetaData => metaData;
        
        public AdjustableOrRelativeDate ExpirationDateTwo { get; }
    }
    
    /// <summary>
    /// A data defining:  the right of a party to cancel a swap transaction on the specified exercise dates. The provision is for &apos;walk-away&apos; cancellation (i.e. the fair value of the swap is not paid). A fee payable on exercise can be specified. As a difference from the FpML construct, the canonical model extends the BuyerSeller class.
    /// </summary>
    public class CancelableProvision : AbstractRosettaModelObject<CancelableProvision>, IBuyerSeller
    {
        private static readonly IRosettaMetaData<CancelableProvision> metaData = new CancelableProvisionMeta();
        
        [JsonConstructor]
        public CancelableProvision(AmericanExercise? americanExercise, BermudaExercise? bermudaExercise, Enums.CallingParty? callingParty, CancelableProvisionAdjustedDates? cancelableProvisionAdjustedDates, BusinessCenterTime? earliestCancellationTime, AdjustableOrRelativeDate? earliestDate, AdjustableOrRelativeDates? effectiveDate, Period? effectivePeriod, EuropeanExercise? europeanExercise, ExerciseNotice? exerciseNotice, AdjustableOrRelativeDate? expirationDate, IEnumerable<FinalCalculationPeriodDateAdjustment> finalCalculationPeriodDateAdjustment, bool followUpConfirmation, Transfer? initialFee, BusinessCenterTime? latestCancelationTime, Enums.CounterpartyRole buyer, Enums.CounterpartyRole seller)
        {
            AmericanExercise = americanExercise;
            BermudaExercise = bermudaExercise;
            CallingParty = callingParty;
            CancelableProvisionAdjustedDates = cancelableProvisionAdjustedDates;
            EarliestCancellationTime = earliestCancellationTime;
            EarliestDate = earliestDate;
            EffectiveDate = effectiveDate;
            EffectivePeriod = effectivePeriod;
            EuropeanExercise = europeanExercise;
            ExerciseNotice = exerciseNotice;
            ExpirationDate = expirationDate;
            FinalCalculationPeriodDateAdjustment = finalCalculationPeriodDateAdjustment;
            FollowUpConfirmation = followUpConfirmation;
            InitialFee = initialFee;
            LatestCancelationTime = latestCancelationTime;
            Buyer = buyer;
            Seller = seller;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CancelableProvision> MetaData => metaData;
        
        /// <summary>
        /// American exercise. FpML implementations consists in an exercise substitution group.
        /// </summary>
        public AmericanExercise? AmericanExercise { get; }
        
        /// <summary>
        /// Bermuda exercise. FpML implementations consists in an exercise substitution group.
        /// </summary>
        public BermudaExercise? BermudaExercise { get; }
        
        /// <summary>
        /// The party with right to exercise a cancellation. Allows for buyer, seller or either.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CallingParty? CallingParty { get; }
        
        /// <summary>
        /// The adjusted dates associated with a cancelable provision. These dates have been adjusted for any applicable business day convention.
        /// </summary>
        public CancelableProvisionAdjustedDates? CancelableProvisionAdjustedDates { get; }
        
        /// <summary>
        /// The earliest time in a business day that notice of cancelation can be given.
        /// </summary>
        public BusinessCenterTime? EarliestCancellationTime { get; }
        
        /// <summary>
        /// The first day when cancelation is permitted to take effect. A party may give notice prior to this date and taken together with the effective period would be necessary to cancel on this date.
        /// </summary>
        public AdjustableOrRelativeDate? EarliestDate { get; }
        
        /// <summary>
        /// The effective date if cancelation is invoked otherwise the cancellation period defines the cancellation date.
        /// </summary>
        public AdjustableOrRelativeDates? EffectiveDate { get; }
        
        /// <summary>
        /// Effective period for cancelation when notice is given. This is the period after notice is given that cancellation becomes effecticve.
        /// </summary>
        public Period? EffectivePeriod { get; }
        
        /// <summary>
        /// European exercise. FpML implementations consists in an exercise substitution group.
        /// </summary>
        public EuropeanExercise? EuropeanExercise { get; }
        
        /// <summary>
        /// Definition of the party to whom notice of exercise should be given.
        /// </summary>
        public ExerciseNotice? ExerciseNotice { get; }
        
        /// <summary>
        /// The last day within the term of the contract that cancelation is allowed.
        /// </summary>
        public AdjustableOrRelativeDate? ExpirationDate { get; }
        
        /// <summary>
        /// Business date convention adjustment to final payment period per leg (swapStream) upon exercise event. The adjustments can be made in-line with leg level BDC&apos;s or they can be specified separately.
        /// </summary>
        public IEnumerable<FinalCalculationPeriodDateAdjustment> FinalCalculationPeriodDateAdjustment { get; }
        
        /// <summary>
        /// A flag to indicate whether follow-up confirmation of exercise (written or electronic) is required following telephonic notice by the buyer to the seller or seller&apos;s agent.
        /// </summary>
        public bool FollowUpConfirmation { get; }
        
        /// <summary>
        /// An initial fee for the cancelable option.
        /// </summary>
        public Transfer? InitialFee { get; }
        
        /// <summary>
        /// The latest time at which notice of cancelation can be given.
        /// </summary>
        public BusinessCenterTime? LatestCancelationTime { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CounterpartyRole Buyer { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CounterpartyRole Seller { get; }
    }
    
    /// <summary>
    /// A data to:  define the adjusted dates for a cancelable provision on a swap transaction.
    /// </summary>
    public class CancelableProvisionAdjustedDates : AbstractRosettaModelObject<CancelableProvisionAdjustedDates>
    {
        private static readonly IRosettaMetaData<CancelableProvisionAdjustedDates> metaData = new CancelableProvisionAdjustedDatesMeta();
        
        [JsonConstructor]
        public CancelableProvisionAdjustedDates(IEnumerable<CancellationEvent> cancellationEvent)
        {
            CancellationEvent = cancellationEvent;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CancelableProvisionAdjustedDates> MetaData => metaData;
        
        /// <summary>
        /// The adjusted dates for an individual cancellation date.
        /// </summary>
        public IEnumerable<CancellationEvent> CancellationEvent { get; }
    }
    
    /// <summary>
    /// The adjusted dates for a specific cancellation date, including the adjusted exercise date and adjusted termination date.
    /// </summary>
    public class CancellationEvent : AbstractRosettaModelObject<CancellationEvent>
    {
        private static readonly IRosettaMetaData<CancellationEvent> metaData = new CancellationEventMeta();
        
        [JsonConstructor]
        public CancellationEvent(LocalDate adjustedEarlyTerminationDate, LocalDate adjustedExerciseDate, _MetaFields? meta)
        {
            AdjustedEarlyTerminationDate = adjustedEarlyTerminationDate;
            AdjustedExerciseDate = adjustedExerciseDate;
            Meta = meta;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CancellationEvent> MetaData => metaData;
        
        /// <summary>
        /// The early termination date that is applicable if an early termination provision is exercised. This date should already be adjusted for any applicable business day convention.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate AdjustedEarlyTerminationDate { get; }
        
        /// <summary>
        /// The date on which option exercise takes place. This date should already be adjusted for any applicable business day convention.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate AdjustedExerciseDate { get; }
        
        public _MetaFields? Meta { get; }
    }
    
    /// <summary>
    /// This type is a generic structure that can represent the parameters of several mid-market valuation and replacement value methods described in the 2021 ISDA Definitions.
    /// </summary>
    public class CashCollateralValuationMethod : AbstractRosettaModelObject<CashCollateralValuationMethod>
    {
        private static readonly IRosettaMetaData<CashCollateralValuationMethod> metaData = new CashCollateralValuationMethodMeta();
        
        [JsonConstructor]
        public CashCollateralValuationMethod(FieldWithMetaString? agreedDiscountRate, Enums.CsaType? applicableCsa, string? cashCollateralCurrency, FieldWithMetaString? cashCollateralInterestRate, bool? prescribedDocumentationAdjustment, IEnumerable<Enums.PartyDetermination> protectedParty)
        {
            AgreedDiscountRate = agreedDiscountRate;
            ApplicableCsa = applicableCsa;
            CashCollateralCurrency = cashCollateralCurrency;
            CashCollateralInterestRate = cashCollateralInterestRate;
            PrescribedDocumentationAdjustment = prescribedDocumentationAdjustment;
            ProtectedParty = protectedParty;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CashCollateralValuationMethod> MetaData => metaData;
        
        /// <summary>
        /// This may be used to indicate the discount rate to be used for cash collateral for cash settlement purposes.
        /// </summary>
        public FieldWithMetaString? AgreedDiscountRate { get; }
        
        /// <summary>
        /// This may be used to specify what type of CSA (credit support annex/agreement) is to be used for cash settlement purposes.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CsaType? ApplicableCsa { get; }
        
        /// <summary>
        /// This may be used to indicate the currency of cash collateral for cash settlement purposes.
        /// </summary>
        public string? CashCollateralCurrency { get; }
        
        /// <summary>
        /// This may be used to indicate the interest rate to be used for cash collateral for cash settlement purposes.
        /// </summary>
        public FieldWithMetaString? CashCollateralInterestRate { get; }
        
        /// <summary>
        /// This may be used to indicate that &apos;prescribed documentation adjustment&apos; is applicable.
        /// </summary>
        public bool? PrescribedDocumentationAdjustment { get; }
        
        /// <summary>
        /// This may be used to specify which party is protected (e.g. under Replacement Value cash settlement methods).
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public IEnumerable<Enums.PartyDetermination> ProtectedParty { get; }
    }
    
    /// <summary>
    /// Specifies the nature of a cash price either as a fee type, cash price type, or premium expression.
    /// </summary>
    public class CashPrice : AbstractRosettaModelObject<CashPrice>
    {
        private static readonly IRosettaMetaData<CashPrice> metaData = new CashPriceMeta();
        
        [JsonConstructor]
        public CashPrice(Enums.CashPriceType cashPriceType, Enums.FeeType? feeType, PremiumExpression? premiumExpression)
        {
            CashPriceType = cashPriceType;
            FeeType = feeType;
            PremiumExpression = premiumExpression;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CashPrice> MetaData => metaData;
        
        /// <summary>
        /// Specifies the type of Cash Price.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CashPriceType CashPriceType { get; }
        
        /// <summary>
        /// Specifies the event type associated with a fee.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.FeeType? FeeType { get; }
        
        /// <summary>
        /// Specifies a premium when expressed in a way other than an amount, and any required forward starting price definition.
        /// </summary>
        public PremiumExpression? PremiumExpression { get; }
    }
    
    /// <summary>
    /// Defines the terms required to compute and settle a cash settlement amount according to a fixing value, including the fixing source, fixing method and fixing date. In FpML, PhysicalSettlementTerms and CashSettlementTerms extend SettlementTerms. In the CDM, this extension paradigm has not been used because SettlementTerms class has been used for purposes related to securities transactions, while it is not used as such in the FpML standard (i.e. only as an abstract construct.
    /// </summary>
    public class CashSettlementTerms : AbstractRosettaModelObject<CashSettlementTerms>
    {
        private static readonly IRosettaMetaData<CashSettlementTerms> metaData = new CashSettlementTermsMeta();
        
        [JsonConstructor]
        public CashSettlementTerms(bool? accruedInterest, Money? cashSettlementAmount, Enums.CashSettlementMethod? cashSettlementMethod, bool? fixedSettlement, _MetaFields? meta, decimal? recoveryFactor, ValuationDate? valuationDate, ValuationMethod? valuationMethod, BusinessCenterTime? valuationTime)
        {
            AccruedInterest = accruedInterest;
            CashSettlementAmount = cashSettlementAmount;
            CashSettlementMethod = cashSettlementMethod;
            FixedSettlement = fixedSettlement;
            Meta = meta;
            RecoveryFactor = recoveryFactor;
            ValuationDate = valuationDate;
            ValuationMethod = valuationMethod;
            ValuationTime = valuationTime;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CashSettlementTerms> MetaData => metaData;
        
        /// <summary>
        /// Indicates whether accrued interest is included (true) or not (false). For cash settlement this specifies whether quotations should be obtained inclusive or not of accrued interest. For physical settlement this specifies whether the buyer should deliver the obligation with an outstanding principal balance that includes or excludes accrued interest. ISDA 2003 Term: Include/Exclude Accrued Interest.
        /// </summary>
        public bool? AccruedInterest { get; }
        
        /// <summary>
        /// The amount paid by the seller to the buyer for cash settlement on the cash settlement date. If not otherwise specified, would typically be calculated as 100 (or the Reference Price) minus the price of the Reference Obligation (all expressed as a percentage) times Floating Rate Payer Calculation Amount. ISDA 2003 Term: Cash Settlement Amount.
        /// </summary>
        public Money? CashSettlementAmount { get; }
        
        /// <summary>
        /// Specifies the type of cash settlement method: cash price, yield curve etc.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CashSettlementMethod? CashSettlementMethod { get; }
        
        /// <summary>
        /// Used for Recovery Lock, to indicate whether fixed Settlement is Applicable or Not Applicable. If Buyer fails to deliver an effective Notice of Physical Settlement on or before the Buyer NOPS Cut-off Date, and if Seller fails to deliver an effective Seller NOPS on or before the Seller NOPS Cut-off Date, then either: (a) if Fixed Settlement is specified in the related Confirmation as not applicable, then the Seller NOPS Cut-off Date shall be the Termination Date; or (b) if Fixed Settlement is specified in the related Confirmation as applicable, then: (i) if the Fixed Settlement Amount is a positive number, Seller shall, subject to Section 3.1 (except for the requirement of satisfaction of the Notice of Physical Settlement Condition to Settlement), pay the Fixed Settlement Amount to Buyer on the Fixed Settlement Payment Date; and (ii) if the Fixed Settlement Amount is a negative number, Buyer shall, subject to Section 3.1 (except for the requirement of satisfaction of the Notice of Physical Settlement Condition to Settlement), pay the absolute value of the Fixed Settlement Amount to Seller on the Fixed Settlement Payment Date.
        /// </summary>
        public bool? FixedSettlement { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <summary>
        /// Used for fixed recovery, specifies the recovery level, determined at contract formation, to be applied on a default. Used to calculate the amount paid by the seller to the buyer for cash settlement on the cash settlement date. Amount calculation is (1 minus the Recovery Factor) multiplied by the Floating Rate Payer Calculation Amount. The currency will be derived from the Floating Rate Payer Calculation Amount.
        /// </summary>
        public decimal? RecoveryFactor { get; }
        
        /// <summary>
        /// Defines the different methods to specify a valuation date, as used for cash settlement. The Single / Multiple ValuationDate is used for the determination of recovery in a credit event, the RelativeDateOffset is used for cash-settled option, and FxFixingDate is used for cross-currency settlement.
        /// </summary>
        public ValuationDate? ValuationDate { get; }
        
        /// <summary>
        /// Specifies the parameters required to obtain a valuation, including the source, quotation method (bid, mid etc.) and any applicable quotation amount.
        /// </summary>
        public ValuationMethod? ValuationMethod { get; }
        
        /// <summary>
        /// The time of the cash settlement valuation date when the cash settlement amount will be determined according to the cash settlement method, if the parties have not otherwise been able to agree the cash settlement amount. When using quations, this is the time of day in the specified business center when the calculation agent seeks quotations for an amount of the reference obligation for purposes of cash settlement. ISDA 2003 Term: Valuation Time.
        /// </summary>
        public BusinessCenterTime? ValuationTime { get; }
    }
    
    /// <summary>
    /// Class to specify a cashflow, i.e. the outcome of either of computation (e.g. interest accrual) or an assessment of some sort (e.g. a fee). The cashflow can then be turned into a cash transfer, artefact to be used as the input to a payment system or the outcome of it. The associated globalKey denotes the ability to associate a hash value to the Cashflow instantiations for the purpose of model cross-referencing, in support of functionality such as the event effect and the lineage.
    /// </summary>
    public class Cashflow : AbstractRosettaModelObject<Cashflow>, IPayoutBase
    {
        private static readonly IRosettaMetaData<Cashflow> metaData = new CashflowMeta();
        
        [JsonConstructor]
        public Cashflow(CashflowType cashflowType, _MetaFields? meta, PaymentDiscounting? paymentDiscounting, PayerReceiver payerReceiver, ResolvablePriceQuantity? priceQuantity, PrincipalPayments? principalPayment, SettlementTerms? settlementTerms)
        {
            CashflowType = cashflowType;
            Meta = meta;
            PaymentDiscounting = paymentDiscounting;
            PayerReceiver = payerReceiver;
            PriceQuantity = priceQuantity;
            PrincipalPayment = principalPayment;
            SettlementTerms = settlementTerms;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Cashflow> MetaData => metaData;
        
        /// <summary>
        /// The qualification of the type of cashflow, e.g. brokerage fee, premium, upfront fee etc. Particularly relevant when it cannot be inferred directly through lineage.
        /// </summary>
        public CashflowType CashflowType { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <summary>
        /// FpML specifies the FpML PaymentDiscounting.model group for representing the discounting elements that can be associated with a payment.
        /// </summary>
        public PaymentDiscounting? PaymentDiscounting { get; }
        
        /// <inheritdoc/>
        public PayerReceiver PayerReceiver { get; }
        
        /// <inheritdoc/>
        public ResolvablePriceQuantity? PriceQuantity { get; }
        
        /// <inheritdoc/>
        public PrincipalPayments? PrincipalPayment { get; }
        
        /// <inheritdoc/>
        public SettlementTerms? SettlementTerms { get; }
    }
    
    /// <summary>
    /// A data defining:  the cashflow representation of a swap trade.
    /// </summary>
    public class CashflowRepresentation : AbstractRosettaModelObject<CashflowRepresentation>
    {
        private static readonly IRosettaMetaData<CashflowRepresentation> metaData = new CashflowRepresentationMeta();
        
        [JsonConstructor]
        public CashflowRepresentation(bool cashflowsMatchParameters, IEnumerable<PaymentCalculationPeriod> paymentCalculationPeriod)
        {
            CashflowsMatchParameters = cashflowsMatchParameters;
            PaymentCalculationPeriod = paymentCalculationPeriod;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CashflowRepresentation> MetaData => metaData;
        
        /// <summary>
        /// A true/false flag to indicate whether the cashflows match the parametric definition of the stream, i.e. whether the cashflows could be regenerated from the parameters without loss of information.
        /// </summary>
        public bool CashflowsMatchParameters { get; }
        
        /// <summary>
        /// The adjusted payment date and associated calculation period parameters required to calculate the actual or projected payment amount. A list of payment calculation period elements may be ordered in the document by ascending adjusted payment date. An FpML document containing an unordered list of payment calculation periods is still regarded as a conformant document.
        /// </summary>
        public IEnumerable<PaymentCalculationPeriod> PaymentCalculationPeriod { get; }
    }
    
    /// <summary>
    /// Characterises the type of cashflow, which can result from either a scheduled or a non-scheduled lifecycle event.
    /// </summary>
    public class CashflowType : AbstractRosettaModelObject<CashflowType>
    {
        private static readonly IRosettaMetaData<CashflowType> metaData = new CashflowTypeMeta();
        
        [JsonConstructor]
        public CashflowType(CashPrice? cashPrice, Enums.ScheduledTransfer? cashflowType, Enums.GrossOrNet? grossOrNet, Enums.PriceExpression? priceExpression)
        {
            CashPrice = cashPrice;
            CashflowTypeValue = cashflowType;
            GrossOrNet = grossOrNet;
            PriceExpression = priceExpression;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CashflowType> MetaData => metaData;
        
        /// <summary>
        /// Type of cashflow corresponding to a non-scheduled event, where a price must be agreed between the parties.
        /// </summary>
        public CashPrice? CashPrice { get; }
        
        /// <summary>
        /// Type of cashflow corresponding to a scheduled event.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        [JsonProperty(PropertyName = "cashflowType")]
        public Enums.ScheduledTransfer? CashflowTypeValue { get; }
        
        /// <summary>
        /// Whether the cashflow is gross, net or a commission, if any.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.GrossOrNet? GrossOrNet { get; }
        
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.PriceExpression? PriceExpression { get; }
    }
    
    /// <summary>
    ///  Class specifying the bond price as either clean or dirty in a bond valuation model.
    /// </summary>
    public class CleanOrDirtyPrice : AbstractRosettaModelObject<CleanOrDirtyPrice>
    {
        private static readonly IRosettaMetaData<CleanOrDirtyPrice> metaData = new CleanOrDirtyPriceMeta();
        
        [JsonConstructor]
        public CleanOrDirtyPrice(CleanPrice? cleanPrice, decimal? dirtyPrice)
        {
            CleanPrice = cleanPrice;
            DirtyPrice = dirtyPrice;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CleanOrDirtyPrice> MetaData => metaData;
        
        /// <summary>
        /// The clean price and accruals presented separately.
        /// </summary>
        public CleanPrice? CleanPrice { get; }
        
        /// <summary>
        /// The dirty price presented as a single number.
        /// </summary>
        public decimal? DirtyPrice { get; }
    }
    
    /// <summary>
    ///  Class to specify the clean price of a bond in a bond valuation model, with accruals presented separately, and modelled onto the cleanPrice model in BonPriceAndYield.model in FpML.
    /// </summary>
    public class CleanPrice : AbstractRosettaModelObject<CleanPrice>
    {
        private static readonly IRosettaMetaData<CleanPrice> metaData = new CleanPriceMeta();
        
        [JsonConstructor]
        public CleanPrice(decimal? accruals, decimal cleanPrice, string? dirtyPrice)
        {
            Accruals = accruals;
            CleanPriceValue = cleanPrice;
            DirtyPrice = dirtyPrice;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CleanPrice> MetaData => metaData;
        
        /// <summary>
        /// The accruals as a number.
        /// </summary>
        public decimal? Accruals { get; }
        
        /// <summary>
        /// The clean price as a number.
        /// </summary>
        [JsonProperty(PropertyName = "cleanPrice")]
        public decimal CleanPriceValue { get; }
        
        /// <summary>
        /// Placeholder for a calculation of dirtyPrice based on cleanPrice and accruals.
        /// </summary>
        public string? DirtyPrice { get; }
    }
    
    /// <summary>
    /// All information required to perform the clear life cycle event; the clearing party (CCP), the two parties facing each other on the alpha contract, and optionally the parties acting as clearing members.
    /// </summary>
    public class ClearingInstruction : AbstractRosettaModelObject<ClearingInstruction>
    {
        private static readonly IRosettaMetaData<ClearingInstruction> metaData = new ClearingInstructionMeta();
        
        [JsonConstructor]
        public ClearingInstruction(TradeState alphaContract, Party? clearerParty1, Party? clearerParty2, Party clearingParty, bool? isOpenOffer, Party party1, Party party2)
        {
            AlphaContract = alphaContract;
            ClearerParty1 = clearerParty1;
            ClearerParty2 = clearerParty2;
            ClearingParty = clearingParty;
            IsOpenOffer = isOpenOffer;
            Party1 = party1;
            Party2 = party2;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ClearingInstruction> MetaData => metaData;
        
        /// <summary>
        /// The contract that will be submitted to the clearing house for clearing. The contract should indicate that it should be cleared by assigning a clearing organisation as a party role.
        /// </summary>
        public TradeState AlphaContract { get; }
        
        /// <summary>
        /// Optional party facing the CCP, acting as clearing member for party1.
        /// </summary>
        public Party? ClearerParty1 { get; }
        
        /// <summary>
        /// Optional party facing the CCP, acting as clearing member for party2.
        /// </summary>
        public Party? ClearerParty2 { get; }
        
        /// <summary>
        /// The Central Counter party (CCP) that the contract will be submitted to for clearing.
        /// </summary>
        public Party ClearingParty { get; }
        
        /// <summary>
        /// Open Offer
        /// </summary>
        public bool? IsOpenOffer { get; }
        
        /// <summary>
        /// First party facing the CCP if it is clearing for its own account.
        /// </summary>
        public Party Party1 { get; }
        
        /// <summary>
        /// Second party facing the CCP if it is clearing for its own account.
        /// </summary>
        public Party Party2 { get; }
    }
    
    /// <summary>
    ///  A class to qualify the closed state of an execution or a contract through the combination or a state (e.g. terminated, novated) and a set of dates: activity date, effective date and, when relevant, last payment date.
    /// </summary>
    public class ClosedState : AbstractRosettaModelObject<ClosedState>
    {
        private static readonly IRosettaMetaData<ClosedState> metaData = new ClosedStateMeta();
        
        [JsonConstructor]
        public ClosedState(LocalDate activityDate, LocalDate? effectiveDate, LocalDate? lastPaymentDate, Enums.ClosedState state)
        {
            ActivityDate = activityDate;
            EffectiveDate = effectiveDate;
            LastPaymentDate = lastPaymentDate;
            State = state;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ClosedState> MetaData => metaData;
        
        /// <summary>
        /// The activity date on which the closing state took place, i.e. either the event date of the closing event (e.g. option exercise, contract early termination) or the contractual termination date.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate ActivityDate { get; }
        
        /// <summary>
        /// The date on which the closing event contractually takes effect, when different from the activity date. When an explicit event effective date attribute is associated with the closing event, it will be that date. In the case of a cancellation event, it will be the date on which the cancelled event took place.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? EffectiveDate { get; }
        
        /// <summary>
        /// The date associated with the last payment in relation to the artefact (e.g. contract) to which this closed state applies. As an example, in the case of an early termination event, it would be the settlement date of the associated fee, if applicable.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? LastPaymentDate { get; }
        
        /// <summary>
        /// The qualification of what gave way to the contract or execution closure, e.g. allocation, termination, ...
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.ClosedState State { get; }
    }
    
    /// <summary>
    /// A type for defining the obligations of the counterparty subject to credit support requirements.
    /// </summary>
    public class Collateral : AbstractRosettaModelObject<Collateral>
    {
        private static readonly IRosettaMetaData<Collateral> metaData = new CollateralMeta();
        
        [JsonConstructor]
        public Collateral(IEnumerable<ReferenceWithMetaCollateralPortfolio> collateralPortfolio, CollateralProvisions? collateralProvisions, IndependentAmount? independentAmount, IEnumerable<Identifier> portfolioIdentifier)
        {
            CollateralPortfolio = collateralPortfolio;
            CollateralProvisions = collateralProvisions;
            IndependentAmount = independentAmount;
            PortfolioIdentifier = portfolioIdentifier;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Collateral> MetaData => metaData;
        
        /// <summary>
        /// The collateral portfolios which contain the collateral which covers a trade. (NB: this can be provided by reference to a global key for each CollateralPortfolio object)
        /// </summary>
        public IEnumerable<ReferenceWithMetaCollateralPortfolio> CollateralPortfolio { get; }
        
        /// <summary>
        /// specifies the collateral provisions of the product.
        /// </summary>
        public CollateralProvisions? CollateralProvisions { get; }
        
        /// <summary>
        /// Independent Amount is an amount that usually less creditworthy counterparties are asked to provide. It can either be a fixed amount or a percentage of the Transaction&apos;s value. The Independent Amount can be: (i) transferred before any trading between the parties occurs (as a deposit at a third party&apos;s account or with the counterparty) or (ii) callable after trading has occurred (typically because a downgrade has occurred). In situation (i), the Independent Amount is not included in the calculation of Exposure, but in situation (ii), it is included in the calculation of Exposure. Thus, for situation (ii), the Independent Amount may be transferred along with any collateral call. Independent Amount is a defined term in the ISDA Credit Support Annex. (&apos;with respect to a party, the amount specified as such for that party in Paragraph 13; if no amount is specified, zero&apos;).
        /// </summary>
        public IndependentAmount? IndependentAmount { get; }
        
        /// <summary>
        /// A list of identifiers pointing to the collateral portfolios which contain the collateral which covers a trade.
        /// </summary>
        public IEnumerable<Identifier> PortfolioIdentifier { get; }
    }
    
    /// <summary>
    /// Represents the parameters needed to calculate the floating rate paid on collateral holdings.
    /// </summary>
    public class CollateralAgreementFloatingRate : AbstractRosettaModelObject<CollateralAgreementFloatingRate>, IFloatingRateBase
    {
        private static readonly IRosettaMetaData<CollateralAgreementFloatingRate> metaData = new CollateralAgreementFloatingRateMeta();
        
        [JsonConstructor]
        public CollateralAgreementFloatingRate(bool compressibleSpread, bool negativeInterest, StrikeSchedule? capRateSchedule, StrikeSchedule? floorRateSchedule, _MetaFields? meta, ReferenceWithMetaFloatingRateOption? rateOption, SpreadSchedule? spreadSchedule)
        {
            CompressibleSpread = compressibleSpread;
            NegativeInterest = negativeInterest;
            CapRateSchedule = capRateSchedule;
            FloorRateSchedule = floorRateSchedule;
            Meta = meta;
            RateOption = rateOption;
            SpreadSchedule = spreadSchedule;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CollateralAgreementFloatingRate> MetaData => metaData;
        
        /// <summary>
        /// Specifies how spreads should be applied in a low/negative rate environment.  If true, spread is applied only if rate is positive.
        /// </summary>
        public bool CompressibleSpread { get; }
        
        /// <summary>
        /// Specifies how negative rates should be applied.  If rates go negative, should the payment be reversed (true) or zeroed out (false)?
        /// </summary>
        public bool NegativeInterest { get; }
        
        /// <inheritdoc/>
        public StrikeSchedule? CapRateSchedule { get; }
        
        /// <inheritdoc/>
        public StrikeSchedule? FloorRateSchedule { get; }
        
        public _MetaFields? Meta { get; }
        
        public ReferenceWithMetaFloatingRateOption? RateOption { get; }
        
        /// <inheritdoc/>
        public SpreadSchedule? SpreadSchedule { get; }
    }
    
    /// <summary>
    /// Represents common attributes to define a collateral balance recorded by the principal as held or posted.
    /// </summary>
    public class CollateralBalance : AbstractRosettaModelObject<CollateralBalance>
    {
        private static readonly IRosettaMetaData<CollateralBalance> metaData = new CollateralBalanceMeta();
        
        [JsonConstructor]
        public CollateralBalance(Money amountBaseCurrency, Enums.CollateralStatus? collateralBalanceStatus, Enums.HaircutIndicator? haircutIndicator, PartyReferencePayerReceiver payerReceiver)
        {
            AmountBaseCurrency = amountBaseCurrency;
            CollateralBalanceStatus = collateralBalanceStatus;
            HaircutIndicator = haircutIndicator;
            PayerReceiver = payerReceiver;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CollateralBalance> MetaData => metaData;
        
        /// <summary>
        /// Specifies the collateral balance amount in base currency determined within a collateral legal agreement, or defined for reporting purposes.
        /// </summary>
        public Money AmountBaseCurrency { get; }
        
        /// <summary>
        /// Defines the collateral balance breakdown of settlement status.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CollateralStatus? CollateralBalanceStatus { get; }
        
        /// <summary>
        /// Indicates if the collateral balance amount is based on pre or post haircut, if a haircut is associated with the collateral asset
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.HaircutIndicator? HaircutIndicator { get; }
        
        /// <summary>
        /// Specifies each of the parties in the collateral balance and its perspective with regards to the direction of the collateral balance, posted or received.
        /// </summary>
        public PartyReferencePayerReceiver PayerReceiver { get; }
    }
    
    /// <summary>
    /// Represents a set of criteria used to specify and desribe collateral.
    /// </summary>
    public class CollateralCriteriaBase : AbstractRosettaModelObject<CollateralCriteriaBase>, ICollateralCriteriaBase
    {
        private static readonly IRosettaMetaData<CollateralCriteriaBase> metaData = new CollateralCriteriaBaseMeta();
        
        [JsonConstructor]
        public CollateralCriteriaBase(IEnumerable<AssetCriteria> asset, IEnumerable<IssuerCriteria> issuer)
        {
            Asset = asset;
            Issuer = issuer;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CollateralCriteriaBase> MetaData => metaData;
        
        /// <inheritdoc/>
        public IEnumerable<AssetCriteria> Asset { get; }
        
        /// <inheritdoc/>
        public IEnumerable<IssuerCriteria> Issuer { get; }
    }
    
    /// <summary>
    /// Represents parameters for calculating the amount the floating interest calculation, e.g.  for a single currency or defaults for all currencies.
    /// </summary>
    public class CollateralInterestCalculationParameters : AbstractRosettaModelObject<CollateralInterestCalculationParameters>
    {
        private static readonly IRosettaMetaData<CollateralInterestCalculationParameters> metaData = new CollateralInterestCalculationParametersMeta();
        
        [JsonConstructor]
        public CollateralInterestCalculationParameters(IEnumerable<Enums.BusinessCenter> compoundingBusinessCenter, Enums.CompoundingType? compoundingType, Enums.DayCountFraction dayCountFraction, decimal? fixedRate, CollateralAgreementFloatingRate? floatingRate, bool inBaseCurrency, Rounding? rounding, Enums.RoundingFrequency? roundingFrequency, decimal? withholdingTaxRate)
        {
            CompoundingBusinessCenter = compoundingBusinessCenter;
            CompoundingType = compoundingType;
            DayCountFraction = dayCountFraction;
            FixedRate = fixedRate;
            FloatingRate = floatingRate;
            InBaseCurrency = inBaseCurrency;
            Rounding = rounding;
            RoundingFrequency = roundingFrequency;
            WithholdingTaxRate = withholdingTaxRate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CollateralInterestCalculationParameters> MetaData => metaData;
        
        /// <summary>
        /// Specifies the applicable business centers for compounding.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public IEnumerable<Enums.BusinessCenter> CompoundingBusinessCenter { get; }
        
        /// <summary>
        /// Specifies the type of compounding to be applied (None, Business, Calendar).
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CompoundingType? CompoundingType { get; }
        
        /// <summary>
        /// Specifies the day count fraction to use for that currency.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.DayCountFraction DayCountFraction { get; }
        
        /// <summary>
        /// Specifies the applicable fixed rate  if used.
        /// </summary>
        public decimal? FixedRate { get; }
        
        /// <summary>
        /// Specifies the floating interest rate to be used.
        /// </summary>
        public CollateralAgreementFloatingRate? FloatingRate { get; }
        
        /// <summary>
        /// If True, specifies that the interest transfers should be converted to base currency equivalent, or if False specifies that the transfer should be in the currency of the collateral.
        /// </summary>
        public bool InBaseCurrency { get; }
        
        /// <summary>
        /// Specifies the rounding rules for settling in that currency.
        /// </summary>
        public Rounding? Rounding { get; }
        
        /// <summary>
        /// Specifies when/how often is rounding applied?
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.RoundingFrequency? RoundingFrequency { get; }
        
        /// <summary>
        /// Specifies the withholding tax rate if a withholding tax is applicable.
        /// </summary>
        public decimal? WithholdingTaxRate { get; }
    }
    
    /// <summary>
    /// Represents parameters that describe how calculated interest amounts are handled, i.e. are they transferred/distributed, or is the collateral balance adjusted, is netting done, and any other special handling.
    /// </summary>
    public class CollateralInterestHandlingParameters : AbstractRosettaModelObject<CollateralInterestHandlingParameters>
    {
        private static readonly IRosettaMetaData<CollateralInterestHandlingParameters> metaData = new CollateralInterestHandlingParametersMeta();
        
        [JsonConstructor]
        public CollateralInterestHandlingParameters(bool? accrueInterestOnUnsettledInterest, string? alternativeProvision, Enums.AlternativeToInterestAmount? alternativeToInterestAmount, LocalTime? cutoffTime, bool includeAccrualInMarginCalc, InterestAmountApplication? interestAmountApplication, Enums.CollateralInterestHandling interestPaymentHandling, NumberBound? interestRolloverLimit, bool netInterestWithMarginCalls, bool netPostedAndHeldInterest, CollateralInterestNotification? notification, bool onFullReturn, bool onPartialReturn, IEnumerable<Enums.BusinessCenter> paymentBusinessCenter, NumberBound? writeoffLimit)
        {
            AccrueInterestOnUnsettledInterest = accrueInterestOnUnsettledInterest;
            AlternativeProvision = alternativeProvision;
            AlternativeToInterestAmount = alternativeToInterestAmount;
            CutoffTime = cutoffTime;
            IncludeAccrualInMarginCalc = includeAccrualInMarginCalc;
            InterestAmountApplication = interestAmountApplication;
            InterestPaymentHandling = interestPaymentHandling;
            InterestRolloverLimit = interestRolloverLimit;
            NetInterestWithMarginCalls = netInterestWithMarginCalls;
            NetPostedAndHeldInterest = netPostedAndHeldInterest;
            Notification = notification;
            OnFullReturn = onFullReturn;
            OnPartialReturn = onPartialReturn;
            PaymentBusinessCenter = paymentBusinessCenter;
            WriteoffLimit = writeoffLimit;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CollateralInterestHandlingParameters> MetaData => metaData;
        
        /// <summary>
        /// Indicates whether interest accruing on unsettled interest amount is included (continues to be accrued) in the following period.
        /// </summary>
        public bool? AccrueInterestOnUnsettledInterest { get; }
        
        /// <summary>
        /// Specifies an alternative to interest amount, when the alternative provision clause is specified.
        /// </summary>
        public string? AlternativeProvision { get; }
        
        /// <summary>
        /// Specifies the alternative to interest amounts.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.AlternativeToInterestAmount? AlternativeToInterestAmount { get; }
        
        /// <summary>
        /// Specifies the time of day that interest needs to be confirmed by.
        /// </summary>
        public LocalTime? CutoffTime { get; }
        
        /// <summary>
        /// Indicates whether or not to include the open interest accrual in the margin calculation.
        /// </summary>
        public bool IncludeAccrualInMarginCalc { get; }
        
        /// <summary>
        /// The application of Interest Amount with respect to the Delivery Amount and the Return Amount.
        /// </summary>
        public InterestAmountApplication? InterestAmountApplication { get; }
        
        /// <summary>
        /// Specifies how the collateral interest is to be handled.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CollateralInterestHandling InterestPaymentHandling { get; }
        
        /// <summary>
        /// Specifies the level below which the interest will be rolled over.
        /// </summary>
        public NumberBound? InterestRolloverLimit { get; }
        
        /// <summary>
        /// Indicates whether the interest amount may be offset against any margin call deliver or return amounts?   (aka &apos;net payments&apos; indicator).
        /// </summary>
        public bool NetInterestWithMarginCalls { get; }
        
        /// <summary>
        /// Indicates whether to net Held and Posted Interest Payments (i.e. whether interest payable for a period can be netted with interest receivable).
        /// </summary>
        public bool NetPostedAndHeldInterest { get; }
        
        /// <summary>
        /// Specifies the terms describing notification requirements.
        /// </summary>
        public CollateralInterestNotification? Notification { get; }
        
        /// <summary>
        /// Indicates the option that accrued interest should be calculated and distributed when a full return of collateral occurs.
        /// </summary>
        public bool OnFullReturn { get; }
        
        /// <summary>
        /// Indicates the option that accrued interest should be calculated and distributed when a partial return collateral occurs.
        /// </summary>
        public bool OnPartialReturn { get; }
        
        /// <summary>
        /// Specifies applicable business centers for payments.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public IEnumerable<Enums.BusinessCenter> PaymentBusinessCenter { get; }
        
        /// <summary>
        /// Specifies the level below which the interest will be written off; if omitted write-off is not applicable.
        /// </summary>
        public NumberBound? WriteoffLimit { get; }
    }
    
    /// <summary>
    /// Represents the parameters describing when notifications should be made for required collateral interest transfers.
    /// </summary>
    public class CollateralInterestNotification : AbstractRosettaModelObject<CollateralInterestNotification>
    {
        private static readonly IRosettaMetaData<CollateralInterestNotification> metaData = new CollateralInterestNotificationMeta();
        
        [JsonConstructor]
        public CollateralInterestNotification(Enums.DayType notificationDayType, LocalTime notificationTime, decimal offset, string trigger)
        {
            NotificationDayType = notificationDayType;
            NotificationTime = notificationTime;
            Offset = offset;
            Trigger = trigger;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CollateralInterestNotification> MetaData => metaData;
        
        /// <summary>
        /// The type of days on which notification should occur.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.DayType NotificationDayType { get; }
        
        /// <summary>
        /// Specifies the time of day that the notification should occur.
        /// </summary>
        public LocalTime NotificationTime { get; }
        
        /// <summary>
        /// Specifies the number of days before (negative) or after (positive) the trigger event.
        /// </summary>
        public decimal Offset { get; }
        
        /// <summary>
        /// Specifies what triggers notification (should be enum) Interest Statement Frequency, Period End Date.
        /// </summary>
        public string Trigger { get; }
    }
    
    /// <summary>
    /// Represents the floating interest calculation and distribution parameters for a single currency.
    /// </summary>
    public class CollateralInterestParameters : AbstractRosettaModelObject<CollateralInterestParameters>
    {
        private static readonly IRosettaMetaData<CollateralInterestParameters> metaData = new CollateralInterestParametersMeta();
        
        [JsonConstructor]
        public CollateralInterestParameters(string? currency, CalculationFrequency? interestCalculationFrequency, CollateralInterestCalculationParameters? interestCalculationParameters, CollateralInterestHandlingParameters? interestHandlingParameters, Enums.CollateralMarginType? marginType, Enums.CounterpartyRole? postingParty)
        {
            Currency = currency;
            InterestCalculationFrequency = interestCalculationFrequency;
            InterestCalculationParameters = interestCalculationParameters;
            InterestHandlingParameters = interestHandlingParameters;
            MarginType = marginType;
            PostingParty = postingParty;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CollateralInterestParameters> MetaData => metaData;
        
        /// <summary>
        /// Specifies the currency for which the parameters are captured.
        /// </summary>
        public string? Currency { get; }
        
        /// <summary>
        /// Represents how often and when interest is calculated.
        /// </summary>
        public CalculationFrequency? InterestCalculationFrequency { get; }
        
        /// <summary>
        /// Represents the basic interest calculation parameters.
        /// </summary>
        public CollateralInterestCalculationParameters? InterestCalculationParameters { get; }
        
        /// <summary>
        /// Represents the parameters describing how and when interest transfer occurs.
        /// </summary>
        public CollateralInterestHandlingParameters? InterestHandlingParameters { get; }
        
        /// <summary>
        /// Specifies the type of margin for which interest is being calculated, if the parameters are different depending on type of margin (initial or variation).
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CollateralMarginType? MarginType { get; }
        
        /// <summary>
        /// Represents the party to which these parameters apply (the applicable party).  In other words, if the parameters are different depending on which party is posting/holding the collateral, for which party to the Collateral Agreement (Party 1 or Party 2) that is posting the collateral do these parameters apply?
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CounterpartyRole? PostingParty { get; }
    }
    
    /// <summary>
    /// Represents a class to allow specification of the type of entity issuing the collateral.
    /// </summary>
    public class CollateralIssuerType : AbstractRosettaModelObject<CollateralIssuerType>
    {
        private static readonly IRosettaMetaData<CollateralIssuerType> metaData = new CollateralIssuerTypeMeta();
        
        [JsonConstructor]
        public CollateralIssuerType(Enums.IssuerType issuerType, QuasiGovernmentIssuerType? quasiGovernmentType, RegionalGovernmentIssuerType? regionalGovernmentType, SpecialPurposeVehicleIssuerType? specialPurposeVehicleType, Enums.SupraNationalIssuerType? supraNationalType)
        {
            IssuerType = issuerType;
            QuasiGovernmentType = quasiGovernmentType;
            RegionalGovernmentType = regionalGovernmentType;
            SpecialPurposeVehicleType = specialPurposeVehicleType;
            SupraNationalType = supraNationalType;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CollateralIssuerType> MetaData => metaData;
        
        /// <summary>
        /// Specifies the origin of entity issuing the collateral.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.IssuerType IssuerType { get; }
        
        /// <summary>
        /// Specifies debt issues by institutions or bodies, typically constituted by statute, with a function mandated by the government and subject to government supervision inclusive of profit- and non-profit making bodies. Includes the US Agencies and GSEs and the EU concept of public sector entities. Excluding any entities which are also Regional Government.
        /// </summary>
        public QuasiGovernmentIssuerType? QuasiGovernmentType { get; }
        
        /// <summary>
        /// Specifies Regional government, local authority or municipal.
        /// </summary>
        public RegionalGovernmentIssuerType? RegionalGovernmentType { get; }
        
        /// <summary>
        /// Specifies a subsidiary company that is formed to undertake a specific business purpose of acquisition and financing of specific assets on a potentially limited recourse basis dependent of how it is designed. E.g. asset backed securities, including securitisations.
        /// </summary>
        public SpecialPurposeVehicleIssuerType? SpecialPurposeVehicleType { get; }
        
        /// <summary>
        /// Specifies debt issued by international organisations and multilateral banks.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.SupraNationalIssuerType? SupraNationalType { get; }
    }
    
    /// <summary>
    /// Represents common attributes to define the details of collateral assets, to be used in margin call messaging and contribute to collateral balances e.g securities in a collateral account.
    /// </summary>
    public class CollateralPortfolio : AbstractRosettaModelObject<CollateralPortfolio>
    {
        private static readonly IRosettaMetaData<CollateralPortfolio> metaData = new CollateralPortfolioMeta();
        
        [JsonConstructor]
        public CollateralPortfolio(IEnumerable<CollateralBalance> collateralBalance, IEnumerable<CollateralPosition> collateralPosition, ReferenceWithMetaLegalAgreement? legalAgreement, _MetaFields? meta, Identifier? portfolioIdentifier)
        {
            CollateralBalance = collateralBalance;
            CollateralPosition = collateralPosition;
            LegalAgreement = legalAgreement;
            Meta = meta;
            PortfolioIdentifier = portfolioIdentifier;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CollateralPortfolio> MetaData => metaData;
        
        /// <summary>
        /// Represents the populated or calculated collateral aggregate balance amount for the collateral portfolio.
        /// </summary>
        public IEnumerable<CollateralBalance> CollateralBalance { get; }
        
        /// <summary>
        /// Specifies the individual components of the collateral positions in the collateral portfolio.
        /// </summary>
        public IEnumerable<CollateralPosition> CollateralPosition { get; }
        
        /// <summary>
        ///  The specification of a legal agreement between two parties governing the collateral relationship such as Credit Support Agreement or Collateral Transfer Agreement etc. (NB: this can be provided by reference to a global key for each LegalAgreement object).
        /// </summary>
        public ReferenceWithMetaLegalAgreement? LegalAgreement { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <summary>
        /// Specifies a unique identifier for a set of collateral positions in a portfolio.
        /// </summary>
        public Identifier? PortfolioIdentifier { get; }
    }
    
    /// <summary>
    /// Specifies the individual components of collateral positions.
    /// </summary>
    public class CollateralPosition : AbstractRosettaModelObject<CollateralPosition>, IPosition
    {
        private static readonly IRosettaMetaData<CollateralPosition> metaData = new CollateralPositionMeta();
        
        [JsonConstructor]
        public CollateralPosition(Enums.CollateralStatus? collateralPositionStatus, CollateralTreatment? treatment, Money? cashBalance, IEnumerable<PriceQuantity> priceQuantity, Product product, ReferenceWithMetaTradeState? tradeReference)
        {
            CollateralPositionStatus = collateralPositionStatus;
            Treatment = treatment;
            CashBalance = cashBalance;
            PriceQuantity = priceQuantity;
            Product = product;
            TradeReference = tradeReference;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CollateralPosition> MetaData => metaData;
        
        /// <summary>
        /// Indicates the collateral positions settlement status.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CollateralStatus? CollateralPositionStatus { get; }
        
        /// <summary>
        /// Specifies if there is any treatment to be applied to collateral, such as percentage discount which will impact collateral value.
        /// </summary>
        public CollateralTreatment? Treatment { get; }
        
        /// <inheritdoc/>
        public Money? CashBalance { get; }
        
        /// <inheritdoc/>
        public IEnumerable<PriceQuantity> PriceQuantity { get; }
        
        /// <inheritdoc/>
        public Product Product { get; }
        
        /// <inheritdoc/>
        public ReferenceWithMetaTradeState? TradeReference { get; }
    }
    
    /// <summary>
    /// Contains collateral attributes which can also inherit information from a GMRA
    /// </summary>
    public class CollateralProvisions : AbstractRosettaModelObject<CollateralProvisions>
    {
        private static readonly IRosettaMetaData<CollateralProvisions> metaData = new CollateralProvisionsMeta();
        
        [JsonConstructor]
        public CollateralProvisions(Enums.CollateralType collateralType, IEnumerable<EligibleCollateralSpecification> eligibleCollateral, SubstitutionProvisions? substitutionProvisions)
        {
            CollateralType = collateralType;
            EligibleCollateral = eligibleCollateral;
            SubstitutionProvisions = substitutionProvisions;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CollateralProvisions> MetaData => metaData;
        
        /// <summary>
        /// Enumerates the collateral types which are accepted by the Seller.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CollateralType CollateralType { get; }
        
        /// <summary>
        /// The eligible collateral as specified in relation to the transaction.
        /// </summary>
        public IEnumerable<EligibleCollateralSpecification> EligibleCollateral { get; }
        
        /// <summary>
        /// The provisions for collateral substitutions such as how many and when they are allowed.
        /// </summary>
        public SubstitutionProvisions? SubstitutionProvisions { get; }
    }
    
    /// <summary>
    /// Specifies the collateral taxonomy, which is composed of a taxonomy value and a taxonomy source.
    /// </summary>
    public class CollateralTaxonomy : AbstractRosettaModelObject<CollateralTaxonomy>
    {
        private static readonly IRosettaMetaData<CollateralTaxonomy> metaData = new CollateralTaxonomyMeta();
        
        [JsonConstructor]
        public CollateralTaxonomy(Enums.TaxonomySource taxonomySource, CollateralTaxonomyValue taxonomyValue)
        {
            TaxonomySource = taxonomySource;
            TaxonomyValue = taxonomyValue;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CollateralTaxonomy> MetaData => metaData;
        
        /// <summary>
        /// Specifies the taxonomy source.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.TaxonomySource TaxonomySource { get; }
        
        /// <summary>
        /// Specifies the taxonomy value.
        /// </summary>
        public CollateralTaxonomyValue TaxonomyValue { get; }
    }
    
    /// <summary>
    /// Specifies the collateral taxonomy value, either as a specified enumeration or as a string.
    /// </summary>
    public class CollateralTaxonomyValue : AbstractRosettaModelObject<CollateralTaxonomyValue>
    {
        private static readonly IRosettaMetaData<CollateralTaxonomyValue> metaData = new CollateralTaxonomyValueMeta();
        
        [JsonConstructor]
        public CollateralTaxonomyValue(IEnumerable<Enums.EU_EMIR_EligibleCollateral> eu_EMIR_EligibleCollateral, IEnumerable<FieldWithMetaString> nonEnumeratedTaxonomyValue, IEnumerable<Enums.UK_EMIR_EligibleCollateral> uk_EMIR_EligibleCollateral, IEnumerable<Enums.US_CFTC_PR_EligibleCollateral> us_CFTC_PR_EligibleCollateral)
        {
            Eu_EMIR_EligibleCollateral = eu_EMIR_EligibleCollateral;
            NonEnumeratedTaxonomyValue = nonEnumeratedTaxonomyValue;
            Uk_EMIR_EligibleCollateral = uk_EMIR_EligibleCollateral;
            Us_CFTC_PR_EligibleCollateral = us_CFTC_PR_EligibleCollateral;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CollateralTaxonomyValue> MetaData => metaData;
        
        /// <summary>
        /// Identifies European Union Eligible Collateral Assets classification categories based on EMIR Uncleared Margin Rules. Eligible Collateral asset classes for both initial margin (IM) and variation margin (VM) posted and collected between specified entities. Please note: EMIR regulation will detail which eligible collateral assets classes apply to each type of entity pairing (counterparty) and which apply to posting of IM and VM
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public IEnumerable<Enums.EU_EMIR_EligibleCollateral> Eu_EMIR_EligibleCollateral { get; }
        
        /// <summary>
        /// Identifies the taxonomy value when not specified as an enumeration.
        /// </summary>
        public IEnumerable<FieldWithMetaString> NonEnumeratedTaxonomyValue { get; }
        
        /// <summary>
        /// Identifies United Kingdom Eligible Collateral Assets classification categories based on UK Onshored EMIR Uncleared Margin Rules Eligible Collateral asset classes for both initial margin (IM) and variation margin (VM) posted and collected between specified entities. Please note: UK EMIR regulation will detail which eligible collateral assets classes apply to each type of entity pairing (counterparty) and which apply to posting of IM and VM.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public IEnumerable<Enums.UK_EMIR_EligibleCollateral> Uk_EMIR_EligibleCollateral { get; }
        
        /// <summary>
        /// Identifies US Eligible Collateral Assets classification categories based on Uncleared Margin Rules published by the CFTC and the US Prudential Regulator. Note: While the same basic categories exist in the CFTC and US Prudential Regulators’ margin rules, the precise definitions or application of those rules could differ between the two rules.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public IEnumerable<Enums.US_CFTC_PR_EligibleCollateral> Us_CFTC_PR_EligibleCollateral { get; }
    }
    
    /// <summary>
    /// The set of elections which specify a Collateral Transfer Agreement
    /// </summary>
    public class CollateralTransferAgreementElections : AbstractRosettaModelObject<CollateralTransferAgreementElections>
    {
        private static readonly IRosettaMetaData<CollateralTransferAgreementElections> metaData = new CollateralTransferAgreementElectionsMeta();
        
        [JsonConstructor]
        public CollateralTransferAgreementElections()
        {
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CollateralTransferAgreementElections> MetaData => metaData;
        
    }
    
    /// <summary>
    /// Specifies the treatment terms for the eligible collateral criteria specified.
    /// </summary>
    public class CollateralTreatment : AbstractRosettaModelObject<CollateralTreatment>
    {
        private static readonly IRosettaMetaData<CollateralTreatment> metaData = new CollateralTreatmentMeta();
        
        [JsonConstructor]
        public CollateralTreatment(IEnumerable<ConcentrationLimit> concentrationLimit, bool isIncluded, CollateralValuationTreatment? valuationTreatment)
        {
            ConcentrationLimit = concentrationLimit;
            IsIncluded = isIncluded;
            ValuationTreatment = valuationTreatment;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CollateralTreatment> MetaData => metaData;
        
        /// <summary>
        /// Specification of concentration limits applicable to the collateral criteria.
        /// </summary>
        public IEnumerable<ConcentrationLimit> ConcentrationLimit { get; }
        
        /// <summary>
        /// A boolean attribute to specify whether collateral critieria are inclusion (True) or exclusion (False) criteria.
        /// </summary>
        public bool IsIncluded { get; }
        
        /// <summary>
        /// Specification of the valuation treatment for the specified collateral.
        /// </summary>
        public CollateralValuationTreatment? ValuationTreatment { get; }
    }
    
    /// <summary>
    /// Specification of the valuation treatment for the specified collateral.
    /// </summary>
    public class CollateralValuationTreatment : AbstractRosettaModelObject<CollateralValuationTreatment>
    {
        private static readonly IRosettaMetaData<CollateralValuationTreatment> metaData = new CollateralValuationTreatmentMeta();
        
        [JsonConstructor]
        public CollateralValuationTreatment(decimal? additionalHaircutPercentage, decimal? fxHaircutPercentage, decimal? haircutPercentage, decimal? marginPercentage)
        {
            AdditionalHaircutPercentage = additionalHaircutPercentage;
            FxHaircutPercentage = fxHaircutPercentage;
            HaircutPercentage = haircutPercentage;
            MarginPercentage = marginPercentage;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CollateralValuationTreatment> MetaData => metaData;
        
        /// <summary>
        /// Specifies a percentage value of any additional haircut to be applied to a collateral asset,the percentage value is expressed as the discount haircut to the value of the collateral- as an example a 5% haircut would be expressed as 0.05. 
        /// </summary>
        public decimal? AdditionalHaircutPercentage { get; }
        
        /// <summary>
        /// Specifies an FX haircut applied to a specific asset which is agreed between the parties (for example, if pledgor eligible collateral is not denominated in the termination currency or under other specified cases in collateral support documents both for initial margin and variation margin).The percentage value is expressed as the discount haircut to the value of the collateral- as an example an 8% FX haircut would be expressed as 0.08.
        /// </summary>
        public decimal? FxHaircutPercentage { get; }
        
        /// <summary>
        /// Specifies a haircut percentage to be applied to the value of asset and used as a discount factor to the value of the collateral asset,expressed as a percentage in decimal terms. As an example a 0.5% haircut would be represented as a decimal number 0.005.
        /// </summary>
        public decimal? HaircutPercentage { get; }
        
        /// <summary>
        /// Specifies a percentage value of transaction needing to be posted as collateral expressed as a valuation. As an example a 104% requirement would be represented as a decimal number 1.04.
        /// </summary>
        public decimal? MarginPercentage { get; }
    }
    
    /// <summary>
    /// Identifies a specific commodity by referencing a product identifier or by a product definition.
    /// </summary>
    public class Commodity : AbstractRosettaModelObject<Commodity>, IProductBase
    {
        private static readonly IRosettaMetaData<Commodity> metaData = new CommodityMeta();
        
        [JsonConstructor]
        public Commodity(CommodityProductDefinition? commodityProductDefinition, DeliveryDateParameters? deliveryDateReference, string? description, Enums.QuotationSide priceQuoteType, IEnumerable<ReferenceWithMetaProductIdentifier> productIdentifier, IEnumerable<ProductTaxonomy> productTaxonomy)
        {
            CommodityProductDefinition = commodityProductDefinition;
            DeliveryDateReference = deliveryDateReference;
            Description = description;
            PriceQuoteType = priceQuoteType;
            ProductIdentifier = productIdentifier;
            ProductTaxonomy = productTaxonomy;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Commodity> MetaData => metaData;
        
        /// <summary>
        /// Specifies the commodity underlier in the event that no ISDA Commodity Reference Benchmark exists.
        /// </summary>
        public CommodityProductDefinition? CommodityProductDefinition { get; }
        
        /// <summary>
        /// Specifies the parameters for identifying the relevant contract date when the commodity reference price is a futures contract.
        /// </summary>
        public DeliveryDateParameters? DeliveryDateReference { get; }
        
        /// <summary>
        /// Provides additional information about the commodity underlier.
        /// </summary>
        public string? Description { get; }
        
        /// <summary>
        /// Describes the required quote type of the underlying price that will be observed. Example values include &apos;Bid, &apos;Ask&apos;, &apos;Settlement&apos; (for a futures contract) and &apos;WeightedAverage&apos; (for some published prices and indices).
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.QuotationSide PriceQuoteType { get; }
        
        /// <inheritdoc/>
        public IEnumerable<ReferenceWithMetaProductIdentifier> ProductIdentifier { get; }
        
        /// <inheritdoc/>
        public IEnumerable<ProductTaxonomy> ProductTaxonomy { get; }
    }
    
    /// <summary>
    /// Payout based on the averaged price of a referenced underlier. (e.g. Commodities). Can represent both average (average of many) &amp; bullet (average of 1) pricing
    /// </summary>
    public class CommodityPayout : AbstractRosettaModelObject<CommodityPayout>, IPayoutBase
    {
        private static readonly IRosettaMetaData<CommodityPayout> metaData = new CommodityPayoutMeta();
        
        [JsonConstructor]
        public CommodityPayout(AveragingCalculation? averagingFeature, CalculationPeriodDates? calculationPeriodDates, CommodityPriceReturnTerms? commodityPriceReturnTerms, FxFeature? fxFeature, _MetaFields? meta, PaymentDates paymentDates, PricingDates pricingDates, CommoditySchedule? schedule, Product underlier, PayerReceiver payerReceiver, ResolvablePriceQuantity? priceQuantity, PrincipalPayments? principalPayment, SettlementTerms? settlementTerms)
        {
            AveragingFeature = averagingFeature;
            CalculationPeriodDates = calculationPeriodDates;
            CommodityPriceReturnTerms = commodityPriceReturnTerms;
            FxFeature = fxFeature;
            Meta = meta;
            PaymentDates = paymentDates;
            PricingDates = pricingDates;
            Schedule = schedule;
            Underlier = underlier;
            PayerReceiver = payerReceiver;
            PriceQuantity = priceQuantity;
            PrincipalPayment = principalPayment;
            SettlementTerms = settlementTerms;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CommodityPayout> MetaData => metaData;
        
        /// <summary>
        /// Indicates if the averaging calculation, when applicable, is weighted or unweighted.
        /// </summary>
        public AveragingCalculation? AveragingFeature { get; }
        
        /// <summary>
        /// Defines the calculation period dates schedule.
        /// </summary>
        public CalculationPeriodDates? CalculationPeriodDates { get; }
        
        /// <summary>
        /// Defines parameters in which the commodity price is assessed.
        /// </summary>
        public CommodityPriceReturnTerms? CommodityPriceReturnTerms { get; }
        
        /// <summary>
        /// Defines quanto or composite FX features that are included in the swap leg.
        /// </summary>
        public FxFeature? FxFeature { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <summary>
        /// Defines the payment date schedule, as defined by the parameters that are needed to specify it, either in a parametric way or by reference to another schedule of dates (e.g. the valuation dates).
        /// </summary>
        public PaymentDates PaymentDates { get; }
        
        /// <summary>
        /// Specifies specific dates or parametric rules for the dates on which the price will be determined.
        /// </summary>
        public PricingDates PricingDates { get; }
        
        /// <summary>
        /// Allows the full representation of a commodity payout by defining a set of schedule periods. It supports standard schedule customization by expressing all the dates, quantities, and pricing data in a non-parametric way.
        /// </summary>
        public CommoditySchedule? Schedule { get; }
        
        /// <summary>
        /// Identifies the underlying product that is referenced for pricing of the applicable leg in a swap.  Referenced in the &apos;2018 ISDA CDM Equity Confirmation for Security Equity Swap&apos; as Security.
        /// </summary>
        public Product Underlier { get; }
        
        /// <inheritdoc/>
        public PayerReceiver PayerReceiver { get; }
        
        /// <inheritdoc/>
        public ResolvablePriceQuantity? PriceQuantity { get; }
        
        /// <inheritdoc/>
        public PrincipalPayments? PrincipalPayment { get; }
        
        /// <inheritdoc/>
        public SettlementTerms? SettlementTerms { get; }
    }
    
    /// <summary>
    /// Defines parameters in which the commodity price is assessed.
    /// </summary>
    public class CommodityPriceReturnTerms : AbstractRosettaModelObject<CommodityPriceReturnTerms>
    {
        private static readonly IRosettaMetaData<CommodityPriceReturnTerms> metaData = new CommodityPriceReturnTermsMeta();
        
        [JsonConstructor]
        public CommodityPriceReturnTerms(decimal? conversionFactor, RollFeature? rollFeature, Rounding? rounding, SpreadSchedule? spread)
        {
            ConversionFactor = conversionFactor;
            RollFeature = rollFeature;
            Rounding = rounding;
            Spread = spread;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CommodityPriceReturnTerms> MetaData => metaData;
        
        /// <summary>
        /// Defines the conversion applied if the quantity unit on contract is different from unit on referenced underlier.
        /// </summary>
        public decimal? ConversionFactor { get; }
        
        /// <summary>
        /// Used in conjunction with an exchange-based pricing source. Identifies a way in which the futures contracts referenced will roll between periods. 
        /// </summary>
        public RollFeature? RollFeature { get; }
        
        /// <summary>
        /// Defines rounding rules and precision to be used in the rounding of a number.
        /// </summary>
        public Rounding? Rounding { get; }
        
        /// <summary>
        /// Defines a spread value for one or more defined dates.
        /// </summary>
        public SpreadSchedule? Spread { get; }
    }
    
    /// <summary>
    /// Specifies the commodity underlier in the event that no ISDA Commodity Reference Price exists.
    /// </summary>
    public class CommodityProductDefinition : AbstractRosettaModelObject<CommodityProductDefinition>
    {
        private static readonly IRosettaMetaData<CommodityProductDefinition> metaData = new CommodityProductDefinitionMeta();
        
        [JsonConstructor]
        public CommodityProductDefinition(Enums.CommodityInformationPublisher? commodityInfoPublisher, FieldWithMetaString exchangeId, PriceSource? priceSource, CommodityReferenceFramework referenceFramework)
        {
            CommodityInfoPublisher = commodityInfoPublisher;
            ExchangeId = exchangeId;
            PriceSource = priceSource;
            ReferenceFramework = referenceFramework;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CommodityProductDefinition> MetaData => metaData;
        
        /// <summary>
        /// Specifies the publication where the commodity prices can be found.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CommodityInformationPublisher? CommodityInfoPublisher { get; }
        
        /// <summary>
        ///  Identifies the exchange from which the reference price should be sourced, using the scheme at the following url: http://www.fpml.org/coding-scheme/external/exchange-id-MIC-1-0
        /// </summary>
        public FieldWithMetaString ExchangeId { get; }
        
        /// <summary>
        /// Specifies a publication that provides the commodity price, including, where applicable the details of where in the publication the price is published.  Applicable when the commodity reference price is not a futures contract
        /// </summary>
        public PriceSource? PriceSource { get; }
        
        /// <summary>
        /// Specifies the type of commodity.
        /// </summary>
        public CommodityReferenceFramework ReferenceFramework { get; }
    }
    
    /// <summary>
    /// Specifies the type of commodity.
    /// </summary>
    public class CommodityReferenceFramework : AbstractRosettaModelObject<CommodityReferenceFramework>
    {
        private static readonly IRosettaMetaData<CommodityReferenceFramework> metaData = new CommodityReferenceFrameworkMeta();
        
        [JsonConstructor]
        public CommodityReferenceFramework(Enums.CapacityUnit? capacityUnit, FieldWithMetaString commodityBase, string commodityName, FieldWithMetaString currency, FieldWithMetaString subCommodity, Enums.WeatherUnit? weatherUnit)
        {
            CapacityUnit = capacityUnit;
            CommodityBase = commodityBase;
            CommodityName = commodityName;
            Currency = currency;
            SubCommodity = subCommodity;
            WeatherUnit = weatherUnit;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CommodityReferenceFramework> MetaData => metaData;
        
        /// <summary>
        /// Provides an enumerated value for a capacity unit, generally used in the context of defining quantities for commodities.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CapacityUnit? CapacityUnit { get; }
        
        /// <summary>
        /// Identifies the base type of the commodity being traded, using the names defined in the ISDA 2005 Commodity Definitions SubAnnex A where possible, e.g. AgriculturalProducts, CommodityCompositeIndices, Energy, Freight, Metals, or PaperAndPlastic. Implementors can define their own scheme with additional values.
        /// </summary>
        public FieldWithMetaString CommodityBase { get; }
        
        /// <summary>
        /// Identifies the commodity more specifically. Where possible, this should follow the naming convention used in the 2005 ISDA Commodity Definitions SubAnnex A, including the subCommodity and additional qualifiers, but should be limited to 256 characters or less.
        /// </summary>
        public string CommodityName { get; }
        
        /// <summary>
        /// Defines the currency in which the commodity is priced.
        /// </summary>
        public FieldWithMetaString Currency { get; }
        
        /// <summary>
        /// Identifies the sub product type of the commodity being traded, using the names defined in the ISDA 2005 Commodity Definitions SubAnnex A where possible, e.g. under Energy, the possible values are Benzene, Coal, DieselFuel, Electricity, FuelOil, GasOil, Gasoline, HeatingOil, JetFuelKerosene, Methanol, Naphtha, NaturalGas, NaturalGasLiquids, Oil, and UltraLowSulpherDiesel. Implementors can define their own scheme with additional values.
        /// </summary>
        public FieldWithMetaString SubCommodity { get; }
        
        /// <summary>
        /// Provides an enumerated values for a weather unit, generally used in the context of defining quantities for commodities.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.WeatherUnit? WeatherUnit { get; }
    }
    
    /// <summary>
    /// A class that allows the full representation of a commodity payout by defining a set of schedule periods. It supports standard schedule customization by expressing all the dates, quantities, and pricing data in a non-parametric way.
    /// </summary>
    public class CommoditySchedule : AbstractRosettaModelObject<CommoditySchedule>
    {
        private static readonly IRosettaMetaData<CommoditySchedule> metaData = new CommodityScheduleMeta();
        
        [JsonConstructor]
        public CommoditySchedule(IEnumerable<SchedulePeriod> schedulePeriod)
        {
            SchedulePeriod = schedulePeriod;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CommoditySchedule> MetaData => metaData;
        
        /// <summary>
        /// Defines a period of a commodity schedule structure.
        /// </summary>
        public IEnumerable<SchedulePeriod> SchedulePeriod { get; }
    }
    
    /// <summary>
    /// Specifies the conditions to be applied for converting into a reference currency when the actual currency rate is not determined upfront.
    /// </summary>
    public class Composite : AbstractRosettaModelObject<Composite>
    {
        private static readonly IRosettaMetaData<Composite> metaData = new CompositeMeta();
        
        [JsonConstructor]
        public Composite(Enums.DeterminationMethod? determinationMethod, BusinessCenterTime? fixingTime, FxSpotRateSource? fxSpotRateSource, RelativeDateOffset? relativeDate)
        {
            DeterminationMethod = determinationMethod;
            FixingTime = fixingTime;
            FxSpotRateSource = fxSpotRateSource;
            RelativeDate = relativeDate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Composite> MetaData => metaData;
        
        /// <summary>
        /// Specifies the method according to which an amount or a date is determined.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.DeterminationMethod? DeterminationMethod { get; }
        
        /// <summary>
        /// The time at which the spot currency exchange rate will be observed. It is specified as a time in a business day calendar location, e.g. 11:00am London time.
        /// </summary>
        public BusinessCenterTime? FixingTime { get; }
        
        /// <summary>
        /// Specifies the methodology (reference source and, optionally, fixing time) to be used for determining a currency conversion rate.
        /// </summary>
        public FxSpotRateSource? FxSpotRateSource { get; }
        
        /// <summary>
        /// A date specified as some offset to another date (the anchor date).
        /// </summary>
        public RelativeDateOffset? RelativeDate { get; }
    }
    
    /// <summary>
    /// A class to specify the outcome of a computed amount, for testing purposes.
    /// </summary>
    public class ComputedAmount : AbstractRosettaModelObject<ComputedAmount>
    {
        private static readonly IRosettaMetaData<ComputedAmount> metaData = new ComputedAmountMeta();
        
        [JsonConstructor]
        public ComputedAmount(decimal amount, string callFunction, FieldWithMetaString? currency)
        {
            Amount = amount;
            CallFunction = callFunction;
            Currency = currency;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ComputedAmount> MetaData => metaData;
        
        public decimal Amount { get; }
        
        public string CallFunction { get; }
        
        /// <summary>
        /// The currency in which the computed amount is denominated. The list of valid currencies is not presently positioned as an enumeration as part of the CDM because that scope is limited to the values specified by ISDA and FpML. As a result, implementers have to make reference to the relevant standard, such as the ISO 4217 standard for currency codes.
        /// </summary>
        public FieldWithMetaString? Currency { get; }
    }
    
    /// <summary>
    /// Represents a class to describe concentration limits that may be applicable to eligible collateral criteria.
    /// </summary>
    public class ConcentrationLimit : AbstractRosettaModelObject<ConcentrationLimit>
    {
        private static readonly IRosettaMetaData<ConcentrationLimit> metaData = new ConcentrationLimitMeta();
        
        [JsonConstructor]
        public ConcentrationLimit(IEnumerable<ConcentrationLimitCriteria> concentrationLimitCriteria, NumberRange? percentageLimit, MoneyRange? valueLimit)
        {
            ConcentrationLimitCriteria = concentrationLimitCriteria;
            PercentageLimit = percentageLimit;
            ValueLimit = valueLimit;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ConcentrationLimit> MetaData => metaData;
        
        /// <summary>
        /// Specifies a set of criteria to describe the assets that the concentration limits apply to.
        /// </summary>
        public IEnumerable<ConcentrationLimitCriteria> ConcentrationLimitCriteria { get; }
        
        /// <summary>
        /// Specifies the perecentage of collateral limit represented as a decimal number - example 25% is 0.25.
        /// </summary>
        public NumberRange? PercentageLimit { get; }
        
        /// <summary>
        /// Specifies the value of collateral limit represented as a range.
        /// </summary>
        public MoneyRange? ValueLimit { get; }
    }
    
    /// <summary>
    /// Respresents a class to describe a set of criteria to describe specific assets that the concentration limits apply to.
    /// </summary>
    public class ConcentrationLimitCriteria : AbstractRosettaModelObject<ConcentrationLimitCriteria>, ICollateralCriteriaBase
    {
        private static readonly IRosettaMetaData<ConcentrationLimitCriteria> metaData = new ConcentrationLimitCriteriaMeta();
        
        [JsonConstructor]
        public ConcentrationLimitCriteria(AverageTradingVolume? averageTradingVolume, Enums.ConcentrationLimitType? concentrationLimitType, IEnumerable<AssetCriteria> asset, IEnumerable<IssuerCriteria> issuer)
        {
            AverageTradingVolume = averageTradingVolume;
            ConcentrationLimitType = concentrationLimitType;
            Asset = asset;
            Issuer = issuer;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ConcentrationLimitCriteria> MetaData => metaData;
        
        /// <summary>
        /// Specifies an average trading volume on an exchange in relation to Equity products.
        /// </summary>
        public AverageTradingVolume? AverageTradingVolume { get; }
        
        /// <summary>
        /// Specifies the type of concentration limit to be applied.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.ConcentrationLimitType? ConcentrationLimitType { get; }
        
        /// <inheritdoc/>
        public IEnumerable<AssetCriteria> Asset { get; }
        
        /// <inheritdoc/>
        public IEnumerable<IssuerCriteria> Issuer { get; }
    }
    
    /// <summary>
    /// A class to specify a trade confirmation.
    /// </summary>
    public class Confirmation : AbstractRosettaModelObject<Confirmation>
    {
        private static readonly IRosettaMetaData<Confirmation> metaData = new ConfirmationMeta();
        
        [JsonConstructor]
        public Confirmation(IEnumerable<Identifier> identifier, Lineage? lineage, IEnumerable<Party> party, IEnumerable<PartyRole> partyRole, Enums.ConfirmationStatus status)
        {
            Identifier = identifier;
            Lineage = lineage;
            Party = party;
            PartyRole = partyRole;
            Status = status;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Confirmation> MetaData => metaData;
        
        /// <summary>
        /// The identifier(s) associated with the trade and resulting confirmation.
        /// </summary>
        public IEnumerable<Identifier> Identifier { get; }
        
        /// <summary>
        /// The lineage attribute provides a linkage to previous lifecycle events and associated data.
        /// </summary>
        public Lineage? Lineage { get; }
        
        /// <summary>
        /// The parties associated with the trade.
        /// </summary>
        public IEnumerable<Party> Party { get; }
        
        /// <summary>
        /// The role(s) that party(ies) may have in relation to the trade
        /// </summary>
        public IEnumerable<PartyRole> PartyRole { get; }
        
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.ConfirmationStatus Status { get; }
    }
    
    /// <summary>
    /// A class describing the weight of each of the underlier constituent within the basket, either in absolute or relative terms.
    /// </summary>
    public class ConstituentWeight : AbstractRosettaModelObject<ConstituentWeight>
    {
        private static readonly IRosettaMetaData<ConstituentWeight> metaData = new ConstituentWeightMeta();
        
        [JsonConstructor]
        public ConstituentWeight(decimal? basketPercentage, decimal? openUnits)
        {
            BasketPercentage = basketPercentage;
            OpenUnits = openUnits;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ConstituentWeight> MetaData => metaData;
        
        /// <summary>
        /// The relative weight of each respective basket constituent, expressed in percentage. A basket percentage of 5% would be represented as 0.05.
        /// </summary>
        public decimal? BasketPercentage { get; }
        
        /// <summary>
        /// The number of units (index or securities) that constitute the underlier of the swap. In the case of a basket swap, this element is used to reference both the number of basket units, and the number of each asset components of the basket when these are expressed in absolute terms.
        /// </summary>
        public decimal? OpenUnits { get; }
    }
    
    /// <summary>
    /// A class to specify the parties&apos; election to specify contact information, in relation to elections such as the Addresses for Transfer or the Demand and Notices as specified in the ISDA Credit Support Annex agreement.
    /// </summary>
    public class ContactElection : AbstractRosettaModelObject<ContactElection>
    {
        private static readonly IRosettaMetaData<ContactElection> metaData = new ContactElectionMeta();
        
        [JsonConstructor]
        public ContactElection(IEnumerable<PartyContactInformation> partyElection)
        {
            PartyElection = partyElection;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ContactElection> MetaData => metaData;
        
        /// <summary>
        /// The parties&apos; contact information election.
        /// </summary>
        public IEnumerable<PartyContactInformation> PartyElection { get; }
    }
    
    /// <summary>
    /// A class to specify contact information associated with a party: telephone, postal/street address, email and web page.
    /// </summary>
    public class ContactInformation : AbstractRosettaModelObject<ContactInformation>
    {
        private static readonly IRosettaMetaData<ContactInformation> metaData = new ContactInformationMeta();
        
        [JsonConstructor]
        public ContactInformation(IEnumerable<Address> address, IEnumerable<string> email, IEnumerable<TelephoneNumber> telephone, IEnumerable<string> webPage)
        {
            Address = address;
            Email = email;
            Telephone = telephone;
            WebPage = webPage;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ContactInformation> MetaData => metaData;
        
        /// <summary>
        /// The street/postal address.
        /// </summary>
        public IEnumerable<Address> Address { get; }
        
        /// <summary>
        /// The email address.
        /// </summary>
        public IEnumerable<string> Email { get; }
        
        /// <summary>
        /// The telephone number.
        /// </summary>
        public IEnumerable<TelephoneNumber> Telephone { get; }
        
        /// <summary>
        /// The web page. This attribute is not specified as part of the FpML ContactInformation complex type.
        /// </summary>
        public IEnumerable<string> WebPage { get; }
    }
    
    /// <summary>
    /// Defines specific attributes that relate to contractual details of trades.
    /// </summary>
    public class ContractDetails : AbstractRosettaModelObject<ContractDetails>
    {
        private static readonly IRosettaMetaData<ContractDetails> metaData = new ContractDetailsMeta();
        
        [JsonConstructor]
        public ContractDetails(IEnumerable<LegalAgreement> documentation, FieldWithMetaGoverningLawEnum? governingLaw, _MetaFields? meta)
        {
            Documentation = documentation;
            GoverningLaw = governingLaw;
            Meta = meta;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ContractDetails> MetaData => metaData;
        
        /// <summary>
        /// Represents the legal document(s) that governs a trade and associated contractual product terms, either as a reference to such documents when specified as part of the CDM, or through identification of some of the key terms of those documents, such as the type of document, the document identifier, the publisher, the document vintage and the agreement date.
        /// </summary>
        public IEnumerable<LegalAgreement> Documentation { get; }
        
        /// <summary>
        /// Represents the law governing the trade and associated contractual product terms.
        /// </summary>
        public FieldWithMetaGoverningLawEnum? GoverningLaw { get; }
        
        public _MetaFields? Meta { get; }
    }
    
    /// <summary>
    /// Specifies instructions to create a fully formed contract, with optional legal agreements.
    /// </summary>
    public class ContractFormationInstruction : AbstractRosettaModelObject<ContractFormationInstruction>
    {
        private static readonly IRosettaMetaData<ContractFormationInstruction> metaData = new ContractFormationInstructionMeta();
        
        [JsonConstructor]
        public ContractFormationInstruction(IEnumerable<LegalAgreement> legalAgreement)
        {
            LegalAgreement = legalAgreement;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ContractFormationInstruction> MetaData => metaData;
        
        /// <summary>
        /// Optional legal agreements associated to the contract being formed, for instance a master agreement.
        /// </summary>
        public IEnumerable<LegalAgreement> LegalAgreement { get; }
    }
    
    public class ContractualMatrix : AbstractRosettaModelObject<ContractualMatrix>
    {
        private static readonly IRosettaMetaData<ContractualMatrix> metaData = new ContractualMatrixMeta();
        
        [JsonConstructor]
        public ContractualMatrix(FieldWithMetaMatrixTermEnum? matrixTerm, FieldWithMetaMatrixTypeEnum matrixType)
        {
            MatrixTerm = matrixTerm;
            MatrixType = matrixType;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ContractualMatrix> MetaData => metaData;
        
        /// <summary>
        /// Defines any applicable key into the relevant matrix. For example, the Transaction Type would be the single term required for the Credit Derivatives Physical Settlement Matrix. This element should be omitted in the case of the 2000 ISDA Definitions Settlement Matrix for Early Termination and Swaptions.
        /// </summary>
        public FieldWithMetaMatrixTermEnum? MatrixTerm { get; }
        
        /// <summary>
        /// Identifies the form of applicable matrix.
        /// </summary>
        public FieldWithMetaMatrixTypeEnum MatrixType { get; }
    }
    
    /// <summary>
    ///  A class to specify the contractual products&apos; economic terms, alongside their product identification and product taxonomy. The contractual product class is meant to be used across the pre-execution, execution and (as part of the Contract) post-execution lifecycle contexts.
    /// </summary>
    public class ContractualProduct : AbstractRosettaModelObject<ContractualProduct>, IProductBase
    {
        private static readonly IRosettaMetaData<ContractualProduct> metaData = new ContractualProductMeta();
        
        [JsonConstructor]
        public ContractualProduct(EconomicTerms economicTerms, MetaAndTemplateFields? meta, IEnumerable<ReferenceWithMetaProductIdentifier> productIdentifier, IEnumerable<ProductTaxonomy> productTaxonomy)
        {
            EconomicTerms = economicTerms;
            Meta = meta;
            ProductIdentifier = productIdentifier;
            ProductTaxonomy = productTaxonomy;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ContractualProduct> MetaData => metaData;
        
        /// <summary>
        /// The economic terms associated with a contractual product, i.e. the set of features that are price-forming.
        /// </summary>
        public EconomicTerms EconomicTerms { get; }
        
        public MetaAndTemplateFields? Meta { get; }
        
        /// <inheritdoc/>
        public IEnumerable<ReferenceWithMetaProductIdentifier> ProductIdentifier { get; }
        
        /// <inheritdoc/>
        public IEnumerable<ProductTaxonomy> ProductTaxonomy { get; }
    }
    
    /// <summary>
    /// A contractual supplement (such as those published by ISDA) and its publication date that will apply to the trade.
    /// </summary>
    public class ContractualTermsSupplement : AbstractRosettaModelObject<ContractualTermsSupplement>
    {
        private static readonly IRosettaMetaData<ContractualTermsSupplement> metaData = new ContractualTermsSupplementMeta();
        
        [JsonConstructor]
        public ContractualTermsSupplement(FieldWithMetaContractualSupplementTypeEnum contractualTermsSupplementType, LocalDate? publicationDate)
        {
            ContractualTermsSupplementType = contractualTermsSupplementType;
            PublicationDate = publicationDate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ContractualTermsSupplement> MetaData => metaData;
        
        /// <summary>
        /// Identifies the form of applicable contractual supplement.
        /// </summary>
        public FieldWithMetaContractualSupplementTypeEnum ContractualTermsSupplementType { get; }
        
        /// <summary>
        /// Specifies the publication date of the applicable version of the contractual supplement.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? PublicationDate { get; }
    }
    
    /// <summary>
    /// A class to specify a convertible bond as having a product identifier. As a difference versus the FpML standard, the CDM structure of this class only includes the productIdentifier class, which consists of an identifier, productTaxonomy, and source of the identifier. The reason for this approach is to avoid the potential for conflicting information between the information associated with the contractual product and the reference information maintained by the relevant service provider.
    /// </summary>
    public class ConvertibleBond : AbstractRosettaModelObject<ConvertibleBond>, IIdentifiedProduct
    {
        private static readonly IRosettaMetaData<ConvertibleBond> metaData = new ConvertibleBondMeta();
        
        [JsonConstructor]
        public ConvertibleBond(ProductIdentifier productIdentifier)
        {
            ProductIdentifier = productIdentifier;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ConvertibleBond> MetaData => metaData;
        
        public ProductIdentifier ProductIdentifier { get; }
    }
    
    /// <summary>
    /// Specifies the relevant data regarding a corporate action
    /// </summary>
    public class CorporateAction : AbstractRosettaModelObject<CorporateAction>
    {
        private static readonly IRosettaMetaData<CorporateAction> metaData = new CorporateActionMeta();
        
        [JsonConstructor]
        public CorporateAction(Enums.CorporateActionType corporateActionType, LocalDate exDate, LocalDate payDate, Product underlier)
        {
            CorporateActionType = corporateActionType;
            ExDate = exDate;
            PayDate = payDate;
            Underlier = underlier;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CorporateAction> MetaData => metaData;
        
        /// <summary>
        /// The type of corporate action taking place.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CorporateActionType CorporateActionType { get; }
        
        /// <summary>
        /// The date on which the corporate action is known to have taken place.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate ExDate { get; }
        
        /// <summary>
        /// The date on which resulting from the corporate action are delivered.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate PayDate { get; }
        
        /// <summary>
        /// The entity impacted by the corporate action.
        /// </summary>
        public Product Underlier { get; }
    }
    
    public class CorrelationReturnTerms : AbstractRosettaModelObject<CorrelationReturnTerms>, IReturnTermsBase
    {
        private static readonly IRosettaMetaData<CorrelationReturnTerms> metaData = new CorrelationReturnTermsMeta();
        
        [JsonConstructor]
        public CorrelationReturnTerms(NumberRange? boundedCorrelation, Price correlationStrikePrice, int? numberOfDataSeries, int? annualizationFactor, DividendApplicability? dividendApplicability, EquityUnderlierProvisions? equityUnderlierProvisions, int expectedN, decimal? initialLevel, Enums.DeterminationMethod? initialLevelSource, bool? meanAdjustment, string? performance, bool? sharePriceDividendAdjustment, ValuationTerms valuationTerms)
        {
            BoundedCorrelation = boundedCorrelation;
            CorrelationStrikePrice = correlationStrikePrice;
            NumberOfDataSeries = numberOfDataSeries;
            AnnualizationFactor = annualizationFactor;
            DividendApplicability = dividendApplicability;
            EquityUnderlierProvisions = equityUnderlierProvisions;
            ExpectedN = expectedN;
            InitialLevel = initialLevel;
            InitialLevelSource = initialLevelSource;
            MeanAdjustment = meanAdjustment;
            Performance = performance;
            SharePriceDividendAdjustment = sharePriceDividendAdjustment;
            ValuationTerms = valuationTerms;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CorrelationReturnTerms> MetaData => metaData;
        
        /// <summary>
        /// Describes correlation bounds, which form a cap and a floor on the realized correlation.
        /// </summary>
        public NumberRange? BoundedCorrelation { get; }
        
        /// <summary>
        /// Correlation Strike Price in accordance with the ISDA 2011 Equity Derivatives Definitions.
        /// </summary>
        public Price CorrelationStrikePrice { get; }
        
        /// <summary>
        /// Number of data series, normal market practice is that correlation data sets are drawn from geographic market areas, such as America, Europe and Asia Pacific, each of these geographic areas will have its own data series to avoid contagion.
        /// </summary>
        public int? NumberOfDataSeries { get; }
        
        /// <inheritdoc/>
        public int? AnnualizationFactor { get; }
        
        /// <inheritdoc/>
        public DividendApplicability? DividendApplicability { get; }
        
        /// <inheritdoc/>
        public EquityUnderlierProvisions? EquityUnderlierProvisions { get; }
        
        /// <inheritdoc/>
        public int ExpectedN { get; }
        
        /// <inheritdoc/>
        public decimal? InitialLevel { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.DeterminationMethod? InitialLevelSource { get; }
        
        /// <inheritdoc/>
        public bool? MeanAdjustment { get; }
        
        /// <inheritdoc/>
        public string? Performance { get; }
        
        /// <inheritdoc/>
        public bool? SharePriceDividendAdjustment { get; }
        
        /// <inheritdoc/>
        public ValuationTerms ValuationTerms { get; }
    }
    
    /// <summary>
    /// Defines a counterparty enumerated value, e.g. Party1 or Party2, with an associated party reference. The product is agnostic to the actual parties to the transaction, with the party references abstracted away from the product definition and replaced by the CounterpartyEnum (e.g. values Party1 or Party2). The CounterpartyEnum can then be positioned in the product (e.g. to specify which counterparty is the payer, receiver etc) and this Counterparty type, which is positioned outside of the product definition, allows the CounterpartyEnum to be associated with an actual party reference.
    /// </summary>
    public class Counterparty : AbstractRosettaModelObject<Counterparty>
    {
        private static readonly IRosettaMetaData<Counterparty> metaData = new CounterpartyMeta();
        
        [JsonConstructor]
        public Counterparty(ReferenceWithMetaParty partyReference, Enums.CounterpartyRole role)
        {
            PartyReference = partyReference;
            Role = role;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Counterparty> MetaData => metaData;
        
        /// <summary>
        /// Specifies the party that is associated to the counterparty.
        /// </summary>
        public ReferenceWithMetaParty PartyReference { get; }
        
        /// <summary>
        /// Specifies the CounterpartyEnum, e.g. either Party1 or Party2, that is associated to the partyReference.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CounterpartyRole Role { get; }
    }
    
    /// <summary>
    ///  The credit default payout specification provides the details necessary for determining when a credit payout will be triggered as well as the parameters for calculating the payout and the settlement terms. The associated globalKey denotes the ability to associate a hash value to the CreditDefaultPayout instantiations for the purpose of model cross-referencing, in support of functionality such as the event effect and the lineage.
    /// </summary>
    public class CreditDefaultPayout : AbstractRosettaModelObject<CreditDefaultPayout>, IPayoutBase
    {
        private static readonly IRosettaMetaData<CreditDefaultPayout> metaData = new CreditDefaultPayoutMeta();
        
        [JsonConstructor]
        public CreditDefaultPayout(GeneralTerms generalTerms, _MetaFields? meta, IEnumerable<ProtectionTerms> protectionTerms, TransactedPrice? transactedPrice, PayerReceiver payerReceiver, ResolvablePriceQuantity? priceQuantity, PrincipalPayments? principalPayment, SettlementTerms? settlementTerms)
        {
            GeneralTerms = generalTerms;
            Meta = meta;
            ProtectionTerms = protectionTerms;
            TransactedPrice = transactedPrice;
            PayerReceiver = payerReceiver;
            PriceQuantity = priceQuantity;
            PrincipalPayment = principalPayment;
            SettlementTerms = settlementTerms;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CreditDefaultPayout> MetaData => metaData;
        
        /// <summary>
        /// The specification of the non-monetary terms for the Credit Derivative Transaction, including the buyer and seller and selected items from the ISDA 2014 Credit Definition article II, such as the reference obligation and related terms.
        /// </summary>
        public GeneralTerms GeneralTerms { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <summary>
        /// Specifies the terms for calculating a payout to protect the buyer of the swap in the case of a qualified credit event. These terms include the applicable credit events, the reference obligation, and in the case of a CDS on mortgage-backed securities, the floatingAmountEvents.
        /// </summary>
        public IEnumerable<ProtectionTerms> ProtectionTerms { get; }
        
        /// <summary>
        /// The qualification of the price at which the contract has been transacted, in terms of market fixed rate, initial points, market price and/or quotation style. In FpML, those attributes are positioned as part of the fee leg.
        /// </summary>
        public TransactedPrice? TransactedPrice { get; }
        
        /// <inheritdoc/>
        public PayerReceiver PayerReceiver { get; }
        
        /// <inheritdoc/>
        public ResolvablePriceQuantity? PriceQuantity { get; }
        
        /// <inheritdoc/>
        public PrincipalPayments? PrincipalPayment { get; }
        
        /// <inheritdoc/>
        public SettlementTerms? SettlementTerms { get; }
    }
    
    /// <summary>
    /// Specifies the relevant data regarding a credit event.
    /// </summary>
    public class CreditEvent : AbstractRosettaModelObject<CreditEvent>
    {
        private static readonly IRosettaMetaData<CreditEvent> metaData = new CreditEventMeta();
        
        [JsonConstructor]
        public CreditEvent(LocalDate? auctionDate, Enums.CreditEventType creditEventType, LocalDate eventDeterminationDate, Price? finalPrice, IEnumerable<Resource> publiclyAvailableInformation, decimal? recoveryPercent, ReferenceInformation referenceInformation)
        {
            AuctionDate = auctionDate;
            CreditEventType = creditEventType;
            EventDeterminationDate = eventDeterminationDate;
            FinalPrice = finalPrice;
            PubliclyAvailableInformation = publiclyAvailableInformation;
            RecoveryPercent = recoveryPercent;
            ReferenceInformation = referenceInformation;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CreditEvent> MetaData => metaData;
        
        /// <summary>
        /// The date on which the auction is scheduled to occur.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? AuctionDate { get; }
        
        /// <summary>
        /// The type of credit event taking place.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CreditEventType CreditEventType { get; }
        
        /// <summary>
        /// The date in which the credit event is determined by the Credit Derivatives Determinations Comitee.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate EventDeterminationDate { get; }
        
        /// <summary>
        /// The final price resulting from the auction.
        /// </summary>
        public Price? FinalPrice { get; }
        
        /// <summary>
        /// A public information source, e.g. a particular newspaper or electronic news service, that may publish relevant information used in the determination of whether or not a credit event has occurred.
        /// </summary>
        public IEnumerable<Resource> PubliclyAvailableInformation { get; }
        
        /// <summary>
        /// The percentage of the original value of the asset affected by the credit event that can be recovered.
        /// </summary>
        public decimal? RecoveryPercent { get; }
        
        /// <summary>
        /// The reference entity, part of a credit basket, impacted by the credit event.
        /// </summary>
        public ReferenceInformation ReferenceInformation { get; }
    }
    
    public class CreditEventNotice : AbstractRosettaModelObject<CreditEventNotice>
    {
        private static readonly IRosettaMetaData<CreditEventNotice> metaData = new CreditEventNoticeMeta();
        
        [JsonConstructor]
        public CreditEventNotice(Enums.BusinessCenter? businessCenter, IEnumerable<Enums.CounterpartyRole> notifyingParty, PubliclyAvailableInformation? publiclyAvailableInformation)
        {
            BusinessCenter = businessCenter;
            NotifyingParty = notifyingParty;
            PubliclyAvailableInformation = publiclyAvailableInformation;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CreditEventNotice> MetaData => metaData;
        
        /// <summary>
        /// Inclusion of this business center element implies that Greenwich Mean Time in Section 3.3 of the 2003 ISDA Credit Derivatives Definitions is replaced by the local time of the city indicated by the businessCenter element value.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.BusinessCenter? BusinessCenter { get; }
        
        /// <summary>
        /// The notifying party is the party that notifies the other party when a credit event has occurred by means of a credit event notice. If more than one party is referenced as being the notifying party then either party may notify the other of a credit event occurring. ISDA 2003 Term: Notifying Party.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public IEnumerable<Enums.CounterpartyRole> NotifyingParty { get; }
        
        /// <summary>
        /// A specified condition to settlement. Publicly available information means information that reasonably confirms any of the facts relevant to determining that a credit event or potential repudiation/moratorium, as applicable, has occurred. The ISDA defined list (2003) is the market standard and is considered comprehensive, and a minimum of two differing public sources must have published the relevant information, to declare a Credit Event. ISDA 2003 Term: Notice of Publicly Available Information Applicable.
        /// </summary>
        public PubliclyAvailableInformation? PubliclyAvailableInformation { get; }
    }
    
    /// <summary>
    /// A class to specify the applicable Credit Events that would trigger a settlement, as specified in the related Confirmation and defined in the ISDA 2014 Credit Definition article IV section 4.1.
    /// </summary>
    public class CreditEvents : AbstractRosettaModelObject<CreditEvents>
    {
        private static readonly IRosettaMetaData<CreditEvents> metaData = new CreditEventsMeta();
        
        [JsonConstructor]
        public CreditEvents(bool? bankruptcy, CreditEventNotice? creditEventNotice, Money? defaultRequirement, bool? distressedRatingsDowngrade, FailureToPay? failureToPay, bool? failureToPayInterest, bool? failureToPayPrincipal, bool? governmentalIntervention, bool? impliedWritedown, bool? maturityExtension, _MetaFields? meta, bool? obligationAcceleration, bool? obligationDefault, bool? repudiationMoratorium, Restructuring? restructuring, bool? writedown)
        {
            Bankruptcy = bankruptcy;
            CreditEventNotice = creditEventNotice;
            DefaultRequirement = defaultRequirement;
            DistressedRatingsDowngrade = distressedRatingsDowngrade;
            FailureToPay = failureToPay;
            FailureToPayInterest = failureToPayInterest;
            FailureToPayPrincipal = failureToPayPrincipal;
            GovernmentalIntervention = governmentalIntervention;
            ImpliedWritedown = impliedWritedown;
            MaturityExtension = maturityExtension;
            Meta = meta;
            ObligationAcceleration = obligationAcceleration;
            ObligationDefault = obligationDefault;
            RepudiationMoratorium = repudiationMoratorium;
            Restructuring = restructuring;
            Writedown = writedown;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CreditEvents> MetaData => metaData;
        
        /// <summary>
        /// A credit event. The reference entity has been dissolved or has become insolvent. It also covers events that may be a precursor to insolvency such as instigation of bankruptcy or insolvency proceedings. Sovereign trades are not subject to Bankruptcy as &apos;technically&apos; a Sovereign cannot become bankrupt. ISDA 2003 Term: Bankruptcy.
        /// </summary>
        public bool? Bankruptcy { get; }
        
        /// <summary>
        /// A specified condition to settlement. An irrevocable written or verbal notice that describes a credit event that has occurred. The notice is sent from the notifying party (either the buyer or the seller) to the counterparty. It provides information relevant to determining that a credit event has occurred. This is typically accompanied by Publicly Available Information. ISDA 2003 Term: Credit Event Notice.
        /// </summary>
        public CreditEventNotice? CreditEventNotice { get; }
        
        /// <summary>
        /// In relation to certain credit events, serves as a threshold for Obligation Acceleration, Obligation Default, Repudiation/Moratorium and Restructuring. Market standard is USD 10,000,000 (JPY 1,000,000,000 for all Japanese Yen trades). This is applied on an aggregate or total basis across all Obligations of the Reference Entity. Used to prevent technical/operational errors from triggering credit events. ISDA 2003 Term: Default Requirement.
        /// </summary>
        public Money? DefaultRequirement { get; }
        
        /// <summary>
        /// A credit event. Results from the fact that the rating of the reference obligation is down-graded to a distressed rating level. From a usage standpoint, this credit event is typically not applicable in case of RMBS trades.
        /// </summary>
        public bool? DistressedRatingsDowngrade { get; }
        
        /// <summary>
        /// A credit event. This credit event triggers, after the expiration of any applicable grace period, if the reference entity fails to make due payments in an aggregate amount of not less than the payment requirement on one or more obligations (e.g. a missed coupon payment). ISDA 2003 Term: Failure to Pay.
        /// </summary>
        public FailureToPay? FailureToPay { get; }
        
        /// <summary>
        /// A credit event. Corresponds to the failure by the Reference Entity to pay an expected interest amount or the payment of an actual interest amount that is less than the expected interest amount. ISDA 2003 Term: Failure to Pay Interest.
        /// </summary>
        public bool? FailureToPayInterest { get; }
        
        /// <summary>
        /// A credit event. Corresponds to the failure by the Reference Entity to pay an expected principal amount or the payment of an actual principal amount that is less than the expected principal amount. ISDA 2003 Term: Failure to Pay Principal.
        /// </summary>
        public bool? FailureToPayPrincipal { get; }
        
        /// <summary>
        /// A credit event. A governmental intervention is an event resulting from an action by a governmental authority that materially impacts the reference entity&apos;s obligations, such as an interest rate reduction, principal reduction, deferral of interest or principal, change in priority ranking, or change in currency or composition of payment. ISDA 2014 Term: Governmental Intervention.
        /// </summary>
        public bool? GovernmentalIntervention { get; }
        
        /// <summary>
        /// A credit event. Results from the fact that losses occur to the underlying instruments that do not result in reductions of the outstanding principal of the reference obligation.
        /// </summary>
        public bool? ImpliedWritedown { get; }
        
        /// <summary>
        /// A credit event. Results from the fact that the underlier fails to make principal payments as expected.
        /// </summary>
        public bool? MaturityExtension { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <summary>
        /// A credit event. One or more of the obligations have been declared due and payable before they would otherwise have been due and payable as a result of, or on the basis of, the occurrence of a default, event of default or other similar condition or event other than failure to pay (preferred by the market over Obligation Default, because more definitive and encompasses the definition of Obligation Default - this is more favorable to the Seller). Subject to the default requirement amount. ISDA 2003 Term: Obligation Acceleration.
        /// </summary>
        public bool? ObligationAcceleration { get; }
        
        /// <summary>
        /// A credit event. One or more of the obligations have become capable of being declared due and payable before they would otherwise have been due and payable as a result of, or on the basis of, the occurrence of a default, event of default or other similar condition or event other than failure to pay. ISDA 2003 Term: Obligation Default.
        /// </summary>
        public bool? ObligationDefault { get; }
        
        /// <summary>
        /// A credit event. The reference entity, or a governmental authority, either refuses to recognise or challenges the validity of one or more obligations of the reference entity, or imposes a moratorium thereby postponing payments on one or more of the obligations of the reference entity. Subject to the default requirement amount. ISDA 2003 Term: Repudiation/Moratorium.
        /// </summary>
        public bool? RepudiationMoratorium { get; }
        
        /// <summary>
        /// A credit event. A restructuring is an event that materially impacts the reference entity&apos;s obligations, such as an interest rate reduction, principal reduction, deferral of interest or principal, change in priority ranking, or change in currency or composition of payment. ISDA 2003 Term: Restructuring.
        /// </summary>
        public Restructuring? Restructuring { get; }
        
        /// <summary>
        /// A credit event. Results from the fact that the underlier writes down its outstanding principal amount.
        /// </summary>
        public bool? Writedown { get; }
    }
    
    /// <summary>
    /// A class to represent the credit limit utilisation information.
    /// </summary>
    public class CreditLimitInformation : AbstractRosettaModelObject<CreditLimitInformation>
    {
        private static readonly IRosettaMetaData<CreditLimitInformation> metaData = new CreditLimitInformationMeta();
        
        [JsonConstructor]
        public CreditLimitInformation(IEnumerable<LimitApplicableExtended> limitApplicable)
        {
            LimitApplicable = limitApplicable;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CreditLimitInformation> MetaData => metaData;
        
        public IEnumerable<LimitApplicableExtended> LimitApplicable { get; }
    }
    
    /// <summary>
    /// Credit limit utilisation breakdown by executed trades and pending orders.
    /// </summary>
    public class CreditLimitUtilisation : AbstractRosettaModelObject<CreditLimitUtilisation>
    {
        private static readonly IRosettaMetaData<CreditLimitUtilisation> metaData = new CreditLimitUtilisationMeta();
        
        [JsonConstructor]
        public CreditLimitUtilisation(CreditLimitUtilisationPosition? executed, CreditLimitUtilisationPosition? pending)
        {
            Executed = executed;
            Pending = pending;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CreditLimitUtilisation> MetaData => metaData;
        
        /// <summary>
        /// Credit limit utilisation attributable to executed trades.
        /// </summary>
        public CreditLimitUtilisationPosition? Executed { get; }
        
        /// <summary>
        /// Credit limit utilisation attributable to pending unexecuted orders.
        /// </summary>
        public CreditLimitUtilisationPosition? Pending { get; }
    }
    
    public class CreditLimitUtilisationPosition : AbstractRosettaModelObject<CreditLimitUtilisationPosition>
    {
        private static readonly IRosettaMetaData<CreditLimitUtilisationPosition> metaData = new CreditLimitUtilisationPositionMeta();
        
        [JsonConstructor]
        public CreditLimitUtilisationPosition(decimal? global, decimal? longPosition, decimal? shortPosition)
        {
            Global = global;
            LongPosition = longPosition;
            ShortPosition = shortPosition;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CreditLimitUtilisationPosition> MetaData => metaData;
        
        /// <summary>
        /// Global credit limit utilisation amount, agnostic of long/short position direction.
        /// </summary>
        public decimal? Global { get; }
        
        /// <summary>
        /// Credit limit utilisation attributable to long positions.
        /// </summary>
        public decimal? LongPosition { get; }
        
        /// <summary>
        /// Credit limit utilisation attributable to short positions.
        /// </summary>
        public decimal? ShortPosition { get; }
    }
    
    /// <summary>
    /// Represents a class to specify the credit notation as the combination of agency, notation, scale and debt type qualifications.
    /// </summary>
    public class CreditNotation : AbstractRosettaModelObject<CreditNotation>
    {
        private static readonly IRosettaMetaData<CreditNotation> metaData = new CreditNotationMeta();
        
        [JsonConstructor]
        public CreditNotation(Enums.CreditRatingAgency agency, Enums.CreditRatingCreditWatch? creditWatch, CreditRatingDebt? debt, FieldWithMetaString notation, Enums.CreditRatingOutlook? outlook, FieldWithMetaString? scale)
        {
            Agency = agency;
            CreditWatch = creditWatch;
            Debt = debt;
            Notation = notation;
            Outlook = outlook;
            Scale = scale;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CreditNotation> MetaData => metaData;
        
        /// <summary>
        /// Specifies The credit agency to which the other variables (notation, scale, debt type) refer to.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CreditRatingAgency Agency { get; }
        
        /// <summary>
        /// Indicates the potential direction of a short-term or long-term rating. It focuses on identifiable events and short-term trends that cause ratings to be placed under special surveillance.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CreditRatingCreditWatch? CreditWatch { get; }
        
        /// <summary>
        /// Specifies the credit rating debt type (e.g. long term, high yield, deposits, ...) associated with the credit rating notation and scale.
        /// </summary>
        public CreditRatingDebt? Debt { get; }
        
        /// <summary>
        /// Specifies The credit rating notation. As it varies among credit rating agencies, FpML doesn&apos;t specify a default scheme.
        /// </summary>
        public FieldWithMetaString Notation { get; }
        
        /// <summary>
        /// Assesses the potential direction of a long-term credit rating over the intermediate term, which is generally up to two years for investment grade and generally up to one year for speculative grade.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CreditRatingOutlook? Outlook { get; }
        
        /// <summary>
        /// Specifies the credit rating scale, with a typical distinction between short term, long term. FpML doesn&apos;t specify a default scheme, which is hence not specified as an enumeration as part of the CDM.
        /// </summary>
        public FieldWithMetaString? Scale { get; }
    }
    
    /// <summary>
    /// Represents the credit rating notation higher level construct, which provides the ability to specify multiple rating notations.
    /// </summary>
    public class CreditNotations : AbstractRosettaModelObject<CreditNotations>
    {
        private static readonly IRosettaMetaData<CreditNotations> metaData = new CreditNotationsMeta();
        
        [JsonConstructor]
        public CreditNotations(CreditNotation? creditNotation, MultipleCreditNotations? creditNotations)
        {
            CreditNotation = creditNotation;
            CreditNotationsValue = creditNotations;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CreditNotations> MetaData => metaData;
        
        /// <summary>
        /// Specifies only one credit notation is determined.
        /// </summary>
        public CreditNotation? CreditNotation { get; }
        
        /// <summary>
        /// Specifies if several credit notations exist, alongside an &apos;any&apos; or &apos;all&apos; or all condition.
        /// </summary>
        [JsonProperty(PropertyName = "creditNotations")]
        public MultipleCreditNotations? CreditNotationsValue { get; }
    }
    
    /// <summary>
    /// Specifies the credit rating debt type(s) associated with the credit rating notation and scale. When several debt types are specified, they must be qualified through an &apos;any&apos; or &apos;all&apos;.
    /// </summary>
    public class CreditRatingDebt : AbstractRosettaModelObject<CreditRatingDebt>
    {
        private static readonly IRosettaMetaData<CreditRatingDebt> metaData = new CreditRatingDebtMeta();
        
        [JsonConstructor]
        public CreditRatingDebt(FieldWithMetaString? debtType, MultipleDebtTypes? debtTypes)
        {
            DebtType = debtType;
            DebtTypes = debtTypes;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CreditRatingDebt> MetaData => metaData;
        
        /// <summary>
        /// Specifies when there is only one debt type. FpML doesn&apos;t specify values in relation to the associated scheme, which is hence not specified as an enumeration as part of the CDM.
        /// </summary>
        public FieldWithMetaString? DebtType { get; }
        
        /// <summary>
        /// Specifies if there are several debt types, alongside an &apos;any&apos; or &apos;all&apos; or all condition. As an example, Baa1 rating is required for any long term debt and deposit.
        /// </summary>
        public MultipleDebtTypes? DebtTypes { get; }
    }
    
    /// <summary>
    /// The set of elections which specify a Credit Support Annex or Deed.
    /// </summary>
    public class CreditSupportAgreementElections : AbstractRosettaModelObject<CreditSupportAgreementElections>
    {
        private static readonly IRosettaMetaData<CreditSupportAgreementElections> metaData = new CreditSupportAgreementElectionsMeta();
        
        [JsonConstructor]
        public CreditSupportAgreementElections()
        {
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CreditSupportAgreementElections> MetaData => metaData;
        
    }
    
    /// <summary>
    /// A class that is used for including the currency exchange rates used to cross between the traded currencies for non-base currency FX contracts.
    /// </summary>
    public class CrossRate : AbstractRosettaModelObject<CrossRate>, IQuotedCurrencyPair
    {
        private static readonly IRosettaMetaData<CrossRate> metaData = new CrossRateMeta();
        
        [JsonConstructor]
        public CrossRate(decimal? forwardPoints, decimal rate, decimal? spotRate, FieldWithMetaString currency1, FieldWithMetaString currency2, Enums.QuoteBasis quoteBasis)
        {
            ForwardPoints = forwardPoints;
            Rate = rate;
            SpotRate = spotRate;
            Currency1 = currency1;
            Currency2 = currency2;
            QuoteBasis = quoteBasis;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CrossRate> MetaData => metaData;
        
        /// <summary>
        /// An optional element used for deals consummated in the FX Forwards market. Forward points represent the interest rate differential between the two currencies traded and are quoted as a premium or a discount. Forward points are added to, or subtracted from, the spot rate to create the rate of the forward trade.
        /// </summary>
        public decimal? ForwardPoints { get; }
        
        /// <summary>
        /// The exchange rate used to cross between the traded currencies.
        /// </summary>
        public decimal Rate { get; }
        
        /// <summary>
        /// An optional element used for FX forwards and certain types of FX OTC options. For deals consummated in the FX Forwards Market, this represents the current market rate for a particular currency pair.
        /// </summary>
        public decimal? SpotRate { get; }
        
        /// <inheritdoc/>
        public FieldWithMetaString Currency1 { get; }
        
        /// <inheritdoc/>
        public FieldWithMetaString Currency2 { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.QuoteBasis QuoteBasis { get; }
    }
    
    public class Curve : AbstractRosettaModelObject<Curve>
    {
        private static readonly IRosettaMetaData<Curve> metaData = new CurveMeta();
        
        [JsonConstructor]
        public Curve(FieldWithMetaCommodityReferencePriceEnum? commodityCurve, InterestRateCurve? interestRateCurve)
        {
            CommodityCurve = commodityCurve;
            InterestRateCurve = interestRateCurve;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Curve> MetaData => metaData;
        
        public FieldWithMetaCommodityReferencePriceEnum? CommodityCurve { get; }
        
        public InterestRateCurve? InterestRateCurve { get; }
    }
    
    /// <summary>
    /// A class to specify an offset either as a normalized [multiplier, period, dayType] or as a custom provision of type string.
    /// </summary>
    public class CustomisableOffset : AbstractRosettaModelObject<CustomisableOffset>
    {
        private static readonly IRosettaMetaData<CustomisableOffset> metaData = new CustomisableOffsetMeta();
        
        [JsonConstructor]
        public CustomisableOffset(string? customProvision, Offset? offset)
        {
            CustomProvision = customProvision;
            Offset = offset;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CustomisableOffset> MetaData => metaData;
        
        public string? CustomProvision { get; }
        
        public Offset? Offset { get; }
    }
    
    /// <summary>
    /// In its initial iteration, this class is meant to support the DTCC TIW workflow information.
    /// </summary>
    public class CustomisedWorkflow : AbstractRosettaModelObject<CustomisedWorkflow>
    {
        private static readonly IRosettaMetaData<CustomisedWorkflow> metaData = new CustomisedWorkflowMeta();
        
        [JsonConstructor]
        public CustomisedWorkflow(string itemName, string itemValue)
        {
            ItemName = itemName;
            ItemValue = itemValue;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CustomisedWorkflow> MetaData => metaData;
        
        /// <summary>
        /// In this initial iteration, this corresponds to the DTCC TIW element name.
        /// </summary>
        public string ItemName { get; }
        
        /// <summary>
        /// In this initial iteration, this corresponds to the DTCC value.
        /// </summary>
        public string ItemValue { get; }
    }
    
    /// <summary>
    /// List of dates.
    /// </summary>
    public class DateList : AbstractRosettaModelObject<DateList>
    {
        private static readonly IRosettaMetaData<DateList> metaData = new DateListMeta();
        
        [JsonConstructor]
        public DateList(IEnumerable<LocalDate> date)
        {
            Date = date;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<DateList> MetaData => metaData;
        
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public IEnumerable<LocalDate> Date { get; }
    }
    
    /// <summary>
    /// A class defining a contiguous series of calendar dates. The date range is defined as all the dates between and including the start and the end date. The start date must fall on or before the end date.
    /// </summary>
    public class DateRange : AbstractRosettaModelObject<DateRange>, IDateRange
    {
        private static readonly IRosettaMetaData<DateRange> metaData = new DateRangeMeta();
        
        [JsonConstructor]
        public DateRange(LocalDate endDate, LocalDate startDate)
        {
            EndDate = endDate;
            StartDate = startDate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<DateRange> MetaData => metaData;
        
        /// <inheritdoc/>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate EndDate { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate StartDate { get; }
    }
    
    /// <summary>
    /// A data to:  provide the ability to point to multiple payment nodes in the document through the unbounded paymentDatesReference.
    /// </summary>
    public class DateRelativeToCalculationPeriodDates : AbstractRosettaModelObject<DateRelativeToCalculationPeriodDates>
    {
        private static readonly IRosettaMetaData<DateRelativeToCalculationPeriodDates> metaData = new DateRelativeToCalculationPeriodDatesMeta();
        
        [JsonConstructor]
        public DateRelativeToCalculationPeriodDates(IEnumerable<ReferenceWithMetaCalculationPeriodDates> calculationPeriodDatesReference)
        {
            CalculationPeriodDatesReference = calculationPeriodDatesReference;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<DateRelativeToCalculationPeriodDates> MetaData => metaData;
        
        /// <summary>
        /// A set of href pointers to calculation period dates defined somewhere else in the document.
        /// </summary>
        public IEnumerable<ReferenceWithMetaCalculationPeriodDates> CalculationPeriodDatesReference { get; }
    }
    
    /// <summary>
    /// A data to:  provide the ability to point to multiple payment nodes in the document through the unbounded paymentDatesReference.
    /// </summary>
    public class DateRelativeToPaymentDates : AbstractRosettaModelObject<DateRelativeToPaymentDates>
    {
        private static readonly IRosettaMetaData<DateRelativeToPaymentDates> metaData = new DateRelativeToPaymentDatesMeta();
        
        [JsonConstructor]
        public DateRelativeToPaymentDates(IEnumerable<ReferenceWithMetaPaymentDates> paymentDatesReference)
        {
            PaymentDatesReference = paymentDatesReference;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<DateRelativeToPaymentDates> MetaData => metaData;
        
        /// <summary>
        /// A set of href pointers to payment dates defined somewhere else in the document.
        /// </summary>
        public IEnumerable<ReferenceWithMetaPaymentDates> PaymentDatesReference { get; }
    }
    
    /// <summary>
    /// A data to:  provide the ability to point to multiple payment nodes in the document through the unbounded paymentDatesReference.
    /// </summary>
    public class DateRelativeToValuationDates : AbstractRosettaModelObject<DateRelativeToValuationDates>
    {
        private static readonly IRosettaMetaData<DateRelativeToValuationDates> metaData = new DateRelativeToValuationDatesMeta();
        
        [JsonConstructor]
        public DateRelativeToValuationDates(IEnumerable<ReferenceWithMetaPerformanceValuationDates> valuationDatesReference)
        {
            ValuationDatesReference = valuationDatesReference;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<DateRelativeToValuationDates> MetaData => metaData;
        
        /// <summary>
        /// A set of href pointers to valuation period dates defined somewhere else in the document.
        /// </summary>
        public IEnumerable<ReferenceWithMetaPerformanceValuationDates> ValuationDatesReference { get; }
    }
    
    /// <summary>
    /// List of dateTimes.
    /// </summary>
    public class DateTimeList : AbstractRosettaModelObject<DateTimeList>
    {
        private static readonly IRosettaMetaData<DateTimeList> metaData = new DateTimeListMeta();
        
        [JsonConstructor]
        public DateTimeList(IEnumerable<ZonedDateTime> dateTime)
        {
            DateTime = dateTime;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<DateTimeList> MetaData => metaData;
        
        /// <summary>
        /// The CDM specifies that the zoned date time is to be expressed in accordance with ISO 8601, either as UTC as an offset to UTC.
        /// </summary>
        public IEnumerable<ZonedDateTime> DateTime { get; }
    }
    
    /// <summary>
    /// Defines a date and value pair. This definition is used for varying rate or amount schedules, e.g. a notional amortisation or a step-up coupon schedule.
    /// </summary>
    public class DatedValue : AbstractRosettaModelObject<DatedValue>
    {
        private static readonly IRosettaMetaData<DatedValue> metaData = new DatedValueMeta();
        
        [JsonConstructor]
        public DatedValue(LocalDate date, _MetaFields? meta, decimal value)
        {
            Date = date;
            Meta = meta;
            Value = value;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<DatedValue> MetaData => metaData;
        
        /// <summary>
        /// The date on which the associated step value becomes effective. This day may be subject to adjustment in accordance with a business day convention.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate Date { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <summary>
        /// The rate of amount which becomes effective on the associated step date. A rate of 5% would be represented as 0.05.
        /// </summary>
        public decimal Value { get; }
    }
    
    /// <summary>
    /// Specifies selected economics of a debt instrument.
    /// </summary>
    public class DebtEconomics : AbstractRosettaModelObject<DebtEconomics>
    {
        private static readonly IRosettaMetaData<DebtEconomics> metaData = new DebtEconomicsMeta();
        
        [JsonConstructor]
        public DebtEconomics(Enums.DebtInterest? debtInterest, Enums.DebtPrincipal? debtPrincipal, Enums.DebtSeniority? debtSeniority)
        {
            DebtInterest = debtInterest;
            DebtPrincipal = debtPrincipal;
            DebtSeniority = debtSeniority;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<DebtEconomics> MetaData => metaData;
        
        /// <summary>
        /// Specifies the general rule for periodic interest rate payment.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.DebtInterest? DebtInterest { get; }
        
        /// <summary>
        /// Specifies the general rule for repayment of principal.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.DebtPrincipal? DebtPrincipal { get; }
        
        /// <summary>
        /// Specifies the order of repayment in the event of a sale or bankruptcy of the issuer or a related party (eg guarantor).
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.DebtSeniority? DebtSeniority { get; }
    }
    
    /// <summary>
    /// Specifies the type of debt instrument.
    /// </summary>
    public class DebtType : AbstractRosettaModelObject<DebtType>
    {
        private static readonly IRosettaMetaData<DebtType> metaData = new DebtTypeMeta();
        
        [JsonConstructor]
        public DebtType(Enums.DebtClass? debtClass, IEnumerable<DebtEconomics> debtEconomics)
        {
            DebtClass = debtClass;
            DebtEconomics = debtEconomics;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<DebtType> MetaData => metaData;
        
        /// <summary>
        /// Specifies the characteristics of a debt instrument.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.DebtClass? DebtClass { get; }
        
        /// <summary>
        /// Specifies selected financial terms of a debt instrument.
        /// </summary>
        public IEnumerable<DebtEconomics> DebtEconomics { get; }
    }
    
    /// <summary>
    /// A class to specify all the ISDA terms relevant to defining the deliverable obligations.
    /// </summary>
    public class DeliverableObligations : AbstractRosettaModelObject<DeliverableObligations>
    {
        private static readonly IRosettaMetaData<DeliverableObligations> metaData = new DeliverableObligationsMeta();
        
        [JsonConstructor]
        public DeliverableObligations(bool? acceleratedOrMatured, bool? accruedInterest, PCDeliverableObligationCharac? assignableLoan, Enums.ObligationCategory? category, PCDeliverableObligationCharac? consentRequiredLoan, LoanParticipation? directLoanParticipation, string? excluded, bool? fullFaithAndCreditObLiability, bool? generalFundObligationLiability, LoanParticipation? indirectLoanParticipation, bool? listed, Period? maximumMaturity, bool? notBearer, bool? notContingent, NotDomesticCurrency? notDomesticCurrency, bool? notDomesticIssuance, bool? notDomesticLaw, bool? notSovereignLender, bool? notSubordinated, string? othReferenceEntityObligations, bool? revenueObligationLiability, SpecifiedCurrency? specifiedCurrency, bool? transferable)
        {
            AcceleratedOrMatured = acceleratedOrMatured;
            AccruedInterest = accruedInterest;
            AssignableLoan = assignableLoan;
            Category = category;
            ConsentRequiredLoan = consentRequiredLoan;
            DirectLoanParticipation = directLoanParticipation;
            Excluded = excluded;
            FullFaithAndCreditObLiability = fullFaithAndCreditObLiability;
            GeneralFundObligationLiability = generalFundObligationLiability;
            IndirectLoanParticipation = indirectLoanParticipation;
            Listed = listed;
            MaximumMaturity = maximumMaturity;
            NotBearer = notBearer;
            NotContingent = notContingent;
            NotDomesticCurrency = notDomesticCurrency;
            NotDomesticIssuance = notDomesticIssuance;
            NotDomesticLaw = notDomesticLaw;
            NotSovereignLender = notSovereignLender;
            NotSubordinated = notSubordinated;
            OthReferenceEntityObligations = othReferenceEntityObligations;
            RevenueObligationLiability = revenueObligationLiability;
            SpecifiedCurrency = specifiedCurrency;
            Transferable = transferable;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<DeliverableObligations> MetaData => metaData;
        
        /// <summary>
        /// A deliverable obligation characteristic. An obligation at time of default is due to mature and due to be repaid, or as a result of downgrade/bankruptcy is due to be repaid as a result of an acceleration clause. ISDA 2003 Term: Accelerated or Matured.
        /// </summary>
        public bool? AcceleratedOrMatured { get; }
        
        /// <summary>
        /// Indicates whether accrued interest is included (true) or not (false). For cash settlement this specifies whether quotations should be obtained inclusive or not of accrued interest. For physical settlement this specifies whether the buyer should deliver the obligation with an outstanding principal balance that includes or excludes accrued interest. ISDA 2003 Term: Include/Exclude Accrued Interest.
        /// </summary>
        public bool? AccruedInterest { get; }
        
        /// <summary>
        /// A deliverable obligation characteristic. A loan that is freely assignable to a bank or financial institution without the consent of the Reference Entity or the guarantor, if any, of the loan (or the consent of the applicable borrower if a Reference Entity is guaranteeing the loan) or any agent. ISDA 2003 Term: Assignable Loan.
        /// </summary>
        public PCDeliverableObligationCharac? AssignableLoan { get; }
        
        /// <summary>
        /// Used in both obligations and deliverable obligations to represent a class or type of securities which apply. ISDA 2003 Term: Obligation Category/Deliverable Obligation Category.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.ObligationCategory? Category { get; }
        
        /// <summary>
        /// A deliverable obligation characteristic. A loan that is capable of being assigned with the consent of the Reference Entity or the guarantor, if any, of the loan or any agent. ISDA 2003 Term: Consent Required Loan.
        /// </summary>
        public PCDeliverableObligationCharac? ConsentRequiredLoan { get; }
        
        /// <summary>
        /// A deliverable obligation characteristic. A loan with a participation agreement whereby the buyer is capable of creating, or procuring the creation of, a contractual right in favour of the seller that provides the seller with recourse to the participation seller for a specified share in any payments due under the relevant loan which are received by the participation seller. ISDA 2003 Term: Direct Loan Participation.
        /// </summary>
        public LoanParticipation? DirectLoanParticipation { get; }
        
        /// <summary>
        /// A free format string to specify any excluded obligations or deliverable obligations, as the case may be, of the reference entity or excluded types of obligations or deliverable obligations. ISDA 2003 Term: Excluded Obligations/Excluded Deliverable Obligations.
        /// </summary>
        public string? Excluded { get; }
        
        /// <summary>
        /// An obligation and deliverable obligation characteristic. Defined in the ISDA published additional provisions for U.S. Municipal as Reference Entity. ISDA 2003 Term: Full Faith and Credit Obligation Liability.
        /// </summary>
        public bool? FullFaithAndCreditObLiability { get; }
        
        /// <summary>
        /// An obligation and deliverable obligation characteristic. Defined in the ISDA published additional provisions for U.S. Municipal as Reference Entity. ISDA 2003 Term: General Fund Obligation Liability.
        /// </summary>
        public bool? GeneralFundObligationLiability { get; }
        
        /// <summary>
        /// ISDA 1999 Term: Indirect Loan Participation. NOTE: Only applicable as a deliverable obligation under ISDA Credit 1999.
        /// </summary>
        public LoanParticipation? IndirectLoanParticipation { get; }
        
        /// <summary>
        /// An obligation and deliverable obligation characteristic. Indicates whether or not the obligation is quoted, listed or ordinarily purchased and sold on an exchange. ISDA 2003 Term: Listed.
        /// </summary>
        public bool? Listed { get; }
        
        /// <summary>
        /// A deliverable obligation characteristic. An obligation that has a remaining maturity from the Physical Settlement Date of not greater than the period specified. ISDA 2003 Term: Maximum Maturity.
        /// </summary>
        public Period? MaximumMaturity { get; }
        
        /// <summary>
        /// A deliverable obligation characteristic. Any obligation that is not a bearer instrument. This applies to Bonds only and is meant to avoid tax, fraud and security/delivery provisions that can potentially be associated with Bearer Bonds. ISDA 2003 Term: Not Bearer.
        /// </summary>
        public bool? NotBearer { get; }
        
        /// <summary>
        /// A deliverable obligation characteristic. In essence Not Contingent means the repayment of principal cannot be dependant on a formula/index, i.e. to prevent the risk of being delivered an instrument that may never pay any element of principal, and to ensure that the obligation is interest bearing (on a regular schedule). ISDA 2003 Term: Not Contingent.
        /// </summary>
        public bool? NotContingent { get; }
        
        /// <summary>
        /// An obligation and deliverable obligation characteristic. Any obligation that is payable in any currency other than the domestic currency. Domestic currency is either the currency so specified or, if no currency is specified, the currency of (a) the reference entity, if the reference entity is a sovereign, or (b) the jurisdiction in which the relevant reference entity is organised, if the reference entity is not a sovereign. ISDA 2003 Term: Not Domestic Currency.
        /// </summary>
        public NotDomesticCurrency? NotDomesticCurrency { get; }
        
        /// <summary>
        /// An obligation and deliverable obligation characteristic. Any obligation other than an obligation that was intended to be offered for sale primarily in the domestic market of the relevant Reference Entity. This specifies that the obligation must be an internationally recognised bond. ISDA 2003 Term: Not Domestic Issuance.
        /// </summary>
        public bool? NotDomesticIssuance { get; }
        
        /// <summary>
        /// An obligation and deliverable obligation characteristic. If the reference entity is a Sovereign, this means any obligation that is not subject to the laws of the reference entity. If the reference entity is not a sovereign, this means any obligation that is not subject to the laws of the jurisdiction of the reference entity. ISDA 2003 Term: Not Domestic Law.
        /// </summary>
        public bool? NotDomesticLaw { get; }
        
        /// <summary>
        /// An obligation and deliverable obligation characteristic. Any obligation that is not primarily (majority) owed to a Sovereign or Supranational Organisation. ISDA 2003 Term: Not Sovereign Lender.
        /// </summary>
        public bool? NotSovereignLender { get; }
        
        /// <summary>
        /// An obligation and deliverable obligation characteristic. An obligation that ranks at least equal with the most senior Reference Obligation in priority of payment or, if no Reference Obligation is specified in the related Confirmation, the obligations of the Reference Entity that are senior. ISDA 2003 Term: Not Subordinated.
        /// </summary>
        public bool? NotSubordinated { get; }
        
        /// <summary>
        /// This element is used to specify any other obligations of a reference entity in both obligations and deliverable obligations. The obligations can be specified free-form. ISDA 2003 Term: Other Obligations of a Reference Entity.
        /// </summary>
        public string? OthReferenceEntityObligations { get; }
        
        /// <summary>
        /// An obligation and deliverable obligation characteristic. Defined in the ISDA published additional provisions for U.S. Municipal as Reference Entity. ISDA 2003 Term: Revenue Obligation Liability.
        /// </summary>
        public bool? RevenueObligationLiability { get; }
        
        /// <summary>
        /// An obligation and deliverable obligation characteristic. The currency or currencies in which an obligation or deliverable obligation must be payable. ISDA 2003 Term: Specified Currency.
        /// </summary>
        public SpecifiedCurrency? SpecifiedCurrency { get; }
        
        /// <summary>
        /// A deliverable obligation characteristic. An obligation that is transferable to institutional investors without any contractual, statutory or regulatory restrictions. ISDA 2003 Term: Transferable.
        /// </summary>
        public bool? Transferable { get; }
    }
    
    /// <summary>
    /// A class to specify the application of Interest Amount with respect the Delivery Amount.
    /// </summary>
    public class DeliveryAmount : AbstractRosettaModelObject<DeliveryAmount>
    {
        private static readonly IRosettaMetaData<DeliveryAmount> metaData = new DeliveryAmountMeta();
        
        [JsonConstructor]
        public DeliveryAmount(string? customElection, Enums.DeliveryAmountElection? standardElection)
        {
            CustomElection = customElection;
            StandardElection = standardElection;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<DeliveryAmount> MetaData => metaData;
        
        /// <summary>
        /// The custom election that might be specified by the parties to the agreement.
        /// </summary>
        public string? CustomElection { get; }
        
        /// <summary>
        /// The standard election as specified by an enumeration.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.DeliveryAmountElection? StandardElection { get; }
    }
    
    /// <summary>
    /// Specifies a specific date or the parameters for identifying the relevant contract date when the commodity reference price is a futures contract.
    /// </summary>
    public class DeliveryDateParameters : AbstractRosettaModelObject<DeliveryDateParameters>
    {
        private static readonly IRosettaMetaData<DeliveryDateParameters> metaData = new DeliveryDateParametersMeta();
        
        [JsonConstructor]
        public DeliveryDateParameters(AdjustableDate? deliveryDate, Offset? deliveryDateExpirationConvention, Offset? deliveryDateRollConvention, Offset? deliveryNearby)
        {
            DeliveryDate = deliveryDate;
            DeliveryDateExpirationConvention = deliveryDateExpirationConvention;
            DeliveryDateRollConvention = deliveryDateRollConvention;
            DeliveryNearby = deliveryNearby;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<DeliveryDateParameters> MetaData => metaData;
        
        /// <summary>
        /// Specifies the specific contract date for the contract that should be referenced for a price.
        /// </summary>
        public AdjustableDate? DeliveryDate { get; }
        
        /// <summary>
        /// Specifies, for a Commodity Transaction that references a listed future, the day on which the specified future will expire ahead of the actual expiration of the referenced future. For example: Z21 Contract expires on 19Nov21, with an adjust of 2D the &apos;expire&apos; will be 16Nov21. DeliveryDateRollConvention takes precedence. Example: Pricing on the Z21 Contract with NearbyContractDay and a deliveryDateRoll of 10D, Sampling of the F22 Contract will occur on 8Nov21 through the last Date of the Z21 Contract. With an ExpConvention of 5D, the last sampling date on the F22 contract will be 12Nov21.
        /// </summary>
        public Offset? DeliveryDateExpirationConvention { get; }
        
        /// <summary>
        /// Specifies, for a Commodity Transaction that references a listed future, the day on which the specified future will roll to the next nearby month prior to the expiration of the referenced future. If the future will not roll at all - i.e. the price will be taken from the expiring contract, 0 days should be specified here. If the future will roll to the next nearby on the last trading day - i.e. the price will be taken from the next nearby on the last trading day, then 1 business day should be specified and so on.
        /// </summary>
        public Offset? DeliveryDateRollConvention { get; }
        
        /// <summary>
        /// Provides a container for the parametric representation that specifies which nearby contract date would be used as a refrence for a price.
        /// </summary>
        public Offset? DeliveryNearby { get; }
    }
    
    public class DerivInstrmAttrbts : AbstractRosettaModelObject<DerivInstrmAttrbts>
    {
        private static readonly IRosettaMetaData<DerivInstrmAttrbts> metaData = new DerivInstrmAttrbtsMeta();
        
        [JsonConstructor]
        public DerivInstrmAttrbts(string dlvryTp, string pricMltplr, UndrlygInstrm undrlygInstrm, string xpryDt)
        {
            DlvryTp = dlvryTp;
            PricMltplr = pricMltplr;
            UndrlygInstrm = undrlygInstrm;
            XpryDt = xpryDt;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<DerivInstrmAttrbts> MetaData => metaData;
        
        public string DlvryTp { get; }
        
        public string PricMltplr { get; }
        
        public UndrlygInstrm UndrlygInstrm { get; }
        
        public string XpryDt { get; }
    }
    
    /// <summary>
    /// Specifies the method according to which an amount or a date is determined.
    /// </summary>
    public class DeterminationMethodology : AbstractRosettaModelObject<DeterminationMethodology>
    {
        private static readonly IRosettaMetaData<DeterminationMethodology> metaData = new DeterminationMethodologyMeta();
        
        [JsonConstructor]
        public DeterminationMethodology(Enums.AveragingCalculationMethod? averagingMethod, Enums.DeterminationMethod? determinationMethod)
        {
            AveragingMethod = averagingMethod;
            DeterminationMethod = determinationMethod;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<DeterminationMethodology> MetaData => metaData;
        
        /// <summary>
        /// Specifies enumerations for the type of averaging calculation.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.AveragingCalculationMethod? AveragingMethod { get; }
        
        /// <summary>
        /// Represents a more granular dimention of observation. Typically relevent for resolving a unique equity price, which can be expressed as trade-weighted or volume-weighted averages.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.DeterminationMethod? DeterminationMethod { get; }
    }
    
    /// <summary>
    /// A data defining:  discounting information. The 2000 ISDA definitions, section 8.4. discounting (related to the calculation of a discounted fixed amount or floating amount) apply. This type must only be included if discounting applies.
    /// </summary>
    public class DiscountingMethod : AbstractRosettaModelObject<DiscountingMethod>
    {
        private static readonly IRosettaMetaData<DiscountingMethod> metaData = new DiscountingMethodMeta();
        
        [JsonConstructor]
        public DiscountingMethod(decimal? discountRate, FieldWithMetaDayCountFractionEnum? discountRateDayCountFraction, Enums.DiscountingType discountingType)
        {
            DiscountRate = discountRate;
            DiscountRateDayCountFraction = discountRateDayCountFraction;
            DiscountingType = discountingType;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<DiscountingMethod> MetaData => metaData;
        
        /// <summary>
        /// A discount rate, expressed as a decimal, to be used in the calculation of a discounted amount. A discount amount of 5% would be represented as 0.05.
        /// </summary>
        public decimal? DiscountRate { get; }
        
        /// <summary>
        /// A discount day count fraction to be used in the calculation of a discounted amount.
        /// </summary>
        public FieldWithMetaDayCountFractionEnum? DiscountRateDayCountFraction { get; }
        
        /// <summary>
        /// The discounting method that is applicable.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.DiscountingType DiscountingType { get; }
    }
    
    /// <summary>
    /// A class to specify the Distributions and Interest Payment provisions applicable to the collateral agreement.
    /// </summary>
    public class DistributionAndInterestPayment : AbstractRosettaModelObject<DistributionAndInterestPayment>
    {
        private static readonly IRosettaMetaData<DistributionAndInterestPayment> metaData = new DistributionAndInterestPaymentMeta();
        
        [JsonConstructor]
        public DistributionAndInterestPayment(IEnumerable<CollateralInterestParameters> interestParameters)
        {
            InterestParameters = interestParameters;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<DistributionAndInterestPayment> MetaData => metaData;
        
        /// <summary>
        /// Represents the interest parameters for the various currencies, margin types, posting parties.
        /// </summary>
        public IEnumerable<CollateralInterestParameters> InterestParameters { get; }
    }
    
    /// <summary>
    /// The parameters which define whether dividends are applicable
    /// </summary>
    public class DividendApplicability : AbstractRosettaModelObject<DividendApplicability>
    {
        private static readonly IRosettaMetaData<DividendApplicability> metaData = new DividendApplicabilityMeta();
        
        [JsonConstructor]
        public DividendApplicability(bool? additionalDividends, bool? allDividends, bool? optionsExchangeDividends)
        {
            AdditionalDividends = additionalDividends;
            AllDividends = allDividends;
            OptionsExchangeDividends = optionsExchangeDividends;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<DividendApplicability> MetaData => metaData;
        
        /// <summary>
        /// If present and true, then additional dividends are applicable.
        /// </summary>
        public bool? AdditionalDividends { get; }
        
        /// <summary>
        /// Represents the European Master Confirmation value of &apos;All Dividends&apos; which, when applicable, signifies that, for a given Ex-Date, the daily observed Share Price for that day is adjusted (reduced) by the cash dividend and/or the cash value of any non cash dividend per Share (including Extraordinary Dividends) declared by the Issuer. All Dividends in accordance with the ISDA 2002 Equity Derivatives Definitions.
        /// </summary>
        public bool? AllDividends { get; }
        
        /// <summary>
        /// If present and true, then options exchange dividends are applicable.
        /// </summary>
        public bool? OptionsExchangeDividends { get; }
    }
    
    /// <summary>
    /// A class to specify the currency in which the dividends will be denominated, i.e. either in the dividend currency or in a currency specified as part of the contract.
    /// </summary>
    public class DividendCurrency : AbstractRosettaModelObject<DividendCurrency>
    {
        private static readonly IRosettaMetaData<DividendCurrency> metaData = new DividendCurrencyMeta();
        
        [JsonConstructor]
        public DividendCurrency(FieldWithMetaString? currency, BasicReferenceWithMetaString? currencyReference, Enums.DeterminationMethod? determinationMethod)
        {
            Currency = currency;
            CurrencyReference = currencyReference;
            DeterminationMethod = determinationMethod;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<DividendCurrency> MetaData => metaData;
        
        /// <summary>
        /// The currency in which the dividend is denominated. The list of valid currencies is not presently positioned as an enumeration as part of the CDM because that scope is limited to the values specified by ISDA and FpML. As a result, implementers have to make reference to the relevant standard, such as the ISO 4217 standard for currency codes.
        /// </summary>
        public FieldWithMetaString? Currency { get; }
        
        /// <summary>
        /// Reference to a currency specified elsewhere in the document
        /// </summary>
        public BasicReferenceWithMetaString? CurrencyReference { get; }
        
        /// <summary>
        /// Specifies the method according to which the dividend is determined, e.g. the dividend currency.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.DeterminationMethod? DeterminationMethod { get; }
    }
    
    /// <summary>
    /// A class to specify the dividend date by reference to another date, with the ability to apply and offset. This class doesn&apos;t exist in FpML and is meant to simplify the choice constraint associated with the DividendPaymentDate class.
    /// </summary>
    public class DividendDateReference : AbstractRosettaModelObject<DividendDateReference>
    {
        private static readonly IRosettaMetaData<DividendDateReference> metaData = new DividendDateReferenceMeta();
        
        [JsonConstructor]
        public DividendDateReference(Enums.DividendDateReference dateReference, Offset? paymentDateOffset)
        {
            DateReference = dateReference;
            PaymentDateOffset = paymentDateOffset;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<DividendDateReference> MetaData => metaData;
        
        /// <summary>
        /// Specification of the dividend date using an enumeration, with values such as the pay date, the ex-date or the record date.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.DividendDateReference DateReference { get; }
        
        /// <summary>
        /// Only to be used when SharePayment has been specified in the dividendDateReference element. The number of Currency Business Days following the day on which the Issuer of the Shares pays the relevant dividend to holders of record of the Shares.
        /// </summary>
        public Offset? PaymentDateOffset { get; }
    }
    
    /// <summary>
    /// A class describing the date on which the dividend will be paid/received. This class is also used to specify the date on which the FX rate will be determined, when applicable.
    /// </summary>
    public class DividendPaymentDate : AbstractRosettaModelObject<DividendPaymentDate>
    {
        private static readonly IRosettaMetaData<DividendPaymentDate> metaData = new DividendPaymentDateMeta();
        
        [JsonConstructor]
        public DividendPaymentDate(ReferenceWithMetaAdjustableOrRelativeDate? dividendDate, DividendDateReference? dividendDateReference)
        {
            DividendDate = dividendDate;
            DividendDateReference = dividendDateReference;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<DividendPaymentDate> MetaData => metaData;
        
        public ReferenceWithMetaAdjustableOrRelativeDate? DividendDate { get; }
        
        public DividendDateReference? DividendDateReference { get; }
    }
    
    /// <summary>
    /// A class describing the dividend payout ratio associated with an equity underlier. In certain cases the actual ratio is not known on trade inception, and only general conditions are then specified.
    /// </summary>
    public class DividendPayoutRatio : AbstractRosettaModelObject<DividendPayoutRatio>
    {
        private static readonly IRosettaMetaData<DividendPayoutRatio> metaData = new DividendPayoutRatioMeta();
        
        [JsonConstructor]
        public DividendPayoutRatio(Product? basketConstituent, decimal? cashRatio, decimal? nonCashRatio, decimal totalRatio)
        {
            BasketConstituent = basketConstituent;
            CashRatio = cashRatio;
            NonCashRatio = nonCashRatio;
            TotalRatio = totalRatio;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<DividendPayoutRatio> MetaData => metaData;
        
        /// <summary>
        /// In the case of a basket underlier, specifies to which component of the basket this particular set of dividend payout ratios correspond.
        /// </summary>
        public Product? BasketConstituent { get; }
        
        /// <summary>
        /// Specifies the cash actual dividend payout ratio associated with the equity underlier. A ratio of 90% should be expressed at 0.90.
        /// </summary>
        public decimal? CashRatio { get; }
        
        /// <summary>
        /// Specifies the non cash actual dividend payout ratio associated with the equity underlier. A ratio of 90% should be expressed at 0.90.
        /// </summary>
        public decimal? NonCashRatio { get; }
        
        /// <summary>
        /// Specifies the total actual dividend payout ratio associated with the equity underlier. A ratio of 90% should be expressed at 0.90.
        /// </summary>
        public decimal TotalRatio { get; }
    }
    
    /// <summary>
    /// Time bounded dividend payment periods, each with a dividend payment date per period.
    /// </summary>
    public class DividendPeriod : AbstractRosettaModelObject<DividendPeriod>
    {
        private static readonly IRosettaMetaData<DividendPeriod> metaData = new DividendPeriodMeta();
        
        [JsonConstructor]
        public DividendPeriod(Product? basketConstituent, BusinessDayAdjustments dateAdjustments, DividendPaymentDate dividendPaymentDate, AdjustableOrRelativeDate? dividendValuationDate, DividendPaymentDate? endDate, DividendPaymentDate? startDate)
        {
            BasketConstituent = basketConstituent;
            DateAdjustments = dateAdjustments;
            DividendPaymentDate = dividendPaymentDate;
            DividendValuationDate = dividendValuationDate;
            EndDate = endDate;
            StartDate = startDate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<DividendPeriod> MetaData => metaData;
        
        /// <summary>
        /// For basket undeliers, reference to the basket component which is paying dividends in the specified period.
        /// </summary>
        public Product? BasketConstituent { get; }
        
        /// <summary>
        /// Date adjustments for all unadjusted dates in this dividend period.
        /// </summary>
        public BusinessDayAdjustments DateAdjustments { get; }
        
        /// <summary>
        /// Specifies when the dividend will be paid to the receiver of the equity return. Has the meaning as defined in the ISDA 2002 Equity Derivatives Definitions. Is not applicable in the case of a dividend reinvestment election.
        /// </summary>
        public DividendPaymentDate DividendPaymentDate { get; }
        
        /// <summary>
        /// Specifies the dividend valuation dates of the swap.
        /// </summary>
        public AdjustableOrRelativeDate? DividendValuationDate { get; }
        
        /// <summary>
        /// Dividend period end date.
        /// </summary>
        public DividendPaymentDate? EndDate { get; }
        
        /// <summary>
        /// Dividend period start date.
        /// </summary>
        public DividendPaymentDate? StartDate { get; }
    }
    
    /// <summary>
    /// A class describing the conditions governing the payment of dividends to the receiver of the equity return, with the exception of the dividend payout ratio, which is defined for each of the underlying components.
    /// </summary>
    public class DividendReturnTerms : AbstractRosettaModelObject<DividendReturnTerms>
    {
        private static readonly IRosettaMetaData<DividendReturnTerms> metaData = new DividendReturnTermsMeta();
        
        [JsonConstructor]
        public DividendReturnTerms(Enums.DividendAmountType? dividendAmountType, Enums.DividendComposition? dividendComposition, DividendCurrency? dividendCurrency, Enums.DividendEntitlement? dividendEntitlement, IEnumerable<DividendPayoutRatio> dividendPayoutRatio, IEnumerable<DividendPeriod> dividendPeriod, bool? dividendReinvestment, Enums.DividendAmountType? excessDividendAmount, Enums.AncillaryRole? extraordinaryDividendsParty, Enums.DividendPeriod? firstOrSecondPeriod, bool? materialDividend, Enums.NonCashDividendTreatment? nonCashDividendTreatment, string? performance, bool? specialDividends)
        {
            DividendAmountType = dividendAmountType;
            DividendComposition = dividendComposition;
            DividendCurrency = dividendCurrency;
            DividendEntitlement = dividendEntitlement;
            DividendPayoutRatio = dividendPayoutRatio;
            DividendPeriod = dividendPeriod;
            DividendReinvestment = dividendReinvestment;
            ExcessDividendAmount = excessDividendAmount;
            ExtraordinaryDividendsParty = extraordinaryDividendsParty;
            FirstOrSecondPeriod = firstOrSecondPeriod;
            MaterialDividend = materialDividend;
            NonCashDividendTreatment = nonCashDividendTreatment;
            Performance = performance;
            SpecialDividends = specialDividends;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<DividendReturnTerms> MetaData => metaData;
        
        /// <summary>
        /// Specifies whether the dividend is paid with respect to the Dividend Period.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.DividendAmountType? DividendAmountType { get; }
        
        /// <summary>
        /// Specifies how the composition of Dividends is to be determined.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.DividendComposition? DividendComposition { get; }
        
        /// <summary>
        /// Specifies the currency in which the dividend will be denominated, e.g. the dividend currency, or a specified currency. This class is not specified as such in FpML, which makes use of the CurrencyAndDeterminationMethod.model to specify such terms.
        /// </summary>
        public DividendCurrency? DividendCurrency { get; }
        
        /// <summary>
        /// Defines the date on which the receiver of the equity return is entitled to the dividend.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.DividendEntitlement? DividendEntitlement { get; }
        
        /// <summary>
        /// Specifies the dividend payout ratio associated with each underlier. In FpML 5.10 the payout is positioned at the underlier level, although there is an intent to reconsider this approach and position it at the leg level. This is approach adopted by the CDM.
        /// </summary>
        public IEnumerable<DividendPayoutRatio> DividendPayoutRatio { get; }
        
        /// <summary>
        /// One to many time bounded dividend payment periods, each with a dividend payment date per period.
        /// </summary>
        public IEnumerable<DividendPeriod> DividendPeriod { get; }
        
        /// <summary>
        /// Boolean element that defines whether the dividend will be reinvested or not.
        /// </summary>
        public bool? DividendReinvestment { get; }
        
        /// <summary>
        /// Determination of Gross Cash Dividend per Share.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.DividendAmountType? ExcessDividendAmount { get; }
        
        /// <summary>
        /// Specifies the party which determines if dividends are extraordinary in relation to normal levels.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.AncillaryRole? ExtraordinaryDividendsParty { get; }
        
        /// <summary>
        /// 2002 ISDA Equity Derivatives Definitions: Dividend Period as either the First Period or the Second Period. | 
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.DividendPeriod? FirstOrSecondPeriod { get; }
        
        /// <summary>
        /// If present and true, then material non cash dividends are applicable.
        /// </summary>
        public bool? MaterialDividend { get; }
        
        /// <summary>
        /// Specifies the treatment of Non-Cash Dividends.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.NonCashDividendTreatment? NonCashDividendTreatment { get; }
        
        /// <summary>
        /// Performance calculation, in accordance with Part 1 Section 12 of the 2018 ISDA CDM Equity Confirmation for Security Equity Swap, Para 75. &apos;Equity Performance&apos;. Cumulative performance is used as a notional multiplier factor on both legs of an Equity Swap.
        /// </summary>
        public string? Performance { get; }
        
        /// <summary>
        /// Specifies the method according to which special dividends are determined.
        /// </summary>
        public bool? SpecialDividends { get; }
    }
    
    /// <summary>
    /// Information related to dividends and payments.
    /// </summary>
    public class DividendTerms : AbstractRosettaModelObject<DividendTerms>
    {
        private static readonly IRosettaMetaData<DividendTerms> metaData = new DividendTermsMeta();
        
        [JsonConstructor]
        public DividendTerms(Enums.DividendEntitlement? dividendEntitlement, DividendPayoutRatio manufacturedIncomeRequirement, Money? minimumBillingAmount)
        {
            DividendEntitlement = dividendEntitlement;
            ManufacturedIncomeRequirement = manufacturedIncomeRequirement;
            MinimumBillingAmount = minimumBillingAmount;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<DividendTerms> MetaData => metaData;
        
        /// <summary>
        /// Defines the date on which the receiver of the equity return is entitled to the dividend.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.DividendEntitlement? DividendEntitlement { get; }
        
        /// <summary>
        /// Specifies the proportion of the value of the dividend on the borrowed shares that the borrower is legally obligated to return to the lender.
        /// </summary>
        public DividendPayoutRatio ManufacturedIncomeRequirement { get; }
        
        /// <summary>
        /// daily fee increments accrue until a threshold is crossed, at which point payment becomes due)
        /// </summary>
        public Money? MinimumBillingAmount { get; }
    }
    
    public class Document : AbstractRosettaModelObject<Document>
    {
        private static readonly IRosettaMetaData<Document> metaData = new DocumentMeta();
        
        [JsonConstructor]
        public Document(FinInstrmRptgTxRpt finInstrmRptgTxRpt)
        {
            FinInstrmRptgTxRpt = finInstrmRptgTxRpt;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Document> MetaData => metaData;
        
        public FinInstrmRptgTxRpt FinInstrmRptgTxRpt { get; }
    }
    
    /// <summary>
    /// Specifies the Duration Terms of the Security Financing Transaction, and optionally any Evergreen terms.
    /// </summary>
    public class Duration : AbstractRosettaModelObject<Duration>
    {
        private static readonly IRosettaMetaData<Duration> metaData = new DurationMeta();
        
        [JsonConstructor]
        public Duration(Enums.DurationType durationType, EvergreenProvision? evergreenProvision)
        {
            DurationType = durationType;
            EvergreenProvision = evergreenProvision;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Duration> MetaData => metaData;
        
        /// <summary>
        /// Specifies the Duration Terms of the Security Financing transaction. e.g. Open or Term.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.DurationType DurationType { get; }
        
        /// <summary>
        /// A data defining: the right of a party to exercise an Evergreen option
        /// </summary>
        public EvergreenProvision? EvergreenProvision { get; }
    }
    
    /// <summary>
    /// A data to:  define the adjusted dates associated with an early termination provision.
    /// </summary>
    public class EarlyTerminationEvent : AbstractRosettaModelObject<EarlyTerminationEvent>
    {
        private static readonly IRosettaMetaData<EarlyTerminationEvent> metaData = new EarlyTerminationEventMeta();
        
        [JsonConstructor]
        public EarlyTerminationEvent(LocalDate adjustedCashSettlementPaymentDate, LocalDate adjustedCashSettlementValuationDate, LocalDate adjustedEarlyTerminationDate, LocalDate adjustedExerciseDate, LocalDate? adjustedExerciseFeePaymentDate, _MetaFields? meta)
        {
            AdjustedCashSettlementPaymentDate = adjustedCashSettlementPaymentDate;
            AdjustedCashSettlementValuationDate = adjustedCashSettlementValuationDate;
            AdjustedEarlyTerminationDate = adjustedEarlyTerminationDate;
            AdjustedExerciseDate = adjustedExerciseDate;
            AdjustedExerciseFeePaymentDate = adjustedExerciseFeePaymentDate;
            Meta = meta;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<EarlyTerminationEvent> MetaData => metaData;
        
        /// <summary>
        /// The date on which the cash settlement amount is paid. This date should already be adjusted for any applicable business date convention.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate AdjustedCashSettlementPaymentDate { get; }
        
        /// <summary>
        /// The date by which the cash settlement amount must be agreed. This date should already be adjusted for any applicable business day convention.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate AdjustedCashSettlementValuationDate { get; }
        
        /// <summary>
        /// The early termination date that is applicable if an early termination provision is exercised. This date should already be adjusted for any applicable business day convention.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate AdjustedEarlyTerminationDate { get; }
        
        /// <summary>
        /// The date on which option exercise takes place. This date should already be adjusted for any applicable business day convention.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate AdjustedExerciseDate { get; }
        
        /// <summary>
        /// The date on which the exercise fee amount is paid. This date should already be adjusted for any applicable business day convention.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? AdjustedExerciseFeePaymentDate { get; }
        
        public _MetaFields? Meta { get; }
    }
    
    /// <summary>
    /// A data defining:  an early termination provision for a swap. This early termination is at fair value, i.e. on termination the fair value of the product must be settled between the parties.
    /// </summary>
    public class EarlyTerminationProvision : AbstractRosettaModelObject<EarlyTerminationProvision>
    {
        private static readonly IRosettaMetaData<EarlyTerminationProvision> metaData = new EarlyTerminationProvisionMeta();
        
        [JsonConstructor]
        public EarlyTerminationProvision(MandatoryEarlyTermination? mandatoryEarlyTermination, Period? mandatoryEarlyTerminationDateTenor, _MetaFields? meta, OptionalEarlyTermination? optionalEarlyTermination, ExercisePeriod? optionalEarlyTerminationParameters)
        {
            MandatoryEarlyTermination = mandatoryEarlyTermination;
            MandatoryEarlyTerminationDateTenor = mandatoryEarlyTerminationDateTenor;
            Meta = meta;
            OptionalEarlyTermination = optionalEarlyTermination;
            OptionalEarlyTerminationParameters = optionalEarlyTerminationParameters;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<EarlyTerminationProvision> MetaData => metaData;
        
        /// <summary>
        /// A mandatory early termination provision to terminate the swap at fair value.
        /// </summary>
        public MandatoryEarlyTermination? MandatoryEarlyTermination { get; }
        
        /// <summary>
        /// Period after trade date of the mandatory early termination date.
        /// </summary>
        public Period? MandatoryEarlyTerminationDateTenor { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <summary>
        /// An option for either or both parties to terminate the swap at fair value.
        /// </summary>
        public OptionalEarlyTermination? OptionalEarlyTermination { get; }
        
        /// <summary>
        /// Definition of the first early termination date and the frequency of the termination dates subsequent to that. American exercise is defined by having a frequency of one day.
        /// </summary>
        public ExercisePeriod? OptionalEarlyTerminationParameters { get; }
    }
    
    /// <summary>
    ///  This class represents the full set of price-forming features associated with a contractual product: the payout component, the notional/quantity, the effective and termination date and the date adjustment provisions when applying uniformily across the payout components. This class also includes the legal provisions which have valuation implications: cancelable provision, extendible provision, early termination provision and extraordinary events specification.
    /// </summary>
    public class EconomicTerms : AbstractRosettaModelObject<EconomicTerms>
    {
        private static readonly IRosettaMetaData<EconomicTerms> metaData = new EconomicTermsMeta();
        
        [JsonConstructor]
        public EconomicTerms(CalculationAgent? calculationAgent, Collateral? collateral, BusinessDayAdjustments? dateAdjustments, AdjustableOrRelativeDate? effectiveDate, ExtraordinaryEvents? extraordinaryEvents, bool? nonStandardisedTerms, Payout payout, AdjustableOrRelativeDate? terminationDate, TerminationProvision? terminationProvision)
        {
            CalculationAgent = calculationAgent;
            Collateral = collateral;
            DateAdjustments = dateAdjustments;
            EffectiveDate = effectiveDate;
            ExtraordinaryEvents = extraordinaryEvents;
            NonStandardisedTerms = nonStandardisedTerms;
            Payout = payout;
            TerminationDate = terminationDate;
            TerminationProvision = terminationProvision;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<EconomicTerms> MetaData => metaData;
        
        /// <summary>
        /// The ISDA calculation agent responsible for performing duties as defined in the applicable product definitions.
        /// </summary>
        public CalculationAgent? CalculationAgent { get; }
        
        /// <summary>
        /// Represents the collateral obligations of a party.
        /// </summary>
        public Collateral? Collateral { get; }
        
        /// <summary>
        /// The business day adjustment convention when it applies across all the payout components. This specification of the business day convention and financial business centers is used for adjusting any calculation period date if it would otherwise fall on a day that is not a business day in the specified business center.
        /// </summary>
        public BusinessDayAdjustments? DateAdjustments { get; }
        
        /// <summary>
        /// The first day of the terms of the trade. This day may be subject to adjustment in accordance with a business day convention.
        /// </summary>
        public AdjustableOrRelativeDate? EffectiveDate { get; }
        
        /// <summary>
        /// 2018 ISDA CDM Equity Confirmation for Security Equity Swap: Extraordinary Events.
        /// </summary>
        public ExtraordinaryEvents? ExtraordinaryEvents { get; }
        
        /// <summary>
        /// Specifies, when boolean value is True, that additional economic terms exist that have not been included in the product representation.
        /// </summary>
        public bool? NonStandardisedTerms { get; }
        
        /// <summary>
        /// The payout specifies the future cashflow computation methodology which characterizes a financial product.
        /// </summary>
        public Payout Payout { get; }
        
        /// <summary>
        /// The last day of the terms of the trade. This date may be subject to adjustments in accordance with the business day convention. It can also be specified in relation to another scheduled date (e.g. the last payment date).
        /// </summary>
        public AdjustableOrRelativeDate? TerminationDate { get; }
        
        /// <summary>
        /// Contains optional provisions pertaining to the termination characteristics of a contract.
        /// </summary>
        public TerminationProvision? TerminationProvision { get; }
    }
    
    /// <summary>
    /// Represents a set of criteria used to specify eligible collateral.
    /// </summary>
    public class EligibleCollateralCriteria : AbstractRosettaModelObject<EligibleCollateralCriteria>, ICollateralCriteriaBase
    {
        private static readonly IRosettaMetaData<EligibleCollateralCriteria> metaData = new EligibleCollateralCriteriaMeta();
        
        [JsonConstructor]
        public EligibleCollateralCriteria(CollateralTreatment treatment, IEnumerable<AssetCriteria> asset, IEnumerable<IssuerCriteria> issuer)
        {
            Treatment = treatment;
            Asset = asset;
            Issuer = issuer;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<EligibleCollateralCriteria> MetaData => metaData;
        
        /// <summary>
        /// Identifies the treatment of specified collateral, e.g., haircuts,holding limits or exclusions.
        /// </summary>
        public CollateralTreatment Treatment { get; }
        
        /// <inheritdoc/>
        public IEnumerable<AssetCriteria> Asset { get; }
        
        /// <inheritdoc/>
        public IEnumerable<IssuerCriteria> Issuer { get; }
    }
    
    /// <summary>
    /// Represents a set of criteria used to specify eligible collateral.
    /// </summary>
    public class EligibleCollateralSpecification : AbstractRosettaModelObject<EligibleCollateralSpecification>
    {
        private static readonly IRosettaMetaData<EligibleCollateralSpecification> metaData = new EligibleCollateralSpecificationMeta();
        
        [JsonConstructor]
        public EligibleCollateralSpecification(IEnumerable<EligibleCollateralCriteria> criteria, IEnumerable<Identifier> identifier, _MetaFields? meta)
        {
            Criteria = criteria;
            Identifier = identifier;
            Meta = meta;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<EligibleCollateralSpecification> MetaData => metaData;
        
        /// <summary>
        /// Represents a set of criteria used to specify eligible collateral.
        /// </summary>
        public IEnumerable<EligibleCollateralCriteria> Criteria { get; }
        
        /// <summary>
        /// Specifies the identifier(s) to uniquely identify eligible collateral or a set of eligible collateral, such as a schedule or equivalant for an identity issuer.
        /// </summary>
        public IEnumerable<Identifier> Identifier { get; }
        
        public _MetaFields? Meta { get; }
    }
    
    public class EligibleCollateralSpecificationInstruction : AbstractRosettaModelObject<EligibleCollateralSpecificationInstruction>
    {
        private static readonly IRosettaMetaData<EligibleCollateralSpecificationInstruction> metaData = new EligibleCollateralSpecificationInstructionMeta();
        
        [JsonConstructor]
        public EligibleCollateralSpecificationInstruction(EligibleCollateralCriteria common, IEnumerable<EligibleCollateralCriteria> variable)
        {
            Common = common;
            Variable = variable;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<EligibleCollateralSpecificationInstruction> MetaData => metaData;
        
        public EligibleCollateralCriteria Common { get; }
        
        public IEnumerable<EligibleCollateralCriteria> Variable { get; }
    }
    
    /// <summary>
    /// A class to specify an equity as having a product identifier. As a difference versus the FpML standard, the CDM structure of this class only includes the productIdentifier class, which consists of an identifier, productTaxonomy, and source of the identifier. The reason for this approach is to avoid the potential for conflicting information between the information associated with the contractual product and the reference information maintained by the relevant service provider.
    /// </summary>
    public class Equity : AbstractRosettaModelObject<Equity>, IIdentifiedProduct
    {
        private static readonly IRosettaMetaData<Equity> metaData = new EquityMeta();
        
        [JsonConstructor]
        public Equity(ProductIdentifier productIdentifier)
        {
            ProductIdentifier = productIdentifier;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Equity> MetaData => metaData;
        
        public ProductIdentifier ProductIdentifier { get; }
    }
    
    /// <summary>
    /// A class for defining the merger events and their treatment.
    /// </summary>
    public class EquityCorporateEvents : AbstractRosettaModelObject<EquityCorporateEvents>
    {
        private static readonly IRosettaMetaData<EquityCorporateEvents> metaData = new EquityCorporateEventsMeta();
        
        [JsonConstructor]
        public EquityCorporateEvents(Enums.ShareExtraordinaryEvent shareForCombined, Enums.ShareExtraordinaryEvent shareForOther, Enums.ShareExtraordinaryEvent shareForShare)
        {
            ShareForCombined = shareForCombined;
            ShareForOther = shareForOther;
            ShareForShare = shareForShare;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<EquityCorporateEvents> MetaData => metaData;
        
        /// <summary>
        /// 2018 ISDA CDM Equity Confirmation for Security Equity Swap: Merger Event (S-F-C) shall occur if a Merger Event occurs and the consideration for the relevant Security consists solely of Combined Consideration. | The consideration paid for the original shares following the Merger Event consists of both cash/securities and new shares.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.ShareExtraordinaryEvent ShareForCombined { get; }
        
        /// <summary>
        /// 2018 ISDA CDM Equity Confirmation for Security Equity Swap: Merger Event (S-F-O) shall occur if a Merger Event occurs and the consideration for the relevant Security consists solely of Other Consideration. | The consideration paid for the original shares following the Merger Event consists wholly of cash/securities other than new shares.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.ShareExtraordinaryEvent ShareForOther { get; }
        
        /// <summary>
        /// 2018 ISDA CDM Equity Confirmation for Security Equity Swap: Merger Event (S-F-S) shall occur if a Merger Event occurs and the consideration for the relevant Security consists solely of Combined Consideration. | The consideration paid for the original shares following the Merger Event consists wholly of new shares.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.ShareExtraordinaryEvent ShareForShare { get; }
    }
    
    /// <summary>
    /// Specification for General Terms and Elections of an Equity Master Confirmation that is applicable across multiple Equity confirmations and is referenced by each of these confirmations, an example of which being the 2018 ISDA CDM Equity Confirmation for Security Equity Swap.
    /// </summary>
    public class EquityMasterConfirmation : AbstractRosettaModelObject<EquityMasterConfirmation>, IEquityMasterConfirmation, IMasterConfirmationBase
    {
        private static readonly IRosettaMetaData<EquityMasterConfirmation> metaData = new EquityMasterConfirmationMeta();
        
        [JsonConstructor]
        public EquityMasterConfirmation()
        {
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<EquityMasterConfirmation> MetaData => metaData;
        
    }
    
    /// <summary>
    /// Specification for the General Terms and Relationship Supplement Elections as provided in the 2018 ISDA CDM Equity Confirmation for Security Equity Swap.
    /// </summary>
    public class EquitySwapMasterConfirmation2018 : AbstractRosettaModelObject<EquitySwapMasterConfirmation2018>, IEquityMasterConfirmation
    {
        private static readonly IRosettaMetaData<EquitySwapMasterConfirmation2018> metaData = new EquitySwapMasterConfirmation2018Meta();
        
        [JsonConstructor]
        public EquitySwapMasterConfirmation2018(PaymentDates equityCashSettlementDates, Enums.InterpolationMethod linearInterpolationElection, PriceReturnTerms pricingMethodElection, SettlementTerms settlementTerms, Enums.ReturnType typeOfSwapElection, ValuationDates valuationDates)
        {
            EquityCashSettlementDates = equityCashSettlementDates;
            LinearInterpolationElection = linearInterpolationElection;
            PricingMethodElection = pricingMethodElection;
            SettlementTerms = settlementTerms;
            TypeOfSwapElection = typeOfSwapElection;
            ValuationDates = valuationDates;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<EquitySwapMasterConfirmation2018> MetaData => metaData;
        
        /// <summary>
        /// The parameters used to generate the payment date schedule, relative to the equityCalculationPeriod. Part 1 Section 12, &apos;Definitions&apos;, of the 2018 ISDA CDM Equity Confirmation. Para 73: &apos;Equity Cash Settlement Date&apos; means each date falling one Settlement Cycle after an Equity Valuation Date; provided that if any such date is not a Settlement Currency Business Day, then such date shall be adjusted per Following Day Adjustment.
        /// </summary>
        public PaymentDates EquityCashSettlementDates { get; }
        
        /// <summary>
        /// Part 1 Section 3, &apos;Floating Obligations&apos;, of the 2018 ISDA CDM Equity Confirmation. Para 3.3, &apos;Linear Interpolation&apos;: If the initial Calculation Period is not equal to the Designated Maturity, then the Linear Interpolation Election shall be as specified in the Relationship Supplement, unless otherwise specified in the Transaction Supplement.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.InterpolationMethod LinearInterpolationElection { get; }
        
        /// <summary>
        /// Part 1 Section 5, &apos;Pricing&apos;, of the 2018 ISDA CDM Equity Confirmation, Para 5.1, &apos;Determining Prices&apos;: Each price in relation to a Pricing Date shall be determined pursuant to the specified Pricing Method. The relevant price specified under the column header &apos;Price&apos; for a corresponding Pricing Date specified under the column header &apos;Pricing Date&apos; shall be determined using the corresponding method specified under the column header &apos;Pricing Method&apos;. Pricing Method for the final Equity Valuation Date shall be specified by the Final EVD Pricing Election and Pricing Method for any other Equity Valuation Date shall be &apos;Securities Close Pricing (Official)&apos;
        /// </summary>
        public PriceReturnTerms PricingMethodElection { get; }
        
        /// <summary>
        /// Part 1 Section 8, &apos;Settlement&apos;, of the 2018 ISDA CDM Equity Confirmation for Security Equity Swap. All Settlements are in Cash.
        /// </summary>
        public SettlementTerms SettlementTerms { get; }
        
        /// <summary>
        /// Part 1 Section 4, &apos;Dividend Obligations&apos;, of the 2018 ISDA CDM Equity Confirmation, Para 4.2 &apos;Dividend Returns&apos;: The Type Of Swap Election shall be &apos;Total Return&apos;, unless otherwise specified (as alternative &apos;Price Return&apos;) in the Transaction Supplement.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.ReturnType TypeOfSwapElection { get; }
        
        /// <summary>
        /// The parameters used to generate the &apos;Equity Valuation Dates&apos; schedule, including the Effective Date and Termination Date for the Swap.
        /// </summary>
        public ValuationDates ValuationDates { get; }
    }
    
    public class EquityUnderlierProvisions : AbstractRosettaModelObject<EquityUnderlierProvisions>
    {
        private static readonly IRosettaMetaData<EquityUnderlierProvisions> metaData = new EquityUnderlierProvisionsMeta();
        
        [JsonConstructor]
        public EquityUnderlierProvisions(bool? componentSecurityIndexAnnexFallback, FieldWithMetaString? localJurisdiction, bool? multipleExchangeIndexAnnexFallback, FieldWithMetaString? relevantJurisdiction)
        {
            ComponentSecurityIndexAnnexFallback = componentSecurityIndexAnnexFallback;
            LocalJurisdiction = localJurisdiction;
            MultipleExchangeIndexAnnexFallback = multipleExchangeIndexAnnexFallback;
            RelevantJurisdiction = relevantJurisdiction;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<EquityUnderlierProvisions> MetaData => metaData;
        
        /// <summary>
        /// For an index option or swap transaction, a flag to indicate whether a relevant Component Security Index Annex is applicable to the transaction.
        /// </summary>
        public bool? ComponentSecurityIndexAnnexFallback { get; }
        
        /// <summary>
        /// The ISO 3166 standard code for the country within which the postal address is located.
        /// </summary>
        public FieldWithMetaString? LocalJurisdiction { get; }
        
        /// <summary>
        /// For an index option or swap transaction, a flag to indicate whether a relevant Multiple Exchange Index Annex is applicable to the transaction. This annex defines additional provisions which are applicable where an index is comprised of component securities that are traded on multiple exchanges.
        /// </summary>
        public bool? MultipleExchangeIndexAnnexFallback { get; }
        
        /// <summary>
        /// The ISO 3166 standard code for the country within which the postal address is located.
        /// </summary>
        public FieldWithMetaString? RelevantJurisdiction { get; }
    }
    
    /// <summary>
    /// A class defining the exercise period for a European style option together with any rules governing the notional amount of the underlying which can be exercised on any given exercise date and any associated exercise fees.
    /// </summary>
    public class EuropeanExercise : AbstractRosettaModelObject<EuropeanExercise>
    {
        private static readonly IRosettaMetaData<EuropeanExercise> metaData = new EuropeanExerciseMeta();
        
        [JsonConstructor]
        public EuropeanExercise(BusinessCenterTime? earliestExerciseTime, ExerciseFee? exerciseFee, IEnumerable<AdjustableOrRelativeDate> expirationDate, BusinessCenterTime expirationTime, Enums.ExpirationTimeType? expirationTimeType, _MetaFields? meta, PartialExercise? partialExercise, AdjustableOrRelativeDates? relevantUnderlyingDate)
        {
            EarliestExerciseTime = earliestExerciseTime;
            ExerciseFee = exerciseFee;
            ExpirationDate = expirationDate;
            ExpirationTime = expirationTime;
            ExpirationTimeType = expirationTimeType;
            Meta = meta;
            PartialExercise = partialExercise;
            RelevantUnderlyingDate = relevantUnderlyingDate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<EuropeanExercise> MetaData => metaData;
        
        /// <summary>
        /// The earliest time at which notice of exercise can be given by the buyer to the seller (or seller&apos;s agent) on the expiration date.
        /// </summary>
        public BusinessCenterTime? EarliestExerciseTime { get; }
        
        /// <summary>
        /// A fee to be paid on exercise. This could be represented as an amount or a rate and notional reference on which to apply the rate.
        /// </summary>
        public ExerciseFee? ExerciseFee { get; }
        
        /// <summary>
        /// The last day within an exercise period for an American style option. For a European style option it is the only day within the exercise period.
        /// </summary>
        public IEnumerable<AdjustableOrRelativeDate> ExpirationDate { get; }
        
        /// <summary>
        /// The latest time for exercise on expirationDate.
        /// </summary>
        public BusinessCenterTime ExpirationTime { get; }
        
        /// <summary>
        /// The time of day at which the equity option expires, for example the official closing time of the exchange.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.ExpirationTimeType? ExpirationTimeType { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <summary>
        /// As defined in the 2000 ISDA Definitions, Section 12.3. Partial Exercise, the buyer of the option has the right to exercise all or less than all the notional amount of the underlying swap on the expiration date, but may not exercise less than the minimum notional amount, and if an integral multiple amount is specified, the notional amount exercised must be equal to, or be an integral multiple of, the integral multiple amount.
        /// </summary>
        public PartialExercise? PartialExercise { get; }
        
        /// <summary>
        /// The effective date on the underlying product if the option is exercised.  For example, for a swaption it is the swap effective date, for an option on an FX spot or forward it is the value date for settlement, and in an extendible/cancelable provision it is the swap termination date, which is the date on which the termination is effective.
        /// </summary>
        public AdjustableOrRelativeDates? RelevantUnderlyingDate { get; }
    }
    
    /// <summary>
    /// Specifies instructions to create a BusinessEvent.
    /// </summary>
    public class EventInstruction : AbstractRosettaModelObject<EventInstruction>, IEventInstruction
    {
        private static readonly IRosettaMetaData<EventInstruction> metaData = new EventInstructionMeta();
        
        [JsonConstructor]
        public EventInstruction(Enums.CorporateActionType? corporateActionIntent, LocalDate? effectiveDate, LocalDate? eventDate, IEnumerable<Instruction> instruction, Enums.EventIntent? intent, IdentifiedList? packageInformation)
        {
            CorporateActionIntent = corporateActionIntent;
            EffectiveDate = effectiveDate;
            EventDate = eventDate;
            Instruction = instruction;
            Intent = intent;
            PackageInformation = packageInformation;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<EventInstruction> MetaData => metaData;
        
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CorporateActionType? CorporateActionIntent { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? EffectiveDate { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? EventDate { get; }
        
        /// <inheritdoc/>
        public IEnumerable<Instruction> Instruction { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.EventIntent? Intent { get; }
        
        /// <inheritdoc/>
        public IdentifiedList? PackageInformation { get; }
    }
    
    /// <summary>
    /// A class to represent the various set of timestamps that can be associated with lifecycle events, as a collection of [dateTime, qualifier].
    /// </summary>
    public class EventTimestamp : AbstractRosettaModelObject<EventTimestamp>
    {
        private static readonly IRosettaMetaData<EventTimestamp> metaData = new EventTimestampMeta();
        
        [JsonConstructor]
        public EventTimestamp(ZonedDateTime dateTime, Enums.EventTimestampQualification qualification)
        {
            DateTime = dateTime;
            Qualification = qualification;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<EventTimestamp> MetaData => metaData;
        
        /// <summary>
        /// The CDM specifies that the zoned date time is to be expressed in accordance with ISO 8601, either as UTC as an offset to UTC.
        /// </summary>
        public ZonedDateTime DateTime { get; }
        
        /// <summary>
        /// The timestamp qualifier is specified through an enumeration because the experience of integrating the DTCC and CME data representations suggests that a wide set of timestamps are currently utilized among service providers, while there is not at present an objective set of criteria that could help suggest a defined set of timestamps as part of the CDM. At some future point, one possible baseline could be developed from the review of the set of timestamps specified across regulatory regimes and regulations (incl. regulations such as high frequency trading). Also, the integration with a further set of implementations and the specification of business workflows such as clearing as part of the CDM development should help confirm the implementation approach in this respect.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.EventTimestampQualification Qualification { get; }
    }
    
    /// <summary>
    /// Specifies a transaction which automatically extends for a specified timeframe until the exercise of an embedded option.
    /// </summary>
    public class EvergreenProvision : AbstractRosettaModelObject<EvergreenProvision>
    {
        private static readonly IRosettaMetaData<EvergreenProvision> metaData = new EvergreenProvisionMeta();
        
        [JsonConstructor]
        public EvergreenProvision(AdjustableRelativeOrPeriodicDates extensionFrequency, Price? finalPeriodFeeAdjustment, ZonedDateTime? noticeDeadlineDateTime, RelativeDateOffset? noticeDeadlinePeriod, RelativeDateOffset noticePeriod, PartyRole? singlePartyOption)
        {
            ExtensionFrequency = extensionFrequency;
            FinalPeriodFeeAdjustment = finalPeriodFeeAdjustment;
            NoticeDeadlineDateTime = noticeDeadlineDateTime;
            NoticeDeadlinePeriod = noticeDeadlinePeriod;
            NoticePeriod = noticePeriod;
            SinglePartyOption = singlePartyOption;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<EvergreenProvision> MetaData => metaData;
        
        /// <summary>
        /// The frequency with which the evergreen contract will be extended if notice is not given.
        /// </summary>
        public AdjustableRelativeOrPeriodicDates ExtensionFrequency { get; }
        
        /// <summary>
        /// An optional adjustment to the rate for the last period of the evergreen i.e. the period from when notice is given to stop rolling the contract through to the termination date.
        /// </summary>
        public Price? FinalPeriodFeeAdjustment { get; }
        
        /// <summary>
        /// A specific date and time for the notice deadline
        /// </summary>
        public ZonedDateTime? NoticeDeadlineDateTime { get; }
        
        /// <summary>
        /// Defines the minimum period before an evergreen is scheduled to terminate that notice can be given that it will terminate beyond the scheduled termination date.
        /// </summary>
        public RelativeDateOffset? NoticeDeadlinePeriod { get; }
        
        /// <summary>
        /// The length of each evergreen extension period relative to the effective date of the preceding contract.
        /// </summary>
        public RelativeDateOffset NoticePeriod { get; }
        
        /// <summary>
        /// If evergreen termination is not available to both parties then this component specifies the buyer and seller of the option.
        /// </summary>
        public PartyRole? SinglePartyOption { get; }
    }
    
    /// <summary>
    /// A class that is used for describing the exchange rate for a particular transaction.
    /// </summary>
    public class ExchangeRate : AbstractRosettaModelObject<ExchangeRate>
    {
        private static readonly IRosettaMetaData<ExchangeRate> metaData = new ExchangeRateMeta();
        
        [JsonConstructor]
        public ExchangeRate(IEnumerable<CrossRate> crossRate)
        {
            CrossRate = crossRate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ExchangeRate> MetaData => metaData;
        
        /// <summary>
        /// An optional element that allow for definition of the currency exchange rates used to cross between the traded currencies for non-base currency FX contracts.
        /// </summary>
        public IEnumerable<CrossRate> CrossRate { get; }
    }
    
    public class ExctgPrsn : AbstractRosettaModelObject<ExctgPrsn>
    {
        private static readonly IRosettaMetaData<ExctgPrsn> metaData = new ExctgPrsnMeta();
        
        [JsonConstructor]
        public ExctgPrsn(Prsn prsn)
        {
            Prsn = prsn;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ExctgPrsn> MetaData => metaData;
        
        public Prsn Prsn { get; }
    }
    
    /// <summary>
    /// Defines specific attributes that relate to trade executions.
    /// </summary>
    public class ExecutionDetails : AbstractRosettaModelObject<ExecutionDetails>
    {
        private static readonly IRosettaMetaData<ExecutionDetails> metaData = new ExecutionDetailsMeta();
        
        [JsonConstructor]
        public ExecutionDetails(Enums.ExecutionType executionType, LegalEntity? executionVenue, _MetaFields? meta, IdentifiedList? packageReference)
        {
            ExecutionType = executionType;
            ExecutionVenue = executionVenue;
            Meta = meta;
            PackageReference = packageReference;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ExecutionDetails> MetaData => metaData;
        
        /// <summary>
        /// Identifies the type of execution, e.g. via voice, electronically...
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.ExecutionType ExecutionType { get; }
        
        /// <summary>
        /// Represents the venue on which a trade was executed.
        /// </summary>
        public LegalEntity? ExecutionVenue { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <summary>
        /// A reference to the package linking the trade with other trades, in case the trade was executed as part of a package (hence this attribute is optional).
        /// </summary>
        public IdentifiedList? PackageReference { get; }
    }
    
    /// <summary>
    /// Specifies instructions for execution of a transaction, consisting of a product, price, quantity, parties, trade identifier, execution details, and settlement terms.
    /// </summary>
    public class ExecutionInstruction : AbstractRosettaModelObject<ExecutionInstruction>
    {
        private static readonly IRosettaMetaData<ExecutionInstruction> metaData = new ExecutionInstructionMeta();
        
        [JsonConstructor]
        public ExecutionInstruction(IEnumerable<AncillaryParty> ancillaryParty, Collateral? collateral, IEnumerable<Counterparty> counterparty, ExecutionDetails executionDetails, IEnumerable<Party> parties, IEnumerable<PartyRole> partyRoles, IEnumerable<PriceQuantity> priceQuantity, Product product, FieldWithMetaLocalDate tradeDate, IEnumerable<TradeIdentifier> tradeIdentifier)
        {
            AncillaryParty = ancillaryParty;
            Collateral = collateral;
            Counterparty = counterparty;
            ExecutionDetails = executionDetails;
            Parties = parties;
            PartyRoles = partyRoles;
            PriceQuantity = priceQuantity;
            Product = product;
            TradeDate = tradeDate;
            TradeIdentifier = tradeIdentifier;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ExecutionInstruction> MetaData => metaData;
        
        /// <summary>
        /// Maps any ancillary parties, e.g. parties involved in the transaction that are not one of the two principal parties.
        /// </summary>
        public IEnumerable<AncillaryParty> AncillaryParty { get; }
        
        /// <summary>
        /// Detail the collateral requirement anticipated with the transaction.
        /// </summary>
        public Collateral? Collateral { get; }
        
        /// <summary>
        /// Maps two defined parties to counterparty enums for the transacted product.
        /// </summary>
        public IEnumerable<Counterparty> Counterparty { get; }
        
        /// <summary>
        /// Specifies the type and venue of execution, e.g. via voice, or electronically.
        /// </summary>
        public ExecutionDetails ExecutionDetails { get; }
        
        /// <summary>
        /// Defines all parties to that execution, including agents and brokers.
        /// </summary>
        public IEnumerable<Party> Parties { get; }
        
        /// <summary>
        /// Defines the role(s) that party(ies) may have in relation to the execution.
        /// </summary>
        public IEnumerable<PartyRole> PartyRoles { get; }
        
        /// <summary>
        /// Defines the prices (e.g. spread, equity price, FX rate), quantities (e.g. currency amount, no. shares) and settlement terms (e.g. initial fee, broker fee, up-front cds payment or option premium settlement) associated with the constituents of the transacted product.
        /// </summary>
        public IEnumerable<PriceQuantity> PriceQuantity { get; }
        
        /// <summary>
        /// Defines the financial product to be executed and contract formed.
        /// </summary>
        public Product Product { get; }
        
        /// <summary>
        /// Denotes the trade/execution date.
        /// </summary>
        public FieldWithMetaLocalDate TradeDate { get; }
        
        /// <summary>
        /// Denotes one or more identifiers associated with the transaction.
        /// </summary>
        public IEnumerable<TradeIdentifier> TradeIdentifier { get; }
    }
    
    /// <summary>
    /// A data defining:  the adjusted dates associated with a particular exercise event.
    /// </summary>
    public class ExerciseEvent : AbstractRosettaModelObject<ExerciseEvent>
    {
        private static readonly IRosettaMetaData<ExerciseEvent> metaData = new ExerciseEventMeta();
        
        [JsonConstructor]
        public ExerciseEvent(LocalDate? adjustedCashSettlementPaymentDate, LocalDate? adjustedCashSettlementValuationDate, LocalDate adjustedExerciseDate, LocalDate? adjustedExerciseFeePaymentDate, LocalDate adjustedRelevantSwapEffectiveDate, _MetaFields? meta)
        {
            AdjustedCashSettlementPaymentDate = adjustedCashSettlementPaymentDate;
            AdjustedCashSettlementValuationDate = adjustedCashSettlementValuationDate;
            AdjustedExerciseDate = adjustedExerciseDate;
            AdjustedExerciseFeePaymentDate = adjustedExerciseFeePaymentDate;
            AdjustedRelevantSwapEffectiveDate = adjustedRelevantSwapEffectiveDate;
            Meta = meta;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ExerciseEvent> MetaData => metaData;
        
        /// <summary>
        /// The date on which the cash settlement amount is paid. This date should already be adjusted for any applicable business day convention.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? AdjustedCashSettlementPaymentDate { get; }
        
        /// <summary>
        /// The date by which the cash settlement amount must be agreed. This date should already be adjusted for any applicable business day convention.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? AdjustedCashSettlementValuationDate { get; }
        
        /// <summary>
        /// The date on which the option exercise takes place. This date should already be adjusted for any applicable business day convention.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate AdjustedExerciseDate { get; }
        
        /// <summary>
        /// The date on which the exercise fee amount is paid. This date should already be adjusted for any applicable business day convention.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? AdjustedExerciseFeePaymentDate { get; }
        
        /// <summary>
        /// The effective date of the underlying swap associated with a given exercise date. This date should already be adjusted for any applicable business day convention.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate AdjustedRelevantSwapEffectiveDate { get; }
        
        public _MetaFields? Meta { get; }
    }
    
    /// <summary>
    /// A class defining the fee payable on exercise of an option. This fee may be defined as an amount or a percentage of the notional exercised. As a difference with FpML, it extends the BuyerSeller class.
    /// </summary>
    public class ExerciseFee : AbstractRosettaModelObject<ExerciseFee>, IPayerReceiver
    {
        private static readonly IRosettaMetaData<ExerciseFee> metaData = new ExerciseFeeMeta();
        
        [JsonConstructor]
        public ExerciseFee(decimal? feeAmount, RelativeDateOffset feePaymentDate, decimal? feeRate, ReferenceWithMetaMoney notionalReference, Enums.CounterpartyRole payer, Enums.CounterpartyRole receiver)
        {
            FeeAmount = feeAmount;
            FeePaymentDate = feePaymentDate;
            FeeRate = feeRate;
            NotionalReference = notionalReference;
            Payer = payer;
            Receiver = receiver;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ExerciseFee> MetaData => metaData;
        
        /// <summary>
        /// The amount of fee to be paid on exercise. The fee currency is that of the referenced notional.
        /// </summary>
        public decimal? FeeAmount { get; }
        
        /// <summary>
        /// The date on which exercise fee(s) will be paid. It is specified as a relative date.
        /// </summary>
        public RelativeDateOffset FeePaymentDate { get; }
        
        /// <summary>
        /// A fee represented as a percentage of some referenced notional. A percentage of 5% would be represented as 0.05.
        /// </summary>
        public decimal? FeeRate { get; }
        
        /// <summary>
        /// A pointer style reference to the associated notional schedule defined elsewhere in the document.
        /// </summary>
        public ReferenceWithMetaMoney NotionalReference { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CounterpartyRole Payer { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CounterpartyRole Receiver { get; }
    }
    
    /// <summary>
    /// A class to define a fee or schedule of fees to be payable on the exercise of an option. This fee may be defined as an amount or a percentage of the notional exercised. As a difference with FpML, it extends the BuyerSeller class.
    /// </summary>
    public class ExerciseFeeSchedule : AbstractRosettaModelObject<ExerciseFeeSchedule>, IPayerReceiver
    {
        private static readonly IRosettaMetaData<ExerciseFeeSchedule> metaData = new ExerciseFeeScheduleMeta();
        
        [JsonConstructor]
        public ExerciseFeeSchedule(AmountSchedule? feeAmountSchedule, RelativeDateOffset feePaymentDate, Schedule? feeRateSchedule, ReferenceWithMetaMoney notionalReference, Enums.CounterpartyRole payer, Enums.CounterpartyRole receiver)
        {
            FeeAmountSchedule = feeAmountSchedule;
            FeePaymentDate = feePaymentDate;
            FeeRateSchedule = feeRateSchedule;
            NotionalReference = notionalReference;
            Payer = payer;
            Receiver = receiver;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ExerciseFeeSchedule> MetaData => metaData;
        
        /// <summary>
        /// The exercise fee amount schedule. The fees are expressed as currency amounts. The currency of the fee is assumed to be that of the notional schedule referenced.
        /// </summary>
        public AmountSchedule? FeeAmountSchedule { get; }
        
        /// <summary>
        /// The date on which exercise fee(s) will be paid. It is specified as a relative date.
        /// </summary>
        public RelativeDateOffset FeePaymentDate { get; }
        
        /// <summary>
        /// The exercise free rate schedule. The fees are expressed as percentage rates of the notional being exercised. The currency of the fee is assumed to be that of the notional schedule referenced.
        /// </summary>
        public Schedule? FeeRateSchedule { get; }
        
        /// <summary>
        /// A pointer style reference to the associated notional schedule defined elsewhere in the document.
        /// </summary>
        public ReferenceWithMetaMoney NotionalReference { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CounterpartyRole Payer { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CounterpartyRole Receiver { get; }
    }
    
    /// <summary>
    /// Specifies the information required to communicate the choices made by the exercising party, in a financial product endowing the party with at least one option.
    /// </summary>
    public class ExerciseInstruction : AbstractRosettaModelObject<ExerciseInstruction>
    {
        private static readonly IRosettaMetaData<ExerciseInstruction> metaData = new ExerciseInstructionMeta();
        
        [JsonConstructor]
        public ExerciseInstruction(AdjustableOrAdjustedDate? exerciseDate, ReferenceWithMetaOptionPayout? exerciseOption, PrimitiveInstruction exerciseQuantity, BusinessCenterTime? exerciseTime, IEnumerable<TradeIdentifier> replacementTradeIdentifier)
        {
            ExerciseDate = exerciseDate;
            ExerciseOption = exerciseOption;
            ExerciseQuantity = exerciseQuantity;
            ExerciseTime = exerciseTime;
            ReplacementTradeIdentifier = replacementTradeIdentifier;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ExerciseInstruction> MetaData => metaData;
        
        /// <summary>
        /// Specifies the date on which an option contained within the financial product would be exercised. The date may be omitted if the contractual product allows for only a single date of exercise (European exercise).
        /// </summary>
        public AdjustableOrAdjustedDate? ExerciseDate { get; }
        
        /// <summary>
        /// Specifies the Option Payout being exercised on the trade.
        /// </summary>
        public ReferenceWithMetaOptionPayout? ExerciseOption { get; }
        
        /// <summary>
        /// Contains instructions for exercising the option including a quantity change, and optionally a transfer.
        /// </summary>
        public PrimitiveInstruction ExerciseQuantity { get; }
        
        /// <summary>
        /// Specifies the time at which an option contained within the financial product woulld be exercised. The time may be omitted if the contractual product allows for only a single time of exercise (European exercise). 
        /// </summary>
        public BusinessCenterTime? ExerciseTime { get; }
        
        /// <summary>
        /// Specifies the trade identifier to apply to the replacement trade for physical exercise.
        /// </summary>
        public IEnumerable<TradeIdentifier> ReplacementTradeIdentifier { get; }
    }
    
    /// <summary>
    /// Defines to whom and where notice of execution should be given. The exerciseNoticeGiver refers to one or both of the principal parties of the trade. If present the exerciseNoticeReceiver refers to a party, other than the principal party, to whom notice should be given.
    /// </summary>
    public class ExerciseNotice : AbstractRosettaModelObject<ExerciseNotice>
    {
        private static readonly IRosettaMetaData<ExerciseNotice> metaData = new ExerciseNoticeMeta();
        
        [JsonConstructor]
        public ExerciseNotice(FieldWithMetaBusinessCenterEnum businessCenter, Enums.ExerciseNoticeGiver exerciseNoticeGiver, Enums.AncillaryRole? exerciseNoticeReceiver)
        {
            BusinessCenter = businessCenter;
            ExerciseNoticeGiver = exerciseNoticeGiver;
            ExerciseNoticeReceiver = exerciseNoticeReceiver;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ExerciseNotice> MetaData => metaData;
        
        /// <summary>
        /// Specifies the location where the exercise must be reported, e.g. where the exercise notice receiver is based.
        /// </summary>
        public FieldWithMetaBusinessCenterEnum BusinessCenter { get; }
        
        /// <summary>
        /// Specifies the principal party of the trade that has the right to exercise.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.ExerciseNoticeGiver ExerciseNoticeGiver { get; }
        
        /// <summary>
        /// Specifies the party to which notice of exercise should be given, e.g. by the buyer of the option. Although in many cases it is the buyer of the option who sends the exercise notice to the seller of the option, this component is reused, e.g. in case of OptionEarlyTermination, either or both parties have the right to exercise.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.AncillaryRole? ExerciseNoticeReceiver { get; }
    }
    
    /// <summary>
    /// This defines the time interval to the start of the exercise period, i.e. the earliest exercise date, and the frequency of subsequent exercise dates (if any).
    /// </summary>
    public class ExercisePeriod : AbstractRosettaModelObject<ExercisePeriod>
    {
        private static readonly IRosettaMetaData<ExercisePeriod> metaData = new ExercisePeriodMeta();
        
        [JsonConstructor]
        public ExercisePeriod(Period earliestExerciseDateTenor, Period? exerciseFrequency, _MetaFields? meta)
        {
            EarliestExerciseDateTenor = earliestExerciseDateTenor;
            ExerciseFrequency = exerciseFrequency;
            Meta = meta;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ExercisePeriod> MetaData => metaData;
        
        /// <summary>
        /// The time interval to the first (and possibly only) exercise date in the exercise period.
        /// </summary>
        public Period EarliestExerciseDateTenor { get; }
        
        /// <summary>
        /// The frequency of subsequent exercise dates in the exercise period following the earliest exercise date. An interval of 1 day should be used to indicate an American style exercise period.
        /// </summary>
        public Period? ExerciseFrequency { get; }
        
        public _MetaFields? Meta { get; }
    }
    
    /// <summary>
    /// A class describing how notice of exercise should be given. This can be either manual or automatic.
    /// </summary>
    public class ExerciseProcedure : AbstractRosettaModelObject<ExerciseProcedure>
    {
        private static readonly IRosettaMetaData<ExerciseProcedure> metaData = new ExerciseProcedureMeta();
        
        [JsonConstructor]
        public ExerciseProcedure(AutomaticExercise? automaticExercise, bool followUpConfirmation, bool? limitedRightToConfirm, ManualExercise? manualExercise, bool? splitTicket)
        {
            AutomaticExercise = automaticExercise;
            FollowUpConfirmation = followUpConfirmation;
            LimitedRightToConfirm = limitedRightToConfirm;
            ManualExercise = manualExercise;
            SplitTicket = splitTicket;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ExerciseProcedure> MetaData => metaData;
        
        /// <summary>
        /// If automatic is specified, then the notional amount of the underlying swap not previously exercised under the swaption will be automatically exercised at the expiration time on the expiration date if at such time the buyer is in-the-money, provided that the difference between the settlement rate and the fixed rate under the relevant underlying swap is not less than the specified threshold rate. The term in-the-money is assumed to have the meaning defining in the 2000 ISDA Definitions, Section 17.4 In-the-money.
        /// </summary>
        public AutomaticExercise? AutomaticExercise { get; }
        
        /// <summary>
        /// A flag to indicate whether follow-up confirmation of exercise (written or electronic) is required following telephonic notice by the buyer to the seller or seller&apos;s agent.
        /// </summary>
        public bool FollowUpConfirmation { get; }
        
        /// <summary>
        /// Has the meaning defined as part of the 1997 ISDA Government Bond Option Definitions, section 4.5 Limited Right to Confirm Exercise. If present, (i) the Seller may request the Buyer to confirm its intent if not done on or before the expiration time on the Expiration date (ii) specific rules will apply in relation to the settlement mode.
        /// </summary>
        public bool? LimitedRightToConfirm { get; }
        
        /// <summary>
        /// Specifies that the notice of exercise must be given by the buyer to the seller or seller&apos;s agent.
        /// </summary>
        public ManualExercise? ManualExercise { get; }
        
        /// <summary>
        /// Typically applicable to the physical settlement of bond and convertible bond options. If present, means that the party required to deliver the bonds will divide those to be delivered as notifying party desires to facilitate delivery obligations.
        /// </summary>
        public bool? SplitTicket { get; }
    }
    
    /// <summary>
    /// Represents the current mark to market value or IM calculation value of the trade portfolio as recorded by the principle (in base currency).
    /// </summary>
    public class Exposure : AbstractRosettaModelObject<Exposure>
    {
        private static readonly IRosettaMetaData<Exposure> metaData = new ExposureMeta();
        
        [JsonConstructor]
        public Exposure(Money aggregateValue, ZonedDateTime? calculationDateTime, ReferenceWithMetaPortfolioState tradePortfolio, ZonedDateTime valuationDateTime)
        {
            AggregateValue = aggregateValue;
            CalculationDateTime = calculationDateTime;
            TradePortfolio = tradePortfolio;
            ValuationDateTime = valuationDateTime;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Exposure> MetaData => metaData;
        
        /// <summary>
        /// Represents the aggregate value of the portfolio in base currency.
        /// </summary>
        public Money AggregateValue { get; }
        
        /// <summary>
        /// Indicates the date when the exposure is calculated if different from valuation date.
        /// </summary>
        public ZonedDateTime? CalculationDateTime { get; }
        
        /// <summary>
        /// Represents a Portfolio that describes all the positions held at a given time, in various states which can be either traded, settled, etc., with lineage information to the previous state.
        /// </summary>
        public ReferenceWithMetaPortfolioState TradePortfolio { get; }
        
        /// <summary>
        /// Indicates the valuation date of the exposure underlying the calculation.
        /// </summary>
        public ZonedDateTime ValuationDateTime { get; }
    }
    
    /// <summary>
    /// A data defining:  an option to extend an existing swap transaction on the specified exercise dates for a term ending on the specified new termination date. As a difference from FpML, it extends the BuyerSeller class, which represents the BuyerSeller.model.
    /// </summary>
    public class ExtendibleProvision : AbstractRosettaModelObject<ExtendibleProvision>, IBuyerSeller
    {
        private static readonly IRosettaMetaData<ExtendibleProvision> metaData = new ExtendibleProvisionMeta();
        
        [JsonConstructor]
        public ExtendibleProvision(AmericanExercise? americanExercise, BermudaExercise? bermudaExercise, Enums.CallingParty? callingParty, EuropeanExercise? europeanExercise, ExerciseNotice? exerciseNotice, ExtendibleProvisionAdjustedDates? extendibleProvisionAdjustedDates, AdjustableRelativeOrPeriodicDates? extensionPeriod, RelativeDateOffset? extensionTerm, bool? followUpConfirmation, ZonedDateTime? noticeDeadlineDateTime, RelativeDateOffset? noticeDeadlinePeriod, PartyRole? singlePartyOption, Enums.CounterpartyRole buyer, Enums.CounterpartyRole seller)
        {
            AmericanExercise = americanExercise;
            BermudaExercise = bermudaExercise;
            CallingParty = callingParty;
            EuropeanExercise = europeanExercise;
            ExerciseNotice = exerciseNotice;
            ExtendibleProvisionAdjustedDates = extendibleProvisionAdjustedDates;
            ExtensionPeriod = extensionPeriod;
            ExtensionTerm = extensionTerm;
            FollowUpConfirmation = followUpConfirmation;
            NoticeDeadlineDateTime = noticeDeadlineDateTime;
            NoticeDeadlinePeriod = noticeDeadlinePeriod;
            SinglePartyOption = singlePartyOption;
            Buyer = buyer;
            Seller = seller;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ExtendibleProvision> MetaData => metaData;
        
        /// <summary>
        /// American exercise. FpML implementations consists in an exercise substitution group.
        /// </summary>
        public AmericanExercise? AmericanExercise { get; }
        
        /// <summary>
        /// Bermuda exercise. FpML implementations consists in an exercise substitution group.
        /// </summary>
        public BermudaExercise? BermudaExercise { get; }
        
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CallingParty? CallingParty { get; }
        
        /// <summary>
        /// European exercise. FpML implementations consists in an exercise substitution group.
        /// </summary>
        public EuropeanExercise? EuropeanExercise { get; }
        
        /// <summary>
        /// Definition of the party to whom notice of exercise should be given.
        /// </summary>
        public ExerciseNotice? ExerciseNotice { get; }
        
        /// <summary>
        /// The adjusted dates associated with an extendible provision. These dates have been adjusted for any applicable business day convention.
        /// </summary>
        public ExtendibleProvisionAdjustedDates? ExtendibleProvisionAdjustedDates { get; }
        
        /// <summary>
        /// The period within which notice can be given that the contract will be extended.
        /// </summary>
        public AdjustableRelativeOrPeriodicDates? ExtensionPeriod { get; }
        
        /// <summary>
        /// The length of each extension period relative to the effective date of the preceding contract.
        /// </summary>
        public RelativeDateOffset? ExtensionTerm { get; }
        
        /// <summary>
        /// A flag to indicate whether follow-up confirmation of exercise (written or electronic) is required following telephonic notice by the buyer to the seller or seller&apos;s agent.
        /// </summary>
        public bool? FollowUpConfirmation { get; }
        
        /// <summary>
        /// A specific date and time for the notice deadline
        /// </summary>
        public ZonedDateTime? NoticeDeadlineDateTime { get; }
        
        /// <summary>
        /// Defines the minimum period before a contract is scheduled to terminate that notice can be given that it will terminate beyond the scheduled termination date.
        /// </summary>
        public RelativeDateOffset? NoticeDeadlinePeriod { get; }
        
        /// <summary>
        /// If the ability to extend the contract is not available to both parties then this component specifies the buyer and seller of the option.
        /// </summary>
        public PartyRole? SinglePartyOption { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CounterpartyRole Buyer { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CounterpartyRole Seller { get; }
    }
    
    /// <summary>
    /// A data defining:  the adjusted dates associated with a provision to extend a swap.
    /// </summary>
    public class ExtendibleProvisionAdjustedDates : AbstractRosettaModelObject<ExtendibleProvisionAdjustedDates>
    {
        private static readonly IRosettaMetaData<ExtendibleProvisionAdjustedDates> metaData = new ExtendibleProvisionAdjustedDatesMeta();
        
        [JsonConstructor]
        public ExtendibleProvisionAdjustedDates(IEnumerable<ExtensionEvent> extensionEvent)
        {
            ExtensionEvent = extensionEvent;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ExtendibleProvisionAdjustedDates> MetaData => metaData;
        
        /// <summary>
        /// The adjusted dates associated with a single extendible exercise date.
        /// </summary>
        public IEnumerable<ExtensionEvent> ExtensionEvent { get; }
    }
    
    /// <summary>
    /// A data to:  define the adjusted dates associated with an individual extension event.
    /// </summary>
    public class ExtensionEvent : AbstractRosettaModelObject<ExtensionEvent>
    {
        private static readonly IRosettaMetaData<ExtensionEvent> metaData = new ExtensionEventMeta();
        
        [JsonConstructor]
        public ExtensionEvent(LocalDate adjustedExerciseDate, LocalDate adjustedExtendedTerminationDate, _MetaFields? meta)
        {
            AdjustedExerciseDate = adjustedExerciseDate;
            AdjustedExtendedTerminationDate = adjustedExtendedTerminationDate;
            Meta = meta;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ExtensionEvent> MetaData => metaData;
        
        /// <summary>
        /// The date on which option exercise takes place. This date should already be adjusted for any applicable business day convention.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate AdjustedExerciseDate { get; }
        
        /// <summary>
        /// The termination date if an extendible provision is exercised. This date should already be adjusted for any applicable business day convention.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate AdjustedExtendedTerminationDate { get; }
        
        public _MetaFields? Meta { get; }
    }
    
    /// <summary>
    /// Where the underlying is shares, defines market events affecting the issuer of those shares that may require the terms of the transaction to be adjusted.
    /// </summary>
    public class ExtraordinaryEvents : AbstractRosettaModelObject<ExtraordinaryEvents>
    {
        private static readonly IRosettaMetaData<ExtraordinaryEvents> metaData = new ExtraordinaryEventsMeta();
        
        [JsonConstructor]
        public ExtraordinaryEvents(AdditionalDisruptionEvents? additionalDisruptionEvents, bool? compositionOfCombinedConsideration, Enums.NationalizationOrInsolvencyOrDelistingEvent? delisting, bool? failureToDeliver, IndexAdjustmentEvents? indexAdjustmentEvents, EquityCorporateEvents? mergerEvents, Enums.NationalizationOrInsolvencyOrDelistingEvent? nationalizationOrInsolvency, Representations? representations, EquityCorporateEvents? tenderOfferEvents)
        {
            AdditionalDisruptionEvents = additionalDisruptionEvents;
            CompositionOfCombinedConsideration = compositionOfCombinedConsideration;
            Delisting = delisting;
            FailureToDeliver = failureToDeliver;
            IndexAdjustmentEvents = indexAdjustmentEvents;
            MergerEvents = mergerEvents;
            NationalizationOrInsolvency = nationalizationOrInsolvency;
            Representations = representations;
            TenderOfferEvents = tenderOfferEvents;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ExtraordinaryEvents> MetaData => metaData;
        
        /// <summary>
        /// 2002 ISDA Equity Derivatives Definitions: Additional Disruption Events | 2018 ISDA CDM Equity Confirmation for Security Equity Swap: Additional Disruption Events means each Additional Disruption Event specified in the Confirmation Side Letter. For the avoidance of doubt, each Additional Disruption Event shall be an Extraordinary Event.
        /// </summary>
        public AdditionalDisruptionEvents? AdditionalDisruptionEvents { get; }
        
        /// <summary>
        /// 2002 ISDA Equity Derivatives Definitions: Composition of Combined Consideration | 2018 ISDA CDM Equity Confirmation for Security Equity Swap: Combined Consideration | If present and true, then composition of combined consideration is applicable.
        /// </summary>
        public bool? CompositionOfCombinedConsideration { get; }
        
        /// <summary>
        /// 2002 ISDA Equity Derivatives Definitions: Delisting | 2018 ISDA CDM Equity Confirmation for Security Equity Swap: Delisting means Delisting (Broad Relisting) or Delisting (Narrow Relisting), as specified in the Relationship Supplement.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.NationalizationOrInsolvencyOrDelistingEvent? Delisting { get; }
        
        /// <summary>
        /// If true, failure to deliver is applicable.
        /// </summary>
        public bool? FailureToDeliver { get; }
        
        /// <summary>
        /// 2002 ISDA Equity Derivatives Definitions: Adjustments to Indices | 
        /// </summary>
        public IndexAdjustmentEvents? IndexAdjustmentEvents { get; }
        
        /// <summary>
        /// 2018 ISDA CDM Equity Confirmation for Security Equity Swap: Merger Event shall occur if a Merger occurs and the Merger Date is on or before the final Equity Valuation Date | Occurs when the underlying ceases to exist following a merger between the Issuer and another company.
        /// </summary>
        public EquityCorporateEvents? MergerEvents { get; }
        
        /// <summary>
        /// 2002 ISDA Equity Derivatives Definitions: Nationalization and Insolvency | 2018 ISDA CDM Equity Confirmation for Security Equity Swap: Nationalization shall occur if all the Securities or all or substantially all the assets of an Issuer are nationalized, expropriated or are otherwise required to be transferred to any governmental agency, authority, entity or instrumentality thereof. Insolvency Filing means as defined in the Confirmation Side Letter.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.NationalizationOrInsolvencyOrDelistingEvent? NationalizationOrInsolvency { get; }
        
        public Representations? Representations { get; }
        
        /// <summary>
        /// 2002 ISDA Equity Derivatives Definitions: Tender Offers | 2018 ISDA CDM Equity Confirmation for Security Equity Swap: Tender Offer Event
        /// </summary>
        public EquityCorporateEvents? TenderOfferEvents { get; }
    }
    
    public class FailureToPay : AbstractRosettaModelObject<FailureToPay>
    {
        private static readonly IRosettaMetaData<FailureToPay> metaData = new FailureToPayMeta();
        
        [JsonConstructor]
        public FailureToPay(bool applicable, GracePeriodExtension? gracePeriodExtension, Money? paymentRequirement)
        {
            Applicable = applicable;
            GracePeriodExtension = gracePeriodExtension;
            PaymentRequirement = paymentRequirement;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FailureToPay> MetaData => metaData;
        
        /// <summary>
        /// Indicates whether the failure to pay provision is applicable.
        /// </summary>
        public bool Applicable { get; }
        
        /// <summary>
        /// If this element is specified, indicates whether or not a grace period extension is applicable. ISDA 2003 Term: Grace Period Extension Applicable.
        /// </summary>
        public GracePeriodExtension? GracePeriodExtension { get; }
        
        /// <summary>
        /// Specifies a threshold for the failure to pay credit event. Market standard is USD 1,000,000 (JPY 100,000,000 for Japanese Yen trades) or its equivalent in the relevant obligation currency. This is applied on an aggregate basis across all Obligations of the Reference Entity. Intended to prevent technical/operational errors from triggering credit events. ISDA 2003 Term: Payment Requirement
        /// </summary>
        public Money? PaymentRequirement { get; }
    }
    
    /// <summary>
    /// Defines the structure needed to represent fallback rate parameters. This type is used to represent modular computed rates in interestRatePayouts.
    /// </summary>
    public class FallbackRateParameters : AbstractRosettaModelObject<FallbackRateParameters>
    {
        private static readonly IRosettaMetaData<FallbackRateParameters> metaData = new FallbackRateParametersMeta();
        
        [JsonConstructor]
        public FallbackRateParameters(FloatingRateCalculationParameters? calculationParameters, LocalDate? effectiveDate, Enums.FloatingRateIndex floatingRateIndex, decimal? spreadAdjustment)
        {
            CalculationParameters = calculationParameters;
            EffectiveDate = effectiveDate;
            FloatingRateIndex = floatingRateIndex;
            SpreadAdjustment = spreadAdjustment;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FallbackRateParameters> MetaData => metaData;
        
        /// <summary>
        /// Support for modular calculated rates, such such as lockout compound calculations.
        /// </summary>
        public FloatingRateCalculationParameters? CalculationParameters { get; }
        
        /// <summary>
        /// The date the fallback rate takes effect.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? EffectiveDate { get; }
        
        /// <summary>
        /// The floating rate index that is used as the basis of the fallback rate.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.FloatingRateIndex FloatingRateIndex { get; }
        
        /// <summary>
        /// The economic spread applied to the underlying fallback rate to replicate the original risky rate.
        /// </summary>
        public decimal? SpreadAdjustment { get; }
    }
    
    /// <summary>
    /// The method, prioritised by the order it is listed in this element, to get a replacement rate for the disrupted settlement rate option.
    /// </summary>
    public class FallbackReferencePrice : AbstractRosettaModelObject<FallbackReferencePrice>
    {
        private static readonly IRosettaMetaData<FallbackReferencePrice> metaData = new FallbackReferencePriceMeta();
        
        [JsonConstructor]
        public FallbackReferencePrice(CalculationAgent? calculationAgentDetermination, IEnumerable<FieldWithMetaSettlementRateOptionEnum> fallBackSettlementRateOption, bool? fallbackSurveyValuationPostponement, ValuationPostponement? valuationPostponement)
        {
            CalculationAgentDetermination = calculationAgentDetermination;
            FallBackSettlementRateOption = fallBackSettlementRateOption;
            FallbackSurveyValuationPostponement = fallbackSurveyValuationPostponement;
            ValuationPostponement = valuationPostponement;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FallbackReferencePrice> MetaData => metaData;
        
        /// <summary>
        /// The calculation agent will decide the rate.
        /// </summary>
        public CalculationAgent? CalculationAgentDetermination { get; }
        
        /// <summary>
        /// This settlement rate option will be used in its place.
        /// </summary>
        public IEnumerable<FieldWithMetaSettlementRateOptionEnum> FallBackSettlementRateOption { get; }
        
        /// <summary>
        /// Request rate quotes from the market. This element is set as type Empty in FpML. When present, the FpML synonym is mapped to a value True in the CDM.
        /// </summary>
        public bool? FallbackSurveyValuationPostponement { get; }
        
        /// <summary>
        /// Specifies how long to wait to get a quote from a settlement rate option upon a price source disruption.
        /// </summary>
        public ValuationPostponement? ValuationPostponement { get; }
    }
    
    /// <summary>
    /// Payment made following trigger occurrence.
    /// </summary>
    public class FeaturePayment : AbstractRosettaModelObject<FeaturePayment>
    {
        private static readonly IRosettaMetaData<FeaturePayment> metaData = new FeaturePaymentMeta();
        
        [JsonConstructor]
        public FeaturePayment(decimal? amount, FieldWithMetaString? currency, decimal? levelPercentage, _MetaFields? meta, PartyReferencePayerReceiver payerReceiver, AdjustableOrRelativeDate? paymentDate, Enums.TimeType? time)
        {
            Amount = amount;
            Currency = currency;
            LevelPercentage = levelPercentage;
            Meta = meta;
            PayerReceiver = payerReceiver;
            PaymentDate = paymentDate;
            Time = time;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FeaturePayment> MetaData => metaData;
        
        /// <summary>
        /// The monetary quantity in currency units.
        /// </summary>
        public decimal? Amount { get; }
        
        /// <summary>
        /// The currency in which an amount is denominated.
        /// </summary>
        public FieldWithMetaString? Currency { get; }
        
        /// <summary>
        /// The trigger level percentage.
        /// </summary>
        public decimal? LevelPercentage { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <summary>
        /// This attribute doesn&apos;t exist as part of the FpML construct, which makes use of the PayerReceiver.model group.
        /// </summary>
        public PartyReferencePayerReceiver PayerReceiver { get; }
        
        /// <summary>
        /// The feature payment date.
        /// </summary>
        public AdjustableOrRelativeDate? PaymentDate { get; }
        
        /// <summary>
        /// The feature payment time.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.TimeType? Time { get; }
    }
    
    public class FinInstrm : AbstractRosettaModelObject<FinInstrm>
    {
        private static readonly IRosettaMetaData<FinInstrm> metaData = new FinInstrmMeta();
        
        [JsonConstructor]
        public FinInstrm(Othr othr)
        {
            Othr = othr;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FinInstrm> MetaData => metaData;
        
        public Othr Othr { get; }
    }
    
    public class FinInstrmGnlAttrbts : AbstractRosettaModelObject<FinInstrmGnlAttrbts>
    {
        private static readonly IRosettaMetaData<FinInstrmGnlAttrbts> metaData = new FinInstrmGnlAttrbtsMeta();
        
        [JsonConstructor]
        public FinInstrmGnlAttrbts(string clssfctnTp, string fullNm, string ntnlCcy)
        {
            ClssfctnTp = clssfctnTp;
            FullNm = fullNm;
            NtnlCcy = ntnlCcy;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FinInstrmGnlAttrbts> MetaData => metaData;
        
        public string ClssfctnTp { get; }
        
        public string FullNm { get; }
        
        public string NtnlCcy { get; }
    }
    
    public class FinInstrmRptgTxRpt : AbstractRosettaModelObject<FinInstrmRptgTxRpt>
    {
        private static readonly IRosettaMetaData<FinInstrmRptgTxRpt> metaData = new FinInstrmRptgTxRptMeta();
        
        [JsonConstructor]
        public FinInstrmRptgTxRpt(Tx tx)
        {
            Tx = tx;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FinInstrmRptgTxRpt> MetaData => metaData;
        
        public Tx Tx { get; }
    }
    
    /// <summary>
    /// A data to:  define business date convention adjustment to final payment period per leg.
    /// </summary>
    public class FinalCalculationPeriodDateAdjustment : AbstractRosettaModelObject<FinalCalculationPeriodDateAdjustment>
    {
        private static readonly IRosettaMetaData<FinalCalculationPeriodDateAdjustment> metaData = new FinalCalculationPeriodDateAdjustmentMeta();
        
        [JsonConstructor]
        public FinalCalculationPeriodDateAdjustment(Enums.BusinessDayConvention businessDayConvention, ReferenceWithMetaAdjustableOrRelativeDates relevantUnderlyingDateReference, ReferenceWithMetaInterestRatePayout swapStreamReference)
        {
            BusinessDayConvention = businessDayConvention;
            RelevantUnderlyingDateReference = relevantUnderlyingDateReference;
            SwapStreamReference = swapStreamReference;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FinalCalculationPeriodDateAdjustment> MetaData => metaData;
        
        /// <summary>
        /// Override business date convention. This takes precedence over leg level information.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.BusinessDayConvention BusinessDayConvention { get; }
        
        /// <summary>
        /// Reference to the unadjusted cancellation effective dates.
        /// </summary>
        public ReferenceWithMetaAdjustableOrRelativeDates RelevantUnderlyingDateReference { get; }
        
        /// <summary>
        /// Reference to the leg, where date adjustments may apply.
        /// </summary>
        public ReferenceWithMetaInterestRatePayout SwapStreamReference { get; }
    }
    
    /// <summary>
    /// Type for reporting the detailed results of calculating a cash flow for a calculation period.  This is enhanced relative to the FpML-based cashflows structure to allow more information to be returned about daily compounded rates.
    /// </summary>
    public class FixedAmountCalculationDetails : AbstractRosettaModelObject<FixedAmountCalculationDetails>
    {
        private static readonly IRosettaMetaData<FixedAmountCalculationDetails> metaData = new FixedAmountCalculationDetailsMeta();
        
        [JsonConstructor]
        public FixedAmountCalculationDetails(decimal calculatedAmount, CalculationPeriodBase calculationPeriod, Money calculationPeriodNotionalAmount, decimal fixedRate, decimal yearFraction)
        {
            CalculatedAmount = calculatedAmount;
            CalculationPeriod = calculationPeriod;
            CalculationPeriodNotionalAmount = calculationPeriodNotionalAmount;
            FixedRate = fixedRate;
            YearFraction = yearFraction;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FixedAmountCalculationDetails> MetaData => metaData;
        
        /// <summary>
        /// The amount of the cash flow that was computed, including any spreads and other processing.
        /// </summary>
        public decimal CalculatedAmount { get; }
        
        /// <summary>
        /// The calculation period for which the floating calculation was performed.
        /// </summary>
        public CalculationPeriodBase CalculationPeriod { get; }
        
        /// <summary>
        /// The notional in effect during the calculation period.
        /// </summary>
        public Money CalculationPeriodNotionalAmount { get; }
        
        /// <summary>
        /// The value of the fixed rate that was used.
        /// </summary>
        public decimal FixedRate { get; }
        
        /// <summary>
        /// The fraction of a year that this calculation represents, according to the day count fraction method.
        /// </summary>
        public decimal YearFraction { get; }
    }
    
    /// <summary>
    /// A predefined price accorded by the counterparties.
    /// </summary>
    public class FixedPrice : AbstractRosettaModelObject<FixedPrice>
    {
        private static readonly IRosettaMetaData<FixedPrice> metaData = new FixedPriceMeta();
        
        [JsonConstructor]
        public FixedPrice(ReferenceWithMetaPriceSchedule? price)
        {
            Price = price;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FixedPrice> MetaData => metaData;
        
        /// <summary>
        /// Fixed price step schedule, including an initial price specified as an absolute number.
        /// </summary>
        public ReferenceWithMetaPriceSchedule? Price { get; }
    }
    
    /// <summary>
    /// Represents a fixed price payout. There is no underlier associated with this payout type and is based on fixed pricing per a given unit (e.g. in commodities price per barrel)
    /// </summary>
    public class FixedPricePayout : AbstractRosettaModelObject<FixedPricePayout>, IPayoutBase
    {
        private static readonly IRosettaMetaData<FixedPricePayout> metaData = new FixedPricePayoutMeta();
        
        [JsonConstructor]
        public FixedPricePayout(FixedPrice fixedPrice, _MetaFields? meta, PaymentDates paymentDates, CommoditySchedule? schedule, PayerReceiver payerReceiver, ResolvablePriceQuantity? priceQuantity, PrincipalPayments? principalPayment, SettlementTerms? settlementTerms)
        {
            FixedPrice = fixedPrice;
            Meta = meta;
            PaymentDates = paymentDates;
            Schedule = schedule;
            PayerReceiver = payerReceiver;
            PriceQuantity = priceQuantity;
            PrincipalPayment = principalPayment;
            SettlementTerms = settlementTerms;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FixedPricePayout> MetaData => metaData;
        
        /// <summary>
        /// Specifies the fixed price on which fixed forward payments are based.
        /// </summary>
        public FixedPrice FixedPrice { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <summary>
        /// Specifies the parameters to generate the payment date schedule, either through a parametric representation or by reference to specified dates.
        /// </summary>
        public PaymentDates PaymentDates { get; }
        
        /// <summary>
        /// Allows the full representation of a commodity payout by defining a set of schedule periods. It supports standard schedule customization by expressing all the dates, quantities, and pricing data in a non-parametric way.
        /// </summary>
        public CommoditySchedule? Schedule { get; }
        
        /// <inheritdoc/>
        public PayerReceiver PayerReceiver { get; }
        
        /// <inheritdoc/>
        public ResolvablePriceQuantity? PriceQuantity { get; }
        
        /// <inheritdoc/>
        public PrincipalPayments? PrincipalPayment { get; }
        
        /// <inheritdoc/>
        public SettlementTerms? SettlementTerms { get; }
    }
    
    /// <summary>
    /// Type defining the specification for a fixed rate.
    /// </summary>
    public class FixedRateSpecification : AbstractRosettaModelObject<FixedRateSpecification>
    {
        private static readonly IRosettaMetaData<FixedRateSpecification> metaData = new FixedRateSpecificationMeta();
        
        [JsonConstructor]
        public FixedRateSpecification(_MetaFields? meta, RateSchedule? rateSchedule)
        {
            Meta = meta;
            RateSchedule = rateSchedule;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FixedRateSpecification> MetaData => metaData;
        
        public _MetaFields? Meta { get; }
        
        /// <summary>
        /// The fixed rate or fixed rate schedule expressed as explicit fixed rates and dates. In the case of a schedule, the step dates may be subject to adjustment in accordance with any adjustments specified in calculationPeriodDatesAdjustments.
        /// </summary>
        public RateSchedule? RateSchedule { get; }
    }
    
    /// <summary>
    /// Type for reporting the detailed results of calculating a cash flow for a calculation period.  This is enhanced relative to the FpML-based cashflows structure to allow more information to be returned about daily compounded rates.
    /// </summary>
    public class FloatingAmountCalculationDetails : AbstractRosettaModelObject<FloatingAmountCalculationDetails>
    {
        private static readonly IRosettaMetaData<FloatingAmountCalculationDetails> metaData = new FloatingAmountCalculationDetailsMeta();
        
        [JsonConstructor]
        public FloatingAmountCalculationDetails(decimal appliedRate, decimal calculatedAmount, CalculationPeriodBase calculationPeriod, Money calculationPeriodNotionalAmount, FloatingRateSettingDetails? floatingRate, FloatingRateProcessingDetails? processingDetails, decimal spreadExclusiveCalculatedAMount, decimal yearFraction)
        {
            AppliedRate = appliedRate;
            CalculatedAmount = calculatedAmount;
            CalculationPeriod = calculationPeriod;
            CalculationPeriodNotionalAmount = calculationPeriodNotionalAmount;
            FloatingRate = floatingRate;
            ProcessingDetails = processingDetails;
            SpreadExclusiveCalculatedAMount = spreadExclusiveCalculatedAMount;
            YearFraction = yearFraction;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FloatingAmountCalculationDetails> MetaData => metaData;
        
        /// <summary>
        /// The rate that was actually applied, after all calculations and treatments.
        /// </summary>
        public decimal AppliedRate { get; }
        
        /// <summary>
        /// The amount of the cash flow that was computed, including any spreads and other processing.
        /// </summary>
        public decimal CalculatedAmount { get; }
        
        /// <summary>
        /// The calculation period for which the floating calculation was performed.
        /// </summary>
        public CalculationPeriodBase CalculationPeriod { get; }
        
        /// <summary>
        /// The notional in effect during the calculation period.
        /// </summary>
        public Money CalculationPeriodNotionalAmount { get; }
        
        /// <summary>
        /// The details of the floating rate setting.  (If it is a calculated rate, details of that calculation will be inside that.
        /// </summary>
        public FloatingRateSettingDetails? FloatingRate { get; }
        
        /// <summary>
        /// Details fo the floating rate treatment after the rate is observed or calculated.  This will include details of things like multipliers, spreads, caps and floors, and the raw and treated rates.
        /// </summary>
        public FloatingRateProcessingDetails? ProcessingDetails { get; }
        
        /// <summary>
        /// The amount of the cash flow excluding any spread, for subsequent processing.
        /// </summary>
        public decimal SpreadExclusiveCalculatedAMount { get; }
        
        /// <summary>
        /// The fraction of a year that this calculation represents, according to the day count fraction method.
        /// </summary>
        public decimal YearFraction { get; }
    }
    
    /// <summary>
    /// A class to specify the ISDA terms relating to the floating rate payment events and the implied additional fixed payments, applicable to the credit derivatives transactions on mortgage-backed securities with pay-as-you-go or physical settlement.
    /// </summary>
    public class FloatingAmountEvents : AbstractRosettaModelObject<FloatingAmountEvents>
    {
        private static readonly IRosettaMetaData<FloatingAmountEvents> metaData = new FloatingAmountEventsMeta();
        
        [JsonConstructor]
        public FloatingAmountEvents(AdditionalFixedPayments? additionalFixedPayments, bool? failureToPayPrincipal, FloatingAmountProvisions? floatingAmountProvisions, bool? impliedWritedown, InterestShortFall? interestShortfall, bool? writedown)
        {
            AdditionalFixedPayments = additionalFixedPayments;
            FailureToPayPrincipal = failureToPayPrincipal;
            FloatingAmountProvisions = floatingAmountProvisions;
            ImpliedWritedown = impliedWritedown;
            InterestShortfall = interestShortfall;
            Writedown = writedown;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FloatingAmountEvents> MetaData => metaData;
        
        /// <summary>
        /// Specifies the events that will give rise to the payment additional fixed payments.
        /// </summary>
        public AdditionalFixedPayments? AdditionalFixedPayments { get; }
        
        /// <summary>
        /// A floating rate payment event. Corresponds to the failure by the Reference Entity to pay an expected principal amount or the payment of an actual principal amount that is less than the expected principal amount. ISDA 2003 Term: Failure to Pay Principal.
        /// </summary>
        public bool? FailureToPayPrincipal { get; }
        
        /// <summary>
        /// Specifies the floating amount provisions associated with the floatingAmountEvents.
        /// </summary>
        public FloatingAmountProvisions? FloatingAmountProvisions { get; }
        
        /// <summary>
        /// A floating rate payment event. Results from the fact that losses occur to the underlying instruments that do not result in reductions of the outstanding principal of the reference obligation.
        /// </summary>
        public bool? ImpliedWritedown { get; }
        
        /// <summary>
        /// A floating rate payment event. With respect to any Reference Obligation Payment Date, either (a) the non-payment of an Expected Interest Amount or (b) the payment of an Actual Interest Amount that is less than the Expected Interest Amount. ISDA 2003 Term: Interest Shortfall.
        /// </summary>
        public InterestShortFall? InterestShortfall { get; }
        
        /// <summary>
        /// A floating rate payment event. Results from the fact that the underlier writes down its outstanding principal amount. ISDA 2003 Term: Writedown.
        /// </summary>
        public bool? Writedown { get; }
    }
    
    public class FloatingAmountProvisions : AbstractRosettaModelObject<FloatingAmountProvisions>
    {
        private static readonly IRosettaMetaData<FloatingAmountProvisions> metaData = new FloatingAmountProvisionsMeta();
        
        [JsonConstructor]
        public FloatingAmountProvisions(bool? stepUpProvision, bool? wacCapInterestProvision)
        {
            StepUpProvision = stepUpProvision;
            WacCapInterestProvision = wacCapInterestProvision;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FloatingAmountProvisions> MetaData => metaData;
        
        /// <summary>
        /// As specified by the ISDA Standard Terms Supplement for use with trades on mortgage-backed securities. The presence of the element with value set to &apos;true&apos; signifies that the provision is applicable. If applicable, the applicable step-up terms are specified as part of that ISDA Standard Terms Supplement. From a usage standpoint, this provision is typically applicable in the case of RMBS and not applicable in case of CMBS trades.
        /// </summary>
        public bool? StepUpProvision { get; }
        
        /// <summary>
        /// As specified by the ISDA Supplement for use with trades on mortgage-backed securities, &apos;WAC Cap&apos; means a weighted average coupon or weighted average rate cap provision (however defined in the Underlying Instruments) of the Underlying Instruments that limits, increases or decreases the interest rate or interest entitlement, as set out in the Underlying Instruments on the Effective Date without regard to any subsequent amendment The presence of the element with value set to &apos;true&apos; signifies that the provision is applicable. From a usage standpoint, this provision is typically applicable in the case of CMBS and not applicable in case of RMBS trades.
        /// </summary>
        public bool? WacCapInterestProvision { get; }
    }
    
    public class FloatingRate : AbstractRosettaModelObject<FloatingRate>, IFloatingRate, IFloatingRateBase
    {
        private static readonly IRosettaMetaData<FloatingRate> metaData = new FloatingRateMeta();
        
        [JsonConstructor]
        public FloatingRate(FloatingRateCalculationParameters? calculationParameters, FallbackRateParameters? fallbackRate, RateSchedule? floatingRateMultiplierSchedule, Enums.RateTreatment? rateTreatment, StrikeSchedule? capRateSchedule, StrikeSchedule? floorRateSchedule, _MetaFields? meta, ReferenceWithMetaFloatingRateOption? rateOption, SpreadSchedule? spreadSchedule)
        {
            CalculationParameters = calculationParameters;
            FallbackRate = fallbackRate;
            FloatingRateMultiplierSchedule = floatingRateMultiplierSchedule;
            RateTreatment = rateTreatment;
            CapRateSchedule = capRateSchedule;
            FloorRateSchedule = floorRateSchedule;
            Meta = meta;
            RateOption = rateOption;
            SpreadSchedule = spreadSchedule;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FloatingRate> MetaData => metaData;
        
        /// <inheritdoc/>
        public FloatingRateCalculationParameters? CalculationParameters { get; }
        
        /// <inheritdoc/>
        public FallbackRateParameters? FallbackRate { get; }
        
        /// <inheritdoc/>
        public RateSchedule? FloatingRateMultiplierSchedule { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.RateTreatment? RateTreatment { get; }
        
        /// <inheritdoc/>
        public StrikeSchedule? CapRateSchedule { get; }
        
        /// <inheritdoc/>
        public StrikeSchedule? FloorRateSchedule { get; }
        
        public _MetaFields? Meta { get; }
        
        public ReferenceWithMetaFloatingRateOption? RateOption { get; }
        
        /// <inheritdoc/>
        public SpreadSchedule? SpreadSchedule { get; }
    }
    
    /// <summary>
    /// A class defining a floating interest rate through the specification of the floating rate index, the tenor, the multiplier schedule, the spread, the qualification of whether a specific rate treatment and/or a cap or floor apply.
    /// </summary>
    public class FloatingRateBase : AbstractRosettaModelObject<FloatingRateBase>, IFloatingRateBase
    {
        private static readonly IRosettaMetaData<FloatingRateBase> metaData = new FloatingRateBaseMeta();
        
        [JsonConstructor]
        public FloatingRateBase(StrikeSchedule? capRateSchedule, StrikeSchedule? floorRateSchedule, _MetaFields? meta, ReferenceWithMetaFloatingRateOption? rateOption, SpreadSchedule? spreadSchedule)
        {
            CapRateSchedule = capRateSchedule;
            FloorRateSchedule = floorRateSchedule;
            Meta = meta;
            RateOption = rateOption;
            SpreadSchedule = spreadSchedule;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FloatingRateBase> MetaData => metaData;
        
        /// <inheritdoc/>
        public StrikeSchedule? CapRateSchedule { get; }
        
        /// <inheritdoc/>
        public StrikeSchedule? FloorRateSchedule { get; }
        
        public _MetaFields? Meta { get; }
        
        public ReferenceWithMetaFloatingRateOption? RateOption { get; }
        
        /// <inheritdoc/>
        public SpreadSchedule? SpreadSchedule { get; }
    }
    
    /// <summary>
    /// Defines the structures needed to represent the calculation parameters for daily averaged and compounded modular rates as defined in the 2021 ISDA Definitions in Section 7. This type is used to represent modular computed rates in interestRatePayouts.
    /// </summary>
    public class FloatingRateCalculationParameters : AbstractRosettaModelObject<FloatingRateCalculationParameters>
    {
        private static readonly IRosettaMetaData<FloatingRateCalculationParameters> metaData = new FloatingRateCalculationParametersMeta();
        
        [JsonConstructor]
        public FloatingRateCalculationParameters(BusinessCenters? applicableBusinessDays, Enums.CalculationMethod calculationMethod, OffsetCalculation? lockoutCalculation, OffsetCalculation? lookbackCalculation, ObservationParameters? observationParameters, ObservationShiftCalculation? observationShiftCalculation)
        {
            ApplicableBusinessDays = applicableBusinessDays;
            CalculationMethod = calculationMethod;
            LockoutCalculation = lockoutCalculation;
            LookbackCalculation = lookbackCalculation;
            ObservationParameters = observationParameters;
            ObservationShiftCalculation = observationShiftCalculation;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FloatingRateCalculationParameters> MetaData => metaData;
        
        /// <summary>
        /// the business days that are applicable for the calculation.
        /// </summary>
        public BusinessCenters? ApplicableBusinessDays { get; }
        
        /// <summary>
        /// calculation type (averaging or compounding).
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CalculationMethod CalculationMethod { get; }
        
        /// <summary>
        /// any lockout  parameters if applicable.
        /// </summary>
        public OffsetCalculation? LockoutCalculation { get; }
        
        /// <summary>
        /// any lookback  parameters if applicable.
        /// </summary>
        public OffsetCalculation? LookbackCalculation { get; }
        
        /// <summary>
        ///  any applicable observation parameters, such as daily caps or floors.
        /// </summary>
        public ObservationParameters? ObservationParameters { get; }
        
        /// <summary>
        /// any obervation shift parameters if applicable.
        /// </summary>
        public ObservationShiftCalculation? ObservationShiftCalculation { get; }
    }
    
    /// <summary>
    /// A data defining:  parameters associated with a floating rate reset. This data forms:  part of the cashflows representation of a stream.
    /// </summary>
    public class FloatingRateDefinition : AbstractRosettaModelObject<FloatingRateDefinition>
    {
        private static readonly IRosettaMetaData<FloatingRateDefinition> metaData = new FloatingRateDefinitionMeta();
        
        [JsonConstructor]
        public FloatingRateDefinition(decimal? calculatedRate, IEnumerable<Strike> capRate, decimal? floatingRateMultiplier, IEnumerable<Strike> floorRate, IEnumerable<RateObservation> rateObservation, decimal? spread)
        {
            CalculatedRate = calculatedRate;
            CapRate = capRate;
            FloatingRateMultiplier = floatingRateMultiplier;
            FloorRate = floorRate;
            RateObservation = rateObservation;
            Spread = spread;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FloatingRateDefinition> MetaData => metaData;
        
        /// <summary>
        /// The final calculated rate for a calculation period after any required averaging of rates A calculated rate of 5% would be represented as 0.05.
        /// </summary>
        public decimal? CalculatedRate { get; }
        
        /// <summary>
        /// The cap rate, if any, which applies to the floating rate for the calculation period. The cap rate (strike) is only required where the floating rate on a swap stream is capped at a certain strike level. The cap rate is assumed to be exclusive of any spread and is a per annum rate, expressed as a decimal. A cap rate of 5% would be represented as 0.05.
        /// </summary>
        public IEnumerable<Strike> CapRate { get; }
        
        /// <summary>
        /// A rate multiplier to apply to the floating rate. The multiplier can be a positive or negative decimal. This element should only be included if the multiplier is not equal to 1 (one).
        /// </summary>
        public decimal? FloatingRateMultiplier { get; }
        
        /// <summary>
        /// The floor rate, if any, which applies to the floating rate for the calculation period. The floor rate (strike) is only required where the floating rate on a swap stream is floored at a certain strike level. The floor rate is assumed to be exclusive of any spread and is a per annum rate, expressed as a decimal. The floor rate of 5% would be represented as 0.05.
        /// </summary>
        public IEnumerable<Strike> FloorRate { get; }
        
        /// <summary>
        /// The details of a particular rate observation, including the fixing date and observed rate. A list of rate observation elements may be ordered in the document by ascending adjusted fixing date. An FpML document containing an unordered list of rate observations is still regarded as a conformant document.
        /// </summary>
        public IEnumerable<RateObservation> RateObservation { get; }
        
        /// <summary>
        /// The ISDA Spread, if any, which applies for the calculation period. The spread is a per annum rate, expressed as a decimal. For purposes of determining a calculation period amount, if positive the spread will be added to the floating rate and if negative the spread will be subtracted from the floating rate. A positive 10 basis point (0.1%) spread would be represented as 0.001.
        /// </summary>
        public decimal? Spread { get; }
    }
    
    /// <summary>
    /// This holds the rate calculation defaults applicable for a floating rate index.
    /// </summary>
    public class FloatingRateIndexCalculationDefaults : AbstractRosettaModelObject<FloatingRateIndexCalculationDefaults>
    {
        private static readonly IRosettaMetaData<FloatingRateIndexCalculationDefaults> metaData = new FloatingRateIndexCalculationDefaultsMeta();
        
        [JsonConstructor]
        public FloatingRateIndexCalculationDefaults(Enums.FloatingRateIndexCategory? category, Enums.FloatingRateIndexStyle? indexStyle, Enums.FloatingRateIndexCalculationMethod? method)
        {
            Category = category;
            IndexStyle = indexStyle;
            Method = method;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FloatingRateIndexCalculationDefaults> MetaData => metaData;
        
        /// <summary>
        /// The ISDA FRO category (e.g. screen rate or calculated rate).
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.FloatingRateIndexCategory? Category { get; }
        
        /// <summary>
        /// The ISDA FRO style (e.g. term rate, swap rate, etc).
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.FloatingRateIndexStyle? IndexStyle { get; }
        
        /// <summary>
        /// The ISDA FRO calculation method (e.g. OIS Compounding).
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.FloatingRateIndexCalculationMethod? Method { get; }
    }
    
    public class FloatingRateIndexDefinition : AbstractRosettaModelObject<FloatingRateIndexDefinition>
    {
        private static readonly IRosettaMetaData<FloatingRateIndexDefinition> metaData = new FloatingRateIndexDefinitionMeta();
        
        [JsonConstructor]
        public FloatingRateIndexDefinition(FloatingRateIndexCalculationDefaults? calculationDefaults, FloatingRateIndexIdentification fro)
        {
            CalculationDefaults = calculationDefaults;
            Fro = fro;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FloatingRateIndexDefinition> MetaData => metaData;
        
        /// <summary>
        /// Any calculation default values.
        /// </summary>
        public FloatingRateIndexCalculationDefaults? CalculationDefaults { get; }
        
        /// <summary>
        /// The underlying FRO name and designated maturity.
        /// </summary>
        public FloatingRateIndexIdentification Fro { get; }
    }
    
    public class FloatingRateIndexIdentification : AbstractRosettaModelObject<FloatingRateIndexIdentification>
    {
        private static readonly IRosettaMetaData<FloatingRateIndexIdentification> metaData = new FloatingRateIndexIdentificationMeta();
        
        [JsonConstructor]
        public FloatingRateIndexIdentification(Enums.ISOCurrencyCode? currency, FieldWithMetaFloatingRateIndexEnum? floatingRateIndex, string? froType)
        {
            Currency = currency;
            FloatingRateIndex = floatingRateIndex;
            FroType = froType;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FloatingRateIndexIdentification> MetaData => metaData;
        
        /// <summary>
        /// FRO currency - 3 character ISO currrency code
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.ISOCurrencyCode? Currency { get; }
        
        /// <summary>
        /// The reference index that is used to specify the floating interest rate. The FpML standard maintains the list of such indices, which are positioned as enumeration values as part of the CDM.
        /// </summary>
        public FieldWithMetaFloatingRateIndexEnum? FloatingRateIndex { get; }
        
        /// <summary>
        /// FRO type (e.g. OIS)
        /// </summary>
        public string? FroType { get; }
    }
    
    /// <summary>
    /// Specification of a floating rate option as a floating rate index and tenor.
    /// </summary>
    public class FloatingRateOption : AbstractRosettaModelObject<FloatingRateOption>
    {
        private static readonly IRosettaMetaData<FloatingRateOption> metaData = new FloatingRateOptionMeta();
        
        [JsonConstructor]
        public FloatingRateOption(FieldWithMetaFloatingRateIndexEnum? floatingRateIndex, Period? indexTenor, FieldWithMetaInflationRateIndexEnum? inflationRateIndex)
        {
            FloatingRateIndex = floatingRateIndex;
            IndexTenor = indexTenor;
            InflationRateIndex = inflationRateIndex;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FloatingRateOption> MetaData => metaData;
        
        /// <summary>
        /// The reference index that is used to specify the floating interest rate. The FpML standard maintains the list of such indices, which are positioned as enumeration values as part of the CDM.
        /// </summary>
        public FieldWithMetaFloatingRateIndexEnum? FloatingRateIndex { get; }
        
        /// <summary>
        /// The ISDA Designated Maturity, i.e. the floating rate tenor.
        /// </summary>
        public Period? IndexTenor { get; }
        
        /// <summary>
        /// The reference index that is used to specify the inflation interest rate. The FpML standard maintains the list of such indices, which are positioned as enumeration values as part of the CDM.
        /// </summary>
        public FieldWithMetaInflationRateIndexEnum? InflationRateIndex { get; }
    }
    
    /// <summary>
    /// Type for reporting the details of the rate treatment.  This could potentially be replaced by the existing FloatingRateDefinition type , but this is slightly more detailed.
    /// </summary>
    public class FloatingRateProcessingDetails : AbstractRosettaModelObject<FloatingRateProcessingDetails>
    {
        private static readonly IRosettaMetaData<FloatingRateProcessingDetails> metaData = new FloatingRateProcessingDetailsMeta();
        
        [JsonConstructor]
        public FloatingRateProcessingDetails(decimal processedRate, FloatingRateProcessingParameters? processingParameters, decimal rawRate, decimal spreadExclusiveRate)
        {
            ProcessedRate = processedRate;
            ProcessingParameters = processingParameters;
            RawRate = rawRate;
            SpreadExclusiveRate = spreadExclusiveRate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FloatingRateProcessingDetails> MetaData => metaData;
        
        /// <summary>
        /// The value of the rate after processing.
        /// </summary>
        public decimal ProcessedRate { get; }
        
        public FloatingRateProcessingParameters? ProcessingParameters { get; }
        
        /// <summary>
        /// The raw or untreated rate, prior to any of the rate treatments.
        /// </summary>
        public decimal RawRate { get; }
        
        /// <summary>
        /// The value of the processed rate without the spread applied, for subsequent compounding, etc.
        /// </summary>
        public decimal SpreadExclusiveRate { get; }
    }
    
    /// <summary>
    /// Type to hold the processing parameters that should be or were used to calculate a floating amount.  These parameters can vary over a schedule so this type holds the acutal values applicable to this calculation.
    /// </summary>
    public class FloatingRateProcessingParameters : AbstractRosettaModelObject<FloatingRateProcessingParameters>
    {
        private static readonly IRosettaMetaData<FloatingRateProcessingParameters> metaData = new FloatingRateProcessingParametersMeta();
        
        [JsonConstructor]
        public FloatingRateProcessingParameters(decimal? capRate, decimal? floorRate, Price? initialRate, decimal? multiplier, Enums.NegativeInterestRateTreatment? negativeTreatment, Rounding? rounding, decimal? spread, Enums.RateTreatment? treatment)
        {
            CapRate = capRate;
            FloorRate = floorRate;
            InitialRate = initialRate;
            Multiplier = multiplier;
            NegativeTreatment = negativeTreatment;
            Rounding = rounding;
            Spread = spread;
            Treatment = treatment;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FloatingRateProcessingParameters> MetaData => metaData;
        
        /// <summary>
        /// capt to be applied to the floating rate.
        /// </summary>
        public decimal? CapRate { get; }
        
        /// <summary>
        /// floor to be applied to the floating rate.
        /// </summary>
        public decimal? FloorRate { get; }
        
        /// <summary>
        /// The rate to be applied for the initial period.
        /// </summary>
        public Price? InitialRate { get; }
        
        /// <summary>
        /// floating rate multiplier.
        /// </summary>
        public decimal? Multiplier { get; }
        
        /// <summary>
        /// How to handle negative interest rates.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.NegativeInterestRateTreatment? NegativeTreatment { get; }
        
        /// <summary>
        /// THe final rate rounding to be applied.
        /// </summary>
        public Rounding? Rounding { get; }
        
        /// <summary>
        /// spread to be added to the floating rate.
        /// </summary>
        public decimal? Spread { get; }
        
        /// <summary>
        /// US rate treatment (Bond Equivalent Yield or Money Market Yield, if applicable.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.RateTreatment? Treatment { get; }
    }
    
    /// <summary>
    /// Type for reporting the raw (untreated) observed or calculated rate for a calculation period.  If this is a calculated rate, it allows details of the observations and the resulting rate to be returned.
    /// </summary>
    public class FloatingRateSettingDetails : AbstractRosettaModelObject<FloatingRateSettingDetails>
    {
        private static readonly IRosettaMetaData<FloatingRateSettingDetails> metaData = new FloatingRateSettingDetailsMeta();
        
        [JsonConstructor]
        public FloatingRateSettingDetails(CalculatedRateDetails? calculationDetails, decimal floatingRate, LocalDate? observationDate, LocalDate? resetDate)
        {
            CalculationDetails = calculationDetails;
            FloatingRate = floatingRate;
            ObservationDate = observationDate;
            ResetDate = resetDate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FloatingRateSettingDetails> MetaData => metaData;
        
        /// <summary>
        /// Calculated rate details (observation dates, values, and weights).
        /// </summary>
        public CalculatedRateDetails? CalculationDetails { get; }
        
        /// <summary>
        /// The resulting rate that was observed or calculated.
        /// </summary>
        public decimal FloatingRate { get; }
        
        /// <summary>
        /// The day upon which the rate was observed (for term rates).
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? ObservationDate { get; }
        
        /// <summary>
        /// The day for which the rate is needed (e.g. period beginning or end date).
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? ResetDate { get; }
    }
    
    /// <summary>
    /// A class to specify the floating interest rate by extending the floating rate definition with a set of attributes that specify such rate: the initial value specified as part of the trade, the rounding convention, the averaging method and the negative interest rate treatment.
    /// </summary>
    public class FloatingRateSpecification : AbstractRosettaModelObject<FloatingRateSpecification>, IFloatingRateSpecification, IFloatingRate
    {
        private static readonly IRosettaMetaData<FloatingRateSpecification> metaData = new FloatingRateSpecificationMeta();
        
        [JsonConstructor]
        public FloatingRateSpecification(Enums.AveragingWeightingMethod? averagingMethod, Rounding? finalRateRounding, Price? initialRate, Enums.NegativeInterestRateTreatment? negativeInterestRateTreatment, FloatingRateCalculationParameters? calculationParameters, FallbackRateParameters? fallbackRate, RateSchedule? floatingRateMultiplierSchedule, Enums.RateTreatment? rateTreatment, StrikeSchedule? capRateSchedule, StrikeSchedule? floorRateSchedule, _MetaFields? meta, ReferenceWithMetaFloatingRateOption? rateOption, SpreadSchedule? spreadSchedule)
        {
            AveragingMethod = averagingMethod;
            FinalRateRounding = finalRateRounding;
            InitialRate = initialRate;
            NegativeInterestRateTreatment = negativeInterestRateTreatment;
            CalculationParameters = calculationParameters;
            FallbackRate = fallbackRate;
            FloatingRateMultiplierSchedule = floatingRateMultiplierSchedule;
            RateTreatment = rateTreatment;
            CapRateSchedule = capRateSchedule;
            FloorRateSchedule = floorRateSchedule;
            Meta = meta;
            RateOption = rateOption;
            SpreadSchedule = spreadSchedule;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FloatingRateSpecification> MetaData => metaData;
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.AveragingWeightingMethod? AveragingMethod { get; }
        
        /// <inheritdoc/>
        public Rounding? FinalRateRounding { get; }
        
        /// <inheritdoc/>
        public Price? InitialRate { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.NegativeInterestRateTreatment? NegativeInterestRateTreatment { get; }
        
        /// <inheritdoc/>
        public FloatingRateCalculationParameters? CalculationParameters { get; }
        
        /// <inheritdoc/>
        public FallbackRateParameters? FallbackRate { get; }
        
        /// <inheritdoc/>
        public RateSchedule? FloatingRateMultiplierSchedule { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.RateTreatment? RateTreatment { get; }
        
        /// <inheritdoc/>
        public StrikeSchedule? CapRateSchedule { get; }
        
        /// <inheritdoc/>
        public StrikeSchedule? FloorRateSchedule { get; }
        
        public _MetaFields? Meta { get; }
        
        public ReferenceWithMetaFloatingRateOption? RateOption { get; }
        
        /// <inheritdoc/>
        public SpreadSchedule? SpreadSchedule { get; }
    }
    
    /// <summary>
    /// From FpML: A type defining either a spot or forward FX transactions.
    /// </summary>
    public class ForeignExchange : AbstractRosettaModelObject<ForeignExchange>
    {
        private static readonly IRosettaMetaData<ForeignExchange> metaData = new ForeignExchangeMeta();
        
        [JsonConstructor]
        public ForeignExchange(ExchangeRate? exchangeRate, Cashflow exchangedCurrency1, Cashflow exchangedCurrency2, Period? tenorPeriod)
        {
            ExchangeRate = exchangeRate;
            ExchangedCurrency1 = exchangedCurrency1;
            ExchangedCurrency2 = exchangedCurrency2;
            TenorPeriod = tenorPeriod;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ForeignExchange> MetaData => metaData;
        
        /// <summary>
        /// The rate of exchange between the two currencies.
        /// </summary>
        public ExchangeRate? ExchangeRate { get; }
        
        /// <summary>
        /// This is the first of the two currency flows that define a single leg of a standard foreign exchange transaction.
        /// </summary>
        public Cashflow ExchangedCurrency1 { get; }
        
        /// <summary>
        /// This is the second of the two currency flows that define a single leg of a standard foreign exchange transaction.
        /// </summary>
        public Cashflow ExchangedCurrency2 { get; }
        
        /// <summary>
        /// A tenor expressed as a period type and multiplier (e.g. 1D, 1Y, etc.)
        /// </summary>
        public Period? TenorPeriod { get; }
    }
    
    /// <summary>
    /// Represents a forward settling payout. The underlier attribute captures the underlying payout, which is settled according to the settlementTerms attribute (which is part of PayoutBase). Both FX Spot and FX Forward should use this component.
    /// </summary>
    public class ForwardPayout : AbstractRosettaModelObject<ForwardPayout>, IPayoutBase
    {
        private static readonly IRosettaMetaData<ForwardPayout> metaData = new ForwardPayoutMeta();
        
        [JsonConstructor]
        public ForwardPayout(_MetaFields? meta, Product underlier, PayerReceiver payerReceiver, ResolvablePriceQuantity? priceQuantity, PrincipalPayments? principalPayment, SettlementTerms? settlementTerms)
        {
            Meta = meta;
            Underlier = underlier;
            PayerReceiver = payerReceiver;
            PriceQuantity = priceQuantity;
            PrincipalPayment = principalPayment;
            SettlementTerms = settlementTerms;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ForwardPayout> MetaData => metaData;
        
        public _MetaFields? Meta { get; }
        
        /// <summary>
        /// Underlying product that the forward is written on, which can be of any type: FX, a contractual product, a security, etc.
        /// </summary>
        public Product Underlier { get; }
        
        /// <inheritdoc/>
        public PayerReceiver PayerReceiver { get; }
        
        /// <inheritdoc/>
        public ResolvablePriceQuantity? PriceQuantity { get; }
        
        /// <inheritdoc/>
        public PrincipalPayments? PrincipalPayment { get; }
        
        /// <inheritdoc/>
        public SettlementTerms? SettlementTerms { get; }
    }
    
    /// <summary>
    /// A class for defining a date frequency, e.g. one day, three months, through the combination of an integer value and a standardized period value that is specified as part of an enumeration.
    /// </summary>
    public class Frequency : AbstractRosettaModelObject<Frequency>, IFrequency
    {
        private static readonly IRosettaMetaData<Frequency> metaData = new FrequencyMeta();
        
        [JsonConstructor]
        public Frequency(_MetaFields? meta, Enums.PeriodExtended period, int periodMultiplier)
        {
            Meta = meta;
            Period = period;
            PeriodMultiplier = periodMultiplier;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Frequency> MetaData => metaData;
        
        public _MetaFields? Meta { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.PeriodExtended Period { get; }
        
        /// <inheritdoc/>
        public int PeriodMultiplier { get; }
    }
    
    /// <summary>
    /// A class defining a currency and a future value date.
    /// </summary>
    public class FutureValueAmount : AbstractRosettaModelObject<FutureValueAmount>
    {
        private static readonly IRosettaMetaData<FutureValueAmount> metaData = new FutureValueAmountMeta();
        
        [JsonConstructor]
        public FutureValueAmount(int calculationPeriodNumberOfDays, FieldWithMetaString currency, ReferenceWithMetaNonNegativeQuantitySchedule? quantity, LocalDate valueDate)
        {
            CalculationPeriodNumberOfDays = calculationPeriodNumberOfDays;
            Currency = currency;
            Quantity = quantity;
            ValueDate = valueDate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FutureValueAmount> MetaData => metaData;
        
        /// <summary>
        /// The number of days from the adjusted calculation period start date to the adjusted value date, calculated in accordance with the applicable day count fraction.
        /// </summary>
        public int CalculationPeriodNumberOfDays { get; }
        
        /// <summary>
        /// The currency in which the an amount is denominated. The list of valid currencies is not presently positioned as an enumeration as part of the CDM because that scope is limited to the values specified by ISDA and FpML. As a result, implementers have to make reference to the relevant standard, such as the ISO 4217 standard for currency codes.
        /// </summary>
        public FieldWithMetaString Currency { get; }
        
        public ReferenceWithMetaNonNegativeQuantitySchedule? Quantity { get; }
        
        /// <summary>
        /// Adjusted value date of the future value amount.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate ValueDate { get; }
    }
    
    /// <summary>
    /// A type for defining FX Features.
    /// </summary>
    public class FxFeature : AbstractRosettaModelObject<FxFeature>
    {
        private static readonly IRosettaMetaData<FxFeature> metaData = new FxFeatureMeta();
        
        [JsonConstructor]
        public FxFeature(Composite? composite, Composite? crossCurrency, Quanto? quanto, FieldWithMetaString referenceCurrency)
        {
            Composite = composite;
            CrossCurrency = crossCurrency;
            Quanto = quanto;
            ReferenceCurrency = referenceCurrency;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FxFeature> MetaData => metaData;
        
        /// <summary>
        /// If &apos;Composite&apos; is specified as the Settlement Type in the relevant Transaction Supplement, an amount in the Settlement Currency, determined by the Calculation Agent as being equal to the number of Options exercised or deemed exercised, multiplied by: (Settlement Price – Strike Price) / (Strike Price – Settlement Price) x Multiplier provided that if the above is equal to a negative amount the Option Cash Settlement Amount shall be deemed to be zero.
        /// </summary>
        public Composite? Composite { get; }
        
        /// <summary>
        /// If &apos;Cross-Currency&apos; is specified as the Settlement Type in the relevant Transaction Supplement, an amount in the Settlement Currency, determined by the Calculation Agent as being equal to the number of Options exercised or deemed exercised, multiplied by: (Settlement Price – Strike Price) / (Strike Price – Settlement Price) x Multiplier x one unit of the Reference Currency converted into an amount in the Settlement Currency using the rate of exchange of the Settlement Currency as quoted on the Reference Price Source on the Valuation Date, provided that if the above is equal to a negative amount the Option Cash Settlement Amount shall be deemed to be zero.
        /// </summary>
        public Composite? CrossCurrency { get; }
        
        /// <summary>
        /// If &apos;Quanto&apos; is specified as the Settlement Type in the relevant Transaction Supplement, an amount, as determined by the Calculation Agent in accordance with the Section 8.2 of the Equity Definitions.
        /// </summary>
        public Quanto? Quanto { get; }
        
        /// <summary>
        /// Specifies the reference currency of the trade.
        /// </summary>
        public FieldWithMetaString ReferenceCurrency { get; }
    }
    
    /// <summary>
    /// Extends the Offset structure to specify an FX fixing date as an offset to dates specified somewhere else in the document.
    /// </summary>
    public class FxFixingDate : AbstractRosettaModelObject<FxFixingDate>, IOffset
    {
        private static readonly IRosettaMetaData<FxFixingDate> metaData = new FxFixingDateMeta();
        
        [JsonConstructor]
        public FxFixingDate(BusinessCenters? businessCenters, ReferenceWithMetaBusinessCenters? businessCentersReference, Enums.BusinessDayConvention? businessDayConvention, DateRelativeToCalculationPeriodDates? dateRelativeToCalculationPeriodDates, DateRelativeToPaymentDates? dateRelativeToPaymentDates, DateRelativeToValuationDates? dateRelativeToValuationDates, AdjustableOrRelativeDate? fxFixingDate, Enums.DayType? dayType, _MetaFields? meta, Enums.Period period, int periodMultiplier)
        {
            BusinessCenters = businessCenters;
            BusinessCentersReference = businessCentersReference;
            BusinessDayConvention = businessDayConvention;
            DateRelativeToCalculationPeriodDates = dateRelativeToCalculationPeriodDates;
            DateRelativeToPaymentDates = dateRelativeToPaymentDates;
            DateRelativeToValuationDates = dateRelativeToValuationDates;
            FxFixingDateValue = fxFixingDate;
            DayType = dayType;
            Meta = meta;
            PeriodValue = period;
            PeriodMultiplier = periodMultiplier;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FxFixingDate> MetaData => metaData;
        
        public BusinessCenters? BusinessCenters { get; }
        
        /// <summary>
        /// A reference to a set of financial business centers defined elsewhere in the document. This set of business centers is used to determine whether a particular day is a business day or not.
        /// </summary>
        public ReferenceWithMetaBusinessCenters? BusinessCentersReference { get; }
        
        /// <summary>
        /// The convention for adjusting a date if it would otherwise fall on a day that is not a business day, as specified by an ISDA convention (e.g. Following, Precedent).
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.BusinessDayConvention? BusinessDayConvention { get; }
        
        /// <summary>
        /// The calculation period references on which settlements in non-deliverable currency are due and will then have to be converted according to the terms specified through the other parts of the nonDeliverableSettlement structure. Implemented for Brazilian-CDI swaps where it will refer to the termination date of the appropriate leg.
        /// </summary>
        public DateRelativeToCalculationPeriodDates? DateRelativeToCalculationPeriodDates { get; }
        
        /// <summary>
        /// The payment date references on which settlements in non-deliverable currency are due and will then have to be converted according to the terms specified through the other parts of the nonDeliverableSettlement structure.
        /// </summary>
        public DateRelativeToPaymentDates? DateRelativeToPaymentDates { get; }
        
        /// <summary>
        /// The calculation period references on which settlements in non-deliverable currency are due and will then have to be converted according to the terms specified through the other parts of the nonDeliverableSettlement structure. Implemented for Brazilian-CDI swaps where it will refer to the termination date of the appropriate leg.
        /// </summary>
        public DateRelativeToValuationDates? DateRelativeToValuationDates { get; }
        
        /// <summary>
        /// Describes the specific date when a non-deliverable forward or cash-settled option will &apos;fix&apos; against a particular rate, which will be used to compute the ultimate cash settlement. This element should be omitted where a single, discrete fixing date cannot be identified e.g. on an american option, where fixing may occur at any date on a continuous range.  This attribute was formerly part of &apos;fxSettlementTerms&apos;, which is now being harmonised into a common &apos;CashSettlementTerms&apos; that includes a &apos;ValuationDate&apos;.
        /// </summary>
        [JsonProperty(PropertyName = "fxFixingDate")]
        public AdjustableOrRelativeDate? FxFixingDateValue { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.DayType? DayType { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        [JsonProperty(PropertyName = "period")]
        public Enums.Period PeriodValue { get; }
        
        /// <inheritdoc/>
        public int PeriodMultiplier { get; }
    }
    
    /// <summary>
    /// Information source specific to Foreign Exchange products.
    /// </summary>
    public class FxInformationSource : AbstractRosettaModelObject<FxInformationSource>, IInformationSource
    {
        private static readonly IRosettaMetaData<FxInformationSource> metaData = new FxInformationSourceMeta();
        
        [JsonConstructor]
        public FxInformationSource(BusinessCenterTime? fixingTime, FieldWithMetaString? sourcePage, string? sourcePageHeading, FieldWithMetaInformationProviderEnum sourceProvider)
        {
            FixingTime = fixingTime;
            SourcePage = sourcePage;
            SourcePageHeading = sourcePageHeading;
            SourceProvider = sourceProvider;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FxInformationSource> MetaData => metaData;
        
        /// <summary>
        /// The time that the fixing will be taken along with a business center to define the time zone.
        /// </summary>
        public BusinessCenterTime? FixingTime { get; }
        
        /// <inheritdoc/>
        public FieldWithMetaString? SourcePage { get; }
        
        /// <inheritdoc/>
        public string? SourcePageHeading { get; }
        
        /// <inheritdoc/>
        public FieldWithMetaInformationProviderEnum SourceProvider { get; }
    }
    
    /// <summary>
    /// A data to:  describe the cashflow representation for FX linked notionals.
    /// </summary>
    public class FxLinkedNotionalAmount : AbstractRosettaModelObject<FxLinkedNotionalAmount>
    {
        private static readonly IRosettaMetaData<FxLinkedNotionalAmount> metaData = new FxLinkedNotionalAmountMeta();
        
        [JsonConstructor]
        public FxLinkedNotionalAmount(LocalDate? adjustedFxSpotFixingDate, decimal? notionalAmount, decimal? observedFxSpotRate, LocalDate? resetDate)
        {
            AdjustedFxSpotFixingDate = adjustedFxSpotFixingDate;
            NotionalAmount = notionalAmount;
            ObservedFxSpotRate = observedFxSpotRate;
            ResetDate = resetDate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FxLinkedNotionalAmount> MetaData => metaData;
        
        /// <summary>
        /// The date on which the FX spot rate is observed. This date should already be adjusted for any applicable business day convention.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? AdjustedFxSpotFixingDate { get; }
        
        /// <summary>
        /// The calculation period notional amount.
        /// </summary>
        public decimal? NotionalAmount { get; }
        
        /// <summary>
        /// The actual observed FX spot rate.
        /// </summary>
        public decimal? ObservedFxSpotRate { get; }
        
        /// <summary>
        /// The reset date.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? ResetDate { get; }
    }
    
    /// <summary>
    /// A data to:  describe a notional schedule where each notional that applies to a calculation period is calculated with reference to a notional amount or notional amount schedule in a different currency by means of a spot currency exchange rate which is normally observed at the beginning of each period.
    /// </summary>
    public class FxLinkedNotionalSchedule : AbstractRosettaModelObject<FxLinkedNotionalSchedule>
    {
        private static readonly IRosettaMetaData<FxLinkedNotionalSchedule> metaData = new FxLinkedNotionalScheduleMeta();
        
        [JsonConstructor]
        public FxLinkedNotionalSchedule(BusinessCenterTime? fixingTime, FxSpotRateSource fxSpotRateSource, FieldWithMetaString varyingNotionalCurrency, RelativeDateOffset varyingNotionalFixingDates, RelativeDateOffset varyingNotionalInterimExchangePaymentDates)
        {
            FixingTime = fixingTime;
            FxSpotRateSource = fxSpotRateSource;
            VaryingNotionalCurrency = varyingNotionalCurrency;
            VaryingNotionalFixingDates = varyingNotionalFixingDates;
            VaryingNotionalInterimExchangePaymentDates = varyingNotionalInterimExchangePaymentDates;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FxLinkedNotionalSchedule> MetaData => metaData;
        
        /// <summary>
        /// The time at which the spot currency exchange rate will be observed. It is specified as a time in a business day calendar location, e.g. 11:00am London time.
        /// </summary>
        public BusinessCenterTime? FixingTime { get; }
        
        /// <summary>
        /// The information source and time at which the spot currency exchange rate will be observed.
        /// </summary>
        public FxSpotRateSource FxSpotRateSource { get; }
        
        /// <summary>
        /// The currency of the varying notional amount, i.e. the notional amount being determined periodically based on observation of a spot currency exchange rate. The list of valid currencies is not presently positioned as an enumeration as part of the CDM because that scope is limited to the values specified by ISDA and FpML. As a result, implementers have to make reference to the relevant standard, such as the ISO 4217 standard for currency codes.
        /// </summary>
        public FieldWithMetaString VaryingNotionalCurrency { get; }
        
        /// <summary>
        /// The dates on which spot currency exchange rates are observed for purposes of determining the varying notional currency amount that will apply to a calculation period.
        /// </summary>
        public RelativeDateOffset VaryingNotionalFixingDates { get; }
        
        /// <summary>
        /// The dates on which interim exchanges of notional are paid. Interim exchanges will arise as a result of changes in the spot currency exchange amount or changes in the constant notional schedule (e.g. amortisation).
        /// </summary>
        public RelativeDateOffset VaryingNotionalInterimExchangePaymentDates { get; }
    }
    
    /// <summary>
    /// A class describing the rate of a currency conversion: pair of currency, quotation mode and exchange rate.
    /// </summary>
    public class FxRate : AbstractRosettaModelObject<FxRate>
    {
        private static readonly IRosettaMetaData<FxRate> metaData = new FxRateMeta();
        
        [JsonConstructor]
        public FxRate(QuotedCurrencyPair quotedCurrencyPair, decimal? rate)
        {
            QuotedCurrencyPair = quotedCurrencyPair;
            Rate = rate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FxRate> MetaData => metaData;
        
        /// <summary>
        /// Defines the two currencies for an FX trade and the quotation relationship between the two currencies.
        /// </summary>
        public QuotedCurrencyPair QuotedCurrencyPair { get; }
        
        /// <summary>
        /// The rate of exchange between the two currencies of the leg of a deal. Must be specified with a quote basis.
        /// </summary>
        public decimal? Rate { get; }
    }
    
    /// <summary>
    /// Defines foreign exchange (FX) asset class specific parameters for market observations.
    /// </summary>
    public class FxRateObservable : AbstractRosettaModelObject<FxRateObservable>
    {
        private static readonly IRosettaMetaData<FxRateObservable> metaData = new FxRateObservableMeta();
        
        [JsonConstructor]
        public FxRateObservable(InformationSource primaryFxSpotRateSource, ReferenceWithMetaQuotedCurrencyPair quotedCurrencyPair, InformationSource? secondaryFxSpotRateSource)
        {
            PrimaryFxSpotRateSource = primaryFxSpotRateSource;
            QuotedCurrencyPair = quotedCurrencyPair;
            SecondaryFxSpotRateSource = secondaryFxSpotRateSource;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FxRateObservable> MetaData => metaData;
        
        /// <summary>
        /// Specifies the primary source from which a rate should be observed.
        /// </summary>
        public InformationSource PrimaryFxSpotRateSource { get; }
        
        /// <summary>
        /// Describes the composition of a rate that has been quoted or is to be quoted.
        /// </summary>
        public ReferenceWithMetaQuotedCurrencyPair QuotedCurrencyPair { get; }
        
        /// <summary>
        /// Specifies an alternative, or secondary, source from which a rate should be observed.
        /// </summary>
        public InformationSource? SecondaryFxSpotRateSource { get; }
    }
    
    /// <summary>
    /// Describes a rate source to be fixed and the date the fixing occurs
    /// </summary>
    public class FxRateSourceFixing : AbstractRosettaModelObject<FxRateSourceFixing>
    {
        private static readonly IRosettaMetaData<FxRateSourceFixing> metaData = new FxRateSourceFixingMeta();
        
        [JsonConstructor]
        public FxRateSourceFixing(AdjustableDate fixingDate, FxSettlementRateSource settlementRateSource)
        {
            FixingDate = fixingDate;
            SettlementRateSource = settlementRateSource;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FxRateSourceFixing> MetaData => metaData;
        
        /// <summary>
        /// The date on which the fixing is scheduled to occur.
        /// </summary>
        public AdjustableDate FixingDate { get; }
        
        public FxSettlementRateSource SettlementRateSource { get; }
    }
    
    /// <summary>
    /// The source of the Foreign Exchange settlement rate.
    /// </summary>
    public class FxSettlementRateSource : AbstractRosettaModelObject<FxSettlementRateSource>
    {
        private static readonly IRosettaMetaData<FxSettlementRateSource> metaData = new FxSettlementRateSourceMeta();
        
        [JsonConstructor]
        public FxSettlementRateSource(FxInformationSource? nonstandardSettlementRate, FieldWithMetaString? settlementRateOption)
        {
            NonstandardSettlementRate = nonstandardSettlementRate;
            SettlementRateOption = settlementRateOption;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FxSettlementRateSource> MetaData => metaData;
        
        /// <summary>
        /// Indicates that a non-standard rate source will be used for the fixing.
        /// </summary>
        public FxInformationSource? NonstandardSettlementRate { get; }
        
        /// <summary>
        /// Indicates that an officially defined rate settlement rate option will be the used for the fixing.
        /// </summary>
        public FieldWithMetaString? SettlementRateOption { get; }
    }
    
    /// <summary>
    /// A class defining the rate source and fixing time for an FX rate.
    /// </summary>
    public class FxSpotRateSource : AbstractRosettaModelObject<FxSpotRateSource>
    {
        private static readonly IRosettaMetaData<FxSpotRateSource> metaData = new FxSpotRateSourceMeta();
        
        [JsonConstructor]
        public FxSpotRateSource(InformationSource primarySource, InformationSource? secondarySource)
        {
            PrimarySource = primarySource;
            SecondarySource = secondarySource;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FxSpotRateSource> MetaData => metaData;
        
        /// <summary>
        /// The primary source for where the rate observation will occur. Will typically be either a page or a reference bank published rate.
        /// </summary>
        public InformationSource PrimarySource { get; }
        
        /// <summary>
        /// An alternative, or secondary, source for where the rate observation will occur. Will typically be either a page or a reference bank published rate.
        /// </summary>
        public InformationSource? SecondarySource { get; }
    }
    
    /// <summary>
    ///  A class specifying a set of non-monetary terms for the Credit Derivative Transaction, including the buyer and seller and selected items from the ISDA 2014 Credit Definition article II, such as the reference obligation and related terms. The CDM GeneralTerms class corresponds to the FpML GeneralTerms complex type, except that the effectiveDate and scheduledTerminationDate have been positioned as part of the InterestRatePayout class in the CDM instead of in GeneralTerms.
    /// </summary>
    public class GeneralTerms : AbstractRosettaModelObject<GeneralTerms>
    {
        private static readonly IRosettaMetaData<GeneralTerms> metaData = new GeneralTermsMeta();
        
        [JsonConstructor]
        public GeneralTerms(IEnumerable<FieldWithMetaString> additionalTerm, BasketReferenceInformation? basketReferenceInformation, IndexReferenceInformation? indexReferenceInformation, bool? modifiedEquityDelivery, ReferenceInformation? referenceInformation, bool? substitution)
        {
            AdditionalTerm = additionalTerm;
            BasketReferenceInformation = basketReferenceInformation;
            IndexReferenceInformation = indexReferenceInformation;
            ModifiedEquityDelivery = modifiedEquityDelivery;
            ReferenceInformation = referenceInformation;
            Substitution = substitution;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<GeneralTerms> MetaData => metaData;
        
        /// <summary>
        /// This attribute is used for representing information contained in the Additional Terms field of the 2003 Master Credit Derivatives confirm.
        /// </summary>
        public IEnumerable<FieldWithMetaString> AdditionalTerm { get; }
        
        /// <summary>
        /// This attribute contains all the terms relevant to defining the Credit Default Swap Basket.
        /// </summary>
        public BasketReferenceInformation? BasketReferenceInformation { get; }
        
        /// <summary>
        /// This attribute contains all the terms relevant to defining the Credit DefaultSwap Index.
        /// </summary>
        public IndexReferenceInformation? IndexReferenceInformation { get; }
        
        /// <summary>
        /// Value of this attribute set to &apos;true&apos; indicates that modified equity delivery is applicable.
        /// </summary>
        public bool? ModifiedEquityDelivery { get; }
        
        /// <summary>
        /// This attribute contains all the terms relevant to defining the reference entity and reference obligation(s).
        /// </summary>
        public ReferenceInformation? ReferenceInformation { get; }
        
        /// <summary>
        /// Value of this attribute set to &apos;true&apos; indicates that substitution is applicable.
        /// </summary>
        public bool? Substitution { get; }
    }
    
    public class GracePeriodExtension : AbstractRosettaModelObject<GracePeriodExtension>
    {
        private static readonly IRosettaMetaData<GracePeriodExtension> metaData = new GracePeriodExtensionMeta();
        
        [JsonConstructor]
        public GracePeriodExtension(bool applicable, Offset? gracePeriod)
        {
            Applicable = applicable;
            GracePeriod = gracePeriod;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<GracePeriodExtension> MetaData => metaData;
        
        /// <summary>
        /// Indicates whether the grace period extension provision is applicable.
        /// </summary>
        public bool Applicable { get; }
        
        /// <summary>
        /// The number of calendar or business days after any due date that the reference entity has to fulfil its obligations before a failure to pay credit event is deemed to have occurred. ISDA 2003 Term: Grace Period.
        /// </summary>
        public Offset? GracePeriod { get; }
    }
    
    public class Id : AbstractRosettaModelObject<Id>
    {
        private static readonly IRosettaMetaData<Id> metaData = new IdMeta();
        
        [JsonConstructor]
        public Id(string lei)
        {
            Lei = lei;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Id> MetaData => metaData;
        
        public string Lei { get; }
    }
    
    /// <summary>
    /// Attaches an identifier to a collection of objects, when those objects themselves can each be represented by an identifier. One use case is the representation of package transactions, where each component is a separate trade with its own identifier, and those trades are linked together as a package with its own identifier. The data type has been named generically rather than referring to &apos;packages&apos; as it may have a number of other uses.
    /// </summary>
    public class IdentifiedList : AbstractRosettaModelObject<IdentifiedList>
    {
        private static readonly IRosettaMetaData<IdentifiedList> metaData = new IdentifiedListMeta();
        
        [JsonConstructor]
        public IdentifiedList(IEnumerable<Identifier> componentId, Identifier listId, _MetaFields? meta, Price? price)
        {
            ComponentId = componentId;
            ListId = listId;
            Meta = meta;
            Price = price;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<IdentifiedList> MetaData => metaData;
        
        /// <summary>
        /// Identifiers for each component of the list. Since the data type is used to link multiple identified objects together, at least 2 components are required in the list. Creating an identified list with only 1 identified component has been deemed unnecessary, because it would just create a redundant identifier.
        /// </summary>
        public IEnumerable<Identifier> ComponentId { get; }
        
        /// <summary>
        /// The identifier for the list. In the case of a package transaction, this would be the package identifier. This attribute is mandatory to allow the list itself to be identified.
        /// </summary>
        public Identifier ListId { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <summary>
        /// The price of the package.
        /// </summary>
        public Price? Price { get; }
    }
    
    /// <summary>
    /// An abstract class to specify a product which terms are abstracted through reference data.
    /// </summary>
    public class IdentifiedProduct : AbstractRosettaModelObject<IdentifiedProduct>, IIdentifiedProduct
    {
        private static readonly IRosettaMetaData<IdentifiedProduct> metaData = new IdentifiedProductMeta();
        
        [JsonConstructor]
        public IdentifiedProduct(ProductIdentifier productIdentifier)
        {
            ProductIdentifier = productIdentifier;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<IdentifiedProduct> MetaData => metaData;
        
        public ProductIdentifier ProductIdentifier { get; }
    }
    
    /// <summary>
    /// A class to specify a generic identifier, applicable to CDM artefacts such as executions, contracts, lifecycle events and legal documents. An issuer can be associated with the actual identifier value as a way to properly qualify it.
    /// </summary>
    public class Identifier : AbstractRosettaModelObject<Identifier>, IIdentifier
    {
        private static readonly IRosettaMetaData<Identifier> metaData = new IdentifierMeta();
        
        [JsonConstructor]
        public Identifier(IEnumerable<AssignedIdentifier> assignedIdentifier, FieldWithMetaString? issuer, ReferenceWithMetaParty? issuerReference, _MetaFields? meta)
        {
            AssignedIdentifier = assignedIdentifier;
            Issuer = issuer;
            IssuerReference = issuerReference;
            Meta = meta;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Identifier> MetaData => metaData;
        
        /// <inheritdoc/>
        public IEnumerable<AssignedIdentifier> AssignedIdentifier { get; }
        
        /// <inheritdoc/>
        public FieldWithMetaString? Issuer { get; }
        
        /// <inheritdoc/>
        public ReferenceWithMetaParty? IssuerReference { get; }
        
        public _MetaFields? Meta { get; }
    }
    
    /// <summary>
    /// A class specifying the Independent Amount as the combination of a payer/receiver, a payment amount, a payment date and an associated payment calculation rule.
    /// </summary>
    public class IndependentAmount : AbstractRosettaModelObject<IndependentAmount>, IPartyReferencePayerReceiver
    {
        private static readonly IRosettaMetaData<IndependentAmount> metaData = new IndependentAmountMeta();
        
        [JsonConstructor]
        public IndependentAmount(IEnumerable<PaymentDetail> paymentDetail, ReferenceWithMetaAccount? payerAccountReference, ReferenceWithMetaParty payerPartyReference, ReferenceWithMetaAccount? receiverAccountReference, ReferenceWithMetaParty receiverPartyReference)
        {
            PaymentDetail = paymentDetail;
            PayerAccountReference = payerAccountReference;
            PayerPartyReference = payerPartyReference;
            ReceiverAccountReference = receiverAccountReference;
            ReceiverPartyReference = receiverPartyReference;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<IndependentAmount> MetaData => metaData;
        
        /// <summary>
        /// An attribute that specifies a payment as the combination of a payment amount, a payment date and an associated payment calculation rule.
        /// </summary>
        public IEnumerable<PaymentDetail> PaymentDetail { get; }
        
        /// <inheritdoc/>
        public ReferenceWithMetaAccount? PayerAccountReference { get; }
        
        /// <inheritdoc/>
        public ReferenceWithMetaParty PayerPartyReference { get; }
        
        /// <inheritdoc/>
        public ReferenceWithMetaAccount? ReceiverAccountReference { get; }
        
        /// <inheritdoc/>
        public ReferenceWithMetaParty ReceiverPartyReference { get; }
    }
    
    /// <summary>
    /// Identifies an index by referencing a product identifier.
    /// </summary>
    public class Index : AbstractRosettaModelObject<Index>, IProductBase
    {
        private static readonly IRosettaMetaData<Index> metaData = new IndexMeta();
        
        [JsonConstructor]
        public Index(IEnumerable<ReferenceWithMetaProductIdentifier> productIdentifier, IEnumerable<ProductTaxonomy> productTaxonomy)
        {
            ProductIdentifier = productIdentifier;
            ProductTaxonomy = productTaxonomy;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Index> MetaData => metaData;
        
        /// <inheritdoc/>
        public IEnumerable<ReferenceWithMetaProductIdentifier> ProductIdentifier { get; }
        
        /// <inheritdoc/>
        public IEnumerable<ProductTaxonomy> ProductTaxonomy { get; }
    }
    
    /// <summary>
    /// Defines the specification of the consequences of Index Events as defined by the 2002 ISDA Equity Derivatives Definitions.
    /// </summary>
    public class IndexAdjustmentEvents : AbstractRosettaModelObject<IndexAdjustmentEvents>
    {
        private static readonly IRosettaMetaData<IndexAdjustmentEvents> metaData = new IndexAdjustmentEventsMeta();
        
        [JsonConstructor]
        public IndexAdjustmentEvents(Enums.IndexEventConsequence indexCancellation, Enums.IndexEventConsequence indexDisruption, Enums.IndexEventConsequence indexModification)
        {
            IndexCancellation = indexCancellation;
            IndexDisruption = indexDisruption;
            IndexModification = indexModification;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<IndexAdjustmentEvents> MetaData => metaData;
        
        /// <summary>
        /// Consequence of index cancellation.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.IndexEventConsequence IndexCancellation { get; }
        
        /// <summary>
        /// Consequence of index disruption.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.IndexEventConsequence IndexDisruption { get; }
        
        /// <summary>
        /// Consequence of index modification.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.IndexEventConsequence IndexModification { get; }
    }
    
    /// <summary>
    /// A class defining a Credit Default Swap Index.
    /// </summary>
    public class IndexReferenceInformation : AbstractRosettaModelObject<IndexReferenceInformation>
    {
        private static readonly IRosettaMetaData<IndexReferenceInformation> metaData = new IndexReferenceInformationMeta();
        
        [JsonConstructor]
        public IndexReferenceInformation(IEnumerable<ReferenceInformation> excludedReferenceEntity, LocalDate? indexAnnexDate, FieldWithMetaIndexAnnexSourceEnum? indexAnnexSource, int? indexAnnexVersion, decimal? indexFactor, IEnumerable<FieldWithMetaString> indexId, FieldWithMetaString? indexName, int? indexSeries, _MetaFields? meta, Enums.CreditSeniority? seniority, SettledEntityMatrix? settledEntityMatrix, Tranche? tranche)
        {
            ExcludedReferenceEntity = excludedReferenceEntity;
            IndexAnnexDate = indexAnnexDate;
            IndexAnnexSource = indexAnnexSource;
            IndexAnnexVersion = indexAnnexVersion;
            IndexFactor = indexFactor;
            IndexId = indexId;
            IndexName = indexName;
            IndexSeries = indexSeries;
            Meta = meta;
            Seniority = seniority;
            SettledEntityMatrix = settledEntityMatrix;
            Tranche = tranche;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<IndexReferenceInformation> MetaData => metaData;
        
        /// <summary>
        /// Excluded reference entity.
        /// </summary>
        public IEnumerable<ReferenceInformation> ExcludedReferenceEntity { get; }
        
        /// <summary>
        /// A CDS index series annex date.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? IndexAnnexDate { get; }
        
        /// <summary>
        /// A CDS index series annex source.
        /// </summary>
        public FieldWithMetaIndexAnnexSourceEnum? IndexAnnexSource { get; }
        
        /// <summary>
        /// A CDS index series version identifier, e.g. 1, 2, 3 etc.
        /// </summary>
        public int? IndexAnnexVersion { get; }
        
        /// <summary>
        /// Index Factor is the index version factor or percent, expressed as an absolute decimal value between 0 and 1, that multiplied by the original notional amount yields the notional amount covered by the seller of protection.
        /// </summary>
        public decimal? IndexFactor { get; }
        
        /// <summary>
        /// A CDS index identifier (e.g. RED pair code).
        /// </summary>
        public IEnumerable<FieldWithMetaString> IndexId { get; }
        
        /// <summary>
        /// The name of the index expressed as a free format string with an associated scheme.
        /// </summary>
        public FieldWithMetaString? IndexName { get; }
        
        /// <summary>
        /// A CDS index series identifier, e.g. 1, 2, 3 etc.
        /// </summary>
        public int? IndexSeries { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <summary>
        /// Seniority of debt instruments comprising the index.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CreditSeniority? Seniority { get; }
        
        /// <summary>
        /// Used to specify the Relevant Settled Entity Matrix when there are settled entities at the time of the trade.
        /// </summary>
        public SettledEntityMatrix? SettledEntityMatrix { get; }
        
        /// <summary>
        /// This element contains CDS tranche terms.
        /// </summary>
        public Tranche? Tranche { get; }
    }
    
    /// <summary>
    /// Defines the information needed to create a Index Transition Business Event.
    /// </summary>
    public class IndexTransitionInstruction : AbstractRosettaModelObject<IndexTransitionInstruction>
    {
        private static readonly IRosettaMetaData<IndexTransitionInstruction> metaData = new IndexTransitionInstructionMeta();
        
        [JsonConstructor]
        public IndexTransitionInstruction(Transfer? cashTransfer, LocalDate effectiveDate, IEnumerable<PriceQuantity> priceQuantity)
        {
            CashTransfer = cashTransfer;
            EffectiveDate = effectiveDate;
            PriceQuantity = priceQuantity;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<IndexTransitionInstruction> MetaData => metaData;
        
        /// <summary>
        /// Specifies the cash transfer that can optionally be tied to an index transition event.
        /// </summary>
        public Transfer? CashTransfer { get; }
        
        /// <summary>
        /// Specifies the effective date of the index transition event. This is first date on which the floating rate calculation will use the new floating rate index and adjusted spread in the floating rate calculation.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate EffectiveDate { get; }
        
        /// <summary>
        /// Specifies both new floating rate index and spread adjustment for each leg to be updated.  The spread adjustment accounts for the difference between the old floating rate index relative to the new one. This spread amount is added to the existing spread to determine the new spread, which is applied from the specified effective date forward. In the case of the IBOR Fallback Rate Adjustments, the adjustment spread (also known as the Fallback Adjustment) accounts for two distinctions: i) the fact that the replacement Risk-Free Rate is an overnight rate while IBORs have term structures (e.g., 1, 3, 6-month LIBOR); and (ii) the historical spread differential between IBORs and their term equivalent Overnight Risk-Free Rate compounded rates.
        /// </summary>
        public IEnumerable<PriceQuantity> PriceQuantity { get; }
    }
    
    public class Indx : AbstractRosettaModelObject<Indx>
    {
        private static readonly IRosettaMetaData<Indx> metaData = new IndxMeta();
        
        [JsonConstructor]
        public Indx(Nm nm)
        {
            Nm = nm;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Indx> MetaData => metaData;
        
        public Nm Nm { get; }
    }
    
    /// <summary>
    /// A data to:  specify the inflation rate.
    /// </summary>
    public class InflationRateSpecification : AbstractRosettaModelObject<InflationRateSpecification>, IFloatingRateSpecification
    {
        private static readonly IRosettaMetaData<InflationRateSpecification> metaData = new InflationRateSpecificationMeta();
        
        [JsonConstructor]
        public InflationRateSpecification(Enums.InflationCalculationMethod? calculationMethod, Enums.InflationCalculationStyle? calculationStyle, bool fallbackBondApplicable, FieldWithMetaString indexSource, Offset inflationLag, decimal? initialIndexLevel, FieldWithMetaInterpolationMethodEnum interpolationMethod, FieldWithMetaString mainPublication, Enums.AveragingWeightingMethod? averagingMethod, Rounding? finalRateRounding, Price? initialRate, Enums.NegativeInterestRateTreatment? negativeInterestRateTreatment, FloatingRateCalculationParameters? calculationParameters, FallbackRateParameters? fallbackRate, RateSchedule? floatingRateMultiplierSchedule, Enums.RateTreatment? rateTreatment, StrikeSchedule? capRateSchedule, StrikeSchedule? floorRateSchedule, _MetaFields? meta, ReferenceWithMetaFloatingRateOption? rateOption, SpreadSchedule? spreadSchedule)
        {
            CalculationMethod = calculationMethod;
            CalculationStyle = calculationStyle;
            FallbackBondApplicable = fallbackBondApplicable;
            IndexSource = indexSource;
            InflationLag = inflationLag;
            InitialIndexLevel = initialIndexLevel;
            InterpolationMethod = interpolationMethod;
            MainPublication = mainPublication;
            AveragingMethod = averagingMethod;
            FinalRateRounding = finalRateRounding;
            InitialRate = initialRate;
            NegativeInterestRateTreatment = negativeInterestRateTreatment;
            CalculationParameters = calculationParameters;
            FallbackRate = fallbackRate;
            FloatingRateMultiplierSchedule = floatingRateMultiplierSchedule;
            RateTreatment = rateTreatment;
            CapRateSchedule = capRateSchedule;
            FloorRateSchedule = floorRateSchedule;
            Meta = meta;
            RateOption = rateOption;
            SpreadSchedule = spreadSchedule;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<InflationRateSpecification> MetaData => metaData;
        
        /// <summary>
        /// Indicates how to use the inflation index to calculate the payment (e.g. Ratio, Return, Spread). Added for Inflation Asset Swap
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.InflationCalculationMethod? CalculationMethod { get; }
        
        /// <summary>
        /// Indicates the style of how the inflation index calculates the payment (e.g. YearOnYear, ZeroCoupon).
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.InflationCalculationStyle? CalculationStyle { get; }
        
        /// <summary>
        /// The applicability of a fallback bond as defined in the 2006 ISDA Inflation Derivatives Definitions, sections 1.3 and 1.8.
        /// </summary>
        public bool FallbackBondApplicable { get; }
        
        /// <summary>
        /// The reference source such as Reuters or Bloomberg. FpML specifies indexSource to be of type rateSourcePageScheme, but without specifying actual values.
        /// </summary>
        public FieldWithMetaString IndexSource { get; }
        
        /// <summary>
        /// An off-setting period from the payment date which determines the reference period for which the inflation index is observed.
        /// </summary>
        public Offset InflationLag { get; }
        
        /// <summary>
        /// Initial known index level for the first calculation period.
        /// </summary>
        public decimal? InitialIndexLevel { get; }
        
        /// <summary>
        /// The method used when calculating the Inflation Index Level from multiple points. The most common is Linear.
        /// </summary>
        public FieldWithMetaInterpolationMethodEnum InterpolationMethod { get; }
        
        /// <summary>
        /// The current main publication source such as relevant web site or a government body. FpML specifies mainPublication to be of type mainPublicationSource, but without specifying actual values.
        /// </summary>
        public FieldWithMetaString MainPublication { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.AveragingWeightingMethod? AveragingMethod { get; }
        
        /// <inheritdoc/>
        public Rounding? FinalRateRounding { get; }
        
        /// <inheritdoc/>
        public Price? InitialRate { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.NegativeInterestRateTreatment? NegativeInterestRateTreatment { get; }
        
        /// <inheritdoc/>
        public FloatingRateCalculationParameters? CalculationParameters { get; }
        
        /// <inheritdoc/>
        public FallbackRateParameters? FallbackRate { get; }
        
        /// <inheritdoc/>
        public RateSchedule? FloatingRateMultiplierSchedule { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.RateTreatment? RateTreatment { get; }
        
        /// <inheritdoc/>
        public StrikeSchedule? CapRateSchedule { get; }
        
        /// <inheritdoc/>
        public StrikeSchedule? FloorRateSchedule { get; }
        
        public _MetaFields? Meta { get; }
        
        public ReferenceWithMetaFloatingRateOption? RateOption { get; }
        
        /// <inheritdoc/>
        public SpreadSchedule? SpreadSchedule { get; }
    }
    
    /// <summary>
    /// A class defining the source for a piece of information (e.g. a rate fix or an FX fixing). The attribute names have been adjusted from FpML to address the fact that the information is not limited to rates.
    /// </summary>
    public class InformationSource : AbstractRosettaModelObject<InformationSource>, IInformationSource
    {
        private static readonly IRosettaMetaData<InformationSource> metaData = new InformationSourceMeta();
        
        [JsonConstructor]
        public InformationSource(FieldWithMetaString? sourcePage, string? sourcePageHeading, FieldWithMetaInformationProviderEnum sourceProvider)
        {
            SourcePage = sourcePage;
            SourcePageHeading = sourcePageHeading;
            SourceProvider = sourceProvider;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<InformationSource> MetaData => metaData;
        
        /// <inheritdoc/>
        public FieldWithMetaString? SourcePage { get; }
        
        /// <inheritdoc/>
        public string? SourcePageHeading { get; }
        
        /// <inheritdoc/>
        public FieldWithMetaInformationProviderEnum SourceProvider { get; }
    }
    
    /// <summary>
    /// A CDM class which purpose is to specify the initial fixing date either alongside the FpML interest rate specification as an offset of another date, or alongside the credit derivative specification as an unadjusted date.
    /// </summary>
    public class InitialFixingDate : AbstractRosettaModelObject<InitialFixingDate>
    {
        private static readonly IRosettaMetaData<InitialFixingDate> metaData = new InitialFixingDateMeta();
        
        [JsonConstructor]
        public InitialFixingDate(LocalDate? initialFixingDate, RelativeDateOffset? relativeDateOffset)
        {
            InitialFixingDateValue = initialFixingDate;
            RelativeDateOffset = relativeDateOffset;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<InitialFixingDate> MetaData => metaData;
        
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        [JsonProperty(PropertyName = "initialFixingDate")]
        public LocalDate? InitialFixingDateValue { get; }
        
        public RelativeDateOffset? RelativeDateOffset { get; }
    }
    
    /// <summary>
    ///  Defines initial margin applied to a repo transaction. Initial margin is an agreed premium to the Purchase Price of a repo to determine the required Market Value of the collateral to be delivered on the Purchase Date. It reflects quality of the collateral. Its aim is to calculate the risk-adjusted or liquidation value of collateral.
    /// </summary>
    public class InitialMargin : AbstractRosettaModelObject<InitialMargin>
    {
        private static readonly IRosettaMetaData<InitialMargin> metaData = new InitialMarginMeta();
        
        [JsonConstructor]
        public InitialMargin(IEnumerable<InitialMarginCalculation> margin, Money? marginThreshold, Enums.MarginType marginType, Money? minimumTransferAmount)
        {
            Margin = margin;
            MarginThreshold = marginThreshold;
            MarginType = marginType;
            MinimumTransferAmount = minimumTransferAmount;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<InitialMargin> MetaData => metaData;
        
        /// <summary>
        /// Initial margin calculation for a collateral asset. Initial margin requirements may be specified for multiple pieces of collateral.
        /// </summary>
        public IEnumerable<InitialMarginCalculation> Margin { get; }
        
        /// <summary>
        /// An element defining a margin threshold which is the Net Exposure of a trade below which parties agree they will not call a margin from each other.
        /// </summary>
        public Money? MarginThreshold { get; }
        
        /// <summary>
        /// An element defining the type of assets (cash or securities) specified to apply as margin to the repo transaction. See GMRA 2011 paragraph 2(h) for &apos;Cash Margin&apos; and GMRA 2011 paragraph 2(cc) for &apos;Margin Securities&apos;.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.MarginType MarginType { get; }
        
        /// <summary>
        /// An element defining a minimum transfer amount which is the minimum margin call parties will make once the margin threshold (or margin ratio threshold / haircut threshold) has been exceeded.
        /// </summary>
        public Money? MinimumTransferAmount { get; }
    }
    
    /// <summary>
    ///  Defines the initial margin calculation applicable to a single piece of collateral.
    /// </summary>
    public class InitialMarginCalculation : AbstractRosettaModelObject<InitialMarginCalculation>
    {
        private static readonly IRosettaMetaData<InitialMarginCalculation> metaData = new InitialMarginCalculationMeta();
        
        [JsonConstructor]
        public InitialMarginCalculation(decimal? haircut, IEnumerable<decimal> haircutThreshold, decimal? marginRatio, IEnumerable<decimal> marginRatioThreshold)
        {
            Haircut = haircut;
            HaircutThreshold = haircutThreshold;
            MarginRatio = marginRatio;
            MarginRatioThreshold = marginRatioThreshold;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<InitialMarginCalculation> MetaData => metaData;
        
        /// <summary>
        /// An element defining a haircut expressed as the percentage difference between the Market Value of the collateral and the Purchase Price of the repo and calculated as 100 multiplied by a ratio of the difference between the Market Value of the collateral and the Purchase Price of the repo to the Market Value of the collateral. Haircut is alternative way to adjust the value of collateral sold in a repurchase agreement to initial margin ratio. Because an initial margin is a percentage of the Purchase Price, while a haircut is a percentage of the Market Value of collateral, the arithmetic of initial margins and haircuts is slightly different. For example, an initial margin of 102% is not equivalent to a haircut of 2%, but to 1.961% (ie 100/102%). See GMRA 2011 paragraph 2(aa).
        /// </summary>
        public decimal? Haircut { get; }
        
        /// <summary>
        /// An element defining a haircut percentage threshold which is the value above (when it&apos;s lower than initial haircut) or below (when it&apos;s higher than initial haircut) which parties agree they will not call a margin from each other.
        /// </summary>
        public IEnumerable<decimal> HaircutThreshold { get; }
        
        /// <summary>
        /// An element defining an initial margin expressed as a ratio of the Market Value of the collateral to the Purchase Price. A default value of initial margin ratio of 1.00 means there is no margin and thus no risk related with the collateral. See GMRA 2000 paragraph 2(z) and GMRA 2011 paragraph 2(bb).
        /// </summary>
        public decimal? MarginRatio { get; }
        
        /// <summary>
        /// An element defining a margin ratio threshold which is the value above (when it&apos;s lower than initial margin ratio) or below (when it&apos;s higher than initial margin ratio) which parties agree they will not call a margin from each other.
        /// </summary>
        public IEnumerable<decimal> MarginRatioThreshold { get; }
    }
    
    /// <summary>
    /// Instruction to a function that will be used to perform a business event
    /// </summary>
    public class Instruction : AbstractRosettaModelObject<Instruction>
    {
        private static readonly IRosettaMetaData<Instruction> metaData = new InstructionMeta();
        
        [JsonConstructor]
        public Instruction(ReferenceWithMetaTradeState? before, PrimitiveInstruction? primitiveInstruction)
        {
            Before = before;
            PrimitiveInstruction = primitiveInstruction;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Instruction> MetaData => metaData;
        
        /// <summary>
        /// Specifies the trade state that will be acted on by the primitive event functions.
        /// </summary>
        public ReferenceWithMetaTradeState? Before { get; }
        
        /// <summary>
        /// Specifies the primitive instructions that will be used to call primitive event functions.
        /// </summary>
        public PrimitiveInstruction? PrimitiveInstruction { get; }
    }
    
    /// <summary>
    /// A class to specify the application of Interest Amount with respect to the Delivery Amount and the Return Amount.
    /// </summary>
    public class InterestAmountApplication : AbstractRosettaModelObject<InterestAmountApplication>
    {
        private static readonly IRosettaMetaData<InterestAmountApplication> metaData = new InterestAmountApplicationMeta();
        
        [JsonConstructor]
        public InterestAmountApplication(DeliveryAmount deliveryAmount, ReturnAmount returnAmount)
        {
            DeliveryAmount = deliveryAmount;
            ReturnAmount = returnAmount;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<InterestAmountApplication> MetaData => metaData;
        
        /// <summary>
        /// The application of Interest Amount with respect the Delivery Amount.
        /// </summary>
        public DeliveryAmount DeliveryAmount { get; }
        
        /// <summary>
        /// The application of Interest Amount with respect the Return Amount.
        /// </summary>
        public ReturnAmount ReturnAmount { get; }
    }
    
    public class InterestRateCurve : AbstractRosettaModelObject<InterestRateCurve>
    {
        private static readonly IRosettaMetaData<InterestRateCurve> metaData = new InterestRateCurveMeta();
        
        [JsonConstructor]
        public InterestRateCurve(FieldWithMetaFloatingRateIndexEnum floatingRateIndex, Period tenor)
        {
            FloatingRateIndex = floatingRateIndex;
            Tenor = tenor;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<InterestRateCurve> MetaData => metaData;
        
        public FieldWithMetaFloatingRateIndexEnum FloatingRateIndex { get; }
        
        public Period Tenor { get; }
    }
    
    /// <summary>
    ///  A class to specify all of the terms necessary to define and calculate a cash flow based on a fixed, a floating or an inflation index rate. The interest rate payout can be applied to interest rate swaps and FRA (which both have two associated interest rate payouts), credit default swaps (to represent the fee leg when subject to periodic payments) and equity swaps (to represent the funding leg). The associated globalKey denotes the ability to associate a hash value to the InterestRatePayout instantiations for the purpose of model cross-referencing, in support of functionality such as the event effect and the lineage.
    /// </summary>
    public class InterestRatePayout : AbstractRosettaModelObject<InterestRatePayout>, IPayoutBase
    {
        private static readonly IRosettaMetaData<InterestRatePayout> metaData = new InterestRatePayoutMeta();
        
        [JsonConstructor]
        public InterestRatePayout(BondReference? bondReference, CalculationPeriodDates? calculationPeriodDates, CashflowRepresentation? cashflowRepresentation, Enums.CompoundingMethod? compoundingMethod, FieldWithMetaDayCountFractionEnum? dayCountFraction, DiscountingMethod? discountingMethod, string? fixedAmount, string? floatingAmount, _MetaFields? meta, AdjustableDate? paymentDate, PaymentDates? paymentDates, bool? paymentDelay, RateSpecification? rateSpecification, ResetDates? resetDates, StubPeriod? stubPeriod, PayerReceiver payerReceiver, ResolvablePriceQuantity? priceQuantity, PrincipalPayments? principalPayment, SettlementTerms? settlementTerms)
        {
            BondReference = bondReference;
            CalculationPeriodDates = calculationPeriodDates;
            CashflowRepresentation = cashflowRepresentation;
            CompoundingMethod = compoundingMethod;
            DayCountFraction = dayCountFraction;
            DiscountingMethod = discountingMethod;
            FixedAmount = fixedAmount;
            FloatingAmount = floatingAmount;
            Meta = meta;
            PaymentDate = paymentDate;
            PaymentDates = paymentDates;
            PaymentDelay = paymentDelay;
            RateSpecification = rateSpecification;
            ResetDates = resetDates;
            StubPeriod = stubPeriod;
            PayerReceiver = payerReceiver;
            PriceQuantity = priceQuantity;
            PrincipalPayment = principalPayment;
            SettlementTerms = settlementTerms;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<InterestRatePayout> MetaData => metaData;
        
        /// <summary>
        /// Reference to a bond underlier to represent an asset swap or Condition Precedent Bond.
        /// </summary>
        public BondReference? BondReference { get; }
        
        /// <summary>
        /// The parameters used to generate the calculation period dates schedule, including the specification of any initial or final stub calculation periods.
        /// </summary>
        public CalculationPeriodDates? CalculationPeriodDates { get; }
        
        /// <summary>
        /// The cashflow representation of the swap stream.
        /// </summary>
        public CashflowRepresentation? CashflowRepresentation { get; }
        
        /// <summary>
        /// If one or more calculation period contributes to a single payment amount this element specifies whether compounding is applicable and, if so, what compounding method is to be used. This element must only be included when more than one calculation period contributes to a single payment amount.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CompoundingMethod? CompoundingMethod { get; }
        
        /// <summary>
        /// The day count fraction. The cardinality has been relaxed when compared with the FpML interest rate swap for the purpose of accommodating standardized credit default swaps which DCF is not explicitly stated as part of the economic terms. The data rule InterestRatePayout_dayCountFraction requires that the DCF be stated for interest rate products.
        /// </summary>
        public FieldWithMetaDayCountFractionEnum? DayCountFraction { get; }
        
        /// <summary>
        /// The parameters specifying any discounting conventions that may apply. This element must only be included if discounting applies.
        /// </summary>
        public DiscountingMethod? DiscountingMethod { get; }
        
        /// <summary>
        /// Fixed Amount Calculation
        /// </summary>
        public string? FixedAmount { get; }
        
        /// <summary>
        /// Floating Amount Calculation
        /// </summary>
        public string? FloatingAmount { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <summary>
        /// The payment date, where only one date is specified, as for the FRA product.
        /// </summary>
        public AdjustableDate? PaymentDate { get; }
        
        /// <summary>
        /// The payment date schedule, as defined by the parameters that are needed to specify it, either in a parametric way or by reference to another schedule of dates (e.g. the reset dates).
        /// </summary>
        public PaymentDates? PaymentDates { get; }
        
        /// <summary>
        /// Applicable to CDS on MBS to specify whether payment delays are applicable to the fixed Amount. RMBS typically have a payment delay of 5 days between the coupon date of the reference obligation and the payment date of the synthetic swap. CMBS do not, on the other hand, with both payment dates being on the 25th of each month.
        /// </summary>
        public bool? PaymentDelay { get; }
        
        /// <summary>
        /// The specification of the rate value(s) applicable to the contract using either a floating rate calculation, a single fixed rate, a fixed rate schedule, or an inflation rate calculation.
        /// </summary>
        public RateSpecification? RateSpecification { get; }
        
        /// <summary>
        /// The reset dates schedule, i.e. the dates on which the new observed index value is applied for each period and the interest rate hence begins to accrue.
        /// </summary>
        public ResetDates? ResetDates { get; }
        
        /// <summary>
        /// The stub calculation period amount parameters. This element must only be included if there is an initial or final stub calculation period. Even then, it must only be included if either the stub references a different floating rate tenor to the regular calculation periods, or if the stub is calculated as a linear interpolation of two different floating rate tenors, or if a specific stub rate or stub amount has been negotiated.
        /// </summary>
        public StubPeriod? StubPeriod { get; }
        
        /// <inheritdoc/>
        public PayerReceiver PayerReceiver { get; }
        
        /// <inheritdoc/>
        public ResolvablePriceQuantity? PriceQuantity { get; }
        
        /// <inheritdoc/>
        public PrincipalPayments? PrincipalPayment { get; }
        
        /// <inheritdoc/>
        public SettlementTerms? SettlementTerms { get; }
    }
    
    /// <summary>
    /// A class to specify the interest shortfall floating rate payment event.
    /// </summary>
    public class InterestShortFall : AbstractRosettaModelObject<InterestShortFall>
    {
        private static readonly IRosettaMetaData<InterestShortFall> metaData = new InterestShortFallMeta();
        
        [JsonConstructor]
        public InterestShortFall(bool compounding, Enums.InterestShortfallCap interestShortfallCap, FieldWithMetaFloatingRateIndexEnum? rateSource)
        {
            Compounding = compounding;
            InterestShortfallCap = interestShortfallCap;
            RateSource = rateSource;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<InterestShortFall> MetaData => metaData;
        
        public bool Compounding { get; }
        
        /// <summary>
        /// Specifies the nature of the interest Shortfall cap (i.e. Fixed Cap or Variable Cap) in the case where it is applicable. ISDA 2003 Term: Interest Shortfall Cap.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.InterestShortfallCap InterestShortfallCap { get; }
        
        /// <summary>
        /// The rate source in the case of a variable cap.
        /// </summary>
        public FieldWithMetaFloatingRateIndexEnum? RateSource { get; }
    }
    
    public class InvstmtDcsnPrsn : AbstractRosettaModelObject<InvstmtDcsnPrsn>
    {
        private static readonly IRosettaMetaData<InvstmtDcsnPrsn> metaData = new InvstmtDcsnPrsnMeta();
        
        [JsonConstructor]
        public InvstmtDcsnPrsn(Prsn prsn)
        {
            Prsn = prsn;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<InvstmtDcsnPrsn> MetaData => metaData;
        
        public Prsn Prsn { get; }
    }
    
    /// <summary>
    /// Represents a criteria used to specify eligible collateral issuers.
    /// </summary>
    public class IssuerCriteria : AbstractRosettaModelObject<IssuerCriteria>
    {
        private static readonly IRosettaMetaData<IssuerCriteria> metaData = new IssuerCriteriaMeta();
        
        [JsonConstructor]
        public IssuerCriteria(bool? counterpartyOwnIssuePermitted, IEnumerable<AgencyRatingCriteria> issuerAgencyRating, IEnumerable<FieldWithMetaString> issuerCountryOfOrigin, IEnumerable<LegalEntity> issuerName, IEnumerable<CollateralIssuerType> issuerType, IEnumerable<AgencyRatingCriteria> sovereignAgencyRating)
        {
            CounterpartyOwnIssuePermitted = counterpartyOwnIssuePermitted;
            IssuerAgencyRating = issuerAgencyRating;
            IssuerCountryOfOrigin = issuerCountryOfOrigin;
            IssuerName = issuerName;
            IssuerType = issuerType;
            SovereignAgencyRating = sovereignAgencyRating;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<IssuerCriteria> MetaData => metaData;
        
        /// <summary>
        /// Represents a filter based on whether it is permitted for the underlying asset to be issued by the posting entity or part of their corporate family.
        /// </summary>
        public bool? CounterpartyOwnIssuePermitted { get; }
        
        /// <summary>
        /// Represents an agency rating based on default risk and creditors claim in event of default associated with asset issuer.
        /// </summary>
        public IEnumerable<AgencyRatingCriteria> IssuerAgencyRating { get; }
        
        /// <summary>
        /// Represents a filter based on the issuing entity country of origin, which is the same as filtering by eligible Sovereigns.
        /// </summary>
        public IEnumerable<FieldWithMetaString> IssuerCountryOfOrigin { get; }
        
        /// <summary>
        /// Specifies the issuing entity name or LEI.
        /// </summary>
        public IEnumerable<LegalEntity> IssuerName { get; }
        
        /// <summary>
        /// Represents a filter based on the type of entity issuing the asset.
        /// </summary>
        public IEnumerable<CollateralIssuerType> IssuerType { get; }
        
        /// <summary>
        /// Represents an agency rating based on default risk of the country of the issuer.
        /// </summary>
        public IEnumerable<AgencyRatingCriteria> SovereignAgencyRating { get; }
    }
    
    /// <summary>
    /// Knock In means option to exercise comes into existence. Knock Out means option to exercise goes out of existence.
    /// </summary>
    public class Knock : AbstractRosettaModelObject<Knock>
    {
        private static readonly IRosettaMetaData<Knock> metaData = new KnockMeta();
        
        [JsonConstructor]
        public Knock(TriggerEvent? knockIn, TriggerEvent? knockOut)
        {
            KnockIn = knockIn;
            KnockOut = knockOut;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Knock> MetaData => metaData;
        
        /// <summary>
        /// The knock in.
        /// </summary>
        public TriggerEvent? KnockIn { get; }
        
        /// <summary>
        /// The knock out.
        /// </summary>
        public TriggerEvent? KnockOut { get; }
    }
    
    /// <summary>
    /// The pricing period per calculation period if the pricing days do not wholly fall within the respective calculation period.
    /// </summary>
    public class Lag : AbstractRosettaModelObject<Lag>
    {
        private static readonly IRosettaMetaData<Lag> metaData = new LagMeta();
        
        [JsonConstructor]
        public Lag(Offset? firstObservationDateOffset, Offset lagDuration)
        {
            FirstObservationDateOffset = firstObservationDateOffset;
            LagDuration = lagDuration;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Lag> MetaData => metaData;
        
        /// <summary>
        /// Defines the offset of the series of pricing dates relative to the calculation period.
        /// </summary>
        public Offset? FirstObservationDateOffset { get; }
        
        /// <summary>
        /// Defines the offset of the series of pricing dates relative to the calculation period.
        /// </summary>
        public Offset LagDuration { get; }
    }
    
    /// <summary>
    /// The specification of a legal agreement between two parties, being negotiated or having been executed. This includes the baseline information and the optional specialised elections
    /// </summary>
    public class LegalAgreement : AbstractRosettaModelObject<LegalAgreement>, ILegalAgreementBase
    {
        private static readonly IRosettaMetaData<LegalAgreement> metaData = new LegalAgreementMeta();
        
        [JsonConstructor]
        public LegalAgreement(AgreementTerms? agreementTerms, _MetaFields? meta, IEnumerable<LegalAgreement> relatedAgreements, UmbrellaAgreement? umbrellaAgreement, LocalDate? agreementDate, IEnumerable<Resource> attachment, IEnumerable<ReferenceWithMetaParty> contractualParty, LocalDate? effectiveDate, IEnumerable<Identifier> identifier, LegalAgreementIdentification legalAgreementIdentification, IEnumerable<PartyRole> otherParty)
        {
            AgreementTerms = agreementTerms;
            Meta = meta;
            RelatedAgreements = relatedAgreements;
            UmbrellaAgreement = umbrellaAgreement;
            AgreementDate = agreementDate;
            Attachment = attachment;
            ContractualParty = contractualParty;
            EffectiveDate = effectiveDate;
            Identifier = identifier;
            LegalAgreementIdentification = legalAgreementIdentification;
            OtherParty = otherParty;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<LegalAgreement> MetaData => metaData;
        
        /// <summary>
        /// Specification of the content of the legal agreement.
        /// </summary>
        public AgreementTerms? AgreementTerms { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <summary>
        /// Specifies the agreement(s) that govern the agreement, either as a reference to such agreements when specified as part of the CDM, or through identification of some of the key terms of those agreements, such as the type of agreement, the publisher, the vintage, the agreement identifier and the agreement date.
        /// </summary>
        public IEnumerable<LegalAgreement> RelatedAgreements { get; }
        
        /// <summary>
        /// The determination of whether Umbrella Agreement terms are applicable (True) or Not Applicable (False).
        /// </summary>
        public UmbrellaAgreement? UmbrellaAgreement { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? AgreementDate { get; }
        
        /// <inheritdoc/>
        public IEnumerable<Resource> Attachment { get; }
        
        /// <inheritdoc/>
        public IEnumerable<ReferenceWithMetaParty> ContractualParty { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? EffectiveDate { get; }
        
        /// <inheritdoc/>
        public IEnumerable<Identifier> Identifier { get; }
        
        /// <inheritdoc/>
        public LegalAgreementIdentification LegalAgreementIdentification { get; }
        
        /// <inheritdoc/>
        public IEnumerable<PartyRole> OtherParty { get; }
    }
    
    /// <summary>
    /// Specifies the legal agreement baseline information, being negotiated or having been executed. It excludes specialized elections
    /// </summary>
    public class LegalAgreementBase : AbstractRosettaModelObject<LegalAgreementBase>, ILegalAgreementBase
    {
        private static readonly IRosettaMetaData<LegalAgreementBase> metaData = new LegalAgreementBaseMeta();
        
        [JsonConstructor]
        public LegalAgreementBase(LocalDate? agreementDate, IEnumerable<Resource> attachment, IEnumerable<ReferenceWithMetaParty> contractualParty, LocalDate? effectiveDate, IEnumerable<Identifier> identifier, LegalAgreementIdentification legalAgreementIdentification, IEnumerable<PartyRole> otherParty)
        {
            AgreementDate = agreementDate;
            Attachment = attachment;
            ContractualParty = contractualParty;
            EffectiveDate = effectiveDate;
            Identifier = identifier;
            LegalAgreementIdentification = legalAgreementIdentification;
            OtherParty = otherParty;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<LegalAgreementBase> MetaData => metaData;
        
        /// <inheritdoc/>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? AgreementDate { get; }
        
        /// <inheritdoc/>
        public IEnumerable<Resource> Attachment { get; }
        
        /// <inheritdoc/>
        public IEnumerable<ReferenceWithMetaParty> ContractualParty { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? EffectiveDate { get; }
        
        /// <inheritdoc/>
        public IEnumerable<Identifier> Identifier { get; }
        
        /// <inheritdoc/>
        public LegalAgreementIdentification LegalAgreementIdentification { get; }
        
        /// <inheritdoc/>
        public IEnumerable<PartyRole> OtherParty { get; }
    }
    
    /// <summary>
    /// Specifies the type of legal agreement, identified via a set of composable attributes: agreementName, publisher, governing law and version, e.g. ISDA 2013 Standard Credit Support Annex English Law.
    /// </summary>
    public class LegalAgreementIdentification : AbstractRosettaModelObject<LegalAgreementIdentification>
    {
        private static readonly IRosettaMetaData<LegalAgreementIdentification> metaData = new LegalAgreementIdentificationMeta();
        
        [JsonConstructor]
        public LegalAgreementIdentification(AgreementName agreementName, Enums.GoverningLaw? governingLaw, Enums.LegalAgreementPublisher? publisher, int? vintage)
        {
            AgreementName = agreementName;
            GoverningLaw = governingLaw;
            Publisher = publisher;
            Vintage = vintage;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<LegalAgreementIdentification> MetaData => metaData;
        
        /// <summary>
        /// The legal agreement name, e.g. Credit Support Annex for Variation Margin.
        /// </summary>
        public AgreementName AgreementName { get; }
        
        /// <summary>
        /// The law governing the legal agreement, e.g. English Law, New York Law or Japanese Law.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.GoverningLaw? GoverningLaw { get; }
        
        /// <summary>
        /// The legal agreement publisher, e.g. ISDA.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.LegalAgreementPublisher? Publisher { get; }
        
        /// <summary>
        /// In the case where successive definitions of the legal agreement have been developed, the vintage identification. This is typically (but not necessarily) done by referencing the year, e.g. 2013 in the case of the ISDA 2013 Standard Credit Support Annex.
        /// </summary>
        public int? Vintage { get; }
    }
    
    /// <summary>
    /// A class to specify a legal entity, with a required name and an optional entity identifier (such as the LEI).
    /// </summary>
    public class LegalEntity : AbstractRosettaModelObject<LegalEntity>, ILegalEntity
    {
        private static readonly IRosettaMetaData<LegalEntity> metaData = new LegalEntityMeta();
        
        [JsonConstructor]
        public LegalEntity(IEnumerable<FieldWithMetaString> entityId, _MetaFields? meta, FieldWithMetaString name)
        {
            EntityId = entityId;
            Meta = meta;
            Name = name;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<LegalEntity> MetaData => metaData;
        
        /// <inheritdoc/>
        public IEnumerable<FieldWithMetaString> EntityId { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <inheritdoc/>
        public FieldWithMetaString Name { get; }
    }
    
    public class LimitApplicable : AbstractRosettaModelObject<LimitApplicable>, ILimitApplicable
    {
        private static readonly IRosettaMetaData<LimitApplicable> metaData = new LimitApplicableMeta();
        
        [JsonConstructor]
        public LimitApplicable(decimal? amountRemaining, decimal? amountUtilized, int? clipSize, FieldWithMetaString? currency, FieldWithMetaCreditLimitTypeEnum? limitType, CreditLimitUtilisation? utilization, Velocity? velocity)
        {
            AmountRemaining = amountRemaining;
            AmountUtilized = amountUtilized;
            ClipSize = clipSize;
            Currency = currency;
            LimitType = limitType;
            Utilization = utilization;
            Velocity = velocity;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<LimitApplicable> MetaData => metaData;
        
        /// <inheritdoc/>
        public decimal? AmountRemaining { get; }
        
        /// <inheritdoc/>
        public decimal? AmountUtilized { get; }
        
        /// <inheritdoc/>
        public int? ClipSize { get; }
        
        /// <inheritdoc/>
        public FieldWithMetaString? Currency { get; }
        
        /// <inheritdoc/>
        public FieldWithMetaCreditLimitTypeEnum? LimitType { get; }
        
        public CreditLimitUtilisation? Utilization { get; }
        
        public Velocity? Velocity { get; }
    }
    
    /// <summary>
    /// A class to represent the CDM attributes that are not part of the FpML standard. Once broader usage is confirmed, it is expected that those two classes can be collapsed.
    /// </summary>
    public class LimitApplicableExtended : AbstractRosettaModelObject<LimitApplicableExtended>, ILimitApplicable
    {
        private static readonly IRosettaMetaData<LimitApplicableExtended> metaData = new LimitApplicableExtendedMeta();
        
        [JsonConstructor]
        public LimitApplicableExtended(decimal? limitAmount, decimal? limitImpactDueToTrade, FieldWithMetaLimitLevelEnum? limitLevel, decimal? amountRemaining, decimal? amountUtilized, int? clipSize, FieldWithMetaString? currency, FieldWithMetaCreditLimitTypeEnum? limitType, CreditLimitUtilisation? utilization, Velocity? velocity)
        {
            LimitAmount = limitAmount;
            LimitImpactDueToTrade = limitImpactDueToTrade;
            LimitLevel = limitLevel;
            AmountRemaining = amountRemaining;
            AmountUtilized = amountUtilized;
            ClipSize = clipSize;
            Currency = currency;
            LimitType = limitType;
            Utilization = utilization;
            Velocity = velocity;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<LimitApplicableExtended> MetaData => metaData;
        
        /// <summary>
        /// The total limit available for the limit level and limit type. While the attribute is of type integer in the CME schema, it has been specified to be of type number in the CDM to take into consideration java size limits as well as for consistency purposes with the way most monetary amounts are expressed.
        /// </summary>
        public decimal? LimitAmount { get; }
        
        /// <summary>
        /// The limit utilized by this specific trade. While the attribute is of type integer in the CME schema, it has been specified to be of type number in the CDM to take into consideration java size limits as well as for consistency purposes with the way most monetary amounts are expressed.
        /// </summary>
        public decimal? LimitImpactDueToTrade { get; }
        
        /// <summary>
        /// The level at which the limit is set: customer business, proprietary business or account level. This attribute is specified as a string as part of the CME clearing confirmation specification.
        /// </summary>
        public FieldWithMetaLimitLevelEnum? LimitLevel { get; }
        
        /// <inheritdoc/>
        public decimal? AmountRemaining { get; }
        
        /// <inheritdoc/>
        public decimal? AmountUtilized { get; }
        
        /// <inheritdoc/>
        public int? ClipSize { get; }
        
        /// <inheritdoc/>
        public FieldWithMetaString? Currency { get; }
        
        /// <inheritdoc/>
        public FieldWithMetaCreditLimitTypeEnum? LimitType { get; }
        
        public CreditLimitUtilisation? Utilization { get; }
        
        public Velocity? Velocity { get; }
    }
    
    /// <summary>
    /// A class to provide lineage information across lifecycle events through a pointer or set of pointers into the event(s), contract(s) and, possibly, payout components that the event is dependent on or relates to. As an example, if an contractFormation event is corrected, the correction event will have a lineage into the initial event, which takes the form of a globalKey into that initial contract formation event. Two referencing mechanisms are provided as part of the CDM: either the globalKey, which corresponds to the hash value of the CDM class which is referred to, or a reference qualifier which is meant to provide support for the ingestion of xml documents with id/href mechanisms. The CDM recommends the use of the globalKey and provides a default implementation which is accessible in the generated code through org.isda.cdm.globalKey.GlobalKeyHashCalculator. If implementers want to use an alternative hashing mechanism, the API in which they need to plug it is com.rosetta.model.lib.HashFunction.
    /// </summary>
    public class Lineage : AbstractRosettaModelObject<Lineage>
    {
        private static readonly IRosettaMetaData<Lineage> metaData = new LineageMeta();
        
        [JsonConstructor]
        public Lineage(IEnumerable<ReferenceWithMetaWorkflowStep> eventReference, IEnumerable<ReferenceWithMetaPortfolioState> portfolioStateReference, IEnumerable<ReferenceWithMetaTrade> tradeReference)
        {
            EventReference = eventReference;
            PortfolioStateReference = portfolioStateReference;
            TradeReference = tradeReference;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Lineage> MetaData => metaData;
        
        /// <summary>
        /// The reference to the instantiation of an Event object, either through a globalKey or an xml-derived id/href mechanism. The definition associated to the Lineage class provides more details with respect to those referencing approaches, their expected usage and available implementation.
        /// </summary>
        public IEnumerable<ReferenceWithMetaWorkflowStep> EventReference { get; }
        
        /// <summary>
        /// The reference to the previous state of a Portfolio, in a chain of Events leading up to a build of that Portfolio as the holding of Product(s) in specific Quantity(ies). As part of the PortfolioState object, a pointer to the previous PortfolioState is provided through a Lineage object, together with pointer(s) to the Event or set of Events leading up to the current (new) state.
        /// </summary>
        public IEnumerable<ReferenceWithMetaPortfolioState> PortfolioStateReference { get; }
        
        public IEnumerable<ReferenceWithMetaTrade> TradeReference { get; }
    }
    
    /// <summary>
    /// Specifies a filter based on an underlying corporate financial official listing defined at a stock exchange.
    /// </summary>
    public class ListingType : AbstractRosettaModelObject<ListingType>
    {
        private static readonly IRosettaMetaData<ListingType> metaData = new ListingTypeMeta();
        
        [JsonConstructor]
        public ListingType(FieldWithMetaString? exchange, Index? index, FieldWithMetaString? sector)
        {
            Exchange = exchange;
            Index = index;
            Sector = sector;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ListingType> MetaData => metaData;
        
        /// <summary>
        /// Represents a filter based on the Primary Stock Exchange facilitating the listing of companies, exchange of Stocks, Exchange traded Derivatives, Bonds, and other Securities expressed in ISO standard 10383.
        /// </summary>
        public FieldWithMetaString? Exchange { get; }
        
        /// <summary>
        /// Represents a filter based on an index that measures a stock market, or a subset of a stock market.
        /// </summary>
        public Index? Index { get; }
        
        /// <summary>
        /// Represents a filter based on an industry sector defined under a system for classifying industry types such as Global Industry Classification Standard (GICS) and North American Industry Classification System (NAICS)
        /// </summary>
        public FieldWithMetaString? Sector { get; }
    }
    
    /// <summary>
    /// Identifies a loan by referencing a product identifier and through an optional set of attributes.
    /// </summary>
    public class Loan : AbstractRosettaModelObject<Loan>, IProductBase
    {
        private static readonly IRosettaMetaData<Loan> metaData = new LoanMeta();
        
        [JsonConstructor]
        public Loan(IEnumerable<LegalEntity> borrower, LocalDate? creditAgreementDate, FieldWithMetaString? facilityType, FieldWithMetaString? lien, FieldWithMetaString? tranche, IEnumerable<ReferenceWithMetaProductIdentifier> productIdentifier, IEnumerable<ProductTaxonomy> productTaxonomy)
        {
            Borrower = borrower;
            CreditAgreementDate = creditAgreementDate;
            FacilityType = facilityType;
            Lien = lien;
            Tranche = tranche;
            ProductIdentifier = productIdentifier;
            ProductTaxonomy = productTaxonomy;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Loan> MetaData => metaData;
        
        /// <summary>
        /// Specifies the borrower. There can be more than one borrower. It is meant to be used in the event that there is no Bloomberg Id or the Secured List isn&apos;t applicable.
        /// </summary>
        public IEnumerable<LegalEntity> Borrower { get; }
        
        /// <summary>
        /// Specifies the credit agreement date is the closing date (the date where the agreement has been signed) for the loans in the credit agreement. Funding of the facilities occurs on (or sometimes a little after) the Credit Agreement date. This underlier attribute is used to help identify which of the company&apos;s outstanding loans are being referenced by knowing to which credit agreement it belongs. ISDA Standards Terms Supplement term: Date of Original Credit Agreement.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? CreditAgreementDate { get; }
        
        /// <summary>
        /// Specifies the type of loan facility (letter of credit, revolving, ...).
        /// </summary>
        public FieldWithMetaString? FacilityType { get; }
        
        /// <summary>
        /// Specifies the seniority level of the lien.
        /// </summary>
        public FieldWithMetaString? Lien { get; }
        
        /// <summary>
        /// Denotes the loan tranche that is subject to the derivative transaction. It will typically be referenced as the Bloomberg tranche number. ISDA Standards Terms Supplement term: Bloomberg Tranche Number.
        /// </summary>
        public FieldWithMetaString? Tranche { get; }
        
        /// <inheritdoc/>
        public IEnumerable<ReferenceWithMetaProductIdentifier> ProductIdentifier { get; }
        
        /// <inheritdoc/>
        public IEnumerable<ProductTaxonomy> ProductTaxonomy { get; }
    }
    
    /// <summary>
    /// A class to specify loan with a participation agreement whereby the buyer is capable of creating, or procuring the creation of, a contractual right in favour of the seller that provides the seller with recourse to the participation seller for a specified share in any payments due under the relevant loan which are received by the participation seller. ISDA 2003 Term: Direct Loan Participation.
    /// </summary>
    public class LoanParticipation : AbstractRosettaModelObject<LoanParticipation>, IPCDeliverableObligationCharac
    {
        private static readonly IRosettaMetaData<LoanParticipation> metaData = new LoanParticipationMeta();
        
        [JsonConstructor]
        public LoanParticipation(string? qualifyingParticipationSeller, bool applicable, bool? partialCashSettlement)
        {
            QualifyingParticipationSeller = qualifyingParticipationSeller;
            Applicable = applicable;
            PartialCashSettlement = partialCashSettlement;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<LoanParticipation> MetaData => metaData;
        
        /// <summary>
        /// If Direct Loan Participation is specified as a deliverable obligation characteristic, this specifies any requirements for the Qualifying Participation Seller. The requirements may be listed free-form. ISDA 2003 Term: Qualifying Participation Seller.
        /// </summary>
        public string? QualifyingParticipationSeller { get; }
        
        /// <inheritdoc/>
        public bool Applicable { get; }
        
        /// <inheritdoc/>
        public bool? PartialCashSettlement { get; }
    }
    
    /// <summary>
    /// A class to specify the amount to be paid by the buyer of the option if the option is exercised prior to the Early Call Date (typically applicable to the convertible bond options).
    /// </summary>
    public class MakeWholeAmount : AbstractRosettaModelObject<MakeWholeAmount>, ISwapCurveValuation
    {
        private static readonly IRosettaMetaData<MakeWholeAmount> metaData = new MakeWholeAmountMeta();
        
        [JsonConstructor]
        public MakeWholeAmount(FieldWithMetaLocalDate earlyCallDate, Enums.InterpolationMethod? interpolationMethod, Enums.FloatingRateIndex floatingRateIndex, Period? indexTenor, Enums.QuotationSide? side, decimal spread)
        {
            EarlyCallDate = earlyCallDate;
            InterpolationMethod = interpolationMethod;
            FloatingRateIndex = floatingRateIndex;
            IndexTenor = indexTenor;
            Side = side;
            Spread = spread;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<MakeWholeAmount> MetaData => metaData;
        
        /// <summary>
        /// Date prior to which the option buyer will have to pay a Make Whole Amount to the option seller if he/she exercises the option.
        /// </summary>
        public FieldWithMetaLocalDate EarlyCallDate { get; }
        
        /// <summary>
        /// The type of interpolation method that the calculation agent reserves the right to use.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.InterpolationMethod? InterpolationMethod { get; }
        
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.FloatingRateIndex FloatingRateIndex { get; }
        
        /// <inheritdoc/>
        public Period? IndexTenor { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.QuotationSide? Side { get; }
        
        /// <inheritdoc/>
        public decimal Spread { get; }
    }
    
    /// <summary>
    /// A data to:  define an early termination provision for which exercise is mandatory.
    /// </summary>
    public class MandatoryEarlyTermination : AbstractRosettaModelObject<MandatoryEarlyTermination>
    {
        private static readonly IRosettaMetaData<MandatoryEarlyTermination> metaData = new MandatoryEarlyTerminationMeta();
        
        [JsonConstructor]
        public MandatoryEarlyTermination(CalculationAgent calculationAgent, SettlementTerms cashSettlement, MandatoryEarlyTerminationAdjustedDates? mandatoryEarlyTerminationAdjustedDates, AdjustableDate mandatoryEarlyTerminationDate, _MetaFields? meta)
        {
            CalculationAgent = calculationAgent;
            CashSettlement = cashSettlement;
            MandatoryEarlyTerminationAdjustedDates = mandatoryEarlyTerminationAdjustedDates;
            MandatoryEarlyTerminationDate = mandatoryEarlyTerminationDate;
            Meta = meta;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<MandatoryEarlyTermination> MetaData => metaData;
        
        /// <summary>
        /// The ISDA Calculation Agent responsible for performing duties associated with an optional early termination.
        /// </summary>
        public CalculationAgent CalculationAgent { get; }
        
        /// <summary>
        /// If specified, this means that cash settlement is applicable to the transaction and defines the parameters associated with the cash settlement procedure. If not specified, then physical settlement is applicable.
        /// </summary>
        public SettlementTerms CashSettlement { get; }
        
        /// <summary>
        /// The adjusted dates associated with a mandatory early termination provision. These dates have been adjusted for any applicable business day convention.
        /// </summary>
        public MandatoryEarlyTerminationAdjustedDates? MandatoryEarlyTerminationAdjustedDates { get; }
        
        /// <summary>
        /// The early termination date associated with a mandatory early termination of a swap.
        /// </summary>
        public AdjustableDate MandatoryEarlyTerminationDate { get; }
        
        public _MetaFields? Meta { get; }
    }
    
    /// <summary>
    /// A data defining:  the adjusted dates associated with a mandatory early termination provision.
    /// </summary>
    public class MandatoryEarlyTerminationAdjustedDates : AbstractRosettaModelObject<MandatoryEarlyTerminationAdjustedDates>
    {
        private static readonly IRosettaMetaData<MandatoryEarlyTerminationAdjustedDates> metaData = new MandatoryEarlyTerminationAdjustedDatesMeta();
        
        [JsonConstructor]
        public MandatoryEarlyTerminationAdjustedDates(LocalDate adjustedCashSettlementPaymentDate, LocalDate adjustedCashSettlementValuationDate, LocalDate adjustedEarlyTerminationDate)
        {
            AdjustedCashSettlementPaymentDate = adjustedCashSettlementPaymentDate;
            AdjustedCashSettlementValuationDate = adjustedCashSettlementValuationDate;
            AdjustedEarlyTerminationDate = adjustedEarlyTerminationDate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<MandatoryEarlyTerminationAdjustedDates> MetaData => metaData;
        
        /// <summary>
        /// The date on which the cash settlement amount is paid. This date should already be adjusted for any applicable business date convention.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate AdjustedCashSettlementPaymentDate { get; }
        
        /// <summary>
        /// The date by which the cash settlement amount must be agreed. This date should already be adjusted for any applicable business day convention.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate AdjustedCashSettlementValuationDate { get; }
        
        /// <summary>
        /// The early termination date that is applicable if an early termination provision is exercised. This date should already be adjusted for any applicable business day convention.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate AdjustedEarlyTerminationDate { get; }
    }
    
    /// <summary>
    /// A class defining manual exercise, i.e. that the option buyer counterparty must give notice to the option seller of exercise.
    /// </summary>
    public class ManualExercise : AbstractRosettaModelObject<ManualExercise>
    {
        private static readonly IRosettaMetaData<ManualExercise> metaData = new ManualExerciseMeta();
        
        [JsonConstructor]
        public ManualExercise(ExerciseNotice? exerciseNotice, bool? fallbackExercise)
        {
            ExerciseNotice = exerciseNotice;
            FallbackExercise = fallbackExercise;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ManualExercise> MetaData => metaData;
        
        /// <summary>
        /// Definition of the party to whom notice of exercise should be given.
        /// </summary>
        public ExerciseNotice? ExerciseNotice { get; }
        
        /// <summary>
        /// If fallback exercise is specified then the notional amount of the underlying swap, not previously exercised under the swaption, will be automatically exercised at the expiration time on the expiration date if at such time the buyer is in-the-money, provided that the difference between the settlement rate and the fixed rate under the relevant underlying swap is not less than one tenth of a percentage point (0.10% or 0.001). The term in-the-money is assumed to have the meaning defined in the 2000 ISDA Definitions, Section 17.4. In-the-money.
        /// </summary>
        public bool? FallbackExercise { get; }
    }
    
    /// <summary>
    /// Represents common attributes required for Issuance and Response to a Margin Call action as a result of a demand for delivery or return of collateral determined under a legal agreement such as a credit support document or equivalent.
    /// </summary>
    public class MarginCallBase : AbstractRosettaModelObject<MarginCallBase>, IMarginCallBase
    {
        private static readonly IRosettaMetaData<MarginCallBase> metaData = new MarginCallBaseMeta();
        
        [JsonConstructor]
        public MarginCallBase(Money? agreementMinimumTransferAmount, Money? agreementRounding, Money? agreementThreshold, MarginCallExposure? baseCurrencyExposure, AgreementName callAgreementType, Identifier? callIdentifier, Party? clearingBroker, ReferenceWithMetaCollateralPortfolio? collateralPortfolio, CollateralBalance? independentAmountBalance, MarginCallInstructionType instructionType, IEnumerable<Party> party, IEnumerable<PartyRole> partyRole, Enums.RegIMRole? regIMRole, Enums.RegMarginType regMarginType)
        {
            AgreementMinimumTransferAmount = agreementMinimumTransferAmount;
            AgreementRounding = agreementRounding;
            AgreementThreshold = agreementThreshold;
            BaseCurrencyExposure = baseCurrencyExposure;
            CallAgreementType = callAgreementType;
            CallIdentifier = callIdentifier;
            ClearingBroker = clearingBroker;
            CollateralPortfolio = collateralPortfolio;
            IndependentAmountBalance = independentAmountBalance;
            InstructionType = instructionType;
            Party = party;
            PartyRole = partyRole;
            RegIMRole = regIMRole;
            RegMarginType = regMarginType;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<MarginCallBase> MetaData => metaData;
        
        /// <inheritdoc/>
        public Money? AgreementMinimumTransferAmount { get; }
        
        /// <inheritdoc/>
        public Money? AgreementRounding { get; }
        
        /// <inheritdoc/>
        public Money? AgreementThreshold { get; }
        
        /// <inheritdoc/>
        public MarginCallExposure? BaseCurrencyExposure { get; }
        
        /// <inheritdoc/>
        public AgreementName CallAgreementType { get; }
        
        /// <inheritdoc/>
        public Identifier? CallIdentifier { get; }
        
        /// <inheritdoc/>
        public Party? ClearingBroker { get; }
        
        /// <inheritdoc/>
        public ReferenceWithMetaCollateralPortfolio? CollateralPortfolio { get; }
        
        /// <inheritdoc/>
        public CollateralBalance? IndependentAmountBalance { get; }
        
        /// <inheritdoc/>
        public MarginCallInstructionType InstructionType { get; }
        
        /// <inheritdoc/>
        public IEnumerable<Party> Party { get; }
        
        /// <inheritdoc/>
        public IEnumerable<PartyRole> PartyRole { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.RegIMRole? RegIMRole { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.RegMarginType RegMarginType { get; }
    }
    
    /// <summary>
    /// Represents attributes required for mark to market value or IM calculation value of the trade portfolio as recorded by the principle (in base currency).
    /// </summary>
    public class MarginCallExposure : AbstractRosettaModelObject<MarginCallExposure>, IMarginCallBase
    {
        private static readonly IRosettaMetaData<MarginCallExposure> metaData = new MarginCallExposureMeta();
        
        [JsonConstructor]
        public MarginCallExposure(Exposure overallExposure, Exposure? scheduleGridIMExposure, Exposure? simmIMExposure, Money? agreementMinimumTransferAmount, Money? agreementRounding, Money? agreementThreshold, MarginCallExposure? baseCurrencyExposure, AgreementName callAgreementType, Identifier? callIdentifier, Party? clearingBroker, ReferenceWithMetaCollateralPortfolio? collateralPortfolio, CollateralBalance? independentAmountBalance, MarginCallInstructionType instructionType, IEnumerable<Party> party, IEnumerable<PartyRole> partyRole, Enums.RegIMRole? regIMRole, Enums.RegMarginType regMarginType)
        {
            OverallExposure = overallExposure;
            ScheduleGridIMExposure = scheduleGridIMExposure;
            SimmIMExposure = simmIMExposure;
            AgreementMinimumTransferAmount = agreementMinimumTransferAmount;
            AgreementRounding = agreementRounding;
            AgreementThreshold = agreementThreshold;
            BaseCurrencyExposure = baseCurrencyExposure;
            CallAgreementType = callAgreementType;
            CallIdentifier = callIdentifier;
            ClearingBroker = clearingBroker;
            CollateralPortfolio = collateralPortfolio;
            IndependentAmountBalance = independentAmountBalance;
            InstructionType = instructionType;
            Party = party;
            PartyRole = partyRole;
            RegIMRole = regIMRole;
            RegMarginType = regMarginType;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<MarginCallExposure> MetaData => metaData;
        
        /// <summary>
        /// Represents the whole overall mark to market value or IM calculation value of the trade portfolio as recorded by the principle (in base currency).
        /// </summary>
        public Exposure OverallExposure { get; }
        
        /// <summary>
        /// Represents Initial Margin (IM) exposure derived from schedule or Grid calculation.
        /// </summary>
        public Exposure? ScheduleGridIMExposure { get; }
        
        /// <summary>
        /// Represents Initial Margin (IM) exposure derived from ISDA SIMM calculation.
        /// </summary>
        public Exposure? SimmIMExposure { get; }
        
        /// <inheritdoc/>
        public Money? AgreementMinimumTransferAmount { get; }
        
        /// <inheritdoc/>
        public Money? AgreementRounding { get; }
        
        /// <inheritdoc/>
        public Money? AgreementThreshold { get; }
        
        /// <inheritdoc/>
        public MarginCallExposure? BaseCurrencyExposure { get; }
        
        /// <inheritdoc/>
        public AgreementName CallAgreementType { get; }
        
        /// <inheritdoc/>
        public Identifier? CallIdentifier { get; }
        
        /// <inheritdoc/>
        public Party? ClearingBroker { get; }
        
        /// <inheritdoc/>
        public ReferenceWithMetaCollateralPortfolio? CollateralPortfolio { get; }
        
        /// <inheritdoc/>
        public CollateralBalance? IndependentAmountBalance { get; }
        
        /// <inheritdoc/>
        public MarginCallInstructionType InstructionType { get; }
        
        /// <inheritdoc/>
        public IEnumerable<Party> Party { get; }
        
        /// <inheritdoc/>
        public IEnumerable<PartyRole> PartyRole { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.RegIMRole? RegIMRole { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.RegMarginType RegMarginType { get; }
    }
    
    /// <summary>
    /// Represents enumeration values to specify the call notification type, direction, specific action type.
    /// </summary>
    public class MarginCallInstructionType : AbstractRosettaModelObject<MarginCallInstructionType>
    {
        private static readonly IRosettaMetaData<MarginCallInstructionType> metaData = new MarginCallInstructionTypeMeta();
        
        [JsonConstructor]
        public MarginCallInstructionType(Enums.CallType callType, bool? visibilityIndicator)
        {
            CallType = callType;
            VisibilityIndicator = visibilityIndicator;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<MarginCallInstructionType> MetaData => metaData;
        
        /// <summary>
        /// Indicates the status of the call message type, such as expected call, notification of a call or an actionable margin call.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CallType CallType { get; }
        
        /// <summary>
        /// Indicates the choice if the call instruction is visible or not to the other party.
        /// </summary>
        public bool? VisibilityIndicator { get; }
    }
    
    /// <summary>
    /// Represents common attributes required for a Margin Call Issuance under a legal agreement such as a credit support document or equivalent.
    /// </summary>
    public class MarginCallIssuance : AbstractRosettaModelObject<MarginCallIssuance>, IMarginCallBase
    {
        private static readonly IRosettaMetaData<MarginCallIssuance> metaData = new MarginCallIssuanceMeta();
        
        [JsonConstructor]
        public MarginCallIssuance(Money callAmountInBaseCurrency, IEnumerable<EligibleCollateralCriteria> recallNonCashCollateralDescription, Money? agreementMinimumTransferAmount, Money? agreementRounding, Money? agreementThreshold, MarginCallExposure? baseCurrencyExposure, AgreementName callAgreementType, Identifier? callIdentifier, Party? clearingBroker, ReferenceWithMetaCollateralPortfolio? collateralPortfolio, CollateralBalance? independentAmountBalance, MarginCallInstructionType instructionType, IEnumerable<Party> party, IEnumerable<PartyRole> partyRole, Enums.RegIMRole? regIMRole, Enums.RegMarginType regMarginType)
        {
            CallAmountInBaseCurrency = callAmountInBaseCurrency;
            RecallNonCashCollateralDescription = recallNonCashCollateralDescription;
            AgreementMinimumTransferAmount = agreementMinimumTransferAmount;
            AgreementRounding = agreementRounding;
            AgreementThreshold = agreementThreshold;
            BaseCurrencyExposure = baseCurrencyExposure;
            CallAgreementType = callAgreementType;
            CallIdentifier = callIdentifier;
            ClearingBroker = clearingBroker;
            CollateralPortfolio = collateralPortfolio;
            IndependentAmountBalance = independentAmountBalance;
            InstructionType = instructionType;
            Party = party;
            PartyRole = partyRole;
            RegIMRole = regIMRole;
            RegMarginType = regMarginType;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<MarginCallIssuance> MetaData => metaData;
        
        /// <summary>
        /// Specifies the amount of margin being called for which accounts for margin calculation inclusive of exposure, independent amount,threshold,collateral balance, MTA, rounding increments (in base currency detailed in supporting collateral agreement).
        /// </summary>
        public Money CallAmountInBaseCurrency { get; }
        
        /// <summary>
        /// Specifies the details to describe or identify non-cash collateral eligible assets for recall purposes.
        /// </summary>
        public IEnumerable<EligibleCollateralCriteria> RecallNonCashCollateralDescription { get; }
        
        /// <inheritdoc/>
        public Money? AgreementMinimumTransferAmount { get; }
        
        /// <inheritdoc/>
        public Money? AgreementRounding { get; }
        
        /// <inheritdoc/>
        public Money? AgreementThreshold { get; }
        
        /// <inheritdoc/>
        public MarginCallExposure? BaseCurrencyExposure { get; }
        
        /// <inheritdoc/>
        public AgreementName CallAgreementType { get; }
        
        /// <inheritdoc/>
        public Identifier? CallIdentifier { get; }
        
        /// <inheritdoc/>
        public Party? ClearingBroker { get; }
        
        /// <inheritdoc/>
        public ReferenceWithMetaCollateralPortfolio? CollateralPortfolio { get; }
        
        /// <inheritdoc/>
        public CollateralBalance? IndependentAmountBalance { get; }
        
        /// <inheritdoc/>
        public MarginCallInstructionType InstructionType { get; }
        
        /// <inheritdoc/>
        public IEnumerable<Party> Party { get; }
        
        /// <inheritdoc/>
        public IEnumerable<PartyRole> PartyRole { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.RegIMRole? RegIMRole { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.RegMarginType RegMarginType { get; }
    }
    
    /// <summary>
    /// Represents common attributes required for a Margin Call Response under a legal agreement such as a credit support document or equivalent.
    /// </summary>
    public class MarginCallResponse : AbstractRosettaModelObject<MarginCallResponse>, IMarginCallBase
    {
        private static readonly IRosettaMetaData<MarginCallResponse> metaData = new MarginCallResponseMeta();
        
        [JsonConstructor]
        public MarginCallResponse(Money agreedAmountBaseCurrency, IEnumerable<MarginCallResponseAction> marginCallResponseAction, Enums.MarginCallResponseType marginResponseType, Money? agreementMinimumTransferAmount, Money? agreementRounding, Money? agreementThreshold, MarginCallExposure? baseCurrencyExposure, AgreementName callAgreementType, Identifier? callIdentifier, Party? clearingBroker, ReferenceWithMetaCollateralPortfolio? collateralPortfolio, CollateralBalance? independentAmountBalance, MarginCallInstructionType instructionType, IEnumerable<Party> party, IEnumerable<PartyRole> partyRole, Enums.RegIMRole? regIMRole, Enums.RegMarginType regMarginType)
        {
            AgreedAmountBaseCurrency = agreedAmountBaseCurrency;
            MarginCallResponseAction = marginCallResponseAction;
            MarginResponseType = marginResponseType;
            AgreementMinimumTransferAmount = agreementMinimumTransferAmount;
            AgreementRounding = agreementRounding;
            AgreementThreshold = agreementThreshold;
            BaseCurrencyExposure = baseCurrencyExposure;
            CallAgreementType = callAgreementType;
            CallIdentifier = callIdentifier;
            ClearingBroker = clearingBroker;
            CollateralPortfolio = collateralPortfolio;
            IndependentAmountBalance = independentAmountBalance;
            InstructionType = instructionType;
            Party = party;
            PartyRole = partyRole;
            RegIMRole = regIMRole;
            RegMarginType = regMarginType;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<MarginCallResponse> MetaData => metaData;
        
        /// <summary>
        /// Indicates the amount that posting entity agrees to remit in response to margin call (in base currency).
        /// </summary>
        public Money AgreedAmountBaseCurrency { get; }
        
        /// <summary>
        /// Specifies the margin call action details, including collateral to be moved and direction.
        /// </summary>
        public IEnumerable<MarginCallResponseAction> MarginCallResponseAction { get; }
        
        /// <summary>
        /// Indicates the response type, such as, is the margin call response a &apos;full&apos; &apos;part&apos; agreement or &apos;dispute&apos;.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.MarginCallResponseType MarginResponseType { get; }
        
        /// <inheritdoc/>
        public Money? AgreementMinimumTransferAmount { get; }
        
        /// <inheritdoc/>
        public Money? AgreementRounding { get; }
        
        /// <inheritdoc/>
        public Money? AgreementThreshold { get; }
        
        /// <inheritdoc/>
        public MarginCallExposure? BaseCurrencyExposure { get; }
        
        /// <inheritdoc/>
        public AgreementName CallAgreementType { get; }
        
        /// <inheritdoc/>
        public Identifier? CallIdentifier { get; }
        
        /// <inheritdoc/>
        public Party? ClearingBroker { get; }
        
        /// <inheritdoc/>
        public ReferenceWithMetaCollateralPortfolio? CollateralPortfolio { get; }
        
        /// <inheritdoc/>
        public CollateralBalance? IndependentAmountBalance { get; }
        
        /// <inheritdoc/>
        public MarginCallInstructionType InstructionType { get; }
        
        /// <inheritdoc/>
        public IEnumerable<Party> Party { get; }
        
        /// <inheritdoc/>
        public IEnumerable<PartyRole> PartyRole { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.RegIMRole? RegIMRole { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.RegMarginType RegMarginType { get; }
    }
    
    /// <summary>
    /// Specifies the margin call action details, including collateral to be moved and its direction.
    /// </summary>
    public class MarginCallResponseAction : AbstractRosettaModelObject<MarginCallResponseAction>
    {
        private static readonly IRosettaMetaData<MarginCallResponseAction> metaData = new MarginCallResponseActionMeta();
        
        [JsonConstructor]
        public MarginCallResponseAction(IEnumerable<CollateralPosition> collateralPositionComponent, Enums.MarginCallAction marginCallAction)
        {
            CollateralPositionComponent = collateralPositionComponent;
            MarginCallAction = marginCallAction;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<MarginCallResponseAction> MetaData => metaData;
        
        /// <summary>
        /// Specifies the collateral to be moved and its direction.
        /// </summary>
        public IEnumerable<CollateralPosition> CollateralPositionComponent { get; }
        
        /// <summary>
        /// Specifies the margin call action details, specified as either Delivery or Return.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.MarginCallAction MarginCallAction { get; }
    }
    
    /// <summary>
    /// The set of elections which specify a Master Agreement.
    /// </summary>
    public class MasterAgreementSchedule : AbstractRosettaModelObject<MasterAgreementSchedule>
    {
        private static readonly IRosettaMetaData<MasterAgreementSchedule> metaData = new MasterAgreementScheduleMeta();
        
        [JsonConstructor]
        public MasterAgreementSchedule()
        {
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<MasterAgreementSchedule> MetaData => metaData;
        
    }
    
    /// <summary>
    /// Legal agreement specification for General Terms and Elections that are applicable across multiple confirmations and are referenced by these confirmations.
    /// </summary>
    public class MasterConfirmationBase : AbstractRosettaModelObject<MasterConfirmationBase>, IMasterConfirmationBase
    {
        private static readonly IRosettaMetaData<MasterConfirmationBase> metaData = new MasterConfirmationBaseMeta();
        
        [JsonConstructor]
        public MasterConfirmationBase()
        {
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<MasterConfirmationBase> MetaData => metaData;
        
    }
    
    /// <summary>
    /// Defines a concrete measure as a number associated to a unit. It extends MeasureBase by requiring the value attribute to be present. A measure may be unit-less so the unit attribute is still optional.
    /// </summary>
    public class Measure : AbstractRosettaModelObject<Measure>, IMeasureBase
    {
        private static readonly IRosettaMetaData<Measure> metaData = new MeasureMeta();
        
        [JsonConstructor]
        public Measure(UnitType? unit, decimal? value)
        {
            Unit = unit;
            Value = value;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Measure> MetaData => metaData;
        
        /// <inheritdoc/>
        public UnitType? Unit { get; }
        
        /// <inheritdoc/>
        public decimal? Value { get; }
    }
    
    /// <summary>
    /// Provides an abstract type to define a measure as a number associated to a unit. This type is abstract because all its attributes are optional. The types that extend it can specify further existence constraints.
    /// </summary>
    public class MeasureBase : AbstractRosettaModelObject<MeasureBase>, IMeasureBase
    {
        private static readonly IRosettaMetaData<MeasureBase> metaData = new MeasureBaseMeta();
        
        [JsonConstructor]
        public MeasureBase(UnitType? unit, decimal? value)
        {
            Unit = unit;
            Value = value;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<MeasureBase> MetaData => metaData;
        
        /// <inheritdoc/>
        public UnitType? Unit { get; }
        
        /// <inheritdoc/>
        public decimal? Value { get; }
    }
    
    /// <summary>
    /// A set of measures, all in the same unit, where the values are defined through a schedule of steps. The initial value may be defined either as part of the steps, or using the single amount attribute.
    /// </summary>
    public class MeasureSchedule : AbstractRosettaModelObject<MeasureSchedule>, IMeasureSchedule, IMeasureBase
    {
        private static readonly IRosettaMetaData<MeasureSchedule> metaData = new MeasureScheduleMeta();
        
        [JsonConstructor]
        public MeasureSchedule(IEnumerable<DatedValue> datedValue, UnitType? unit, decimal? value)
        {
            DatedValue = datedValue;
            Unit = unit;
            Value = value;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<MeasureSchedule> MetaData => metaData;
        
        /// <inheritdoc/>
        public IEnumerable<DatedValue> DatedValue { get; }
        
        /// <inheritdoc/>
        public UnitType? Unit { get; }
        
        /// <inheritdoc/>
        public decimal? Value { get; }
    }
    
    /// <summary>
    /// This class corresponds to the components of the FpML MessageHeader.model.
    /// </summary>
    public class MessageInformation : AbstractRosettaModelObject<MessageInformation>
    {
        private static readonly IRosettaMetaData<MessageInformation> metaData = new MessageInformationMeta();
        
        [JsonConstructor]
        public MessageInformation(IEnumerable<FieldWithMetaString> copyTo, FieldWithMetaString messageId, FieldWithMetaString? sentBy, IEnumerable<FieldWithMetaString> sentTo)
        {
            CopyTo = copyTo;
            MessageId = messageId;
            SentBy = sentBy;
            SentTo = sentTo;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<MessageInformation> MetaData => metaData;
        
        /// <summary>
        /// A unique identifier (within the specified coding scheme) giving the details of some party to whom a copy of this message will be sent for reference.
        /// </summary>
        public IEnumerable<FieldWithMetaString> CopyTo { get; }
        
        /// <summary>
        /// A unique identifier assigned to the message.
        /// </summary>
        public FieldWithMetaString MessageId { get; }
        
        /// <summary>
        /// The identifier for the originator of a message instance.
        /// </summary>
        public FieldWithMetaString? SentBy { get; }
        
        /// <summary>
        /// The identifier(s) for the recipient(s) of a message instance.
        /// </summary>
        public IEnumerable<FieldWithMetaString> SentTo { get; }
    }
    
    /// <summary>
    /// Defines a monetary amount in a specified currency.
    /// </summary>
    public class Money : AbstractRosettaModelObject<Money>, IQuantity
    {
        private static readonly IRosettaMetaData<Money> metaData = new MoneyMeta();
        
        [JsonConstructor]
        public Money(_MetaFields? meta, Frequency? frequency, Measure? multiplier, IEnumerable<DatedValue> datedValue, UnitType? unit, decimal? value)
        {
            Meta = meta;
            Frequency = frequency;
            Multiplier = multiplier;
            DatedValue = datedValue;
            Unit = unit;
            Value = value;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Money> MetaData => metaData;
        
        public _MetaFields? Meta { get; }
        
        /// <inheritdoc/>
        public Frequency? Frequency { get; }
        
        /// <inheritdoc/>
        public Measure? Multiplier { get; }
        
        /// <inheritdoc/>
        public IEnumerable<DatedValue> DatedValue { get; }
        
        /// <inheritdoc/>
        public UnitType? Unit { get; }
        
        /// <inheritdoc/>
        public decimal? Value { get; }
    }
    
    /// <summary>
    /// The money bound is defined as a money amount and whether the bound is inclusive.
    /// </summary>
    public class MoneyBound : AbstractRosettaModelObject<MoneyBound>
    {
        private static readonly IRosettaMetaData<MoneyBound> metaData = new MoneyBoundMeta();
        
        [JsonConstructor]
        public MoneyBound(bool inclusive, Money money)
        {
            Inclusive = inclusive;
            Money = money;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<MoneyBound> MetaData => metaData;
        
        /// <summary>
        /// Whether the money amount bound is inclusive, e.g. for a lower bound, false would indicate greater than, whereas true would indicate greater than or equal to.
        /// </summary>
        public bool Inclusive { get; }
        
        /// <summary>
        /// The money amount to be used as the bound, e.g. 1,000 USD.
        /// </summary>
        public Money Money { get; }
    }
    
    /// <summary>
    /// The money range defined as either a lower and upper money bound, or both.
    /// </summary>
    public class MoneyRange : AbstractRosettaModelObject<MoneyRange>
    {
        private static readonly IRosettaMetaData<MoneyRange> metaData = new MoneyRangeMeta();
        
        [JsonConstructor]
        public MoneyRange(MoneyBound? lowerBound, MoneyBound? upperBound)
        {
            LowerBound = lowerBound;
            UpperBound = upperBound;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<MoneyRange> MetaData => metaData;
        
        /// <summary>
        /// The lower bound of a money range, e.g. greater than or equal to 1,000 USD.
        /// </summary>
        public MoneyBound? LowerBound { get; }
        
        /// <summary>
        /// The upper bound of a money range, e.g. less than 10,000 USD.
        /// </summary>
        public MoneyBound? UpperBound { get; }
    }
    
    /// <summary>
    /// Represetns a class to specify multiple credit notations alongside a conditional &apos;any&apos; or &apos;all&apos; qualifier.
    /// </summary>
    public class MultipleCreditNotations : AbstractRosettaModelObject<MultipleCreditNotations>
    {
        private static readonly IRosettaMetaData<MultipleCreditNotations> metaData = new MultipleCreditNotationsMeta();
        
        [JsonConstructor]
        public MultipleCreditNotations(Enums.Quantifier condition, IEnumerable<FieldWithMetaCreditNotation> creditNotation, Enums.CreditNotationMismatchResolution? mismatchResolution, Enums.CreditRatingAgency? referenceAgency)
        {
            Condition = condition;
            CreditNotation = creditNotation;
            MismatchResolution = mismatchResolution;
            ReferenceAgency = referenceAgency;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<MultipleCreditNotations> MetaData => metaData;
        
        /// <summary>
        /// An enumerated element, to qualify whether All or Any credit notation applies.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.Quantifier Condition { get; }
        
        /// <summary>
        /// At least two credit notations much be specified.
        /// </summary>
        public IEnumerable<FieldWithMetaCreditNotation> CreditNotation { get; }
        
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CreditNotationMismatchResolution? MismatchResolution { get; }
        
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CreditRatingAgency? ReferenceAgency { get; }
    }
    
    /// <summary>
    /// Represents a class to specify multiple credit debt types alongside a conditional &apos;any&apos; or &apos;all&apos; qualifier.
    /// </summary>
    public class MultipleDebtTypes : AbstractRosettaModelObject<MultipleDebtTypes>
    {
        private static readonly IRosettaMetaData<MultipleDebtTypes> metaData = new MultipleDebtTypesMeta();
        
        [JsonConstructor]
        public MultipleDebtTypes(Enums.Quantifier condition, IEnumerable<FieldWithMetaString> debtType)
        {
            Condition = condition;
            DebtType = debtType;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<MultipleDebtTypes> MetaData => metaData;
        
        /// <summary>
        /// An enumerated attribute, to qualify whether All or Any debt type applies.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.Quantifier Condition { get; }
        
        /// <summary>
        /// The type of debt, e.g. long term debt, deposit, ... FpML doesn&apos;t specific a scheme value, hence no enumeration is specified as part of the CDM. At least two debt types much be specified.
        /// </summary>
        public IEnumerable<FieldWithMetaString> DebtType { get; }
    }
    
    /// <summary>
    /// A class defining multiple exercises. As defined in the 2000 ISDA Definitions, Section 12.4. Multiple Exercise, the buyer of the option has the right to exercise all or less than all the unexercised notional amount of the underlying swap on one or more days in the exercise period, but on any such day may not exercise less than the minimum notional amount or more than the maximum notional amount, and if an integral multiple amount is specified, the notional exercised must be equal to or, be an integral multiple of, the integral multiple amount. In FpML, MultipleExercise is built upon the PartialExercise.model.
    /// </summary>
    public class MultipleExercise : AbstractRosettaModelObject<MultipleExercise>, IPartialExercise
    {
        private static readonly IRosettaMetaData<MultipleExercise> metaData = new MultipleExerciseMeta();
        
        [JsonConstructor]
        public MultipleExercise(decimal? maximumNotionalAmount, int? maximumNumberOfOptions, decimal? integralMultipleAmount, decimal? minimumNotionalAmount, int? minimumNumberOfOptions, ReferenceWithMetaMoney notionaReference)
        {
            MaximumNotionalAmount = maximumNotionalAmount;
            MaximumNumberOfOptions = maximumNumberOfOptions;
            IntegralMultipleAmount = integralMultipleAmount;
            MinimumNotionalAmount = minimumNotionalAmount;
            MinimumNumberOfOptions = minimumNumberOfOptions;
            NotionaReference = notionaReference;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<MultipleExercise> MetaData => metaData;
        
        /// <summary>
        /// The maximum notional amount that can be exercised on a given exercise date.
        /// </summary>
        public decimal? MaximumNotionalAmount { get; }
        
        /// <summary>
        /// The maximum number of options that can be exercised on a given exercise date. If the number is not specified, it means that the maximum number of options corresponds to the remaining unexercised options.
        /// </summary>
        public int? MaximumNumberOfOptions { get; }
        
        /// <inheritdoc/>
        public decimal? IntegralMultipleAmount { get; }
        
        /// <inheritdoc/>
        public decimal? MinimumNotionalAmount { get; }
        
        /// <inheritdoc/>
        public int? MinimumNumberOfOptions { get; }
        
        /// <inheritdoc/>
        public ReferenceWithMetaMoney NotionaReference { get; }
    }
    
    public class MultipleValuationDates : AbstractRosettaModelObject<MultipleValuationDates>, ISingleValuationDate
    {
        private static readonly IRosettaMetaData<MultipleValuationDates> metaData = new MultipleValuationDatesMeta();
        
        [JsonConstructor]
        public MultipleValuationDates(int? businessDaysThereafter, int? numberValuationDates, int? businessDays)
        {
            BusinessDaysThereafter = businessDaysThereafter;
            NumberValuationDates = numberValuationDates;
            BusinessDays = businessDays;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<MultipleValuationDates> MetaData => metaData;
        
        /// <summary>
        /// The number of business days between successive valuation dates when multiple valuation dates are applicable for cash settlement. ISDA 2003 Term: Business Days thereafter.
        /// </summary>
        public int? BusinessDaysThereafter { get; }
        
        /// <summary>
        /// Where multiple valuation dates are specified as being applicable for cash settlement, this element specifies (a) the number of applicable valuation dates, and (b) the number of business days after satisfaction of all conditions to settlement when the first such valuation date occurs, and (c) the number of business days thereafter of each successive valuation date. ISDA 2003 Term: Multiple Valuation Dates.
        /// </summary>
        public int? NumberValuationDates { get; }
        
        /// <inheritdoc/>
        public int? BusinessDays { get; }
    }
    
    /// <summary>
    /// A class to represent the attributes that are specific to a natural person.
    /// </summary>
    public class NaturalPerson : AbstractRosettaModelObject<NaturalPerson>
    {
        private static readonly IRosettaMetaData<NaturalPerson> metaData = new NaturalPersonMeta();
        
        [JsonConstructor]
        public NaturalPerson(ContactInformation? contactInformation, LocalDate? dateOfBirth, string? firstName, string? honorific, IEnumerable<string> initial, _MetaFields? meta, IEnumerable<string> middleName, IEnumerable<FieldWithMetaPersonIdentifier> personId, IEnumerable<NaturalPersonRole> personRole, string? suffix, string? surname)
        {
            ContactInformation = contactInformation;
            DateOfBirth = dateOfBirth;
            FirstName = firstName;
            Honorific = honorific;
            Initial = initial;
            Meta = meta;
            MiddleName = middleName;
            PersonId = personId;
            PersonRole = personRole;
            Suffix = suffix;
            Surname = surname;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<NaturalPerson> MetaData => metaData;
        
        /// <summary>
        /// The contact information for such person, when different from the contact information associated with the party.
        /// </summary>
        public ContactInformation? ContactInformation { get; }
        
        /// <summary>
        /// The natural person&apos;s date of birth.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? DateOfBirth { get; }
        
        /// <summary>
        /// The natural person&apos;s first name. It is optional in FpML.
        /// </summary>
        public string? FirstName { get; }
        
        /// <summary>
        /// An honorific title, such as Mr., Ms., Dr. etc.
        /// </summary>
        public string? Honorific { get; }
        
        /// <summary>
        /// The natural person&apos;s middle initial(s). If a middle initial is provided then a name should be absent.
        /// </summary>
        public IEnumerable<string> Initial { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <summary>
        /// The natural person&apos;s middle name(s). If a middle name is provided then an initial should be absent.
        /// </summary>
        public IEnumerable<string> MiddleName { get; }
        
        /// <summary>
        /// The identifier associated with a person, e.g. the internal identification code.
        /// </summary>
        public IEnumerable<FieldWithMetaPersonIdentifier> PersonId { get; }
        
        /// <summary>
        /// The role of the person(s) 
        /// </summary>
        public IEnumerable<NaturalPersonRole> PersonRole { get; }
        
        /// <summary>
        /// Name suffix, such as Jr., III, etc.
        /// </summary>
        public string? Suffix { get; }
        
        /// <summary>
        /// The natural person&apos;s surname.
        /// </summary>
        public string? Surname { get; }
    }
    
    /// <summary>
    /// A class to specify the role(s) that natural person(s) may have in relation to the contract.
    /// </summary>
    public class NaturalPersonRole : AbstractRosettaModelObject<NaturalPersonRole>
    {
        private static readonly IRosettaMetaData<NaturalPersonRole> metaData = new NaturalPersonRoleMeta();
        
        [JsonConstructor]
        public NaturalPersonRole(ReferenceWithMetaNaturalPerson personReference, IEnumerable<FieldWithMetaNaturalPersonRoleEnum> role)
        {
            PersonReference = personReference;
            Role = role;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<NaturalPersonRole> MetaData => metaData;
        
        /// <summary>
        /// A reference to the natural person to whom the role refers to.
        /// </summary>
        public ReferenceWithMetaNaturalPerson PersonReference { get; }
        
        /// <summary>
        /// FpML specifies a person role that is distinct from the party role.
        /// </summary>
        public IEnumerable<FieldWithMetaNaturalPersonRoleEnum> Role { get; }
    }
    
    public class New : AbstractRosettaModelObject<New>
    {
        private static readonly IRosettaMetaData<New> metaData = new NewMeta();
        
        [JsonConstructor]
        public New(AddtlAttrbts addtlAttrbts, Buyr buyr, ExctgPrsn exctgPrsn, string exctgPty, FinInstrm finInstrm, InvstmtDcsnPrsn invstmtDcsnPrsn, string invstmtPtyInd, OrdrTrnsmssn ordrTrnsmssn, Sellr sellr, string submitgPty, Tx tx, string txId)
        {
            AddtlAttrbts = addtlAttrbts;
            Buyr = buyr;
            ExctgPrsn = exctgPrsn;
            ExctgPty = exctgPty;
            FinInstrm = finInstrm;
            InvstmtDcsnPrsn = invstmtDcsnPrsn;
            InvstmtPtyInd = invstmtPtyInd;
            OrdrTrnsmssn = ordrTrnsmssn;
            Sellr = sellr;
            SubmitgPty = submitgPty;
            Tx = tx;
            TxId = txId;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<New> MetaData => metaData;
        
        public AddtlAttrbts AddtlAttrbts { get; }
        
        public Buyr Buyr { get; }
        
        public ExctgPrsn ExctgPrsn { get; }
        
        public string ExctgPty { get; }
        
        public FinInstrm FinInstrm { get; }
        
        public InvstmtDcsnPrsn InvstmtDcsnPrsn { get; }
        
        public string InvstmtPtyInd { get; }
        
        public OrdrTrnsmssn OrdrTrnsmssn { get; }
        
        public Sellr Sellr { get; }
        
        public string SubmitgPty { get; }
        
        public Tx Tx { get; }
        
        public string TxId { get; }
    }
    
    public class Nm : AbstractRosettaModelObject<Nm>
    {
        private static readonly IRosettaMetaData<Nm> metaData = new NmMeta();
        
        [JsonConstructor]
        public Nm(RefRate refRate, Term term)
        {
            RefRate = refRate;
            Term = term;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Nm> MetaData => metaData;
        
        public RefRate RefRate { get; }
        
        public Term Term { get; }
    }
    
    /// <summary>
    /// Specifies a quantity as a non-negative number, which condition is enforced through a data rule that only applies to the extending class.
    /// </summary>
    public class NonNegativeQuantity : AbstractRosettaModelObject<NonNegativeQuantity>, IQuantity
    {
        private static readonly IRosettaMetaData<NonNegativeQuantity> metaData = new NonNegativeQuantityMeta();
        
        [JsonConstructor]
        public NonNegativeQuantity(Frequency? frequency, Measure? multiplier, IEnumerable<DatedValue> datedValue, UnitType? unit, decimal? value)
        {
            Frequency = frequency;
            Multiplier = multiplier;
            DatedValue = datedValue;
            Unit = unit;
            Value = value;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<NonNegativeQuantity> MetaData => metaData;
        
        /// <inheritdoc/>
        public Frequency? Frequency { get; }
        
        /// <inheritdoc/>
        public Measure? Multiplier { get; }
        
        /// <inheritdoc/>
        public IEnumerable<DatedValue> DatedValue { get; }
        
        /// <inheritdoc/>
        public UnitType? Unit { get; }
        
        /// <inheritdoc/>
        public decimal? Value { get; }
    }
    
    public class NonNegativeQuantitySchedule : AbstractRosettaModelObject<NonNegativeQuantitySchedule>, IQuantitySchedule
    {
        private static readonly IRosettaMetaData<NonNegativeQuantitySchedule> metaData = new NonNegativeQuantityScheduleMeta();
        
        [JsonConstructor]
        public NonNegativeQuantitySchedule(Frequency? frequency, Measure? multiplier, IEnumerable<DatedValue> datedValue, UnitType? unit, decimal? value)
        {
            Frequency = frequency;
            Multiplier = multiplier;
            DatedValue = datedValue;
            Unit = unit;
            Value = value;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<NonNegativeQuantitySchedule> MetaData => metaData;
        
        /// <inheritdoc/>
        public Frequency? Frequency { get; }
        
        /// <inheritdoc/>
        public Measure? Multiplier { get; }
        
        /// <inheritdoc/>
        public IEnumerable<DatedValue> DatedValue { get; }
        
        /// <inheritdoc/>
        public UnitType? Unit { get; }
        
        /// <inheritdoc/>
        public decimal? Value { get; }
    }
    
    /// <summary>
    /// A class defining a step date and non-negative step value pair. This step definitions are used to define varying rate or amount schedules, e.g. a notional amortisation or a step-up coupon schedule.
    /// </summary>
    public class NonNegativeStep : AbstractRosettaModelObject<NonNegativeStep>
    {
        private static readonly IRosettaMetaData<NonNegativeStep> metaData = new NonNegativeStepMeta();
        
        [JsonConstructor]
        public NonNegativeStep(_MetaFields? meta, LocalDate stepDate, decimal stepValue)
        {
            Meta = meta;
            StepDate = stepDate;
            StepValue = stepValue;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<NonNegativeStep> MetaData => metaData;
        
        public _MetaFields? Meta { get; }
        
        /// <summary>
        /// The date on which the associated stepValue becomes effective. This day may be subject to adjustment in accordance with a business day convention.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate StepDate { get; }
        
        /// <summary>
        /// The non-negative rate or amount which becomes effective on the associated stepDate. A rate of 5% would be represented as 0.05.
        /// </summary>
        public decimal StepValue { get; }
    }
    
    /// <summary>
    /// A class to specify the ISDA 2003 Term: Not Domestic Currency.
    /// </summary>
    public class NotDomesticCurrency : AbstractRosettaModelObject<NotDomesticCurrency>
    {
        private static readonly IRosettaMetaData<NotDomesticCurrency> metaData = new NotDomesticCurrencyMeta();
        
        [JsonConstructor]
        public NotDomesticCurrency(bool applicable, FieldWithMetaString? currency)
        {
            Applicable = applicable;
            Currency = currency;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<NotDomesticCurrency> MetaData => metaData;
        
        /// <summary>
        /// Indicates whether the Not Domestic Currency provision is applicable.
        /// </summary>
        public bool Applicable { get; }
        
        /// <summary>
        /// An explicit specification of the domestic currency. The list of valid currencies is not presently positioned as an enumeration as part of the CDM because that scope is limited to the values specified by ISDA and FpML. As a result, implementers have to make reference to the relevant standard, such as the ISO 4217 standard for currency codes.
        /// </summary>
        public FieldWithMetaString? Currency { get; }
    }
    
    /// <summary>
    /// The number bound is defined as a number and whether the bound is inclusive.
    /// </summary>
    public class NumberBound : AbstractRosettaModelObject<NumberBound>
    {
        private static readonly IRosettaMetaData<NumberBound> metaData = new NumberBoundMeta();
        
        [JsonConstructor]
        public NumberBound(bool inclusive, decimal number)
        {
            Inclusive = inclusive;
            Number = number;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<NumberBound> MetaData => metaData;
        
        /// <summary>
        /// Whether the number bound is inclusive, e.g. for a lower bound, false would indicate greater than, whereas true would indicate greater than or equal to.
        /// </summary>
        public bool Inclusive { get; }
        
        /// <summary>
        /// The number to be used as the bound, e.g. 5.
        /// </summary>
        public decimal Number { get; }
    }
    
    /// <summary>
    /// The number range defined as either a lower and upper number bound, or both.
    /// </summary>
    public class NumberRange : AbstractRosettaModelObject<NumberRange>
    {
        private static readonly IRosettaMetaData<NumberRange> metaData = new NumberRangeMeta();
        
        [JsonConstructor]
        public NumberRange(NumberBound? lowerBound, NumberBound? upperBound)
        {
            LowerBound = lowerBound;
            UpperBound = upperBound;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<NumberRange> MetaData => metaData;
        
        /// <summary>
        /// The lower bound of a number range, e.g. greater than or equal to 5.
        /// </summary>
        public NumberBound? LowerBound { get; }
        
        /// <summary>
        /// The upper bound of a number range, e.g. less than 10.
        /// </summary>
        public NumberBound? UpperBound { get; }
    }
    
    /// <summary>
    /// A class to specify the underlying obligations of the reference entity on which protection is purchased or sold through the Credit Default Swap.
    /// </summary>
    public class Obligations : AbstractRosettaModelObject<Obligations>
    {
        private static readonly IRosettaMetaData<Obligations> metaData = new ObligationsMeta();
        
        [JsonConstructor]
        public Obligations(bool? cashSettlementOnly, Enums.ObligationCategory category, bool? continuity, bool? deliveryOfCommitments, FieldWithMetaString? designatedPriority, string? excluded, bool? fullFaithAndCreditObLiability, bool? generalFundObligationLiability, bool? listed, bool? notContingent, NotDomesticCurrency? notDomesticCurrency, bool? notDomesticIssuance, bool? notDomesticLaw, bool? notSovereignLender, bool? notSubordinated, string? othReferenceEntityObligations, bool? revenueObligationLiability, SpecifiedCurrency? specifiedCurrency)
        {
            CashSettlementOnly = cashSettlementOnly;
            Category = category;
            Continuity = continuity;
            DeliveryOfCommitments = deliveryOfCommitments;
            DesignatedPriority = designatedPriority;
            Excluded = excluded;
            FullFaithAndCreditObLiability = fullFaithAndCreditObLiability;
            GeneralFundObligationLiability = generalFundObligationLiability;
            Listed = listed;
            NotContingent = notContingent;
            NotDomesticCurrency = notDomesticCurrency;
            NotDomesticIssuance = notDomesticIssuance;
            NotDomesticLaw = notDomesticLaw;
            NotSovereignLender = notSovereignLender;
            NotSubordinated = notSubordinated;
            OthReferenceEntityObligations = othReferenceEntityObligations;
            RevenueObligationLiability = revenueObligationLiability;
            SpecifiedCurrency = specifiedCurrency;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Obligations> MetaData => metaData;
        
        /// <summary>
        /// An obligation and deliverable obligation characteristic. Defined in the ISDA published Standard Terms Supplement for use with CDS Transactions on Leveraged Loans. ISDA 2003 Term: Cash Settlement Only.
        /// </summary>
        public bool? CashSettlementOnly { get; }
        
        /// <summary>
        /// Used in both obligations and deliverable obligations to represent a class or type of securities which apply. ISDA 2003 Term: Obligation Category/Deliverable Obligation Category.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.ObligationCategory Category { get; }
        
        /// <summary>
        /// An obligation and deliverable obligation characteristic. Defined in the ISDA published Standard Terms Supplement for use with CDS Transactions on Leveraged Loans. ISDA 2003 Term: Continuity.
        /// </summary>
        public bool? Continuity { get; }
        
        /// <summary>
        /// An obligation and deliverable obligation characteristic. Defined in the ISDA published Standard Terms Supplement for use with CDS Transactions on Leveraged Loans. ISDA 2003 Term: Delivery of Commitments.
        /// </summary>
        public bool? DeliveryOfCommitments { get; }
        
        /// <summary>
        /// Applies to Loan CDS, to indicate what lien level is appropriate for a deliverable obligation. Applies to European Loan CDS, to indicate the Ranking of the obligation. Example: a 2nd lien Loan CDS would imply that the deliverable obligations are 1st or 2nd lien loans.
        /// </summary>
        public FieldWithMetaString? DesignatedPriority { get; }
        
        /// <summary>
        /// A free format string to specify any excluded obligations or deliverable obligations, as the case may be, of the reference entity or excluded types of obligations or deliverable obligations. ISDA 2003 Term: Excluded Obligations/Excluded Deliverable Obligations.
        /// </summary>
        public string? Excluded { get; }
        
        /// <summary>
        /// An obligation and deliverable obligation characteristic. Defined in the ISDA published additional provisions for U.S. Municipal as Reference Entity. ISDA 2003 Term: Full Faith and Credit Obligation Liability.
        /// </summary>
        public bool? FullFaithAndCreditObLiability { get; }
        
        /// <summary>
        /// An obligation and deliverable obligation characteristic. Defined in the ISDA published additional provisions for U.S. Municipal as Reference Entity. ISDA 2003 Term: General Fund Obligation Liability.
        /// </summary>
        public bool? GeneralFundObligationLiability { get; }
        
        /// <summary>
        /// An obligation and deliverable obligation characteristic. Indicates whether or not the obligation is quoted, listed or ordinarily purchased and sold on an exchange. ISDA 2003 Term: Listed.
        /// </summary>
        public bool? Listed { get; }
        
        /// <summary>
        /// OTE: Only allowed as an obligation characteristic under ISDA Credit 1999. In essence Not Contingent means the repayment of principal cannot be dependent on a formula/index, i.e. to prevent the risk of being delivered an instrument that may never pay any element of principal, and to ensure that the obligation is interest bearing (on a regular schedule). ISDA 2003 Term: Not Contingent.
        /// </summary>
        public bool? NotContingent { get; }
        
        /// <summary>
        /// An obligation and deliverable obligation characteristic. Any obligation that is payable in any currency other than the domestic currency. Domestic currency is either the currency so specified or, if no currency is specified, the currency of (a) the reference entity, if the reference entity is a sovereign, or (b) the jurisdiction in which the relevant reference entity is organised, if the reference entity is not a sovereign. ISDA 2003 Term: Not Domestic Currency.
        /// </summary>
        public NotDomesticCurrency? NotDomesticCurrency { get; }
        
        /// <summary>
        /// An obligation and deliverable obligation characteristic. Any obligation other than an obligation that was intended to be offered for sale primarily in the domestic market of the relevant Reference Entity. This specifies that the obligation must be an internationally recognised bond. ISDA 2003 Term: Not Domestic Issuance.
        /// </summary>
        public bool? NotDomesticIssuance { get; }
        
        /// <summary>
        /// An obligation and deliverable obligation characteristic. If the reference entity is a Sovereign, this means any obligation that is not subject to the laws of the reference entity. If the reference entity is not a sovereign, this means any obligation that is not subject to the laws of the jurisdiction of the reference entity. ISDA 2003 Term: Not Domestic Law.
        /// </summary>
        public bool? NotDomesticLaw { get; }
        
        /// <summary>
        /// An obligation and deliverable obligation characteristic. Any obligation that is not primarily (majority) owed to a Sovereign or Supranational Organisation. ISDA 2003 Term: Not Sovereign Lender.
        /// </summary>
        public bool? NotSovereignLender { get; }
        
        /// <summary>
        /// An obligation and deliverable obligation characteristic. An obligation that ranks at least equal with the most senior Reference Obligation in priority of payment or, if no Reference Obligation is specified in the related Confirmation, the obligations of the Reference Entity that are senior. ISDA 2003 Term: Not Subordinated.
        /// </summary>
        public bool? NotSubordinated { get; }
        
        /// <summary>
        /// This element is used to specify any other obligations of a reference entity in both obligations and deliverable obligations. The obligations can be specified free-form. ISDA 2003 Term: Other Obligations of a Reference Entity.
        /// </summary>
        public string? OthReferenceEntityObligations { get; }
        
        /// <summary>
        /// An obligation and deliverable obligation characteristic. Defined in the ISDA published additional provisions for U.S. Municipal as Reference Entity. ISDA 2003 Term: Revenue Obligation Liability.
        /// </summary>
        public bool? RevenueObligationLiability { get; }
        
        /// <summary>
        /// An obligation and deliverable obligation characteristic. The currency or currencies in which an obligation or deliverable obligation must be payable. ISDA 2003 Term: Specified Currency.
        /// </summary>
        public SpecifiedCurrency? SpecifiedCurrency { get; }
    }
    
    /// <summary>
    /// Specifies the object to be observed for a price, it could be an asset or a reference.
    /// </summary>
    public class Observable : AbstractRosettaModelObject<Observable>
    {
        private static readonly IRosettaMetaData<Observable> metaData = new ObservableMeta();
        
        [JsonConstructor]
        public Observable(FieldWithMetaCommodity? commodity, FieldWithMetaQuotedCurrencyPair? currencyPair, _MetaFields? meta, Enums.OptionReferenceType? optionReferenceType, IEnumerable<FieldWithMetaProductIdentifier> productIdentifier, FieldWithMetaFloatingRateOption? rateOption)
        {
            Commodity = commodity;
            CurrencyPair = currencyPair;
            Meta = meta;
            OptionReferenceType = optionReferenceType;
            ProductIdentifier = productIdentifier;
            RateOption = rateOption;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Observable> MetaData => metaData;
        
        /// <summary>
        /// Identifies a commodity by referencing a product identifier.
        /// </summary>
        public FieldWithMetaCommodity? Commodity { get; }
        
        /// <summary>
        /// Describes the composition of a rate that has been quoted or is to be quoted, including the two currencies and the quotation relationship between the two currencies.
        /// </summary>
        public FieldWithMetaQuotedCurrencyPair? CurrencyPair { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <summary>
        /// The underlying contract which is referenced when determining the final settlement price of the instrument. Eg. Rolling Front Month Future; Spot etc.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.OptionReferenceType? OptionReferenceType { get; }
        
        /// <summary>
        /// Comprises of an identifier and a source. The associated metadata key denotes the ability to associate a hash value to the ProductIdentifier instantiations for the purpose of model cross-referencing, in support of functionality such as the event effect and the lineage.
        /// </summary>
        public IEnumerable<FieldWithMetaProductIdentifier> ProductIdentifier { get; }
        
        /// <summary>
        /// Specifies a floating rate index and tenor.
        /// </summary>
        public FieldWithMetaFloatingRateOption? RateOption { get; }
    }
    
    /// <summary>
    /// Defines a single, numerical value that was observed in the marketplace. Observations of market data are made independently to business events or trade life-cycle events, so data instances of Observation can be created independently of any other model type, hence it is annotated as a root type. Observations will be broadly reused in many situations, so references to Observation are supported via the &apos;key&apos; annotation.
    /// </summary>
    public class Observation : AbstractRosettaModelObject<Observation>
    {
        private static readonly IRosettaMetaData<Observation> metaData = new ObservationMeta();
        
        [JsonConstructor]
        public Observation(_MetaFields? meta, ObservationIdentifier observationIdentifier, Price observedValue)
        {
            Meta = meta;
            ObservationIdentifier = observationIdentifier;
            ObservedValue = observedValue;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Observation> MetaData => metaData;
        
        public _MetaFields? Meta { get; }
        
        /// <summary>
        /// Represents the observation was made i.e. how to uniquely identify the observed value among the population of all available market data.
        /// </summary>
        public ObservationIdentifier ObservationIdentifier { get; }
        
        /// <summary>
        /// Specifies the observed value as a number.
        /// </summary>
        public Price ObservedValue { get; }
    }
    
    /// <summary>
    /// Specifies a single date on which market observations take place and specifies optional associated weighting.
    /// </summary>
    public class ObservationDate : AbstractRosettaModelObject<ObservationDate>
    {
        private static readonly IRosettaMetaData<ObservationDate> metaData = new ObservationDateMeta();
        
        [JsonConstructor]
        public ObservationDate(LocalDate? adjustedDate, _MetaFields? meta, string? observationReference, LocalDate? unadjustedDate, decimal? weight)
        {
            AdjustedDate = adjustedDate;
            Meta = meta;
            ObservationReference = observationReference;
            UnadjustedDate = unadjustedDate;
            Weight = weight;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ObservationDate> MetaData => metaData;
        
        /// <summary>
        /// The date once the adjustment has been performed. (Note that this date may change if the business center holidays change).
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? AdjustedDate { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <summary>
        /// Specifies an identification key for the market observation. This attribute can be used as a reference to assign weights to a series of dates defined in a parametricSchedule.
        /// </summary>
        public string? ObservationReference { get; }
        
        /// <summary>
        /// A date subject to adjustment.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? UnadjustedDate { get; }
        
        /// <summary>
        /// Specifies the degree of importance of the observation.
        /// </summary>
        public decimal? Weight { get; }
    }
    
    /// <summary>
    /// Describes date details for a set of observation dates in parametric or non-parametric form.
    /// </summary>
    public class ObservationDates : AbstractRosettaModelObject<ObservationDates>
    {
        private static readonly IRosettaMetaData<ObservationDates> metaData = new ObservationDatesMeta();
        
        [JsonConstructor]
        public ObservationDates(ObservationSchedule? observationSchedule, ParametricDates? parametricDates, PeriodicDates? periodicSchedule)
        {
            ObservationSchedule = observationSchedule;
            ParametricDates = parametricDates;
            PeriodicSchedule = periodicSchedule;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ObservationDates> MetaData => metaData;
        
        /// <summary>
        /// Specifies a schedule of dates (non-parametric) on which market observations take place, and allows for the optional definition of weights where applicable.  When no weight is specified, then weight of each date is assumed to be 1.0
        /// </summary>
        public ObservationSchedule? ObservationSchedule { get; }
        
        /// <summary>
        /// Specifies parametric terms to determine which days within a given calculation period the price would be observed. Typically associated with Commodities. 
        /// </summary>
        public ParametricDates? ParametricDates { get; }
        
        /// <summary>
        /// Specifies the date range and frequency on which market observations take place.  Weights can be assigned to dates in the schedule by assigning the weight and corresponding observationReference in the observationSchedule.
        /// </summary>
        public PeriodicDates? PeriodicSchedule { get; }
    }
    
    /// <summary>
    /// Specifies the necessary information to create any observation event.
    /// </summary>
    public class ObservationEvent : AbstractRosettaModelObject<ObservationEvent>
    {
        private static readonly IRosettaMetaData<ObservationEvent> metaData = new ObservationEventMeta();
        
        [JsonConstructor]
        public ObservationEvent(CorporateAction? corporateAction, CreditEvent? creditEvent)
        {
            CorporateAction = corporateAction;
            CreditEvent = creditEvent;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ObservationEvent> MetaData => metaData;
        
        /// <summary>
        /// Specifies the necessary information to create a corporate action.
        /// </summary>
        public CorporateAction? CorporateAction { get; }
        
        /// <summary>
        /// Specifies the necessary information to create a credit event.
        /// </summary>
        public CreditEvent? CreditEvent { get; }
    }
    
    /// <summary>
    /// Defines the parameters needed to uniquely identify a piece of data among the population of all available market data.
    /// </summary>
    public class ObservationIdentifier : AbstractRosettaModelObject<ObservationIdentifier>
    {
        private static readonly IRosettaMetaData<ObservationIdentifier> metaData = new ObservationIdentifierMeta();
        
        [JsonConstructor]
        public ObservationIdentifier(DeterminationMethodology? determinationMethodology, InformationSource? informationSource, Observable observable, LocalDate observationDate, TimeZone? observationTime)
        {
            DeterminationMethodology = determinationMethodology;
            InformationSource = informationSource;
            Observable = observable;
            ObservationDate = observationDate;
            ObservationTime = observationTime;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ObservationIdentifier> MetaData => metaData;
        
        /// <summary>
        /// Specifies the method according to which an amount or a date is determined.
        /// </summary>
        public DeterminationMethodology? DeterminationMethodology { get; }
        
        /// <summary>
        /// Represents where the market data published and should be observed.
        /// </summary>
        public InformationSource? InformationSource { get; }
        
        /// <summary>
        /// Represents the asset or rate to which the observation relates.
        /// </summary>
        public Observable Observable { get; }
        
        /// <summary>
        /// Specifies the date value to use when resolving the market data.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate ObservationDate { get; }
        
        /// <summary>
        /// Represents the time and time-zone.
        /// </summary>
        public TimeZone? ObservationTime { get; }
    }
    
    /// <summary>
    /// Specifies inputs needed to process an observation.
    /// </summary>
    public class ObservationInstruction : AbstractRosettaModelObject<ObservationInstruction>
    {
        private static readonly IRosettaMetaData<ObservationInstruction> metaData = new ObservationInstructionMeta();
        
        [JsonConstructor]
        public ObservationInstruction(ObservationEvent observationEvent)
        {
            ObservationEvent = observationEvent;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ObservationInstruction> MetaData => metaData;
        
        /// <summary>
        /// Contains all information related to an observation.
        /// </summary>
        public ObservationEvent ObservationEvent { get; }
    }
    
    /// <summary>
    /// Parameters on daily observed computed rates, specifically daily caps and floors. This type is used to represent modular computed rates in interestRatePayouts.
    /// </summary>
    public class ObservationParameters : AbstractRosettaModelObject<ObservationParameters>
    {
        private static readonly IRosettaMetaData<ObservationParameters> metaData = new ObservationParametersMeta();
        
        [JsonConstructor]
        public ObservationParameters(decimal? observationCapRate, decimal? observationFloorRate)
        {
            ObservationCapRate = observationCapRate;
            ObservationFloorRate = observationFloorRate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ObservationParameters> MetaData => metaData;
        
        /// <summary>
        /// A daily observation cap rate.
        /// </summary>
        public decimal? ObservationCapRate { get; }
        
        /// <summary>
        /// A daily observation floor rate.
        /// </summary>
        public decimal? ObservationFloorRate { get; }
    }
    
    /// <summary>
    /// Specifies a single date on which market observations take place and specifies optional associated weighting.
    /// </summary>
    public class ObservationSchedule : AbstractRosettaModelObject<ObservationSchedule>
    {
        private static readonly IRosettaMetaData<ObservationSchedule> metaData = new ObservationScheduleMeta();
        
        [JsonConstructor]
        public ObservationSchedule(BusinessDayAdjustments? dateAdjustments, IEnumerable<ObservationDate> observationDate)
        {
            DateAdjustments = dateAdjustments;
            ObservationDate = observationDate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ObservationSchedule> MetaData => metaData;
        
        /// <summary>
        /// The business day convention and financial business centers used for adjusting the date if it would otherwise fall on a day that is not a business date in the specified business centers.
        /// </summary>
        public BusinessDayAdjustments? DateAdjustments { get; }
        
        /// <summary>
        /// Specifies an adjusted or unadjusted date for a market observation.
        /// </summary>
        public IEnumerable<ObservationDate> ObservationDate { get; }
    }
    
    /// <summary>
    /// Parameters to describe the observation shift for a daily compounded or averaged floating rate. This type is used to represent modular computed rates in interestRatePayouts.
    /// </summary>
    public class ObservationShiftCalculation : AbstractRosettaModelObject<ObservationShiftCalculation>
    {
        private static readonly IRosettaMetaData<ObservationShiftCalculation> metaData = new ObservationShiftCalculationMeta();
        
        [JsonConstructor]
        public ObservationShiftCalculation(BusinessCenters? additionalBusinessDays, Enums.ObservationPeriodDates? calculationBase, int? offsetDays)
        {
            AdditionalBusinessDays = additionalBusinessDays;
            CalculationBase = calculationBase;
            OffsetDays = offsetDays;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ObservationShiftCalculation> MetaData => metaData;
        
        /// <summary>
        /// Any additional business days that be applicable.
        /// </summary>
        public BusinessCenters? AdditionalBusinessDays { get; }
        
        /// <summary>
        /// Whether the rate is calculated in advance, in arrears, or relative to a reset date.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.ObservationPeriodDates? CalculationBase { get; }
        
        /// <summary>
        /// The number of days of observation shift.
        /// </summary>
        public int? OffsetDays { get; }
    }
    
    /// <summary>
    /// The observation source can be composed of an curve and/or and information source.
    /// </summary>
    public class ObservationSource : AbstractRosettaModelObject<ObservationSource>
    {
        private static readonly IRosettaMetaData<ObservationSource> metaData = new ObservationSourceMeta();
        
        [JsonConstructor]
        public ObservationSource(Curve? curve, InformationSource? informationSource)
        {
            Curve = curve;
            InformationSource = informationSource;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ObservationSource> MetaData => metaData;
        
        public Curve? Curve { get; }
        
        public InformationSource? InformationSource { get; }
    }
    
    /// <summary>
    /// Class containing terms that are associated with observing a price/benchmark/index across either single or multiple observations. 
    /// </summary>
    public class ObservationTerms : AbstractRosettaModelObject<ObservationTerms>
    {
        private static readonly IRosettaMetaData<ObservationTerms> metaData = new ObservationTermsMeta();
        
        [JsonConstructor]
        public ObservationTerms(CalculationPeriodDates? calculationPeriodDates, FxSpotRateSource? informationSource, int? numberOfObservationDates, Observable? observable, ObservationDates observationDates, Rounding? precision, BusinessCenterTime? pricingTime, Enums.TimeType? pricingTimeType)
        {
            CalculationPeriodDates = calculationPeriodDates;
            InformationSource = informationSource;
            NumberOfObservationDates = numberOfObservationDates;
            Observable = observable;
            ObservationDates = observationDates;
            Precision = precision;
            PricingTime = pricingTime;
            PricingTimeType = pricingTimeType;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ObservationTerms> MetaData => metaData;
        
        /// <summary>
        /// Defines parameters used to generate the calculation period dates schedule, including the specification of any initial or final stub calculation periods. A calculation period schedule consists of an optional initial stub calculation period, one or more regular calculation periods and an optional final stub calculation period. In the absence of any initial or final stub calculation periods, the regular part of the calculation period schedule is assumed to be between the effective date and the termination date. No implicit stubs are allowed, i.e. stubs must be explicitly specified using an appropriate combination of firstPeriodStartDate, firstRegularPeriodStartDate and lastRegularPeriodEndDate.
        /// </summary>
        public CalculationPeriodDates? CalculationPeriodDates { get; }
        
        /// <summary>
        /// The information source where a published or displayed market rate will be obtained, e.g. Telerate Page 3750.
        /// </summary>
        public FxSpotRateSource? InformationSource { get; }
        
        /// <summary>
        /// The number of observation dates between observation start date and observation end date.
        /// </summary>
        public int? NumberOfObservationDates { get; }
        
        /// <summary>
        /// Specifies the object to be observed for a price, it could be an asset or a reference.
        /// </summary>
        public Observable? Observable { get; }
        
        /// <summary>
        /// Describes date details for a set of observation dates in parametric or non-parametric form.
        /// </summary>
        public ObservationDates ObservationDates { get; }
        
        /// <summary>
        /// Defines rounding rules and precision to be used in the rounding of observations.
        /// </summary>
        public Rounding? Precision { get; }
        
        /// <summary>
        /// Defines time in respect to a business calendar location that the price/benchmark/index is observed
        /// </summary>
        public BusinessCenterTime? PricingTime { get; }
        
        /// <summary>
        /// The enumerated values to specify points in the day when option exercise and valuation can occur.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.TimeType? PricingTimeType { get; }
    }
    
    /// <summary>
    /// A class defining an offset used in calculating a new date relative to a reference date, e.g. calendar days, business days, commodity Business days, etc.
    /// </summary>
    public class Offset : AbstractRosettaModelObject<Offset>, IOffset, IPeriod
    {
        private static readonly IRosettaMetaData<Offset> metaData = new OffsetMeta();
        
        [JsonConstructor]
        public Offset(Enums.DayType? dayType, _MetaFields? meta, Enums.Period period, int periodMultiplier)
        {
            DayType = dayType;
            Meta = meta;
            PeriodValue = period;
            PeriodMultiplier = periodMultiplier;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Offset> MetaData => metaData;
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.DayType? DayType { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        [JsonProperty(PropertyName = "period")]
        public Enums.Period PeriodValue { get; }
        
        /// <inheritdoc/>
        public int PeriodMultiplier { get; }
    }
    
    /// <summary>
    /// Defines business day shifts for daily componded or averaged rates.  This type is used for lookback and lockout rates. This type is used to represent modular computed rates in interestRatePayouts.
    /// </summary>
    public class OffsetCalculation : AbstractRosettaModelObject<OffsetCalculation>
    {
        private static readonly IRosettaMetaData<OffsetCalculation> metaData = new OffsetCalculationMeta();
        
        [JsonConstructor]
        public OffsetCalculation(int? offsetDays)
        {
            OffsetDays = offsetDays;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<OffsetCalculation> MetaData => metaData;
        
        /// <summary>
        /// The number of business days offset.
        /// </summary>
        public int? OffsetDays { get; }
    }
    
    /// <summary>
    ///  A class to represent the applicable terms to qualify an option exercise: the option style (e.g. American style option), the exercise procedure (e.g. manual exercise) and the settlement terms (e.g. physical vs. cash).
    /// </summary>
    public class OptionExercise : AbstractRosettaModelObject<OptionExercise>
    {
        private static readonly IRosettaMetaData<OptionExercise> metaData = new OptionExerciseMeta();
        
        [JsonConstructor]
        public OptionExercise(ExerciseProcedure? exerciseProcedure, OptionStyle optionStyle, OptionStrike? strike)
        {
            ExerciseProcedure = exerciseProcedure;
            OptionStyle = optionStyle;
            Strike = strike;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<OptionExercise> MetaData => metaData;
        
        /// <summary>
        /// The set of parameters defining the procedure associated with the exercise, e.g. manual exercise.
        /// </summary>
        public ExerciseProcedure? ExerciseProcedure { get; }
        
        /// <summary>
        /// The option exercise can be of American style, Bermuda style or European style. The FpML implementation makes use of a substitution group.
        /// </summary>
        public OptionStyle OptionStyle { get; }
        
        /// <summary>
        /// Specifies the strike of the option on credit default swap.
        /// </summary>
        public OptionStrike? Strike { get; }
    }
    
    /// <summary>
    /// Defines additional optional features that can be included in an option contract.
    /// </summary>
    public class OptionFeature : AbstractRosettaModelObject<OptionFeature>
    {
        private static readonly IRosettaMetaData<OptionFeature> metaData = new OptionFeatureMeta();
        
        [JsonConstructor]
        public OptionFeature(AveragingCalculation? averagingFeature, Barrier? barrier, IEnumerable<FxFeature> fxFeature, Knock? knock, PassThrough? passThrough, StrategyFeature? strategyFeature)
        {
            AveragingFeature = averagingFeature;
            Barrier = barrier;
            FxFeature = fxFeature;
            Knock = knock;
            PassThrough = passThrough;
            StrategyFeature = strategyFeature;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<OptionFeature> MetaData => metaData;
        
        /// <summary>
        /// Defines an option feature in which an average market observation price is determined on valuation and compared to the strike to determine a settlement amount.
        /// </summary>
        public AveragingCalculation? AveragingFeature { get; }
        
        /// <summary>
        /// Specifies a barrier feature.
        /// </summary>
        public Barrier? Barrier { get; }
        
        /// <summary>
        /// Describes a quanto or composite FX feature.
        /// </summary>
        public IEnumerable<FxFeature> FxFeature { get; }
        
        /// <summary>
        /// Specifies a knock in or knock out feature.
        /// </summary>
        public Knock? Knock { get; }
        
        /// <summary>
        /// Specifies the rules for pass-through payments from the underlier, such as dividends.
        /// </summary>
        public PassThrough? PassThrough { get; }
        
        /// <summary>
        /// Defines a simple strategy feature.
        /// </summary>
        public StrategyFeature? StrategyFeature { get; }
    }
    
    /// <summary>
    ///  The option payout specification terms. The associated globalKey denotes the ability to associate a hash value to the respective OptionPayout instantiation for the purpose of model cross-referencing, in support of functionality such as the event effect and the lineage.
    /// </summary>
    public class OptionPayout : AbstractRosettaModelObject<OptionPayout>, IPayoutBase
    {
        private static readonly IRosettaMetaData<OptionPayout> metaData = new OptionPayoutMeta();
        
        [JsonConstructor]
        public OptionPayout(BuyerSeller buyerSeller, OptionExercise exerciseTerms, OptionFeature? feature, _MetaFields? meta, ObservationTerms? observationTerms, Enums.OptionType? optionType, CommoditySchedule? schedule, Product underlier, PayerReceiver payerReceiver, ResolvablePriceQuantity? priceQuantity, PrincipalPayments? principalPayment, SettlementTerms? settlementTerms)
        {
            BuyerSeller = buyerSeller;
            ExerciseTerms = exerciseTerms;
            Feature = feature;
            Meta = meta;
            ObservationTerms = observationTerms;
            OptionType = optionType;
            Schedule = schedule;
            Underlier = underlier;
            PayerReceiver = payerReceiver;
            PriceQuantity = priceQuantity;
            PrincipalPayment = principalPayment;
            SettlementTerms = settlementTerms;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<OptionPayout> MetaData => metaData;
        
        public BuyerSeller BuyerSeller { get; }
        
        /// <summary>
        /// The terms for exercising the option, which include the option style (e.g. American style option), the exercise procedure (e.g. manual exercise) and the settlement terms (e.g. physical vs. cash).
        /// </summary>
        public OptionExercise ExerciseTerms { get; }
        
        /// <summary>
        /// The option feature, such as quanto, Asian, barrier, knock.
        /// </summary>
        public OptionFeature? Feature { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <summary>
        /// Class containing terms that are associated with observing a price/benchmark/index across either single or multple observations. To be used for option contracts that reference a benchmark price.
        /// </summary>
        public ObservationTerms? ObservationTerms { get; }
        
        /// <summary>
        /// The type of option transaction. From a usage standpoint, put/call is the default option type, while payer/receiver indicator is used for options on index credit default swaps, consistently with the industry practice. Straddle is used for the case of straddle strategy, that combine a call and a put with the same strike.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.OptionType? OptionType { get; }
        
        /// <summary>
        /// Allows the full representation of a commodity payout by defining a set of schedule periods. It supports standard schedule customization by expressing all the dates, quantities, and pricing data in a non-parametric way.
        /// </summary>
        public CommoditySchedule? Schedule { get; }
        
        /// <summary>
        /// The product underlying the option, which can be of any type including ContractualProduct or Security.
        /// </summary>
        public Product Underlier { get; }
        
        /// <inheritdoc/>
        public PayerReceiver PayerReceiver { get; }
        
        /// <inheritdoc/>
        public ResolvablePriceQuantity? PriceQuantity { get; }
        
        /// <inheritdoc/>
        public PrincipalPayments? PrincipalPayment { get; }
        
        /// <inheritdoc/>
        public SettlementTerms? SettlementTerms { get; }
    }
    
    /// <summary>
    /// Defines the strike price of an option.
    /// </summary>
    public class OptionStrike : AbstractRosettaModelObject<OptionStrike>
    {
        private static readonly IRosettaMetaData<OptionStrike> metaData = new OptionStrikeMeta();
        
        [JsonConstructor]
        public OptionStrike(AveragingStrikeFeature? averagingStrikeFeature, ReferenceSwapCurve? referenceSwapCurve, Price? strikePrice, ReferenceWithMetaFixedRateSpecification? strikeReference)
        {
            AveragingStrikeFeature = averagingStrikeFeature;
            ReferenceSwapCurve = referenceSwapCurve;
            StrikePrice = strikePrice;
            StrikeReference = strikeReference;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<OptionStrike> MetaData => metaData;
        
        /// <summary>
        /// Defines an  option strike that is calculated from an average of observed market prices.
        /// </summary>
        public AveragingStrikeFeature? AveragingStrikeFeature { get; }
        
        /// <summary>
        /// Defines the strike of an option when expressed by reference to a swap curve (Typically the case for a convertible bond option).
        /// </summary>
        public ReferenceSwapCurve? ReferenceSwapCurve { get; }
        
        /// <summary>
        /// Defines the strike of an option in the form of a price that could be a cash price, interestRate, or other types.
        /// </summary>
        public Price? StrikePrice { get; }
        
        /// <summary>
        /// Defines the strike of an option in reference to the spread of the underlying swap (typical practice in the case of an option on a credit single name swaps).
        /// </summary>
        public ReferenceWithMetaFixedRateSpecification? StrikeReference { get; }
    }
    
    /// <summary>
    /// The qualification of the option style: American, Bermuda or European. FpML implements those features as part of a substitution group.
    /// </summary>
    public class OptionStyle : AbstractRosettaModelObject<OptionStyle>
    {
        private static readonly IRosettaMetaData<OptionStyle> metaData = new OptionStyleMeta();
        
        [JsonConstructor]
        public OptionStyle(AmericanExercise? americanExercise, BermudaExercise? bermudaExercise, EuropeanExercise? europeanExercise)
        {
            AmericanExercise = americanExercise;
            BermudaExercise = bermudaExercise;
            EuropeanExercise = europeanExercise;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<OptionStyle> MetaData => metaData;
        
        public AmericanExercise? AmericanExercise { get; }
        
        public BermudaExercise? BermudaExercise { get; }
        
        public EuropeanExercise? EuropeanExercise { get; }
    }
    
    /// <summary>
    /// A data defining:  an early termination provision where either or both parties have the right to exercise.
    /// </summary>
    public class OptionalEarlyTermination : AbstractRosettaModelObject<OptionalEarlyTermination>
    {
        private static readonly IRosettaMetaData<OptionalEarlyTermination> metaData = new OptionalEarlyTerminationMeta();
        
        [JsonConstructor]
        public OptionalEarlyTermination(AmericanExercise? americanExercise, BermudaExercise? bermudaExercise, CalculationAgent? calculationAgent, SettlementTerms? cashSettlement, EuropeanExercise? europeanExercise, IEnumerable<ExerciseNotice> exerciseNotice, bool? followUpConfirmation, bool? mutualEarlyTermination, OptionalEarlyTerminationAdjustedDates? optionalEarlyTerminationAdjustedDates, BuyerSeller? singlePartyOption)
        {
            AmericanExercise = americanExercise;
            BermudaExercise = bermudaExercise;
            CalculationAgent = calculationAgent;
            CashSettlement = cashSettlement;
            EuropeanExercise = europeanExercise;
            ExerciseNotice = exerciseNotice;
            FollowUpConfirmation = followUpConfirmation;
            MutualEarlyTermination = mutualEarlyTermination;
            OptionalEarlyTerminationAdjustedDates = optionalEarlyTerminationAdjustedDates;
            SinglePartyOption = singlePartyOption;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<OptionalEarlyTermination> MetaData => metaData;
        
        /// <summary>
        /// American exercise. FpML implementations consists in an exercise substitution group.
        /// </summary>
        public AmericanExercise? AmericanExercise { get; }
        
        /// <summary>
        /// Bermuda exercise. FpML implementations consists in an exercise substitution group.
        /// </summary>
        public BermudaExercise? BermudaExercise { get; }
        
        /// <summary>
        /// The ISDA Calculation Agent responsible for performing duties associated with an optional early termination.
        /// </summary>
        public CalculationAgent? CalculationAgent { get; }
        
        /// <summary>
        /// If specified, this means that cash settlement is applicable to the transaction and defines the parameters associated with the cash settlement procedure. If not specified, then physical settlement is applicable.
        /// </summary>
        public SettlementTerms? CashSettlement { get; }
        
        /// <summary>
        /// European exercise. FpML implementations consists in an exercise substitution group.
        /// </summary>
        public EuropeanExercise? EuropeanExercise { get; }
        
        /// <summary>
        /// Definition of the party to whom notice of exercise should be given.
        /// </summary>
        public IEnumerable<ExerciseNotice> ExerciseNotice { get; }
        
        /// <summary>
        /// A flag to indicate whether follow-up confirmation of exercise (written or electronic) is required following telephonic notice by the buyer to the seller or seller&apos;s agent.
        /// </summary>
        public bool? FollowUpConfirmation { get; }
        
        /// <summary>
        /// Used for specifying whether the Mutual Early Termination Right that is detailed in the Master Confirmation will apply.
        /// </summary>
        public bool? MutualEarlyTermination { get; }
        
        /// <summary>
        /// An early termination provision to terminate the trade at fair value where one or both parties have the right to decide on termination.
        /// </summary>
        public OptionalEarlyTerminationAdjustedDates? OptionalEarlyTerminationAdjustedDates { get; }
        
        /// <summary>
        /// If optional early termination is not available to both parties then this component specifies the buyer and seller of the option. In FpML, this attribute is of type SinglePsrtyOption, which actually consists of the BuyerSeller.model.
        /// </summary>
        public BuyerSeller? SinglePartyOption { get; }
    }
    
    /// <summary>
    /// A data defining:  the adjusted dates associated with an optional early termination provision.
    /// </summary>
    public class OptionalEarlyTerminationAdjustedDates : AbstractRosettaModelObject<OptionalEarlyTerminationAdjustedDates>
    {
        private static readonly IRosettaMetaData<OptionalEarlyTerminationAdjustedDates> metaData = new OptionalEarlyTerminationAdjustedDatesMeta();
        
        [JsonConstructor]
        public OptionalEarlyTerminationAdjustedDates(IEnumerable<EarlyTerminationEvent> earlyTerminationEvent)
        {
            EarlyTerminationEvent = earlyTerminationEvent;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<OptionalEarlyTerminationAdjustedDates> MetaData => metaData;
        
        /// <summary>
        /// The adjusted dates associated with an individual early termination date.
        /// </summary>
        public IEnumerable<EarlyTerminationEvent> EarlyTerminationEvent { get; }
    }
    
    public class OrdrTrnsmssn : AbstractRosettaModelObject<OrdrTrnsmssn>
    {
        private static readonly IRosettaMetaData<OrdrTrnsmssn> metaData = new OrdrTrnsmssnMeta();
        
        [JsonConstructor]
        public OrdrTrnsmssn(string trnsmssnInd)
        {
            TrnsmssnInd = trnsmssnInd;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<OrdrTrnsmssn> MetaData => metaData;
        
        public string TrnsmssnInd { get; }
    }
    
    /// <summary>
    /// A class for defining an agreement executed between parties.
    /// </summary>
    public class OtherAgreement : AbstractRosettaModelObject<OtherAgreement>
    {
        private static readonly IRosettaMetaData<OtherAgreement> metaData = new OtherAgreementMeta();
        
        [JsonConstructor]
        public OtherAgreement(LocalDate? date, FieldWithMetaString? identifier, FieldWithMetaString otherAgreementType, FieldWithMetaString? version)
        {
            Date = date;
            Identifier = identifier;
            OtherAgreementType = otherAgreementType;
            Version = version;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<OtherAgreement> MetaData => metaData;
        
        /// <summary>
        /// The date on which the agreement was signed.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? Date { get; }
        
        /// <summary>
        /// An identifier that has been created to identify the agreement.
        /// </summary>
        public FieldWithMetaString? Identifier { get; }
        
        /// <summary>
        /// The agreement executed between the parties and intended to govern product-specific derivatives transactions between those parties.
        /// </summary>
        public FieldWithMetaString OtherAgreementType { get; }
        
        /// <summary>
        /// The version of the agreement.
        /// </summary>
        public FieldWithMetaString? Version { get; }
    }
    
    /// <summary>
    /// A class to specify a related legal agreement. For example, ISDA 2016 Credit Support Annex for Initial Margin, paragraph 13, General Principles, (s): Other CSA and Japanese Law CSA (VM). | ISDA 2016 Credit Support Annex for Variation Margin, paragraph 13, (o): Other CSA.
    /// </summary>
    public class OtherAgreementTerms : AbstractRosettaModelObject<OtherAgreementTerms>
    {
        private static readonly IRosettaMetaData<OtherAgreementTerms> metaData = new OtherAgreementTermsMeta();
        
        [JsonConstructor]
        public OtherAgreementTerms(bool isSpecified, string? legalDocument)
        {
            IsSpecified = isSpecified;
            LegalDocument = legalDocument;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<OtherAgreementTerms> MetaData => metaData;
        
        /// <summary>
        /// The qualification of whether some other related agreement is specified (True) or not (False).
        /// </summary>
        public bool IsSpecified { get; }
        
        /// <summary>
        /// The specification of this other agreement, when the qualification is True.
        /// </summary>
        public string? LegalDocument { get; }
    }
    
    public class Othr : AbstractRosettaModelObject<Othr>
    {
        private static readonly IRosettaMetaData<Othr> metaData = new OthrMeta();
        
        [JsonConstructor]
        public Othr(DerivInstrmAttrbts derivInstrmAttrbts, FinInstrmGnlAttrbts finInstrmGnlAttrbts, string id, SchmeNm schmeNm)
        {
            DerivInstrmAttrbts = derivInstrmAttrbts;
            FinInstrmGnlAttrbts = finInstrmGnlAttrbts;
            Id = id;
            SchmeNm = schmeNm;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Othr> MetaData => metaData;
        
        public DerivInstrmAttrbts DerivInstrmAttrbts { get; }
        
        public FinInstrmGnlAttrbts FinInstrmGnlAttrbts { get; }
        
        public string Id { get; }
        
        public SchmeNm SchmeNm { get; }
    }
    
    /// <summary>
    /// A class to specify the Partial Cash Deliverable Obligation Characteristic.
    /// </summary>
    public class PCDeliverableObligationCharac : AbstractRosettaModelObject<PCDeliverableObligationCharac>, IPCDeliverableObligationCharac
    {
        private static readonly IRosettaMetaData<PCDeliverableObligationCharac> metaData = new PCDeliverableObligationCharacMeta();
        
        [JsonConstructor]
        public PCDeliverableObligationCharac(bool applicable, bool? partialCashSettlement)
        {
            Applicable = applicable;
            PartialCashSettlement = partialCashSettlement;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<PCDeliverableObligationCharac> MetaData => metaData;
        
        /// <inheritdoc/>
        public bool Applicable { get; }
        
        /// <inheritdoc/>
        public bool? PartialCashSettlement { get; }
    }
    
    /// <summary>
    /// Defines rules for the dates on which the price will be determined.
    /// </summary>
    public class ParametricDates : AbstractRosettaModelObject<ParametricDates>
    {
        private static readonly IRosettaMetaData<ParametricDates> metaData = new ParametricDatesMeta();
        
        [JsonConstructor]
        public ParametricDates(BusinessCenters businessCenters, Enums.DayDistribution? dayDistribution, decimal? dayFrequency, IEnumerable<Enums.DayOfWeek> dayOfWeek, Enums.DayType dayType, Lag? lag)
        {
            BusinessCenters = businessCenters;
            DayDistribution = dayDistribution;
            DayFrequency = dayFrequency;
            DayOfWeek = dayOfWeek;
            DayType = dayType;
            Lag = lag;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ParametricDates> MetaData => metaData;
        
        /// <summary>
        /// The enumerated values to specify the business centers.
        /// </summary>
        public BusinessCenters BusinessCenters { get; }
        
        /// <summary>
        /// Denotes the method by which the pricing days are distributed across the pricing period.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.DayDistribution? DayDistribution { get; }
        
        /// <summary>
        /// Defines the occurrence of the dayOfWeek within the pricing period on which pricing will take place, e.g. the 3rd Friday within each Calculation Period. If omitted, every dayOfWeek will be a pricing day.
        /// </summary>
        public decimal? DayFrequency { get; }
        
        /// <summary>
        /// Indicates the days of the week on which the price will be determined.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public IEnumerable<Enums.DayOfWeek> DayOfWeek { get; }
        
        /// <summary>
        /// Denotes the enumerated values to specify the day type classification used in counting the number of days between two dates.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.DayType DayType { get; }
        
        /// <summary>
        /// The pricing period per calculation period if the pricing days do not wholly fall within the respective calculation period.
        /// </summary>
        public Lag? Lag { get; }
    }
    
    /// <summary>
    /// A class defining partial exercise. As defined in the 2000 ISDA Definitions, Section 12.3 Partial Exercise, the buyer of the option may exercise all or less than all the notional amount of the underlying swap but may not be less than the minimum notional amount (if specified) and must be an integral multiple of the integral multiple amount if specified.
    /// </summary>
    public class PartialExercise : AbstractRosettaModelObject<PartialExercise>, IPartialExercise
    {
        private static readonly IRosettaMetaData<PartialExercise> metaData = new PartialExerciseMeta();
        
        [JsonConstructor]
        public PartialExercise(decimal? integralMultipleAmount, decimal? minimumNotionalAmount, int? minimumNumberOfOptions, ReferenceWithMetaMoney notionaReference)
        {
            IntegralMultipleAmount = integralMultipleAmount;
            MinimumNotionalAmount = minimumNotionalAmount;
            MinimumNumberOfOptions = minimumNumberOfOptions;
            NotionaReference = notionaReference;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<PartialExercise> MetaData => metaData;
        
        /// <inheritdoc/>
        public decimal? IntegralMultipleAmount { get; }
        
        /// <inheritdoc/>
        public decimal? MinimumNotionalAmount { get; }
        
        /// <inheritdoc/>
        public int? MinimumNumberOfOptions { get; }
        
        /// <inheritdoc/>
        public ReferenceWithMetaMoney NotionaReference { get; }
    }
    
    /// <summary>
    /// A class to specify a party, without a qualification as to whether this party is a legal entity or a natural person, although the model provides the ability to associate a person (or set of persons) to a party, which use case would imply that such party would be a legal entity (even if not formally specified as such). 
    /// </summary>
    public class Party : AbstractRosettaModelObject<Party>
    {
        private static readonly IRosettaMetaData<Party> metaData = new PartyMeta();
        
        [JsonConstructor]
        public Party(Account? account, IEnumerable<BusinessUnit> businessUnit, ContactInformation? contactInformation, _MetaFields? meta, FieldWithMetaString? name, IEnumerable<PartyIdentifier> partyId, IEnumerable<NaturalPerson> person, IEnumerable<NaturalPersonRole> personRole)
        {
            Account = account;
            BusinessUnit = businessUnit;
            ContactInformation = contactInformation;
            Meta = meta;
            Name = name;
            PartyId = partyId;
            Person = person;
            PersonRole = personRole;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Party> MetaData => metaData;
        
        /// <summary>
        /// The account that might be associated with the party. At most one account can be specified, as it is expected that this information is used in the context of a contract or legal document where only one account per party can be associated with such object.
        /// </summary>
        public Account? Account { get; }
        
        /// <summary>
        /// Optional organization unit information used to describe the organization units (e.g. trading desks) involved in a transaction or business process, incl. the contact information (when relevant).
        /// </summary>
        public IEnumerable<BusinessUnit> BusinessUnit { get; }
        
        /// <summary>
        /// The postal/street address, telephone number, email address and/or web page. If the contact information is specific to the associated business unit(s) or person (s), it should be associated with those.
        /// </summary>
        public ContactInformation? ContactInformation { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <summary>
        /// The party name.
        /// </summary>
        public FieldWithMetaString? Name { get; }
        
        /// <summary>
        /// The identifier associated with a party, e.g. the 20 digits LEI code.
        /// </summary>
        public IEnumerable<PartyIdentifier> PartyId { get; }
        
        /// <summary>
        /// The person(s) who might be associated with the party as part of the execution, contract or legal document.
        /// </summary>
        public IEnumerable<NaturalPerson> Person { get; }
        
        /// <summary>
        /// The role of the person(s) 
        /// </summary>
        public IEnumerable<NaturalPersonRole> PersonRole { get; }
    }
    
    /// <summary>
    /// Specifies instruction to change the party on a trade. This primitive instruction is used in a number of scenarios including: clearing, allocation and novation. The instrution must include a trade identifier, because a change of party effectively results in a different trade.
    /// </summary>
    public class PartyChangeInstruction : AbstractRosettaModelObject<PartyChangeInstruction>
    {
        private static readonly IRosettaMetaData<PartyChangeInstruction> metaData = new PartyChangeInstructionMeta();
        
        [JsonConstructor]
        public PartyChangeInstruction(AncillaryParty? ancillaryParty, Counterparty counterparty, PartyRole? partyRole, IEnumerable<TradeIdentifier> tradeId)
        {
            AncillaryParty = ancillaryParty;
            Counterparty = counterparty;
            PartyRole = partyRole;
            TradeId = tradeId;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<PartyChangeInstruction> MetaData => metaData;
        
        /// <summary>
        /// Specifies an ancillary party to be added onto the new transaction, e.g. the original executing party in an allocation.
        /// </summary>
        public AncillaryParty? AncillaryParty { get; }
        
        /// <summary>
        /// The new counterparty who is stepping into the trade. The stepping out counterparty is inferred based on the counterparty role that is being updated.
        /// </summary>
        public Counterparty Counterparty { get; }
        
        /// <summary>
        /// Specifies an additional party roles to be added on to the new transaction.
        /// </summary>
        public PartyRole? PartyRole { get; }
        
        /// <summary>
        /// The identifier to be assigned to the new trade post change of party.
        /// </summary>
        public IEnumerable<TradeIdentifier> TradeId { get; }
    }
    
    /// <summary>
    /// A class to specify contact information within a party: address and, optionally, associated business unit and person. This class also supports the ISDA CSA representation as a single string, through the address attribute.
    /// </summary>
    public class PartyContactInformation : AbstractRosettaModelObject<PartyContactInformation>
    {
        private static readonly IRosettaMetaData<PartyContactInformation> metaData = new PartyContactInformationMeta();
        
        [JsonConstructor]
        public PartyContactInformation(string? additionalInformation, IEnumerable<BusinessUnit> businessUnit, ContactInformation? contactInformation, ReferenceWithMetaParty? partyReference, IEnumerable<NaturalPerson> person)
        {
            AdditionalInformation = additionalInformation;
            BusinessUnit = businessUnit;
            ContactInformation = contactInformation;
            PartyReference = partyReference;
            Person = person;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<PartyContactInformation> MetaData => metaData;
        
        /// <summary>
        /// Specification of special instructions of the relevant party.
        /// </summary>
        public string? AdditionalInformation { get; }
        
        /// <summary>
        /// Optional organization unit information used to describe the organization units (e.g. trading desks) involved in a transaction or business process, incl. the contact information (when relevant).
        /// </summary>
        public IEnumerable<BusinessUnit> BusinessUnit { get; }
        
        /// <summary>
        /// The postal/street address, telephone number, email address and/or web page. If the contact information is specific to the associated business unit(s), it should be associated with those.
        /// </summary>
        public ContactInformation? ContactInformation { get; }
        
        /// <summary>
        /// The reference to the party to which the contact information refers to.
        /// </summary>
        public ReferenceWithMetaParty? PartyReference { get; }
        
        /// <summary>
        /// Optional information about people involved in a transaction or business process. (These are employees of the party.)
        /// </summary>
        public IEnumerable<NaturalPerson> Person { get; }
    }
    
    /// <summary>
    /// A class to specify a party-related, non-standardized data in a generic form.
    /// </summary>
    public class PartyCustomisedWorkflow : AbstractRosettaModelObject<PartyCustomisedWorkflow>
    {
        private static readonly IRosettaMetaData<PartyCustomisedWorkflow> metaData = new PartyCustomisedWorkflowMeta();
        
        [JsonConstructor]
        public PartyCustomisedWorkflow(IEnumerable<CustomisedWorkflow> customisedWorkflow, string? partyName, ReferenceWithMetaParty? partyReference)
        {
            CustomisedWorkflow = customisedWorkflow;
            PartyName = partyName;
            PartyReference = partyReference;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<PartyCustomisedWorkflow> MetaData => metaData;
        
        /// <summary>
        /// Non-standardized data in a generic form.
        /// </summary>
        public IEnumerable<CustomisedWorkflow> CustomisedWorkflow { get; }
        
        /// <summary>
        /// The party name to which the workflow pertains to.
        /// </summary>
        public string? PartyName { get; }
        
        /// <summary>
        /// Reference to the party to which the workflow pertains to.
        /// </summary>
        public ReferenceWithMetaParty? PartyReference { get; }
    }
    
    /// <summary>
    /// Comprises an identifier and a source. The associated metadata key denotes the ability to associate a hash value to the PartyIdentifier instantiations for the purpose of model cross-referencing, in support of functionality such as the event effect and the lineage.
    /// </summary>
    public class PartyIdentifier : AbstractRosettaModelObject<PartyIdentifier>
    {
        private static readonly IRosettaMetaData<PartyIdentifier> metaData = new PartyIdentifierMeta();
        
        [JsonConstructor]
        public PartyIdentifier(FieldWithMetaString identifier, Enums.PartyIdentifierType? identifierType, _MetaFields? meta)
        {
            Identifier = identifier;
            IdentifierType = identifierType;
            Meta = meta;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<PartyIdentifier> MetaData => metaData;
        
        /// <summary>
        /// Provides an identifier associated with a party. The identifier is unique within the public source specified in the source attribute.
        /// </summary>
        public FieldWithMetaString Identifier { get; }
        
        /// <summary>
        /// Defines the source of the identifier.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.PartyIdentifierType? IdentifierType { get; }
        
        public _MetaFields? Meta { get; }
    }
    
    /// <summary>
    /// Specifies the parties responsible for making and receiving payments defined by this structure.
    /// </summary>
    public class PartyReferencePayerReceiver : AbstractRosettaModelObject<PartyReferencePayerReceiver>, IPartyReferencePayerReceiver
    {
        private static readonly IRosettaMetaData<PartyReferencePayerReceiver> metaData = new PartyReferencePayerReceiverMeta();
        
        [JsonConstructor]
        public PartyReferencePayerReceiver(ReferenceWithMetaAccount? payerAccountReference, ReferenceWithMetaParty payerPartyReference, ReferenceWithMetaAccount? receiverAccountReference, ReferenceWithMetaParty receiverPartyReference)
        {
            PayerAccountReference = payerAccountReference;
            PayerPartyReference = payerPartyReference;
            ReceiverAccountReference = receiverAccountReference;
            ReceiverPartyReference = receiverPartyReference;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<PartyReferencePayerReceiver> MetaData => metaData;
        
        /// <inheritdoc/>
        public ReferenceWithMetaAccount? PayerAccountReference { get; }
        
        /// <inheritdoc/>
        public ReferenceWithMetaParty PayerPartyReference { get; }
        
        /// <inheritdoc/>
        public ReferenceWithMetaAccount? ReceiverAccountReference { get; }
        
        /// <inheritdoc/>
        public ReferenceWithMetaParty ReceiverPartyReference { get; }
    }
    
    /// <summary>
    /// A class to specify the role(s) that party(ies) may have in relation to the execution, contract or other legal agreement.
    /// </summary>
    public class PartyRole : AbstractRosettaModelObject<PartyRole>
    {
        private static readonly IRosettaMetaData<PartyRole> metaData = new PartyRoleMeta();
        
        [JsonConstructor]
        public PartyRole(ReferenceWithMetaParty? ownershipPartyReference, ReferenceWithMetaParty partyReference, Enums.PartyRole role)
        {
            OwnershipPartyReference = ownershipPartyReference;
            PartyReference = partyReference;
            Role = role;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<PartyRole> MetaData => metaData;
        
        /// <summary>
        /// A reference to the party that has ownership of this party role information. FpML specifies that For shared trade information, this attribute will reference the originator of the data (for example, an execution facility or clearing house).
        /// </summary>
        public ReferenceWithMetaParty? OwnershipPartyReference { get; }
        
        /// <summary>
        /// A reference to the party to which the role refers to.
        /// </summary>
        public ReferenceWithMetaParty PartyReference { get; }
        
        /// <summary>
        /// The party role.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.PartyRole Role { get; }
    }
    
    /// <summary>
    /// Type which contains pass through payments.
    /// </summary>
    public class PassThrough : AbstractRosettaModelObject<PassThrough>
    {
        private static readonly IRosettaMetaData<PassThrough> metaData = new PassThroughMeta();
        
        [JsonConstructor]
        public PassThrough(IEnumerable<PassThroughItem> passThroughItem)
        {
            PassThroughItem = passThroughItem;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<PassThrough> MetaData => metaData;
        
        /// <summary>
        /// One to many pass through payment items.
        /// </summary>
        public IEnumerable<PassThroughItem> PassThroughItem { get; }
    }
    
    /// <summary>
    /// Class to represent a single pass through payment.
    /// </summary>
    public class PassThroughItem : AbstractRosettaModelObject<PassThroughItem>
    {
        private static readonly IRosettaMetaData<PassThroughItem> metaData = new PassThroughItemMeta();
        
        [JsonConstructor]
        public PassThroughItem(decimal passThroughPercentage, PayerReceiver payerReceiver)
        {
            PassThroughPercentage = passThroughPercentage;
            PayerReceiver = payerReceiver;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<PassThroughItem> MetaData => metaData;
        
        /// <summary>
        /// Percentage of payments from the underlier which are passed through.
        /// </summary>
        public decimal PassThroughPercentage { get; }
        
        /// <summary>
        /// This attribute doesn&apos;t exists in the FpML construct, which makes use of the PayerReceiver.model group.
        /// </summary>
        public PayerReceiver PayerReceiver { get; }
    }
    
    /// <summary>
    /// Specifies the parties responsible for making and receiving payments defined by this structure.
    /// </summary>
    public class PayerReceiver : AbstractRosettaModelObject<PayerReceiver>, IPayerReceiver
    {
        private static readonly IRosettaMetaData<PayerReceiver> metaData = new PayerReceiverMeta();
        
        [JsonConstructor]
        public PayerReceiver(Enums.CounterpartyRole payer, Enums.CounterpartyRole receiver)
        {
            Payer = payer;
            Receiver = receiver;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<PayerReceiver> MetaData => metaData;
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CounterpartyRole Payer { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CounterpartyRole Receiver { get; }
    }
    
    /// <summary>
    /// A data defining:  the adjusted payment date and associated calculation period parameters required to calculate the actual or projected payment amount. This data forms:  part of the cashflow representation of a swap stream.
    /// </summary>
    public class PaymentCalculationPeriod : AbstractRosettaModelObject<PaymentCalculationPeriod>
    {
        private static readonly IRosettaMetaData<PaymentCalculationPeriod> metaData = new PaymentCalculationPeriodMeta();
        
        [JsonConstructor]
        public PaymentCalculationPeriod(LocalDate? adjustedPaymentDate, IEnumerable<CalculationPeriod> calculationPeriod, decimal? discountFactor, Money? fixedPaymentAmount, Money? forecastPaymentAmount, _MetaFields? meta, Money? presentValueAmount, LocalDate? unadjustedPaymentDate)
        {
            AdjustedPaymentDate = adjustedPaymentDate;
            CalculationPeriod = calculationPeriod;
            DiscountFactor = discountFactor;
            FixedPaymentAmount = fixedPaymentAmount;
            ForecastPaymentAmount = forecastPaymentAmount;
            Meta = meta;
            PresentValueAmount = presentValueAmount;
            UnadjustedPaymentDate = unadjustedPaymentDate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<PaymentCalculationPeriod> MetaData => metaData;
        
        /// <summary>
        /// The adjusted payment date. This date should already be adjusted for any applicable business day convention. This component is not intended for use in trade confirmation but may be specified to allow the fee structure to also serve as a cashflow type component.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? AdjustedPaymentDate { get; }
        
        /// <summary>
        /// The parameters used in the calculation of a fixed or floating rate calculation period amount. A list of calculation period elements may be ordered in the document by ascending start date. An FpML document which contains an unordered list of calculation periods is still regarded as a conformant document.
        /// </summary>
        public IEnumerable<CalculationPeriod> CalculationPeriod { get; }
        
        /// <summary>
        /// A decimal value representing the discount factor used to calculate the present value of cash flow.
        /// </summary>
        public decimal? DiscountFactor { get; }
        
        /// <summary>
        /// A known fixed payment amount.
        /// </summary>
        public Money? FixedPaymentAmount { get; }
        
        /// <summary>
        /// A monetary amount representing the forecast of the future value of the payment.
        /// </summary>
        public Money? ForecastPaymentAmount { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <summary>
        /// A monetary amount representing the present value of the forecast payment.
        /// </summary>
        public Money? PresentValueAmount { get; }
        
        /// <summary>
        /// The unadjusted payment date.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? UnadjustedPaymentDate { get; }
    }
    
    /// <summary>
    /// The payment dates when specified as relative to a set of dates specified somewhere else in the instance document/transaction, e.g. the valuation dates as typically the case for equity swaps, or when specified as a calculation period schedule.
    /// </summary>
    public class PaymentDateSchedule : AbstractRosettaModelObject<PaymentDateSchedule>
    {
        private static readonly IRosettaMetaData<PaymentDateSchedule> metaData = new PaymentDateScheduleMeta();
        
        [JsonConstructor]
        public PaymentDateSchedule(AdjustableOrRelativeDate? finalPaymentDate, IEnumerable<AdjustableRelativeOrPeriodicDates> interimPaymentDates)
        {
            FinalPaymentDate = finalPaymentDate;
            InterimPaymentDates = interimPaymentDates;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<PaymentDateSchedule> MetaData => metaData;
        
        /// <summary>
        /// The last payment when specified as an adjustable or relative date, as in the FpML total return construct.
        /// </summary>
        public AdjustableOrRelativeDate? FinalPaymentDate { get; }
        
        public IEnumerable<AdjustableRelativeOrPeriodicDates> InterimPaymentDates { get; }
    }
    
    /// <summary>
    /// Specifies the parameters to generate the payment date schedule, either through a parametric representation or by reference to specified dates.
    /// </summary>
    public class PaymentDates : AbstractRosettaModelObject<PaymentDates>
    {
        private static readonly IRosettaMetaData<PaymentDates> metaData = new PaymentDatesMeta();
        
        [JsonConstructor]
        public PaymentDates(LocalDate? firstPaymentDate, LocalDate? lastRegularPaymentDate, _MetaFields? meta, Enums.PayRelativeTo? payRelativeTo, PaymentDateSchedule? paymentDateSchedule, BusinessDayAdjustments? paymentDatesAdjustments, Offset? paymentDaysOffset, Frequency? paymentFrequency)
        {
            FirstPaymentDate = firstPaymentDate;
            LastRegularPaymentDate = lastRegularPaymentDate;
            Meta = meta;
            PayRelativeTo = payRelativeTo;
            PaymentDateSchedule = paymentDateSchedule;
            PaymentDatesAdjustments = paymentDatesAdjustments;
            PaymentDaysOffset = paymentDaysOffset;
            PaymentFrequency = paymentFrequency;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<PaymentDates> MetaData => metaData;
        
        /// <summary>
        /// The first unadjusted payment date. This day may be subject to adjustment in accordance with any business day convention specified in paymentDatesAdjustments. This element must only be included if there is an initial stub. This date will normally correspond to an unadjusted calculation period start or end date. This is true even if early or delayed payment is specified to be applicable since the actual first payment date will be the specified number of days before or after the applicable adjusted calculation period start or end date with the resulting payment date then being adjusted in accordance with any business day convention specified in paymentDatesAdjustments.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? FirstPaymentDate { get; }
        
        /// <summary>
        /// The last regular payment date when specified as a date, as in the FpML interest rate construct. FpML specifies that this date may be subject to adjustment in accordance with any business day convention specified in the paymentDatesAdjustments attribute.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? LastRegularPaymentDate { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <summary>
        /// Specifies whether the payments occur relative to each adjusted calculation period start date or end date, each reset date, valuation date or the last pricing date. Calculation period start date means relative to the start of the first calculation period contributing to a given payment. Similarly, calculation period end date means the end of the last calculation period contributing to a given payment. The valuation date is applicable for Brazilian-CDI and equity swaps.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.PayRelativeTo? PayRelativeTo { get; }
        
        /// <summary>
        /// The payment dates when specified as relative to a set of dates specified somewhere else in the instance document/transaction, e.g. the valuation dates as typically the case for equity swaps, or when specified as a calculation period schedule.
        /// </summary>
        public PaymentDateSchedule? PaymentDateSchedule { get; }
        
        /// <summary>
        /// The definition of the business day convention and financial business centers used for adjusting the payment date if it would otherwise fall on a day that is not a business day in the specified business center.
        /// </summary>
        public BusinessDayAdjustments? PaymentDatesAdjustments { get; }
        
        /// <summary>
        /// If early payment or delayed payment is required, specifies the number of days offset that the payment occurs relative to what would otherwise be the unadjusted payment date. The offset can be specified in terms of either calendar or business days. Even in the case of a calendar days offset, the resulting payment date, adjusted for the specified calendar days offset, will still be adjusted in accordance with the specified payment dates adjustments. This element should only be included if early or delayed payment is applicable, i.e. if the periodMultiplier element value is not equal to zero. An early payment would be indicated by a negative periodMultiplier element value and a delayed payment (or payment lag) would be indicated by a positive periodMultiplier element value.
        /// </summary>
        public Offset? PaymentDaysOffset { get; }
        
        /// <summary>
        /// The frequency at which regular payment dates occur. If the payment frequency is equal to the frequency defined in the calculation period dates component then one calculation period contributes to each payment amount. If the payment frequency is less frequent than the frequency defined in the calculation period dates component then more than one calculation period will contribute to the payment amount. A payment frequency more frequent than the calculation period frequency or one that is not a multiple of the calculation period frequency is invalid. If the payment frequency is of value T (term), the period is defined by the effectiveDate and the terminationDate.
        /// </summary>
        public Frequency? PaymentFrequency { get; }
    }
    
    public class PaymentDetail : AbstractRosettaModelObject<PaymentDetail>
    {
        private static readonly IRosettaMetaData<PaymentDetail> metaData = new PaymentDetailMeta();
        
        [JsonConstructor]
        public PaymentDetail(_MetaFields? meta, Money? paymentAmount, AdjustableOrRelativeDate? paymentDate, PaymentRule paymentRule)
        {
            Meta = meta;
            PaymentAmount = paymentAmount;
            PaymentDate = paymentDate;
            PaymentRule = paymentRule;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<PaymentDetail> MetaData => metaData;
        
        public _MetaFields? Meta { get; }
        
        /// <summary>
        /// A fixed payment amount.
        /// </summary>
        public Money? PaymentAmount { get; }
        
        public AdjustableOrRelativeDate? PaymentDate { get; }
        
        /// <summary>
        /// The calculation rule.
        /// </summary>
        public PaymentRule PaymentRule { get; }
    }
    
    /// <summary>
    /// This class corresponds to the FpML PaymentDiscounting.model group for representing the discounting elements that can be associated with a payment.
    /// </summary>
    public class PaymentDiscounting : AbstractRosettaModelObject<PaymentDiscounting>
    {
        private static readonly IRosettaMetaData<PaymentDiscounting> metaData = new PaymentDiscountingMeta();
        
        [JsonConstructor]
        public PaymentDiscounting(decimal? discountFactor, Money? presentValueAmount)
        {
            DiscountFactor = discountFactor;
            PresentValueAmount = presentValueAmount;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<PaymentDiscounting> MetaData => metaData;
        
        /// <summary>
        /// The value representing the discount factor used to calculate the present value of the cash flow.
        /// </summary>
        public decimal? DiscountFactor { get; }
        
        /// <summary>
        /// The amount representing the present value of the forecast payment.
        /// </summary>
        public Money? PresentValueAmount { get; }
    }
    
    /// <summary>
    /// A class defining the payment calculation rule. As of FpML 5.10, percentage rule is the only calculation rule that has been specified as part of the standard.
    /// </summary>
    public class PaymentRule : AbstractRosettaModelObject<PaymentRule>
    {
        private static readonly IRosettaMetaData<PaymentRule> metaData = new PaymentRuleMeta();
        
        [JsonConstructor]
        public PaymentRule(PercentageRule? percentageRule)
        {
            PercentageRule = percentageRule;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<PaymentRule> MetaData => metaData;
        
        /// <summary>
        /// This attribute is not present as part of the FpML construct, as the payment rule is specialised by means of runtime type extension through the xsi:type.
        /// </summary>
        public PercentageRule? PercentageRule { get; }
    }
    
    /// <summary>
    /// A class to represent the set of future cashflow methodologies in the form of specific payout class(es) that can be associated for the purpose of specifying a financial product. For example, two interest rate payouts can be combined to specify an interest rate swap, or one interest rate payout can be combined with a credit default payout to specify a credit default swap.
    /// </summary>
    public class Payout : AbstractRosettaModelObject<Payout>
    {
        private static readonly IRosettaMetaData<Payout> metaData = new PayoutMeta();
        
        [JsonConstructor]
        public Payout(IEnumerable<AssetPayout> assetPayout, IEnumerable<Cashflow> cashflow, IEnumerable<CommodityPayout> commodityPayout, CreditDefaultPayout? creditDefaultPayout, IEnumerable<FixedPricePayout> fixedPricePayout, IEnumerable<ForwardPayout> forwardPayout, IEnumerable<InterestRatePayout> interestRatePayout, _MetaFields? meta, IEnumerable<OptionPayout> optionPayout, IEnumerable<PerformancePayout> performancePayout, IEnumerable<SecurityPayout> securityPayout)
        {
            AssetPayout = assetPayout;
            Cashflow = cashflow;
            CommodityPayout = commodityPayout;
            CreditDefaultPayout = creditDefaultPayout;
            FixedPricePayout = fixedPricePayout;
            ForwardPayout = forwardPayout;
            InterestRatePayout = interestRatePayout;
            Meta = meta;
            OptionPayout = optionPayout;
            PerformancePayout = performancePayout;
            SecurityPayout = securityPayout;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Payout> MetaData => metaData;
        
        /// <summary>
        /// The security payout when the product involves some form of securities, such as collateral in a securities financing transaction
        /// </summary>
        public IEnumerable<AssetPayout> AssetPayout { get; }
        
        /// <summary>
        /// A cashflow between the parties to the trade. For interest rate and equity products, this corresponds to the FpML additionalPayment element. For credit default swaps, this corresponds to the FpML initialPayment element and the singlePayment element of the fee leg. For option products, it represents the FpML premium element.
        /// </summary>
        public IEnumerable<Cashflow> Cashflow { get; }
        
        /// <summary>
        /// Defines the payout for the floating leg of a Commodity Swap.
        /// </summary>
        public IEnumerable<CommodityPayout> CommodityPayout { get; }
        
        /// <summary>
        /// The credit default payout, which provides the details necessary for determining when a credit payout will be triggered as well as the parameters for calculating the payout and the settlement terms.
        /// </summary>
        public CreditDefaultPayout? CreditDefaultPayout { get; }
        
        /// <summary>
        /// Defines a payout in which one or more payouts are defined as a fixed price.
        /// </summary>
        public IEnumerable<FixedPricePayout> FixedPricePayout { get; }
        
        /// <summary>
        /// Represents a forward settling payout. The &apos;Underlier&apos; attribute captures the underlying payout, which is settled according to the &apos;SettlementTerms&apos; attribute. Both FX Spot and FX Forward should use this component.
        /// </summary>
        public IEnumerable<ForwardPayout> ForwardPayout { get; }
        
        /// <summary>
        /// All of the terms necessary to define and calculate a cash flow based on a fixed, a floating or an inflation index rate. The interest rate payout can be applied to interest rate swaps and FRA (which both have two associated interest rate payouts), credit default swaps (to represent the fee leg when subject to periodic payments) and equity swaps (to represent the funding leg).
        /// </summary>
        public IEnumerable<InterestRatePayout> InterestRatePayout { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <summary>
        /// The option payout.
        /// </summary>
        public IEnumerable<OptionPayout> OptionPayout { get; }
        
        /// <summary>
        /// The performance payout, which encompasses the equity price returns, dividend returns, volatility return, variance return and correlation provisions.
        /// </summary>
        public IEnumerable<PerformancePayout> PerformancePayout { get; }
        
        /// <summary>
        /// The security payout when the product involves some form of securities, such as collateral in a securities financing transaction
        /// </summary>
        public IEnumerable<SecurityPayout> SecurityPayout { get; }
    }
    
    /// <summary>
    ///  Base class that all payout types should extend. Use case is that some validation rules may need to apply across all payout types, for which the data rule can be written at the base class level
    /// </summary>
    public class PayoutBase : AbstractRosettaModelObject<PayoutBase>, IPayoutBase
    {
        private static readonly IRosettaMetaData<PayoutBase> metaData = new PayoutBaseMeta();
        
        [JsonConstructor]
        public PayoutBase(PayerReceiver payerReceiver, ResolvablePriceQuantity? priceQuantity, PrincipalPayments? principalPayment, SettlementTerms? settlementTerms)
        {
            PayerReceiver = payerReceiver;
            PriceQuantity = priceQuantity;
            PrincipalPayment = principalPayment;
            SettlementTerms = settlementTerms;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<PayoutBase> MetaData => metaData;
        
        /// <inheritdoc/>
        public PayerReceiver PayerReceiver { get; }
        
        /// <inheritdoc/>
        public ResolvablePriceQuantity? PriceQuantity { get; }
        
        /// <inheritdoc/>
        public PrincipalPayments? PrincipalPayment { get; }
        
        /// <inheritdoc/>
        public SettlementTerms? SettlementTerms { get; }
    }
    
    /// <summary>
    /// A class defining a content model for a calculation rule defined as percentage of the notional amount.
    /// </summary>
    public class PercentageRule : AbstractRosettaModelObject<PercentageRule>
    {
        private static readonly IRosettaMetaData<PercentageRule> metaData = new PercentageRuleMeta();
        
        [JsonConstructor]
        public PercentageRule(ReferenceWithMetaMoney notionalAmountReference, decimal paymentPercent)
        {
            NotionalAmountReference = notionalAmountReference;
            PaymentPercent = paymentPercent;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<PercentageRule> MetaData => metaData;
        
        /// <summary>
        /// A reference to the notional amount.
        /// </summary>
        public ReferenceWithMetaMoney NotionalAmountReference { get; }
        
        /// <summary>
        /// A percentage of the notional amount.
        /// </summary>
        public decimal PaymentPercent { get; }
    }
    
    /// <summary>
    /// Contains the necessary specifications for all performance payouts, encompassing equity return, dividend, variance, volatility and correlation products.
    /// </summary>
    public class PerformancePayout : AbstractRosettaModelObject<PerformancePayout>, IPayoutBase
    {
        private static readonly IRosettaMetaData<PerformancePayout> metaData = new PerformancePayoutMeta();
        
        [JsonConstructor]
        public PerformancePayout(IEnumerable<FxFeature> fxFeature, _MetaFields? meta, ObservationTerms? observationTerms, PaymentDates paymentDates, ReturnTerms returnTerms, Product? underlier, ValuationDates valuationDates, PayerReceiver payerReceiver, ResolvablePriceQuantity? priceQuantity, PrincipalPayments? principalPayment, SettlementTerms? settlementTerms)
        {
            FxFeature = fxFeature;
            Meta = meta;
            ObservationTerms = observationTerms;
            PaymentDates = paymentDates;
            ReturnTerms = returnTerms;
            Underlier = underlier;
            ValuationDates = valuationDates;
            PayerReceiver = payerReceiver;
            PriceQuantity = priceQuantity;
            PrincipalPayment = principalPayment;
            SettlementTerms = settlementTerms;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<PerformancePayout> MetaData => metaData;
        
        /// <summary>
        /// Defines quanto or composite FX features that are included in the swap leg.
        /// </summary>
        public IEnumerable<FxFeature> FxFeature { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <summary>
        /// Defines how and when a performance type option or performance type swap is to be observed.
        /// </summary>
        public ObservationTerms? ObservationTerms { get; }
        
        /// <summary>
        /// Defines the payment date schedule, as defined by the parameters that are needed to specify it, either in a parametric way or by reference to another schedule of dates (e.g. the valuation dates).
        /// </summary>
        public PaymentDates PaymentDates { get; }
        
        /// <summary>
        /// Specifies the type of return of a performance payout.
        /// </summary>
        public ReturnTerms ReturnTerms { get; }
        
        /// <summary>
        /// Identifies the underlying product that is referenced for pricing of the applicable leg in a swap.  Referenced in the &apos;2018 ISDA CDM Equity Confirmation for Security Equity Swap&apos; as Security.
        /// </summary>
        public Product? Underlier { get; }
        
        /// <summary>
        /// Defines how and when a performance type option or performance type swap is to be valued, including both interim and final valuation.
        /// </summary>
        public ValuationDates ValuationDates { get; }
        
        /// <inheritdoc/>
        public PayerReceiver PayerReceiver { get; }
        
        /// <inheritdoc/>
        public ResolvablePriceQuantity? PriceQuantity { get; }
        
        /// <inheritdoc/>
        public PrincipalPayments? PrincipalPayment { get; }
        
        /// <inheritdoc/>
        public SettlementTerms? SettlementTerms { get; }
    }
    
    /// <summary>
    /// Defines how and when a performance type option or performance type swap is to be valued.
    /// </summary>
    public class PerformanceValuationDates : AbstractRosettaModelObject<PerformanceValuationDates>
    {
        private static readonly IRosettaMetaData<PerformanceValuationDates> metaData = new PerformanceValuationDatesMeta();
        
        [JsonConstructor]
        public PerformanceValuationDates(Enums.DeterminationMethod determinationMethod, _MetaFields? meta, AdjustableOrRelativeDate? valuationDate, AdjustableRelativeOrPeriodicDates? valuationDates, BusinessCenterTime? valuationTime, Enums.TimeType? valuationTimeType)
        {
            DeterminationMethod = determinationMethod;
            Meta = meta;
            ValuationDate = valuationDate;
            ValuationDates = valuationDates;
            ValuationTime = valuationTime;
            ValuationTimeType = valuationTimeType;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<PerformanceValuationDates> MetaData => metaData;
        
        /// <summary>
        /// Specifies the method according to which an amount or a date is determined.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.DeterminationMethod DeterminationMethod { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <summary>
        /// 2018 ISDA CDM Equity Confirmation for Security Equity Swap: Pricing Date
        /// </summary>
        public AdjustableOrRelativeDate? ValuationDate { get; }
        
        /// <summary>
        /// 2018 ISDA CDM Equity Confirmation for Security Equity Swap: Pricing Date
        /// </summary>
        public AdjustableRelativeOrPeriodicDates? ValuationDates { get; }
        
        /// <summary>
        /// The specific time of day at which the calculation agent values the underlying. The SpecificTime is the only case when the valuationTime (time + business center location  e.g. 10:00:00 USNY) should be provided. You should be able to provide just the valuationTime without valuationTimeType, which infer that this is a specific time.
        /// </summary>
        public BusinessCenterTime? ValuationTime { get; }
        
        /// <summary>
        /// The time of day at which the calculation agent values the underlying, for example the official closing time of the exchange.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.TimeType? ValuationTimeType { get; }
    }
    
    /// <summary>
    /// A class to define recurring periods or time offsets.
    /// </summary>
    public class Period : AbstractRosettaModelObject<Period>, IPeriod
    {
        private static readonly IRosettaMetaData<Period> metaData = new PeriodMeta();
        
        [JsonConstructor]
        public Period(_MetaFields? meta, Enums.Period period, int periodMultiplier)
        {
            Meta = meta;
            PeriodValue = period;
            PeriodMultiplier = periodMultiplier;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Period> MetaData => metaData;
        
        public _MetaFields? Meta { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        [JsonProperty(PropertyName = "period")]
        public Enums.Period PeriodValue { get; }
        
        /// <inheritdoc/>
        public int PeriodMultiplier { get; }
    }
    
    /// <summary>
    /// Indicator to specify if the period bound is defined as a period and whether the bound is inclusive.
    /// </summary>
    public class PeriodBound : AbstractRosettaModelObject<PeriodBound>
    {
        private static readonly IRosettaMetaData<PeriodBound> metaData = new PeriodBoundMeta();
        
        [JsonConstructor]
        public PeriodBound(bool inclusive, Period period)
        {
            Inclusive = inclusive;
            Period = period;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<PeriodBound> MetaData => metaData;
        
        /// <summary>
        /// Specifies whether the period bound is inclusive, e.g. for a lower bound, false would indicate greater than, whereas true would indicate greater than or equal to.
        /// </summary>
        public bool Inclusive { get; }
        
        /// <summary>
        /// Specifies the period is to be used as the bound, e.g. 5Y.
        /// </summary>
        public Period Period { get; }
    }
    
    /// <summary>
    /// Indicates The period range defined as either a lower and upper period bound, or both.
    /// </summary>
    public class PeriodRange : AbstractRosettaModelObject<PeriodRange>
    {
        private static readonly IRosettaMetaData<PeriodRange> metaData = new PeriodRangeMeta();
        
        [JsonConstructor]
        public PeriodRange(PeriodBound? lowerBound, PeriodBound? upperBound)
        {
            LowerBound = lowerBound;
            UpperBound = upperBound;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<PeriodRange> MetaData => metaData;
        
        /// <summary>
        /// Specifies the lower bound of a period range, e.g. greater than or equal to 5Y.
        /// </summary>
        public PeriodBound? LowerBound { get; }
        
        /// <summary>
        /// Specifies the upper bound of a period range, e.g. less than to 10Y.
        /// </summary>
        public PeriodBound? UpperBound { get; }
    }
    
    /// <summary>
    /// A class for specifying a calculation period schedule.
    /// </summary>
    public class PeriodicDates : AbstractRosettaModelObject<PeriodicDates>
    {
        private static readonly IRosettaMetaData<PeriodicDates> metaData = new PeriodicDatesMeta();
        
        [JsonConstructor]
        public PeriodicDates(Enums.DayType? dayType, AdjustableOrRelativeDate? endDate, BusinessDayAdjustments? periodDatesAdjustments, CalculationPeriodFrequency? periodFrequency, AdjustableOrRelativeDate? startDate)
        {
            DayType = dayType;
            EndDate = endDate;
            PeriodDatesAdjustments = periodDatesAdjustments;
            PeriodFrequency = periodFrequency;
            StartDate = startDate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<PeriodicDates> MetaData => metaData;
        
        /// <summary>
        /// Denotes the enumerated values to specify the day type classification used in counting the number of days between two dates.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.DayType? DayType { get; }
        
        /// <summary>
        /// The end date of the calculation period. FpML specifies that for interest rate swaps this date must only be specified if it is not equal to the termination date. It is always specified in the case of equity swaps with periodic payments. This date may be subject to adjustment in accordance with a business day convention.
        /// </summary>
        public AdjustableOrRelativeDate? EndDate { get; }
        
        /// <summary>
        /// The specification of the business day convention and financial business centers used for adjusting any calculation period date if it would otherwise fall on a day that is not a business day in the specified business center.
        /// </summary>
        public BusinessDayAdjustments? PeriodDatesAdjustments { get; }
        
        /// <summary>
        /// The frequency at which calculation period end dates occur with the regular part of the calculation period schedule and their roll date convention.
        /// </summary>
        public CalculationPeriodFrequency? PeriodFrequency { get; }
        
        /// <summary>
        /// The start date of the calculation period. FpML specifies that for interest rate swaps this date must only be specified if it is not equal to the effective date. It is always specified in the case of equity swaps and credit default swaps with periodic payments. This date may be subject to adjustment in accordance with a business day convention.
        /// </summary>
        public AdjustableOrRelativeDate? StartDate { get; }
    }
    
    /// <summary>
    /// Comprises an identifier and a source. The associated metadata key denotes the ability to associate a hash value to the PersonIdentifier instantiations for the purpose of model cross-referencing, in support of functionality such as the event effect and the lineage.
    /// </summary>
    public class PersonIdentifier : AbstractRosettaModelObject<PersonIdentifier>
    {
        private static readonly IRosettaMetaData<PersonIdentifier> metaData = new PersonIdentifierMeta();
        
        [JsonConstructor]
        public PersonIdentifier(FieldWithMetaString? country, FieldWithMetaString identifier, Enums.PersonIdentifierType? identifierType, _MetaFields? meta)
        {
            Country = country;
            Identifier = identifier;
            IdentifierType = identifierType;
            Meta = meta;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<PersonIdentifier> MetaData => metaData;
        
        /// <summary>
        /// The ISO 3166 standard code for the country issuing the identifier.
        /// </summary>
        public FieldWithMetaString? Country { get; }
        
        /// <summary>
        /// Provides an identifier associated with a person. The identifier is unique within the public source specified in the source attribute.
        /// </summary>
        public FieldWithMetaString Identifier { get; }
        
        /// <summary>
        /// Defines the source of the identifier.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.PersonIdentifierType? IdentifierType { get; }
        
        public _MetaFields? Meta { get; }
    }
    
    public class PhysicalSettlementPeriod : AbstractRosettaModelObject<PhysicalSettlementPeriod>
    {
        private static readonly IRosettaMetaData<PhysicalSettlementPeriod> metaData = new PhysicalSettlementPeriodMeta();
        
        [JsonConstructor]
        public PhysicalSettlementPeriod(int? businessDays, bool? businessDaysNotSpecified, int? maximumBusinessDays)
        {
            BusinessDays = businessDays;
            BusinessDaysNotSpecified = businessDaysNotSpecified;
            MaximumBusinessDays = maximumBusinessDays;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<PhysicalSettlementPeriod> MetaData => metaData;
        
        /// <summary>
        /// A number of business days. Its precise meaning is dependant on the context in which this element is used. ISDA 2003 Term: Business Day.
        /// </summary>
        public int? BusinessDays { get; }
        
        /// <summary>
        /// An explicit indication that a number of business days are not specified and therefore ISDA fallback provisions should apply.
        /// </summary>
        public bool? BusinessDaysNotSpecified { get; }
        
        /// <summary>
        /// A maximum number of business days. Its precise meaning is dependant on the context in which this element is used. Intended to be used to limit a particular ISDA fallback provision.
        /// </summary>
        public int? MaximumBusinessDays { get; }
    }
    
    /// <summary>
    /// Specifies Physical Settlement Terms characteristics for the settlement of a Credit Default Swap or Option.
    /// </summary>
    public class PhysicalSettlementTerms : AbstractRosettaModelObject<PhysicalSettlementTerms>
    {
        private static readonly IRosettaMetaData<PhysicalSettlementTerms> metaData = new PhysicalSettlementTermsMeta();
        
        [JsonConstructor]
        public PhysicalSettlementTerms(bool? clearedPhysicalSettlement, DeliverableObligations? deliverableObligations, bool? escrow, _MetaFields? meta, PhysicalSettlementPeriod? physicalSettlementPeriod, Enums.AncillaryRole? predeterminedClearingOrganizationParty, bool? sixtyBusinessDaySettlementCap)
        {
            ClearedPhysicalSettlement = clearedPhysicalSettlement;
            DeliverableObligations = deliverableObligations;
            Escrow = escrow;
            Meta = meta;
            PhysicalSettlementPeriod = physicalSettlementPeriod;
            PredeterminedClearingOrganizationParty = predeterminedClearingOrganizationParty;
            SixtyBusinessDaySettlementCap = sixtyBusinessDaySettlementCap;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<PhysicalSettlementTerms> MetaData => metaData;
        
        /// <summary>
        /// Specifies whether the swap resulting from physical settlement of the swaption transaction will clear through a clearing house. The meaning of Cleared Physical Settlement is defined in the 2006 ISDA Definitions, Section 15.2 (published in Supplement number 28).
        /// </summary>
        public bool? ClearedPhysicalSettlement { get; }
        
        /// <summary>
        /// This element contains all the ISDA terms relevant to defining the deliverable obligations.
        /// </summary>
        public DeliverableObligations? DeliverableObligations { get; }
        
        /// <summary>
        /// If this element is specified and set to &apos;true&apos;, indicates that physical settlement must take place through the use of an escrow agent. (For Canadian counterparties this is always &apos;Not Applicable&apos;. ISDA 2003 Term: Escrow.
        /// </summary>
        public bool? Escrow { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <summary>
        /// The number of business days used in the determination of the physical settlement date. The physical settlement date is this number of business days after all applicable conditions to settlement are satisfied. If a number of business days is not specified fallback provisions apply for determining the number of business days. If Section 8.5/8.6 of the 1999/2003 ISDA Definitions are to apply the businessDaysNotSpecified element should be included. If a specified number of business days are to apply these should be specified in the businessDays element. If Section 8.5/8.6 of the 1999/2003 ISDA Definitions are to apply but capped at a maximum number of business days then the maximum number should be specified in the maximumBusinessDays element. ISDA 2003 Term: Physical Settlement Period.
        /// </summary>
        public PhysicalSettlementPeriod? PhysicalSettlementPeriod { get; }
        
        /// <summary>
        /// Specifies the clearing organization (CCP, DCO) to which the trade should be cleared.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.AncillaryRole? PredeterminedClearingOrganizationParty { get; }
        
        /// <summary>
        /// If this element is specified and set to &apos;true&apos;, for a transaction documented under the 2003 ISDA Credit Derivatives Definitions, has the effect of incorporating the language set forth below into the confirmation. The section references are to the 2003 ISDA Credit Derivatives Definitions. Notwithstanding Section 1.7 or any provisions of Sections 9.9 or 9.10 to the contrary, but without prejudice to Section 9.3 and (where applicable) Sections 9.4, 9.5 and 9.6, if the Termination Date has not occurred on or prior to the date that is 60 Business Days following the Physical Settlement Date, such 60th Business Day shall be deemed to be the Termination Date with respect to this Transaction except in relation to any portion of the Transaction (an &apos;Affected Portion&apos;) in respect of which: (1) a valid notice of Buy-in Price has been delivered that is effective fewer than three Business Days prior to such 60th Business Day, in which case the Termination Date for that Affected Portion shall be the third Business Day following the date on which such notice is effective; or (2) Buyer has purchased but not Delivered Deliverable Obligations validly specified by Seller pursuant to Section 9.10(b), in which case the Termination Date for that Affected Portion shall be the tenth Business Day following the date on which Seller validly specified such Deliverable Obligations to Buyer.
        /// </summary>
        public bool? SixtyBusinessDaySettlementCap { get; }
    }
    
    /// <summary>
    ///  A Portfolio represents an aggregation of multiple Positions, by describing the parameters that this Portfolio should be aggregated based on. The resulting PortfolioState is calculated using these aggregation parameters as inputs, by aggregating all the Events that are relevant to this Portfolio. The concept of Portfolio works at all levels in the model: from the highest for a given LegalEntity for instance, to the lowest to account for security substitutions in a secutity financing transaction. As such, Portfolio can be used either above or below the Contract level.
    /// </summary>
    public class Portfolio : AbstractRosettaModelObject<Portfolio>
    {
        private static readonly IRosettaMetaData<Portfolio> metaData = new PortfolioMeta();
        
        [JsonConstructor]
        public Portfolio(AggregationParameters aggregationParameters, PortfolioState portfolioState)
        {
            AggregationParameters = aggregationParameters;
            PortfolioState = portfolioState;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Portfolio> MetaData => metaData;
        
        /// <summary>
        /// Describes the portfolio by describing how to aggregate all its relevant Events.
        /// </summary>
        public AggregationParameters AggregationParameters { get; }
        
        /// <summary>
        /// Describes the state of the Portfolio as a list of Positions resulting from the aggregation.
        /// </summary>
        public PortfolioState PortfolioState { get; }
    }
    
    /// <summary>
    /// State-full representation of a Portfolio that describes all the positions held at a given time, in various states which can be either traded, settled, etc., with lineage information to the previous state
    /// </summary>
    public class PortfolioState : AbstractRosettaModelObject<PortfolioState>
    {
        private static readonly IRosettaMetaData<PortfolioState> metaData = new PortfolioStateMeta();
        
        [JsonConstructor]
        public PortfolioState(Lineage lineage, _MetaFields? meta, IEnumerable<Position> positions)
        {
            Lineage = lineage;
            Meta = meta;
            Positions = positions;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<PortfolioState> MetaData => metaData;
        
        /// <summary>
        /// Pointer to the previous PortfolioState and new Event(s) leading to the current (new) state. Previous PortfolioState in the Lineage can be Null in case this is the start of the chain of Events.
        /// </summary>
        public Lineage Lineage { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <summary>
        /// The list of positions, each containing a Quantity and a Product.
        /// </summary>
        public IEnumerable<Position> Positions { get; }
    }
    
    /// <summary>
    /// A Position describes how much of a given Product is being held and constitutes the atomic element of a Portfolio.
    /// </summary>
    public class Position : AbstractRosettaModelObject<Position>, IPosition
    {
        private static readonly IRosettaMetaData<Position> metaData = new PositionMeta();
        
        [JsonConstructor]
        public Position(Money? cashBalance, IEnumerable<PriceQuantity> priceQuantity, Product product, ReferenceWithMetaTradeState? tradeReference)
        {
            CashBalance = cashBalance;
            PriceQuantity = priceQuantity;
            Product = product;
            TradeReference = tradeReference;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Position> MetaData => metaData;
        
        /// <inheritdoc/>
        public Money? CashBalance { get; }
        
        /// <inheritdoc/>
        public IEnumerable<PriceQuantity> PriceQuantity { get; }
        
        /// <inheritdoc/>
        public Product Product { get; }
        
        /// <inheritdoc/>
        public ReferenceWithMetaTradeState? TradeReference { get; }
    }
    
    /// <summary>
    /// This class corresponds to the FpML Premium.model group for representing the option premium when expressed in a way other than an amount.
    /// </summary>
    public class PremiumExpression : AbstractRosettaModelObject<PremiumExpression>
    {
        private static readonly IRosettaMetaData<PremiumExpression> metaData = new PremiumExpressionMeta();
        
        [JsonConstructor]
        public PremiumExpression(decimal? percentageOfNotional, Enums.PremiumType? premiumType, Money? pricePerOption)
        {
            PercentageOfNotional = percentageOfNotional;
            PremiumType = premiumType;
            PricePerOption = pricePerOption;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<PremiumExpression> MetaData => metaData;
        
        /// <summary>
        /// The amount of premium to be paid expressed as a percentage of the notional value of the transaction. A percentage of 5% would be expressed as 0.05.
        /// </summary>
        public decimal? PercentageOfNotional { get; }
        
        /// <summary>
        /// Forward start premium type
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.PremiumType? PremiumType { get; }
        
        /// <summary>
        /// The amount of premium to be paid expressed as a function of the number of options.
        /// </summary>
        public Money? PricePerOption { get; }
    }
    
    public class Pric : AbstractRosettaModelObject<Pric>
    {
        private static readonly IRosettaMetaData<Pric> metaData = new PricMeta();
        
        [JsonConstructor]
        public Pric(string bsisPts, Pric pric)
        {
            BsisPts = bsisPts;
            PricValue = pric;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Pric> MetaData => metaData;
        
        public string BsisPts { get; }
        
        [JsonProperty(PropertyName = "pric")]
        public Pric PricValue { get; }
    }
    
    /// <summary>
    /// Specifies a price as a single value to be associated to a financial product. This data type extends PriceSchedule and requires that only the amount value exists.
    /// </summary>
    public class Price : AbstractRosettaModelObject<Price>, IPriceSchedule
    {
        private static readonly IRosettaMetaData<Price> metaData = new PriceMeta();
        
        [JsonConstructor]
        public Price(UnitType? perUnitOf, PriceExpression priceExpression, IEnumerable<DatedValue> datedValue, UnitType? unit, decimal? value)
        {
            PerUnitOf = perUnitOf;
            PriceExpression = priceExpression;
            DatedValue = datedValue;
            Unit = unit;
            Value = value;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Price> MetaData => metaData;
        
        /// <inheritdoc/>
        public UnitType? PerUnitOf { get; }
        
        /// <inheritdoc/>
        public PriceExpression PriceExpression { get; }
        
        /// <inheritdoc/>
        public IEnumerable<DatedValue> DatedValue { get; }
        
        /// <inheritdoc/>
        public UnitType? Unit { get; }
        
        /// <inheritdoc/>
        public decimal? Value { get; }
    }
    
    public class PriceExpression : AbstractRosettaModelObject<PriceExpression>
    {
        private static readonly IRosettaMetaData<PriceExpression> metaData = new PriceExpressionMeta();
        
        [JsonConstructor]
        public PriceExpression(Enums.CapFloor? capFloor, CashPrice? cashPrice, Enums.CleanOrDirtyPrice? cleanOrDirty, Enums.GrossOrNet? grossOrNet, Enums.PriceExpression? priceExpression, Enums.PriceType priceType, Enums.SpreadType? spreadType)
        {
            CapFloor = capFloor;
            CashPrice = cashPrice;
            CleanOrDirty = cleanOrDirty;
            GrossOrNet = grossOrNet;
            PriceExpressionValue = priceExpression;
            PriceType = priceType;
            SpreadType = spreadType;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<PriceExpression> MetaData => metaData;
        
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CapFloor? CapFloor { get; }
        
        public CashPrice? CashPrice { get; }
        
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CleanOrDirtyPrice? CleanOrDirty { get; }
        
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.GrossOrNet? GrossOrNet { get; }
        
        [JsonConverter(typeof(StringEnumConverter))]
        [JsonProperty(PropertyName = "priceExpression")]
        public Enums.PriceExpression? PriceExpressionValue { get; }
        
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.PriceType PriceType { get; }
        
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.SpreadType? SpreadType { get; }
    }
    
    /// <summary>
    /// Defines a settlement as an exchange between two parties of a specified quantity of an asset (the quantity) against a specified quantity of another asset (the price). The settlement is optional and can be either cash or physical. In the case of non-cash products, the settlement of the price/quantity would not be specified here and instead would be delegated to the product mechanics, as parameterised by the price/quantity values.
    /// </summary>
    public class PriceQuantity : AbstractRosettaModelObject<PriceQuantity>
    {
        private static readonly IRosettaMetaData<PriceQuantity> metaData = new PriceQuantityMeta();
        
        [JsonConstructor]
        public PriceQuantity(BuyerSeller? buyerSeller, AdjustableOrRelativeDate? effectiveDate, _MetaFields? meta, Observable? observable, IEnumerable<FieldWithMetaPriceSchedule> price, IEnumerable<FieldWithMetaNonNegativeQuantitySchedule> quantity, SettlementTerms? settlementTerms)
        {
            BuyerSeller = buyerSeller;
            EffectiveDate = effectiveDate;
            Meta = meta;
            Observable = observable;
            Price = price;
            Quantity = quantity;
            SettlementTerms = settlementTerms;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<PriceQuantity> MetaData => metaData;
        
        /// <summary>
        /// Defines the direction of the exchange. The convention is that the buyer receives the quantity / pays the price, whereas the seller receives the price / pays the quantity. Attribute is optional in case the price/quantity settlement is defined as part of the product mechanics.
        /// </summary>
        public BuyerSeller? BuyerSeller { get; }
        
        /// <summary>
        /// Specifies the date at which the price and quantity become effective. This day may be subject to adjustment in accordance with a business day convention, or could be specified as relative to a trade date, for instance. Optional cardinality, as the effective date is usually specified in the product definition, so it may only need to be specified as part of the PriceQuantity in an increase/decrease scenario for an existing trade.
        /// </summary>
        public AdjustableOrRelativeDate? EffectiveDate { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <summary>
        /// Specifies the object to be observed for a price, it could be an asset or a reference. The cardinality is optional as some quantity / price cases have no observable (e.g. a notional and a fixed rate in a given currency).
        /// </summary>
        public Observable? Observable { get; }
        
        /// <summary>
        /// Specifies a price to be used for trade amounts and other purposes.
        /// </summary>
        public IEnumerable<FieldWithMetaPriceSchedule> Price { get; }
        
        /// <summary>
        /// Specifies a quantity to be associated with an event, for example a trade amount.
        /// </summary>
        public IEnumerable<FieldWithMetaNonNegativeQuantitySchedule> Quantity { get; }
        
        /// <summary>
        /// Whether the settlement is cash or physical and the corresponding terms. Attribute is optional in case the price/quantity settlement is defined as part of the product mechanics.
        /// </summary>
        public SettlementTerms? SettlementTerms { get; }
    }
    
    public class PriceReturnTerms : AbstractRosettaModelObject<PriceReturnTerms>
    {
        private static readonly IRosettaMetaData<PriceReturnTerms> metaData = new PriceReturnTermsMeta();
        
        [JsonConstructor]
        public PriceReturnTerms(decimal? conversionFactor, string? performance, Enums.ReturnType returnType, PriceSchedule? valuationPriceFinal, PriceSchedule? valuationPriceInitial)
        {
            ConversionFactor = conversionFactor;
            Performance = performance;
            ReturnType = returnType;
            ValuationPriceFinal = valuationPriceFinal;
            ValuationPriceInitial = valuationPriceInitial;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<PriceReturnTerms> MetaData => metaData;
        
        /// <summary>
        /// Defines the conversion applied if the quantity unit on contract is different from unit on referenced underlier.
        /// </summary>
        public decimal? ConversionFactor { get; }
        
        /// <summary>
        /// Performance calculation, in accordance with Part 1 Section 12 of the 2018 ISDA CDM Equity Confirmation for Security Equity Swap, Para 75. &apos;Equity Performance&apos;. Cumulative performance is used as a notional multiplier factor on both legs of an Equity Swap.
        /// </summary>
        public string? Performance { get; }
        
        /// <summary>
        /// The type of return associated with the equity swap.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.ReturnType ReturnType { get; }
        
        /// <summary>
        /// 2018 ISDA CDM Equity Confirmation for Security Equity Swap: Final Price | Specifies the final valuation price of the underlier. This price can be expressed either as an actual amount/currency, as a determination method, or by reference to another value specified in the swap document.
        /// </summary>
        public PriceSchedule? ValuationPriceFinal { get; }
        
        /// <summary>
        /// Specifies the initial valuation price(s) of the underlier. This price can be expressed either as an actual amount/currency, as a determination method, or by reference to another value specified in the swap document.
        /// </summary>
        public PriceSchedule? ValuationPriceInitial { get; }
    }
    
    /// <summary>
    /// Specifies the price of a financial instrument in a trade as a schedule of measures. A price generically expresses the value of an exchange as a ratio: it measures the amount of one thing needed to be exchanged for 1 unit of another thing (e.g. cash in a specific currency in exchange for a bond or share). This generic representation can be used to support any type of financial price beyond just cash price: e.g. an interest rate, a foreign exchange rate, etc. This data type is generically based on a schedule and can also be used to represent a price as a single value.
    /// </summary>
    public class PriceSchedule : AbstractRosettaModelObject<PriceSchedule>, IPriceSchedule, IMeasureSchedule
    {
        private static readonly IRosettaMetaData<PriceSchedule> metaData = new PriceScheduleMeta();
        
        [JsonConstructor]
        public PriceSchedule(UnitType? perUnitOf, PriceExpression priceExpression, IEnumerable<DatedValue> datedValue, UnitType? unit, decimal? value)
        {
            PerUnitOf = perUnitOf;
            PriceExpression = priceExpression;
            DatedValue = datedValue;
            Unit = unit;
            Value = value;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<PriceSchedule> MetaData => metaData;
        
        /// <inheritdoc/>
        public UnitType? PerUnitOf { get; }
        
        /// <inheritdoc/>
        public PriceExpression PriceExpression { get; }
        
        /// <inheritdoc/>
        public IEnumerable<DatedValue> DatedValue { get; }
        
        /// <inheritdoc/>
        public UnitType? Unit { get; }
        
        /// <inheritdoc/>
        public decimal? Value { get; }
    }
    
    /// <summary>
    /// Specifies a publication that provides the commodity price, including, where applicable, the details of where in the publication the price is published.
    /// </summary>
    public class PriceSource : AbstractRosettaModelObject<PriceSource>
    {
        private static readonly IRosettaMetaData<PriceSource> metaData = new PriceSourceMeta();
        
        [JsonConstructor]
        public PriceSource(FieldWithMetaString pricePublisher, string? priceSourceHeading, string? priceSourceLocation, LocalTime? priceSourceTime)
        {
            PricePublisher = pricePublisher;
            PriceSourceHeading = priceSourceHeading;
            PriceSourceLocation = priceSourceLocation;
            PriceSourceTime = priceSourceTime;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<PriceSource> MetaData => metaData;
        
        /// <summary>
        /// Defines a publication in which the price can be found. (e.g Gas Daily, Platts Bloomberg. Commodity publishers can be found at this URL:  http://www.fpml.org/coding-scheme/commodity-information-provider&gt;
        /// </summary>
        public FieldWithMetaString PricePublisher { get; }
        
        /// <summary>
        /// Specifies the heading or field name for the price  on a given page or screen, where applicable.
        /// </summary>
        public string? PriceSourceHeading { get; }
        
        /// <summary>
        /// Specifies the location of the price which may be a specific page, electornic screen name, or a code (e.g. a RIC code) where the price can be found.
        /// </summary>
        public string? PriceSourceLocation { get; }
        
        /// <summary>
        /// Specifies the time at which the price should be observed.
        /// </summary>
        public LocalTime? PriceSourceTime { get; }
    }
    
    /// <summary>
    /// A data defining:  the parameters used to get a price quote to replace the settlement rate option that is disrupted.
    /// </summary>
    public class PriceSourceDisruption : AbstractRosettaModelObject<PriceSourceDisruption>
    {
        private static readonly IRosettaMetaData<PriceSourceDisruption> metaData = new PriceSourceDisruptionMeta();
        
        [JsonConstructor]
        public PriceSourceDisruption(FallbackReferencePrice fallbackReferencePrice)
        {
            FallbackReferencePrice = fallbackReferencePrice;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<PriceSourceDisruption> MetaData => metaData;
        
        /// <summary>
        /// The method, prioritised by the order it is listed in this element, to get a replacement rate for the disrupted settlement rate option.
        /// </summary>
        public FallbackReferencePrice FallbackReferencePrice { get; }
    }
    
    /// <summary>
    /// Specifies specific dates or parametric rules for the dates on which the price will be determined
    /// </summary>
    public class PricingDates : AbstractRosettaModelObject<PricingDates>
    {
        private static readonly IRosettaMetaData<PricingDates> metaData = new PricingDatesMeta();
        
        [JsonConstructor]
        public PricingDates(ParametricDates? parametricDates, IEnumerable<AdjustableDates> specifiedDates)
        {
            ParametricDates = parametricDates;
            SpecifiedDates = specifiedDates;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<PricingDates> MetaData => metaData;
        
        /// <summary>
        /// Defines rules for the dates on which the price will be determined.
        /// </summary>
        public ParametricDates? ParametricDates { get; }
        
        /// <summary>
        /// Defines specified dates on which the price will be determined.
        /// </summary>
        public IEnumerable<AdjustableDates> SpecifiedDates { get; }
    }
    
    /// <summary>
    /// A Primitive Instruction describes the inputs required to pass into the corresponding PrimitiveEvent function.
    /// </summary>
    public class PrimitiveInstruction : AbstractRosettaModelObject<PrimitiveInstruction>
    {
        private static readonly IRosettaMetaData<PrimitiveInstruction> metaData = new PrimitiveInstructionMeta();
        
        [JsonConstructor]
        public PrimitiveInstruction(ContractFormationInstruction? contractFormation, ExecutionInstruction? execution, ExerciseInstruction? exercise, IndexTransitionInstruction? indexTransition, ObservationInstruction? observation, PartyChangeInstruction? partyChange, QuantityChangeInstruction? quantityChange, ResetInstruction? reset, SplitInstruction? split, StockSplitInstruction? stockSplit, TermsChangeInstruction? termsChange, TransferInstruction? transfer)
        {
            ContractFormation = contractFormation;
            Execution = execution;
            Exercise = exercise;
            IndexTransition = indexTransition;
            Observation = observation;
            PartyChange = partyChange;
            QuantityChange = quantityChange;
            Reset = reset;
            Split = split;
            StockSplit = stockSplit;
            TermsChange = termsChange;
            Transfer = transfer;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<PrimitiveInstruction> MetaData => metaData;
        
        /// <summary>
        /// Specifies instructions describing an contract formation primitive event.
        /// </summary>
        public ContractFormationInstruction? ContractFormation { get; }
        
        /// <summary>
        /// Specifies instructions describing an execution primitive event.
        /// </summary>
        public ExecutionInstruction? Execution { get; }
        
        /// <summary>
        /// Specifies instructions describing an exercise primitive event.
        /// </summary>
        public ExerciseInstruction? Exercise { get; }
        
        /// <summary>
        /// Specifies inputs needed to process a Index Transition business event.
        /// </summary>
        public IndexTransitionInstruction? IndexTransition { get; }
        
        /// <summary>
        /// Specifies inputs needed to process an observation.
        /// </summary>
        public ObservationInstruction? Observation { get; }
        
        /// <summary>
        /// Specifies instructions describing a party change primitive event.
        /// </summary>
        public PartyChangeInstruction? PartyChange { get; }
        
        /// <summary>
        /// Specifies instructions describing an quantity change primitive event.
        /// </summary>
        public QuantityChangeInstruction? QuantityChange { get; }
        
        /// <summary>
        /// Specifies instructions describing a reset event.
        /// </summary>
        public ResetInstruction? Reset { get; }
        
        /// <summary>
        /// Specifies instructions to split a trade into multiple branches.
        /// </summary>
        public SplitInstruction? Split { get; }
        
        /// <summary>
        /// Specifies inputs needed to process a Stock Split business event.
        /// </summary>
        public StockSplitInstruction? StockSplit { get; }
        
        /// <summary>
        /// Specifies instructions describing a terms change primitive event.
        /// </summary>
        public TermsChangeInstruction? TermsChange { get; }
        
        /// <summary>
        /// Specifies instructions describing a transfer primitive event.
        /// </summary>
        public TransferInstruction? Transfer { get; }
    }
    
    /// <summary>
    /// Any kind of principal payments when the amount is known and thus fixed.
    /// </summary>
    public class PrincipalPayment : AbstractRosettaModelObject<PrincipalPayment>
    {
        private static readonly IRosettaMetaData<PrincipalPayment> metaData = new PrincipalPaymentMeta();
        
        [JsonConstructor]
        public PrincipalPayment(decimal? discountFactor, _MetaFields? meta, PayerReceiver? payerReceiver, Money? presentValuePrincipalAmount, Money? principalAmount, AdjustableDate? principalPaymentDate)
        {
            DiscountFactor = discountFactor;
            Meta = meta;
            PayerReceiver = payerReceiver;
            PresentValuePrincipalAmount = presentValuePrincipalAmount;
            PrincipalAmount = principalAmount;
            PrincipalPaymentDate = principalPaymentDate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<PrincipalPayment> MetaData => metaData;
        
        /// <summary>
        /// The value representing the discount factor used to calculate the present value of the principal payment amount.
        /// </summary>
        public decimal? DiscountFactor { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <summary>
        /// Specifies the parties responsible for making and receiving payments defined by this structure.
        /// </summary>
        public PayerReceiver? PayerReceiver { get; }
        
        /// <summary>
        /// The amount representing the present value of the principal payment.
        /// </summary>
        public Money? PresentValuePrincipalAmount { get; }
        
        /// <summary>
        /// When known at the time the transaction is made, the cash amount to be paid.
        /// </summary>
        public Money? PrincipalAmount { get; }
        
        /// <summary>
        /// The date where the PrincipalPayment shall be settled.
        /// </summary>
        public AdjustableDate? PrincipalPaymentDate { get; }
    }
    
    /// <summary>
    /// Describe dates schedules for Principal Exchanges and related role of the parties when known.
    /// </summary>
    public class PrincipalPaymentSchedule : AbstractRosettaModelObject<PrincipalPaymentSchedule>
    {
        private static readonly IRosettaMetaData<PrincipalPaymentSchedule> metaData = new PrincipalPaymentScheduleMeta();
        
        [JsonConstructor]
        public PrincipalPaymentSchedule(PrincipalPayment? finalPrincipalPayment, PrincipalPayment? initialPrincipalPayment, AdjustableRelativeOrPeriodicDates? intermediatePrincipalPayment)
        {
            FinalPrincipalPayment = finalPrincipalPayment;
            InitialPrincipalPayment = initialPrincipalPayment;
            IntermediatePrincipalPayment = intermediatePrincipalPayment;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<PrincipalPaymentSchedule> MetaData => metaData;
        
        /// <summary>
        /// Principal Payment at Trade maturity
        /// </summary>
        public PrincipalPayment? FinalPrincipalPayment { get; }
        
        /// <summary>
        /// Principal Payment made at Trade inception.
        /// </summary>
        public PrincipalPayment? InitialPrincipalPayment { get; }
        
        /// <summary>
        /// Principal Payment as part of the Trade lifecycle e.g. as part of notional reset adjustements in a Cross Currency Swap with a varying notional leg.
        /// </summary>
        public AdjustableRelativeOrPeriodicDates? IntermediatePrincipalPayment { get; }
    }
    
    /// <summary>
    /// A class defining which principal exchanges occur for the stream.
    /// </summary>
    public class PrincipalPayments : AbstractRosettaModelObject<PrincipalPayments>
    {
        private static readonly IRosettaMetaData<PrincipalPayments> metaData = new PrincipalPaymentsMeta();
        
        [JsonConstructor]
        public PrincipalPayments(bool finalPayment, bool initialPayment, bool intermediatePayment, _MetaFields? meta, PrincipalPaymentSchedule? principalPaymentSchedule, IEnumerable<string> varyingLegNotionalCurrency)
        {
            FinalPayment = finalPayment;
            InitialPayment = initialPayment;
            IntermediatePayment = intermediatePayment;
            Meta = meta;
            PrincipalPaymentSchedule = principalPaymentSchedule;
            VaryingLegNotionalCurrency = varyingLegNotionalCurrency;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<PrincipalPayments> MetaData => metaData;
        
        /// <summary>
        /// A true/false flag to indicate whether there is a final exchange of principal on the termination date.
        /// </summary>
        public bool FinalPayment { get; }
        
        /// <summary>
        /// A true/false flag to indicate whether there is an initial exchange of principal on the effective date.
        /// </summary>
        public bool InitialPayment { get; }
        
        /// <summary>
        /// A true/false flag to indicate whether there are intermediate or interim exchanges of principal during the term of the swap.
        /// </summary>
        public bool IntermediatePayment { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <summary>
        /// Describe dates schedules for Principal Exchanges and related role of the parties when known.
        /// </summary>
        public PrincipalPaymentSchedule? PrincipalPaymentSchedule { get; }
        
        /// <summary>
        /// Indicate the Payout legs which nominal amount may vary in regards of FX Fixing dates as determined in the product terms.
        /// </summary>
        public IEnumerable<string> VaryingLegNotionalCurrency { get; }
    }
    
    /// <summary>
    /// Defines the product that is the subject of a tradable product definition, an underlying product definition, a physical exercise, a position, or other purposes.
    /// </summary>
    public class Product : AbstractRosettaModelObject<Product>
    {
        private static readonly IRosettaMetaData<Product> metaData = new ProductMeta();
        
        [JsonConstructor]
        public Product(AssetPool? assetPool, Basket? basket, ReferenceWithMetaCommodity? commodity, ContractualProduct? contractualProduct, ForeignExchange? foreignExchange, Index? index, Loan? loan, _MetaFields? meta, Security? security)
        {
            AssetPool = assetPool;
            Basket = basket;
            Commodity = commodity;
            ContractualProduct = contractualProduct;
            ForeignExchange = foreignExchange;
            Index = index;
            Loan = loan;
            Meta = meta;
            Security = security;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Product> MetaData => metaData;
        
        /// <summary>
        /// Identifies an asset pool product for defining pool of assets backing an asset backed security.
        /// </summary>
        public AssetPool? AssetPool { get; }
        
        /// <summary>
        /// Identifies a custom basket by referencing a product identifier and its constituents.
        /// </summary>
        public Basket? Basket { get; }
        
        /// <summary>
        /// Identifies a commodity by referencing a product identifier.
        /// </summary>
        public ReferenceWithMetaCommodity? Commodity { get; }
        
        /// <summary>
        /// Specifies the contractual product&apos;s economic terms, product identifier, and product taxonomy.
        /// </summary>
        public ContractualProduct? ContractualProduct { get; }
        
        /// <summary>
        /// Defines a foreign exchange spot or forward transaction.
        /// </summary>
        public ForeignExchange? ForeignExchange { get; }
        
        /// <summary>
        /// Identifies an index by referencing a product identifier.
        /// </summary>
        public Index? Index { get; }
        
        /// <summary>
        /// Identifies a loan by referencing a product identifier and an optional set of attributes.
        /// </summary>
        public Loan? Loan { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <summary>
        /// Identifies a security by referencing a product identifier and a security type, plus an optional set of attributes.
        /// </summary>
        public Security? Security { get; }
    }
    
    /// <summary>
    /// Serves as an abstract class to specify a product using a productIdentifier.
    /// </summary>
    public class ProductBase : AbstractRosettaModelObject<ProductBase>, IProductBase
    {
        private static readonly IRosettaMetaData<ProductBase> metaData = new ProductBaseMeta();
        
        [JsonConstructor]
        public ProductBase(IEnumerable<ReferenceWithMetaProductIdentifier> productIdentifier, IEnumerable<ProductTaxonomy> productTaxonomy)
        {
            ProductIdentifier = productIdentifier;
            ProductTaxonomy = productTaxonomy;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ProductBase> MetaData => metaData;
        
        /// <inheritdoc/>
        public IEnumerable<ReferenceWithMetaProductIdentifier> ProductIdentifier { get; }
        
        /// <inheritdoc/>
        public IEnumerable<ProductTaxonomy> ProductTaxonomy { get; }
    }
    
    /// <summary>
    /// Comprises an identifier and a source. The associated metadata key denotes the ability to associate a hash value to the ProductIdentifier instantiations for the purpose of model cross-referencing, in support of functionality such as the event effect and the lineage.
    /// </summary>
    public class ProductIdentifier : AbstractRosettaModelObject<ProductIdentifier>
    {
        private static readonly IRosettaMetaData<ProductIdentifier> metaData = new ProductIdentifierMeta();
        
        [JsonConstructor]
        public ProductIdentifier(FieldWithMetaString identifier, _MetaFields? meta, Enums.ProductIdType source)
        {
            Identifier = identifier;
            Meta = meta;
            Source = source;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ProductIdentifier> MetaData => metaData;
        
        /// <summary>
        /// Provides an identifier associated with a specific product.  The identifier is unique within the public source specified in the source attribute.
        /// </summary>
        public FieldWithMetaString Identifier { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <summary>
        /// Defines the source of the identifier.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.ProductIdType Source { get; }
    }
    
    /// <summary>
    /// Specifies the product taxonomy, which is composed of a taxonomy value and a taxonomy source.
    /// </summary>
    public class ProductTaxonomy : AbstractRosettaModelObject<ProductTaxonomy>, ITaxonomy
    {
        private static readonly IRosettaMetaData<ProductTaxonomy> metaData = new ProductTaxonomyMeta();
        
        [JsonConstructor]
        public ProductTaxonomy(FieldWithMetaAssetClassEnum? primaryAssetClass, string? productQualifier, IEnumerable<FieldWithMetaAssetClassEnum> secondaryAssetClass, Enums.TaxonomySource? source, TaxonomyValue? value)
        {
            PrimaryAssetClass = primaryAssetClass;
            ProductQualifier = productQualifier;
            SecondaryAssetClass = secondaryAssetClass;
            Source = source;
            Value = value;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ProductTaxonomy> MetaData => metaData;
        
        /// <summary>
        /// Classifies the most important risk class of the trade.
        /// </summary>
        public FieldWithMetaAssetClassEnum? PrimaryAssetClass { get; }
        
        /// <summary>
        /// Derived from the product payout features using a CDM product qualification function that determines the product type based on the product payout features.
        /// </summary>
        public string? ProductQualifier { get; }
        
        /// <summary>
        ///  Classifies additional risk classes of the trade, if any.
        /// </summary>
        public IEnumerable<FieldWithMetaAssetClassEnum> SecondaryAssetClass { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.TaxonomySource? Source { get; }
        
        /// <inheritdoc/>
        public TaxonomyValue? Value { get; }
    }
    
    /// <summary>
    /// A class to specify the terms for calculating a payout to protect the buyer of the swap in the case of a qualified credit event. These terms include the applicable credit events, the reference obligation, and in the case of a CDS on mortgage-backed securities, the floatingAmountEvents.
    /// </summary>
    public class ProtectionTerms : AbstractRosettaModelObject<ProtectionTerms>
    {
        private static readonly IRosettaMetaData<ProtectionTerms> metaData = new ProtectionTermsMeta();
        
        [JsonConstructor]
        public ProtectionTerms(CreditEvents? creditEvents, FloatingAmountEvents? floatingAmountEvents, _MetaFields? meta, Obligations? obligations)
        {
            CreditEvents = creditEvents;
            FloatingAmountEvents = floatingAmountEvents;
            Meta = meta;
            Obligations = obligations;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ProtectionTerms> MetaData => metaData;
        
        /// <summary>
        /// Specifies the applicable Credit Events that would trigger a settlement, as specified in the related Confirmation and defined in the ISDA 2014 Credit Definition article IV section 4.1.
        /// </summary>
        public CreditEvents? CreditEvents { get; }
        
        /// <summary>
        /// This element contains the ISDA terms relating to the floating rate payment events and the implied additional fixed payments, applicable to the credit derivatives transactions on mortgage-backed securities with pay-as-you-go or physical settlement.
        /// </summary>
        public FloatingAmountEvents? FloatingAmountEvents { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <summary>
        /// The underlying obligations of the reference entity on which you are buying or selling protection. The credit events Failure to Pay, Obligation Acceleration, Obligation Default, Restructuring, Repudiation/Moratorium are defined with respect to these obligations.
        /// </summary>
        public Obligations? Obligations { get; }
    }
    
    public class Prsn : AbstractRosettaModelObject<Prsn>
    {
        private static readonly IRosettaMetaData<Prsn> metaData = new PrsnMeta();
        
        [JsonConstructor]
        public Prsn(string ctryOfBrnch, Othr othr)
        {
            CtryOfBrnch = ctryOfBrnch;
            Othr = othr;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Prsn> MetaData => metaData;
        
        public string CtryOfBrnch { get; }
        
        public Othr Othr { get; }
    }
    
    public class PubliclyAvailableInformation : AbstractRosettaModelObject<PubliclyAvailableInformation>
    {
        private static readonly IRosettaMetaData<PubliclyAvailableInformation> metaData = new PubliclyAvailableInformationMeta();
        
        [JsonConstructor]
        public PubliclyAvailableInformation(IEnumerable<string> publicSource, int? specifiedNumber, bool? standardPublicSources)
        {
            PublicSource = publicSource;
            SpecifiedNumber = specifiedNumber;
            StandardPublicSources = standardPublicSources;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<PubliclyAvailableInformation> MetaData => metaData;
        
        /// <summary>
        /// A public information source, e.g. a particular newspaper or electronic news service, that may publish relevant information used in the determination of whether or not a credit event has occurred. ISDA 2003 Term: Public Source.
        /// </summary>
        public IEnumerable<string> PublicSource { get; }
        
        /// <summary>
        /// The minimum number of the specified public information sources that must publish information that reasonably confirms that a credit event has occurred. The market convention is two. ISDA 2003 Term: Specified Number.
        /// </summary>
        public int? SpecifiedNumber { get; }
        
        /// <summary>
        /// If this element is specified and set to &apos;true&apos;, indicates that ISDA defined Standard Public Sources are applicable.
        /// </summary>
        public bool? StandardPublicSources { get; }
    }
    
    public class Qty : AbstractRosettaModelObject<Qty>
    {
        private static readonly IRosettaMetaData<Qty> metaData = new QtyMeta();
        
        [JsonConstructor]
        public Qty(string unit)
        {
            Unit = unit;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Qty> MetaData => metaData;
        
        public string Unit { get; }
    }
    
    /// <summary>
    /// Specifies a quantity as a single value to be associated to a financial product, for example a transfer amount resulting from a trade. This data type extends QuantitySchedule and requires that only the single amount value exists.
    /// </summary>
    public class Quantity : AbstractRosettaModelObject<Quantity>, IQuantity, IQuantitySchedule
    {
        private static readonly IRosettaMetaData<Quantity> metaData = new QuantityMeta();
        
        [JsonConstructor]
        public Quantity(Frequency? frequency, Measure? multiplier, IEnumerable<DatedValue> datedValue, UnitType? unit, decimal? value)
        {
            Frequency = frequency;
            Multiplier = multiplier;
            DatedValue = datedValue;
            Unit = unit;
            Value = value;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Quantity> MetaData => metaData;
        
        /// <inheritdoc/>
        public Frequency? Frequency { get; }
        
        /// <inheritdoc/>
        public Measure? Multiplier { get; }
        
        /// <inheritdoc/>
        public IEnumerable<DatedValue> DatedValue { get; }
        
        /// <inheritdoc/>
        public UnitType? Unit { get; }
        
        /// <inheritdoc/>
        public decimal? Value { get; }
    }
    
    /// <summary>
    /// Instructions required to create a Quantity Change Primitive Event, which can be either an increase, a decrease or a replacement. An increase adds a new trade lot to the original trade, whereas a decrease subtracts from an existing trade lot&apos;s quantity. A replacement updates the quantity of an existing trade lot to the new value.
    /// </summary>
    public class QuantityChangeInstruction : AbstractRosettaModelObject<QuantityChangeInstruction>
    {
        private static readonly IRosettaMetaData<QuantityChangeInstruction> metaData = new QuantityChangeInstructionMeta();
        
        [JsonConstructor]
        public QuantityChangeInstruction(IEnumerable<PriceQuantity> change, Enums.QuantityChangeDirection direction, IEnumerable<Identifier> lotIdentifier)
        {
            Change = change;
            Direction = direction;
            LotIdentifier = lotIdentifier;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<QuantityChangeInstruction> MetaData => metaData;
        
        /// <summary>
        /// Quantity by which the trade is being increased, decreased or replaced, and the price at which such quantity change is agreed. The quantity change should always be specified as a positive number, with the direction (increase/decrease/replacement) being specified by the direction enumeration. A fee can also be associated to the quantity change by specifying a Price component of type CashPrice, including the corresponding settlement date and direction.
        /// </summary>
        public IEnumerable<PriceQuantity> Change { get; }
        
        /// <summary>
        /// Direction of the quantity change specified as either an increase, decrease or replacement.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.QuantityChangeDirection Direction { get; }
        
        /// <summary>
        /// Identifier for the new lot (in case of increase) or for the existing lot to be changed(in case of decrease or replacement). This optional attribute is mandatory in case of a decrease or replacement if the initial trade state contains multiple trade lots.
        /// </summary>
        public IEnumerable<Identifier> LotIdentifier { get; }
    }
    
    /// <summary>
    ///  Class to specify a mechanism for a quantity to be set as a multiplier to another (reference) quantity, based on a price observation. At the moment this class only supports FX or Equity-linked notional and re-uses existing building blocks for those 2 cases, until such time when component can be made more generic. This captures the case of resetting cross-currency swaps and resetting equity swaps.
    /// </summary>
    public class QuantityMultiplier : AbstractRosettaModelObject<QuantityMultiplier>
    {
        private static readonly IRosettaMetaData<QuantityMultiplier> metaData = new QuantityMultiplierMeta();
        
        [JsonConstructor]
        public QuantityMultiplier(FxLinkedNotionalSchedule? fxLinkedNotionalSchedule, decimal? multiplierValue)
        {
            FxLinkedNotionalSchedule = fxLinkedNotionalSchedule;
            MultiplierValue = multiplierValue;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<QuantityMultiplier> MetaData => metaData;
        
        /// <summary>
        /// Multiplier specified as an FX-linked schedule, e.g. for a resetting cross-currency swap..
        /// </summary>
        public FxLinkedNotionalSchedule? FxLinkedNotionalSchedule { get; }
        
        public decimal? MultiplierValue { get; }
    }
    
    /// <summary>
    /// Specifies a quantity schedule to be associated to a financial product to represent a trade amount. This data type extends MeasureSchedule with several unit or multiplier attributes that are used to define financial quantities. This data type is generically based on a schedule and can also be used to represent a quantity as a single value.
    /// </summary>
    public class QuantitySchedule : AbstractRosettaModelObject<QuantitySchedule>, IQuantitySchedule, IMeasureSchedule
    {
        private static readonly IRosettaMetaData<QuantitySchedule> metaData = new QuantityScheduleMeta();
        
        [JsonConstructor]
        public QuantitySchedule(Frequency? frequency, Measure? multiplier, IEnumerable<DatedValue> datedValue, UnitType? unit, decimal? value)
        {
            Frequency = frequency;
            Multiplier = multiplier;
            DatedValue = datedValue;
            Unit = unit;
            Value = value;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<QuantitySchedule> MetaData => metaData;
        
        /// <inheritdoc/>
        public Frequency? Frequency { get; }
        
        /// <inheritdoc/>
        public Measure? Multiplier { get; }
        
        /// <inheritdoc/>
        public IEnumerable<DatedValue> DatedValue { get; }
        
        /// <inheritdoc/>
        public UnitType? Unit { get; }
        
        /// <inheritdoc/>
        public decimal? Value { get; }
    }
    
    /// <summary>
    /// Determines the currency rate that the seller of the equity amounts will apply at each valuation date for converting the respective amounts into a currency that is different from the currency denomination of the underlier.
    /// </summary>
    public class Quanto : AbstractRosettaModelObject<Quanto>
    {
        private static readonly IRosettaMetaData<Quanto> metaData = new QuantoMeta();
        
        [JsonConstructor]
        public Quanto(BusinessCenterTime? fixingTime, IEnumerable<FxRate> fxRate, FxSpotRateSource? fxSpotRateSource)
        {
            FixingTime = fixingTime;
            FxRate = fxRate;
            FxSpotRateSource = fxSpotRateSource;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Quanto> MetaData => metaData;
        
        /// <summary>
        /// The time at which the spot currency exchange rate will be observed. It is specified as a time in a business day calendar location, e.g. 11:00am London time.
        /// </summary>
        public BusinessCenterTime? FixingTime { get; }
        
        /// <summary>
        /// Specifies a currency conversion rate.
        /// </summary>
        public IEnumerable<FxRate> FxRate { get; }
        
        /// <summary>
        /// Specifies the methodology (reference source and, optionally, fixing time) to be used for determining a currency conversion rate.
        /// </summary>
        public FxSpotRateSource? FxSpotRateSource { get; }
    }
    
    /// <summary>
    /// Represents a class to allow specification of different types of Quasi Government collateral.
    /// </summary>
    public class QuasiGovernmentIssuerType : AbstractRosettaModelObject<QuasiGovernmentIssuerType>
    {
        private static readonly IRosettaMetaData<QuasiGovernmentIssuerType> metaData = new QuasiGovernmentIssuerTypeMeta();
        
        [JsonConstructor]
        public QuasiGovernmentIssuerType(bool sovereignEntity, bool? sovereignRecourse)
        {
            SovereignEntity = sovereignEntity;
            SovereignRecourse = sovereignRecourse;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<QuasiGovernmentIssuerType> MetaData => metaData;
        
        /// <summary>
        /// True if sovereign entity (e.g. not separate legal personality from sovereign) or false if non-sovereign entity (e.g. separate legal personality from sovereign).
        /// </summary>
        public bool SovereignEntity { get; }
        
        /// <summary>
        /// Applies to non-sovereign entity (e.g. separate legal personality from sovereign).  True if entity has recourse to sovereign (e.g. debt guaranteed by government).  False if entity does not have recourse to sovereign.
        /// </summary>
        public bool? SovereignRecourse { get; }
    }
    
    /// <summary>
    /// A class that describes the composition of a rate that has been quoted or is to be quoted. This includes the two currencies and the quotation relationship between the two currencies and is used as a building block throughout the FX specification.
    /// </summary>
    public class QuotedCurrencyPair : AbstractRosettaModelObject<QuotedCurrencyPair>, IQuotedCurrencyPair
    {
        private static readonly IRosettaMetaData<QuotedCurrencyPair> metaData = new QuotedCurrencyPairMeta();
        
        [JsonConstructor]
        public QuotedCurrencyPair(FieldWithMetaString currency1, FieldWithMetaString currency2, Enums.QuoteBasis quoteBasis)
        {
            Currency1 = currency1;
            Currency2 = currency2;
            QuoteBasis = quoteBasis;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<QuotedCurrencyPair> MetaData => metaData;
        
        /// <inheritdoc/>
        public FieldWithMetaString Currency1 { get; }
        
        /// <inheritdoc/>
        public FieldWithMetaString Currency2 { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.QuoteBasis QuoteBasis { get; }
    }
    
    /// <summary>
    /// A class defining parameters associated with an individual observation or fixing. This class forms part of the cashflow representation of a stream.
    /// </summary>
    public class RateObservation : AbstractRosettaModelObject<RateObservation>
    {
        private static readonly IRosettaMetaData<RateObservation> metaData = new RateObservationMeta();
        
        [JsonConstructor]
        public RateObservation(LocalDate? adjustedFixingDate, decimal? forecastRate, _MetaFields? meta, int? observationWeight, decimal? observedRate, ReferenceWithMetaRateObservation? rateReference, LocalDate? resetDate, decimal? treatedForecastRate, decimal? treatedRate)
        {
            AdjustedFixingDate = adjustedFixingDate;
            ForecastRate = forecastRate;
            Meta = meta;
            ObservationWeight = observationWeight;
            ObservedRate = observedRate;
            RateReference = rateReference;
            ResetDate = resetDate;
            TreatedForecastRate = treatedForecastRate;
            TreatedRate = treatedRate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<RateObservation> MetaData => metaData;
        
        /// <summary>
        /// The adjusted fixing date, i.e. the actual date the rate is observed. The date should already be adjusted for any applicable business day convention.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? AdjustedFixingDate { get; }
        
        /// <summary>
        /// The value representing the forecast rate used to calculate the forecast future value of the accrual period.A value of 1% should be represented as 0.01.
        /// </summary>
        public decimal? ForecastRate { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <summary>
        /// The number of days weighting to be associated with the rate observation, i.e. the number of days such rate is in effect. This is applicable in the case of a weighted average method of calculation where more than one reset date is established for a single calculation period.
        /// </summary>
        public int? ObservationWeight { get; }
        
        /// <summary>
        /// The actual observed rate before any required rate treatment is applied, e.g. before converting a rate quoted on a discount basis to an equivalent yield. An observed rate of 5% would be represented as 0.05.
        /// </summary>
        public decimal? ObservedRate { get; }
        
        /// <summary>
        /// A pointer style reference to a floating rate component defined as part of a stub calculation period amount component. It is only required when it is necessary to distinguish two rate observations for the same fixing date which could occur when linear interpolation of two different rates occurs for a stub calculation period.
        /// </summary>
        public ReferenceWithMetaRateObservation? RateReference { get; }
        
        /// <summary>
        /// The reset date.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? ResetDate { get; }
        
        /// <summary>
        /// The value representing the forecast rate after applying rate treatment rules. A value of 1% should be represented as 0.01.
        /// </summary>
        public decimal? TreatedForecastRate { get; }
        
        /// <summary>
        /// The observed rate after any required rate treatment is applied. A treated rate of 5% would be represented as 0.05.
        /// </summary>
        public decimal? TreatedRate { get; }
    }
    
    /// <summary>
    /// A class defining a schedule of rates or amounts in terms of an initial value and then a series of step date and value pairs. On each step date the rate or amount changes to the new step value. The series of step date and value pairs are optional. If not specified, this implies that the initial value remains unchanged over time.
    /// </summary>
    public class RateSchedule : AbstractRosettaModelObject<RateSchedule>, IRateSchedule
    {
        private static readonly IRosettaMetaData<RateSchedule> metaData = new RateScheduleMeta();
        
        [JsonConstructor]
        public RateSchedule(ReferenceWithMetaPriceSchedule price)
        {
            Price = price;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<RateSchedule> MetaData => metaData;
        
        /// <inheritdoc/>
        public ReferenceWithMetaPriceSchedule Price { get; }
    }
    
    /// <summary>
    ///  A class to specify the fixed interest rate, floating interest rate or inflation rate.
    /// </summary>
    public class RateSpecification : AbstractRosettaModelObject<RateSpecification>
    {
        private static readonly IRosettaMetaData<RateSpecification> metaData = new RateSpecificationMeta();
        
        [JsonConstructor]
        public RateSpecification(FixedRateSpecification? fixedRate, FloatingRateSpecification? floatingRate, InflationRateSpecification? inflationRate)
        {
            FixedRate = fixedRate;
            FloatingRate = floatingRate;
            InflationRate = inflationRate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<RateSpecification> MetaData => metaData;
        
        /// <summary>
        /// The fixed rate or fixed rate specification expressed as explicit fixed rates and dates.
        /// </summary>
        public FixedRateSpecification? FixedRate { get; }
        
        /// <summary>
        /// The floating interest rate specification, which includes the definition of the floating rate index. the tenor, the initial value, and, when applicable, the spread, the rounding convention, the averaging method and the negative interest rate treatment.
        /// </summary>
        public FloatingRateSpecification? FloatingRate { get; }
        
        /// <summary>
        /// An inflation rate calculation definition.
        /// </summary>
        public InflationRateSpecification? InflationRate { get; }
    }
    
    public class RefRate : AbstractRosettaModelObject<RefRate>
    {
        private static readonly IRosettaMetaData<RefRate> metaData = new RefRateMeta();
        
        [JsonConstructor]
        public RefRate(string indx, string nm)
        {
            Indx = indx;
            Nm = nm;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<RefRate> MetaData => metaData;
        
        public string Indx { get; }
        
        public string Nm { get; }
    }
    
    /// <summary>
    /// A class to describe an institution (party) identified by means of a coding scheme and an optional name.
    /// </summary>
    public class ReferenceBank : AbstractRosettaModelObject<ReferenceBank>
    {
        private static readonly IRosettaMetaData<ReferenceBank> metaData = new ReferenceBankMeta();
        
        [JsonConstructor]
        public ReferenceBank(FieldWithMetaString referenceBankId, string? referenceBankName)
        {
            ReferenceBankId = referenceBankId;
            ReferenceBankName = referenceBankName;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ReferenceBank> MetaData => metaData;
        
        /// <summary>
        /// An institution (party) identifier, e.g. a bank identifier code (BIC). FpML specifies a referenceBankIdScheme.
        /// </summary>
        public FieldWithMetaString ReferenceBankId { get; }
        
        /// <summary>
        /// The name of the institution (party). A free format string. FpML does not define usage rules for the element.
        /// </summary>
        public string? ReferenceBankName { get; }
    }
    
    /// <summary>
    /// A class defining the list of reference institutions polled for relevant rates or prices when determining the cash settlement amount for a product where cash settlement is applicable.
    /// </summary>
    public class ReferenceBanks : AbstractRosettaModelObject<ReferenceBanks>
    {
        private static readonly IRosettaMetaData<ReferenceBanks> metaData = new ReferenceBanksMeta();
        
        [JsonConstructor]
        public ReferenceBanks(IEnumerable<ReferenceBank> referenceBank)
        {
            ReferenceBank = referenceBank;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ReferenceBanks> MetaData => metaData;
        
        /// <summary>
        /// An institution (party) identified by means of a coding scheme and an optional name.
        /// </summary>
        public IEnumerable<ReferenceBank> ReferenceBank { get; }
    }
    
    /// <summary>
    /// A class specifying the Credit Default Swap Reference Information.
    /// </summary>
    public class ReferenceInformation : AbstractRosettaModelObject<ReferenceInformation>
    {
        private static readonly IRosettaMetaData<ReferenceInformation> metaData = new ReferenceInformationMeta();
        
        [JsonConstructor]
        public ReferenceInformation(bool? allGuarantees, bool? noReferenceObligation, LegalEntity referenceEntity, IEnumerable<ReferenceObligation> referenceObligation, bool? referencePolicy, Price? referencePrice, bool? securedList, bool? unknownReferenceObligation)
        {
            AllGuarantees = allGuarantees;
            NoReferenceObligation = noReferenceObligation;
            ReferenceEntity = referenceEntity;
            ReferenceObligation = referenceObligation;
            ReferencePolicy = referencePolicy;
            ReferencePrice = referencePrice;
            SecuredList = securedList;
            UnknownReferenceObligation = unknownReferenceObligation;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ReferenceInformation> MetaData => metaData;
        
        /// <summary>
        /// Indicates whether an obligation of the Reference Entity, guaranteed by the Reference Entity on behalf of a non-Affiliate, is to be considered an Obligation for the purpose of the transaction. It will be considered an obligation if allGuarantees is applicable (true) and not if allGuarantees is inapplicable (false). ISDA 2003 Term: All Guarantees.
        /// </summary>
        public bool? AllGuarantees { get; }
        
        /// <summary>
        /// Used to indicate that there is no Reference Obligation associated with this Credit Default Swap and that there will never be one.
        /// </summary>
        public bool? NoReferenceObligation { get; }
        
        /// <summary>
        /// The corporate or sovereign entity which is subject to the swap transaction and any successor that assumes all or substantially all of its contractual and other obligations. Reference Entities cannot be senior or subordinated. It is the obligations of the Reference Entities that can be senior or subordinated. ISDA 2014 Credit definitions article II section 2.1: `Reference Entity` means the entity specified as such in the related Confirmation.
        /// </summary>
        public LegalEntity ReferenceEntity { get; }
        
        /// <summary>
        /// The Reference Obligation is a financial instrument that is either issued or guaranteed by the reference entity. It serves to clarify the precise reference entity protection is being offered upon, and its legal position with regard to other related firms (parents/subsidiaries). Furthermore the Reference Obligation is ALWAYS deliverable and establishes the Pari Passu ranking (as the deliverable bonds must rank equal to the reference obligation). ISDA 2003 Term: Reference Obligation.
        /// </summary>
        public IEnumerable<ReferenceObligation> ReferenceObligation { get; }
        
        /// <summary>
        /// Applicable to the transactions on mortgage-backed security, which can make use of a reference policy. Presence of the element with value set to &apos;true&apos; indicates that the reference policy is applicable; absence implies that it is not.
        /// </summary>
        public bool? ReferencePolicy { get; }
        
        /// <summary>
        /// Used to determine (a) for physically settled trades, the Physical Settlement Amount, which equals the Floating Rate Payer Calculation Amount times the Reference Price and (b) for cash settled trades, the Cash Settlement Amount, which equals the greater of (i) the difference between the Reference Price and the Final Price and (ii) zero. ISDA 2003 Term: Reference Price.
        /// </summary>
        public Price? ReferencePrice { get; }
        
        /// <summary>
        /// With respect to any day, the list of Syndicated Secured Obligations of the Designated Priority of the Reference Entity published by Markit Group Limited or any successor thereto appointed by the Specified Dealers (the &apos;Secured List Publisher&apos;) on or most recently before such day, which list is currently available at [http://www.markit.com]. ISDA 2003 Term: Relevant Secured List.
        /// </summary>
        public bool? SecuredList { get; }
        
        /// <summary>
        /// Used to indicate that the Reference obligation associated with the Credit Default Swap is currently not known. This is not valid for Legal Confirmation purposes, but is valid for earlier stages in the trade life cycle (e.g. Broker Confirmation).
        /// </summary>
        public bool? UnknownReferenceObligation { get; }
    }
    
    /// <summary>
    /// A class to specify the reference obligation that is associated with a credit derivative instrument.
    /// </summary>
    public class ReferenceObligation : AbstractRosettaModelObject<ReferenceObligation>
    {
        private static readonly IRosettaMetaData<ReferenceObligation> metaData = new ReferenceObligationMeta();
        
        [JsonConstructor]
        public ReferenceObligation(LegalEntity? guarantor, string? guarantorReference, Loan? loan, LegalEntity? primaryObligor, ReferenceWithMetaLegalEntity? primaryObligorReference, Security? security, bool? standardReferenceObligation)
        {
            Guarantor = guarantor;
            GuarantorReference = guarantorReference;
            Loan = loan;
            PrimaryObligor = primaryObligor;
            PrimaryObligorReference = primaryObligorReference;
            Security = security;
            StandardReferenceObligation = standardReferenceObligation;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ReferenceObligation> MetaData => metaData;
        
        /// <summary>
        /// The party that guarantees by way of a contractual arrangement to pay the debts of an obligor if the obligor is unable to make the required payments itself. ISDA 2003 Term: Guarantor.
        /// </summary>
        public LegalEntity? Guarantor { get; }
        
        /// <summary>
        /// A pointer style reference to a reference entity defined elsewhere in the document. Used when the reference entity is the guarantor.
        /// </summary>
        public string? GuarantorReference { get; }
        
        /// <summary>
        /// Identifies the underlying asset when it is a loan.
        /// </summary>
        public Loan? Loan { get; }
        
        /// <summary>
        /// The entity primarily responsible for repaying debt to a creditor as a result of borrowing or issuing bonds. ISDA 2003 Term: Primary Obligor.
        /// </summary>
        public LegalEntity? PrimaryObligor { get; }
        
        /// <summary>
        /// A pointer style reference to a reference entity defined elsewhere in the document. Used when the reference entity is the primary obligor.
        /// </summary>
        public ReferenceWithMetaLegalEntity? PrimaryObligorReference { get; }
        
        /// <summary>
        /// Identifies the underlying asset when it is a security, such as a bond or convertible bond. The security data type requires one or more productIdentifiers, specificaiton of the security type (e.g. debt), and includes optional attributes to specify a debt class, such as asset-backed, as well as seniority.
        /// </summary>
        public Security? Security { get; }
        
        /// <summary>
        /// Indicates if the reference obligation is a Standard Reference Obligation. ISDA 2014 Term: Standard Reference Obligation.
        /// </summary>
        public bool? StandardReferenceObligation { get; }
    }
    
    public class ReferencePair : AbstractRosettaModelObject<ReferencePair>
    {
        private static readonly IRosettaMetaData<ReferencePair> metaData = new ReferencePairMeta();
        
        [JsonConstructor]
        public ReferencePair(FieldWithMetaEntityTypeEnum entityType, bool? noReferenceObligation, LegalEntity referenceEntity, ReferenceObligation? referenceObligation)
        {
            EntityType = entityType;
            NoReferenceObligation = noReferenceObligation;
            ReferenceEntity = referenceEntity;
            ReferenceObligation = referenceObligation;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ReferencePair> MetaData => metaData;
        
        /// <summary>
        /// Defines the reference entity types corresponding to a list of types in the ISDA First to Default documentation.
        /// </summary>
        public FieldWithMetaEntityTypeEnum EntityType { get; }
        
        /// <summary>
        /// Used to indicate that there is no Reference Obligation associated with this Credit Default Swap and that there will never be one.
        /// </summary>
        public bool? NoReferenceObligation { get; }
        
        /// <summary>
        /// The corporate or sovereign entity on which you are buying or selling protection and any successor that assumes all or substantially all of its contractual and other obligations. It is vital to use the correct legal name of the entity and to be careful not to choose a subsidiary if you really want to trade protection on a parent company. Please note, Reference Entities cannot be senior or subordinated. It is the obligations of the Reference Entities that can be senior or subordinated. ISDA 2003 Term: Reference Entity.
        /// </summary>
        public LegalEntity ReferenceEntity { get; }
        
        /// <summary>
        /// The Reference Obligation is a financial instrument that is either issued or guaranteed by the reference entity. It serves to clarify the precise reference entity protection is being offered upon, and its legal position with regard to other related firms (parents/subsidiaries). Furthermore the Reference Obligation is ALWAYS deliverable and establishes the Pari Passu ranking (as the deliverable bonds must rank equal to the reference obligation). ISDA 2003 Term: Reference Obligation.
        /// </summary>
        public ReferenceObligation? ReferenceObligation { get; }
    }
    
    /// <summary>
    /// This type contains all the reference pool items to define the reference entity and reference obligation(s) in the basket.
    /// </summary>
    public class ReferencePool : AbstractRosettaModelObject<ReferencePool>
    {
        private static readonly IRosettaMetaData<ReferencePool> metaData = new ReferencePoolMeta();
        
        [JsonConstructor]
        public ReferencePool(IEnumerable<ReferencePoolItem> referencePoolItem)
        {
            ReferencePoolItem = referencePoolItem;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ReferencePool> MetaData => metaData;
        
        /// <summary>
        /// This type contains all the constituent weight and reference information.
        /// </summary>
        public IEnumerable<ReferencePoolItem> ReferencePoolItem { get; }
    }
    
    /// <summary>
    /// This type contains all the constituent weight and reference information.
    /// </summary>
    public class ReferencePoolItem : AbstractRosettaModelObject<ReferencePoolItem>
    {
        private static readonly IRosettaMetaData<ReferencePoolItem> metaData = new ReferencePoolItemMeta();
        
        [JsonConstructor]
        public ReferencePoolItem(ReferenceWithMetaCashSettlementTerms? cashSettlementTermsReference, ConstituentWeight? constituentWeight, ReferenceWithMetaPhysicalSettlementTerms? physicalSettlementTermsReference, ReferenceWithMetaProtectionTerms? protectionTermsReference, ReferencePair referencePair)
        {
            CashSettlementTermsReference = cashSettlementTermsReference;
            ConstituentWeight = constituentWeight;
            PhysicalSettlementTermsReference = physicalSettlementTermsReference;
            ProtectionTermsReference = protectionTermsReference;
            ReferencePair = referencePair;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ReferencePoolItem> MetaData => metaData;
        
        /// <summary>
        /// Reference to the cash settlement terms applicable to this item.
        /// </summary>
        public ReferenceWithMetaCashSettlementTerms? CashSettlementTermsReference { get; }
        
        /// <summary>
        /// Describes the weight of each of the constituents within the basket. If not provided, it is assumed to be equal weighted.
        /// </summary>
        public ConstituentWeight? ConstituentWeight { get; }
        
        /// <summary>
        /// Reference to the physical settlement terms applicable to this item.
        /// </summary>
        public ReferenceWithMetaPhysicalSettlementTerms? PhysicalSettlementTermsReference { get; }
        
        /// <summary>
        /// Reference to the documentation terms applicable to this item.
        /// </summary>
        public ReferenceWithMetaProtectionTerms? ProtectionTermsReference { get; }
        
        public ReferencePair ReferencePair { get; }
    }
    
    /// <summary>
    /// A complex type used to specify the option and convertible bond option strike when expressed in reference to a swap curve.
    /// </summary>
    public class ReferenceSwapCurve : AbstractRosettaModelObject<ReferenceSwapCurve>
    {
        private static readonly IRosettaMetaData<ReferenceSwapCurve> metaData = new ReferenceSwapCurveMeta();
        
        [JsonConstructor]
        public ReferenceSwapCurve(MakeWholeAmount? makeWholeAmount, SwapCurveValuation swapUnwindValue)
        {
            MakeWholeAmount = makeWholeAmount;
            SwapUnwindValue = swapUnwindValue;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ReferenceSwapCurve> MetaData => metaData;
        
        /// <summary>
        /// Amount to be paid by the buyer of the option if the option is exercised prior to the Early Call Date. (The market practice in the convertible bond option space being that the buyer should be penalised if he/she exercises the option early on.)
        /// </summary>
        public MakeWholeAmount? MakeWholeAmount { get; }
        
        public SwapCurveValuation SwapUnwindValue { get; }
    }
    
    /// <summary>
    /// Represents a class to allow specification of different type of Regional government collateral.
    /// </summary>
    public class RegionalGovernmentIssuerType : AbstractRosettaModelObject<RegionalGovernmentIssuerType>
    {
        private static readonly IRosettaMetaData<RegionalGovernmentIssuerType> metaData = new RegionalGovernmentIssuerTypeMeta();
        
        [JsonConstructor]
        public RegionalGovernmentIssuerType(bool sovereignRecourse)
        {
            SovereignRecourse = sovereignRecourse;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<RegionalGovernmentIssuerType> MetaData => metaData;
        
        /// <summary>
        /// Applies to regional governments, local authorities or municipals.  True if entity has recourse to sovereign (e.g. debt guaranteed by government).  False if entity does not have recourse to sovereign.
        /// </summary>
        public bool SovereignRecourse { get; }
    }
    
    public class RelatedParty : AbstractRosettaModelObject<RelatedParty>
    {
        private static readonly IRosettaMetaData<RelatedParty> metaData = new RelatedPartyMeta();
        
        [JsonConstructor]
        public RelatedParty(ReferenceWithMetaAccount? accountReference, ReferenceWithMetaParty partyReference, Enums.PartyRole role)
        {
            AccountReference = accountReference;
            PartyReference = partyReference;
            Role = role;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<RelatedParty> MetaData => metaData;
        
        /// <summary>
        /// Reference to an account.
        /// </summary>
        public ReferenceWithMetaAccount? AccountReference { get; }
        
        /// <summary>
        /// Reference to a party.
        /// </summary>
        public ReferenceWithMetaParty PartyReference { get; }
        
        /// <summary>
        /// The category of the relationship. The related party performs the role specified in this field for the base party. For example, if the role is ,Guarantor, the related party acts as a guarantor for the base party.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.PartyRole Role { get; }
    }
    
    /// <summary>
    /// A class defining a date (referred to as the derived date) as a relative offset from another date (referred to as the anchor date). If the anchor date is itself an adjustable date then the offset is assumed to be calculated from the adjusted anchor date. A number of different scenarios can be supported, namely; 1) the derived date may simply be a number of calendar periods (days, weeks, months or years) preceding or following the anchor date; 2) the unadjusted derived date may be a number of calendar periods (days, weeks, months or years) preceding or following the anchor date with the resulting unadjusted derived date subject to adjustment in accordance with a specified business day convention, i.e. the derived date must fall on a good business day; 3) the derived date may be a number of business days preceding or following the anchor date. Note that the businessDayConvention specifies any required adjustment to the unadjusted derived date. A negative or positive value in the periodMultiplier indicates whether the unadjusted derived precedes or follows the anchor date. The businessDayConvention should contain a value NONE if the day type element contains a value of Business (since specifying a negative or positive business days offset would already guarantee that the derived date would fall on a good business day in the specified business centers).
    /// </summary>
    public class RelativeDateOffset : AbstractRosettaModelObject<RelativeDateOffset>, IRelativeDateOffset, IOffset
    {
        private static readonly IRosettaMetaData<RelativeDateOffset> metaData = new RelativeDateOffsetMeta();
        
        [JsonConstructor]
        public RelativeDateOffset(LocalDate? adjustedDate, BusinessCenters? businessCenters, ReferenceWithMetaBusinessCenters? businessCentersReference, Enums.BusinessDayConvention businessDayConvention, BasicReferenceWithMetaLocalDate? dateRelativeTo, Enums.DayType? dayType, _MetaFields? meta, Enums.Period period, int periodMultiplier)
        {
            AdjustedDate = adjustedDate;
            BusinessCenters = businessCenters;
            BusinessCentersReference = businessCentersReference;
            BusinessDayConvention = businessDayConvention;
            DateRelativeTo = dateRelativeTo;
            DayType = dayType;
            Meta = meta;
            PeriodValue = period;
            PeriodMultiplier = periodMultiplier;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<RelativeDateOffset> MetaData => metaData;
        
        /// <inheritdoc/>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? AdjustedDate { get; }
        
        public BusinessCenters? BusinessCenters { get; }
        
        /// <inheritdoc/>
        public ReferenceWithMetaBusinessCenters? BusinessCentersReference { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.BusinessDayConvention BusinessDayConvention { get; }
        
        /// <inheritdoc/>
        public BasicReferenceWithMetaLocalDate? DateRelativeTo { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.DayType? DayType { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        [JsonProperty(PropertyName = "period")]
        public Enums.Period PeriodValue { get; }
        
        /// <inheritdoc/>
        public int PeriodMultiplier { get; }
    }
    
    /// <summary>
    /// A class describing a set of dates defined as relative to another set of dates.
    /// </summary>
    public class RelativeDates : AbstractRosettaModelObject<RelativeDates>, IRelativeDateOffset
    {
        private static readonly IRosettaMetaData<RelativeDates> metaData = new RelativeDatesMeta();
        
        [JsonConstructor]
        public RelativeDates(int? periodSkip, DateRange? scheduleBounds, LocalDate? adjustedDate, BusinessCenters? businessCenters, ReferenceWithMetaBusinessCenters? businessCentersReference, Enums.BusinessDayConvention businessDayConvention, BasicReferenceWithMetaLocalDate? dateRelativeTo, Enums.DayType? dayType, _MetaFields? meta, Enums.Period period, int periodMultiplier)
        {
            PeriodSkip = periodSkip;
            ScheduleBounds = scheduleBounds;
            AdjustedDate = adjustedDate;
            BusinessCenters = businessCenters;
            BusinessCentersReference = businessCentersReference;
            BusinessDayConvention = businessDayConvention;
            DateRelativeTo = dateRelativeTo;
            DayType = dayType;
            Meta = meta;
            PeriodValue = period;
            PeriodMultiplier = periodMultiplier;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<RelativeDates> MetaData => metaData;
        
        /// <summary>
        /// The number of periods in the referenced date schedule that are between each date in the relative date schedule. Thus a skip of 2 would mean that dates are relative to every second date in the referenced schedule. If present this should have a value greater than 1.
        /// </summary>
        public int? PeriodSkip { get; }
        
        /// <summary>
        /// The first and last dates of a schedule. This can be used to restrict the range of values in a reference series of dates.
        /// </summary>
        public DateRange? ScheduleBounds { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? AdjustedDate { get; }
        
        public BusinessCenters? BusinessCenters { get; }
        
        /// <inheritdoc/>
        public ReferenceWithMetaBusinessCenters? BusinessCentersReference { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.BusinessDayConvention BusinessDayConvention { get; }
        
        /// <inheritdoc/>
        public BasicReferenceWithMetaLocalDate? DateRelativeTo { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.DayType? DayType { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        [JsonProperty(PropertyName = "period")]
        public Enums.Period PeriodValue { get; }
        
        /// <inheritdoc/>
        public int PeriodMultiplier { get; }
    }
    
    /// <summary>
    ///  Bond price relative to a benchmark, as in a convertible bond.
    /// </summary>
    public class RelativePrice : AbstractRosettaModelObject<RelativePrice>
    {
        private static readonly IRosettaMetaData<RelativePrice> metaData = new RelativePriceMeta();
        
        [JsonConstructor]
        public RelativePrice(IEnumerable<BondEquityModel> bondEquityModel, decimal spread)
        {
            BondEquityModel = bondEquityModel;
            Spread = spread;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<RelativePrice> MetaData => metaData;
        
        /// <summary>
        /// Bond equity model for convertible bonds.
        /// </summary>
        public IEnumerable<BondEquityModel> BondEquityModel { get; }
        
        /// <summary>
        /// The spread to a benchmark.
        /// </summary>
        public decimal Spread { get; }
    }
    
    public class Representations : AbstractRosettaModelObject<Representations>
    {
        private static readonly IRosettaMetaData<Representations> metaData = new RepresentationsMeta();
        
        [JsonConstructor]
        public Representations(bool? additionalAcknowledgements, bool agreementsRegardingHedging, bool? indexDisclaimer, bool nonReliance)
        {
            AdditionalAcknowledgements = additionalAcknowledgements;
            AgreementsRegardingHedging = agreementsRegardingHedging;
            IndexDisclaimer = indexDisclaimer;
            NonReliance = nonReliance;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Representations> MetaData => metaData;
        
        /// <summary>
        /// If true, then additional acknowledgements are applicable.
        /// </summary>
        public bool? AdditionalAcknowledgements { get; }
        
        /// <summary>
        /// If true, then agreements regarding hedging are applicable.
        /// </summary>
        public bool AgreementsRegardingHedging { get; }
        
        /// <summary>
        /// If present and true, then index disclaimer is applicable.
        /// </summary>
        public bool? IndexDisclaimer { get; }
        
        /// <summary>
        /// If true, then non reliance is applicable.
        /// </summary>
        public bool NonReliance { get; }
    }
    
    /// <summary>
    /// Defines the reset value or fixing value produced in cashflow calculations, during the life-cycle of a financial instrument. The reset process defined in Create_Reset function joins product definition details with observations to compute the reset value.
    /// </summary>
    public class Reset : AbstractRosettaModelObject<Reset>
    {
        private static readonly IRosettaMetaData<Reset> metaData = new ResetMeta();
        
        [JsonConstructor]
        public Reset(AveragingCalculation? averagingMethodology, _MetaFields? meta, IEnumerable<ReferenceWithMetaObservation> observations, LocalDate? rateRecordDate, LocalDate resetDate, Price resetValue)
        {
            AveragingMethodology = averagingMethodology;
            Meta = meta;
            Observations = observations;
            RateRecordDate = rateRecordDate;
            ResetDate = resetDate;
            ResetValue = resetValue;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Reset> MetaData => metaData;
        
        /// <summary>
        /// Identifies the aggregation method to use in the case where multiple observations are used to compute the reset value and the method is not defined in a payout.
        /// </summary>
        public AveragingCalculation? AveragingMethodology { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <summary>
        /// Represents an audit of the observations used to produce the reset value. If multiple observations were necessary to produce the reset value, the aggregation method should be defined on the payout.
        /// </summary>
        public IEnumerable<ReferenceWithMetaObservation> Observations { get; }
        
        /// <summary>
        /// Specifies the &apos;Rate Record Day&apos; for a Fallback rate.  Fallback rate fixing processes typically set the fixing rate in arrears, i.e., the Fallback Rate corresponding to a Rate Record Date is set at the end of the interest accural period.  When this applies, Reset-&gt;resetDate occurs at the end of the interest period, and the Reset-&gt;rateRecordDate occurs near the start of the interest period.  The Reset-&gt;rateRecordDate and Reset-&gt;observations-&gt;observationIdentifier-&gt;observationDate will differ if a Fallback rate is unavailable on the Rate Record Date, and the latest previous available rate is used as the observation.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? RateRecordDate { get; }
        
        /// <summary>
        /// Specifies the date on which the reset occurred.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate ResetDate { get; }
        
        /// <summary>
        /// Specifies the reset or fixing value. The fixing value could be a cash price, interest rate, or other value.
        /// </summary>
        public Price ResetValue { get; }
    }
    
    /// <summary>
    /// A data defining:  the parameters used to generate the reset dates schedule and associated fixing dates. The reset dates are the dates on which the new index value (which is observed on the fixing date) is applied for each period and on which the interest rate hence begins to accrue.
    /// </summary>
    public class ResetDates : AbstractRosettaModelObject<ResetDates>
    {
        private static readonly IRosettaMetaData<ResetDates> metaData = new ResetDatesMeta();
        
        [JsonConstructor]
        public ResetDates(ReferenceWithMetaCalculationPeriodDates? calculationPeriodDatesReference, AdjustableDate? finalFixingDate, RelativeDateOffset? fixingDates, InitialFixingDate? initialFixingDate, _MetaFields? meta, Offset? rateCutOffDaysOffset, BusinessDayAdjustments? resetDatesAdjustments, ResetFrequency? resetFrequency, Enums.ResetRelativeTo? resetRelativeTo)
        {
            CalculationPeriodDatesReference = calculationPeriodDatesReference;
            FinalFixingDate = finalFixingDate;
            FixingDates = fixingDates;
            InitialFixingDate = initialFixingDate;
            Meta = meta;
            RateCutOffDaysOffset = rateCutOffDaysOffset;
            ResetDatesAdjustments = resetDatesAdjustments;
            ResetFrequency = resetFrequency;
            ResetRelativeTo = resetRelativeTo;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ResetDates> MetaData => metaData;
        
        /// <summary>
        /// A pointer style reference to the associated calculation period dates component defined elsewhere in the document.
        /// </summary>
        public ReferenceWithMetaCalculationPeriodDates? CalculationPeriodDatesReference { get; }
        
        /// <summary>
        /// This attribute is not part of the FpML ResetDate, and has been added as part of the CDM to support the credit derivatives final fixing date.
        /// </summary>
        public AdjustableDate? FinalFixingDate { get; }
        
        /// <summary>
        /// The fixing dates are the dates on which the index values are observed. The fixing dates are specified by reference to the reset date through business days offset and an associated set of financial business centers. Normally these offset calculation rules will be those specified in the ISDA definition for the relevant floating rate index (ISDA&apos;s Floating Rate Option). However, non-standard offset calculation rules may apply for a trade if mutually agreed by the principal parties to the transaction.
        /// </summary>
        public RelativeDateOffset? FixingDates { get; }
        
        /// <summary>
        /// The initial fixing date.
        /// </summary>
        public InitialFixingDate? InitialFixingDate { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <summary>
        /// Specifies the number of business days before the period end date when the rate cut-off date is assumed to apply. The financial business centers associated with determining the rate cut-off date are those specified in the reset dates adjustments. The rate cut-off number of days must be a negative integer (a value of zero would imply no rate cut off applies in which case the rateCutOffDaysOffset element should not be included). The relevant rate for each reset date in the period from, and including, a rate cut-off date to, but excluding, the next applicable period end date (or, in the case of the last calculation period, the termination date) will (solely for purposes of calculating the floating amount payable on the next applicable payment date) be deemed to be the relevant rate in effect on that rate cut-off date. For example, if rate cut-off days for a daily averaging deal is -2 business days, then the refix rate applied on (period end date - 2 days) will also be applied as the reset on (period end date - 1 day), i.e. the actual number of reset dates remains the same but from the rate cut-off date until the period end date, the same refix rate is applied. Note that in the case of several calculation periods contributing to a single payment, the rate cut-off is assumed only to apply to the final calculation period contributing to that payment. The day type associated with the offset must imply a business days offset.
        /// </summary>
        public Offset? RateCutOffDaysOffset { get; }
        
        /// <summary>
        /// The definition of the business day convention and financial business centers used for adjusting the reset date if it would otherwise fall on a day that is not a business day in the specified business center.
        /// </summary>
        public BusinessDayAdjustments? ResetDatesAdjustments { get; }
        
        /// <summary>
        /// The frequency at which the reset dates occur. In the case of a weekly reset frequency, also specifies the day of the week that the reset occurs. If the reset frequency is greater than the calculation period frequency then this implies that more than one reset is established for each calculation period and some form of rate averaging is applicable.
        /// </summary>
        public ResetFrequency? ResetFrequency { get; }
        
        /// <summary>
        /// Specifies whether the reset dates are determined with respect to each adjusted calculation period start date or adjusted calculation period end date. If the reset frequency is specified as daily this element must not be included.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.ResetRelativeTo? ResetRelativeTo { get; }
    }
    
    /// <summary>
    /// A class defining the reset frequency. In the case of a weekly reset, also specifies the day of the week that the reset occurs. If the reset frequency is greater than the calculation period frequency the this implies that more or more reset dates is established for each calculation period and some form of rate averaging is applicable. The specific averaging method of calculation is specified in FloatingRateCalculation. In case the reset frequency is of value T (term), the period is defined by the swap/swapStream/calculationPerioDates/effectiveDate and the swap/swapStream/calculationPerioDates/terminationDate.
    /// </summary>
    public class ResetFrequency : AbstractRosettaModelObject<ResetFrequency>, IFrequency
    {
        private static readonly IRosettaMetaData<ResetFrequency> metaData = new ResetFrequencyMeta();
        
        [JsonConstructor]
        public ResetFrequency(Enums.WeeklyRollConvention? weeklyRollConvention, _MetaFields? meta, Enums.PeriodExtended period, int periodMultiplier)
        {
            WeeklyRollConvention = weeklyRollConvention;
            Meta = meta;
            Period = period;
            PeriodMultiplier = periodMultiplier;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ResetFrequency> MetaData => metaData;
        
        /// <summary>
        /// The day of the week on which a weekly reset date occurs. This element must be included if the reset frequency is defined as weekly and not otherwise.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.WeeklyRollConvention? WeeklyRollConvention { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.PeriodExtended Period { get; }
        
        /// <inheritdoc/>
        public int PeriodMultiplier { get; }
    }
    
    /// <summary>
    /// Defines the information needed to create a Reset Business Event. 
    /// </summary>
    public class ResetInstruction : AbstractRosettaModelObject<ResetInstruction>
    {
        private static readonly IRosettaMetaData<ResetInstruction> metaData = new ResetInstructionMeta();
        
        [JsonConstructor]
        public ResetInstruction(ReferenceWithMetaPayout payout, LocalDate? rateRecordDate, LocalDate resetDate)
        {
            Payout = payout;
            RateRecordDate = rateRecordDate;
            ResetDate = resetDate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ResetInstruction> MetaData => metaData;
        
        public ReferenceWithMetaPayout Payout { get; }
        
        /// <summary>
        /// Specifies the &apos;Rate Record Day&apos; for a Fallback rate.  Fallback rate fixing processes typically set the fixing rate in arrears, i.e., the Fallback Rate corresponding to a Rate Record Date is set at the end of the interest accural period.  When this applies, Reset-&gt;resetDate occurs at the end of the interest period, and the Reset-&gt;rateRecordDate occurs near the start of the interest period.  The Reset-&gt;rateRecordDate and Reset-&gt;observations-&gt;observationIdentifier-&gt;observationDate will differ if a Fallback rate is unavailable on the Rate Record Date, and the latest previous available rate is used as the observation.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? RateRecordDate { get; }
        
        /// <summary>
        /// Specifies the date on which the reset is occuring.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate ResetDate { get; }
    }
    
    /// <summary>
    /// Generic class to specify the quantity for different payout legs in a contractual product, when that quantity can vary across payout legs or across time. A resolvable quantity can always be resolved into a single quantity from the quantity notation which has a corresponding asset identifier. In addition to the base case, where quantity is directly specified as a number as part of the quantity notation, the other use cases are: (i) quantity based on some pre-defined schedule (eg amortising notional), (ii) quantity based on some pre-defined events (eg resetting cross-currency notional), or quantity set as reference to another quantity (eg equity notional as no. securities x price).
    /// </summary>
    public class ResolvablePriceQuantity : AbstractRosettaModelObject<ResolvablePriceQuantity>
    {
        private static readonly IRosettaMetaData<ResolvablePriceQuantity> metaData = new ResolvablePriceQuantityMeta();
        
        [JsonConstructor]
        public ResolvablePriceQuantity(FutureValueAmount? futureValueNotional, _MetaFields? meta, IEnumerable<ReferenceWithMetaPriceSchedule> priceSchedule, QuantityMultiplier? quantityMultiplier, ReferenceWithMetaResolvablePriceQuantity? quantityReference, ReferenceWithMetaNonNegativeQuantitySchedule? quantitySchedule, bool? reset, Quantity? resolvedQuantity)
        {
            FutureValueNotional = futureValueNotional;
            Meta = meta;
            PriceSchedule = priceSchedule;
            QuantityMultiplier = quantityMultiplier;
            QuantityReference = quantityReference;
            QuantitySchedule = quantitySchedule;
            Reset = reset;
            ResolvedQuantity = resolvedQuantity;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ResolvablePriceQuantity> MetaData => metaData;
        
        /// <summary>
        /// The future value notional is specific to BRL CDI swaps, and is specified alongside the notional amount. The value is calculated as follows: Future Value Notional = Notional Amount * (1 + Fixed Rate) ^ (Fixed Rate Day Count Fraction). The currency should always match that expressed in the notional schedule. The value date should match the adjusted termination date.
        /// </summary>
        public FutureValueAmount? FutureValueNotional { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <summary>
        /// A payout&apos;s price specified as a schedule, which may also contain a single value if that price is constant. There may be multiple prices specified for a single payout: e.g. a floating interest rate leg may specify a spread, a cap and/or floor and a multiplier. The price must be specified outside of the payout in a PriceQuantity object and only referenced inside the payout using an address.
        /// </summary>
        public IEnumerable<ReferenceWithMetaPriceSchedule> PriceSchedule { get; }
        
        /// <summary>
        /// Quantity multiplier is specified on top of a reference quantity and is used as a multiplying factor when resolving the quantity. A quantity multiplier can only exist when the resolvable quantity specifies a reference quantity.
        /// </summary>
        public QuantityMultiplier? QuantityMultiplier { get; }
        
        /// <summary>
        /// Reference quantity when resolvable quantity is defined as relative to another (resolvable) quantity. A resolvable quantity needs to contain either an absolute quantity or a reference to another (resolvable) quantity. This requirement is captured by a choice rule on the class.
        /// </summary>
        public ReferenceWithMetaResolvablePriceQuantity? QuantityReference { get; }
        
        /// <summary>
        /// A payout&apos;s quantity specified as a schedule, which may also contain a single value if that quantity is constant. There can only be a single quantity schedule applicable to a payout: e.g. the notional for an interest rate leg. The quantity must be specified outside of the payout in a PriceQuantity object and only referenced inside the payout using an address.
        /// </summary>
        public ReferenceWithMetaNonNegativeQuantitySchedule? QuantitySchedule { get; }
        
        /// <summary>
        /// Whether the quantity is resettable
        /// </summary>
        public bool? Reset { get; }
        
        /// <summary>
        /// A product&apos;s quantity as a single, non-negative amount.  When specified as part of a product definition, this quantity attribute would not be set.  Instead it is specified on the quantity notation along with an asset identifier matching this payout&apos;s asset identifier.  This allows the quantity to be resolved for a payout leg, which can then be specified here for convenience during data processing.  There needs to be at least one resolvable quantity across payout legs of a product to define an anchor that other payout quantities can refer to.  This attribute is ignored when mapping existing FpML messages.
        /// </summary>
        public Quantity? ResolvedQuantity { get; }
    }
    
    /// <summary>
    /// Describes the resource that contains the media representation of a business event (i.e used for stating the Publicly Available Information). For example, can describe a file or a URL that represents the event. This type is an extended version of a type defined by RIXML (www.rixml.org).  Rosetta restricts the FpML implementation by not providing the ability to associated a document in hexadecimalBinary or base64Binary until such time that actual use cases will come up.
    /// </summary>
    public class Resource : AbstractRosettaModelObject<Resource>
    {
        private static readonly IRosettaMetaData<Resource> metaData = new ResourceMeta();
        
        [JsonConstructor]
        public Resource(string? comments, FieldWithMetaString? language, ResourceLength? length, FieldWithMetaString? mimeType, string? name, FieldWithMetaString resourceId, FieldWithMetaResourceTypeEnum? resourceType, decimal? sizeInBytes, string? stringValue, string? url)
        {
            Comments = comments;
            Language = language;
            Length = length;
            MimeType = mimeType;
            Name = name;
            ResourceId = resourceId;
            ResourceType = resourceType;
            SizeInBytes = sizeInBytes;
            String = stringValue;
            Url = url;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Resource> MetaData => metaData;
        
        /// <summary>
        /// Any additional comments that are deemed necessary. For example, which software version is required to open the document? Or, how does this resource relate to the others for this event?
        /// </summary>
        public string? Comments { get; }
        
        /// <summary>
        /// Indicates the language of the resource, described using the ISO 639-2/T Code.
        /// </summary>
        public FieldWithMetaString? Language { get; }
        
        /// <summary>
        /// Indicates the length of the resource. For example, if the resource were a PDF file, the length would be in pages.
        /// </summary>
        public ResourceLength? Length { get; }
        
        /// <summary>
        /// Indicates the type of media used to store the content. mimeType is used to determine the software product(s) that can read the content. MIME Types are described in RFC 2046.
        /// </summary>
        public FieldWithMetaString? MimeType { get; }
        
        /// <summary>
        /// The name of the resource.  It is specified as a NormalizedString in FpML.
        /// </summary>
        public string? Name { get; }
        
        /// <summary>
        /// The unique identifier of the resource within the event. FpML specifies this element of type resourceIdScheme but with no specified value.
        /// </summary>
        public FieldWithMetaString ResourceId { get; }
        
        /// <summary>
        /// A description of the type of the resource, e.g. a confirmation.
        /// </summary>
        public FieldWithMetaResourceTypeEnum? ResourceType { get; }
        
        /// <summary>
        /// Indicates the size of the resource in bytes. It could be used by the end user to estimate the download time and storage needs.
        /// </summary>
        public decimal? SizeInBytes { get; }
        
        /// <summary>
        /// Provides extra information as string. In case the extra information is in XML format, a CDATA section must be placed around the source message to prevent its interpretation as XML content.
        /// </summary>
        public string? String { get; }
        
        /// <summary>
        /// Indicates where the resource can be found, as a URL that references the information on a web server accessible to the message recipient.
        /// </summary>
        public string? Url { get; }
    }
    
    /// <summary>
    /// A class to indicate the length of the resource.
    /// </summary>
    public class ResourceLength : AbstractRosettaModelObject<ResourceLength>
    {
        private static readonly IRosettaMetaData<ResourceLength> metaData = new ResourceLengthMeta();
        
        [JsonConstructor]
        public ResourceLength(Enums.LengthUnit lengthUnit, decimal lengthValue)
        {
            LengthUnit = lengthUnit;
            LengthValue = lengthValue;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ResourceLength> MetaData => metaData;
        
        /// <summary>
        /// The length unit of the resource. For example, pages (pdf, text documents) or time (audio, video files).
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.LengthUnit LengthUnit { get; }
        
        /// <summary>
        /// The length value of the resource.
        /// </summary>
        public decimal LengthValue { get; }
    }
    
    public class Restructuring : AbstractRosettaModelObject<Restructuring>
    {
        private static readonly IRosettaMetaData<Restructuring> metaData = new RestructuringMeta();
        
        [JsonConstructor]
        public Restructuring(bool applicable, bool? multipleCreditEventNotices, bool? multipleHolderObligation, FieldWithMetaRestructuringEnum? restructuringType)
        {
            Applicable = applicable;
            MultipleCreditEventNotices = multipleCreditEventNotices;
            MultipleHolderObligation = multipleHolderObligation;
            RestructuringType = restructuringType;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Restructuring> MetaData => metaData;
        
        /// <summary>
        /// Indicates whether the restructuring provision is applicable.
        /// </summary>
        public bool Applicable { get; }
        
        /// <summary>
        /// Presence of this element and value set to &apos;true&apos; indicates that Section 3.9 of the 2003 Credit Derivatives Definitions shall apply. Absence of this element indicates that Section 3.9 shall not apply. NOTE: Not allowed under ISDA Credit 1999.
        /// </summary>
        public bool? MultipleCreditEventNotices { get; }
        
        /// <summary>
        /// In relation to a restructuring credit event, unless multiple holder obligation is not specified restructurings are limited to multiple holder obligations. A multiple holder obligation means an obligation that is held by more than three holders that are not affiliates of each other and where at least two thirds of the holders must agree to the event that constitutes the restructuring credit event. ISDA 2003 Term: Multiple Holder Obligation.
        /// </summary>
        public bool? MultipleHolderObligation { get; }
        
        /// <summary>
        /// Specifies the type of restructuring that is applicable.
        /// </summary>
        public FieldWithMetaRestructuringEnum? RestructuringType { get; }
    }
    
    /// <summary>
    /// A class to specify the application of Interest Amount with respect the Return Amount.
    /// </summary>
    public class ReturnAmount : AbstractRosettaModelObject<ReturnAmount>
    {
        private static readonly IRosettaMetaData<ReturnAmount> metaData = new ReturnAmountMeta();
        
        [JsonConstructor]
        public ReturnAmount(string? customElection, bool? includesDefaultLanguage)
        {
            CustomElection = customElection;
            IncludesDefaultLanguage = includesDefaultLanguage;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ReturnAmount> MetaData => metaData;
        
        /// <summary>
        /// Custom election that might be specified by the parties to the agreement.
        /// </summary>
        public string? CustomElection { get; }
        
        /// <summary>
        /// Default language is included when True, and excluded when False.
        /// </summary>
        public bool? IncludesDefaultLanguage { get; }
    }
    
    /// <summary>
    /// Specifies the information required to create the return of a Security Finance Transaction.
    /// </summary>
    public class ReturnInstruction : AbstractRosettaModelObject<ReturnInstruction>
    {
        private static readonly IRosettaMetaData<ReturnInstruction> metaData = new ReturnInstructionMeta();
        
        [JsonConstructor]
        public ReturnInstruction(IEnumerable<Quantity> quantity)
        {
            Quantity = quantity;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ReturnInstruction> MetaData => metaData;
        
        /// <summary>
        /// Specifies the quantity of shares and cash to be returned in a partial return event.
        /// </summary>
        public IEnumerable<Quantity> Quantity { get; }
    }
    
    /// <summary>
    /// Specifies the type of return of a performance payout.
    /// </summary>
    public class ReturnTerms : AbstractRosettaModelObject<ReturnTerms>
    {
        private static readonly IRosettaMetaData<ReturnTerms> metaData = new ReturnTermsMeta();
        
        [JsonConstructor]
        public ReturnTerms(CorrelationReturnTerms? correlationReturnTerms, DividendReturnTerms? dividendReturnTerms, PriceReturnTerms? priceReturnTerms, VarianceReturnTerms? varianceReturnTerms, VolatilityReturnTerms? volatilityReturnTerms)
        {
            CorrelationReturnTerms = correlationReturnTerms;
            DividendReturnTerms = dividendReturnTerms;
            PriceReturnTerms = priceReturnTerms;
            VarianceReturnTerms = varianceReturnTerms;
            VolatilityReturnTerms = volatilityReturnTerms;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ReturnTerms> MetaData => metaData;
        
        /// <summary>
        /// Return terms based upon the observed correlation between the components of the underlying basket.
        /// </summary>
        public CorrelationReturnTerms? CorrelationReturnTerms { get; }
        
        /// <summary>
        /// Return terms based upon dividend payments associated to the underlier.
        /// </summary>
        public DividendReturnTerms? DividendReturnTerms { get; }
        
        /// <summary>
        /// Return terms based upon the underlier&apos;s observed price.
        /// </summary>
        public PriceReturnTerms? PriceReturnTerms { get; }
        
        /// <summary>
        /// Return terms based upon the observed variance of the underlier&apos;s price.
        /// </summary>
        public VarianceReturnTerms? VarianceReturnTerms { get; }
        
        /// <summary>
        /// Return terms based upon the observed volatility of the underlier&apos;s price.
        /// </summary>
        public VolatilityReturnTerms? VolatilityReturnTerms { get; }
    }
    
    /// <summary>
    /// Contains all common elements in variance, volatility and correlation return Terms.
    /// </summary>
    public class ReturnTermsBase : AbstractRosettaModelObject<ReturnTermsBase>, IReturnTermsBase
    {
        private static readonly IRosettaMetaData<ReturnTermsBase> metaData = new ReturnTermsBaseMeta();
        
        [JsonConstructor]
        public ReturnTermsBase(int? annualizationFactor, DividendApplicability? dividendApplicability, EquityUnderlierProvisions? equityUnderlierProvisions, int expectedN, decimal? initialLevel, Enums.DeterminationMethod? initialLevelSource, bool? meanAdjustment, string? performance, bool? sharePriceDividendAdjustment, ValuationTerms valuationTerms)
        {
            AnnualizationFactor = annualizationFactor;
            DividendApplicability = dividendApplicability;
            EquityUnderlierProvisions = equityUnderlierProvisions;
            ExpectedN = expectedN;
            InitialLevel = initialLevel;
            InitialLevelSource = initialLevelSource;
            MeanAdjustment = meanAdjustment;
            Performance = performance;
            SharePriceDividendAdjustment = sharePriceDividendAdjustment;
            ValuationTerms = valuationTerms;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ReturnTermsBase> MetaData => metaData;
        
        /// <inheritdoc/>
        public int? AnnualizationFactor { get; }
        
        /// <inheritdoc/>
        public DividendApplicability? DividendApplicability { get; }
        
        /// <inheritdoc/>
        public EquityUnderlierProvisions? EquityUnderlierProvisions { get; }
        
        /// <inheritdoc/>
        public int ExpectedN { get; }
        
        /// <inheritdoc/>
        public decimal? InitialLevel { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.DeterminationMethod? InitialLevelSource { get; }
        
        /// <inheritdoc/>
        public bool? MeanAdjustment { get; }
        
        /// <inheritdoc/>
        public string? Performance { get; }
        
        /// <inheritdoc/>
        public bool? SharePriceDividendAdjustment { get; }
        
        /// <inheritdoc/>
        public ValuationTerms ValuationTerms { get; }
    }
    
    /// <summary>
    /// Used in conjunction with an exchange-based pricing source. Identifies a way in which the futures contracts referenced will roll between periods. 
    /// </summary>
    public class RollFeature : AbstractRosettaModelObject<RollFeature>
    {
        private static readonly IRosettaMetaData<RollFeature> metaData = new RollFeatureMeta();
        
        [JsonConstructor]
        public RollFeature(Offset? deliveryDateRollConvention, Enums.RollSourceCalendar? rollSourceCalendar)
        {
            DeliveryDateRollConvention = deliveryDateRollConvention;
            RollSourceCalendar = rollSourceCalendar;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<RollFeature> MetaData => metaData;
        
        /// <summary>
        /// Specifies, for a Commodity Transaction that references a delivery date for a listed future, the day on which the specified future will roll to the next nearby month prior to the expiration of the referenced future. If the future will not roll at all - i.e. the price will be taken from the expiring contract, 0 should be specified here. If the future will roll to the next nearby on the last trading day - i.e. the price will be taken from the next nearby on the last trading day, then 1 should be specified and so on.
        /// </summary>
        public Offset? DeliveryDateRollConvention { get; }
        
        /// <summary>
        /// Used in conjunction with an exchange-based pricing source. Identifies a date source calendar from which the pricing dates and thus roll to the next contract will be based off (e.g. pricing is based on the NYMEX WTI First Nearby Futures Contract, if Future is chosen, the pricing will roll to the next futures contract on expiration, if ListedOption is chosen, the pricing will roll to the next futures contract on the Option expiration date which is three business days before the expiration of the NYMEX WTI futures contract.) Omitting this element will result in the default behavior expected with the pricing source described within the commodity element.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.RollSourceCalendar? RollSourceCalendar { get; }
    }
    
    /// <summary>
    /// Defines rounding rules and precision to be used in the rounding of a number.
    /// </summary>
    public class Rounding : AbstractRosettaModelObject<Rounding>
    {
        private static readonly IRosettaMetaData<Rounding> metaData = new RoundingMeta();
        
        [JsonConstructor]
        public Rounding(int? precision, Enums.RoundingDirection roundingDirection)
        {
            Precision = precision;
            RoundingDirection = roundingDirection;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Rounding> MetaData => metaData;
        
        /// <summary>
        /// Specifies the rounding precision in terms of a number of decimal places when the number is evaluated in decimal form (not percentage), e.g. 0.09876543 rounded to the nearest 5 decimal places is  0.0987654.
        /// </summary>
        public int? Precision { get; }
        
        /// <summary>
        /// Specifies the rounding rounding rule as up, down, or nearest.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.RoundingDirection RoundingDirection { get; }
    }
    
    /// <summary>
    /// A class defining a schedule of rates or amounts in terms of an initial value and then a series of step date and value pairs. On each step date the rate or amount changes to the new step value. The series of step date and value pairs are optional. If not specified, this implies that the initial value remains unchanged over time.
    /// </summary>
    public class Schedule : AbstractRosettaModelObject<Schedule>, ISchedule
    {
        private static readonly IRosettaMetaData<Schedule> metaData = new ScheduleMeta();
        
        [JsonConstructor]
        public Schedule(IEnumerable<DatedValue> datedValue, decimal value)
        {
            DatedValue = datedValue;
            Value = value;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Schedule> MetaData => metaData;
        
        /// <inheritdoc/>
        public IEnumerable<DatedValue> DatedValue { get; }
        
        /// <inheritdoc/>
        public decimal Value { get; }
    }
    
    /// <summary>
    /// A class that defines the commodity period of a schedule. The period contains a set of start and end dates, quantities, fixing, and pricing data.
    /// </summary>
    public class SchedulePeriod : AbstractRosettaModelObject<SchedulePeriod>
    {
        private static readonly IRosettaMetaData<SchedulePeriod> metaData = new SchedulePeriodMeta();
        
        [JsonConstructor]
        public SchedulePeriod(DateRange calculationPeriod, DateRange fixingPeriod, LocalDate paymentDate)
        {
            CalculationPeriod = calculationPeriod;
            FixingPeriod = fixingPeriod;
            PaymentDate = paymentDate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<SchedulePeriod> MetaData => metaData;
        
        /// <summary>
        /// Period for which the payment is generated.
        /// </summary>
        public DateRange CalculationPeriod { get; }
        
        /// <summary>
        /// Period over which the underlying price is observed.
        /// </summary>
        public DateRange FixingPeriod { get; }
        
        /// <summary>
        /// Adjusted payment date.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate PaymentDate { get; }
    }
    
    public class ScheduledTransfer : AbstractRosettaModelObject<ScheduledTransfer>
    {
        private static readonly IRosettaMetaData<ScheduledTransfer> metaData = new ScheduledTransferMeta();
        
        [JsonConstructor]
        public ScheduledTransfer(Enums.CorporateActionType? corporateActionTransferType, Enums.ScheduledTransfer transferType)
        {
            CorporateActionTransferType = corporateActionTransferType;
            TransferType = transferType;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ScheduledTransfer> MetaData => metaData;
        
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CorporateActionType? CorporateActionTransferType { get; }
        
        /// <summary>
        /// Specifies a transfer created from a scheduled or contingent event on a contract, e.g. Exercise, Performance, Credit Event
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.ScheduledTransfer TransferType { get; }
    }
    
    public class SchmeNm : AbstractRosettaModelObject<SchmeNm>
    {
        private static readonly IRosettaMetaData<SchmeNm> metaData = new SchmeNmMeta();
        
        [JsonConstructor]
        public SchmeNm(string prtry)
        {
            Prtry = prtry;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<SchmeNm> MetaData => metaData;
        
        public string Prtry { get; }
    }
    
    /// <summary>
    /// Identifies a security by referencing a product identifier and by specifying the sector.
    /// </summary>
    public class Security : AbstractRosettaModelObject<Security>, IProductBase
    {
        private static readonly IRosettaMetaData<Security> metaData = new SecurityMeta();
        
        [JsonConstructor]
        public Security(DebtType? debtType, EconomicTerms? economicTerms, Enums.EquityType? equityType, Enums.FundProductType? fundType, Enums.SecurityType securityType, IEnumerable<ReferenceWithMetaProductIdentifier> productIdentifier, IEnumerable<ProductTaxonomy> productTaxonomy)
        {
            DebtType = debtType;
            EconomicTerms = economicTerms;
            EquityType = equityType;
            FundType = fundType;
            SecurityType = securityType;
            ProductIdentifier = productIdentifier;
            ProductTaxonomy = productTaxonomy;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Security> MetaData => metaData;
        
        /// <summary>
        /// Identifies the type of debt and selected debt economics.
        /// </summary>
        public DebtType? DebtType { get; }
        
        /// <summary>
        /// The economic terms associated with a contractual product, i.e. the set of features that are price-forming.
        /// </summary>
        public EconomicTerms? EconomicTerms { get; }
        
        /// <summary>
        /// Identifies the type of equity.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.EquityType? EquityType { get; }
        
        /// <summary>
        /// Identifies the type of fund.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.FundProductType? FundType { get; }
        
        /// <summary>
        /// Identifies the type of security using an enumerated list.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.SecurityType SecurityType { get; }
        
        /// <inheritdoc/>
        public IEnumerable<ReferenceWithMetaProductIdentifier> ProductIdentifier { get; }
        
        /// <inheritdoc/>
        public IEnumerable<ProductTaxonomy> ProductTaxonomy { get; }
    }
    
    /// <summary>
    /// The set of elections which specify a Security Agremeent
    /// </summary>
    public class SecurityAgreementElections : AbstractRosettaModelObject<SecurityAgreementElections>
    {
        private static readonly IRosettaMetaData<SecurityAgreementElections> metaData = new SecurityAgreementElectionsMeta();
        
        [JsonConstructor]
        public SecurityAgreementElections()
        {
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<SecurityAgreementElections> MetaData => metaData;
        
    }
    
    /// <summary>
    ///  Terms defining a security leg in a securities financing transaction, which can either be the near leg or the far leg and is closely modelled onto the nearLeg and farLeg types in FpML
    /// </summary>
    public class SecurityLeg : AbstractRosettaModelObject<SecurityLeg>
    {
        private static readonly IRosettaMetaData<SecurityLeg> metaData = new SecurityLegMeta();
        
        [JsonConstructor]
        public SecurityLeg(BuyerSeller buyerSeller, AdjustableOrRelativeDate? deliveryDate, Enums.DeliveryMethod deliveryMethod, ExchangeRate? fxRate, _MetaFields? meta, Money? settlementAmount, string? settlementCurrency, AdjustableOrRelativeDate settlementDate)
        {
            BuyerSeller = buyerSeller;
            DeliveryDate = deliveryDate;
            DeliveryMethod = deliveryMethod;
            FxRate = fxRate;
            Meta = meta;
            SettlementAmount = settlementAmount;
            SettlementCurrency = settlementCurrency;
            SettlementDate = settlementDate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<SecurityLeg> MetaData => metaData;
        
        /// <summary>
        /// Whether the leg is a buyer or seller of security
        /// </summary>
        public BuyerSeller BuyerSeller { get; }
        
        /// <summary>
        /// Delivery Date for the transaction. Delivery Date can be populated when it is not equal to the Settlement Date.
        /// </summary>
        public AdjustableOrRelativeDate? DeliveryDate { get; }
        
        /// <summary>
        /// Specifies a delivery method for the security transaction.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.DeliveryMethod DeliveryMethod { get; }
        
        /// <summary>
        /// FX rate in case when cash settlement amount is in a different currency to the security.
        /// </summary>
        public ExchangeRate? FxRate { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <summary>
        /// Settlement amount for the security leg
        /// </summary>
        public Money? SettlementAmount { get; }
        
        /// <summary>
        /// Settlement Currency for use where the Settlement Amount cannot be known in advance.
        /// </summary>
        public string? SettlementCurrency { get; }
        
        /// <summary>
        /// Settlement or Payment Date for the security leg
        /// </summary>
        public AdjustableOrRelativeDate SettlementDate { get; }
    }
    
    /// <summary>
    /// Specifies the information required for inclusion in a securities lending billing invoice.
    /// </summary>
    public class SecurityLendingInvoice : AbstractRosettaModelObject<SecurityLendingInvoice>
    {
        private static readonly IRosettaMetaData<SecurityLendingInvoice> metaData = new SecurityLendingInvoiceMeta();
        
        [JsonConstructor]
        public SecurityLendingInvoice(LocalDate billingEndDate, IEnumerable<BillingRecord> billingRecord, LocalDate billingStartDate, IEnumerable<BillingSummary> billingSummary, _MetaFields? meta, Party receivingParty, Party sendingParty)
        {
            BillingEndDate = billingEndDate;
            BillingRecord = billingRecord;
            BillingStartDate = billingStartDate;
            BillingSummary = billingSummary;
            Meta = meta;
            ReceivingParty = receivingParty;
            SendingParty = sendingParty;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<SecurityLendingInvoice> MetaData => metaData;
        
        /// <summary>
        /// The ending date of the period described by this invoice
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate BillingEndDate { get; }
        
        /// <summary>
        /// The billing records contained within the invoice
        /// </summary>
        public IEnumerable<BillingRecord> BillingRecord { get; }
        
        /// <summary>
        /// The starting date of the period described by this invoice
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate BillingStartDate { get; }
        
        /// <summary>
        /// The billing summaries contained within the invoice
        /// </summary>
        public IEnumerable<BillingSummary> BillingSummary { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <summary>
        /// The party receiving the invoice
        /// </summary>
        public Party ReceivingParty { get; }
        
        /// <summary>
        /// The party issuing the invoice
        /// </summary>
        public Party SendingParty { get; }
    }
    
    /// <summary>
    ///  Security payout specification in case the product payout involves some form of security collateral, as in a securities financing transaction.
    /// </summary>
    public class SecurityPayout : AbstractRosettaModelObject<SecurityPayout>
    {
        private static readonly IRosettaMetaData<SecurityPayout> metaData = new SecurityPayoutMeta();
        
        [JsonConstructor]
        public SecurityPayout(InitialMargin? initialMargin, _MetaFields? meta, Enums.RepoDuration? repoDuration, IEnumerable<SecurityLeg> securityLeg, IEnumerable<SecurityValuation> securityValuation)
        {
            InitialMargin = initialMargin;
            Meta = meta;
            RepoDuration = repoDuration;
            SecurityLeg = securityLeg;
            SecurityValuation = securityValuation;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<SecurityPayout> MetaData => metaData;
        
        /// <summary>
        /// RepoDurationEnum.
        /// </summary>
        public InitialMargin? InitialMargin { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <summary>
        /// A duration code for the repo transaction. This defines a type of a repo transaction with fixed duration.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.RepoDuration? RepoDuration { get; }
        
        /// <summary>
        /// Each SecurityLeg represent a buy/sell at different dates, typically 1 near leg and 1 far leg in a securities financing transaction.
        /// </summary>
        public IEnumerable<SecurityLeg> SecurityLeg { get; }
        
        /// <summary>
        /// The underlying securities and their valuation for the security leg.
        /// </summary>
        public IEnumerable<SecurityValuation> SecurityValuation { get; }
    }
    
    /// <summary>
    ///  Terms defining the security valuation method as part of a security leg in a securities fianncing transaction and closely modelled onto the CollateralValuation type in FpML.
    /// </summary>
    public class SecurityValuation : AbstractRosettaModelObject<SecurityValuation>
    {
        private static readonly IRosettaMetaData<SecurityValuation> metaData = new SecurityValuationMeta();
        
        [JsonConstructor]
        public SecurityValuation(SecurityValuationModel securityValuationModel, Security underlier)
        {
            SecurityValuationModel = securityValuationModel;
            Underlier = underlier;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<SecurityValuation> MetaData => metaData;
        
        /// <summary>
        /// The security valuation model choice, based on either a nominal amount or a number of units.
        /// </summary>
        public SecurityValuationModel SecurityValuationModel { get; }
        
        /// <summary>
        /// The underlying security of the security leg.
        /// </summary>
        public Security Underlier { get; }
    }
    
    /// <summary>
    ///  The security valuation model choice, which can either be based on nominal amount as for a bond, or on the number of contract units as for equity.
    /// </summary>
    public class SecurityValuationModel : AbstractRosettaModelObject<SecurityValuationModel>
    {
        private static readonly IRosettaMetaData<SecurityValuationModel> metaData = new SecurityValuationModelMeta();
        
        [JsonConstructor]
        public SecurityValuationModel(BondValuationModel? bondValuationModel, UnitContractValuationModel? unitContractValuationModel)
        {
            BondValuationModel = bondValuationModel;
            UnitContractValuationModel = unitContractValuationModel;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<SecurityValuationModel> MetaData => metaData;
        
        /// <summary>
        /// The valuation model when the security is a bond.
        /// </summary>
        public BondValuationModel? BondValuationModel { get; }
        
        /// <summary>
        /// The valuation model when the security is a unit contract like equity.
        /// </summary>
        public UnitContractValuationModel? UnitContractValuationModel { get; }
    }
    
    public class Sellr : AbstractRosettaModelObject<Sellr>
    {
        private static readonly IRosettaMetaData<Sellr> metaData = new SellrMeta();
        
        [JsonConstructor]
        public Sellr(AcctOwnr acctOwnr)
        {
            AcctOwnr = acctOwnr;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Sellr> MetaData => metaData;
        
        public AcctOwnr AcctOwnr { get; }
    }
    
    /// <summary>
    /// A class to specify the Relevant Settled Entity Matrix.
    /// </summary>
    public class SettledEntityMatrix : AbstractRosettaModelObject<SettledEntityMatrix>
    {
        private static readonly IRosettaMetaData<SettledEntityMatrix> metaData = new SettledEntityMatrixMeta();
        
        [JsonConstructor]
        public SettledEntityMatrix(FieldWithMetaSettledEntityMatrixSourceEnum matrixSource, LocalDate? publicationDate)
        {
            MatrixSource = matrixSource;
            PublicationDate = publicationDate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<SettledEntityMatrix> MetaData => metaData;
        
        /// <summary>
        /// Relevant settled entity matrix source.
        /// </summary>
        public FieldWithMetaSettledEntityMatrixSourceEnum MatrixSource { get; }
        
        /// <summary>
        /// Specifies the publication date of the applicable version of the matrix. When this element is omitted, the Standard Terms Supplement defines rules for which version of the matrix is applicable.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? PublicationDate { get; }
    }
    
    /// <summary>
    /// A base class to be extended by the SettlementTerms class.
    /// </summary>
    public class SettlementBase : AbstractRosettaModelObject<SettlementBase>, ISettlementBase
    {
        private static readonly IRosettaMetaData<SettlementBase> metaData = new SettlementBaseMeta();
        
        [JsonConstructor]
        public SettlementBase(_MetaFields? meta, Enums.SettlementCentre? settlementCentre, FieldWithMetaString? settlementCurrency, SettlementDate? settlementDate, SettlementProvision? settlementProvision, Enums.SettlementType settlementType, Enums.StandardSettlementStyle? standardSettlementStyle, Enums.TransferSettlement? transferSettlementType)
        {
            Meta = meta;
            SettlementCentre = settlementCentre;
            SettlementCurrency = settlementCurrency;
            SettlementDate = settlementDate;
            SettlementProvision = settlementProvision;
            SettlementType = settlementType;
            StandardSettlementStyle = standardSettlementStyle;
            TransferSettlementType = transferSettlementType;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<SettlementBase> MetaData => metaData;
        
        public _MetaFields? Meta { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.SettlementCentre? SettlementCentre { get; }
        
        /// <inheritdoc/>
        public FieldWithMetaString? SettlementCurrency { get; }
        
        /// <inheritdoc/>
        public SettlementDate? SettlementDate { get; }
        
        /// <inheritdoc/>
        public SettlementProvision? SettlementProvision { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.SettlementType SettlementType { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.StandardSettlementStyle? StandardSettlementStyle { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.TransferSettlement? TransferSettlementType { get; }
    }
    
    /// <summary>
    /// A data defining the settlement date(s) for cash or physical settlement as either a set of explicit dates, together with applicable adjustments, or as a date relative to some other (anchor) date, or as any date in a range of contiguous business days. This data type provides a level of abstraction on top of the different legacy methods used to specify a settlement / payment date, which vary across product types, asset classes and delivery types.
    /// </summary>
    public class SettlementDate : AbstractRosettaModelObject<SettlementDate>
    {
        private static readonly IRosettaMetaData<SettlementDate> metaData = new SettlementDateMeta();
        
        [JsonConstructor]
        public SettlementDate(AdjustableDates? adjustableDates, AdjustableOrAdjustedOrRelativeDate? adjustableOrRelativeDate, BusinessDateRange? businessDateRange, int? cashSettlementBusinessDays, _MetaFields? meta, bool? paymentDelay, LocalDate? valueDate)
        {
            AdjustableDates = adjustableDates;
            AdjustableOrRelativeDate = adjustableOrRelativeDate;
            BusinessDateRange = businessDateRange;
            CashSettlementBusinessDays = cashSettlementBusinessDays;
            Meta = meta;
            PaymentDelay = paymentDelay;
            ValueDate = valueDate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<SettlementDate> MetaData => metaData;
        
        /// <summary>
        /// A series of dates that shall be subject to adjustment if they would otherwise fall on a day that is not a business day in the specified business centers, together with the convention for adjusting the date. This attributes was formerly part of &apos;CashSettlementPaymentDate&apos; as included into &apos;OptionCashSettlement&apos; (which is now merged into a unique &apos;CashSettlementTerms&apos; data type.
        /// </summary>
        public AdjustableDates? AdjustableDates { get; }
        
        /// <summary>
        /// A single settlement date subject to adjustment or specified as relative to another date (e.g. the trade date). This attribute was formerly part of &apos;SettlementTerms&apos;, which is now being harmonised to include a common &apos;SettlementDate&apos;, as inherited from &apos;SettlementBase&apos;.
        /// </summary>
        public AdjustableOrAdjustedOrRelativeDate? AdjustableOrRelativeDate { get; }
        
        /// <summary>
        /// A range of contiguous business days. This attribute is meant to be merged with the &apos;settlementDate&apos; at some future point once we refactor &apos;Date&apos; to use a single complex type across the model. This attributes was formerly part of &apos;CashSettlementPaymentDate&apos;, as included into &apos;OptionCashSettlement&apos; (which is now merged into a unique &apos;CashSettlementTerms&apos; data type.
        /// </summary>
        public BusinessDateRange? BusinessDateRange { get; }
        
        /// <summary>
        /// The number of business days used in the determination of the cash settlement payment date. If a cash settlement amount is specified, the cash settlement payment date will be this number of business days following the calculation of the final price. If a cash settlement amount is not specified, the cash settlement payment date will be this number of business days after all conditions to settlement are satisfied. ISDA 2003 Term: Cash Settlement Date. This attribute was formerly part of &apos;CashSettlementTerms&apos; as used for credit event settlement, which now includes a common &apos;SettlementDate&apos; attribute.
        /// </summary>
        public int? CashSettlementBusinessDays { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <summary>
        /// Applicable to CDS on MBS to specify whether payment delays are applicable to the fixed Amount. RMBS typically have a payment delay of 5 days between the coupon date of the reference obligation and the payment date of the synthetic swap. CMBS do not, on the other hand, with both payment dates being on the 25th of each month.
        /// </summary>
        public bool? PaymentDelay { get; }
        
        /// <summary>
        /// The settlement date for a forward settling product. For Foreign Exchange contracts, this represents a common settlement date between both currency legs. To specify different settlement dates for each currency leg, see the ForeignExchange class. This attribute was formerly part of &apos;SettlementTerms&apos;, which is now being harmonised to include a common &apos;SettlementDate&apos;, as inherited from &apos;SettlementBase&apos;.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? ValueDate { get; }
    }
    
    /// <summary>
    /// Defines the origin to the transfer as a reference for lineage purposes, whether it originated from trade level settlement terms or from payment terms on an economic payout.
    /// </summary>
    public class SettlementOrigin : AbstractRosettaModelObject<SettlementOrigin>
    {
        private static readonly IRosettaMetaData<SettlementOrigin> metaData = new SettlementOriginMeta();
        
        [JsonConstructor]
        public SettlementOrigin(ReferenceWithMetaAssetPayout? assetPayout, ReferenceWithMetaCommodityPayout? commodityPayout, ReferenceWithMetaCreditDefaultPayout? creditDefaultPayout, ReferenceWithMetaFixedPricePayout? fixedPricePayout, ReferenceWithMetaForwardPayout? forwardPayout, ReferenceWithMetaInterestRatePayout? interestRatePayout, ReferenceWithMetaOptionPayout? optionPayout, ReferenceWithMetaPerformancePayout? performancePayout, ReferenceWithMetaSettlementTerms? settlementTerms)
        {
            AssetPayout = assetPayout;
            CommodityPayout = commodityPayout;
            CreditDefaultPayout = creditDefaultPayout;
            FixedPricePayout = fixedPricePayout;
            ForwardPayout = forwardPayout;
            InterestRatePayout = interestRatePayout;
            OptionPayout = optionPayout;
            PerformancePayout = performancePayout;
            SettlementTerms = settlementTerms;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<SettlementOrigin> MetaData => metaData;
        
        /// <summary>
        /// Represents a reference to an Asset Payout.
        /// </summary>
        public ReferenceWithMetaAssetPayout? AssetPayout { get; }
        
        /// <summary>
        /// Represents a reference to an Commodity Payout.
        /// </summary>
        public ReferenceWithMetaCommodityPayout? CommodityPayout { get; }
        
        /// <summary>
        /// Represents a reference to a Credit Default Payout.
        /// </summary>
        public ReferenceWithMetaCreditDefaultPayout? CreditDefaultPayout { get; }
        
        /// <summary>
        /// Represents a reference to a Fixed Price Payout
        /// </summary>
        public ReferenceWithMetaFixedPricePayout? FixedPricePayout { get; }
        
        /// <summary>
        /// Represents a reference to a Forward Payout.
        /// </summary>
        public ReferenceWithMetaForwardPayout? ForwardPayout { get; }
        
        /// <summary>
        /// Represents a reference to an Interest Rate Payout.
        /// </summary>
        public ReferenceWithMetaInterestRatePayout? InterestRatePayout { get; }
        
        /// <summary>
        /// Represents a reference to an Option Payout.
        /// </summary>
        public ReferenceWithMetaOptionPayout? OptionPayout { get; }
        
        /// <summary>
        /// Represents a reference to a Performance Payout.
        /// </summary>
        public ReferenceWithMetaPerformancePayout? PerformancePayout { get; }
        
        /// <summary>
        /// Represents a reference to settlement terms, which may have been specified at execution.
        /// </summary>
        public ReferenceWithMetaSettlementTerms? SettlementTerms { get; }
    }
    
    /// <summary>
    /// Defines parameters that regulate a settlement, for instance whether this settlement should be netted with other ones or broken-down into smaller amounts.
    /// </summary>
    public class SettlementProvision : AbstractRosettaModelObject<SettlementProvision>
    {
        private static readonly IRosettaMetaData<SettlementProvision> metaData = new SettlementProvisionMeta();
        
        [JsonConstructor]
        public SettlementProvision(ShapingProvision? shapingProvisions)
        {
            ShapingProvisions = shapingProvisions;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<SettlementProvision> MetaData => metaData;
        
        /// <summary>
        /// Defines the parameters that are necessary to &apos;shape&apos; a settlement, i.e. break it down into smaller amounts.
        /// </summary>
        public ShapingProvision? ShapingProvisions { get; }
    }
    
    /// <summary>
    /// Defines the settlement rate option to use for fixing in case of cash settlement. Currently only applicable to foreign exchange fixing in case of cross-currency settlement.
    /// </summary>
    public class SettlementRateOption : AbstractRosettaModelObject<SettlementRateOption>
    {
        private static readonly IRosettaMetaData<SettlementRateOption> metaData = new SettlementRateOptionMeta();
        
        [JsonConstructor]
        public SettlementRateOption(PriceSourceDisruption? priceSourceDisruption, FieldWithMetaSettlementRateOptionEnum settlementRateOption)
        {
            PriceSourceDisruption = priceSourceDisruption;
            SettlementRateOptionValue = settlementRateOption;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<SettlementRateOption> MetaData => metaData;
        
        /// <summary>
        /// An attribute defining the parameters to get a new quote when a settlement rate option is disrupted.
        /// </summary>
        public PriceSourceDisruption? PriceSourceDisruption { get; }
        
        /// <summary>
        /// The rate source for the conversion to the settlement currency. This source is specified through a scheme that reflects the terms of the Annex A to the 1998 FX and Currency Option Definitions.
        /// </summary>
        [JsonProperty(PropertyName = "settlementRateOption")]
        public FieldWithMetaSettlementRateOptionEnum SettlementRateOptionValue { get; }
    }
    
    /// <summary>
    /// Specifies the settlement terms, which can either be cash, physical, or fx-based cash-settlement. This class can be used for the settlement of options and forwards, cash transactions (e.g. securities or foreign exchange), or in case of credit event.
    /// </summary>
    public class SettlementTerms : AbstractRosettaModelObject<SettlementTerms>, ISettlementBase
    {
        private static readonly IRosettaMetaData<SettlementTerms> metaData = new SettlementTermsMeta();
        
        [JsonConstructor]
        public SettlementTerms(IEnumerable<CashSettlementTerms> cashSettlementTerms, PhysicalSettlementTerms? physicalSettlementTerms, _MetaFields? meta, Enums.SettlementCentre? settlementCentre, FieldWithMetaString? settlementCurrency, SettlementDate? settlementDate, SettlementProvision? settlementProvision, Enums.SettlementType settlementType, Enums.StandardSettlementStyle? standardSettlementStyle, Enums.TransferSettlement? transferSettlementType)
        {
            CashSettlementTerms = cashSettlementTerms;
            PhysicalSettlementTerms = physicalSettlementTerms;
            Meta = meta;
            SettlementCentre = settlementCentre;
            SettlementCurrency = settlementCurrency;
            SettlementDate = settlementDate;
            SettlementProvision = settlementProvision;
            SettlementType = settlementType;
            StandardSettlementStyle = standardSettlementStyle;
            TransferSettlementType = transferSettlementType;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<SettlementTerms> MetaData => metaData;
        
        /// <summary>
        /// Specifies the parameters associated with the cash settlement procedure.
        /// </summary>
        public IEnumerable<CashSettlementTerms> CashSettlementTerms { get; }
        
        /// <summary>
        /// Specifies the physical settlement terms which apply to the transaction.
        /// </summary>
        public PhysicalSettlementTerms? PhysicalSettlementTerms { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.SettlementCentre? SettlementCentre { get; }
        
        /// <inheritdoc/>
        public FieldWithMetaString? SettlementCurrency { get; }
        
        /// <inheritdoc/>
        public SettlementDate? SettlementDate { get; }
        
        /// <inheritdoc/>
        public SettlementProvision? SettlementProvision { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.SettlementType SettlementType { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.StandardSettlementStyle? StandardSettlementStyle { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.TransferSettlement? TransferSettlementType { get; }
    }
    
    /// <summary>
    /// Defines the applicable settlement limits that may require a settlement to be &apos;shaped&apos;, i.e. broken-down into smaller amounts.
    /// </summary>
    public class ShapingProvision : AbstractRosettaModelObject<ShapingProvision>
    {
        private static readonly IRosettaMetaData<ShapingProvision> metaData = new ShapingProvisionMeta();
        
        [JsonConstructor]
        public ShapingProvision(IEnumerable<Money> shapeSchedule)
        {
            ShapeSchedule = shapeSchedule;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ShapingProvision> MetaData => metaData;
        
        /// <summary>
        /// Defines applicable settlement limits in each currency.
        /// </summary>
        public IEnumerable<Money> ShapeSchedule { get; }
    }
    
    /// <summary>
    /// A class to specify the number of business days after satisfaction of all conditions to settlement.
    /// </summary>
    public class SingleValuationDate : AbstractRosettaModelObject<SingleValuationDate>, ISingleValuationDate
    {
        private static readonly IRosettaMetaData<SingleValuationDate> metaData = new SingleValuationDateMeta();
        
        [JsonConstructor]
        public SingleValuationDate(int? businessDays)
        {
            BusinessDays = businessDays;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<SingleValuationDate> MetaData => metaData;
        
        /// <inheritdoc/>
        public int? BusinessDays { get; }
    }
    
    public class Sngl : AbstractRosettaModelObject<Sngl>
    {
        private static readonly IRosettaMetaData<Sngl> metaData = new SnglMeta();
        
        [JsonConstructor]
        public Sngl(Indx indx, string isin)
        {
            Indx = indx;
            Isin = isin;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Sngl> MetaData => metaData;
        
        public Indx Indx { get; }
        
        public string Isin { get; }
    }
    
    /// <summary>
    /// Represents a class to allow specification of different types of special purpose vehicle (SPV) collateral.
    /// </summary>
    public class SpecialPurposeVehicleIssuerType : AbstractRosettaModelObject<SpecialPurposeVehicleIssuerType>
    {
        private static readonly IRosettaMetaData<SpecialPurposeVehicleIssuerType> metaData = new SpecialPurposeVehicleIssuerTypeMeta();
        
        [JsonConstructor]
        public SpecialPurposeVehicleIssuerType(Enums.CreditRisk? creditRisk)
        {
            CreditRisk = creditRisk;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<SpecialPurposeVehicleIssuerType> MetaData => metaData;
        
        /// <summary>
        /// Indicates tranched or untranched credit risk.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CreditRisk? CreditRisk { get; }
    }
    
    public class SpecifiedCurrency : AbstractRosettaModelObject<SpecifiedCurrency>
    {
        private static readonly IRosettaMetaData<SpecifiedCurrency> metaData = new SpecifiedCurrencyMeta();
        
        [JsonConstructor]
        public SpecifiedCurrency(bool applicable, FieldWithMetaString? currency)
        {
            Applicable = applicable;
            Currency = currency;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<SpecifiedCurrency> MetaData => metaData;
        
        /// <summary>
        /// Indicates whether the specified currency provision is applicable.
        /// </summary>
        public bool Applicable { get; }
        
        /// <summary>
        /// The currency in which the specified currency is denominated. The list of valid currencies is not presently positioned as an enumeration as part of the CDM because that scope is limited to the values specified by ISDA and FpML. As a result, implementers have to make reference to the relevant standard, such as the ISO 4217 standard for currency codes.
        /// </summary>
        public FieldWithMetaString? Currency { get; }
    }
    
    /// <summary>
    /// Specifies instructions for a split, consisting of a breakdown of instructions to be applied to each branch of the split. This instruction can be used to duplicate a trade, as in a clearing scenario, or to split a trade into smaller quantities (in which case each breakdown instruction needs to include a quantity change), as in an allocation.
    /// </summary>
    public class SplitInstruction : AbstractRosettaModelObject<SplitInstruction>
    {
        private static readonly IRosettaMetaData<SplitInstruction> metaData = new SplitInstructionMeta();
        
        [JsonConstructor]
        public SplitInstruction(IEnumerable<PrimitiveInstruction> breakdown)
        {
            Breakdown = breakdown;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<SplitInstruction> MetaData => metaData;
        
        /// <summary>
        /// Each split breakdown specifies the set of primitive instructions to be applied to a single branch of that split. N split breakdowns result in N output trades, which include the original trade. Instructions for how to handle the original trade (e.g. if it must be closed) must be specified in one of the breakdowns.
        /// </summary>
        public IEnumerable<PrimitiveInstruction> Breakdown { get; }
    }
    
    /// <summary>
    /// Adds an optional spread type element to the Schedule to identify a long or short spread value.
    /// </summary>
    public class SpreadSchedule : AbstractRosettaModelObject<SpreadSchedule>, IRateSchedule
    {
        private static readonly IRosettaMetaData<SpreadSchedule> metaData = new SpreadScheduleMeta();
        
        [JsonConstructor]
        public SpreadSchedule(FieldWithMetaSpreadScheduleTypeEnum? spreadScheduleType, ReferenceWithMetaPriceSchedule price)
        {
            SpreadScheduleType = spreadScheduleType;
            Price = price;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<SpreadSchedule> MetaData => metaData;
        
        /// <summary>
        /// An element which purpose is to identify a long or short spread value.
        /// </summary>
        public FieldWithMetaSpreadScheduleTypeEnum? SpreadScheduleType { get; }
        
        /// <inheritdoc/>
        public ReferenceWithMetaPriceSchedule Price { get; }
    }
    
    /// <summary>
    /// Defines the state of a trade at a point in the Trade&apos;s life cycle. Trades have many state dimensions, all of which are represented here. For example, states useful for position keeping are represented alongside those needed for regulatory reporting.
    /// </summary>
    public class State : AbstractRosettaModelObject<State>
    {
        private static readonly IRosettaMetaData<State> metaData = new StateMeta();
        
        [JsonConstructor]
        public State(ClosedState? closedState, Enums.PositionStatus? positionState)
        {
            ClosedState = closedState;
            PositionState = positionState;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<State> MetaData => metaData;
        
        /// <summary>
        /// Represents the qualification of what led to the trade&apos;s closure alongside the dates on which this closure took effect.
        /// </summary>
        public ClosedState? ClosedState { get; }
        
        /// <summary>
        /// Identifies the state of the position, to distinguish if just executed, formed, already settled, closed, etc.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.PositionStatus? PositionState { get; }
    }
    
    /// <summary>
    /// Data required to perform a stock split business event.
    /// </summary>
    public class StockSplitInstruction : AbstractRosettaModelObject<StockSplitInstruction>
    {
        private static readonly IRosettaMetaData<StockSplitInstruction> metaData = new StockSplitInstructionMeta();
        
        [JsonConstructor]
        public StockSplitInstruction(decimal adjustmentRatio, LocalDate effectiveDate)
        {
            AdjustmentRatio = adjustmentRatio;
            EffectiveDate = effectiveDate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<StockSplitInstruction> MetaData => metaData;
        
        /// <summary>
        /// The number that denotes the cumulative quantity of post-split shares issued to shareholders versus the quantity of pre-split shares previously issued to shareholders.  This number will be multiplied by existing shares in an equity derivative contract or other positions to determine the post-split number of shares.  With regard to any reference to price, the pre-split reference price will be divided by this number to determine the post-split reference price.
        /// </summary>
        public decimal AdjustmentRatio { get; }
        
        /// <summary>
        /// The effective date of the stock split, also known as the ex-date. This is the date on which the additional shares are paid to the shareholders, or in the case of a reverse stock split, the number shares held by each shareholder is proportionally reduced.  Equity derivative transactions can be amended in firms&apos; internal systems on such date.   In most markets, the listed stock price is reduced (or increased for a reverse stock split) to account for the split on the same date, but in some markets the price adjustment occurs on a later date.  In either case, equity derivative transactions should be amended on the date that the stocks are paid to the shareholders (or consolidated).
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate EffectiveDate { get; }
    }
    
    /// <summary>
    /// A class for defining option strategy features.
    /// </summary>
    public class StrategyFeature : AbstractRosettaModelObject<StrategyFeature>
    {
        private static readonly IRosettaMetaData<StrategyFeature> metaData = new StrategyFeatureMeta();
        
        [JsonConstructor]
        public StrategyFeature(CalendarSpread? calendarSpread, StrikeSpread? strikeSpread)
        {
            CalendarSpread = calendarSpread;
            StrikeSpread = strikeSpread;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<StrategyFeature> MetaData => metaData;
        
        /// <summary>
        /// Definition of the later expiration date in a calendar spread.
        /// </summary>
        public CalendarSpread? CalendarSpread { get; }
        
        /// <summary>
        /// Definition of the upper strike in a strike spread.
        /// </summary>
        public StrikeSpread? StrikeSpread { get; }
    }
    
    /// <summary>
    /// A class describing a single cap or floor rate.
    /// </summary>
    public class Strike : AbstractRosettaModelObject<Strike>
    {
        private static readonly IRosettaMetaData<Strike> metaData = new StrikeMeta();
        
        [JsonConstructor]
        public Strike(Enums.PayerReceiver? buyer, _MetaFields? meta, Enums.PayerReceiver? seller, decimal strikeRate)
        {
            Buyer = buyer;
            Meta = meta;
            Seller = seller;
            StrikeRate = strikeRate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Strike> MetaData => metaData;
        
        /// <summary>
        /// The buyer of the option.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.PayerReceiver? Buyer { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <summary>
        /// The party that has sold.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.PayerReceiver? Seller { get; }
        
        /// <summary>
        /// The rate for a cap or floor.
        /// </summary>
        public decimal StrikeRate { get; }
    }
    
    /// <summary>
    /// A class describing a schedule of cap or floor rates.
    /// </summary>
    public class StrikeSchedule : AbstractRosettaModelObject<StrikeSchedule>, IRateSchedule
    {
        private static readonly IRosettaMetaData<StrikeSchedule> metaData = new StrikeScheduleMeta();
        
        [JsonConstructor]
        public StrikeSchedule(Enums.PayerReceiver? buyer, Enums.PayerReceiver? seller, ReferenceWithMetaPriceSchedule price)
        {
            Buyer = buyer;
            Seller = seller;
            Price = price;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<StrikeSchedule> MetaData => metaData;
        
        /// <summary>
        /// The buyer of the option.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.PayerReceiver? Buyer { get; }
        
        /// <summary>
        /// The party that has sold.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.PayerReceiver? Seller { get; }
        
        /// <inheritdoc/>
        public ReferenceWithMetaPriceSchedule Price { get; }
    }
    
    /// <summary>
    /// A class for defining a strike spread feature.
    /// </summary>
    public class StrikeSpread : AbstractRosettaModelObject<StrikeSpread>
    {
        private static readonly IRosettaMetaData<StrikeSpread> metaData = new StrikeSpreadMeta();
        
        [JsonConstructor]
        public StrikeSpread(OptionStrike upperStrike, decimal upperStrikeNumberOfOptions)
        {
            UpperStrike = upperStrike;
            UpperStrikeNumberOfOptions = upperStrikeNumberOfOptions;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<StrikeSpread> MetaData => metaData;
        
        /// <summary>
        /// Upper strike in a strike spread.
        /// </summary>
        public OptionStrike UpperStrike { get; }
        
        /// <summary>
        /// Number of options at the upper strike price in a strike spread.
        /// </summary>
        public decimal UpperStrikeNumberOfOptions { get; }
    }
    
    /// <summary>
    /// A data defining:  how the initial or final stub calculation period amounts is calculated. For example, the rate to be applied to the initial or final stub calculation period may be the linear interpolation of two different tenors for the floating rate index specified in the calculation period amount component, e.g. A two month stub period may used the linear interpolation of a one month and three month floating rate. The different rate tenors would be specified in this component. Note that a maximum of two rate tenors can be specified. If a stub period uses a single index tenor and this is the same as that specified in the calculation period amount component then the initial stub or final stub component, as the case may be, must not be included.
    /// </summary>
    public class StubCalculationPeriodAmount : AbstractRosettaModelObject<StubCalculationPeriodAmount>
    {
        private static readonly IRosettaMetaData<StubCalculationPeriodAmount> metaData = new StubCalculationPeriodAmountMeta();
        
        [JsonConstructor]
        public StubCalculationPeriodAmount(ReferenceWithMetaCalculationPeriodDates calculationPeriodDatesReference, StubValue? finalStub, StubValue? initialStub)
        {
            CalculationPeriodDatesReference = calculationPeriodDatesReference;
            FinalStub = finalStub;
            InitialStub = initialStub;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<StubCalculationPeriodAmount> MetaData => metaData;
        
        /// <summary>
        /// A pointer style reference to the associated calculation period dates component defined elsewhere in the document.
        /// </summary>
        public ReferenceWithMetaCalculationPeriodDates CalculationPeriodDatesReference { get; }
        
        /// <summary>
        /// Specifies how the final stub amount is calculated. A single floating rate tenor different to that used for the regular part of the calculation periods schedule may be specified, or two floating tenors may be specified. If two floating rate tenors are specified then Linear Interpolation (in accordance with the 2000 ISDA Definitions, Section 8.3. Interpolation) is assumed to apply. Alternatively, an actual known stub rate or stub amount may be specified.
        /// </summary>
        public StubValue? FinalStub { get; }
        
        /// <summary>
        /// Specifies how the initial stub amount is calculated. A single floating rate tenor different to that used for the regular part of the calculation periods schedule may be specified, or two floating tenors may be specified. If two floating rate tenors are specified then Linear Interpolation (in accordance with the 2000 ISDA Definitions, Section 8.3. Interpolation) is assumed to apply. Alternatively, an actual known stub rate or stub amount may be specified.
        /// </summary>
        public StubValue? InitialStub { get; }
    }
    
    /// <summary>
    /// A class defining a floating rate.
    /// </summary>
    public class StubFloatingRate : AbstractRosettaModelObject<StubFloatingRate>
    {
        private static readonly IRosettaMetaData<StubFloatingRate> metaData = new StubFloatingRateMeta();
        
        [JsonConstructor]
        public StubFloatingRate(IEnumerable<StrikeSchedule> capRateSchedule, Enums.FloatingRateIndex floatingRateIndex, Schedule? floatingRateMultiplierSchedule, IEnumerable<StrikeSchedule> floorRateSchedule, Period? indexTenor, Enums.RateTreatment? rateTreatment, IEnumerable<SpreadSchedule> spreadSchedule)
        {
            CapRateSchedule = capRateSchedule;
            FloatingRateIndex = floatingRateIndex;
            FloatingRateMultiplierSchedule = floatingRateMultiplierSchedule;
            FloorRateSchedule = floorRateSchedule;
            IndexTenor = indexTenor;
            RateTreatment = rateTreatment;
            SpreadSchedule = spreadSchedule;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<StubFloatingRate> MetaData => metaData;
        
        /// <summary>
        /// The cap rate or cap rate schedule, if any, which applies to the floating rate. The cap rate (strike) is only required where the floating rate on a swap stream is capped at a certain level. A cap rate schedule is expressed as explicit cap rates and dates and the step dates may be subject to adjustment in accordance with any adjustments specified in calculationPeriodDatesAdjustments. The cap rate is assumed to be exclusive of any spread and is a per annum rate, expressed as a decimal. A cap rate of 5% would be represented as 0.05.
        /// </summary>
        public IEnumerable<StrikeSchedule> CapRateSchedule { get; }
        
        /// <summary>
        /// The floating rate index.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.FloatingRateIndex FloatingRateIndex { get; }
        
        /// <summary>
        /// A rate multiplier or multiplier schedule to apply to the floating rate. A multiplier schedule is expressed as explicit multipliers and dates. In the case of a schedule, the step dates may be subject to adjustment in accordance with any adjustments specified in the calculationPeriodDatesAdjustments. The multiplier can be a positive or negative decimal. This element should only be included if the multiplier is not equal to 1 (one) for the term of the stream.
        /// </summary>
        public Schedule? FloatingRateMultiplierSchedule { get; }
        
        /// <summary>
        /// The floor rate or floor rate schedule, if any, which applies to the floating rate. The floor rate (strike) is only required where the floating rate on a swap stream is floored at a certain strike level. A floor rate schedule is expressed as explicit floor rates and dates and the step dates may be subject to adjustment in accordance with any adjustments specified in calculationPeriodDatesAdjustments. The floor rate is assumed to be exclusive of any spread and is a per annum rate, expressed as a decimal. A floor rate of 5% would be represented as 0.05.
        /// </summary>
        public IEnumerable<StrikeSchedule> FloorRateSchedule { get; }
        
        /// <summary>
        /// The ISDA Designated Maturity, i.e. the tenor of the floating rate.
        /// </summary>
        public Period? IndexTenor { get; }
        
        /// <summary>
        /// The specification of any rate conversion which needs to be applied to the observed rate before being used in any calculations. The two common conversions are for securities quoted on a bank discount basis which will need to be converted to either a Money Market Yield or Bond Equivalent Yield. See the Annex to the 2000 ISDA Definitions, Section 7.3. Certain General Definitions Relating to Floating Rate Options, paragraphs (g) and (h) for definitions of these terms.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.RateTreatment? RateTreatment { get; }
        
        /// <summary>
        /// The ISDA Spread or a Spread schedule expressed as explicit spreads and dates. In the case of a schedule, the step dates may be subject to adjustment in accordance with any adjustments specified in calculationPeriodDatesAdjustments. The spread is a per annum rate, expressed as a decimal. For purposes of determining a calculation period amount, if positive the spread will be added to the floating rate and if negative the spread will be subtracted from the floating rate. A positive 10 basis point (0.1%) spread would be represented as 0.001.
        /// </summary>
        public IEnumerable<SpreadSchedule> SpreadSchedule { get; }
    }
    
    /// <summary>
    ///  A class defining how the initial or final stub calculation period amounts is calculated. For example, the rate to be applied to the initial or final stub calculation period may be the linear interpolation of two different tenors for the floating rate index specified in the calculation period amount component, e.g. A two month stub period may used the linear interpolation of a one month and three month floating rate. The different rate tenors would be specified in this component. Note that a maximum of two rate tenors can be specified. If a stub period uses a single index tenor and this is the same as that specified in the calculation period amount component then the initial stub or final stub component, as the case may be, must not be included.
    /// </summary>
    public class StubPeriod : AbstractRosettaModelObject<StubPeriod>
    {
        private static readonly IRosettaMetaData<StubPeriod> metaData = new StubPeriodMeta();
        
        [JsonConstructor]
        public StubPeriod(ReferenceWithMetaCalculationPeriodDates calculationPeriodDatesReference, StubValue? finalStub, StubValue? initialStub)
        {
            CalculationPeriodDatesReference = calculationPeriodDatesReference;
            FinalStub = finalStub;
            InitialStub = initialStub;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<StubPeriod> MetaData => metaData;
        
        /// <summary>
        /// A pointer style reference to the associated calculation period dates component defined elsewhere in the document.
        /// </summary>
        public ReferenceWithMetaCalculationPeriodDates CalculationPeriodDatesReference { get; }
        
        /// <summary>
        /// Specifies how the final stub amount is calculated. A single floating rate tenor different to that used for the regular part of the calculation periods schedule may be specified, or two floating tenors may be specified. If two floating rate tenors are specified then Linear Interpolation (in accordance with the 2000 ISDA Definitions, Section 8.3. Interpolation) is assumed to apply. Alternatively, an actual known stub rate or stub amount may be specified.
        /// </summary>
        public StubValue? FinalStub { get; }
        
        /// <summary>
        /// Specifies how the initial stub amount is calculated. A single floating rate tenor different to that used for the regular part of the calculation periods schedule may be specified, or two floating tenors may be specified. If two floating rate tenors are specified then Linear Interpolation (in accordance with the 2000 ISDA Definitions, Section 8.3. Interpolation) is assumed to apply. Alternatively, an actual known stub rate or stub amount may be specified.
        /// </summary>
        public StubValue? InitialStub { get; }
    }
    
    /// <summary>
    /// A type defining how a stub calculation period amount is calculated. A single floating rate tenor different to that used for the regular part of the calculation periods schedule may be specified, or two floating rate tenors many be specified. If two floating rate tenors are specified then Linear Interpolation (in accordance with the 2000 ISDA Definitions, Section 8.3 Interpolation) is assumed to apply. Alternatively, an actual known stub rate or stub amount may be specified.
    /// </summary>
    public class StubValue : AbstractRosettaModelObject<StubValue>
    {
        private static readonly IRosettaMetaData<StubValue> metaData = new StubValueMeta();
        
        [JsonConstructor]
        public StubValue(IEnumerable<StubFloatingRate> floatingRate, Money? stubAmount, decimal? stubRate)
        {
            FloatingRate = floatingRate;
            StubAmount = stubAmount;
            StubRate = stubRate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<StubValue> MetaData => metaData;
        
        /// <summary>
        /// The rates to be applied to the initial or final stub may be the linear interpolation of two different rates. While the majority of the time, the rate indices will be the same as that specified in the stream and only the tenor itself will be different, it is possible to specift two different rates. For example, a 2 month stub period may use the linear interpolation of a 1 month and 3 month rate. The different rates would be specified in this component. Note that a maximum of two rates can be specified. If a stub period uses the same floating rate index, including tenor, as the regular calculation periods then this should not be specified again within this component, i.e. the stub calculation period amount component may not need to be specified even if there is an initial or final stub period. If a stub period uses a different floating rate index compared to the regular calculation periods then this should be specified within this component. If specified here, they are likely to have id attributes, allowing them to be referenced from within the cashflows component.
        /// </summary>
        public IEnumerable<StubFloatingRate> FloatingRate { get; }
        
        /// <summary>
        /// An actual amount to apply for the initial or final stub period may have been agreed between the two parties. If an actual stub amount has been agreed then it would be included in this component.
        /// </summary>
        public Money? StubAmount { get; }
        
        /// <summary>
        /// An actual rate to apply for the initial or final stub period may have been agreed between the principal parties (in a similar way to how an initial rate may have been agreed for the first regular period). If an actual stub rate has been agreed then it would be included in this component. It will be a per annum rate, expressed as a decimal. A stub rate of 5% would be represented as 0.05.
        /// </summary>
        public decimal? StubRate { get; }
    }
    
    /// <summary>
    /// Defines collateral substitution provisions such as how many and with how much notice are substitutions allowed.
    /// </summary>
    public class SubstitutionProvisions : AbstractRosettaModelObject<SubstitutionProvisions>
    {
        private static readonly IRosettaMetaData<SubstitutionProvisions> metaData = new SubstitutionProvisionsMeta();
        
        [JsonConstructor]
        public SubstitutionProvisions(ZonedDateTime? noticeDeadlineDateTime, Period? noticeDeadlinePeriod, int? numberOfSubstitutionsAllowed)
        {
            NoticeDeadlineDateTime = noticeDeadlineDateTime;
            NoticeDeadlinePeriod = noticeDeadlinePeriod;
            NumberOfSubstitutionsAllowed = numberOfSubstitutionsAllowed;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<SubstitutionProvisions> MetaData => metaData;
        
        /// <summary>
        /// A specific date and time for the notice deadline
        /// </summary>
        public ZonedDateTime? NoticeDeadlineDateTime { get; }
        
        /// <summary>
        /// Defines the min period for notify of a substitution.
        /// </summary>
        public Period? NoticeDeadlinePeriod { get; }
        
        /// <summary>
        /// Specifies if 1 or more substitutions are allowed.
        /// </summary>
        public int? NumberOfSubstitutionsAllowed { get; }
    }
    
    /// <summary>
    /// A class to specify a valuation swap curve, which is used as part of the strike construct for the bond and convertible bond options.
    /// </summary>
    public class SwapCurveValuation : AbstractRosettaModelObject<SwapCurveValuation>, ISwapCurveValuation
    {
        private static readonly IRosettaMetaData<SwapCurveValuation> metaData = new SwapCurveValuationMeta();
        
        [JsonConstructor]
        public SwapCurveValuation(Enums.FloatingRateIndex floatingRateIndex, Period? indexTenor, Enums.QuotationSide? side, decimal spread)
        {
            FloatingRateIndex = floatingRateIndex;
            IndexTenor = indexTenor;
            Side = side;
            Spread = spread;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<SwapCurveValuation> MetaData => metaData;
        
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.FloatingRateIndex FloatingRateIndex { get; }
        
        /// <inheritdoc/>
        public Period? IndexTenor { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.QuotationSide? Side { get; }
        
        /// <inheritdoc/>
        public decimal Spread { get; }
    }
    
    public class Swp : AbstractRosettaModelObject<Swp>
    {
        private static readonly IRosettaMetaData<Swp> metaData = new SwpMeta();
        
        [JsonConstructor]
        public Swp(SwpIn swpIn, SwpOut swpOut)
        {
            SwpIn = swpIn;
            SwpOut = swpOut;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Swp> MetaData => metaData;
        
        public SwpIn SwpIn { get; }
        
        public SwpOut SwpOut { get; }
    }
    
    public class SwpIn : AbstractRosettaModelObject<SwpIn>
    {
        private static readonly IRosettaMetaData<SwpIn> metaData = new SwpInMeta();
        
        [JsonConstructor]
        public SwpIn(Sngl sngl)
        {
            Sngl = sngl;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<SwpIn> MetaData => metaData;
        
        public Sngl Sngl { get; }
    }
    
    public class SwpOut : AbstractRosettaModelObject<SwpOut>
    {
        private static readonly IRosettaMetaData<SwpOut> metaData = new SwpOutMeta();
        
        [JsonConstructor]
        public SwpOut(Sngl sngl)
        {
            Sngl = sngl;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<SwpOut> MetaData => metaData;
        
        public Sngl Sngl { get; }
    }
    
    /// <summary>
    /// Defines the taxonomy of an object by combining a taxonomy source (i.e. the rules to classify the object) and a value (i.e. the output of those rules on the object).
    /// </summary>
    public class Taxonomy : AbstractRosettaModelObject<Taxonomy>, ITaxonomy
    {
        private static readonly IRosettaMetaData<Taxonomy> metaData = new TaxonomyMeta();
        
        [JsonConstructor]
        public Taxonomy(Enums.TaxonomySource? source, TaxonomyValue? value)
        {
            Source = source;
            Value = value;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Taxonomy> MetaData => metaData;
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.TaxonomySource? Source { get; }
        
        /// <inheritdoc/>
        public TaxonomyValue? Value { get; }
    }
    
    public class TaxonomyClassification : AbstractRosettaModelObject<TaxonomyClassification>
    {
        private static readonly IRosettaMetaData<TaxonomyClassification> metaData = new TaxonomyClassificationMeta();
        
        [JsonConstructor]
        public TaxonomyClassification(string className, string? description, string value)
        {
            ClassName = className;
            Description = description;
            Value = value;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<TaxonomyClassification> MetaData => metaData;
        
        /// <summary>
        /// The name defined by the classification system for a specific attribute in the taxonomy.
        /// </summary>
        public string ClassName { get; }
        
        /// <summary>
        /// A descuription of the class.
        /// </summary>
        public string? Description { get; }
        
        /// <summary>
        /// The value set by the taxonomu that is specific to the className attribute.
        /// </summary>
        public string Value { get; }
    }
    
    /// <summary>
    /// Defines a taxonomy value as either a simple string or a more granular expression with class names and values for each class.
    /// </summary>
    public class TaxonomyValue : AbstractRosettaModelObject<TaxonomyValue>
    {
        private static readonly IRosettaMetaData<TaxonomyValue> metaData = new TaxonomyValueMeta();
        
        [JsonConstructor]
        public TaxonomyValue(IEnumerable<TaxonomyClassification> classification, FieldWithMetaString? name)
        {
            Classification = classification;
            Name = name;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<TaxonomyValue> MetaData => metaData;
        
        /// <summary>
        /// Specifies the taxonomy value as a set of class names and values for each class.
        /// </summary>
        public IEnumerable<TaxonomyClassification> Classification { get; }
        
        /// <summary>
        /// Specifies the taxonomy value as a simple string, which may be associated to an external scheme.
        /// </summary>
        public FieldWithMetaString? Name { get; }
    }
    
    /// <summary>
    /// A class to specify a telephone number as a type of phone number (e.g. work, personal, ...) alongside with the actual number.
    /// </summary>
    public class TelephoneNumber : AbstractRosettaModelObject<TelephoneNumber>
    {
        private static readonly IRosettaMetaData<TelephoneNumber> metaData = new TelephoneNumberMeta();
        
        [JsonConstructor]
        public TelephoneNumber(string number, Enums.TelephoneType? telephoneNumberType)
        {
            Number = number;
            TelephoneNumberType = telephoneNumberType;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<TelephoneNumber> MetaData => metaData;
        
        /// <summary>
        /// The actual telephone number.
        /// </summary>
        public string Number { get; }
        
        /// <summary>
        /// The type of telephone number, e.g. work, mobile.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.TelephoneType? TelephoneNumberType { get; }
    }
    
    public class Term : AbstractRosettaModelObject<Term>
    {
        private static readonly IRosettaMetaData<Term> metaData = new TermMeta();
        
        [JsonConstructor]
        public Term(string unit, string val)
        {
            Unit = unit;
            Val = val;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Term> MetaData => metaData;
        
        public string Unit { get; }
        
        public string Val { get; }
    }
    
    /// <summary>
    /// A class for defining option provisions.
    /// </summary>
    public class TerminationProvision : AbstractRosettaModelObject<TerminationProvision>
    {
        private static readonly IRosettaMetaData<TerminationProvision> metaData = new TerminationProvisionMeta();
        
        [JsonConstructor]
        public TerminationProvision(CancelableProvision? cancelableProvision, EarlyTerminationProvision? earlyTerminationProvision, EvergreenProvision? evergreenProvision, ExtendibleProvision? extendibleProvision)
        {
            CancelableProvision = cancelableProvision;
            EarlyTerminationProvision = earlyTerminationProvision;
            EvergreenProvision = evergreenProvision;
            ExtendibleProvision = extendibleProvision;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<TerminationProvision> MetaData => metaData;
        
        /// <summary>
        /// A provision that allows the specification of an embedded option within a swap giving the buyer of the option the right to terminate the swap, in whole or in part, on the early termination date.
        /// </summary>
        public CancelableProvision? CancelableProvision { get; }
        
        /// <summary>
        /// Parameters specifying provisions relating to the optional and mandatory early termination of a swap transaction.
        /// </summary>
        public EarlyTerminationProvision? EarlyTerminationProvision { get; }
        
        /// <summary>
        /// A data defining: the right of a party to exercise an Evergreen option
        /// </summary>
        public EvergreenProvision? EvergreenProvision { get; }
        
        /// <summary>
        /// A provision that allows the specification of an embedded option with a swap giving the buyer of the option the right to extend the swap, in whole or in part, to the extended termination date.
        /// </summary>
        public ExtendibleProvision? ExtendibleProvision { get; }
    }
    
    /// <summary>
    /// Specifies instructions for terms change consisting of the new transaction terms, and the renegotiation fee.
    /// </summary>
    public class TermsChangeInstruction : AbstractRosettaModelObject<TermsChangeInstruction>
    {
        private static readonly IRosettaMetaData<TermsChangeInstruction> metaData = new TermsChangeInstructionMeta();
        
        [JsonConstructor]
        public TermsChangeInstruction(Enums.NotionalAdjustment? adjustment, IEnumerable<AncillaryParty> ancillaryParty, Product? product)
        {
            Adjustment = adjustment;
            AncillaryParty = ancillaryParty;
            Product = product;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<TermsChangeInstruction> MetaData => metaData;
        
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.NotionalAdjustment? Adjustment { get; }
        
        /// <summary>
        /// ancillary party to be changed
        /// </summary>
        public IEnumerable<AncillaryParty> AncillaryParty { get; }
        
        /// <summary>
        /// product to be changed
        /// </summary>
        public Product? Product { get; }
    }
    
    /// <summary>
    /// The time alongside with the timezone location information. This class makes use of the FpML TimezoneLocation construct.
    /// </summary>
    public class TimeZone : AbstractRosettaModelObject<TimeZone>
    {
        private static readonly IRosettaMetaData<TimeZone> metaData = new TimeZoneMeta();
        
        [JsonConstructor]
        public TimeZone(FieldWithMetaString? location, LocalTime time)
        {
            Location = location;
            Time = time;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<TimeZone> MetaData => metaData;
        
        /// <summary>
        /// FpML specifies the timezoneLocationScheme by reference to the Time Zone Database (a.k.a. tz database) maintained by IANA, the Internet Assigned Numbers Authority.
        /// </summary>
        public FieldWithMetaString? Location { get; }
        
        /// <summary>
        /// The observation time.
        /// </summary>
        public LocalTime Time { get; }
    }
    
    /// <summary>
    /// Definition of a product as ready to be traded, i.e. included in an execution or contract, by associating a specific price and quantity to this product plus an (optional) mechanism for any potential future quantity adjustment.
    /// </summary>
    public class TradableProduct : AbstractRosettaModelObject<TradableProduct>
    {
        private static readonly IRosettaMetaData<TradableProduct> metaData = new TradableProductMeta();
        
        [JsonConstructor]
        public TradableProduct(Enums.NotionalAdjustment? adjustment, IEnumerable<AncillaryParty> ancillaryParty, IEnumerable<Counterparty> counterparty, Product product, IEnumerable<TradeLot> tradeLot)
        {
            Adjustment = adjustment;
            AncillaryParty = ancillaryParty;
            Counterparty = counterparty;
            Product = product;
            TradeLot = tradeLot;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<TradableProduct> MetaData => metaData;
        
        /// <summary>
        /// Specifies the conditions that govern the adjustment to the quantity of a product being traded: e.g. execution, portfolio rebalancing etc. It is typically used in the context of Equity Swaps.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.NotionalAdjustment? Adjustment { get; }
        
        /// <summary>
        /// Specifies the parties with ancillary roles in the transaction. The product is agnostic to the actual parties involved in the transaction, with the party references abstracted away from the product definition and replaced by the AncillaryRoleEnum. The AncillaryRoleEnum can then be positioned in the product and this AncillaryParty type, which is positioned outside of the product definition, allows the AncillaryRoleEnum to be associated with an actual party reference.
        /// </summary>
        public IEnumerable<AncillaryParty> AncillaryParty { get; }
        
        /// <summary>
        /// Specifies the parties which are the two counterparties to the transaction.  The product is agnostic to the actual parties to the transaction, with the party references abstracted away from the product definition and replaced by the counterparty enum (e.g. CounterpartyEnum values Party1 or Party2). The counterparty enum can then be positioned in the product (e.g. to specify which counterparty is the payer, receiver etc) and this counterparties attribute, which is positioned outside of the product definition, allows the counterparty enum to be associated with an actual party reference.
        /// </summary>
        public IEnumerable<Counterparty> Counterparty { get; }
        
        /// <summary>
        /// The underlying product to be included in a contract or execution.
        /// </summary>
        public Product Product { get; }
        
        /// <summary>
        /// Specifies the price, quantity and effective date of each trade lot, when the same product may be traded multiple times in different lots with the same counterparty. In a trade increase, a new trade lot is added to the list, with the corresponding effective date. In a trade decrease, the existing trade lot(s) are decreased of the corresponding quantity (and an unwind fee may have to be settled). The multiple cardinality and the ability to increase existing trades is used for Equity Swaps in particular.
        /// </summary>
        public IEnumerable<TradeLot> TradeLot { get; }
    }
    
    /// <summary>
    /// Defines the output of a financial transaction between parties - a Business Event. A Trade impacts the financial position (i.e. the balance sheet) of involved parties.
    /// </summary>
    public class Trade : AbstractRosettaModelObject<Trade>
    {
        private static readonly IRosettaMetaData<Trade> metaData = new TradeMeta();
        
        [JsonConstructor]
        public Trade(IEnumerable<Account> account, LocalDate? clearedDate, Collateral? collateral, ContractDetails? contractDetails, ExecutionDetails? executionDetails, _MetaFields? meta, IEnumerable<Party> party, IEnumerable<PartyRole> partyRole, TradableProduct tradableProduct, FieldWithMetaLocalDate tradeDate, IEnumerable<TradeIdentifier> tradeIdentifier)
        {
            Account = account;
            ClearedDate = clearedDate;
            Collateral = collateral;
            ContractDetails = contractDetails;
            ExecutionDetails = executionDetails;
            Meta = meta;
            Party = party;
            PartyRole = partyRole;
            TradableProduct = tradableProduct;
            TradeDate = tradeDate;
            TradeIdentifier = tradeIdentifier;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Trade> MetaData => metaData;
        
        /// <summary>
        /// Represents a party&apos;s granular account information, which may be used in subsequent internal processing.
        /// </summary>
        public IEnumerable<Account> Account { get; }
        
        /// <summary>
        /// Specifies the date on which a trade is cleared (novated) through a central counterparty clearing service.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? ClearedDate { get; }
        
        /// <summary>
        /// Represents the collateral obligations of a party.
        /// </summary>
        public Collateral? Collateral { get; }
        
        /// <summary>
        /// Represents information specific to trades involving contractual products.
        /// </summary>
        public ContractDetails? ContractDetails { get; }
        
        /// <summary>
        /// Represents information specific to trades that arose from executions.
        /// </summary>
        public ExecutionDetails? ExecutionDetails { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <summary>
        /// Represents the parties to the trade. The cardinality is optional to address the case where the trade is defined within a BusinessEvent data type, in which case the party is specified in BusinessEvent.
        /// </summary>
        public IEnumerable<Party> Party { get; }
        
        /// <summary>
        /// Represents the role each specified party takes in the trade. further to the principal roles, payer and receiver.
        /// </summary>
        public IEnumerable<PartyRole> PartyRole { get; }
        
        /// <summary>
        /// Represents the financial instrument The corresponding FpML construct is the product abstract element and the associated substitution group.
        /// </summary>
        public TradableProduct TradableProduct { get; }
        
        /// <summary>
        /// Specifies the date which the trade was agreed.
        /// </summary>
        public FieldWithMetaLocalDate TradeDate { get; }
        
        /// <summary>
        /// Represents the identifier(s) that uniquely identify a trade for an identity issuer. A trade can include multiple identifiers, for example a trade that is reportable to both the CFTC and ESMA, and then has an associated USI (Unique Swap Identifier) UTI (Unique Trade Identifier).
        /// </summary>
        public IEnumerable<TradeIdentifier> TradeIdentifier { get; }
    }
    
    /// <summary>
    /// Defines a trade identifier as a special case of the generic identifier type, that also includes the trade identifier class.
    /// </summary>
    public class TradeIdentifier : AbstractRosettaModelObject<TradeIdentifier>, IIdentifier
    {
        private static readonly IRosettaMetaData<TradeIdentifier> metaData = new TradeIdentifierMeta();
        
        [JsonConstructor]
        public TradeIdentifier(Enums.TradeIdentifierType? identifierType, IEnumerable<AssignedIdentifier> assignedIdentifier, FieldWithMetaString? issuer, ReferenceWithMetaParty? issuerReference, _MetaFields? meta)
        {
            IdentifierType = identifierType;
            AssignedIdentifier = assignedIdentifier;
            Issuer = issuer;
            IssuerReference = issuerReference;
            Meta = meta;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<TradeIdentifier> MetaData => metaData;
        
        /// <summary>
        /// The enumerated classification of the identifier. Optional as a trade identifier may be party-specific, in which case it may not correspond to any established classification.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.TradeIdentifierType? IdentifierType { get; }
        
        /// <inheritdoc/>
        public IEnumerable<AssignedIdentifier> AssignedIdentifier { get; }
        
        /// <inheritdoc/>
        public FieldWithMetaString? Issuer { get; }
        
        /// <inheritdoc/>
        public ReferenceWithMetaParty? IssuerReference { get; }
        
        public _MetaFields? Meta { get; }
    }
    
    /// <summary>
    /// Specifies the price and quantity of a trade lot, where the same product could be traded multiple times with the same counterparty but in different lots (at a different date, in a different quantity and at a different price). One trade lot combined with a product definition specifies the entire economics of a trade. The lifecycle mechanics of each such trade lot (e.g. cashflow payments) is independent of the other lots.
    /// </summary>
    public class TradeLot : AbstractRosettaModelObject<TradeLot>
    {
        private static readonly IRosettaMetaData<TradeLot> metaData = new TradeLotMeta();
        
        [JsonConstructor]
        public TradeLot(IEnumerable<Identifier> lotIdentifier, IEnumerable<PriceQuantity> priceQuantity)
        {
            LotIdentifier = lotIdentifier;
            PriceQuantity = priceQuantity;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<TradeLot> MetaData => metaData;
        
        /// <summary>
        /// Specifies one or more identifiers for the lot, if any.
        /// </summary>
        public IEnumerable<Identifier> LotIdentifier { get; }
        
        /// <summary>
        /// Specifies the settlement characteristics of a trade lot: price, quantity, observable (optionally) and the settlement terms. This attribute has a multiple cardinality to allow to specify the price, quantity and observable of different legs in a single, composite product (e.g. a Swap).
        /// </summary>
        public IEnumerable<PriceQuantity> PriceQuantity { get; }
    }
    
    /// <summary>
    /// The attributes that are specific for consensus based pricing reporting.
    /// </summary>
    public class TradePricingReport : AbstractRosettaModelObject<TradePricingReport>
    {
        private static readonly IRosettaMetaData<TradePricingReport> metaData = new TradePricingReportMeta();
        
        [JsonConstructor]
        public TradePricingReport(Enums.FloatingRateIndex? discountingIndex, TimeZone pricingTime, Trade trade)
        {
            DiscountingIndex = discountingIndex;
            PricingTime = pricingTime;
            Trade = trade;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<TradePricingReport> MetaData => metaData;
        
        /// <summary>
        /// It specifies the interest payable on collateral delivered under a CSA covering the trade.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.FloatingRateIndex? DiscountingIndex { get; }
        
        /// <summary>
        /// The regional exchange close time for the underlying contract,including time zone, at which the trades should be priced. This provides an indication for which regional snapshot should be used for pricing primarily for Global markets where there are multiple regional close times.
        /// </summary>
        public TimeZone PricingTime { get; }
        
        /// <summary>
        /// Represents the cosensus based pricing parameters on a trade basis.
        /// </summary>
        public Trade Trade { get; }
    }
    
    /// <summary>
    /// Defines the fundamental financial information that can be changed by a Primitive Event and by extension any business or life-cycle event. Each TradeState specifies where a Trade is in its life-cycle. TradeState is a root type and as such, can be created independently to any other CDM data type, but can also be used as part of the CDM Event Model.
    /// </summary>
    public class TradeState : AbstractRosettaModelObject<TradeState>
    {
        private static readonly IRosettaMetaData<TradeState> metaData = new TradeStateMeta();
        
        [JsonConstructor]
        public TradeState(_MetaFields? meta, IEnumerable<ObservationEvent> observationHistory, IEnumerable<Reset> resetHistory, State? state, Trade trade, IEnumerable<TransferState> transferHistory, IEnumerable<Valuation> valuationHistory)
        {
            Meta = meta;
            ObservationHistory = observationHistory;
            ResetHistory = resetHistory;
            State = state;
            Trade = trade;
            TransferHistory = transferHistory;
            ValuationHistory = valuationHistory;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<TradeState> MetaData => metaData;
        
        public _MetaFields? Meta { get; }
        
        /// <summary>
        /// Represents the observed events related to a particular product or process, such as credit events or corporate actions.
        /// </summary>
        public IEnumerable<ObservationEvent> ObservationHistory { get; }
        
        /// <summary>
        /// Represents the updated Trade attributes which can change as the result of a reset event. Only the changed values are captured, leaving the remaining data attributes empty. See Create_Reset function for further details on how TradeState is used in the Reset event. The TradeState data type is used to maintain backwards compatibility with the current Reset mechanism.
        /// </summary>
        public IEnumerable<Reset> ResetHistory { get; }
        
        /// <summary>
        /// Represents the State of the Trade through its life-cycle.
        /// </summary>
        public State? State { get; }
        
        /// <summary>
        /// Represents the Trade that has been effected by a business or life-cycle event.
        /// </summary>
        public Trade Trade { get; }
        
        /// <summary>
        /// Represents the updated Trade attributes which can change as the result of a transfer event.
        /// </summary>
        public IEnumerable<TransferState> TransferHistory { get; }
        
        public IEnumerable<Valuation> ValuationHistory { get; }
    }
    
    /// <summary>
    /// The class to represent a CDS Tranche.
    /// </summary>
    public class Tranche : AbstractRosettaModelObject<Tranche>
    {
        private static readonly IRosettaMetaData<Tranche> metaData = new TrancheMeta();
        
        [JsonConstructor]
        public Tranche(decimal attachmentPoint, decimal exhaustionPoint, bool? incurredRecoveryApplicable)
        {
            AttachmentPoint = attachmentPoint;
            ExhaustionPoint = exhaustionPoint;
            IncurredRecoveryApplicable = incurredRecoveryApplicable;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Tranche> MetaData => metaData;
        
        /// <summary>
        /// Lower bound percentage of the loss that the Tranche can endure, expressed as a decimal. An attachment point of 5% would be represented as 0.05. The difference between Attachment and Exhaustion points is called the width of the Tranche.
        /// </summary>
        public decimal AttachmentPoint { get; }
        
        /// <summary>
        /// Upper bound percentage of the loss that the Tranche can endure, expressed as a decimal. An exhaustion point of 5% would be represented as 0.05. The difference between Attachment and Exhaustion points is call the width of the Tranche.
        /// </summary>
        public decimal ExhaustionPoint { get; }
        
        /// <summary>
        /// Outstanding Swap Notional Amount is defined at any time on any day, as the greater of: (a) Zero; If Incurred Recovery Amount Applicable: (b) The Original Swap Notional Amount minus the sum of all Incurred Loss Amounts and all Incurred Recovery Amounts (if any) determined under this Confirmation at or prior to such time.Incurred Recovery Amount not populated: (b) The Original Swap Notional Amount minus the sum of all Incurred Loss Amounts determined under this Confirmation at or prior to such time.
        /// </summary>
        public bool? IncurredRecoveryApplicable { get; }
    }
    
    /// <summary>
    ///  A class to represent the transacted price attributes that are positioned as part of the FpML FeeLeg.
    /// </summary>
    public class TransactedPrice : AbstractRosettaModelObject<TransactedPrice>
    {
        private static readonly IRosettaMetaData<TransactedPrice> metaData = new TransactedPriceMeta();
        
        [JsonConstructor]
        public TransactedPrice(decimal? initialPoints, decimal? marketFixedRate, decimal? marketPrice, Enums.QuotationStyle? quotationStyle)
        {
            InitialPoints = initialPoints;
            MarketFixedRate = marketFixedRate;
            MarketPrice = marketPrice;
            QuotationStyle = quotationStyle;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<TransactedPrice> MetaData => metaData;
        
        /// <summary>
        /// An optional element that contains the up-front points expressed as a percentage of the notional. An initialPoints value of 5% would be represented as 0.05. The initialPoints element is an alternative to marketFixedRate in quoting the traded level of a trade. When initialPoints is used, the traded level is the sum of fixedRate and initialPoints. The initialPoints is one of the items that are factored into the initialPayment calculation and is payable by the Buyer to the Seller. Note that initialPoints and marketFixedRate may both be present in the same document when both implied values are desired.
        /// </summary>
        public decimal? InitialPoints { get; }
        
        /// <summary>
        /// An optional element that only has meaning in a credit index trade. This element contains the credit spread (&apos;fair value&apos;) at which the trade was executed. Unlike the fixedRate of an index, the marketFixedRate varies over the life of the index depending on market conditions. The marketFixedRate is the price of the index as quoted by trading desks.
        /// </summary>
        public decimal? MarketFixedRate { get; }
        
        /// <summary>
        /// An optional element that only has meaning in a credit index trade. This element contains the price at which the trade was executed and is used instead of marketFixedRate on credit trades on certain indicies which are quoted using a price rather than a spread.
        /// </summary>
        public decimal? MarketPrice { get; }
        
        /// <summary>
        /// An optional element that contains the up-front points expressed as a percentage of the notional. An initialPoints value of 5% would be represented as 0.05. The initialPoints element is an alternative to marketFixedRate in quoting the traded level of a trade. When initialPoints is used, the traded level is the sum of fixedRate and initialPoints. The initialPoints is one of the items that are factored into the initialPayment calculation and is payable by the Buyer to the Seller. Note that initialPoints and marketFixedRate may both be present in the same document when both implied values are desired.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.QuotationStyle? QuotationStyle { get; }
    }
    
    /// <summary>
    /// Defines the movement of cash, securities or commodities between two parties on a date.
    /// </summary>
    public class Transfer : AbstractRosettaModelObject<Transfer>, ITransferBase
    {
        private static readonly IRosettaMetaData<Transfer> metaData = new TransferMeta();
        
        [JsonConstructor]
        public Transfer(Reset? resetOrigin, SettlementOrigin? settlementOrigin, TransferExpression transferExpression, IEnumerable<FieldWithMetaIdentifier> identifier, Observable? observable, PartyReferencePayerReceiver payerReceiver, NonNegativeQuantity quantity, AdjustableOrAdjustedOrRelativeDate settlementDate)
        {
            ResetOrigin = resetOrigin;
            SettlementOrigin = settlementOrigin;
            TransferExpression = transferExpression;
            Identifier = identifier;
            Observable = observable;
            PayerReceiver = payerReceiver;
            Quantity = quantity;
            SettlementDate = settlementDate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Transfer> MetaData => metaData;
        
        /// <summary>
        /// Represents the reset and observation values that were used to determine the transfer amount.
        /// </summary>
        public Reset? ResetOrigin { get; }
        
        /// <summary>
        /// Represents the origin to the transfer as a reference for lineage purposes, whether it originated from trade level settlement terms or from payment terms on an economic payout.
        /// </summary>
        public SettlementOrigin? SettlementOrigin { get; }
        
        /// <summary>
        /// Specifies a transfer expression (cash price, performance amount, scheduled payment amount, etc.) to define the nature of the transfer amount and its source.
        /// </summary>
        public TransferExpression TransferExpression { get; }
        
        /// <inheritdoc/>
        public IEnumerable<FieldWithMetaIdentifier> Identifier { get; }
        
        /// <inheritdoc/>
        public Observable? Observable { get; }
        
        /// <inheritdoc/>
        public PartyReferencePayerReceiver PayerReceiver { get; }
        
        /// <inheritdoc/>
        public NonNegativeQuantity Quantity { get; }
        
        /// <inheritdoc/>
        public AdjustableOrAdjustedOrRelativeDate SettlementDate { get; }
    }
    
    public class TransferBase : AbstractRosettaModelObject<TransferBase>, ITransferBase
    {
        private static readonly IRosettaMetaData<TransferBase> metaData = new TransferBaseMeta();
        
        [JsonConstructor]
        public TransferBase(IEnumerable<FieldWithMetaIdentifier> identifier, Observable? observable, PartyReferencePayerReceiver payerReceiver, NonNegativeQuantity quantity, AdjustableOrAdjustedOrRelativeDate settlementDate)
        {
            Identifier = identifier;
            Observable = observable;
            PayerReceiver = payerReceiver;
            Quantity = quantity;
            SettlementDate = settlementDate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<TransferBase> MetaData => metaData;
        
        /// <inheritdoc/>
        public IEnumerable<FieldWithMetaIdentifier> Identifier { get; }
        
        /// <inheritdoc/>
        public Observable? Observable { get; }
        
        /// <inheritdoc/>
        public PartyReferencePayerReceiver PayerReceiver { get; }
        
        /// <inheritdoc/>
        public NonNegativeQuantity Quantity { get; }
        
        /// <inheritdoc/>
        public AdjustableOrAdjustedOrRelativeDate SettlementDate { get; }
    }
    
    /// <summary>
    /// Specifies a transfer expression (cash price, performance amount, scheduled payment amount, etc.) to define the nature of the transfer amount and its source.
    /// </summary>
    public class TransferExpression : AbstractRosettaModelObject<TransferExpression>
    {
        private static readonly IRosettaMetaData<TransferExpression> metaData = new TransferExpressionMeta();
        
        [JsonConstructor]
        public TransferExpression(Enums.FeeType? priceTransfer, ScheduledTransfer? scheduledTransfer)
        {
            PriceTransfer = priceTransfer;
            ScheduledTransfer = scheduledTransfer;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<TransferExpression> MetaData => metaData;
        
        /// <summary>
        /// Specifies a transfer amount exchanged as a price or fee for entering into a Business Event, e.g. Premium, Termination fee, Novation fee.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.FeeType? PriceTransfer { get; }
        
        /// <summary>
        /// Specifies a transfer created from a scheduled or contingent event on a contract, e.g. Exercise, Performance, Credit Event
        /// </summary>
        public ScheduledTransfer? ScheduledTransfer { get; }
    }
    
    /// <summary>
    /// Defines the payout on which to create a Transfer along with all necessary resets.
    /// </summary>
    public class TransferInstruction : AbstractRosettaModelObject<TransferInstruction>
    {
        private static readonly IRosettaMetaData<TransferInstruction> metaData = new TransferInstructionMeta();
        
        [JsonConstructor]
        public TransferInstruction(IEnumerable<TransferState> transferState)
        {
            TransferState = transferState;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<TransferInstruction> MetaData => metaData;
        
        /// <summary>
        /// Specifies the terms and state of a transfers.
        /// </summary>
        public IEnumerable<TransferState> TransferState { get; }
    }
    
    /// <summary>
    /// Defines the fundamental financial information associated with a Transfer event. Each TransferState specifies where a Transfer is in its life-cycle. TransferState is a root type and as such, can be created independently to any other CDM data type, but can also be used as part of the CDM Event Model.
    /// </summary>
    public class TransferState : AbstractRosettaModelObject<TransferState>
    {
        private static readonly IRosettaMetaData<TransferState> metaData = new TransferStateMeta();
        
        [JsonConstructor]
        public TransferState(_MetaFields? meta, Transfer transfer, Enums.TransferStatus? transferStatus)
        {
            Meta = meta;
            Transfer = transfer;
            TransferStatus = transferStatus;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<TransferState> MetaData => metaData;
        
        public _MetaFields? Meta { get; }
        
        /// <summary>
        /// Represents the Transfer that has been effected by a business or life-cycle event.
        /// </summary>
        public Transfer Transfer { get; }
        
        /// <summary>
        /// Represents the State of the Transfer through its life-cycle.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.TransferStatus? TransferStatus { get; }
    }
    
    /// <summary>
    /// Trigger point at which feature is effective.
    /// </summary>
    public class Trigger : AbstractRosettaModelObject<Trigger>
    {
        private static readonly IRosettaMetaData<Trigger> metaData = new TriggerMeta();
        
        [JsonConstructor]
        public Trigger(CreditEvents? creditEvents, ReferenceWithMetaCreditEvents? creditEventsReference, decimal? level, decimal? levelPercentage, Enums.TriggerTimeType? triggerTimeType, Enums.TriggerType? triggerType)
        {
            CreditEvents = creditEvents;
            CreditEventsReference = creditEventsReference;
            Level = level;
            LevelPercentage = levelPercentage;
            TriggerTimeType = triggerTimeType;
            TriggerType = triggerType;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Trigger> MetaData => metaData;
        
        public CreditEvents? CreditEvents { get; }
        
        public ReferenceWithMetaCreditEvents? CreditEventsReference { get; }
        
        /// <summary>
        /// The trigger level.
        /// </summary>
        public decimal? Level { get; }
        
        /// <summary>
        /// The trigger level percentage.
        /// </summary>
        public decimal? LevelPercentage { get; }
        
        /// <summary>
        /// The valuation time type of knock condition.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.TriggerTimeType? TriggerTimeType { get; }
        
        /// <summary>
        /// The Triggering condition.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.TriggerType? TriggerType { get; }
    }
    
    /// <summary>
    /// Observation point for trigger.
    /// </summary>
    public class TriggerEvent : AbstractRosettaModelObject<TriggerEvent>
    {
        private static readonly IRosettaMetaData<TriggerEvent> metaData = new TriggerEventMeta();
        
        [JsonConstructor]
        public TriggerEvent(FeaturePayment? featurePayment, IEnumerable<AveragingSchedule> schedule, Trigger trigger, DateList? triggerDates)
        {
            FeaturePayment = featurePayment;
            Schedule = schedule;
            Trigger = trigger;
            TriggerDates = triggerDates;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<TriggerEvent> MetaData => metaData;
        
        /// <summary>
        /// The feature payment, i.e. the payment made following trigger occurrence.
        /// </summary>
        public FeaturePayment? FeaturePayment { get; }
        
        /// <summary>
        /// A derivative schedule.
        /// </summary>
        public IEnumerable<AveragingSchedule> Schedule { get; }
        
        /// <summary>
        /// The trigger level
        /// </summary>
        public Trigger Trigger { get; }
        
        /// <summary>
        /// The trigger Dates.
        /// </summary>
        public DateList? TriggerDates { get; }
    }
    
    public class Tx : AbstractRosettaModelObject<Tx>
    {
        private static readonly IRosettaMetaData<Tx> metaData = new TxMeta();
        
        [JsonConstructor]
        public Tx(string ctryOfBrnch, New newTx, Pric pric, Qty qty, string tradDt, string tradVn, string tradgCpcty)
        {
            CtryOfBrnch = ctryOfBrnch;
            NewTx = newTx;
            Pric = pric;
            Qty = qty;
            TradDt = tradDt;
            TradVn = tradVn;
            TradgCpcty = tradgCpcty;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Tx> MetaData => metaData;
        
        public string CtryOfBrnch { get; }
        
        public New NewTx { get; }
        
        public Pric Pric { get; }
        
        public Qty Qty { get; }
        
        public string TradDt { get; }
        
        public string TradVn { get; }
        
        public string TradgCpcty { get; }
    }
    
    /// <summary>
    /// A class to specify a set of legal entities which are part of a legal agreement beyond the two contracting parties to that agreement. This data representation reflects the ISDA Create representation.
    /// </summary>
    public class UmbrellaAgreement : AbstractRosettaModelObject<UmbrellaAgreement>
    {
        private static readonly IRosettaMetaData<UmbrellaAgreement> metaData = new UmbrellaAgreementMeta();
        
        [JsonConstructor]
        public UmbrellaAgreement(bool isApplicable, string? language, IEnumerable<UmbrellaAgreementEntity> parties)
        {
            IsApplicable = isApplicable;
            Language = language;
            Parties = parties;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<UmbrellaAgreement> MetaData => metaData;
        
        /// <summary>
        /// The determination of whether Umbrella Agreement terms are Applicable (True), or Not Applicable (False)
        /// </summary>
        public bool IsApplicable { get; }
        
        /// <summary>
        /// The language associated with the umbrella agreement, and which applies to all the parties to the umbrella agreement.
        /// </summary>
        public string? Language { get; }
        
        /// <summary>
        /// Underlying principals to the umbrella agreement.
        /// </summary>
        public IEnumerable<UmbrellaAgreementEntity> Parties { get; }
    }
    
    /// <summary>
    /// A class to specify the legal entities that are part of the umbrella agreement.
    /// </summary>
    public class UmbrellaAgreementEntity : AbstractRosettaModelObject<UmbrellaAgreementEntity>, ILegalEntity
    {
        private static readonly IRosettaMetaData<UmbrellaAgreementEntity> metaData = new UmbrellaAgreementEntityMeta();
        
        [JsonConstructor]
        public UmbrellaAgreementEntity(string? terms, IEnumerable<FieldWithMetaString> entityId, _MetaFields? meta, FieldWithMetaString name)
        {
            Terms = terms;
            EntityId = entityId;
            Meta = meta;
            Name = name;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<UmbrellaAgreementEntity> MetaData => metaData;
        
        /// <summary>
        /// The terms that might be associated with each party to the umbrella agreement.
        /// </summary>
        public string? Terms { get; }
        
        /// <inheritdoc/>
        public IEnumerable<FieldWithMetaString> EntityId { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <inheritdoc/>
        public FieldWithMetaString Name { get; }
    }
    
    public class UndrlygInstrm : AbstractRosettaModelObject<UndrlygInstrm>
    {
        private static readonly IRosettaMetaData<UndrlygInstrm> metaData = new UndrlygInstrmMeta();
        
        [JsonConstructor]
        public UndrlygInstrm(Swp swp)
        {
            Swp = swp;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<UndrlygInstrm> MetaData => metaData;
        
        public Swp Swp { get; }
    }
    
    /// <summary>
    ///  Unit contract model for security valuation, e.g. for equity, modelled onto UnitContract.model in FpML.
    /// </summary>
    public class UnitContractValuationModel : AbstractRosettaModelObject<UnitContractValuationModel>
    {
        private static readonly IRosettaMetaData<UnitContractValuationModel> metaData = new UnitContractValuationModelMeta();
        
        [JsonConstructor]
        public UnitContractValuationModel(Quantity numberOfUnits, Money unitPrice)
        {
            NumberOfUnits = numberOfUnits;
            UnitPrice = unitPrice;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<UnitContractValuationModel> MetaData => metaData;
        
        /// <summary>
        /// The number of units (index or securities).
        /// </summary>
        public Quantity NumberOfUnits { get; }
        
        /// <summary>
        /// The price of each unit.
        /// </summary>
        public Money UnitPrice { get; }
    }
    
    /// <summary>
    /// Defines the unit to be used for price, quantity, or other purposes
    /// </summary>
    public class UnitType : AbstractRosettaModelObject<UnitType>
    {
        private static readonly IRosettaMetaData<UnitType> metaData = new UnitTypeMeta();
        
        [JsonConstructor]
        public UnitType(Enums.CapacityUnit? capacityUnit, FieldWithMetaString? currency, Enums.FinancialUnit? financialUnit, Enums.WeatherUnit? weatherUnit)
        {
            CapacityUnit = capacityUnit;
            Currency = currency;
            FinancialUnit = financialUnit;
            WeatherUnit = weatherUnit;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<UnitType> MetaData => metaData;
        
        /// <summary>
        /// Provides an enumerated value for a capacity unit, generally used in the context of defining quantities for commodities.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CapacityUnit? CapacityUnit { get; }
        
        /// <summary>
        /// Defines the currency to be used as a unit for a price, quantity, or other purpose.
        /// </summary>
        public FieldWithMetaString? Currency { get; }
        
        /// <summary>
        /// Provides an enumerated value for financial units, generally used in the context of defining quantities for securities.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.FinancialUnit? FinancialUnit { get; }
        
        /// <summary>
        /// Provides an enumerated values for a weather unit, generally used in the context of defining quantities for commodities.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.WeatherUnit? WeatherUnit { get; }
    }
    
    /// <summary>
    /// Defines the value of an investment, asset, or security
    /// </summary>
    public class Valuation : AbstractRosettaModelObject<Valuation>
    {
        private static readonly IRosettaMetaData<Valuation> metaData = new ValuationMeta();
        
        [JsonConstructor]
        public Valuation(Money amount, decimal? delta, Enums.ValuationType? method, Enums.ValuationSource? source, ZonedDateTime timestamp)
        {
            Amount = amount;
            Delta = delta;
            Method = method;
            Source = source;
            Timestamp = timestamp;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Valuation> MetaData => metaData;
        
        /// <summary>
        /// Current value of the outstanding contract
        /// </summary>
        public Money Amount { get; }
        
        /// <summary>
        /// The ratio of the change in the price of a derivative transaction to the change in the price of the underlying. This field is applicable only to options and swaptions.
        /// </summary>
        public decimal? Delta { get; }
        
        /// <summary>
        /// Method used for the valuation of the transaction by the valuation party.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.ValuationType? Method { get; }
        
        /// <summary>
        /// Source of the valuation of the transaction by the valuation party.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.ValuationSource? Source { get; }
        
        /// <summary>
        /// Date and time of the last valuation marked to market, provided by the central counterparty (CCP) or calculated using the current or last available market price of the inputs.
        /// </summary>
        public ZonedDateTime Timestamp { get; }
    }
    
    /// <summary>
    /// A single object that represents the different methods to specify a valuation date, as used for cash settlement. The Single / Multiple ValuationDate is used for the determination of recovery in a credit event, the RelativeDateOffset is used for cash-settled option, and FxFixingDate is used for cross-currency settlement.
    /// </summary>
    public class ValuationDate : AbstractRosettaModelObject<ValuationDate>
    {
        private static readonly IRosettaMetaData<ValuationDate> metaData = new ValuationDateMeta();
        
        [JsonConstructor]
        public ValuationDate(FxFixingDate? fxFixingDate, AdjustableDates? fxFixingSchedule, MultipleValuationDates? multipleValuationDates, SingleValuationDate? singleValuationDate, RelativeDateOffset? valuationDate)
        {
            FxFixingDate = fxFixingDate;
            FxFixingSchedule = fxFixingSchedule;
            MultipleValuationDates = multipleValuationDates;
            SingleValuationDate = singleValuationDate;
            ValuationDateValue = valuationDate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ValuationDate> MetaData => metaData;
        
        /// <summary>
        /// The date on which the currency rate will be determined for the purpose of specifying the amount in deliverable currency. This attribute was formerly part of &apos;NonDeliverableSettlement&apos;, which is now being harmonised into a common &apos;CashSettlementTerms&apos; that includes a &apos;ValuationDate&apos;.
        /// </summary>
        public FxFixingDate? FxFixingDate { get; }
        
        /// <summary>
        /// The date, when expressed as a schedule of date(s), on which the currency rate will be determined for the purpose of specifying the amount in deliverable currency. This attribute was formerly part of &apos;NonDeliverableSettlement&apos;, which is now being harmonised into a common &apos;CashSettlementTerms&apos; that includes a &apos;ValuationDate&apos;.
        /// </summary>
        public AdjustableDates? FxFixingSchedule { get; }
        
        /// <summary>
        /// Where multiple valuation dates are specified as being applicable for cash settlement, this element specifies (a) the number of applicable valuation dates, and (b) the number of business days after satisfaction of all conditions to settlement when the first such valuation date occurs, and (c) the number of business days thereafter of each successive valuation date. ISDA 2003 Term: Multiple Valuation Dates.
        /// </summary>
        public MultipleValuationDates? MultipleValuationDates { get; }
        
        /// <summary>
        /// Where single valuation date is specified as being applicable for cash settlement, this element specifies the number of business days after satisfaction of all conditions to settlement when such valuation date occurs. ISDA 2003 Term: Single Valuation Date.
        /// </summary>
        public SingleValuationDate? SingleValuationDate { get; }
        
        /// <summary>
        /// The date on which the cash settlement amount will be determined according to the cash settlement method if the parties have not otherwise been able to agree the cash settlement amount. This attribute was formerly part of &apos;OptionCashSettlement&apos;, which is now being harmonised into a common &apos;CashSettlementTerms&apos; that includes a &apos;ValuationDate&apos;.
        /// </summary>
        [JsonProperty(PropertyName = "valuationDate")]
        public RelativeDateOffset? ValuationDateValue { get; }
    }
    
    /// <summary>
    /// Defines how and when a performance type option or performance type swap is to be valued, including initial, interim and final valuation dates.
    /// </summary>
    public class ValuationDates : AbstractRosettaModelObject<ValuationDates>
    {
        private static readonly IRosettaMetaData<ValuationDates> metaData = new ValuationDatesMeta();
        
        [JsonConstructor]
        public ValuationDates(PerformanceValuationDates valuationDatesFinal, PerformanceValuationDates? valuationDatesInitial, PerformanceValuationDates? valuationDatesInterim)
        {
            ValuationDatesFinal = valuationDatesFinal;
            ValuationDatesInitial = valuationDatesInitial;
            ValuationDatesInterim = valuationDatesInterim;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ValuationDates> MetaData => metaData;
        
        /// <summary>
        /// Specifies the final valuation dates of the underlyer.
        /// </summary>
        public PerformanceValuationDates ValuationDatesFinal { get; }
        
        /// <summary>
        /// Specifies the initial valuation dates of the underlyer.
        /// </summary>
        public PerformanceValuationDates? ValuationDatesInitial { get; }
        
        /// <summary>
        /// Specifies the interim valuation dates of the underlyer.
        /// </summary>
        public PerformanceValuationDates? ValuationDatesInterim { get; }
    }
    
    /// <summary>
    /// Specifies the parameters required to obtain a valuation, including the source, quotation method (bid, mid etc.) and any applicable quotation amount.
    /// </summary>
    public class ValuationMethod : AbstractRosettaModelObject<ValuationMethod>
    {
        private static readonly IRosettaMetaData<ValuationMethod> metaData = new ValuationMethodMeta();
        
        [JsonConstructor]
        public ValuationMethod(CashCollateralValuationMethod? cashCollateralValuationMethod, Money? minimumQuotationAmount, Money? quotationAmount, Enums.QuotationRateType? quotationMethod, Enums.ValuationMethod? valuationMethod, ValuationSource valuationSource)
        {
            CashCollateralValuationMethod = cashCollateralValuationMethod;
            MinimumQuotationAmount = minimumQuotationAmount;
            QuotationAmount = quotationAmount;
            QuotationMethod = quotationMethod;
            ValuationMethodValue = valuationMethod;
            ValuationSource = valuationSource;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ValuationMethod> MetaData => metaData;
        
        /// <summary>
        /// Specifies the parameters representing several mid-market valuation and replacement value methods.
        /// </summary>
        public CashCollateralValuationMethod? CashCollateralValuationMethod { get; }
        
        /// <summary>
        /// In the determination of a cash settlement amount, if weighted average quotations are to be obtained, the minimum quotation amount specifies a minimum intended threshold amount of outstanding principal balance of the reference obligation for which the quote should be obtained. If not specified, the ISDA definitions provide for a fallback amount of the lower of either USD 1,000,000 (or its equivalent in the relevant obligation currency) or the quotation amount. ISDA 2003 Term: Minimum Quotation Amount.
        /// </summary>
        public Money? MinimumQuotationAmount { get; }
        
        /// <summary>
        /// In the determination of a cash settlement amount, if weighted average quotations are to be obtained, the quotation amount specifies an upper limit to the outstanding principal balance of the reference obligation for which the quote should be obtained. If not specified, the ISDA definitions provide for a fallback amount equal to the floating rate payer calculation amount. ISDA 2003 Term: Quotation Amount.
        /// </summary>
        public Money? QuotationAmount { get; }
        
        /// <summary>
        /// The type of price quotations to be requested from dealers when determining the market value of the reference obligation for purposes of cash settlement, or which rate quote is to be observed for a fixing. For example, Bid, Offer, Mid-market or Exercising Party Pays. ISDA 2003 Term: Quotation Method. The meaning of Exercising Party Pays is defined in the 2000 ISDA Definitions, Section 17.2. Certain Definitions Relating to Cash Settlement, paragraph (j).
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.QuotationRateType? QuotationMethod { get; }
        
        /// <summary>
        /// The ISDA defined methodology for determining the final price of the reference obligation for purposes of cash settlement. (ISDA 2003 Term: Valuation Method). For example, Market, Highest etc.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        [JsonProperty(PropertyName = "valuationMethod")]
        public Enums.ValuationMethod? ValuationMethodValue { get; }
        
        /// <summary>
        /// The source for obtaining a valuation. This may come from some information source (e.g. Reuters), from a rate option fixing (e.g. FX fixing for cross-currency settlement), or from a set of reference banks. This is a mandatory attribute as the valuation method relies on one of those sources to be specified.
        /// </summary>
        public ValuationSource ValuationSource { get; }
    }
    
    /// <summary>
    /// Specifies how long to wait to get a quote from a settlement rate option upon a price source disruption.
    /// </summary>
    public class ValuationPostponement : AbstractRosettaModelObject<ValuationPostponement>
    {
        private static readonly IRosettaMetaData<ValuationPostponement> metaData = new ValuationPostponementMeta();
        
        [JsonConstructor]
        public ValuationPostponement(int maximumDaysOfPostponement)
        {
            MaximumDaysOfPostponement = maximumDaysOfPostponement;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ValuationPostponement> MetaData => metaData;
        
        /// <summary>
        /// The maximum number of days to wait for a quote from the disrupted settlement rate option before proceeding to the next method.
        /// </summary>
        public int MaximumDaysOfPostponement { get; }
    }
    
    /// <summary>
    /// A class describing the method for obtaining a settlement rate, specified through either an information source (page), a settlement rate option (fixing) or by using quotes from reference banks.
    /// </summary>
    public class ValuationSource : AbstractRosettaModelObject<ValuationSource>
    {
        private static readonly IRosettaMetaData<ValuationSource> metaData = new ValuationSourceMeta();
        
        [JsonConstructor]
        public ValuationSource(AncillaryEntity? dealerOrCCP, FxSpotRateSource? informationSource, ReferenceWithMetaQuotedCurrencyPair? quotedCurrencyPair, ReferenceBanks? referenceBanks, SettlementRateOption? settlementRateOption)
        {
            DealerOrCCP = dealerOrCCP;
            InformationSource = informationSource;
            QuotedCurrencyPair = quotedCurrencyPair;
            ReferenceBanks = referenceBanks;
            SettlementRateOption = settlementRateOption;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ValuationSource> MetaData => metaData;
        
        /// <summary>
        /// Holds an identifier for the reference entity that is agreed by both parties as a basis for cash settlement calculations. This could be a dealer from whom quotations are obtained by the calculation agent on the reference obligation for purposes of cash settlement in a credit event. ISDA 2003 Term: Dealer. This could be the clearing organization (CCP, DCO) to which the trade should be cleared, as applicable for cash-settled swaptions.
        /// </summary>
        public AncillaryEntity? DealerOrCCP { get; }
        
        /// <summary>
        /// The information source where a published or displayed market rate will be obtained, e.g. Telerate Page 3750.
        /// </summary>
        public FxSpotRateSource? InformationSource { get; }
        
        /// <summary>
        /// Defines the two currencies for an FX trade and the quotation relationship between the two currencies.  This attribute was formerly part of &apos;fxSettlementTerms&apos;, which is now being harmonised into a common &apos;CashSettlementTerms&apos; that includes a &apos;ValuationDate&apos;.
        /// </summary>
        public ReferenceWithMetaQuotedCurrencyPair? QuotedCurrencyPair { get; }
        
        /// <summary>
        /// A container for a set of reference institutions that may be called upon to provide rate quotations as part of the method to determine the applicable cash settlement amount. If institutions are not specified, it is assumed that reference institutions will be agreed between the parties on the exercise date, or in the case of swap transaction to which mandatory early termination is applicable, the cash settlement valuation date.
        /// </summary>
        public ReferenceBanks? ReferenceBanks { get; }
        
        /// <summary>
        /// The rate option to use for the fixing. Currently only applicable to foreign exchange fixing in case of cross-currency settlement.
        /// </summary>
        public SettlementRateOption? SettlementRateOption { get; }
    }
    
    public class ValuationTerms : AbstractRosettaModelObject<ValuationTerms>
    {
        private static readonly IRosettaMetaData<ValuationTerms> metaData = new ValuationTermsMeta();
        
        [JsonConstructor]
        public ValuationTerms(bool? componentSecurityIndexAnnexFallback, AdjustableRelativeOrPeriodicDates? dividendValuationDates, Enums.FPVFinalPriceElectionFallback? fPVFinalPriceElectionFallback, bool? futuresPriceValuation, bool? multipleExchangeIndexAnnexFallback, int? numberOfValuationDates, bool? optionsPriceValuation)
        {
            ComponentSecurityIndexAnnexFallback = componentSecurityIndexAnnexFallback;
            DividendValuationDates = dividendValuationDates;
            FPVFinalPriceElectionFallback = fPVFinalPriceElectionFallback;
            FuturesPriceValuation = futuresPriceValuation;
            MultipleExchangeIndexAnnexFallback = multipleExchangeIndexAnnexFallback;
            NumberOfValuationDates = numberOfValuationDates;
            OptionsPriceValuation = optionsPriceValuation;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ValuationTerms> MetaData => metaData;
        
        /// <summary>
        /// For an index option transaction, a flag to indicate whether a relevant Component Security Index Annex is applicable to the transaction.
        /// </summary>
        public bool? ComponentSecurityIndexAnnexFallback { get; }
        
        /// <summary>
        /// Specifies the dividend valuation dates of the swap.
        /// </summary>
        public AdjustableRelativeOrPeriodicDates? DividendValuationDates { get; }
        
        /// <summary>
        /// Specifies the fallback provisions for Hedging Party in the determination of the Final Price.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.FPVFinalPriceElectionFallback? FPVFinalPriceElectionFallback { get; }
        
        /// <summary>
        /// The official settlement price as announced by the related exchange is applicable, in accordance with the ISDA 2002 definitions.
        /// </summary>
        public bool? FuturesPriceValuation { get; }
        
        /// <summary>
        /// For an index option transaction, a flag to indicate whether a relevant Multiple Exchange Index Annex is applicable to the transaction. This annex defines additional provisions which are applicable where an index is comprised of component securities that are traded on multiple exchanges.
        /// </summary>
        public bool? MultipleExchangeIndexAnnexFallback { get; }
        
        /// <summary>
        /// The number of valuation dates between valuation start date and valuation end date.
        /// </summary>
        public int? NumberOfValuationDates { get; }
        
        /// <summary>
        /// The official settlement price as announced by the related exchange is applicable, in accordance with the ISDA 2002 definitions
        /// </summary>
        public bool? OptionsPriceValuation { get; }
    }
    
    public class VarianceCapFloor : AbstractRosettaModelObject<VarianceCapFloor>
    {
        private static readonly IRosettaMetaData<VarianceCapFloor> metaData = new VarianceCapFloorMeta();
        
        [JsonConstructor]
        public VarianceCapFloor(BoundedVariance? boundedVariance, decimal? unadjustedVarianceCap, bool varianceCap)
        {
            BoundedVariance = boundedVariance;
            UnadjustedVarianceCap = unadjustedVarianceCap;
            VarianceCap = varianceCap;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<VarianceCapFloor> MetaData => metaData;
        
        /// <summary>
        /// Conditions which bound variance. The contract specifies one or more boundary levels. These levels are expressed as prices for confirmation purposes Underlyer price must be equal to or higher than Lower Barrier is known as Up Conditional Swap Underlyer price must be equal to or lower than Upper Barrier is known as Down Conditional Swap Underlyer price must be equal to or higher than Lower Barrier and must be equal to or lower than Upper Barrier is known as Barrier Conditional Swap.
        /// </summary>
        public BoundedVariance? BoundedVariance { get; }
        
        /// <summary>
        /// For use when varianceCap is applicable. Contains the scaling factor of the Variance Cap that can differ on a trade-by-trade basis in the European market. For example, a Variance Cap of 2.5^2 x Variance Strike Price has an unadjustedVarianceCap of 2.5.
        /// </summary>
        public decimal? UnadjustedVarianceCap { get; }
        
        /// <summary>
        /// If present and true, then variance cap is applicable.
        /// </summary>
        public bool VarianceCap { get; }
    }
    
    public class VarianceReturnTerms : AbstractRosettaModelObject<VarianceReturnTerms>, IReturnTermsBase
    {
        private static readonly IRosettaMetaData<VarianceReturnTerms> metaData = new VarianceReturnTermsMeta();
        
        [JsonConstructor]
        public VarianceReturnTerms(Observable? exchangeTradedContractNearest, VarianceCapFloor? varianceCapFloor, Price? varianceStrikePrice, NonNegativeQuantitySchedule? vegaNotionalAmount, VolatilityCapFloor? volatilityCapFloor, Price? volatilityStrikePrice, int? annualizationFactor, DividendApplicability? dividendApplicability, EquityUnderlierProvisions? equityUnderlierProvisions, int expectedN, decimal? initialLevel, Enums.DeterminationMethod? initialLevelSource, bool? meanAdjustment, string? performance, bool? sharePriceDividendAdjustment, ValuationTerms valuationTerms)
        {
            ExchangeTradedContractNearest = exchangeTradedContractNearest;
            VarianceCapFloor = varianceCapFloor;
            VarianceStrikePrice = varianceStrikePrice;
            VegaNotionalAmount = vegaNotionalAmount;
            VolatilityCapFloor = volatilityCapFloor;
            VolatilityStrikePrice = volatilityStrikePrice;
            AnnualizationFactor = annualizationFactor;
            DividendApplicability = dividendApplicability;
            EquityUnderlierProvisions = equityUnderlierProvisions;
            ExpectedN = expectedN;
            InitialLevel = initialLevel;
            InitialLevelSource = initialLevelSource;
            MeanAdjustment = meanAdjustment;
            Performance = performance;
            SharePriceDividendAdjustment = sharePriceDividendAdjustment;
            ValuationTerms = valuationTerms;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<VarianceReturnTerms> MetaData => metaData;
        
        /// <summary>
        /// Specification of the exchange traded contract nearest.
        /// </summary>
        public Observable? ExchangeTradedContractNearest { get; }
        
        /// <summary>
        /// Contains possible barriers for variance products, both variance-based and underlier price based
        /// </summary>
        public VarianceCapFloor? VarianceCapFloor { get; }
        
        /// <summary>
        /// Variance Strike Price in accordance with the ISDA 2011 Equity Derivatives Definitions.
        /// </summary>
        public Price? VarianceStrikePrice { get; }
        
        /// <summary>
        /// Vega Notional represents the approximate gain/loss at maturity for a 1% difference between RVol (realised vol) and KVol (strike vol). It does not necessarily represent the Vega Risk of the trade.
        /// </summary>
        public NonNegativeQuantitySchedule? VegaNotionalAmount { get; }
        
        /// <summary>
        /// Contains containing volatility-based barriers
        /// </summary>
        public VolatilityCapFloor? VolatilityCapFloor { get; }
        
        /// <summary>
        /// Volatility Strike Price in accordance with the ISDA 2011 Equity Derivatives Definitions.
        /// </summary>
        public Price? VolatilityStrikePrice { get; }
        
        /// <inheritdoc/>
        public int? AnnualizationFactor { get; }
        
        /// <inheritdoc/>
        public DividendApplicability? DividendApplicability { get; }
        
        /// <inheritdoc/>
        public EquityUnderlierProvisions? EquityUnderlierProvisions { get; }
        
        /// <inheritdoc/>
        public int ExpectedN { get; }
        
        /// <inheritdoc/>
        public decimal? InitialLevel { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.DeterminationMethod? InitialLevelSource { get; }
        
        /// <inheritdoc/>
        public bool? MeanAdjustment { get; }
        
        /// <inheritdoc/>
        public string? Performance { get; }
        
        /// <inheritdoc/>
        public bool? SharePriceDividendAdjustment { get; }
        
        /// <inheritdoc/>
        public ValuationTerms ValuationTerms { get; }
    }
    
    public class Velocity : AbstractRosettaModelObject<Velocity>
    {
        private static readonly IRosettaMetaData<Velocity> metaData = new VelocityMeta();
        
        [JsonConstructor]
        public Velocity(Enums.PeriodTime? period, int? periodMultiplier)
        {
            Period = period;
            PeriodMultiplier = periodMultiplier;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Velocity> MetaData => metaData;
        
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.PeriodTime? Period { get; }
        
        public int? PeriodMultiplier { get; }
    }
    
    /// <summary>
    /// Contains volatility-based barriers. Volatility Cap needs to be specified in accordance with the ISDA 2011 Equity Derivatives Definitions.
    /// </summary>
    public class VolatilityCapFloor : AbstractRosettaModelObject<VolatilityCapFloor>
    {
        private static readonly IRosettaMetaData<VolatilityCapFloor> metaData = new VolatilityCapFloorMeta();
        
        [JsonConstructor]
        public VolatilityCapFloor(bool applicable, decimal? totalVolatilityCap, decimal? volatilityCapFactor)
        {
            Applicable = applicable;
            TotalVolatilityCap = totalVolatilityCap;
            VolatilityCapFactor = volatilityCapFactor;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<VolatilityCapFloor> MetaData => metaData;
        
        /// <summary>
        /// Indicates whether the volatility cap is applicable in accordance with the ISDA 2011 Equity Derivatives Definitions. Setting the element &apos;applicable&apos; to &apos;False&apos; - means No Volatility Cap and no &apos;totalVolatilityCap&apos; or &apos;volatilityCapFactor&apos; should be provided. Setting the element &apos;applicable&apos; to &apos;True&apos; - means Volatility Cap election, then &apos;totalVolatilityCap&apos; or &apos;volatilityCapFactor&apos; should be provided, otherwise it defaults to volatilityCapFactor=2.5.
        /// </summary>
        public bool Applicable { get; }
        
        /// <summary>
        /// Volatility Cap Amount in accordance with the ISDA 2011 Equity Derivatives Definitions. This means the Volatility Cap Amount election is a number.
        /// </summary>
        public decimal? TotalVolatilityCap { get; }
        
        /// <summary>
        /// Volatility Cap Amount in accordance with the ISDA 2011 Equity Derivatives Definitions. The Calculated VolCapAmt can be optionally provided.
        /// </summary>
        public decimal? VolatilityCapFactor { get; }
    }
    
    public class VolatilityReturnTerms : AbstractRosettaModelObject<VolatilityReturnTerms>, IReturnTermsBase
    {
        private static readonly IRosettaMetaData<VolatilityReturnTerms> metaData = new VolatilityReturnTermsMeta();
        
        [JsonConstructor]
        public VolatilityReturnTerms(Observable? exchangeTradedContractNearest, VolatilityCapFloor? volatilityCapFloor, Price volatilityStrikePrice, int? annualizationFactor, DividendApplicability? dividendApplicability, EquityUnderlierProvisions? equityUnderlierProvisions, int expectedN, decimal? initialLevel, Enums.DeterminationMethod? initialLevelSource, bool? meanAdjustment, string? performance, bool? sharePriceDividendAdjustment, ValuationTerms valuationTerms)
        {
            ExchangeTradedContractNearest = exchangeTradedContractNearest;
            VolatilityCapFloor = volatilityCapFloor;
            VolatilityStrikePrice = volatilityStrikePrice;
            AnnualizationFactor = annualizationFactor;
            DividendApplicability = dividendApplicability;
            EquityUnderlierProvisions = equityUnderlierProvisions;
            ExpectedN = expectedN;
            InitialLevel = initialLevel;
            InitialLevelSource = initialLevelSource;
            MeanAdjustment = meanAdjustment;
            Performance = performance;
            SharePriceDividendAdjustment = sharePriceDividendAdjustment;
            ValuationTerms = valuationTerms;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<VolatilityReturnTerms> MetaData => metaData;
        
        /// <summary>
        /// Specification of the exchange traded contract nearest.
        /// </summary>
        public Observable? ExchangeTradedContractNearest { get; }
        
        /// <summary>
        /// Contains volatility-based barriers
        /// </summary>
        public VolatilityCapFloor? VolatilityCapFloor { get; }
        
        /// <summary>
        /// Volatility Strike Price in accordance with the ISDA 2011 Equity Derivatives Definitions.
        /// </summary>
        public Price VolatilityStrikePrice { get; }
        
        /// <inheritdoc/>
        public int? AnnualizationFactor { get; }
        
        /// <inheritdoc/>
        public DividendApplicability? DividendApplicability { get; }
        
        /// <inheritdoc/>
        public EquityUnderlierProvisions? EquityUnderlierProvisions { get; }
        
        /// <inheritdoc/>
        public int ExpectedN { get; }
        
        /// <inheritdoc/>
        public decimal? InitialLevel { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.DeterminationMethod? InitialLevelSource { get; }
        
        /// <inheritdoc/>
        public bool? MeanAdjustment { get; }
        
        /// <inheritdoc/>
        public string? Performance { get; }
        
        /// <inheritdoc/>
        public bool? SharePriceDividendAdjustment { get; }
        
        /// <inheritdoc/>
        public ValuationTerms ValuationTerms { get; }
    }
    
    /// <summary>
    /// A single weighted averaging observation.
    /// </summary>
    public class WeightedAveragingObservation : AbstractRosettaModelObject<WeightedAveragingObservation>
    {
        private static readonly IRosettaMetaData<WeightedAveragingObservation> metaData = new WeightedAveragingObservationMeta();
        
        [JsonConstructor]
        public WeightedAveragingObservation(ZonedDateTime? dateTime, int? observationNumber, decimal weight)
        {
            DateTime = dateTime;
            ObservationNumber = observationNumber;
            Weight = weight;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<WeightedAveragingObservation> MetaData => metaData;
        
        /// <summary>
        /// Observation date time, which should be used when literal observation dates are required. The CDM specifies that the zoned date time is to be expressed in accordance with ISO 8601, either as UTC as an offset to UTC.
        /// </summary>
        public ZonedDateTime? DateTime { get; }
        
        /// <summary>
        /// Observation number, which should be unique, within a series generated by a date schedule.
        /// </summary>
        public int? ObservationNumber { get; }
        
        /// <summary>
        /// Observation weight, which is used as a multiplier for the observation value.
        /// </summary>
        public decimal Weight { get; }
    }
    
    /// <summary>
    /// A collection of workflow steps which together makeup an entire workflow sequence.
    /// </summary>
    public class Workflow : AbstractRosettaModelObject<Workflow>
    {
        private static readonly IRosettaMetaData<Workflow> metaData = new WorkflowMeta();
        
        [JsonConstructor]
        public Workflow(IEnumerable<WorkflowStep> steps)
        {
            Steps = steps;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Workflow> MetaData => metaData;
        
        public IEnumerable<WorkflowStep> Steps { get; }
    }
    
    /// <summary>
    /// A class to specify workflow information, which is conceptually applicable to all lifecycle events.
    /// </summary>
    public class WorkflowState : AbstractRosettaModelObject<WorkflowState>
    {
        private static readonly IRosettaMetaData<WorkflowState> metaData = new WorkflowStateMeta();
        
        [JsonConstructor]
        public WorkflowState(string? comment, IEnumerable<PartyCustomisedWorkflow> partyCustomisedWorkflow, Enums.WarehouseIdentity? warehouseIdentity, Enums.WorkflowStatus workflowStatus)
        {
            Comment = comment;
            PartyCustomisedWorkflow = partyCustomisedWorkflow;
            WarehouseIdentity = warehouseIdentity;
            WorkflowStatus = workflowStatus;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<WorkflowState> MetaData => metaData;
        
        /// <summary>
        /// A comment field to be associated with the workflow, e.g. to specify why a transaction event was rejected by a party.
        /// </summary>
        public string? Comment { get; }
        
        /// <summary>
        /// Workflow data that is specific to certain market participants and is expressed as part of the CDM in a very generic manner, which can be party-specific. The initial use cases have been derived from the CME clearing and the DTCC TIW submissions.
        /// </summary>
        public IEnumerable<PartyCustomisedWorkflow> PartyCustomisedWorkflow { get; }
        
        /// <summary>
        /// The identity of the warehouse, if any, that is executing that workflow step.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.WarehouseIdentity? WarehouseIdentity { get; }
        
        /// <summary>
        /// The workflow status indicator, e.g. Accepted, Rejected, ...
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.WorkflowStatus WorkflowStatus { get; }
    }
    
    /// <summary>
    /// A workflow step represents the state of a business event. The workflow step contains a reference to a previous WorkflowStep in order to preserve lineage. A workflow step is accepted if it contains a business event, proposed if proposedEvent is present and is rejected if the rejected flag is set.
    /// </summary>
    public class WorkflowStep : AbstractRosettaModelObject<WorkflowStep>
    {
        private static readonly IRosettaMetaData<WorkflowStep> metaData = new WorkflowStepMeta();
        
        [JsonConstructor]
        public WorkflowStep(IEnumerable<Account> account, Enums.Action? action, IEnumerable<WorkflowStepApproval> approval, BusinessEvent? businessEvent, CreditLimitInformation? creditLimitInformation, IEnumerable<Identifier> eventIdentifier, Lineage? lineage, MessageInformation? messageInformation, _MetaFields? meta, EventInstruction? nextEvent, IEnumerable<Party> party, ReferenceWithMetaWorkflowStep? previousWorkflowStep, EventInstruction? proposedEvent, bool? rejected, IEnumerable<EventTimestamp> timestamp, WorkflowState? workflowState)
        {
            Account = account;
            Action = action;
            Approval = approval;
            BusinessEvent = businessEvent;
            CreditLimitInformation = creditLimitInformation;
            EventIdentifier = eventIdentifier;
            Lineage = lineage;
            MessageInformation = messageInformation;
            Meta = meta;
            NextEvent = nextEvent;
            Party = party;
            PreviousWorkflowStep = previousWorkflowStep;
            ProposedEvent = proposedEvent;
            Rejected = rejected;
            Timestamp = timestamp;
            WorkflowState = workflowState;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<WorkflowStep> MetaData => metaData;
        
        /// <summary>
        /// Optional account information that could be associated to the event.
        /// </summary>
        public IEnumerable<Account> Account { get; }
        
        /// <summary>
        /// Specifies whether the event is a new, a correction or a cancellation.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.Action? Action { get; }
        
        /// <summary>
        /// Optional party approvals for the current workflow step. A workflow step can have any number of parties associated to it, thus this object is represented as a list. All parties that are expected to provide approval should have an item in this list that references them.
        /// </summary>
        public IEnumerable<WorkflowStepApproval> Approval { get; }
        
        /// <summary>
        /// Life cycle event for the step. The businessEvent is optional when a proposedEvent or rejection are present.
        /// </summary>
        public BusinessEvent? BusinessEvent { get; }
        
        public CreditLimitInformation? CreditLimitInformation { get; }
        
        /// <summary>
        /// The identifier(s) that uniquely identify a lifecycle event. The unbounded cardinality is meant to provide the ability to associate identifiers that are issued by distinct parties. As an example, each of the parties to the event may choose to associate their own identifiers to the event.
        /// </summary>
        public IEnumerable<Identifier> EventIdentifier { get;