/*
 * Decompiled with CFR 0.152.
 */
package com.rosetta.model.metafields;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.GlobalKeyFields;
import com.rosetta.model.lib.meta.Key;
import com.rosetta.model.lib.meta.MetaDataFields;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.MetaFieldsMeta;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaClass
public interface MetaFields
extends RosettaModelObject,
MetaDataFields,
GlobalKeyFields {
    public static final MetaFieldsMeta metaData = new MetaFieldsMeta();

    public MetaFields build();

    public MetaFieldsBuilder toBuilder();

    public String getExternalKey();

    public String getGlobalKey();

    public List<? extends Key> getKey();

    public String getScheme();

    default public RosettaMetaData<? extends MetaFields> metaData() {
        return metaData;
    }

    public static MetaFieldsBuilder builder() {
        return new MetaFieldsBuilderImpl();
    }

    default public Class<? extends MetaFields> getType() {
        return MetaFields.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("externalKey"), String.class, (Object)this.getExternalKey(), (RosettaModelObject)this, new AttributeMeta[]{AttributeMeta.META});
        processor.processBasic(path.newSubPath("globalKey"), String.class, (Object)this.getGlobalKey(), (RosettaModelObject)this, new AttributeMeta[]{AttributeMeta.META});
        processor.processBasic(path.newSubPath("scheme"), String.class, (Object)this.getScheme(), (RosettaModelObject)this, new AttributeMeta[]{AttributeMeta.META});
        this.processRosetta(path.newSubPath("key"), processor, Key.class, this.getKey(), new AttributeMeta[0]);
    }

    public static class MetaFieldsBuilderImpl
    implements MetaFieldsBuilder {
        protected String externalKey;
        protected String globalKey;
        protected List<Key.KeyBuilder> key = new ArrayList<Key.KeyBuilder>();
        protected String scheme;

        @Override
        public String getExternalKey() {
            return this.externalKey;
        }

        @Override
        public String getGlobalKey() {
            return this.globalKey;
        }

        @Override
        public List<? extends Key.KeyBuilder> getKey() {
            return this.key;
        }

        @Override
        public Key.KeyBuilder getOrCreateKey(int _index) {
            if (this.key == null) {
                this.key = new ArrayList<Key.KeyBuilder>();
            }
            return (Key.KeyBuilder)this.getIndex(this.key, _index, () -> {
                Key.KeyBuilder newKey = Key.builder();
                return newKey;
            });
        }

        @Override
        public String getScheme() {
            return this.scheme;
        }

        @Override
        public MetaFieldsBuilder setExternalKey(String externalKey) {
            this.externalKey = externalKey == null ? null : externalKey;
            return this;
        }

        @Override
        public MetaFieldsBuilder setGlobalKey(String globalKey) {
            this.globalKey = globalKey == null ? null : globalKey;
            return this;
        }

        @Override
        public MetaFieldsBuilder addKey(Key key) {
            if (key != null) {
                this.key.add(key.toBuilder());
            }
            return this;
        }

        @Override
        public MetaFieldsBuilder addKey(Key key, int _idx) {
            this.getIndex(this.key, _idx, () -> key.toBuilder());
            return this;
        }

        @Override
        public MetaFieldsBuilder addKey(List<? extends Key> keys) {
            if (keys != null) {
                for (Key key : keys) {
                    this.key.add(key.toBuilder());
                }
            }
            return this;
        }

        @Override
        public MetaFieldsBuilder setKey(List<? extends Key> keys) {
            this.key = keys == null ? new ArrayList<Key.KeyBuilder>() : (List)keys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public MetaFieldsBuilder setScheme(String scheme) {
            this.scheme = scheme == null ? null : scheme;
            return this;
        }

        @Override
        public MetaFields build() {
            return new MetaFieldsImpl(this);
        }

        @Override
        public MetaFieldsBuilder toBuilder() {
            return this;
        }

        @Override
        public MetaFieldsBuilder prune() {
            this.key = this.key.stream().filter(b -> b != null).map(b -> (Key.KeyBuilder)b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getExternalKey() != null) {
                return true;
            }
            if (this.getGlobalKey() != null) {
                return true;
            }
            if (this.getKey() != null && this.getKey().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getScheme() != null;
        }

        public MetaFieldsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            MetaFieldsBuilder o = (MetaFieldsBuilder)other;
            merger.mergeRosetta(this.getKey(), o.getKey(), this::getOrCreateKey);
            merger.mergeBasic((Object)this.getExternalKey(), (Object)o.getExternalKey(), this::setExternalKey, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getGlobalKey(), (Object)o.getGlobalKey(), this::setGlobalKey, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getScheme(), (Object)o.getScheme(), this::setScheme, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            MetaFields _that = this.getType().cast(o);
            if (!Objects.equals(this.externalKey, _that.getExternalKey())) {
                return false;
            }
            if (!Objects.equals(this.globalKey, _that.getGlobalKey())) {
                return false;
            }
            if (!ListEquals.listEquals(this.key, _that.getKey())) {
                return false;
            }
            return Objects.equals(this.scheme, _that.getScheme());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.externalKey != null ? this.externalKey.hashCode() : 0);
            _result = 31 * _result + (this.globalKey != null ? this.globalKey.hashCode() : 0);
            _result = 31 * _result + (this.key != null ? this.key.hashCode() : 0);
            _result = 31 * _result + (this.scheme != null ? this.scheme.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "MetaFieldsBuilder {externalKey=" + this.externalKey + ", globalKey=" + this.globalKey + ", key=" + this.key + ", scheme=" + this.scheme + '}';
        }
    }

    public static class MetaFieldsImpl
    implements MetaFields {
        private final String externalKey;
        private final String globalKey;
        private final List<? extends Key> key;
        private final String scheme;

        protected MetaFieldsImpl(MetaFieldsBuilder builder) {
            this.externalKey = builder.getExternalKey();
            this.globalKey = builder.getGlobalKey();
            this.key = Optional.ofNullable(builder.getKey()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.scheme = builder.getScheme();
        }

        @Override
        public String getExternalKey() {
            return this.externalKey;
        }

        @Override
        public String getGlobalKey() {
            return this.globalKey;
        }

        @Override
        public List<? extends Key> getKey() {
            return this.key;
        }

        @Override
        public String getScheme() {
            return this.scheme;
        }

        @Override
        public MetaFields build() {
            return this;
        }

        @Override
        public MetaFieldsBuilder toBuilder() {
            MetaFieldsBuilder builder = MetaFields.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(MetaFieldsBuilder builder) {
            Optional.ofNullable(this.getExternalKey()).ifPresent(builder::setExternalKey);
            Optional.ofNullable(this.getGlobalKey()).ifPresent(builder::setGlobalKey);
            Optional.ofNullable(this.getKey()).ifPresent(builder::setKey);
            Optional.ofNullable(this.getScheme()).ifPresent(builder::setScheme);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            MetaFields _that = this.getType().cast(o);
            if (!Objects.equals(this.externalKey, _that.getExternalKey())) {
                return false;
            }
            if (!Objects.equals(this.globalKey, _that.getGlobalKey())) {
                return false;
            }
            if (!ListEquals.listEquals(this.key, _that.getKey())) {
                return false;
            }
            return Objects.equals(this.scheme, _that.getScheme());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.externalKey != null ? this.externalKey.hashCode() : 0);
            _result = 31 * _result + (this.globalKey != null ? this.globalKey.hashCode() : 0);
            _result = 31 * _result + (this.key != null ? this.key.hashCode() : 0);
            _result = 31 * _result + (this.scheme != null ? this.scheme.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "MetaFields {externalKey=" + this.externalKey + ", globalKey=" + this.globalKey + ", key=" + this.key + ", scheme=" + this.scheme + '}';
        }
    }

    public static interface MetaFieldsBuilder
    extends MetaFields,
    RosettaModelObjectBuilder,
    GlobalKeyFields.GlobalKeyFieldsBuilder,
    MetaDataFields.MetaDataFieldsBuilder {
        public Key.KeyBuilder getOrCreateKey(int var1);

        public List<? extends Key.KeyBuilder> getKey();

        public MetaFieldsBuilder setExternalKey(String var1);

        public MetaFieldsBuilder setGlobalKey(String var1);

        public MetaFieldsBuilder addKey(Key var1);

        public MetaFieldsBuilder addKey(Key var1, int var2);

        public MetaFieldsBuilder addKey(List<? extends Key> var1);

        public MetaFieldsBuilder setKey(List<? extends Key> var1);

        public MetaFieldsBuilder setScheme(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("externalKey"), String.class, (Object)this.getExternalKey(), (RosettaModelObjectBuilder)this, new AttributeMeta[]{AttributeMeta.META});
            processor.processBasic(path.newSubPath("globalKey"), String.class, (Object)this.getGlobalKey(), (RosettaModelObjectBuilder)this, new AttributeMeta[]{AttributeMeta.META});
            processor.processBasic(path.newSubPath("scheme"), String.class, (Object)this.getScheme(), (RosettaModelObjectBuilder)this, new AttributeMeta[]{AttributeMeta.META});
            this.processRosetta(path.newSubPath("key"), processor, Key.KeyBuilder.class, this.getKey(), new AttributeMeta[0]);
        }

        public MetaFieldsBuilder prune();
    }
}

