/*
 * Decompiled with CFR 0.152.
 */
package cdm.regulation;

import cdm.regulation.New;
import cdm.regulation.Pric;
import cdm.regulation.Qty;
import cdm.regulation.meta.TxMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface Tx
extends RosettaModelObject {
    public static final TxMeta metaData = new TxMeta();

    public Tx build();

    public TxBuilder toBuilder();

    public String getCtryOfBrnch();

    public New getNewTx();

    public Pric getPric();

    public Qty getQty();

    public String getTradDt();

    public String getTradVn();

    public String getTradgCpcty();

    default public RosettaMetaData<? extends Tx> metaData() {
        return metaData;
    }

    public static TxBuilder builder() {
        return new TxBuilderImpl();
    }

    default public Class<? extends Tx> getType() {
        return Tx.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("ctryOfBrnch"), String.class, (Object)this.getCtryOfBrnch(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("tradDt"), String.class, (Object)this.getTradDt(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("tradVn"), String.class, (Object)this.getTradVn(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("tradgCpcty"), String.class, (Object)this.getTradgCpcty(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("newTx"), processor, New.class, this.getNewTx(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("pric"), processor, Pric.class, this.getPric(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("qty"), processor, Qty.class, this.getQty(), new AttributeMeta[0]);
    }

    public static class TxBuilderImpl
    implements TxBuilder {
        protected String ctryOfBrnch;
        protected New.NewBuilder newTx;
        protected Pric.PricBuilder pric;
        protected Qty.QtyBuilder qty;
        protected String tradDt;
        protected String tradVn;
        protected String tradgCpcty;

        @Override
        public String getCtryOfBrnch() {
            return this.ctryOfBrnch;
        }

        @Override
        public New.NewBuilder getNewTx() {
            return this.newTx;
        }

        @Override
        public New.NewBuilder getOrCreateNewTx() {
            New.NewBuilder result = this.newTx != null ? this.newTx : (this.newTx = New.builder());
            return result;
        }

        @Override
        public Pric.PricBuilder getPric() {
            return this.pric;
        }

        @Override
        public Pric.PricBuilder getOrCreatePric() {
            Pric.PricBuilder result = this.pric != null ? this.pric : (this.pric = Pric.builder());
            return result;
        }

        @Override
        public Qty.QtyBuilder getQty() {
            return this.qty;
        }

        @Override
        public Qty.QtyBuilder getOrCreateQty() {
            Qty.QtyBuilder result = this.qty != null ? this.qty : (this.qty = Qty.builder());
            return result;
        }

        @Override
        public String getTradDt() {
            return this.tradDt;
        }

        @Override
        public String getTradVn() {
            return this.tradVn;
        }

        @Override
        public String getTradgCpcty() {
            return this.tradgCpcty;
        }

        @Override
        public TxBuilder setCtryOfBrnch(String ctryOfBrnch) {
            this.ctryOfBrnch = ctryOfBrnch == null ? null : ctryOfBrnch;
            return this;
        }

        @Override
        public TxBuilder setNewTx(New newTx) {
            this.newTx = newTx == null ? null : newTx.toBuilder();
            return this;
        }

        @Override
        public TxBuilder setPric(Pric pric) {
            this.pric = pric == null ? null : pric.toBuilder();
            return this;
        }

        @Override
        public TxBuilder setQty(Qty qty) {
            this.qty = qty == null ? null : qty.toBuilder();
            return this;
        }

        @Override
        public TxBuilder setTradDt(String tradDt) {
            this.tradDt = tradDt == null ? null : tradDt;
            return this;
        }

        @Override
        public TxBuilder setTradVn(String tradVn) {
            this.tradVn = tradVn == null ? null : tradVn;
            return this;
        }

        @Override
        public TxBuilder setTradgCpcty(String tradgCpcty) {
            this.tradgCpcty = tradgCpcty == null ? null : tradgCpcty;
            return this;
        }

        @Override
        public Tx build() {
            return new TxImpl(this);
        }

        @Override
        public TxBuilder toBuilder() {
            return this;
        }

        @Override
        public TxBuilder prune() {
            if (this.newTx != null && !this.newTx.prune().hasData()) {
                this.newTx = null;
            }
            if (this.pric != null && !this.pric.prune().hasData()) {
                this.pric = null;
            }
            if (this.qty != null && !this.qty.prune().hasData()) {
                this.qty = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getCtryOfBrnch() != null) {
                return true;
            }
            if (this.getNewTx() != null && this.getNewTx().hasData()) {
                return true;
            }
            if (this.getPric() != null && this.getPric().hasData()) {
                return true;
            }
            if (this.getQty() != null && this.getQty().hasData()) {
                return true;
            }
            if (this.getTradDt() != null) {
                return true;
            }
            if (this.getTradVn() != null) {
                return true;
            }
            return this.getTradgCpcty() != null;
        }

        public TxBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            TxBuilder o = (TxBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getNewTx(), (RosettaModelObjectBuilder)o.getNewTx(), this::setNewTx);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPric(), (RosettaModelObjectBuilder)o.getPric(), this::setPric);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getQty(), (RosettaModelObjectBuilder)o.getQty(), this::setQty);
            merger.mergeBasic((Object)this.getCtryOfBrnch(), (Object)o.getCtryOfBrnch(), this::setCtryOfBrnch, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTradDt(), (Object)o.getTradDt(), this::setTradDt, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTradVn(), (Object)o.getTradVn(), this::setTradVn, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTradgCpcty(), (Object)o.getTradgCpcty(), this::setTradgCpcty, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Tx _that = this.getType().cast(o);
            if (!Objects.equals(this.ctryOfBrnch, _that.getCtryOfBrnch())) {
                return false;
            }
            if (!Objects.equals(this.newTx, _that.getNewTx())) {
                return false;
            }
            if (!Objects.equals(this.pric, _that.getPric())) {
                return false;
            }
            if (!Objects.equals(this.qty, _that.getQty())) {
                return false;
            }
            if (!Objects.equals(this.tradDt, _that.getTradDt())) {
                return false;
            }
            if (!Objects.equals(this.tradVn, _that.getTradVn())) {
                return false;
            }
            return Objects.equals(this.tradgCpcty, _that.getTradgCpcty());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.ctryOfBrnch != null ? this.ctryOfBrnch.hashCode() : 0);
            _result = 31 * _result + (this.newTx != null ? this.newTx.hashCode() : 0);
            _result = 31 * _result + (this.pric != null ? this.pric.hashCode() : 0);
            _result = 31 * _result + (this.qty != null ? this.qty.hashCode() : 0);
            _result = 31 * _result + (this.tradDt != null ? this.tradDt.hashCode() : 0);
            _result = 31 * _result + (this.tradVn != null ? this.tradVn.hashCode() : 0);
            _result = 31 * _result + (this.tradgCpcty != null ? this.tradgCpcty.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TxBuilder {ctryOfBrnch=" + this.ctryOfBrnch + ", newTx=" + this.newTx + ", pric=" + this.pric + ", qty=" + this.qty + ", tradDt=" + this.tradDt + ", tradVn=" + this.tradVn + ", tradgCpcty=" + this.tradgCpcty + '}';
        }
    }

    public static class TxImpl
    implements Tx {
        private final String ctryOfBrnch;
        private final New newTx;
        private final Pric pric;
        private final Qty qty;
        private final String tradDt;
        private final String tradVn;
        private final String tradgCpcty;

        protected TxImpl(TxBuilder builder) {
            this.ctryOfBrnch = builder.getCtryOfBrnch();
            this.newTx = Optional.ofNullable(builder.getNewTx()).map(f -> f.build()).orElse(null);
            this.pric = Optional.ofNullable(builder.getPric()).map(f -> f.build()).orElse(null);
            this.qty = Optional.ofNullable(builder.getQty()).map(f -> f.build()).orElse(null);
            this.tradDt = builder.getTradDt();
            this.tradVn = builder.getTradVn();
            this.tradgCpcty = builder.getTradgCpcty();
        }

        @Override
        public String getCtryOfBrnch() {
            return this.ctryOfBrnch;
        }

        @Override
        public New getNewTx() {
            return this.newTx;
        }

        @Override
        public Pric getPric() {
            return this.pric;
        }

        @Override
        public Qty getQty() {
            return this.qty;
        }

        @Override
        public String getTradDt() {
            return this.tradDt;
        }

        @Override
        public String getTradVn() {
            return this.tradVn;
        }

        @Override
        public String getTradgCpcty() {
            return this.tradgCpcty;
        }

        @Override
        public Tx build() {
            return this;
        }

        @Override
        public TxBuilder toBuilder() {
            TxBuilder builder = Tx.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(TxBuilder builder) {
            Optional.ofNullable(this.getCtryOfBrnch()).ifPresent(builder::setCtryOfBrnch);
            Optional.ofNullable(this.getNewTx()).ifPresent(builder::setNewTx);
            Optional.ofNullable(this.getPric()).ifPresent(builder::setPric);
            Optional.ofNullable(this.getQty()).ifPresent(builder::setQty);
            Optional.ofNullable(this.getTradDt()).ifPresent(builder::setTradDt);
            Optional.ofNullable(this.getTradVn()).ifPresent(builder::setTradVn);
            Optional.ofNullable(this.getTradgCpcty()).ifPresent(builder::setTradgCpcty);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Tx _that = this.getType().cast(o);
            if (!Objects.equals(this.ctryOfBrnch, _that.getCtryOfBrnch())) {
                return false;
            }
            if (!Objects.equals(this.newTx, _that.getNewTx())) {
                return false;
            }
            if (!Objects.equals(this.pric, _that.getPric())) {
                return false;
            }
            if (!Objects.equals(this.qty, _that.getQty())) {
                return false;
            }
            if (!Objects.equals(this.tradDt, _that.getTradDt())) {
                return false;
            }
            if (!Objects.equals(this.tradVn, _that.getTradVn())) {
                return false;
            }
            return Objects.equals(this.tradgCpcty, _that.getTradgCpcty());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.ctryOfBrnch != null ? this.ctryOfBrnch.hashCode() : 0);
            _result = 31 * _result + (this.newTx != null ? this.newTx.hashCode() : 0);
            _result = 31 * _result + (this.pric != null ? this.pric.hashCode() : 0);
            _result = 31 * _result + (this.qty != null ? this.qty.hashCode() : 0);
            _result = 31 * _result + (this.tradDt != null ? this.tradDt.hashCode() : 0);
            _result = 31 * _result + (this.tradVn != null ? this.tradVn.hashCode() : 0);
            _result = 31 * _result + (this.tradgCpcty != null ? this.tradgCpcty.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Tx {ctryOfBrnch=" + this.ctryOfBrnch + ", newTx=" + this.newTx + ", pric=" + this.pric + ", qty=" + this.qty + ", tradDt=" + this.tradDt + ", tradVn=" + this.tradVn + ", tradgCpcty=" + this.tradgCpcty + '}';
        }
    }

    public static interface TxBuilder
    extends Tx,
    RosettaModelObjectBuilder {
        public New.NewBuilder getOrCreateNewTx();

        @Override
        public New.NewBuilder getNewTx();

        public Pric.PricBuilder getOrCreatePric();

        @Override
        public Pric.PricBuilder getPric();

        public Qty.QtyBuilder getOrCreateQty();

        @Override
        public Qty.QtyBuilder getQty();

        public TxBuilder setCtryOfBrnch(String var1);

        public TxBuilder setNewTx(New var1);

        public TxBuilder setPric(Pric var1);

        public TxBuilder setQty(Qty var1);

        public TxBuilder setTradDt(String var1);

        public TxBuilder setTradVn(String var1);

        public TxBuilder setTradgCpcty(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("ctryOfBrnch"), String.class, (Object)this.getCtryOfBrnch(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("tradDt"), String.class, (Object)this.getTradDt(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("tradVn"), String.class, (Object)this.getTradVn(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("tradgCpcty"), String.class, (Object)this.getTradgCpcty(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("newTx"), processor, New.NewBuilder.class, this.getNewTx(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("pric"), processor, Pric.PricBuilder.class, this.getPric(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("qty"), processor, Qty.QtyBuilder.class, this.getQty(), new AttributeMeta[0]);
        }

        public TxBuilder prune();
    }
}

