/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template.validation.datarule;

import cdm.product.template.TradableProduct;
import cdm.product.template.functions.PriceQuantityTriangulation;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="TradableProductPriceQuantityTriangulation")
@ImplementedBy(value=Default.class)
public interface TradableProductPriceQuantityTriangulation
extends Validator<TradableProduct> {
    public static final String NAME = "TradableProductPriceQuantityTriangulation";
    public static final String DEFINITION = "PriceQuantityTriangulation( tradeLot ) = True";

    public ValidationResult<TradableProduct> validate(RosettaPath var1, TradableProduct var2);

    public static class NoOp
    implements TradableProductPriceQuantityTriangulation {
        @Override
        public ValidationResult<TradableProduct> validate(RosettaPath path, TradableProduct tradableProduct) {
            return ValidationResult.success((String)TradableProductPriceQuantityTriangulation.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"TradableProduct", (RosettaPath)path, (String)TradableProductPriceQuantityTriangulation.DEFINITION);
        }
    }

    public static class Default
    implements TradableProductPriceQuantityTriangulation {
        @Inject
        protected PriceQuantityTriangulation priceQuantityTriangulation;

        @Override
        public ValidationResult<TradableProduct> validate(RosettaPath path, TradableProduct tradableProduct) {
            ComparisonResult result = this.executeDataRule(tradableProduct);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)TradableProductPriceQuantityTriangulation.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"TradableProduct", (RosettaPath)path, (String)TradableProductPriceQuantityTriangulation.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition TradableProductPriceQuantityTriangulation failed.";
            }
            return ValidationResult.failure((String)TradableProductPriceQuantityTriangulation.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"TradableProduct", (RosettaPath)path, (String)TradableProductPriceQuantityTriangulation.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(TradableProduct tradableProduct) {
            try {
                ComparisonResult result = ExpressionOperators.areEqual((Mapper)MapperS.of((Object)this.priceQuantityTriangulation.evaluate(MapperS.of((Object)tradableProduct).mapC("getTradeLot", _tradableProduct -> _tradableProduct.getTradeLot()).getMulti())), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All);
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

