/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template.validation.datarule;

import cdm.product.template.TradableProduct;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="TradableProductNotionalAdjustment")
@ImplementedBy(value=Default.class)
public interface TradableProductNotionalAdjustment
extends Validator<TradableProduct> {
    public static final String NAME = "TradableProductNotionalAdjustment";
    public static final String DEFINITION = "if adjustment exists then product -> contractualProduct -> economicTerms -> payout -> performancePayout -> returnTerms -> priceReturnTerms exists or product -> contractualProduct -> economicTerms -> payout -> performancePayout exists";

    public ValidationResult<TradableProduct> validate(RosettaPath var1, TradableProduct var2);

    public static class NoOp
    implements TradableProductNotionalAdjustment {
        @Override
        public ValidationResult<TradableProduct> validate(RosettaPath path, TradableProduct tradableProduct) {
            return ValidationResult.success((String)TradableProductNotionalAdjustment.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"TradableProduct", (RosettaPath)path, (String)TradableProductNotionalAdjustment.DEFINITION);
        }
    }

    public static class Default
    implements TradableProductNotionalAdjustment {
        @Override
        public ValidationResult<TradableProduct> validate(RosettaPath path, TradableProduct tradableProduct) {
            ComparisonResult result = this.executeDataRule(tradableProduct);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)TradableProductNotionalAdjustment.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"TradableProduct", (RosettaPath)path, (String)TradableProductNotionalAdjustment.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition TradableProductNotionalAdjustment failed.";
            }
            return ValidationResult.failure((String)TradableProductNotionalAdjustment.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"TradableProduct", (RosettaPath)path, (String)TradableProductNotionalAdjustment.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(TradableProduct tradableProduct) {
            try {
                ComparisonResult result = MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.exists((Mapper)MapperS.of((Object)tradableProduct).map("getAdjustment", _tradableProduct -> _tradableProduct.getAdjustment())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.exists((Mapper)MapperS.of((Object)tradableProduct).map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).map("getReturnTerms", performancePayout -> performancePayout.getReturnTerms()).map("getPriceReturnTerms", returnTerms -> returnTerms.getPriceReturnTerms())).or(ExpressionOperators.exists((Mapper)MapperS.of((Object)tradableProduct).map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getPerformancePayout", payout -> payout.getPerformancePayout())));
                    }
                    return MapperS.ofNull();
                }));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

