/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template.validation.datarule;

import cdm.base.staticdata.party.AncillaryRoleEnum;
import cdm.product.template.TradableProduct;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="TradableProductForwardPayout_PredeterminedClearingOrganizationParty")
@ImplementedBy(value=Default.class)
public interface TradableProductForwardPayoutPredeterminedClearingOrganizationParty
extends Validator<TradableProduct> {
    public static final String NAME = "TradableProductForwardPayout_PredeterminedClearingOrganizationParty";
    public static final String DEFINITION = "if product -> contractualProduct -> economicTerms -> payout -> forwardPayout -> settlementTerms -> physicalSettlementTerms -> predeterminedClearingOrganizationParty exists then ancillaryParty -> role contains AncillaryRoleEnum -> PredeterminedClearingOrganizationParty";

    public ValidationResult<TradableProduct> validate(RosettaPath var1, TradableProduct var2);

    public static class NoOp
    implements TradableProductForwardPayoutPredeterminedClearingOrganizationParty {
        @Override
        public ValidationResult<TradableProduct> validate(RosettaPath path, TradableProduct tradableProduct) {
            return ValidationResult.success((String)TradableProductForwardPayoutPredeterminedClearingOrganizationParty.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"TradableProduct", (RosettaPath)path, (String)TradableProductForwardPayoutPredeterminedClearingOrganizationParty.DEFINITION);
        }
    }

    public static class Default
    implements TradableProductForwardPayoutPredeterminedClearingOrganizationParty {
        @Override
        public ValidationResult<TradableProduct> validate(RosettaPath path, TradableProduct tradableProduct) {
            ComparisonResult result = this.executeDataRule(tradableProduct);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)TradableProductForwardPayoutPredeterminedClearingOrganizationParty.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"TradableProduct", (RosettaPath)path, (String)TradableProductForwardPayoutPredeterminedClearingOrganizationParty.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition TradableProductForwardPayout_PredeterminedClearingOrganizationParty failed.";
            }
            return ValidationResult.failure((String)TradableProductForwardPayoutPredeterminedClearingOrganizationParty.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"TradableProduct", (RosettaPath)path, (String)TradableProductForwardPayoutPredeterminedClearingOrganizationParty.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(TradableProduct tradableProduct) {
            try {
                ComparisonResult result = MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.exists((Mapper)MapperS.of((Object)tradableProduct).map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getForwardPayout", payout -> payout.getForwardPayout()).map("getSettlementTerms", payoutBase -> payoutBase.getSettlementTerms()).map("getPhysicalSettlementTerms", settlementTerms -> settlementTerms.getPhysicalSettlementTerms()).map("getPredeterminedClearingOrganizationParty", physicalSettlementTerms -> physicalSettlementTerms.getPredeterminedClearingOrganizationParty())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.contains((Mapper)MapperS.of((Object)tradableProduct).mapC("getAncillaryParty", _tradableProduct -> _tradableProduct.getAncillaryParty()).map("getRole", ancillaryParty -> ancillaryParty.getRole()), (Mapper)MapperS.of((Object)((Object)AncillaryRoleEnum.PREDETERMINED_CLEARING_ORGANIZATION_PARTY)));
                    }
                    return MapperS.ofNull();
                }));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

