/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template.validation.datarule;

import cdm.base.staticdata.party.AncillaryRoleEnum;
import cdm.product.template.TradableProduct;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="TradableProductExerciseNoticeReceiverPartyManual")
@ImplementedBy(value=Default.class)
public interface TradableProductExerciseNoticeReceiverPartyManual
extends Validator<TradableProduct> {
    public static final String NAME = "TradableProductExerciseNoticeReceiverPartyManual";
    public static final String DEFINITION = "if product -> contractualProduct -> economicTerms -> payout -> optionPayout -> exerciseTerms -> exerciseProcedure -> manualExercise -> exerciseNotice -> exerciseNoticeReceiver exists then ancillaryParty -> role contains AncillaryRoleEnum -> ExerciseNoticeReceiverPartyManual and if ancillaryParty -> role contains AncillaryRoleEnum -> ExerciseNoticeReceiverPartyManual then product -> contractualProduct -> economicTerms -> payout -> optionPayout -> exerciseTerms -> exerciseProcedure -> manualExercise -> exerciseNotice -> exerciseNoticeReceiver exists";

    public ValidationResult<TradableProduct> validate(RosettaPath var1, TradableProduct var2);

    public static class NoOp
    implements TradableProductExerciseNoticeReceiverPartyManual {
        @Override
        public ValidationResult<TradableProduct> validate(RosettaPath path, TradableProduct tradableProduct) {
            return ValidationResult.success((String)TradableProductExerciseNoticeReceiverPartyManual.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"TradableProduct", (RosettaPath)path, (String)TradableProductExerciseNoticeReceiverPartyManual.DEFINITION);
        }
    }

    public static class Default
    implements TradableProductExerciseNoticeReceiverPartyManual {
        @Override
        public ValidationResult<TradableProduct> validate(RosettaPath path, TradableProduct tradableProduct) {
            ComparisonResult result = this.executeDataRule(tradableProduct);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)TradableProductExerciseNoticeReceiverPartyManual.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"TradableProduct", (RosettaPath)path, (String)TradableProductExerciseNoticeReceiverPartyManual.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition TradableProductExerciseNoticeReceiverPartyManual failed.";
            }
            return ValidationResult.failure((String)TradableProductExerciseNoticeReceiverPartyManual.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"TradableProduct", (RosettaPath)path, (String)TradableProductExerciseNoticeReceiverPartyManual.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(TradableProduct tradableProduct) {
            try {
                ComparisonResult result = MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.exists((Mapper)MapperS.of((Object)tradableProduct).map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).map("getExerciseTerms", optionPayout -> optionPayout.getExerciseTerms()).map("getExerciseProcedure", optionExercise -> optionExercise.getExerciseProcedure()).map("getManualExercise", exerciseProcedure -> exerciseProcedure.getManualExercise()).map("getExerciseNotice", manualExercise -> manualExercise.getExerciseNotice()).map("getExerciseNoticeReceiver", exerciseNotice -> exerciseNotice.getExerciseNoticeReceiver())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.contains((Mapper)MapperS.of((Object)tradableProduct).mapC("getAncillaryParty", _tradableProduct -> _tradableProduct.getAncillaryParty()).map("getRole", ancillaryParty -> ancillaryParty.getRole()), (Mapper)MapperS.of((Object)((Object)AncillaryRoleEnum.EXERCISE_NOTICE_RECEIVER_PARTY_MANUAL))).and(MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                            if (ExpressionOperators.contains((Mapper)MapperS.of((Object)tradableProduct).mapC("getAncillaryParty", _tradableProduct -> _tradableProduct.getAncillaryParty()).map("getRole", ancillaryParty -> ancillaryParty.getRole()), (Mapper)MapperS.of((Object)((Object)AncillaryRoleEnum.EXERCISE_NOTICE_RECEIVER_PARTY_MANUAL))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                                return ExpressionOperators.exists((Mapper)MapperS.of((Object)tradableProduct).map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).map("getExerciseTerms", optionPayout -> optionPayout.getExerciseTerms()).map("getExerciseProcedure", optionExercise -> optionExercise.getExerciseProcedure()).map("getManualExercise", exerciseProcedure -> exerciseProcedure.getManualExercise()).map("getExerciseNotice", manualExercise -> manualExercise.getExerciseNotice()).map("getExerciseNoticeReceiver", exerciseNotice -> exerciseNotice.getExerciseNoticeReceiver()));
                            }
                            return MapperS.ofNull();
                        })));
                    }
                    return MapperS.ofNull();
                }));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

