/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template.validation.datarule;

import cdm.base.staticdata.party.AncillaryRoleEnum;
import cdm.product.template.TradableProduct;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="TradableProductCalculationAgentIndependent")
@ImplementedBy(value=Default.class)
public interface TradableProductCalculationAgentIndependent
extends Validator<TradableProduct> {
    public static final String NAME = "TradableProductCalculationAgentIndependent";
    public static final String DEFINITION = "if product -> contractualProduct -> economicTerms -> calculationAgent -> calculationAgentParty exists then ancillaryParty -> role contains AncillaryRoleEnum -> CalculationAgentIndependent and if ancillaryParty -> role contains AncillaryRoleEnum -> CalculationAgentIndependent then product -> contractualProduct -> economicTerms -> calculationAgent -> calculationAgentParty exists";

    public ValidationResult<TradableProduct> validate(RosettaPath var1, TradableProduct var2);

    public static class NoOp
    implements TradableProductCalculationAgentIndependent {
        @Override
        public ValidationResult<TradableProduct> validate(RosettaPath path, TradableProduct tradableProduct) {
            return ValidationResult.success((String)TradableProductCalculationAgentIndependent.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"TradableProduct", (RosettaPath)path, (String)TradableProductCalculationAgentIndependent.DEFINITION);
        }
    }

    public static class Default
    implements TradableProductCalculationAgentIndependent {
        @Override
        public ValidationResult<TradableProduct> validate(RosettaPath path, TradableProduct tradableProduct) {
            ComparisonResult result = this.executeDataRule(tradableProduct);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)TradableProductCalculationAgentIndependent.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"TradableProduct", (RosettaPath)path, (String)TradableProductCalculationAgentIndependent.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition TradableProductCalculationAgentIndependent failed.";
            }
            return ValidationResult.failure((String)TradableProductCalculationAgentIndependent.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"TradableProduct", (RosettaPath)path, (String)TradableProductCalculationAgentIndependent.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(TradableProduct tradableProduct) {
            try {
                ComparisonResult result = MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.exists((Mapper)MapperS.of((Object)tradableProduct).map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getCalculationAgent", economicTerms -> economicTerms.getCalculationAgent()).map("getCalculationAgentParty", calculationAgent -> calculationAgent.getCalculationAgentParty())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.contains((Mapper)MapperS.of((Object)tradableProduct).mapC("getAncillaryParty", _tradableProduct -> _tradableProduct.getAncillaryParty()).map("getRole", ancillaryParty -> ancillaryParty.getRole()), (Mapper)MapperS.of((Object)((Object)AncillaryRoleEnum.CALCULATION_AGENT_INDEPENDENT))).and(MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                            if (ExpressionOperators.contains((Mapper)MapperS.of((Object)tradableProduct).mapC("getAncillaryParty", _tradableProduct -> _tradableProduct.getAncillaryParty()).map("getRole", ancillaryParty -> ancillaryParty.getRole()), (Mapper)MapperS.of((Object)((Object)AncillaryRoleEnum.CALCULATION_AGENT_INDEPENDENT))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                                return ExpressionOperators.exists((Mapper)MapperS.of((Object)tradableProduct).map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getCalculationAgent", economicTerms -> economicTerms.getCalculationAgent()).map("getCalculationAgentParty", calculationAgent -> calculationAgent.getCalculationAgentParty()));
                            }
                            return MapperS.ofNull();
                        })));
                    }
                    return MapperS.ofNull();
                }));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

