/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template.validation.datarule;

import cdm.product.asset.ReturnTypeEnum;
import cdm.product.template.ReturnTerms;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;

@RosettaDataRule(value="ReturnTermsReturnTermsExists")
@ImplementedBy(value=Default.class)
public interface ReturnTermsReturnTermsExists
extends Validator<ReturnTerms> {
    public static final String NAME = "ReturnTermsReturnTermsExists";
    public static final String DEFINITION = "if priceReturnTerms -> returnType = ReturnTypeEnum -> Total then (priceReturnTerms, dividendReturnTerms) only exists else if priceReturnTerms -> returnType = ReturnTypeEnum -> Price then priceReturnTerms only exists else priceReturnTerms only exists or dividendReturnTerms only exists or varianceReturnTerms only exists or volatilityReturnTerms only exists or correlationReturnTerms only exists";

    public ValidationResult<ReturnTerms> validate(RosettaPath var1, ReturnTerms var2);

    public static class NoOp
    implements ReturnTermsReturnTermsExists {
        @Override
        public ValidationResult<ReturnTerms> validate(RosettaPath path, ReturnTerms returnTerms) {
            return ValidationResult.success((String)ReturnTermsReturnTermsExists.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ReturnTerms", (RosettaPath)path, (String)ReturnTermsReturnTermsExists.DEFINITION);
        }
    }

    public static class Default
    implements ReturnTermsReturnTermsExists {
        @Override
        public ValidationResult<ReturnTerms> validate(RosettaPath path, ReturnTerms returnTerms) {
            ComparisonResult result = this.executeDataRule(returnTerms);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)ReturnTermsReturnTermsExists.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ReturnTerms", (RosettaPath)path, (String)ReturnTermsReturnTermsExists.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition ReturnTermsReturnTermsExists failed.";
            }
            return ValidationResult.failure((String)ReturnTermsReturnTermsExists.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ReturnTerms", (RosettaPath)path, (String)ReturnTermsReturnTermsExists.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(ReturnTerms returnTerms) {
            try {
                ComparisonResult result = MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)returnTerms).map("getPriceReturnTerms", _returnTerms -> _returnTerms.getPriceReturnTerms()).map("getReturnType", priceReturnTerms -> priceReturnTerms.getReturnType()), (Mapper)MapperS.of((Object)((Object)ReturnTypeEnum.TOTAL)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.onlyExists(Arrays.asList(MapperS.of((Object)returnTerms).map("getPriceReturnTerms", _returnTerms -> _returnTerms.getPriceReturnTerms()), MapperS.of((Object)returnTerms).map("getDividendReturnTerms", _returnTerms -> _returnTerms.getDividendReturnTerms())));
                    }
                    if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)returnTerms).map("getPriceReturnTerms", _returnTerms -> _returnTerms.getPriceReturnTerms()).map("getReturnType", priceReturnTerms -> priceReturnTerms.getReturnType()), (Mapper)MapperS.of((Object)((Object)ReturnTypeEnum.PRICE)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.onlyExists(Arrays.asList(MapperS.of((Object)returnTerms).map("getPriceReturnTerms", _returnTerms -> _returnTerms.getPriceReturnTerms())));
                    }
                    return ExpressionOperators.onlyExists(Arrays.asList(MapperS.of((Object)returnTerms).map("getPriceReturnTerms", _returnTerms -> _returnTerms.getPriceReturnTerms()))).or(ExpressionOperators.onlyExists(Arrays.asList(MapperS.of((Object)returnTerms).map("getDividendReturnTerms", _returnTerms -> _returnTerms.getDividendReturnTerms())))).or(ExpressionOperators.onlyExists(Arrays.asList(MapperS.of((Object)returnTerms).map("getVarianceReturnTerms", _returnTerms -> _returnTerms.getVarianceReturnTerms())))).or(ExpressionOperators.onlyExists(Arrays.asList(MapperS.of((Object)returnTerms).map("getVolatilityReturnTerms", _returnTerms -> _returnTerms.getVolatilityReturnTerms())))).or(ExpressionOperators.onlyExists(Arrays.asList(MapperS.of((Object)returnTerms).map("getCorrelationReturnTerms", _returnTerms -> _returnTerms.getCorrelationReturnTerms())))).asMapper();
                }));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

