/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template.validation.datarule;

import cdm.product.template.PerformancePayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="PerformancePayoutNoSharePriceDividendAdjustmentForeignExchange")
@ImplementedBy(value=Default.class)
public interface PerformancePayoutNoSharePriceDividendAdjustmentForeignExchange
extends Validator<PerformancePayout> {
    public static final String NAME = "PerformancePayoutNoSharePriceDividendAdjustmentForeignExchange";
    public static final String DEFINITION = "if underlier -> foreignExchange exists then returnTerms -> varianceReturnTerms -> sharePriceDividendAdjustment is absent and returnTerms -> volatilityReturnTerms -> sharePriceDividendAdjustment is absent";

    public ValidationResult<PerformancePayout> validate(RosettaPath var1, PerformancePayout var2);

    public static class NoOp
    implements PerformancePayoutNoSharePriceDividendAdjustmentForeignExchange {
        @Override
        public ValidationResult<PerformancePayout> validate(RosettaPath path, PerformancePayout performancePayout) {
            return ValidationResult.success((String)PerformancePayoutNoSharePriceDividendAdjustmentForeignExchange.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PerformancePayout", (RosettaPath)path, (String)PerformancePayoutNoSharePriceDividendAdjustmentForeignExchange.DEFINITION);
        }
    }

    public static class Default
    implements PerformancePayoutNoSharePriceDividendAdjustmentForeignExchange {
        @Override
        public ValidationResult<PerformancePayout> validate(RosettaPath path, PerformancePayout performancePayout) {
            ComparisonResult result = this.executeDataRule(performancePayout);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)PerformancePayoutNoSharePriceDividendAdjustmentForeignExchange.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PerformancePayout", (RosettaPath)path, (String)PerformancePayoutNoSharePriceDividendAdjustmentForeignExchange.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition PerformancePayoutNoSharePriceDividendAdjustmentForeignExchange failed.";
            }
            return ValidationResult.failure((String)PerformancePayoutNoSharePriceDividendAdjustmentForeignExchange.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PerformancePayout", (RosettaPath)path, (String)PerformancePayoutNoSharePriceDividendAdjustmentForeignExchange.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(PerformancePayout performancePayout) {
            try {
                ComparisonResult result = MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.exists((Mapper)MapperS.of((Object)performancePayout).map("getUnderlier", _performancePayout -> _performancePayout.getUnderlier()).map("getForeignExchange", product -> product.getForeignExchange())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.notExists((Mapper)MapperS.of((Object)performancePayout).map("getReturnTerms", _performancePayout -> _performancePayout.getReturnTerms()).map("getVarianceReturnTerms", returnTerms -> returnTerms.getVarianceReturnTerms()).map("getSharePriceDividendAdjustment", returnTermsBase -> returnTermsBase.getSharePriceDividendAdjustment())).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)performancePayout).map("getReturnTerms", _performancePayout -> _performancePayout.getReturnTerms()).map("getVolatilityReturnTerms", returnTerms -> returnTerms.getVolatilityReturnTerms()).map("getSharePriceDividendAdjustment", returnTermsBase -> returnTermsBase.getSharePriceDividendAdjustment())));
                    }
                    return MapperS.ofNull();
                }));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

