/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template.validation.datarule;

import cdm.product.qualification.functions.Qualify_UnderlierProduct_Equity;
import cdm.product.template.PerformancePayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="PerformancePayoutEquitySpecificAttributes")
@ImplementedBy(value=Default.class)
public interface PerformancePayoutEquitySpecificAttributes
extends Validator<PerformancePayout> {
    public static final String NAME = "PerformancePayoutEquitySpecificAttributes";
    public static final String DEFINITION = "if Qualify_UnderlierProduct_Equity( underlier ) = False then returnTerms -> varianceReturnTerms -> dividendApplicability is absent and returnTerms -> varianceReturnTerms -> equityUnderlierProvisions is absent and returnTerms -> varianceReturnTerms -> sharePriceDividendAdjustment is absent and returnTerms -> volatilityReturnTerms -> dividendApplicability is absent and returnTerms -> volatilityReturnTerms -> equityUnderlierProvisions is absent and returnTerms -> volatilityReturnTerms -> sharePriceDividendAdjustment is absent and returnTerms -> correlationReturnTerms -> dividendApplicability is absent and returnTerms -> correlationReturnTerms -> equityUnderlierProvisions is absent and returnTerms -> correlationReturnTerms -> sharePriceDividendAdjustment is absent";

    public ValidationResult<PerformancePayout> validate(RosettaPath var1, PerformancePayout var2);

    public static class NoOp
    implements PerformancePayoutEquitySpecificAttributes {
        @Override
        public ValidationResult<PerformancePayout> validate(RosettaPath path, PerformancePayout performancePayout) {
            return ValidationResult.success((String)PerformancePayoutEquitySpecificAttributes.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PerformancePayout", (RosettaPath)path, (String)PerformancePayoutEquitySpecificAttributes.DEFINITION);
        }
    }

    public static class Default
    implements PerformancePayoutEquitySpecificAttributes {
        @Inject
        protected Qualify_UnderlierProduct_Equity qualify_UnderlierProduct_Equity;

        @Override
        public ValidationResult<PerformancePayout> validate(RosettaPath path, PerformancePayout performancePayout) {
            ComparisonResult result = this.executeDataRule(performancePayout);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)PerformancePayoutEquitySpecificAttributes.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PerformancePayout", (RosettaPath)path, (String)PerformancePayoutEquitySpecificAttributes.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition PerformancePayoutEquitySpecificAttributes failed.";
            }
            return ValidationResult.failure((String)PerformancePayoutEquitySpecificAttributes.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PerformancePayout", (RosettaPath)path, (String)PerformancePayoutEquitySpecificAttributes.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(PerformancePayout performancePayout) {
            try {
                ComparisonResult result = MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)this.qualify_UnderlierProduct_Equity.evaluate((Product)MapperS.of((Object)performancePayout).map("getUnderlier", _performancePayout -> _performancePayout.getUnderlier()).get())), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.notExists((Mapper)MapperS.of((Object)performancePayout).map("getReturnTerms", _performancePayout -> _performancePayout.getReturnTerms()).map("getVarianceReturnTerms", returnTerms -> returnTerms.getVarianceReturnTerms()).map("getDividendApplicability", returnTermsBase -> returnTermsBase.getDividendApplicability())).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)performancePayout).map("getReturnTerms", _performancePayout -> _performancePayout.getReturnTerms()).map("getVarianceReturnTerms", returnTerms -> returnTerms.getVarianceReturnTerms()).map("getEquityUnderlierProvisions", returnTermsBase -> returnTermsBase.getEquityUnderlierProvisions()))).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)performancePayout).map("getReturnTerms", _performancePayout -> _performancePayout.getReturnTerms()).map("getVarianceReturnTerms", returnTerms -> returnTerms.getVarianceReturnTerms()).map("getSharePriceDividendAdjustment", returnTermsBase -> returnTermsBase.getSharePriceDividendAdjustment()))).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)performancePayout).map("getReturnTerms", _performancePayout -> _performancePayout.getReturnTerms()).map("getVolatilityReturnTerms", returnTerms -> returnTerms.getVolatilityReturnTerms()).map("getDividendApplicability", returnTermsBase -> returnTermsBase.getDividendApplicability()))).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)performancePayout).map("getReturnTerms", _performancePayout -> _performancePayout.getReturnTerms()).map("getVolatilityReturnTerms", returnTerms -> returnTerms.getVolatilityReturnTerms()).map("getEquityUnderlierProvisions", returnTermsBase -> returnTermsBase.getEquityUnderlierProvisions()))).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)performancePayout).map("getReturnTerms", _performancePayout -> _performancePayout.getReturnTerms()).map("getVolatilityReturnTerms", returnTerms -> returnTerms.getVolatilityReturnTerms()).map("getSharePriceDividendAdjustment", returnTermsBase -> returnTermsBase.getSharePriceDividendAdjustment()))).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)performancePayout).map("getReturnTerms", _performancePayout -> _performancePayout.getReturnTerms()).map("getCorrelationReturnTerms", returnTerms -> returnTerms.getCorrelationReturnTerms()).map("getDividendApplicability", returnTermsBase -> returnTermsBase.getDividendApplicability()))).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)performancePayout).map("getReturnTerms", _performancePayout -> _performancePayout.getReturnTerms()).map("getCorrelationReturnTerms", returnTerms -> returnTerms.getCorrelationReturnTerms()).map("getEquityUnderlierProvisions", returnTermsBase -> returnTermsBase.getEquityUnderlierProvisions()))).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)performancePayout).map("getReturnTerms", _performancePayout -> _performancePayout.getReturnTerms()).map("getCorrelationReturnTerms", returnTerms -> returnTerms.getCorrelationReturnTerms()).map("getSharePriceDividendAdjustment", returnTermsBase -> returnTermsBase.getSharePriceDividendAdjustment())));
                    }
                    return MapperS.ofNull();
                }));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

