/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template.validation.datarule;

import cdm.product.template.Payout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="PayoutNotionalResetInterestRatePayoutExists")
@ImplementedBy(value=Default.class)
public interface PayoutNotionalResetInterestRatePayoutExists
extends Validator<Payout> {
    public static final String NAME = "PayoutNotionalResetInterestRatePayoutExists";
    public static final String DEFINITION = "if performancePayout -> priceQuantity -> reset contains True then interestRatePayout exists";

    public ValidationResult<Payout> validate(RosettaPath var1, Payout var2);

    public static class NoOp
    implements PayoutNotionalResetInterestRatePayoutExists {
        @Override
        public ValidationResult<Payout> validate(RosettaPath path, Payout payout) {
            return ValidationResult.success((String)PayoutNotionalResetInterestRatePayoutExists.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Payout", (RosettaPath)path, (String)PayoutNotionalResetInterestRatePayoutExists.DEFINITION);
        }
    }

    public static class Default
    implements PayoutNotionalResetInterestRatePayoutExists {
        @Override
        public ValidationResult<Payout> validate(RosettaPath path, Payout payout) {
            ComparisonResult result = this.executeDataRule(payout);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)PayoutNotionalResetInterestRatePayoutExists.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Payout", (RosettaPath)path, (String)PayoutNotionalResetInterestRatePayoutExists.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition PayoutNotionalResetInterestRatePayoutExists failed.";
            }
            return ValidationResult.failure((String)PayoutNotionalResetInterestRatePayoutExists.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Payout", (RosettaPath)path, (String)PayoutNotionalResetInterestRatePayoutExists.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(Payout payout) {
            try {
                ComparisonResult result = MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.contains((Mapper)MapperS.of((Object)payout).mapC("getPerformancePayout", _payout -> _payout.getPerformancePayout()).map("getPriceQuantity", payoutBase -> payoutBase.getPriceQuantity()).map("getReset", resolvablePriceQuantity -> resolvablePriceQuantity.getReset()), (Mapper)MapperS.of((Object)true)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.exists((Mapper)MapperS.of((Object)payout).mapC("getInterestRatePayout", _payout -> _payout.getInterestRatePayout()));
                    }
                    return MapperS.ofNull();
                }));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

