/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template.validation.datarule;

import cdm.product.template.Payout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="PayoutLastRegularPaymentDate")
@ImplementedBy(value=Default.class)
public interface PayoutLastRegularPaymentDate
extends Validator<Payout> {
    public static final String NAME = "PayoutLastRegularPaymentDate";
    public static final String DEFINITION = "if interestRatePayout -> paymentDates -> lastRegularPaymentDate exists and interestRatePayout -> stubPeriod -> finalStub exists then interestRatePayout count = 2";

    public ValidationResult<Payout> validate(RosettaPath var1, Payout var2);

    public static class NoOp
    implements PayoutLastRegularPaymentDate {
        @Override
        public ValidationResult<Payout> validate(RosettaPath path, Payout payout) {
            return ValidationResult.success((String)PayoutLastRegularPaymentDate.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Payout", (RosettaPath)path, (String)PayoutLastRegularPaymentDate.DEFINITION);
        }
    }

    public static class Default
    implements PayoutLastRegularPaymentDate {
        @Override
        public ValidationResult<Payout> validate(RosettaPath path, Payout payout) {
            ComparisonResult result = this.executeDataRule(payout);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)PayoutLastRegularPaymentDate.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Payout", (RosettaPath)path, (String)PayoutLastRegularPaymentDate.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition PayoutLastRegularPaymentDate failed.";
            }
            return ValidationResult.failure((String)PayoutLastRegularPaymentDate.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Payout", (RosettaPath)path, (String)PayoutLastRegularPaymentDate.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(Payout payout) {
            try {
                ComparisonResult result = MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.exists((Mapper)MapperS.of((Object)payout).mapC("getInterestRatePayout", _payout -> _payout.getInterestRatePayout()).map("getPaymentDates", interestRatePayout -> interestRatePayout.getPaymentDates()).map("getLastRegularPaymentDate", paymentDates -> paymentDates.getLastRegularPaymentDate())).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)payout).mapC("getInterestRatePayout", _payout -> _payout.getInterestRatePayout()).map("getStubPeriod", interestRatePayout -> interestRatePayout.getStubPeriod()).map("getFinalStub", stubPeriod -> stubPeriod.getFinalStub()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.areEqual((Mapper)MapperS.of((Object)MapperS.of((Object)payout).mapC("getInterestRatePayout", _payout -> _payout.getInterestRatePayout()).resultCount()), (Mapper)MapperS.of((Object)2), (CardinalityOperator)CardinalityOperator.All);
                    }
                    return MapperS.ofNull();
                }));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

