/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template.validation.datarule;

import cdm.base.staticdata.party.AncillaryRoleEnum;
import cdm.product.template.EconomicTerms;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="EconomicTermsIndependentCalculationAgent")
@ImplementedBy(value=Default.class)
public interface EconomicTermsIndependentCalculationAgent
extends Validator<EconomicTerms> {
    public static final String NAME = "EconomicTermsIndependentCalculationAgent";
    public static final String DEFINITION = "if calculationAgent -> calculationAgentParty exists then calculationAgent -> calculationAgentParty = AncillaryRoleEnum -> CalculationAgentIndependent";

    public ValidationResult<EconomicTerms> validate(RosettaPath var1, EconomicTerms var2);

    public static class NoOp
    implements EconomicTermsIndependentCalculationAgent {
        @Override
        public ValidationResult<EconomicTerms> validate(RosettaPath path, EconomicTerms economicTerms) {
            return ValidationResult.success((String)EconomicTermsIndependentCalculationAgent.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"EconomicTerms", (RosettaPath)path, (String)EconomicTermsIndependentCalculationAgent.DEFINITION);
        }
    }

    public static class Default
    implements EconomicTermsIndependentCalculationAgent {
        @Override
        public ValidationResult<EconomicTerms> validate(RosettaPath path, EconomicTerms economicTerms) {
            ComparisonResult result = this.executeDataRule(economicTerms);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)EconomicTermsIndependentCalculationAgent.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"EconomicTerms", (RosettaPath)path, (String)EconomicTermsIndependentCalculationAgent.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition EconomicTermsIndependentCalculationAgent failed.";
            }
            return ValidationResult.failure((String)EconomicTermsIndependentCalculationAgent.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"EconomicTerms", (RosettaPath)path, (String)EconomicTermsIndependentCalculationAgent.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(EconomicTerms economicTerms) {
            try {
                ComparisonResult result = MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.exists((Mapper)MapperS.of((Object)economicTerms).map("getCalculationAgent", _economicTerms -> _economicTerms.getCalculationAgent()).map("getCalculationAgentParty", calculationAgent -> calculationAgent.getCalculationAgentParty())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.areEqual((Mapper)MapperS.of((Object)economicTerms).map("getCalculationAgent", _economicTerms -> _economicTerms.getCalculationAgent()).map("getCalculationAgentParty", calculationAgent -> calculationAgent.getCalculationAgentParty()), (Mapper)MapperS.of((Object)((Object)AncillaryRoleEnum.CALCULATION_AGENT_INDEPENDENT)), (CardinalityOperator)CardinalityOperator.All);
                    }
                    return MapperS.ofNull();
                }));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

