/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template.validation.datarule;

import cdm.product.template.EconomicTerms;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="EconomicTermsExtraordinaryEvents")
@ImplementedBy(value=Default.class)
public interface EconomicTermsExtraordinaryEvents
extends Validator<EconomicTerms> {
    public static final String NAME = "EconomicTermsExtraordinaryEvents";
    public static final String DEFINITION = "if extraordinaryEvents exists then payout -> performancePayout -> returnTerms -> priceReturnTerms exists or payout -> optionPayout -> underlier -> security exists";

    public ValidationResult<EconomicTerms> validate(RosettaPath var1, EconomicTerms var2);

    public static class NoOp
    implements EconomicTermsExtraordinaryEvents {
        @Override
        public ValidationResult<EconomicTerms> validate(RosettaPath path, EconomicTerms economicTerms) {
            return ValidationResult.success((String)EconomicTermsExtraordinaryEvents.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"EconomicTerms", (RosettaPath)path, (String)EconomicTermsExtraordinaryEvents.DEFINITION);
        }
    }

    public static class Default
    implements EconomicTermsExtraordinaryEvents {
        @Override
        public ValidationResult<EconomicTerms> validate(RosettaPath path, EconomicTerms economicTerms) {
            ComparisonResult result = this.executeDataRule(economicTerms);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)EconomicTermsExtraordinaryEvents.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"EconomicTerms", (RosettaPath)path, (String)EconomicTermsExtraordinaryEvents.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition EconomicTermsExtraordinaryEvents failed.";
            }
            return ValidationResult.failure((String)EconomicTermsExtraordinaryEvents.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"EconomicTerms", (RosettaPath)path, (String)EconomicTermsExtraordinaryEvents.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(EconomicTerms economicTerms) {
            try {
                ComparisonResult result = MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.exists((Mapper)MapperS.of((Object)economicTerms).map("getExtraordinaryEvents", _economicTerms -> _economicTerms.getExtraordinaryEvents())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.exists((Mapper)MapperS.of((Object)economicTerms).map("getPayout", _economicTerms -> _economicTerms.getPayout()).mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).map("getReturnTerms", performancePayout -> performancePayout.getReturnTerms()).map("getPriceReturnTerms", returnTerms -> returnTerms.getPriceReturnTerms())).or(ExpressionOperators.exists((Mapper)MapperS.of((Object)economicTerms).map("getPayout", _economicTerms -> _economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).map("getUnderlier", optionPayout -> optionPayout.getUnderlier()).map("getSecurity", product -> product.getSecurity())));
                    }
                    return MapperS.ofNull();
                }));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

