/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template.validation.datarule;

import cdm.product.template.EconomicTerms;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="EconomicTermsAssetPayoutDividendTermsValidation")
@ImplementedBy(value=Default.class)
public interface EconomicTermsAssetPayoutDividendTermsValidation
extends Validator<EconomicTerms> {
    public static final String NAME = "EconomicTermsAssetPayoutDividendTermsValidation";
    public static final String DEFINITION = "if payout -> assetPayout -> dividendTerms exists then terminationDate exists";

    public ValidationResult<EconomicTerms> validate(RosettaPath var1, EconomicTerms var2);

    public static class NoOp
    implements EconomicTermsAssetPayoutDividendTermsValidation {
        @Override
        public ValidationResult<EconomicTerms> validate(RosettaPath path, EconomicTerms economicTerms) {
            return ValidationResult.success((String)EconomicTermsAssetPayoutDividendTermsValidation.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"EconomicTerms", (RosettaPath)path, (String)EconomicTermsAssetPayoutDividendTermsValidation.DEFINITION);
        }
    }

    public static class Default
    implements EconomicTermsAssetPayoutDividendTermsValidation {
        @Override
        public ValidationResult<EconomicTerms> validate(RosettaPath path, EconomicTerms economicTerms) {
            ComparisonResult result = this.executeDataRule(economicTerms);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)EconomicTermsAssetPayoutDividendTermsValidation.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"EconomicTerms", (RosettaPath)path, (String)EconomicTermsAssetPayoutDividendTermsValidation.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition EconomicTermsAssetPayoutDividendTermsValidation failed.";
            }
            return ValidationResult.failure((String)EconomicTermsAssetPayoutDividendTermsValidation.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"EconomicTerms", (RosettaPath)path, (String)EconomicTermsAssetPayoutDividendTermsValidation.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(EconomicTerms economicTerms) {
            try {
                ComparisonResult result = MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.exists((Mapper)MapperS.of((Object)economicTerms).map("getPayout", _economicTerms -> _economicTerms.getPayout()).mapC("getAssetPayout", payout -> payout.getAssetPayout()).map("getDividendTerms", assetPayout -> assetPayout.getDividendTerms())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.exists((Mapper)MapperS.of((Object)economicTerms).map("getTerminationDate", _economicTerms -> _economicTerms.getTerminationDate()));
                    }
                    return MapperS.ofNull();
                }));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

