/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template.processor;

import cdm.product.common.settlement.PriceQuantity;
import cdm.product.common.settlement.processor.PriceQuantityHelper;
import cdm.product.template.processor.FraHelper;
import com.regnosys.rosetta.common.translation.Mapping;
import com.regnosys.rosetta.common.translation.MappingContext;
import com.regnosys.rosetta.common.translation.MappingProcessor;
import com.regnosys.rosetta.common.translation.MappingProcessorUtils;
import com.regnosys.rosetta.common.translation.Path;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.meta.Reference;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.util.CollectionUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class FraPriceQuantitySplitterMappingProcessor
extends MappingProcessor {
    public FraPriceQuantitySplitterMappingProcessor(RosettaPath path, List<Path> synonymPaths, MappingContext context) {
        super(path, synonymPaths, context);
    }

    public void map(Path synonymPath, List<? extends RosettaModelObjectBuilder> builder, RosettaModelObjectBuilder parent) {
        List priceQuantityList = CollectionUtils.emptyIfNull(builder);
        if (priceQuantityList.size() == 1) {
            PriceQuantity.PriceQuantityBuilder fixedLegPriceQuantity = (PriceQuantity.PriceQuantityBuilder)priceQuantityList.get(0);
            PriceQuantity.PriceQuantityBuilder floatingLegPriceQuantity = ((PriceQuantity.PriceQuantityBuilder)priceQuantityList.get(0)).build().toBuilder();
            priceQuantityList.add(floatingLegPriceQuantity);
            this.updateFixedLeg(fixedLegPriceQuantity);
            this.updateFloatingLeg(synonymPath, floatingLegPriceQuantity);
        }
    }

    private PriceQuantity.PriceQuantityBuilder updateFixedLeg(PriceQuantity.PriceQuantityBuilder fixedLegPriceQuantity) {
        return fixedLegPriceQuantity.setObservable(null);
    }

    private void updateFloatingLeg(Path synonymPath, PriceQuantity.PriceQuantityBuilder floatingLegPriceQuantity) {
        floatingLegPriceQuantity.getPrice().clear();
        this.getNonReferenceMapping(synonymPath.addElement("notional").addElement("amount")).ifPresent(this::updateFloatingLegQuantity);
        this.getNonReferenceMapping(synonymPath.addElement("floatingRateIndex")).ifPresent(this::updateRateOption);
    }

    private Optional<Mapping> getNonReferenceMapping(Path synonymPath) {
        return MappingProcessorUtils.filterMappings((List)this.getContext().getMappings(), (Path)synonymPath).stream().filter(m -> !(m.getRosettaValue() instanceof Reference.ReferenceBuilder)).filter(m -> Arrays.stream(m.getRosettaPath().getPathNames()).anyMatch("tradeLot"::equals)).filter(m -> m.getXmlValue() != null).findFirst();
    }

    private void updateFloatingLegQuantity(Mapping mapping) {
        Path newSynonymPath = FraHelper.getDummyFloatingLegPath(mapping.getXmlPath());
        Path rosettaPath = PriceQuantityHelper.incrementPathElementIndex(mapping.getRosettaPath(), "priceQuantity", 1);
        this.getMappings().add(new Mapping(newSynonymPath, mapping.getXmlValue(), rosettaPath, mapping.getRosettaValue(), null, false, true, false));
    }

    private void updateRateOption(Mapping mapping) {
        Path rosettaPath = PriceQuantityHelper.incrementPathElementIndex(mapping.getRosettaPath(), "priceQuantity", 1);
        mapping.setRosettaPath(rosettaPath);
    }
}

